/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.base.MutableLong;
import com.oracle.coherence.common.base.SingleWaiterCooperativeNotifier;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.collections.ConcurrentLinkedQueue;
import com.oracle.coherence.common.collections.NullableSortedMap;
import com.oracle.coherence.common.io.BufferManager;
import com.oracle.coherence.common.io.BufferManagers;
import com.oracle.coherence.common.io.BufferSequence;
import com.oracle.coherence.common.io.Buffers;
import com.oracle.coherence.common.net.exabus.EndPoint;
import com.oracle.coherence.common.net.exabus.MessageBus;
import com.oracle.coherence.common.util.Duration;
import com.tangosol.application.ContainerHelper;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.MessageHandler;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.RequestContext;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.message.responseMessage.SimpleResponse;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.queue.SingleConsumerQueue;
import com.tangosol.coherence.component.util.windowedArray.ConcurrentWindowedArray;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ServiceFailurePolicyBuilder;
import com.tangosol.config.expression.Parameter;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.grid.DefaultGridDependencies;
import com.tangosol.internal.net.service.grid.GridDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlGridHelper;
import com.tangosol.internal.tracing.Scope;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.SpanContext;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.internal.util.GridComponent;
import com.tangosol.internal.util.MessagePublisher;
import com.tangosol.internal.util.NullMessagePublisher;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.SizeEstimatingBufferOutput;
import com.tangosol.io.WrapperBufferInput;
import com.tangosol.io.WrapperBufferOutput;
import com.tangosol.io.WrapperDataInputStream;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.io.WriteBuffer;
import com.tangosol.license.LicenseException;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.Cluster;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.internal.ProtocolAwareStream;
import com.tangosol.net.management.NotificationManager;
import com.tangosol.net.management.Registry;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.net.security.PermissionInfo;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.InflatableSet;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LiteMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.ObservableHashMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntPredicate;
import javax.management.Notification;

public abstract class Grid
extends Service
implements GridComponent,
com.tangosol.net.Service {
    private boolean __m_AcceptingOthers;
    private ActionPolicy __m_ActionPolicy;
    private Long __m_BaseSUIDThisMember;
    private BufferManager __m_BufferManager;
    private transient Cluster __m_Cluster;
    private MasterMemberSet __m_ClusterMemberSet;
    private transient ConcurrentMap __m_CompletedRequestSUIDs;
    public static final int CONFIG_MAP_SERVICE = 1;
    private transient MemberSet __m_DepartingMembers;
    private volatile boolean __m_InWait;
    private Listeners __m_MemberListeners;
    public static final int MESSAGE_OFFSET = 32;
    private Class[] __m_MessageClass;
    private Map __m_MessageClassMap;
    private MessageHandler __m_MessageHandler;
    private volatile MessagePublisher __m_MessagePublisher;
    private transient AtomicLong __m_OldestPendingRequestSUIDCounter;
    private transient Collection __m_PendingQuiescenceResponses;
    private PollArray __m_PollArray;
    private Queue __m_QueueDeferred;
    private transient Queue __m_QueueDeferredWelcome;
    protected static final Random RANDOM;
    private long __m_RequestTimeout;
    private ResourceRegistry __m_ResourceRegistry;
    private ServiceConfig.Map __m_ServiceConfigMap;
    private ServiceFailurePolicy __m_ServiceFailurePolicy;
    private int __m_ServiceId;
    private Map __m_ServiceLeftActions;
    private ServiceMemberSet __m_ServiceMemberSet;
    private transient long __m_StatsPollCount;
    private transient long __m_StatsPollDuration;
    private transient long __m_StatsPollMaxDuration;
    private transient long __m_StatsSent;
    private transient long __m_StatsSentLocal;
    private volatile transient long __m_StatsTimeoutCount;
    public static final int SUID_REQUEST = 0;
    private transient AtomicLong[] __m_SUIDCounter;
    private AtomicLong __m_SuspendPollLimit;
    public static final long TIME_CLUSTER = -3L;
    public static final long TIME_SAFE = -2L;
    public static final long TIME_SYSTEM = -1L;
    private Object __m_UserContext;
    private List __m_WrapperStreamFactoryAllList;
    private List __m_WrapperStreamFactoryList;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Acknowledgement", Acknowledgement.get_CLASS());
        __mapChildren.put("BusEventMessage", BusEventMessage.get_CLASS());
        __mapChildren.put("ConfigRequest", ConfigRequest.get_CLASS());
        __mapChildren.put("ConfigResponse", ConfigResponse.get_CLASS());
        __mapChildren.put("ConfigSync", ConfigSync.get_CLASS());
        __mapChildren.put("ConfigUpdate", ConfigUpdate.get_CLASS());
        __mapChildren.put("DispatchEvent", DispatchEvent.get_CLASS());
        __mapChildren.put("DispatchNotification", DispatchNotification.get_CLASS());
        __mapChildren.put("MemberConfigUpdate", MemberConfigUpdate.get_CLASS());
        __mapChildren.put("MemberJoined", MemberJoined.get_CLASS());
        __mapChildren.put("MemberRecovered", MemberRecovered.get_CLASS());
        __mapChildren.put("MemberWelcome", MemberWelcome.get_CLASS());
        __mapChildren.put("MemberWelcomeRequest", MemberWelcomeRequest.get_CLASS());
        __mapChildren.put("MemberWelcomeRequestTask", MemberWelcomeRequestTask.get_CLASS());
        __mapChildren.put("NotifyConnectionClose", NotifyConnectionClose.get_CLASS());
        __mapChildren.put("NotifyConnectionOpen", NotifyConnectionOpen.get_CLASS());
        __mapChildren.put("NotifyMemberJoined", NotifyMemberJoined.get_CLASS());
        __mapChildren.put("NotifyMemberLeaving", NotifyMemberLeaving.get_CLASS());
        __mapChildren.put("NotifyMemberLeft", NotifyMemberLeft.get_CLASS());
        __mapChildren.put("NotifyMessageReceipt", NotifyMessageReceipt.get_CLASS());
        __mapChildren.put("NotifyPollClosed", NotifyPollClosed.get_CLASS());
        __mapChildren.put("NotifyResponse", NotifyResponse.get_CLASS());
        __mapChildren.put("NotifyServiceAnnounced", NotifyServiceAnnounced.get_CLASS());
        __mapChildren.put("NotifyServiceJoining", NotifyServiceJoining.get_CLASS());
        __mapChildren.put("NotifyServiceLeaving", NotifyServiceLeaving.get_CLASS());
        __mapChildren.put("NotifyServiceLeft", NotifyServiceLeft.get_CLASS());
        __mapChildren.put("NotifyServiceQuiescence", NotifyServiceQuiescence.get_CLASS());
        __mapChildren.put("NotifyShutdown", NotifyShutdown.get_CLASS());
        __mapChildren.put("NotifyStartup", NotifyStartup.get_CLASS());
        __mapChildren.put("PingRequest", PingRequest.get_CLASS());
        __mapChildren.put("ProtocolContext", ProtocolContext.get_CLASS());
        __mapChildren.put("Response", Response.get_CLASS());
        __mapChildren.put("WrapperGuardable", WrapperGuardable.get_CLASS());
    }

    public Grid(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_MemberListeners = new Listeners();
            this.__m_QueueDeferred = new Queue();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public String getServiceType() {
        return null;
    }

    public int getSUIDCounterLength() {
        return 1;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public void addMemberListener(MemberListener l) {
        this.ensureEventDispatcher();
        this.getMemberListeners().add(l);
    }

    public long adjustWaitTime(long cWaitMillis, long cAdjustMillis) {
        if (cWaitMillis < 0L) {
            return Long.MAX_VALUE;
        }
        if (cAdjustMillis < 0L) {
            if (cAdjustMillis == -3L) {
                cAdjustMillis = this.getClusterTime();
            } else if (cAdjustMillis == -2L) {
                cAdjustMillis = Base.getSafeTimeMillis();
            } else if (cAdjustMillis == -1L) {
                cAdjustMillis = System.currentTimeMillis();
            } else {
                throw new IllegalArgumentException("Invalid adjustment: " + cAdjustMillis);
            }
        }
        return (cWaitMillis += cAdjustMillis) < 0L ? Long.MAX_VALUE : cWaitMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateOldestSUID(LongArray array, int nMember) {
        long lSUID;
        long lBase = Grid.getBaseSUID(nMember);
        LongArray longArray = array;
        synchronized (longArray) {
            lSUID = array.ceilingIndex(lBase);
        }
        return lSUID == -1L || Grid.getMemberId(lSUID) != nMember ? -1L : lSUID;
    }

    public static long calculateOldestSUID(NavigableMap mapSUID, int nMember) {
        long lBaseMember = Grid.getBaseSUID(nMember);
        Long LSUID = mapSUID.ceilingKey(lBaseMember);
        return LSUID == null || Grid.getBaseSUID(LSUID) != lBaseMember ? -1L : LSUID;
    }

    public long calculateRequestTimeout(RequestMessage msg) {
        long cTimeoutMillis = this.getRequestTimeout();
        if (msg instanceof PriorityTask) {
            cTimeoutMillis = Grid.adjustTimeout(cTimeoutMillis, ((PriorityTask)((Object)msg)).getRequestTimeoutMillis());
        }
        return cTimeoutMillis;
    }

    protected void checkShutdownPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new LocalPermission("Cluster.shutdown"));
        }
    }

    @Override
    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultGridDependencies((GridDependencies)deps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closePolls() {
        long lLast;
        this.getServiceConfigMap().clearPendingPolls();
        PollArray waPoll = this.getPollArray();
        waPoll.checkPolls();
        PollArray pollArray = waPoll;
        synchronized (pollArray) {
            long lFirst = waPoll.getFirstIndex();
            lLast = waPoll.getLastIndex();
        }
        for (long l = lFirst; l <= lLast; ++l) {
            Poll poll = (Poll)waPoll.get(l);
            if (poll == null) continue;
            poll.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePolls(Member member) {
        long lLast;
        PollArray waPoll;
        Grid._assert(Thread.currentThread() == this.getThread());
        PollArray pollArray = waPoll = this.getPollArray();
        synchronized (pollArray) {
            long lFirst = waPoll.getFirstIndex();
            lLast = waPoll.getLastIndex();
        }
        for (long l = lFirst; l <= lLast; ++l) {
            Poll poll = (Poll)waPoll.get(l);
            if (poll == null) continue;
            poll.onLeft(member);
        }
    }

    public String collectTransportStats(Member member) {
        EndPoint peer;
        MessageHandler handler = this.getMessageHandler();
        if (handler != null && (peer = this.getServiceMemberSet().getServiceEndPoint(member.getId())) != null) {
            return String.valueOf(handler.getConnectionMap().get(peer));
        }
        return member.toString(2);
    }

    public int compareImportance(Member memberThat) {
        return 0;
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlGridHelper.fromXml(xml, new DefaultGridDependencies(), this.getOperationalContext(), this.getContextClassLoader()));
        this.setServiceConfig(xml);
    }

    protected ResolvableParameterList createResolver() {
        ResolvableParameterList resolver = new ResolvableParameterList();
        resolver.add(new Parameter("class-loader", this.getContextClassLoader()));
        resolver.add(new Parameter("service-name", this.getServiceName()));
        Cluster cluster = this.getCluster();
        if (cluster != null) {
            resolver.add(new Parameter("cluster-name", cluster.getClusterName()));
        }
        return resolver;
    }

    public void deferUntilServiceLeft(Member member, Continuation continuation) {
        Map mapDeferred = this.getServiceLeftActions();
        LinkedList<Continuation> listActions = (LinkedList<Continuation>)mapDeferred.get(member);
        if (listActions == null) {
            listActions = new LinkedList<Continuation>();
            mapDeferred.put(member, listActions);
        }
        listActions.add(continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deserializeMessage(Message msg) {
        if (!this.validateMessage(msg)) {
            return false;
        }
        try {
            ReadBuffer.BufferInput input = msg.getReadBuffer().getBufferInput();
            input.readShort();
            input.readShort();
            boolean fWrapped = this.isProtocolFiltered();
            if (fWrapped) {
                input = this.wrapStream(input, msg);
            }
            if (!(input instanceof WrapperBufferInput.VersionAwareBufferInput)) {
                input = new WrapperBufferInput.VersionAwareBufferInput(input, this.getContextClassLoader(), msg);
            }
            msg.readInternal(input);
            msg.read(input);
            if (fWrapped) {
                input.close();
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            boolean bl = this.onMessageReadException(e, msg);
            return bl;
        }
        finally {
            msg.setDeserializationRequired(false);
            msg.releaseIncoming();
        }
    }

    public void dispatchMemberEvent(Member member, int nEvent) {
        Listeners listeners = this.getMemberListeners();
        if (!listeners.isEmpty()) {
            this.dispatchEvent(new MemberEvent(this, nEvent, member), listeners);
        }
    }

    @Override
    public void dispatchNotification(String sMBeanName, String sType, String sMsg, Object oData) {
        Registry registry = this.getCluster().getManagement();
        if (registry != null) {
            DispatchNotification notify = (DispatchNotification)this._newChild("DispatchNotification");
            notify.setMBeanName(sMBeanName);
            notify.setSource(this.getThisMember().toString());
            notify.setType(sType);
            notify.setMessage(sMsg);
            notify.setUserData(oData);
            this.ensureEventDispatcher().getQueue().add(notify);
        }
    }

    public void doPollClose(Poll poll) {
        if (!poll.isClosed()) {
            NotifyPollClosed msgNotify = (NotifyPollClosed)this.instantiateMessage("NotifyPollClosed");
            msgNotify.setNotifyPoll(poll);
            this.send(msgNotify);
        }
    }

    public void doPollClose(Poll poll, Throwable eReason) {
        if (!poll.isClosed()) {
            NotifyPollClosed msgNotify = (NotifyPollClosed)this.instantiateMessage("NotifyPollClosed");
            msgNotify.setException(eReason);
            msgNotify.setNotifyPoll(poll);
            this.send(msgNotify);
        }
    }

    public void doPollMemberLeft(Poll poll, Member member) {
        NotifyPollClosed msgNotify = (NotifyPollClosed)this.instantiateMessage("NotifyPollClosed");
        msgNotify.setNotifyPoll(poll);
        msgNotify.setNotifyMember(member);
        this.send(msgNotify);
    }

    public long drainOverflow(MemberSet setMembers, long cMillis) throws InterruptedException {
        EventDispatcher dispatcher = (EventDispatcher)this.getEventDispatcher();
        if (dispatcher != null) {
            cMillis = dispatcher.drainOverflow(cMillis);
        }
        return this.getMessagePublisher().drainOverflow(setMembers, cMillis);
    }

    public int estimateMessageSize(Message msg) throws IOException {
        int cbMsg = msg.getEstimatedByteSize();
        return cbMsg < 0 ? this.serializeMessage(msg, new SizeEstimatingBufferOutput()) : cbMsg;
    }

    public void flush() {
        MessagePublisher publisher;
        if (this.getThread() != Thread.currentThread()) {
            this.getQueue().flush();
        }
        if ((publisher = this.getMessagePublisher()) != null) {
            publisher.flush();
        }
        SingleWaiterCooperativeNotifier.flush();
    }

    public String formatStats(boolean fVerbose) {
        Object sStats = this.formatStats();
        if (fVerbose) {
            sStats = (String)sStats + " " + String.valueOf(this.getMessagePublisher());
        }
        return sStats;
    }

    public ActionPolicy getActionPolicy() {
        return this.__m_ActionPolicy;
    }

    public static long getBaseSUID(int nMember) {
        return (long)nMember << 48;
    }

    public static long getBaseSUID(long lSUID) {
        return lSUID & 0xFFFF000000000000L;
    }

    public Long getBaseSUIDThisMember() {
        return this.__m_BaseSUIDThisMember;
    }

    public BufferManager getBufferManager() {
        return this.__m_BufferManager;
    }

    @Override
    public Cluster getCluster() {
        return this.__m_Cluster;
    }

    public MasterMemberSet getClusterMemberSet() {
        return this.__m_ClusterMemberSet;
    }

    public Member getClusterOldestMember() {
        return this.getClusterMemberSet().getOldestMember();
    }

    public ClusterService getClusterService() {
        return ((com.tangosol.coherence.component.net.Cluster)this.getCluster()).getClusterService();
    }

    public long getClusterTime() {
        return this.getCluster().getTimeMillis();
    }

    public int getClusterTimeVariance() {
        return this.getClusterService().getTimestampMaxVariance();
    }

    public ConcurrentMap getCompletedRequestSUIDs() {
        return this.__m_CompletedRequestSUIDs;
    }

    public ServiceConfig.Map getConfigMap(int nMapType) {
        if (nMapType == 1) {
            return this.getServiceConfigMap();
        }
        throw new IllegalArgumentException();
    }

    public MemberSet getConfigMapUpdateMembers(ServiceConfig.Map map) {
        return this.getOthersMemberSet();
    }

    protected long getDelay(String sOperation) {
        int cMillis = Config.getInteger("coherence.service." + this.getServiceName() + "." + sOperation + ".delay", Config.getInteger("coherence.service." + sOperation + ".delay", 0));
        if ((long)cMillis < 0L) {
            cMillis = RANDOM.nextInt(-1 * cMillis);
        }
        return cMillis;
    }

    public MemberSet getDepartingMembers() {
        return this.__m_DepartingMembers;
    }

    @Override
    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("Id=").append(this.getServiceId());
        if (this.isRunning() && this.getServiceOldestMember() != null) {
            sb.append(", OldestMemberId=").append(this.getServiceOldestMember().getId());
        }
        return sb.toString();
    }

    public String getEndPointName() {
        MessageHandler handler = this.getMessageHandler();
        return handler == null ? "" : handler.getMessageBus().getLocalEndPoint().toString();
    }

    @Override
    public ServiceInfo getInfo() {
        return this.getCluster().getServiceInfo(this.getServiceName());
    }

    public static int getMemberId(long lSUID) {
        return (int)(lSUID >>> 48);
    }

    public Listeners getMemberListeners() {
        return this.__m_MemberListeners;
    }

    protected MemberSet getMemberSet(int nState) {
        return this.getMemberSet(this.getServiceMemberSet(), nState);
    }

    protected MemberSet getMemberSet(ServiceMemberSet setMembers, int nState) {
        MemberSet setResult = new MemberSet();
        for (Member member : setMembers) {
            if (setMembers.getState(member.getId()) != nState) continue;
            setResult.add(member);
        }
        return setResult;
    }

    private Class[] getMessageClass() {
        return this.__m_MessageClass;
    }

    public Class getMessageClass(int i) {
        Class[] aClass = this.getMessageClass();
        return aClass != null && i < aClass.length ? aClass[i += 32] : null;
    }

    public Class getMessageClass(String sMsgName) {
        return (Class)this.getMessageClassMap().get(sMsgName);
    }

    public Map getMessageClassMap() {
        return this.__m_MessageClassMap;
    }

    public MessageHandler getMessageHandler() {
        return this.__m_MessageHandler;
    }

    public MessagePublisher getMessagePublisher() {
        return this.__m_MessagePublisher;
    }

    public long getOldestPendingRequestSUID() {
        return this.getOldestPendingRequestSUIDCounter().get();
    }

    public AtomicLong getOldestPendingRequestSUIDCounter() {
        return this.__m_OldestPendingRequestSUIDCounter;
    }

    public MemberSet getOthersMemberSet() {
        return this.getOthersMemberSet(0);
    }

    public MemberSet getOthersMemberSet(int nState) {
        ServiceMemberSet setAll = this.getServiceMemberSet();
        MemberSet setOthers = new MemberSet();
        setOthers.addAll((Collection)setAll);
        setOthers.remove(this.getThisMember());
        if (nState > 0) {
            for (Member member : setAll) {
                if (setAll.getState(member.getId()) >= nState) continue;
                setOthers.remove(member);
            }
        }
        return setOthers;
    }

    public List getOutstandingPolls(long cAgeMillis) {
        long lLast;
        PollArray waPoll = this.getPollArray();
        long lFirst = waPoll.getFirstIndex();
        if (lFirst > (lLast = waPoll.getLastIndex())) {
            return Collections.emptyList();
        }
        if (cAgeMillis <= 0L) {
            cAgeMillis = Math.max(this.getDefaultGuardTimeout(), this.getStartupTimeout()) >>> 1;
        }
        LinkedList<Poll> listPolls = new LinkedList<Poll>();
        long ldtCutoff = Base.getSafeTimeMillis() - cAgeMillis;
        for (long l = lFirst; l <= lLast; ++l) {
            Poll poll = (Poll)waPoll.get(l);
            if (poll == null || poll.isClosed()) continue;
            if (poll.getInitTimeMillis() >= ldtCutoff) {
                return listPolls;
            }
            listPolls.add(poll);
        }
        return listPolls;
    }

    public Collection getPendingQuiescenceResponses() {
        return this.__m_PendingQuiescenceResponses;
    }

    public PollArray getPollArray() {
        return this.__m_PollArray;
    }

    public ProtocolAwareStream.ProtocolContext getProtocolContext(Message msg) {
        ProtocolContext context = new ProtocolContext();
        context.setMessage(msg);
        return context;
    }

    private Queue getQueueDeferred() {
        return this.__m_QueueDeferred;
    }

    public Queue getQueueDeferredWelcome() {
        return this.__m_QueueDeferredWelcome;
    }

    public long getRequestTimeout() {
        return this.__m_RequestTimeout;
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        return this.__m_ResourceRegistry;
    }

    public ServiceConfig.Map getServiceConfigMap() {
        ServiceConfig.Map map = this.__m_ServiceConfigMap;
        if (map == null) {
            map = (ServiceConfig.Map)((ServiceConfig)this._findChild("ServiceConfig")).getMap();
            this.setServiceConfigMap(map);
        }
        return map;
    }

    public ServiceFailurePolicy getServiceFailurePolicy() {
        return this.__m_ServiceFailurePolicy;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public Map getServiceLeftActions() {
        return this.__m_ServiceLeftActions;
    }

    public ServiceMemberSet getServiceMemberSet() {
        return this.__m_ServiceMemberSet;
    }

    public Member getServiceOldestMember() {
        ServiceMemberSet setMember = this.getServiceMemberSet();
        return setMember == null ? null : setMember.getOldestMember();
    }

    public String getServiceVersion() {
        return "";
    }

    @Override
    public long getStartupTimeout() {
        long cMillis = super.getStartupTimeout();
        if (cMillis <= 0L) {
            cMillis = Config.getLong("coherence.service." + this.getServiceName() + ".startup.timeout", Config.getLong("coherence.service.startup.timeout", Config.getLong("coherence.service.startuptimeout", 0L)));
            if (cMillis <= 0L) {
                cMillis = this.getClusterService().getDeliveryTimeoutMillis();
            }
            this.setStartupTimeout(cMillis);
        }
        return cMillis;
    }

    public long getStatsPollCount() {
        return this.__m_StatsPollCount;
    }

    public long getStatsPollDuration() {
        return this.__m_StatsPollDuration;
    }

    public long getStatsPollMaxDuration() {
        return this.__m_StatsPollMaxDuration;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public long getStatsSentLocal() {
        return this.__m_StatsSentLocal;
    }

    public long getStatsTimeoutCount() {
        return this.__m_StatsTimeoutCount;
    }

    public long getSUID(int nDomain) {
        return this.getSUIDCounter(nDomain).incrementAndGet();
    }

    protected AtomicLong[] getSUIDCounter() {
        return this.__m_SUIDCounter;
    }

    protected AtomicLong getSUIDCounter(int i) {
        return this.getSUIDCounter()[i];
    }

    public long getSUIDRange(int nDomain, int nWidth) {
        Grid._assert(nWidth > 0);
        return this.getSUIDCounter(nDomain).getAndAdd(nWidth) + 1L;
    }

    public AtomicLong getSuspendPollLimit() {
        return this.__m_SuspendPollLimit;
    }

    public Member getThisMember() {
        MasterMemberSet setMembers = this.getClusterMemberSet();
        return setMembers == null ? null : setMembers.getThisMember();
    }

    public ObservableMap getThisMemberConfigMap() {
        Member memberThis = this.getThisMember();
        if (memberThis == null) {
            return null;
        }
        ServiceMemberSet setMemberService = this.getServiceMemberSet();
        return setMemberService == null ? this.getClusterService().getServiceInfo(this.getServiceId()).getMemberSet().ensureMemberConfigMap(memberThis.getId()) : setMemberService.ensureMemberConfigMap(memberThis.getId());
    }

    @Override
    public String getThreadName() {
        String sServiceType = this.getServiceType();
        String sServiceName = this.getServiceName();
        return sServiceName.equals(sServiceType) ? sServiceName : sServiceType + ":" + sServiceName;
    }

    @Override
    public Object getUserContext() {
        return this.__m_UserContext;
    }

    @Override
    public long getWaitMillis() {
        long cWait = super.getWaitMillis();
        if (this.isGuardian()) {
            long ldtNow = Base.getLastSafeTimeMillis();
            long cGuardMillis = Math.max(1L, this.getGuardSupport().getNextCheckTime() - ldtNow);
            cWait = cWait == 0L ? cGuardMillis : Math.min(cWait, cGuardMillis);
        } else if (this.isGuarded()) {
            cWait = cWait == 0L ? 1000L : Math.min(cWait, 1000L);
        }
        return cWait == 0L ? 1000L : cWait;
    }

    public List getWrapperStreamFactoryAllList() {
        return this.__m_WrapperStreamFactoryAllList;
    }

    public List getWrapperStreamFactoryList() {
        return this.__m_WrapperStreamFactoryList;
    }

    @Override
    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        if (guardable instanceof Guard) {
            Grid service = (Grid)((Guard)guardable).get_Parent();
            guardable = service.instantiateWrapperGuardable(guardable);
        } else {
            guardable = this.instantiateWrapperGuardable(guardable);
        }
        return super.guard(guardable, cMillis, flPctRecover);
    }

    protected void initializeSUID() {
        int nMember = this.getThisMember().getId();
        long lMillis = this.getClusterTime();
        long lFirst = (long)nMember << 48 | lMillis & 0xFFFFFFFFFFFFL;
        AtomicLong[] aCounter = new AtomicLong[this.getSUIDCounterLength()];
        int c = aCounter.length;
        for (int i = 0; i < c; ++i) {
            AtomicLong counter;
            aCounter[i] = counter = new AtomicLong(lFirst);
        }
        this.setSUIDCounter(aCounter);
        this.setBaseSUIDThisMember(lFirst);
        this.setOldestPendingRequestSUIDCounter(new AtomicLong(lFirst + 1L));
    }

    public void initializeTransport() {
        com.tangosol.coherence.component.net.Cluster cluster = (com.tangosol.coherence.component.net.Cluster)this.getCluster();
        String sTransport = ((GridDependencies)this.getDependencies()).getReliableTransport();
        if ("datagram".equals(sTransport)) {
            this.setMessagePublisher(cluster.getPublisher());
        } else {
            MessageHandler handler = this.getMessageHandler();
            MessageBus bus = cluster.createMessageBus(this.getServiceType(), sTransport);
            if (handler != null) {
                Grid._trace("Service " + this.getServiceName() + " unbound from " + String.valueOf(handler.getMessageBus().getLocalEndPoint()), 3);
                this.setMessageHandler(null);
                handler.close();
            }
            if (bus == null) {
                this.setMessagePublisher(cluster.getMessagePublisher());
            } else {
                handler = this.instantiateMessageHandler();
                handler.initialize(this, bus, cluster.getMessagePublisher());
                this.setMessagePublisher(handler);
                this.setMessageHandler(handler);
                this.setDepartingMembers(new MemberSet());
                Grid._trace("Service " + this.getServiceName() + " is bound to " + String.valueOf(bus.getLocalEndPoint()), 5);
            }
        }
    }

    protected XmlElement initServiceConfig() {
        return new SimpleElement("config");
    }

    public Message instantiateMessage(int nMsgType) {
        Class clz = this.getMessageClass(nMsgType);
        if (clz == null) {
            throw new RuntimeException("Service " + this.getServiceName() + " was unable to instantiate MessageType=" + nMsgType);
        }
        try {
            Message msg = (Message)clz.newInstance();
            msg.setService(this);
            return msg;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public Message instantiateMessage(String sMsgName) {
        Class clz = this.getMessageClass(sMsgName);
        if (clz == null) {
            throw new IllegalArgumentException("Unable to instantiate Message \"" + sMsgName + "\"");
        }
        try {
            Message msg = (Message)clz.newInstance();
            msg.setService(this);
            return msg;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected MessageHandler instantiateMessageHandler() {
        return new MessageHandler();
    }

    @Override
    protected Queue instantiateQueue() {
        return (ReceiveQueue)this._findChild("ReceiveQueue");
    }

    public RequestContext instantiateRequestContext() {
        return new RequestContext();
    }

    public WrapperGuardable instantiateWrapperGuardable(Guardable guardable) {
        WrapperGuardable wrapper = (WrapperGuardable)this._newChild("WrapperGuardable");
        wrapper.setGuardable(guardable);
        return wrapper;
    }

    public boolean isAcceptingOthers() {
        return this.__m_AcceptingOthers;
    }

    public boolean isClusterThread(boolean fStrict) {
        Thread threadService = this.getThread();
        if (threadService == null) {
            return false;
        }
        ThreadGroup groupCluster = threadService.getThreadGroup();
        ThreadGroup groupThis = Thread.currentThread().getThreadGroup();
        return fStrict ? groupCluster == groupThis : groupCluster.parentOf(groupThis);
    }

    public boolean isCoherenceThread() {
        return GuardSupport.getThreadContext() != null;
    }

    public boolean isCompatibleServiceType(String sType) {
        return this.getServiceType().equals(sType);
    }

    public boolean isInWait() {
        return this.__m_InWait;
    }

    public boolean isProtocolFiltered() {
        return this.getWrapperStreamFactoryAllList() != null || this.getWrapperStreamFactoryList() != null;
    }

    @Override
    public boolean isSuspended() {
        return this.getSuspendPollLimit().get() != Long.MAX_VALUE;
    }

    public boolean isSuspendedFully() {
        long lLast = this.getSuspendPollLimit().get();
        if (lLast < Long.MAX_VALUE) {
            PollArray aPoll = this.getPollArray();
            for (long lNext = aPoll.getFirstIndex(); lNext <= lLast; ++lNext) {
                RequestMessage msg;
                Poll poll = (Poll)aPoll.get(lNext);
                if (poll == null || (msg = (RequestMessage)poll.get_Parent()) == null || !msg.isSuspendable()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isVersionCompatible(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        int nEncoded = ServiceMemberSet.encodeVersion(nMajor, nMinor, nMicro, nPatchSet, nPatch);
        return this.isVersionCompatible(nEncoded);
    }

    @Override
    public boolean isVersionCompatible(int nYear, int nMonth, int nPatch) {
        int nEncoded = ServiceMemberSet.encodeVersion(nYear, nMonth, nPatch);
        return this.isVersionCompatible(nEncoded);
    }

    @Override
    public boolean isVersionCompatible(int nVersion) {
        MasterMemberSet memberSet = this.getClusterMemberSet();
        return memberSet != null && memberSet.isVersionCompatible(nVersion);
    }

    @Override
    public boolean isVersionCompatible(IntPredicate predicate) {
        MasterMemberSet memberSet = this.getClusterMemberSet();
        return memberSet != null && memberSet.isVersionCompatible(predicate);
    }

    @Override
    public int getMinimumServiceVersion() {
        MasterMemberSet memberSet = this.getClusterMemberSet();
        return memberSet == null ? 0 : memberSet.getMinimumVersion();
    }

    public boolean isVersionCompatible(Member member, int nVersion) {
        return this.getClusterMemberSet().getServiceVersionInt(member.getId()) >= nVersion;
    }

    public boolean isVersionCompatible(Member member, int nYear, int nMonth, int nPatch) {
        return this.isVersionCompatible(member, ServiceMemberSet.encodeVersion(nYear, nMonth, nPatch));
    }

    public boolean isVersionCompatible(Member member, int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        return this.isVersionCompatible(member, ServiceMemberSet.encodeVersion(nMajor, nMinor, nMicro, nPatchSet, nPatch));
    }

    public boolean isVersionCompatible(MemberSet setMembers, int nVersion) {
        MasterMemberSet setMaster = this.getClusterMemberSet();
        switch (setMembers.size()) {
            case 0: {
                return true;
            }
            case 1: {
                return setMaster.getServiceVersionInt(setMembers.getFirstId()) >= nVersion;
            }
        }
        int[] anMember = setMembers.toIdArray();
        int c = anMember.length;
        for (int i = 0; i < c; ++i) {
            if (setMaster.getServiceVersionInt(anMember[i]) >= nVersion) continue;
            return false;
        }
        return true;
    }

    public boolean isVersionCompatible(MemberSet setMembers, int nYear, int nMonth, int nPatch) {
        return this.isVersionCompatible(setMembers, MasterMemberSet.encodeVersion(nYear, nMonth, nPatch));
    }

    public boolean isVersionCompatible(MemberSet setMembers, int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        return this.isVersionCompatible(setMembers, MasterMemberSet.encodeVersion(nMajor, nMinor, nMicro, nPatchSet, nPatch));
    }

    public boolean isPatchCompatible(Member member, int nEncodedVersion) {
        return this.getClusterMemberSet().isPatchCompatible(member.getId(), nEncodedVersion);
    }

    public boolean isPatchCompatible(MemberSet setMembers, int nEncodedVersion) {
        if (setMembers.isEmpty()) {
            return true;
        }
        MasterMemberSet setMaster = this.getClusterMemberSet();
        int[] anId = setMembers.toIdArray();
        for (int i = 0; i < anId.length; ++i) {
            if (anId[i] == 0 || setMaster.isPatchCompatible(anId[i], nEncodedVersion)) continue;
            return false;
        }
        return true;
    }

    public boolean isWelcomedBy(Member member) {
        return this.getServiceMemberSet().isMemberConfigured(member.getId());
    }

    protected void notifyServiceJoined() {
        ClusterService clusterService = this.getClusterService();
        if (clusterService != this) {
            int nIdThis = this.getThisMember().getId();
            this.getServiceMemberSet().setServiceJoined(nIdThis);
            MemberJoined msg = (MemberJoined)this.instantiateMessage("MemberJoined");
            msg.setMemberId(nIdThis);
            msg.setToMemberSet(this.getOthersMemberSet());
            this.send(msg);
            clusterService.doServiceJoined(this);
        }
    }

    public void onConfigIOException(IOException e, Member member) {
        StringBuffer sb = new StringBuffer();
        if (this.getServiceId() == 0) {
            sb.append("Failed to deserialize the config Message received from member ").append(member.getId()).append(". This member is configured with the following serializer: ").append(this.getSerializer()).append(", which may be incompatible with the serializer configured by the sender.");
        } else {
            sb.append("The service \"" + this.getServiceName() + "\"");
            String sSerializerThat = (String)this.getServiceMemberSet().getMemberConfigMap(member.getId()).get("Serializer");
            sb.append(" is configured to use serializer ").append(this.getSerializer()).append(", which appears to be different from ").append(sSerializerThat == null ? "the serializer" : (sSerializerThat.length() == 0 ? "default serializer" : sSerializerThat)).append(" used by ").append(member).append('.');
        }
        if (member == this.getServiceOldestMember()) {
            sb.append('\n').append(Grid.getStackTrace(e)).append("Stopping the ").append(this.getServiceName()).append(" service.");
            Grid._trace(sb.toString(), 1);
            this.stop();
        } else {
            Grid._trace(sb.toString(), 3);
        }
    }

    @Override
    protected void onDependencies(ServiceDependencies deps) {
        List<ParameterizedBuilder<MemberListener>> listBuilder;
        ServiceFailurePolicyBuilder builder;
        super.onDependencies(deps);
        GridDependencies depsGrid = (GridDependencies)deps;
        ActionPolicy policyAction = (ActionPolicy)depsGrid.getActionPolicyBuilder().realize(this.createResolver(), this.getContextClassLoader(), null);
        this.setActionPolicy(policyAction);
        this.setRequestTimeout(depsGrid.getRequestTimeoutMillis());
        long cTimeoutMillis = depsGrid.getDefaultGuardTimeoutMillis();
        if (cTimeoutMillis > 0L) {
            cTimeoutMillis = Math.max(cTimeoutMillis, 5000L);
            this.setDefaultGuardTimeout(cTimeoutMillis);
        }
        if ((builder = depsGrid.getServiceFailurePolicyBuilder()) != null) {
            this.setServiceFailurePolicy(builder.realize(this.createResolver(), this.getContextClassLoader(), null));
        }
        if ((listBuilder = depsGrid.getMemberListenerBuilders()) != null) {
            for (ParameterizedBuilder<MemberListener> bldr : listBuilder) {
                this.addMemberListener(bldr.realize(this.createResolver(), this.getContextClassLoader(), null));
            }
        }
    }

    @Override
    protected void onEnter() {
        this.setStartTimestamp(Base.getSafeTimeMillis());
        this.resetStats();
        ContainerHelper.initializeThreadContext(this);
        this.initializeTransport();
        if (this.getServiceId() > 0) {
            this.initializeSUID();
            this.setQueueDeferredWelcome(new Queue());
            this.setServiceLeftActions(new HashMap());
            this.getThisMemberConfigMap().put("Serializer", this.ensureSerializer().getClass().getName());
        }
        this.getActionPolicy().init(this);
        this.setServiceState(1);
        this.post(this.instantiateMessage("NotifyStartup"));
    }

    @Override
    public void onException(Throwable e) {
        TracingHelper.augmentSpanWithErrorDetails(TracingHelper.getActiveSpan(), true, e);
        super.onException(e);
    }

    @Override
    protected void onExit() {
        Message msg;
        super.onExit();
        MessageHandler handler = this.getMessageHandler();
        if (handler != null) {
            handler.close();
        }
        Queue queue = this.getQueue();
        while ((msg = (Message)queue.removeNoWait()) != null) {
            if (!msg.isDeserializationRequired()) continue;
            msg.releaseIncoming();
        }
    }

    @Override
    public void onInit() {
        super.onInit();
        this.setCompletedRequestSUIDs(new ConcurrentHashMap(16, 0.75f, Runtime.getRuntime().availableProcessors() * 3));
        Map map = this.get_ChildClasses();
        Class<Message> clzMessage = Message.class;
        for (Map.Entry entry : map.entrySet()) {
            String sMsgName = (String)entry.getKey();
            Class clz = (Class)entry.getValue();
            if (!clzMessage.isAssignableFrom(clz)) continue;
            this.registerMessageType(sMsgName, clz);
        }
        PollArray waPoll = (PollArray)this._findChild("PollArray");
        this.setPollArray(waPoll);
        waPoll.remove(waPoll.add(new Poll()));
        this.getSuspendPollLimit().set(Long.MAX_VALUE);
    }

    @Override
    protected void onInterval() {
        MessageHandler handler;
        this.getPollArray().checkPolls();
        Collection colQuiescenceResp = this.getPendingQuiescenceResponses();
        if (colQuiescenceResp != null && this.isSuspendedFully()) {
            for (NotifyResponse msgResp : colQuiescenceResp) {
                this.post(msgResp);
            }
            this.setPendingQuiescenceResponses(null);
        }
        if ((handler = this.getMessageHandler()) != null) {
            handler.onInterval();
        }
        super.onInterval();
    }

    public void onMessage(Message msg) {
        if (msg != null) {
            try {
                Poll poll;
                if (!this.validateMessage(msg)) {
                    return;
                }
                Member memberFrom = msg.getFromMember();
                if (memberFrom != null) {
                    MemberSet.readBarrier(memberFrom.getId());
                }
                this.setStatsReceived(this.getStatsReceived() + 1L);
                boolean fTracing = msg instanceof RequestMessage && TracingHelper.isEnabled();
                Span span = null;
                Scope scope = null;
                if (fTracing) {
                    SpanContext ctx = msg.getTracingSpanContext();
                    Span.Builder builder = this.newTracingSpan(msg instanceof Runnable ? "dispatch" : "process", msg).withMetadata("member.source", memberFrom == null ? -1L : (long)memberFrom.getId());
                    if (!TracingHelper.isNoop(ctx)) {
                        builder.setParent(ctx);
                    }
                    span = builder.startSpan();
                    scope = TracingHelper.getTracer().withSpan(span);
                }
                try {
                    msg.onReceived();
                }
                catch (EventDeathException e) {
                    if (msg instanceof RequestMessage) {
                        String sMsg = "Processing for RequestMessage has been interrupted:\n" + String.valueOf(msg);
                        if (fTracing) {
                            span.log(sMsg);
                        }
                        Grid._trace(sMsg, 2);
                        Grid._trace(Grid.getStackTrace(e), 4);
                    }
                }
                catch (Throwable t) {
                    if (fTracing) {
                        TracingHelper.augmentSpanWithErrorDetails(span, true, t);
                    }
                    throw t;
                }
                finally {
                    if (fTracing) {
                        scope.close();
                        span.end();
                    }
                }
                if ((poll = msg.getPoll()) != null) {
                    poll.onResponse(msg);
                }
            }
            catch (Throwable e) {
                this.onException(e);
            }
        }
    }

    protected boolean onMessageReadException(Throwable e, Message msg) {
        if (e instanceof SecurityException) {
            Grid._trace("SecurityException received while reading " + String.valueOf(msg) + "\n" + Grid.getStackTrace(e), 1);
        } else {
            Grid._trace("An exception (" + e.getClass().getName() + "): '" + e.getMessage() + "', occurred reading Message " + msg.get_Name() + " Type=" + msg.getMessageType() + " for Service=" + String.valueOf(this) + " from " + String.valueOf(msg.getFromMember()) + " with read buffer=" + Buffers.toString(msg.getReadBuffer().toByteBuffer(), 0x100000), 1);
            this.onException(e);
        }
        return false;
    }

    public void onMessageReceipt(Message msg) {
        if (!(msg == null || ((ReceiveQueue)this.getQueue()).isPreprocessingEnabled() && msg.preprocessSentNotification())) {
            NotifyMessageReceipt msgRecpt = (NotifyMessageReceipt)this.instantiateMessage("NotifyMessageReceipt");
            msgRecpt.setNotifyMessage(msg);
            this.post(msgRecpt);
        }
    }

    @Override
    protected void onNotify() {
        long lStart = Base.getLastSafeTimeMillis();
        Queue queueDeferred = this.getQueueDeferred();
        Queue queueIn = this.getQueue();
        for (int i = 0; i < 512; ++i) {
            Message msg;
            Message message = msg = queueDeferred == null ? (Message)queueIn.removeNoWait() : this.processDeferredQueue();
            if (msg == null) break;
            if (msg.isDeserializationRequired() && !this.deserializeMessage(msg)) continue;
            this.onMessage(msg);
        }
        this.setStatsCpu(this.getStatsCpu() + (Base.getSafeTimeMillis() - lStart));
        super.onNotify();
    }

    public void onNotifyServiceJoined(Member member) {
        int nMember = member.getId();
        ServiceMemberSet setMember = this.getServiceMemberSet();
        Member memberOldest = setMember.getOldestMember();
        Grid._trace("Member " + nMember + " joined Service " + this.getServiceName() + " with senior member " + (memberOldest == null ? "n/a" : String.valueOf(memberOldest.getId())), 3);
        setMember.setServiceJoined(nMember);
        this.dispatchMemberEvent(member, 1);
    }

    public void onNotifyServiceLeft(Member member) {
        int nMember = member.getId();
        ServiceMemberSet setMember = this.getServiceMemberSet();
        boolean fJoining = setMember.isServiceJoining(nMember);
        Member memberOldest = this.getServiceOldestMember();
        Grid._trace("Member " + member.getId() + (setMember.getState(nMember) == 1 ? " aborted joining" : " left") + " service " + this.getServiceName() + " with senior member " + (memberOldest == null ? "n/a" : String.valueOf(memberOldest.getId())), 3);
        boolean fOldest = member == memberOldest;
        setMember.remove(member);
        this.closePolls(member);
        this.getServiceConfigMap().onServiceLeft(member, fOldest);
        if (!fJoining) {
            this.dispatchMemberEvent(member, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotifyServiceQuiescence(boolean fResume, boolean fResumeOnFailover) {
        AtomicLong atlSuspend = this.getSuspendPollLimit();
        if (fResume ^ this.isSuspended()) {
            return;
        }
        if (fResume) {
            AtomicLong atomicLong = atlSuspend;
            synchronized (atomicLong) {
                atlSuspend.set(Long.MAX_VALUE);
                atlSuspend.notifyAll();
            }
        } else {
            atlSuspend.set(this.getPollArray().getLastIndex());
        }
        Grid._trace("Service " + this.getServiceName() + " has been " + (fResume ? "resumed" : "suspended"), 5);
    }

    public void onPollClosed(Poll poll) {
        this.unregisterPoll(poll);
    }

    @Override
    public void onServiceStarted() {
        if (this.validateServiceConfig()) {
            this.getServiceConfigMap().getConfig().attachConfigListener();
            this.notifyServiceJoined();
            this.setAcceptingOthers(true);
            this.setAcceptingClients(true);
        } else {
            this.post(this.instantiateMessage("NotifyShutdown"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onServiceState(int nState) {
        ClusterService clusterservice = this.getClusterService();
        switch (nState) {
            case 1: {
                this.onServiceStarting();
                break;
            }
            case 2: {
                if (this == clusterservice) {
                    this.onServiceStarted();
                    break;
                }
                if (clusterservice.getServiceMemberSet().size() > 1) {
                    if (clusterservice.getServiceOldestMember() == this.getThisMember()) {
                        Grid.sleep(1000L);
                    } else {
                        Iterator iterCaches = Arrays.stream(clusterservice.getServiceInfo()).iterator();
                        while (iterCaches.hasNext()) {
                            ServiceInfo info = (ServiceInfo)iterCaches.next();
                            if (info.getOldestMember() != this.getThisMember()) continue;
                            Grid.sleep(1000L);
                            break;
                        }
                    }
                }
                clusterservice.doServiceJoining(this);
                Member memberSenior = this.getServiceOldestMember();
                Grid._trace("Service " + this.getServiceName() + " joined the cluster with senior service member " + memberSenior.getId(), 3);
                this.getThisMemberConfigMap().addMapListener((MemberConfigListener)this._findChild("MemberConfigListener"));
                MessageHandler handler = this.getMessageHandler();
                if (handler != null) {
                    handler.connectAll();
                }
                if (this.getThisMember() == memberSenior) {
                    this.onServiceStarted();
                    break;
                }
                long cDelayMillis = this.getDelay("join");
                Grid._trace("Starting service " + this.getServiceName() + (String)(cDelayMillis > 0L ? " in " + cDelayMillis + " ms" : " immediately"), 6);
                Runnable task = (Runnable)((Object)this._newChild("MemberWelcomeRequestTask"));
                if (cDelayMillis > 0L) {
                    Grid service = (Grid)this.get_Module();
                    com.tangosol.coherence.component.util.DaemonPool pool = service.getDaemonPool();
                    if (pool.isStarted()) {
                        pool.schedule(task, cDelayMillis);
                        break;
                    }
                    ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
                    scheduler.schedule(task, cDelayMillis, TimeUnit.MILLISECONDS);
                    scheduler.shutdown();
                    break;
                }
                task.run();
                break;
            }
            case 3: {
                this.getServiceMemberSet().setServiceLeaving(this.getThisMember().getId());
                this.onServiceStopping();
                clusterservice.doServiceLeaving(this);
                break;
            }
            case 4: {
                try {
                    this.onServiceStopped();
                    this.closePolls();
                    break;
                }
                finally {
                    clusterservice.doServiceLeft(this);
                    Grid._trace("Service " + this.getServiceName() + " left the cluster", 3);
                }
            }
        }
    }

    @Override
    protected void onStartupTimeout() {
        throw new RequestTimeoutException("Timeout during service start: " + String.valueOf(this.getInfo()));
    }

    @Override
    protected void onWait() throws InterruptedException {
        this.flush();
        this.setInWait(true);
        try {
            super.onWait();
            this.setInWait(false);
        }
        catch (InterruptedException e) {
            this.setInWait(false);
            throw e;
        }
    }

    public void poll(RequestMessage[] aMsgs, long cMillisTimeout) {
        Grid._assert(this.getThread() != Thread.currentThread(), "this is a blocking operation and cannot be called on the Service thread");
        this.waitAcceptingClients();
        long ldtStart = cMillisTimeout == 0L ? 0L : Base.getSafeTimeMillis();
        long cMillisWait = cMillisTimeout;
        int cMsg = aMsgs.length;
        try {
            int i;
            Poll pollMax = null;
            long lPollIdMax = 0L;
            for (int i2 = 0; i2 < cMsg; ++i2) {
                Poll poll;
                long lPollId;
                RequestMessage msg = aMsgs[i2];
                if (!msg.isSuspendable() || (lPollId = (poll = msg.ensureRequestPoll()).getPollId()) <= lPollIdMax) continue;
                lPollIdMax = lPollId;
                pollMax = poll;
            }
            if (lPollIdMax != 0L && lPollIdMax > this.getSuspendPollLimit().get()) {
                cMillisWait = pollMax.waitServiceResume(ldtStart, cMillisWait);
            }
            long cbPending = 0L;
            int nLast = -1;
            for (i = 0; i < cMsg; ++i) {
                RequestMessage msg = aMsgs[i];
                if ((cbPending = this.post(msg, cbPending)) != -1L) continue;
                for (int j = nLast + 1; j <= i; ++j) {
                    cMillisWait = this.drainOverflow(aMsgs[j].getToMemberSet(), cMillisWait);
                }
                cbPending = 0L;
                nLast = i;
            }
            this.flush();
            for (i = nLast + 1; i < cMsg; ++i) {
                cMillisWait = this.drainOverflow(aMsgs[i].getToMemberSet(), cMillisWait);
            }
            for (i = cMsg - 1; i >= 0; --i) {
                aMsgs[i].getRequestPoll().waitCompletion(ldtStart, cMillisTimeout);
            }
            aMsgs = null;
        }
        catch (InterruptedException e) {
            if (this.isCoherenceThread()) {
                this.heartbeat();
                Thread.interrupted();
            } else {
                Thread.currentThread().interrupt();
            }
            throw this.processPollInterrupt(aMsgs, e);
        }
        finally {
            if (aMsgs != null) {
                for (int i = 0; i < cMsg; ++i) {
                    this.doPollClose(aMsgs[i].ensureRequestPoll());
                }
            }
        }
    }

    public void poll(Collection colMsgs, long cMillisTimeout) {
        if (colMsgs != null && !colMsgs.isEmpty()) {
            RequestMessage[] aMsgs = new RequestMessage[colMsgs.size()];
            int i = 0;
            Iterator it = colMsgs.iterator();
            while (it.hasNext()) {
                aMsgs[i++] = (RequestMessage)it.next();
            }
            this.poll(aMsgs, cMillisTimeout);
        }
    }

    public Object poll(RequestMessage msg) {
        return this.poll(msg, msg.checkTimeoutRemaining());
    }

    public Object poll(RequestMessage msg, long cMillisTimeout) {
        Grid._assert(this.getThread() != Thread.currentThread(), "this is a blocking operation and cannot be called on the Service thread");
        this.waitAcceptingClients();
        long ldtStart = cMillisTimeout == 0L ? 0L : Base.getSafeTimeMillis();
        long cMillisWait = cMillisTimeout;
        Poll poll = msg.ensureRequestPoll();
        try {
            if (msg.isSuspendable() && poll.getPollId() > this.getSuspendPollLimit().get()) {
                cMillisWait = poll.waitServiceResume(ldtStart, cMillisWait);
            }
            this.send(msg);
            this.drainOverflow(msg.getToMemberSet(), cMillisWait);
            Object object = poll.waitCompletion(ldtStart, cMillisTimeout);
            return object;
        }
        catch (InterruptedException e) {
            if (this.isCoherenceThread()) {
                this.heartbeat();
                Thread.interrupted();
            } else {
                Thread.currentThread().interrupt();
            }
            throw this.processPollInterrupt(new RequestMessage[]{msg}, e);
        }
        finally {
            this.doPollClose(poll);
        }
    }

    public void post(Message msg) {
        msg.setService(this);
        msg.post();
    }

    public long post(Message msg, long cbPending) {
        long cbMsg;
        this.post(msg);
        Disposable bufferController = msg.getBufferController();
        long l = bufferController instanceof BufferSequence ? ((BufferSequence)bufferController).getLength() : (cbMsg = bufferController instanceof WriteBuffer ? (long)((WriteBuffer)((Object)bufferController)).length() : 0L);
        if ((cbPending += cbMsg) > Math.max(0x10000000L, BufferManagers.getDirectManager().getCapacity() / (long)Runtime.getRuntime().availableProcessors())) {
            this.flush();
            cbPending = -1L;
        }
        return cbPending;
    }

    protected Message processDeferredQueue() {
        Queue queueDeferred = this.getQueueDeferred();
        Message msg = null;
        if (this.isAcceptingOthers()) {
            if (queueDeferred != null && (msg = (Message)queueDeferred.removeNoWait()) == null) {
                this.setQueueDeferred(null);
            }
        } else {
            msg = (Message)this.getQueue().removeNoWait();
            if (msg != null && !msg.isInternal()) {
                queueDeferred.add(msg);
                msg = null;
            }
        }
        return msg;
    }

    protected RuntimeException processPollInterrupt(RequestMessage[] aMsgs, InterruptedException e) {
        StringBuilder sbLog = new StringBuilder();
        TreeMap<Integer, String> mapMbrs = new TreeMap<Integer, String>();
        sbLog.append("This thread was interrupted while waiting for the results ").append("of a request:\n");
        int c = aMsgs.length;
        for (int i = 0; i < c; ++i) {
            Poll poll = aMsgs[i].ensureRequestPoll();
            if (poll.isClosed()) continue;
            sbLog.append(poll.toString());
            sbLog.append(',');
            int[] anMbr = poll.getRemainingMemberSet().toIdArray();
            for (int j = 0; j < anMbr.length; ++j) {
                int nMemberId = anMbr[j];
                Member member = this.getClusterMemberSet().getMember(nMemberId);
                mapMbrs.put(nMemberId, member == null ? String.valueOf(nMemberId) : member.toString());
            }
        }
        Grid._trace(sbLog.toString(), 2);
        return new WrapperException(e, "Request interrupted while waiting for response from " + String.valueOf(mapMbrs.values()));
    }

    public void processServiceLeftActions(Member member) {
        List listActions = (List)this.getServiceLeftActions().remove(member);
        if (listActions != null && !listActions.isEmpty()) {
            Iterator iter = listActions.iterator();
            while (iter.hasNext()) {
                ((Continuation)iter.next()).proceed(null);
            }
        }
    }

    protected void register() {
        ClusterService clusterservice = this.getClusterService();
        int nId = clusterservice.ensureService(this);
        Grid._assert(nId > 0);
        this.setServiceId(nId);
        this.setClusterMemberSet(clusterservice.getClusterMemberSet());
    }

    public void registerMessageType(String sMsgName, Class clz) {
        try {
            Message msg = (Message)clz.newInstance();
            int nType = msg.getMessageType();
            if (this.getMessageClass(nType) != null) {
                throw new IllegalStateException(String.valueOf(clz) + " - duplicate MessageType: " + nType + " " + String.valueOf(this.getMessageClass(nType)));
            }
            this.setMessageClass(nType, clz);
            this.getMessageClassMap().put(sMsgName, clz);
        }
        catch (Exception e) {
            Grid._trace("Service.registerMessageType: Unable to instantiate " + String.valueOf(clz), 1);
            Grid._trace(e);
        }
    }

    public RequestContext registerRequestContext(RequestContext ctx) {
        if (ctx == null) {
            ctx = this.instantiateRequestContext();
        }
        ctx.setRequestSUID(this.getSUID(0));
        ctx.setOldestPendingSUID(this.getOldestPendingRequestSUID());
        return ctx;
    }

    @Override
    public void removeMemberListener(MemberListener l) {
        this.getMemberListeners().remove(l);
    }

    public static List removeSUIDRange(LongArray array, int nMember, boolean fValues) {
        return Grid.removeSUIDRange(array, Grid.getBaseSUID(nMember), Grid.getBaseSUID(nMember + 1), fValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List removeSUIDRange(LongArray array, long lFrom, long lTo, boolean fValues) {
        LongArray longArray = array;
        synchronized (longArray) {
            if (fValues) {
                LinkedList listValues = new LinkedList();
                LongArray.Iterator iter = array.iterator(lFrom);
                while (iter.hasNext()) {
                    Object oValue = iter.next();
                    if (iter.getIndex() >= lTo) break;
                    iter.remove();
                    listValues.add(oValue);
                }
                return listValues;
            }
            array.remove(lFrom, lTo);
            return null;
        }
    }

    public static void removeSUIDRange(SortedMap mapSUID, int nMember) {
        Grid.removeSUIDRange(mapSUID, Grid.getBaseSUID(nMember), Grid.getBaseSUID(nMember + 1));
    }

    public static void removeSUIDRange(SortedMap mapSUID, long lFrom, long lTo) {
        mapSUID.subMap(lFrom, lTo).clear();
    }

    protected void reportTransportMismatch(Member member) {
        ServiceMemberSet setMember = this.getServiceMemberSet();
        Member memberThis = this.getThisMember();
        String sRoleThis = memberThis.getRoleName();
        String sRoleThat = member.getRoleName();
        Grid._trace(String.valueOf(member) + " is joining the service using \"" + ServiceMemberSet.formatEndPoint(setMember.getServiceEndPointName(member.getId())) + "\" transport while this member is configured to use \"" + ServiceMemberSet.formatEndPoint(setMember.getServiceEndPointName(memberThis.getId())) + "\"", Base.equals(sRoleThis, sRoleThat) ? 2 : 3);
    }

    public void reportTransportStats() {
        ServiceMemberSet setMember = this.getServiceMemberSet();
        for (Member member : setMember) {
            Grid._trace(this.collectTransportStats(member));
        }
    }

    @Override
    public void resetStats() {
        this.setStatsPollCount(0L);
        this.setStatsPollDuration(0L);
        this.setStatsPollMaxDuration(0L);
        this.setStatsTimeoutCount(0L);
        this.setStatsSent(0L);
        this.setStatsSentLocal(0L);
        MessageHandler handler = this.getMessageHandler();
        if (handler != null) {
            handler.resetStats();
        }
        super.resetStats();
    }

    public EndPoint resolveEndPoint(String sEndPoint, Member member, Map mapMemberConfig) {
        EndPoint peer = null;
        try {
            if (sEndPoint != null && sEndPoint.length() > 0) {
                peer = ((com.tangosol.coherence.component.net.Cluster)this.getCluster()).getSocketManager().getDepot().resolveEndPoint(sEndPoint);
            }
        }
        catch (IllegalArgumentException e) {
            Grid._trace("Failed to resolve the EndPoint name \"" + sEndPoint + "\" to communicate with service " + this.getServiceName() + " at " + String.valueOf(member) + "; falling back on the datagram transport", 1);
            return null;
        }
        if (this.getMessageHandler() != null && peer == null) {
            this.reportTransportMismatch(member);
        }
        return peer;
    }

    public void send(Message msg) {
        this.post(msg);
        this.flush();
    }

    public void sendPingRequest(Member member, Continuation continuation) {
        PingRequest msgPing = (PingRequest)this.instantiateMessage("PingRequest");
        msgPing.setContinuation(continuation);
        msgPing.setToMemberSet(SingleMemberSet.instantiate(member));
        this.post(msgPing);
    }

    public int serializeMessage(Message msg, WriteBuffer.BufferOutput output) throws IOException {
        output.writeShort(this.getServiceId());
        output.writeShort(msg.getMessageType());
        boolean fFiltered = this.isProtocolFiltered();
        if (fFiltered) {
            output = this.wrapStream(output, msg);
        }
        if (!(output instanceof WrapperBufferOutput.VersionAwareBufferOutput)) {
            output = new WrapperBufferOutput.VersionAwareBufferOutput(output, msg);
        }
        msg.writeInternal(output);
        msg.write(output);
        if (fFiltered) {
            output.close();
        }
        return output.getOffset();
    }

    @Override
    public void setAcceptingClients(boolean fAccepting) {
        ClusterService clusterService;
        boolean fWasAccepting = this.isAcceptingClients();
        if (!fWasAccepting && fAccepting) {
            this.dispatchMemberEvent(this.getThisMember(), 1);
        }
        super.setAcceptingClients(fAccepting);
        if (!fWasAccepting && fAccepting && (clusterService = this.getClusterService()) != this) {
            clusterService.guard(this.getGuardable(), this.getDefaultGuardTimeout(), this.getDefaultGuardRecovery());
            GuardSupport.setThreadContext(this.getGuardable().getContext());
        }
    }

    protected void setAcceptingOthers(boolean fAccepting) {
        this.__m_AcceptingOthers = fAccepting;
    }

    protected void setActionPolicy(ActionPolicy policy) {
        this.__m_ActionPolicy = policy;
    }

    public void setBaseSUIDThisMember(Long longMember) {
        this.__m_BaseSUIDThisMember = longMember;
    }

    public void setBufferManager(BufferManager mgr) {
        this.__m_BufferManager = mgr;
    }

    public void setCluster(Cluster cluster) {
        Grid._assert(this.getCluster() == null);
        this.__m_Cluster = cluster;
    }

    public void setClusterMemberSet(MasterMemberSet setMember) {
        Grid._assert(!this.isStarted());
        this.__m_ClusterMemberSet = setMember;
    }

    protected void setCompletedRequestSUIDs(ConcurrentMap map) {
        this.__m_CompletedRequestSUIDs = map;
    }

    protected void setDepartingMembers(MemberSet setMembers) {
        this.__m_DepartingMembers = setMembers;
    }

    protected void setInWait(boolean fWait) {
        this.__m_InWait = fWait;
    }

    private void setMemberListeners(Listeners listeners) {
        this.__m_MemberListeners = listeners;
    }

    private void setMessageClass(Class[] aclz) {
        this.__m_MessageClass = aclz;
    }

    protected void setMessageClass(int i, Class clz) {
        boolean fBeyondBounds;
        Class[] aClass = this.getMessageClass();
        boolean bl = fBeyondBounds = aClass == null || (i += 32) >= aClass.length;
        if (fBeyondBounds && clz != null) {
            int cNew = Math.max(i + (i >>> 1), i + 4);
            Class[] aClassNew = new Class[cNew];
            if (aClass != null) {
                System.arraycopy(aClass, 0, aClassNew, 0, aClass.length);
            }
            aClass = aClassNew;
            this.setMessageClass(aClassNew);
            fBeyondBounds = false;
        }
        if (!fBeyondBounds) {
            aClass[i] = clz;
        }
    }

    protected void setMessageClassMap(Map map) {
        this.__m_MessageClassMap = map;
    }

    protected void setMessageHandler(MessageHandler handler) {
        this.__m_MessageHandler = handler;
    }

    public void setMessagePublisher(MessagePublisher queue) {
        this.__m_MessagePublisher = queue;
    }

    protected void setOldestPendingRequestSUIDCounter(AtomicLong map) {
        this.__m_OldestPendingRequestSUIDCounter = map;
    }

    public void setPendingQuiescenceResponses(Collection colResponses) {
        this.__m_PendingQuiescenceResponses = colResponses;
    }

    protected void setPollArray(PollArray waPoll) {
        this.__m_PollArray = waPoll;
    }

    private void setQueueDeferred(Queue queue) {
        this.__m_QueueDeferred = queue;
    }

    public void setQueueDeferredWelcome(Queue queue) {
        this.__m_QueueDeferredWelcome = queue;
    }

    public void setRequestTimeout(long cMillis) {
        this.__m_RequestTimeout = cMillis;
    }

    public void setResourceRegistry(ResourceRegistry registry) {
        this.__m_ResourceRegistry = registry;
    }

    protected void setServiceConfigMap(ServiceConfig.Map map) {
        this.__m_ServiceConfigMap = map;
    }

    public void setServiceFailurePolicy(ServiceFailurePolicy policy) {
        this.__m_ServiceFailurePolicy = policy;
    }

    public void setServiceId(int nId) {
        Grid._assert(!this.isStarted());
        this.__m_ServiceId = nId;
    }

    public void setServiceLeftActions(Map mapActions) {
        this.__m_ServiceLeftActions = mapActions;
    }

    public void setServiceMemberSet(ServiceMemberSet setMember) {
        Grid._assert(this.getServiceMemberSet() == null || setMember == null);
        this.__m_ServiceMemberSet = setMember;
    }

    @Override
    public void setServiceState(int nState) {
        if (nState > this.getServiceState()) {
            switch (nState) {
                case 2: {
                    break;
                }
                case 3: {
                    this.dispatchMemberEvent(this.getThisMember(), 2);
                    break;
                }
                case 4: {
                    this.dispatchMemberEvent(this.getThisMember(), 3);
                }
            }
        }
        super.setServiceState(nState);
    }

    protected void setStatsPollCount(long cPolls) {
        this.__m_StatsPollCount = cPolls;
    }

    protected void setStatsPollDuration(long cMillis) {
        this.__m_StatsPollDuration = cMillis;
    }

    protected void setStatsPollMaxDuration(long cMillis) {
        this.__m_StatsPollMaxDuration = cMillis;
    }

    @Override
    public void setStatsReceived(long cMsgs) {
        super.setStatsReceived(cMsgs);
    }

    public void setStatsSent(long cMsgs) {
        this.__m_StatsSent = cMsgs;
    }

    public void setStatsSentLocal(long cMsgs) {
        this.__m_StatsSentLocal = cMsgs;
    }

    public void setStatsTimeoutCount(long cRequests) {
        this.__m_StatsTimeoutCount = cRequests;
    }

    protected void setSUIDCounter(AtomicLong[] alongCounter) {
        this.__m_SUIDCounter = alongCounter;
    }

    protected void setSUIDCounter(int i, AtomicLong longCounter) {
        this.getSUIDCounter()[i] = longCounter;
    }

    public void setSuspendPollLimit(AtomicLong atomicLimit) {
        this.__m_SuspendPollLimit = atomicLimit;
    }

    @Override
    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
    }

    public void setWrapperStreamFactoryAllList(List listAll) {
        this.__m_WrapperStreamFactoryAllList = listAll;
    }

    public void setWrapperStreamFactoryList(List list) {
        Grid._assert(!this.isStarted());
        this.__m_WrapperStreamFactoryList = list;
    }

    @Override
    public synchronized void shutdown() {
        Thread thread;
        if (this.isStarted() && this.getServiceState() < 3) {
            this.checkShutdownPermission();
            this.send(this.instantiateMessage("NotifyShutdown"));
        }
        if ((thread = this.getThread()) != Thread.currentThread()) {
            while (this.isStarted() && this.getServiceState() < 4) {
                try {
                    Blocking.wait(this, 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
            }
            this.waitForEventDispatcher();
            if (this.getServiceState() != 4) {
                this.stop();
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.getServiceState() == 0) {
            this.register();
        }
        super.start();
    }

    @Override
    public void stop() {
        this.checkShutdownPermission();
        this.setMessagePublisher(NullMessagePublisher.INSTANCE);
        super.stop();
    }

    public RuntimeException tagException(Throwable e) {
        if (e instanceof LicenseException) {
            return (LicenseException)e;
        }
        String sMsg = null;
        try {
            StackTraceElement[] atrace;
            sMsg = "Failed request execution for " + this.getServiceName() + " service on " + String.valueOf(this.getThisMember());
            if (e instanceof WrapperException) {
                WrapperException we = (WrapperException)e;
                e = we.getOriginalException();
                sMsg = sMsg + " " + we.getMessage();
            }
            if (e instanceof OutOfMemoryError && ((atrace = e.getStackTrace()) == null || atrace.length == 0)) {
                e = new OutOfMemoryError();
            }
        }
        catch (Throwable atrace) {
            // empty catch block
        }
        if (this.isExiting()) {
            Grid._trace(this.get_Name() + " encountered an exception (" + e.getClass().getName() + ": " + e.getMessage() + ") while stopping.", 3);
            throw new EventDeathException(sMsg);
        }
        try {
            this.getSerializer().serialize(new SizeEstimatingBufferOutput(), e);
        }
        catch (Throwable ex) {
            e = new RuntimeException(e.toString() + " (Note: The orignal exception is not serializable).");
        }
        return Base.ensureRuntimeException(e, sMsg);
    }

    protected void unregisterPoll(Poll poll) {
        Grid._assert(poll != null && poll.getService() == this);
        this.getPollArray().remove(poll.getPollId());
        long cMillis = Base.getSafeTimeMillis() - poll.getInitTimeMillis();
        this.setStatsPollCount(this.getStatsPollCount() + 1L);
        this.setStatsPollDuration(this.getStatsPollDuration() + cMillis);
        if (cMillis > this.getStatsPollMaxDuration()) {
            this.setStatsPollMaxDuration(cMillis);
        }
    }

    public void unregisterRequestContext(RequestContext ctx) {
        if (ctx == null) {
            return;
        }
        AtomicLong counterOldest = this.getOldestPendingRequestSUIDCounter();
        ConcurrentMap map = this.getCompletedRequestSUIDs();
        long lIdCtx = ctx.getRequestSUID();
        long lIdNext = lIdCtx + 1L;
        MutableLong LIdCtx = new MutableLong(lIdCtx);
        if (!counterOldest.compareAndSet(lIdCtx, lIdNext)) {
            map.put(LIdCtx, Boolean.TRUE);
            if (!counterOldest.compareAndSet(lIdCtx, lIdNext)) {
                return;
            }
            map.remove(LIdCtx);
        }
        while (map.containsKey(LIdCtx.set(lIdNext)) && map.remove(LIdCtx) != null && counterOldest.compareAndSet(lIdNext, lIdNext + 1L)) {
            ++lIdNext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validateMessage(Message msg) {
        Member memberFrom = msg.getFromMember();
        if (memberFrom != null) {
            int nMemberFrom = memberFrom.getId();
            ServiceMemberSet setMember = this.getServiceMemberSet();
            boolean fMember = false;
            if (setMember != null) {
                ServiceMemberSet serviceMemberSet = setMember;
                synchronized (serviceMemberSet) {
                    fMember = ((MemberSet)setMember).getMember(nMemberFrom) != null;
                }
            }
            if (!fMember && !msg.isInternal() && this.getServiceId() > 0) {
                Grid._trace("Discarding a " + msg.get_Name() + " message from member " + nMemberFrom + " which does not belong to the service.", 3);
                return false;
            }
        }
        return true;
    }

    protected boolean validateServiceConfig() {
        XmlElement xmlConfig;
        boolean fSenior = this.getThisMember() == this.getServiceOldestMember();
        Character oConfigKey = Character.valueOf('$');
        ServiceConfig.Map mapConfig = this.getServiceConfigMap();
        XmlElement xmlElement = xmlConfig = fSenior ? null : (XmlElement)mapConfig.get(oConfigKey);
        if (xmlConfig == null) {
            Grid._assert(fSenior, "The service configuration is missing.");
            xmlConfig = this.initServiceConfig();
            mapConfig.put(oConfigKey, xmlConfig);
            return true;
        }
        return this.validateServiceConfig(xmlConfig);
    }

    protected boolean validateServiceConfig(XmlElement xmlConfig) {
        return true;
    }

    protected boolean verifyFeature(String sFeature, Object oValue, Object oTest) {
        if (oValue.equals(oTest)) {
            return true;
        }
        Grid._trace("Incompatible " + sFeature + " implementation: this node is configured to use " + String.valueOf(oValue) + ", but the service senior is using " + String.valueOf(oTest) + "; stopping the service.", 1);
        return false;
    }

    protected ReadBuffer.BufferInput wrapStream(ReadBuffer.BufferInput input, Message msg) {
        List listSvc;
        InputStream streamWrap = null;
        List listAll = this.getWrapperStreamFactoryAllList();
        if (listAll != null) {
            streamWrap = new WrapperDataInputStream(input);
            int c = listAll.size();
            for (int i = 0; i < c; ++i) {
                streamWrap = ((WrapperStreamFactory)listAll.get(i)).getInputStream(streamWrap);
                if (!(streamWrap instanceof ProtocolAwareStream)) continue;
                ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
            }
        }
        if ((listSvc = this.getWrapperStreamFactoryList()) != null) {
            if (streamWrap == null) {
                streamWrap = new WrapperDataInputStream(input);
            }
            int c = listSvc.size();
            for (int i = 0; i < c; ++i) {
                streamWrap = ((WrapperStreamFactory)listSvc.get(i)).getInputStream(streamWrap);
                if (!(streamWrap instanceof ProtocolAwareStream)) continue;
                ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
            }
        }
        return streamWrap == null ? input : (streamWrap instanceof ReadBuffer.BufferInput ? (ReadBuffer.BufferInput)((Object)streamWrap) : new WrapperBufferInput(new DataInputStream(streamWrap), this.getContextClassLoader()));
    }

    public WriteBuffer.BufferOutput wrapStream(WriteBuffer.BufferOutput output, Message msg) {
        List listAll;
        List listSvc = this.getWrapperStreamFactoryList();
        OutputStream streamWrap = null;
        if (listSvc != null) {
            streamWrap = new WrapperDataOutputStream(output);
            int c = listSvc.size();
            for (int i = 0; i < c; ++i) {
                streamWrap = ((WrapperStreamFactory)listSvc.get(i)).getOutputStream(streamWrap);
                if (!(streamWrap instanceof ProtocolAwareStream)) continue;
                ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
            }
        }
        if ((listAll = this.getWrapperStreamFactoryAllList()) != null) {
            if (streamWrap == null) {
                streamWrap = new WrapperDataOutputStream(output);
            }
            int c = listAll.size();
            for (int i = 0; i < c; ++i) {
                streamWrap = ((WrapperStreamFactory)listAll.get(i)).getOutputStream(streamWrap);
                if (!(streamWrap instanceof ProtocolAwareStream)) continue;
                ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
            }
        }
        return streamWrap == null ? output : (streamWrap instanceof WriteBuffer.BufferOutput ? (WriteBuffer.BufferOutput)((Object)streamWrap) : new WrapperBufferOutput(new DataOutputStream(streamWrap)));
    }

    static {
        try {
            RANDOM = new Random();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        Grid.__initStatic();
    }

    public static class Acknowledgement
    extends Message {
        public Acknowledgement() {
            this(null, null, true);
        }

        public Acknowledgement(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Acknowledgement();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$Acknowledgement".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }
    }

    public static class BusEventMessage
    extends com.tangosol.coherence.component.net.message.BusEventMessage {
        public BusEventMessage() {
            this(null, null, true);
        }

        public BusEventMessage(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-21);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BusEventMessage();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$BusEventMessage".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }
    }

    public static class ConfigRequest
    extends RequestMessage {
        private transient ServiceConfig.Map __m_ConfigMap;
        private boolean __m_Remove;
        private Map __m_UpdateMap;

        public ConfigRequest() {
            this(null, null, true);
        }

        public ConfigRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-15);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new Poll("Poll", this, true), "Poll");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConfigRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ConfigRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public ServiceConfig.Map getConfigMap() {
            return this.__m_ConfigMap;
        }

        @Override
        public String getDescription() {
            return "UpdateMap=" + String.valueOf(this.getUpdateMap()) + "\nRemove=" + this.isRemove();
        }

        public Map getUpdateMap() {
            return this.__m_UpdateMap;
        }

        public boolean isRemove() {
            return this.__m_Remove;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Grid service = this.getService();
            ServiceConfig.Map mapConfig = this.getConfigMap();
            Member memberThis = service.getThisMember();
            Member memberFrom = this.getFromMember();
            Map mapUpdate = this.getUpdateMap();
            boolean fRemove = this.isRemove();
            ConfigResponse response = (ConfigResponse)service.instantiateMessage("ConfigResponse");
            if (memberThis == mapConfig.getConfigCoordinator()) {
                if (memberThis == memberFrom) {
                    Iterator iter = mapUpdate.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        Object oKey = entry.getKey();
                        if (mapConfig.containsKey(oKey)) {
                            if (fRemove) {
                                iter.remove();
                                continue;
                            }
                            entry.setValue(mapConfig.get(oKey));
                            continue;
                        }
                        if (fRemove) continue;
                        iter.remove();
                    }
                } else {
                    mapConfig.updateInternal(mapUpdate, fRemove);
                }
                MemberSet setOthers = new MemberSet();
                setOthers.addAll((Collection)service.getConfigMapUpdateMembers(mapConfig));
                setOthers.remove(memberFrom);
                ConfigUpdate msg = (ConfigUpdate)service.instantiateMessage("ConfigUpdate");
                msg.setConfigMap(mapConfig);
                msg.setToMemberSet(setOthers);
                msg.setUpdateMap(mapUpdate);
                msg.setRemove(fRemove);
                response.setAcknowledged(true);
                service.post(msg);
            } else {
                response.setAcknowledged(false);
            }
            response.respondTo(this);
            service.post(response);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            LiteMap<Object, Object> map = new LiteMap<Object, Object>();
            Grid service = this.getService();
            try {
                ServiceConfig.Map configMap = service.getConfigMap(input.readInt());
                this.setConfigMap(configMap);
                this.setRemove(input.readBoolean());
                int cEntries = input.readInt();
                for (int i = 0; i < cEntries; ++i) {
                    map.put(configMap.readObject(input), configMap.readObject(input));
                }
            }
            catch (IOException e) {
                service.onConfigIOException(e, this.getFromMember());
            }
            this.setUpdateMap(map);
        }

        public void setConfigMap(ServiceConfig.Map mapConfig) {
            this.__m_ConfigMap = mapConfig;
        }

        public void setRemove(boolean fRemove) {
            this.__m_Remove = fRemove;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setUpdateMap(Map mapUpdate) {
            this.__m_UpdateMap = mapUpdate;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            ServiceConfig.Map mapConfig = this.getConfigMap();
            Map mapUpdate = this.getUpdateMap();
            output.writeInt(this.getConfigMap().getMapType());
            output.writeBoolean(this.isRemove());
            output.writeInt(mapUpdate.size());
            for (Map.Entry entry : mapUpdate.entrySet()) {
                mapConfig.writeObject(output, entry.getKey());
                mapConfig.writeObject(output, entry.getValue());
            }
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            private boolean __m_Acknowledged;

            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ConfigRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public boolean isAcknowledged() {
                return this.__m_Acknowledged;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onCompletion() {
                Grid service = this.getService();
                if (service.getServiceState() == 4) {
                    return;
                }
                ConfigRequest msgRequest = (ConfigRequest)this.get_Parent();
                ServiceConfig.Map mapConfig = msgRequest.getConfigMap();
                Map mapPending = mapConfig.getConfig().getPendingPolls();
                Map mapUpdate = msgRequest.getUpdateMap();
                boolean fRemove = msgRequest.isRemove();
                if (!mapUpdate.isEmpty()) {
                    Map mapInternal;
                    Map map = mapInternal = mapConfig.getMap();
                    synchronized (map) {
                        for (Map.Entry entry : mapUpdate.entrySet()) {
                            Object oKey = entry.getKey();
                            if (mapPending.get(oKey) != this) continue;
                            mapPending.remove(oKey);
                            if (this.isAcknowledged()) continue;
                            Object oValueOld = entry.getValue();
                            Object oValueNew = mapInternal.get(oKey);
                            boolean fRemoveNew = !mapInternal.containsKey(oKey);
                            if (fRemove != fRemoveNew || !Base.equals(oValueOld, oValueNew)) continue;
                            Member memberCoordinator = mapConfig.getConfigCoordinator();
                            LiteMap mapUpdateNew = new LiteMap();
                            mapUpdateNew.put(oKey, oValueOld);
                            Poll._trace("Service " + service.getServiceName() + ": resending ConfigRequest to member " + memberCoordinator.getId() + " for key=" + String.valueOf(oKey) + ", value=" + String.valueOf(oValueOld), 3);
                            ConfigRequest msg = (ConfigRequest)service.instantiateMessage("ConfigRequest");
                            msg.setConfigMap(mapConfig);
                            msg.setUpdateMap(mapUpdateNew);
                            msg.setRemove(fRemove);
                            msg.addToMember(memberCoordinator);
                            mapPending.put(oKey, msg.ensureRequestPoll());
                            service.post(msg);
                        }
                    }
                }
                super.onCompletion();
            }

            @Override
            public void onResponse(Message msg) {
                ConfigResponse msgResponse = (ConfigResponse)msg;
                this.setAcknowledged(msgResponse.isAcknowledged());
                super.onResponse(msg);
            }

            protected void setAcknowledged(boolean fAcknowledged) {
                this.__m_Acknowledged = fAcknowledged;
            }
        }
    }

    public static class ConfigResponse
    extends Message {
        private boolean __m_Acknowledged;

        public ConfigResponse() {
            this(null, null, true);
        }

        public ConfigResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-16);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConfigResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ConfigResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public boolean isAcknowledged() {
            return this.__m_Acknowledged;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            this.setAcknowledged(input.readBoolean());
        }

        public void setAcknowledged(boolean fAcknowledged) {
            this.__m_Acknowledged = fAcknowledged;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            output.writeBoolean(this.isAcknowledged());
        }
    }

    public static class ConfigSync
    extends Message {
        private transient ServiceConfig.Map __m_ConfigMap;
        private Map __m_SyncMap;

        public ConfigSync() {
            this(null, null, true);
        }

        public ConfigSync(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-17);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConfigSync();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ConfigSync".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public ServiceConfig.Map getConfigMap() {
            return this.__m_ConfigMap;
        }

        @Override
        public String getDescription() {
            return "SyncMap=" + String.valueOf(this.getSyncMap());
        }

        public Map getSyncMap() {
            return this.__m_SyncMap;
        }

        @Override
        public void onReceived() {
            Grid service = this.getService();
            ServiceConfig.Map mapConfig = this.getConfigMap();
            Member memberFrom = this.getFromMember();
            Member memberCoordinator = mapConfig.getConfigCoordinator();
            if (memberCoordinator != null && memberCoordinator != memberFrom && service.isAcceptingOthers()) {
                if (service.getServiceMemberSet().contains(memberFrom)) {
                    mapConfig.deferConfigUpdate(this);
                } else {
                    ConfigSync._trace("Ignoring ConfigSync from departed member " + String.valueOf(memberFrom), 5);
                }
                return;
            }
            super.onReceived();
            if (!service.isWelcomedBy(memberFrom)) {
                ConfigSync._trace("Ignoring premature ConfigSync from member " + memberFrom.getId(), 5);
                return;
            }
            Map mapSrc = this.getSyncMap();
            Map mapInternal = mapConfig.getMap();
            if (!mapSrc.isEmpty()) {
                ConfigSync._trace("Service " + service.getServiceName() + ": received " + this.getConfigMap().getConfig().get_Name() + " ConfigSync from member " + memberFrom.getId() + " containing " + mapSrc.size() + " entries", 3);
            }
            mapInternal.keySet().retainAll(mapSrc.keySet());
            mapConfig.updateInternal(mapSrc, false);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            Grid service = this.getService();
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            try {
                ServiceConfig.Map mapConfig = service.getConfigMap(input.readInt());
                int c = input.readInt();
                this.setConfigMap(mapConfig);
                for (int i = 0; i < c; ++i) {
                    Object oKey = mapConfig.readObject(input);
                    Object oValue = mapConfig.readObject(input);
                    map.put(oKey, oValue);
                }
            }
            catch (IOException e) {
                service.onConfigIOException(e, this.getFromMember());
            }
            this.setSyncMap(map);
        }

        public void setConfigMap(ServiceConfig.Map mapConfig) {
            this.__m_ConfigMap = mapConfig;
        }

        public void setSyncMap(Map mapSync) {
            this.__m_SyncMap = mapSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            Map mapSync;
            ServiceConfig.Map mapConfig = this.getConfigMap();
            Map map = mapSync = this.getSyncMap();
            synchronized (map) {
                output.writeInt(mapConfig.getMapType());
                output.writeInt(mapSync.size());
                for (Map.Entry entry : mapSync.entrySet()) {
                    mapConfig.writeObject(output, entry.getKey());
                    mapConfig.writeObject(output, entry.getValue());
                }
            }
        }
    }

    public static class ConfigUpdate
    extends Message {
        private transient ServiceConfig.Map __m_ConfigMap;
        private boolean __m_Remove;
        private Map __m_UpdateMap;

        public ConfigUpdate() {
            this(null, null, true);
        }

        public ConfigUpdate(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-18);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConfigUpdate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ConfigUpdate".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public ServiceConfig.Map getConfigMap() {
            return this.__m_ConfigMap;
        }

        @Override
        public String getDescription() {
            return "UpdateMap=" + String.valueOf(this.getUpdateMap()) + "; Remove=" + this.isRemove();
        }

        public Map getUpdateMap() {
            return this.__m_UpdateMap;
        }

        public boolean isRemove() {
            return this.__m_Remove;
        }

        @Override
        public void onReceived() {
            Grid service = this.getService();
            ServiceConfig.Map mapConfig = this.getConfigMap();
            Member memberFrom = this.getFromMember();
            Member memberCoordinator = mapConfig.getConfigCoordinator();
            if (memberCoordinator != null && memberCoordinator != memberFrom) {
                if (service.getServiceMemberSet().contains(memberFrom)) {
                    mapConfig.deferConfigUpdate(this);
                } else {
                    ConfigUpdate._trace("Ignoring ConfigUpdate from departed member " + memberFrom.getId(), 5);
                }
                return;
            }
            super.onReceived();
            if (!service.isWelcomedBy(memberFrom)) {
                ConfigUpdate._trace("Ignoring premature ConfigSync from member " + memberFrom.getId(), 5);
                return;
            }
            Map mapUpdate = this.getUpdateMap();
            Iterator iter = mapUpdate.keySet().iterator();
            while (iter.hasNext()) {
                Object oKey = iter.next();
                if (!mapConfig.isRequestPending(oKey)) continue;
                ConfigUpdate._trace("Request is pending; ignoring the ConfigUpdate " + this.getDescription(), 5);
                iter.remove();
            }
            mapConfig.updateInternal(mapUpdate, this.isRemove());
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            Grid service = this.getService();
            LiteMap<Object, Object> map = new LiteMap<Object, Object>();
            try {
                ServiceConfig.Map mapConfig = service.getConfigMap(input.readInt());
                this.setConfigMap(mapConfig);
                this.setRemove(input.readBoolean());
                int cEntries = input.readInt();
                for (int i = 0; i < cEntries; ++i) {
                    map.put(mapConfig.readObject(input), mapConfig.readObject(input));
                }
            }
            catch (IOException e) {
                this.getService().onConfigIOException(e, this.getFromMember());
            }
            this.setUpdateMap(map);
        }

        public void setConfigMap(ServiceConfig.Map mapConfig) {
            this.__m_ConfigMap = mapConfig;
        }

        public void setRemove(boolean fRemove) {
            this.__m_Remove = fRemove;
        }

        public void setUpdateMap(Map mapUpdate) {
            this.__m_UpdateMap = mapUpdate;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            ServiceConfig.Map mapConfig = this.getConfigMap();
            Grid service = this.getService();
            Map mapUpdate = this.getUpdateMap();
            output.writeInt(mapConfig.getMapType());
            output.writeBoolean(this.isRemove());
            output.writeInt(mapUpdate.size());
            for (Map.Entry entry : mapUpdate.entrySet()) {
                mapConfig.writeObject(output, entry.getKey());
                mapConfig.writeObject(output, entry.getValue());
            }
        }
    }

    public static class DispatchEvent
    extends Service.DispatchEvent {
        public DispatchEvent() {
            this(null, null, true);
        }

        public DispatchEvent(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DispatchEvent();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$DispatchEvent".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void run() {
            EventObject evt = this.getEvent();
            if (evt instanceof MemberEvent) {
                ((MemberEvent)evt).dispatch(this.getListeners());
            } else {
                super.run();
            }
        }
    }

    public static class DispatchNotification
    extends Util
    implements Runnable {
        private String __m_MBeanName;
        private String __m_Message;
        private String __m_Source;
        private String __m_Type;
        private Object __m_UserData;

        public DispatchNotification() {
            this(null, null, true);
        }

        public DispatchNotification(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DispatchNotification();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$DispatchNotification".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public String getMBeanName() {
            return this.__m_MBeanName;
        }

        public String getMessage() {
            return this.__m_Message;
        }

        public String getSource() {
            return this.__m_Source;
        }

        public String getType() {
            return this.__m_Type;
        }

        public Object getUserData() {
            return this.__m_UserData;
        }

        @Override
        public void run() {
            String sMBeanName;
            NotificationManager manager;
            Grid service = (Grid)this.get_Module();
            Registry registry = service.getCluster().getManagement();
            if (registry != null && (manager = registry.getNotificationManager()).isSubscribedTo(sMBeanName = this.getMBeanName())) {
                Notification note = new Notification(this.getType(), (Object)this.getSource(), -1L, this.getMessage());
                note.setUserData(this.getUserData());
                manager.trigger(sMBeanName, note);
            }
        }

        public void setMBeanName(String sName) {
            this.__m_MBeanName = sName;
        }

        public void setMessage(String sMsg) {
            this.__m_Message = sMsg;
        }

        public void setSource(String sSource) {
            this.__m_Source = sSource;
        }

        public void setType(String sType) {
            this.__m_Type = sType;
        }

        public void setUserData(Object oData) {
            this.__m_UserData = oData;
        }
    }

    public static class MemberConfigUpdate
    extends Message {
        private Object __m_Key;
        private boolean __m_Remove;
        private Object __m_Value;

        public MemberConfigUpdate() {
            this(null, null, true);
        }

        public MemberConfigUpdate(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-3);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberConfigUpdate();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$MemberConfigUpdate".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "Key=" + String.valueOf(this.getKey()) + "; Value=" + String.valueOf(this.getValue()) + "; Remove=" + this.isRemove();
        }

        public Object getKey() {
            return this.__m_Key;
        }

        public Object getValue() {
            return this.__m_Value;
        }

        public boolean isRemove() {
            return this.__m_Remove;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Grid service = this.getService();
            Member member = this.getFromMember();
            MemberConfigUpdate._assert(member != service.getThisMember());
            ObservableMap map = service.getServiceMemberSet().ensureMemberConfigMap(member.getId());
            Object oKey = this.getKey();
            if (this.isRemove()) {
                map.remove(oKey);
            } else {
                map.put(oKey, this.getValue());
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            Grid service = this.getService();
            try {
                this.setKey(service.readObject(input));
                this.setValue(service.readObject(input));
                this.setRemove(input.readBoolean());
            }
            catch (IOException e) {
                service.onConfigIOException(e, this.getFromMember());
            }
        }

        public void setKey(Object pKey) {
            this.__m_Key = pKey;
        }

        public void setRemove(boolean pRemove) {
            this.__m_Remove = pRemove;
        }

        public void setValue(Object pValue) {
            this.__m_Value = pValue;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            Grid service = this.getService();
            service.writeObject(output, this.getKey());
            service.writeObject(output, this.getValue());
            output.writeBoolean(this.isRemove());
        }
    }

    public static class MemberJoined
    extends Message {
        private int __m_MemberId;

        public MemberJoined() {
            this(null, null, true);
        }

        public MemberJoined(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(4);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberJoined();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$MemberJoined".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "NotifyMember=" + String.valueOf(this.getFromMember());
        }

        public int getMemberId() {
            return this.__m_MemberId;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Grid service = (Grid)this.get_Module();
            service.onNotifyServiceJoined(service.getServiceMemberSet().getMember(this.getMemberId()));
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setMemberId(input.readInt());
        }

        public void setMemberId(int nId) {
            this.__m_MemberId = nId;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeInt(this.getMemberId());
        }
    }

    public static class MemberRecovered
    extends Message {
        private int __m_MemberId;

        public MemberRecovered() {
            this(null, null, true);
        }

        public MemberRecovered(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(18);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberRecovered();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$MemberRecovered".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "MemberRecovered=" + String.valueOf(this.getFromMember());
        }

        public int getMemberId() {
            return this.__m_MemberId;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Grid service = (Grid)this.get_Module();
            Member member = service.getServiceMemberSet().getMember(this.getMemberId());
            service.dispatchMemberEvent(member, 4);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            this.setMemberId(input.readInt());
        }

        public void setMemberId(int nId) {
            this.__m_MemberId = nId;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            output.writeInt(this.getMemberId());
        }
    }

    public static class MemberWelcome
    extends Message {
        private Map __m_MemberConfigMap;
        private boolean __m_Rejected;
        private Map __m_ServiceConfigMap;

        public MemberWelcome() {
            this(null, null, true);
        }

        public MemberWelcome(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-2);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberWelcome();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$MemberWelcome".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "MemberConfigMap=" + String.valueOf(this.getMemberConfigMap());
        }

        public Map getMemberConfigMap() {
            return this.__m_MemberConfigMap;
        }

        public Map getServiceConfigMap() {
            return this.__m_ServiceConfigMap;
        }

        public boolean isRejected() {
            return this.__m_Rejected;
        }

        @Override
        public void onReceived() {
            if (this.isRejected()) {
                return;
            }
            Grid service = this.getService();
            service.getServiceMemberSet().updateMemberConfigMap(this.getFromMember().getId(), this.getMemberConfigMap());
            Map mapServiceConfig = this.getServiceConfigMap();
            if (mapServiceConfig != null) {
                service.getServiceConfigMap().updateInternal(mapServiceConfig, false);
            }
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            boolean fRejected = input.readBoolean();
            this.setRejected(fRejected);
            if (fRejected) {
                return;
            }
            Grid service = this.getService();
            try {
                ObservableHashMap<Object, Object> mapMemberConfig = new ObservableHashMap<Object, Object>();
                int c = input.readInt();
                for (int i = 0; i < c; ++i) {
                    Object oKey = service.readObject(input);
                    Object oValue = service.readObject(input);
                    mapMemberConfig.put(oKey, oValue);
                }
                HashMap<Object, Object> mapServiceConfig = null;
                boolean fServiceConfig = input.readBoolean();
                if (fServiceConfig) {
                    com.tangosol.coherence.component.util.ServiceConfig cfgService = service.getServiceConfigMap().getConfig();
                    mapServiceConfig = new HashMap<Object, Object>();
                    int c2 = input.readInt();
                    for (int i = 0; i < c2; ++i) {
                        Object oKey = cfgService.readObject(input);
                        Object oValue = cfgService.readObject(input);
                        mapServiceConfig.put(oKey, oValue);
                    }
                }
                this.setMemberConfigMap(mapMemberConfig);
                this.setServiceConfigMap(mapServiceConfig);
            }
            catch (IOException e) {
                service.onConfigIOException(e, this.getFromMember());
            }
        }

        public void setMemberConfigMap(Map map) {
            this.__m_MemberConfigMap = map;
        }

        public void setRejected(boolean fRejected) {
            this.__m_Rejected = fRejected;
        }

        public void setServiceConfigMap(Map mapConfig) {
            this.__m_ServiceConfigMap = mapConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            Map mapMemberConfig;
            boolean fRejected = this.isRejected();
            output.writeBoolean(fRejected);
            if (fRejected) {
                return;
            }
            Grid service = this.getService();
            Map mapServiceConfig = this.getServiceConfigMap();
            Map map = mapMemberConfig = this.getMemberConfigMap();
            synchronized (map) {
                output.writeInt(mapMemberConfig.size());
                for (Map.Entry entry : mapMemberConfig.entrySet()) {
                    service.writeObject(output, entry.getKey());
                    service.writeObject(output, entry.getValue());
                }
            }
            if (mapServiceConfig == null) {
                output.writeBoolean(false);
            } else {
                com.tangosol.coherence.component.util.ServiceConfig cfgService = service.getServiceConfigMap().getConfig();
                output.writeBoolean(true);
                output.writeInt(mapServiceConfig.size());
                for (Map.Entry entry : mapServiceConfig.entrySet()) {
                    cfgService.writeObject(output, entry.getKey());
                    cfgService.writeObject(output, entry.getValue());
                }
            }
        }
    }

    public static class MemberWelcomeRequest
    extends RequestMessage {
        private MemberSet __m_SenderMemberSet;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public MemberWelcomeRequest() {
            this(null, null, true);
        }

        public MemberWelcomeRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberWelcomeRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$MemberWelcomeRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public MemberSet getSenderMemberSet() {
            return this.__m_SenderMemberSet;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            Grid service = this.getService();
            service.post(this.populateWelcomeMessage());
        }

        protected MemberWelcome populateWelcomeMessage() {
            Grid service = this.getService();
            MemberWelcomeRequest._assert(service.getServiceId() > 0);
            MemberWelcome msgWelcome = (MemberWelcome)service.instantiateMessage("MemberWelcome");
            msgWelcome.respondTo(this);
            ServiceMemberSet setMemberThis = service.getServiceMemberSet();
            MemberSet setMemberThat = this.getSenderMemberSet();
            if (((MemberSet)setMemberThis).size() == setMemberThat.size() && setMemberThis.containsAll((Collection)setMemberThat)) {
                msgWelcome.setMemberConfigMap(service.getThisMemberConfigMap());
                if (service.getThisMember() == service.getServiceOldestMember()) {
                    msgWelcome.setServiceConfigMap(service.getServiceConfigMap());
                }
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("Rejecting service handshake request from member ").append(this.getFromMember().getId()).append(" due to a concurrent membership change");
                MemberSet setDelta = new MemberSet();
                setDelta.addAll((Collection)setMemberThis);
                setDelta.removeAll((Collection)setMemberThat);
                if (!setDelta.isEmpty()) {
                    sb.append("; requestor's member set is missing " + String.valueOf(setDelta));
                }
                setDelta.clear();
                setDelta.addAll((Collection)setMemberThat);
                setDelta.removeAll((Collection)setMemberThis);
                if (!setDelta.isEmpty()) {
                    sb.append("; requestor's member set has extra " + String.valueOf(setDelta));
                }
                MemberWelcomeRequest._trace(sb.toString(), 3);
                msgWelcome.setRejected(true);
            }
            return msgWelcome;
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            MemberSet setMembers = new MemberSet();
            setMembers.readExternal(input);
            this.setSenderMemberSet(setMembers);
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setSenderMemberSet(MemberSet setMember) {
            if (setMember instanceof ServiceMemberSet) {
                MemberSet setSnapshot = new MemberSet();
                setSnapshot.addAll((Collection)setMember);
                setMember = setSnapshot;
            }
            this.__m_SenderMemberSet = setMember;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            this.getSenderMemberSet().writeExternal(output);
        }

        static {
            MemberWelcomeRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            private transient MemberSet __m_RejectedMemberSet;

            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$MemberWelcomeRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public String getDescription() {
                StringBuilder sb = new StringBuilder();
                sb.append("RejectedMemberSet=[").append(this.getRejectedMemberSet().getIdList()).append(']');
                return sb.toString();
            }

            public MemberSet getRejectedMemberSet() {
                return this.__m_RejectedMemberSet;
            }

            public boolean isRejected() {
                return !this.getRejectedMemberSet().isEmpty();
            }

            @Override
            protected void onCompletion() {
                Grid service = this.getService();
                if (service.getServiceState() == 2) {
                    MemberSet setLeft = this.getLeftMemberSet();
                    MemberSet setRejected = this.getRejectedMemberSet();
                    if (service.getThisMember() == service.getServiceOldestMember()) {
                        Poll._trace("This member has become service senior. Starting " + service.getServiceName(), 3);
                        if (service.getServiceId() > 0) {
                            service.onServiceStarted();
                        }
                    } else if (!setRejected.isEmpty() || !setLeft.isEmpty()) {
                        int cPauseMillis;
                        MemberSet setRetry;
                        ServiceMemberSet setCurrent = service.getServiceMemberSet();
                        StringBuilder sbMsg = new StringBuilder("Retrying service handshake request due to a concurrent membership change");
                        if (setLeft.isEmpty()) {
                            MemberSet setPrevious = ((MemberWelcomeRequest)this.get_Parent()).getSenderMemberSet();
                            setRetry = new MemberSet();
                            if (setPrevious.size() == ((MemberSet)setCurrent).size()) {
                                cPauseMillis = Math.min(500, 10 * setRejected.size());
                            } else {
                                cPauseMillis = 0;
                                setRetry.addAll((Collection)setCurrent);
                                setRetry.removeAll((Collection)setPrevious);
                            }
                            setRetry.addAll((Collection)setRejected);
                            setRetry.retainAll((Collection)service.getOthersMemberSet());
                            sbMsg.append("; resending the request to ").append(setRetry);
                        } else {
                            cPauseMillis = 15;
                            setRetry = service.getOthersMemberSet();
                            sbMsg.append("; responders left ").append(setLeft).append("; resending the request to all ").append(setRetry.size()).append(" service members");
                        }
                        if (cPauseMillis > 0) {
                            sbMsg.append(" after a ").append(new Duration((long)cPauseMillis * 1000000L)).append(" backoff period");
                            Grid.sleep(cPauseMillis);
                        }
                        Poll._trace(sbMsg.toString(), 3);
                        MemberWelcomeRequest msg = (MemberWelcomeRequest)service.instantiateMessage("MemberWelcomeRequest");
                        msg.setSenderMemberSet(setCurrent);
                        msg.setToMemberSet(setRetry);
                        service.post(msg);
                        this.setResult(Boolean.FALSE);
                    } else if (service.getServiceId() > 0) {
                        service.onServiceStarted();
                    }
                }
                super.onCompletion();
            }

            @Override
            public void onInit() {
                this.setRejectedMemberSet(new MemberSet());
                super.onInit();
            }

            @Override
            public void onResponse(Message msg) {
                if (((MemberWelcome)msg).isRejected()) {
                    this.getRejectedMemberSet().add(msg.getFromMember());
                }
                super.onResponse(msg);
            }

            protected void setRejectedMemberSet(MemberSet setReject) {
                this.__m_RejectedMemberSet = setReject;
            }
        }
    }

    public static class MemberWelcomeRequestTask
    extends Component
    implements Runnable {
        public MemberWelcomeRequestTask() {
            this(null, null, true);
        }

        public MemberWelcomeRequestTask(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberWelcomeRequestTask();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$MemberWelcomeRequestTask".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void run() {
            MemberWelcomeRequest msg = (MemberWelcomeRequest)((Grid)this.get_Module()).instantiateMessage("MemberWelcomeRequest");
            msg.setSenderMemberSet(((Grid)this.get_Module()).getServiceMemberSet());
            msg.setToMemberSet(((Grid)this.get_Module()).getOthersMemberSet());
            ((Grid)this.get_Module()).post(msg);
        }
    }

    public static class NotifyConnectionClose
    extends Message {
        private Member __m_NotifyMember;

        public NotifyConnectionClose() {
            this(null, null, true);
        }

        public NotifyConnectionClose(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-24);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyConnectionClose();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyConnectionClose".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "NotifyMember=" + String.valueOf(this.getNotifyMember());
        }

        public Member getNotifyMember() {
            return this.__m_NotifyMember;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Grid service = this.getService();
            Member member = this.getNotifyMember();
            service.dispatchMemberEvent(member, 3);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            Grid service = this.getService();
            this.setNotifyMember((Member)service.readObject(input));
        }

        public void setNotifyMember(Member sProperty) {
            this.__m_NotifyMember = sProperty;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            Grid service = this.getService();
            service.writeObject(output, (Object)this.getNotifyMember());
        }
    }

    public static class NotifyConnectionOpen
    extends Message {
        private Member __m_NotifyMember;

        public NotifyConnectionOpen() {
            this(null, null, true);
        }

        public NotifyConnectionOpen(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-23);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyConnectionOpen();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyConnectionOpen".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "NotifyMember=" + String.valueOf(this.getNotifyMember());
        }

        public Member getNotifyMember() {
            return this.__m_NotifyMember;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Grid service = this.getService();
            Member member = this.getNotifyMember();
            service.dispatchMemberEvent(member, 1);
        }

        @Override
        public void read(ReadBuffer.BufferInput input) throws IOException {
            super.read(input);
            Grid service = this.getService();
            this.setNotifyMember((Member)service.readObject(input));
        }

        public void setNotifyMember(Member memberNotify) {
            this.__m_NotifyMember = memberNotify;
        }

        @Override
        public void write(WriteBuffer.BufferOutput output) throws IOException {
            super.write(output);
            Grid service = this.getService();
            service.writeObject(output, (Object)this.getNotifyMember());
        }
    }

    public static class NotifyMemberJoined
    extends Message {
        private Member __m_NotifyMember;

        public NotifyMemberJoined() {
            this(null, null, true);
        }

        public NotifyMemberJoined(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-4);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyMemberJoined();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyMemberJoined".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "NotifyMember=" + String.valueOf(this.getNotifyMember());
        }

        public Member getNotifyMember() {
            return this.__m_NotifyMember;
        }

        public void setNotifyMember(Member member) {
            this.__m_NotifyMember = member;
        }
    }

    public static class NotifyMemberLeaving
    extends Message {
        private Member __m_NotifyMember;

        public NotifyMemberLeaving() {
            this(null, null, true);
        }

        public NotifyMemberLeaving(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-5);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyMemberLeaving();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyMemberLeaving".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "NotifyMember=" + String.valueOf(this.getNotifyMember());
        }

        public Member getNotifyMember() {
            return this.__m_NotifyMember;
        }

        public void setNotifyMember(Member member) {
            this.__m_NotifyMember = member;
        }
    }

    public static class NotifyMemberLeft
    extends Message {
        private Member __m_NotifyMember;

        public NotifyMemberLeft() {
            this(null, null, true);
        }

        public NotifyMemberLeft(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-6);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyMemberLeft();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyMemberLeft".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "NotifyMember=" + String.valueOf(this.getNotifyMember());
        }

        public Member getNotifyMember() {
            return this.__m_NotifyMember;
        }

        public void setNotifyMember(Member member) {
            this.__m_NotifyMember = member;
        }
    }

    public static class NotifyMessageReceipt
    extends Message {
        private Message __m_NotifyMessage;

        public NotifyMessageReceipt() {
            this(null, null, true);
        }

        public NotifyMessageReceipt(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-7);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyMessageReceipt();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyMessageReceipt".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "NotifyMessage=" + Base.indentString(this.getNotifyMessage().toString(), "              ", false);
        }

        public Message getNotifyMessage() {
            return this.__m_NotifyMessage;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Message msg = this.getNotifyMessage();
            if (msg != null) {
                msg.onDelivery();
            }
        }

        @Override
        public boolean preprocess() {
            Message msg = this.getNotifyMessage();
            return msg == null || msg.preprocessSentNotification();
        }

        public void setNotifyMessage(Message msg) {
            this.__m_NotifyMessage = msg;
        }
    }

    public static class NotifyPollClosed
    extends Message {
        private Throwable __m_Exception;
        private Member __m_NotifyMember;
        private transient Poll __m_NotifyPoll;

        public NotifyPollClosed() {
            this(null, null, true);
        }

        public NotifyPollClosed(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-8);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyPollClosed();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyPollClosed".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "NotifyMessage=" + Base.indentString(this.getNotifyPoll().toString(), "              ", false);
        }

        public Throwable getException() {
            return this.__m_Exception;
        }

        public Member getNotifyMember() {
            return this.__m_NotifyMember;
        }

        public Poll getNotifyPoll() {
            return this.__m_NotifyPoll;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Poll poll = this.getNotifyPoll();
            if (poll != null) {
                Member memberLeft;
                Throwable e = this.getException();
                if (e != null) {
                    poll.onException(e);
                }
                if ((memberLeft = this.getNotifyMember()) == null) {
                    poll.close();
                } else {
                    poll.onLeft(memberLeft);
                }
            }
        }

        public void setException(Throwable eException) {
            this.__m_Exception = eException;
        }

        public void setNotifyMember(Member member) {
            this.__m_NotifyMember = member;
        }

        public void setNotifyPoll(Poll msg) {
            this.__m_NotifyPoll = msg;
        }
    }

    public static class NotifyResponse
    extends Message {
        private transient Object __m_Result;

        public NotifyResponse() {
            this(null, null, true);
        }

        public NotifyResponse(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-20);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyResponse();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyResponse".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object getResult() {
            return this.__m_Result;
        }

        public void setResult(Object oResult) {
            this.__m_Result = oResult;
        }
    }

    public static class NotifyServiceAnnounced
    extends Message {
        private String __m_NotifyServiceName;

        public NotifyServiceAnnounced() {
            this(null, null, true);
        }

        public NotifyServiceAnnounced(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-9);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyServiceAnnounced();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyServiceAnnounced".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "NotifyServiceName=" + this.getNotifyServiceName();
        }

        public String getNotifyServiceName() {
            return this.__m_NotifyServiceName;
        }

        public void setNotifyServiceName(String sName) {
            this.__m_NotifyServiceName = sName;
        }
    }

    public static class NotifyServiceJoining
    extends RequestMessage
    implements Service.MemberJoinAction {
        private NotifyResponse __m_ContinuationMessage;
        private Member __m_NotifyMember;
        private Map __m_NotifyMemberConfigMap;
        private String __m_NotifyServiceEndPointName;
        private long __m_NotifyServiceJoinTime;
        private String __m_NotifyServiceVersion;
        private PermissionInfo __m_PermissionInfo;

        public NotifyServiceJoining() {
            this(null, null, true);
        }

        public NotifyServiceJoining(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-10);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new Poll("Poll", this, true), "Poll");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyServiceJoining();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyServiceJoining".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public NotifyResponse getContinuationMessage() {
            return this.__m_ContinuationMessage;
        }

        @Override
        public String getDescription() {
            return "NotifyMember=" + String.valueOf(this.getNotifyMember()) + "\nNotifyEndPoint=" + this.getNotifyServiceEndPointName();
        }

        @Override
        public com.tangosol.net.Member getJoiningMember() {
            return this.getNotifyMember();
        }

        public Member getNotifyMember() {
            return this.__m_NotifyMember;
        }

        public Map getNotifyMemberConfigMap() {
            return this.__m_NotifyMemberConfigMap;
        }

        public String getNotifyServiceEndPointName() {
            return this.__m_NotifyServiceEndPointName;
        }

        public long getNotifyServiceJoinTime() {
            return this.__m_NotifyServiceJoinTime;
        }

        public String getNotifyServiceVersion() {
            return this.__m_NotifyServiceVersion;
        }

        public PermissionInfo getPermissionInfo() {
            return this.__m_PermissionInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceived() {
            MessageHandler handler;
            Security security;
            super.onReceived();
            Grid service = this.getService();
            Member memberThis = service.getThisMember();
            Member memberFrom = this.getNotifyMember();
            Map mapConfig = this.getNotifyMemberConfigMap();
            int nMemberFrom = memberFrom.getId();
            ServiceMemberSet setMember = service.getServiceMemberSet();
            Object oReject = null;
            NotifyResponse msgResponse = (NotifyResponse)service.instantiateMessage("NotifyResponse");
            msgResponse.respondTo(this);
            if (setMember.contains(memberFrom)) {
                NotifyServiceJoining._trace("Rejecting the ServiceJoining request processing from member " + nMemberFrom, 3);
                oReject = "Member " + memberThis.getId() + " has not finished processing service departure notification";
            }
            if (oReject == null && !service.getActionPolicy().isAllowed(service, this)) {
                String sMsg = "The request from member " + nMemberFrom + " to join the service was rejected by the service action policy";
                NotifyServiceJoining._trace(sMsg, 3);
                oReject = new RuntimeException(sMsg);
            }
            Security security2 = security = service.getServiceId() > 1 ? Security.getInstance() : null;
            if (oReject == null && security != null && setMember.getOldestMember() == memberThis) {
                PermissionInfo piRequest = this.getPermissionInfo();
                if (piRequest == null) {
                    NotifyServiceJoining._trace("Request is rejected due to disabled security at " + String.valueOf(memberFrom), 1);
                    oReject = new SecurityException();
                } else {
                    Object oResponse = security.processSecureRequest(memberThis, memberFrom, piRequest);
                    if (oResponse instanceof RuntimeException) {
                        NotifyServiceJoining._trace("Security configuration mismatch or break-in attempt: " + ((RuntimeException)oResponse).getMessage(), 1);
                        oReject = new SecurityException();
                    } else {
                        msgResponse.setResult(oResponse);
                    }
                }
            }
            EndPoint peer = null;
            if (oReject == null && (peer = service.resolveEndPoint(this.getNotifyServiceEndPointName(), memberFrom, mapConfig)) != null && (handler = service.getMessageHandler()) != null) {
                if (handler.getConnectionMap().containsKey(peer)) {
                    NotifyServiceJoining._trace("Rejecting the ServiceJoining request processing from member " + nMemberFrom + "; EndPoint=" + String.valueOf(peer), 3);
                    oReject = "Member " + memberThis.getId() + " has not finished processing service departure notification";
                } else if (!handler.connect(memberFrom, peer)) {
                    peer = null;
                }
            }
            if (oReject == null) {
                ServiceMemberSet serviceMemberSet = setMember;
                synchronized (serviceMemberSet) {
                    setMember.add(memberFrom);
                    setMember.setServiceVersion(nMemberFrom, this.getNotifyServiceVersion());
                    setMember.setServiceJoinTime(nMemberFrom, this.getNotifyServiceJoinTime());
                    setMember.setServiceEndPointName(nMemberFrom, peer == null ? null : peer.getCanonicalName());
                    setMember.setServiceEndPoint(nMemberFrom, peer);
                    setMember.updateMemberConfigMap(nMemberFrom, mapConfig);
                    setMember.setServiceJoining(nMemberFrom);
                }
            } else {
                msgResponse.setResult(oReject);
            }
            service.post(msgResponse);
        }

        public void setContinuationMessage(NotifyResponse msg) {
            this.__m_ContinuationMessage = msg;
        }

        public void setNotifyMember(Member member) {
            this.__m_NotifyMember = member;
        }

        public void setNotifyMemberConfigMap(Map map) {
            this.__m_NotifyMemberConfigMap = map;
        }

        public void setNotifyServiceEndPointName(String sName) {
            this.__m_NotifyServiceEndPointName = sName;
        }

        public void setNotifyServiceJoinTime(long ldt) {
            this.__m_NotifyServiceJoinTime = ldt;
        }

        public void setNotifyServiceVersion(String sVersion) {
            this.__m_NotifyServiceVersion = sVersion;
        }

        public void setPermissionInfo(PermissionInfo infoPermission) {
            this.__m_PermissionInfo = infoPermission;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyServiceJoining$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                NotifyServiceJoining msgReq = (NotifyServiceJoining)this.get_Parent();
                NotifyResponse msgContinuation = msgReq.getContinuationMessage();
                if (msgContinuation != null) {
                    msgContinuation.setResult(this.getResult());
                    msgContinuation.getService().send(msgContinuation);
                }
            }

            @Override
            public void onResponse(Message msg) {
                NotifyResponse msgResponse = (NotifyResponse)msg;
                this.setResult(msgResponse.getResult());
                super.onResponse(msg);
            }
        }
    }

    public static class NotifyServiceLeaving
    extends Message {
        private Member __m_NotifyMember;

        public NotifyServiceLeaving() {
            this(null, null, true);
        }

        public NotifyServiceLeaving(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-11);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyServiceLeaving();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyServiceLeaving".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "NotifyMember=" + String.valueOf(this.getNotifyMember());
        }

        public Member getNotifyMember() {
            return this.__m_NotifyMember;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Grid service = this.getService();
            Member member = this.getNotifyMember();
            service.getServiceMemberSet().setServiceLeaving(member.getId());
            service.dispatchMemberEvent(member, 2);
        }

        public void setNotifyMember(Member member) {
            this.__m_NotifyMember = member;
        }
    }

    public static class NotifyServiceLeft
    extends Message
    implements Continuation {
        private Member __m_NotifyMember;

        public NotifyServiceLeft() {
            this(null, null, true);
        }

        public NotifyServiceLeft(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-12);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyServiceLeft();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyServiceLeft".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public String getDescription() {
            return "NotifyMember=" + String.valueOf(this.getNotifyMember());
        }

        public Member getNotifyMember() {
            return this.__m_NotifyMember;
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Grid service = this.getService();
            Member member = this.getNotifyMember();
            int nMember = member.getId();
            NotifyServiceLeft._assert(nMember != service.getThisMember().getId());
            ServiceMemberSet setMember = service.getServiceMemberSet();
            if (setMember.getState(nMember) == 1) {
                NotifyServiceLeft._trace("Aborted join protocol for " + service.collectTransportStats(member) + "\n" + service.formatStats(true), 3);
            }
            MessageHandler handler = service.getMessageHandler();
            EndPoint peer = setMember.getServiceEndPoint(nMember);
            if (peer == null || handler == null) {
                this.proceed((Object)null);
            } else {
                service.getDepartingMembers().add(member);
                handler.release(peer, this);
            }
        }

        public void proceed(Object oResult) {
            Grid service = this.getService();
            Member member = this.getNotifyMember();
            NotifyServiceLeft._assert(Thread.currentThread() == service.getThread());
            service.onNotifyServiceLeft(member);
            service.processServiceLeftActions(member);
        }

        public void setNotifyMember(Member member) {
            this.__m_NotifyMember = member;
        }
    }

    public static class NotifyServiceQuiescence
    extends RequestMessage {
        private NotifyResponse __m_ContinuationMessage;
        private boolean __m_Resume;
        private boolean __m_ResumeOnFailover;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public NotifyServiceQuiescence() {
            this(null, null, true);
        }

        public NotifyServiceQuiescence(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-22);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyServiceQuiescence();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyServiceQuiescence".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public NotifyResponse getContinuationMessage() {
            return this.__m_ContinuationMessage;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (Poll)this._newChild("Poll");
        }

        public boolean isResume() {
            return this.__m_Resume;
        }

        protected boolean isResumeOnFailover() {
            return this.__m_ResumeOnFailover;
        }

        @Override
        public void onReceived() {
            Grid service = this.getService();
            boolean fResume = this.isResume();
            NotifyResponse msgResponse = (NotifyResponse)service.instantiateMessage("NotifyResponse");
            LinkedList<NotifyResponse> colResp = service.getPendingQuiescenceResponses();
            service.onNotifyServiceQuiescence(fResume, this.isResumeOnFailover());
            msgResponse.respondTo(this);
            if (fResume) {
                if (colResp != null) {
                    Iterator iter = colResp.iterator();
                    while (iter.hasNext()) {
                        service.post((NotifyResponse)iter.next());
                    }
                    service.setPendingQuiescenceResponses(null);
                }
                service.post(msgResponse);
            } else if (!service.isAcceptingClients() || service.isSuspendedFully()) {
                service.post(msgResponse);
            } else {
                if (colResp == null) {
                    colResp = new LinkedList<NotifyResponse>();
                    service.setPendingQuiescenceResponses(colResp);
                }
                colResp.add(msgResponse);
            }
        }

        public void setContinuationMessage(NotifyResponse responseMessage) {
            this.__m_ContinuationMessage = responseMessage;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        public void setResume(boolean fResume) {
            this.__m_Resume = fResume;
        }

        public void setResumeOnFailover(boolean fResume) {
            this.__m_ResumeOnFailover = fResume;
        }

        static {
            NotifyServiceQuiescence.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyServiceQuiescence$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                NotifyServiceQuiescence msgReq = (NotifyServiceQuiescence)this.get_Parent();
                NotifyResponse msgContinuation = msgReq.getContinuationMessage();
                if (msgContinuation != null) {
                    msgContinuation.setResult(this.getResult());
                    msgContinuation.getService().send(msgContinuation);
                }
            }

            @Override
            public void onResponse(Message msg) {
                NotifyResponse msgResponse = (NotifyResponse)msg;
                this.setResult(msgResponse.getResult());
                super.onResponse(msg);
            }
        }
    }

    public static class NotifyShutdown
    extends Message {
        public NotifyShutdown() {
            this(null, null, true);
        }

        public NotifyShutdown(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-13);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyShutdown();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyShutdown".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            Grid service = this.getService();
            service.setServiceState(3);
            service.stop();
        }
    }

    public static class NotifyStartup
    extends Message {
        public NotifyStartup() {
            this(null, null, true);
        }

        public NotifyStartup(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(-14);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new NotifyStartup();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$NotifyStartup".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onReceived() {
            super.onReceived();
            this.getService().setServiceState(2);
        }
    }

    public static class PingRequest
    extends RequestMessage {
        private transient Continuation __m_Continuation;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Poll", Poll.get_CLASS());
        }

        public PingRequest() {
            this(null, null, true);
        }

        public PingRequest(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(3);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PingRequest();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$PingRequest".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public Continuation getContinuation() {
            return this.__m_Continuation;
        }

        @Override
        protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
            return (Poll)this._newChild("Poll");
        }

        @Override
        public void onReceived() {
            Grid service = this.getService();
            Message msg = service.instantiateMessage("Response");
            msg.respondTo(this);
            service.post(msg);
        }

        public void setContinuation(Continuation continuation) {
            this.__m_Continuation = continuation;
        }

        @Override
        public void setRequestTimeout(long ldtTimeout) {
            super.setRequestTimeout(ldtTimeout);
        }

        static {
            PingRequest.__initStatic();
        }

        public static class Poll
        extends com.tangosol.coherence.component.net.Poll {
            public Poll() {
                this(null, null, true);
            }

            public Poll(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Poll();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$PingRequest$Poll".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onCompletion() {
                Continuation continuation = ((PingRequest)this.get_Parent()).getContinuation();
                if (continuation != null) {
                    continuation.proceed(this.getRespondedMemberSet().isEmpty() ? Boolean.FALSE : Boolean.TRUE);
                }
            }
        }
    }

    public static class ProtocolContext
    extends Util
    implements ProtocolAwareStream.ProtocolContext {
        private Message __m_Message;

        public ProtocolContext() {
            this(null, null, true);
        }

        public ProtocolContext(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ProtocolContext();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ProtocolContext".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public com.tangosol.net.Member getFromMember() {
            return this.getMessage().getFromMember();
        }

        public Message getMessage() {
            return this.__m_Message;
        }

        @Override
        public com.tangosol.net.Service getService() {
            return this.getMessage().getService();
        }

        @Override
        public Set getToMemberSet() {
            Message msg = this.getMessage();
            Set setTo = msg.getToMemberSet();
            if (setTo == null && msg instanceof DiscoveryMessage) {
                setTo = Collections.singleton(((DiscoveryMessage)msg).getToMember());
            }
            return setTo;
        }

        @Override
        public boolean isClusterService() {
            return this.getMessage().getService().getServiceId() == 0;
        }

        @Override
        public boolean isInductionMessage() {
            return this.getMessage() instanceof ClusterService.NewMemberRequestIdReply;
        }

        public void setMessage(Message pMessage) {
            this.__m_Message = pMessage;
        }

        @Override
        public String toString() {
            return this.getMessage().toString();
        }
    }

    public static class Response
    extends SimpleResponse {
        public Response() {
            this(null, null, true);
        }

        public Response(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setMessageType(2);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Response();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$Response".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }
    }

    public static class WrapperGuardable
    extends Component
    implements Guardable {
        private Guardable __m_Guardable;

        public WrapperGuardable() {
            this(null, null, true);
        }

        public WrapperGuardable(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new WrapperGuardable();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$WrapperGuardable".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public boolean equals(Object obj) {
            return Base.equals(obj instanceof WrapperGuardable ? ((WrapperGuardable)obj).getGuardable() : obj, this.getGuardable());
        }

        @Override
        public Guardian.GuardContext getContext() {
            return this.getGuardable().getContext();
        }

        public Guardable getGuardable() {
            return this.__m_Guardable;
        }

        public Grid getService() {
            return (Grid)this.get_Module();
        }

        public ServiceFailurePolicy getServiceFailurePolicy() {
            return this.getService().getServiceFailurePolicy();
        }

        public int hashCode() {
            return this.getGuardable().hashCode();
        }

        @Override
        public void recover() {
            Grid service = this.getService();
            ((com.tangosol.coherence.component.net.Cluster)service.getCluster()).onGuardableRecover();
            this.reportOutstandingPolls();
            service.reportTransportStats();
            WrapperGuardable._trace(service.formatStats(true), 5);
            this.getServiceFailurePolicy().onGuardableRecovery(this.getGuardable(), service);
        }

        protected void reportOutstandingPolls() {
            Guardian.GuardContext ctx = this.getContext();
            long cTimeoutMillis = ctx == null ? this.getService().getDefaultGuardTimeout() : ctx.getSoftTimeoutMillis();
            List listPolls = this.getService().getOutstandingPolls(cTimeoutMillis >> 1);
            if (listPolls.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder("\n\n *** Outstanding polls: ***");
            Iterator iter = listPolls.iterator();
            while (iter.hasNext() && sb.length() < 32000) {
                sb.append('\n').append(iter.next());
            }
            sb.append("\n *** Service Stats: ***\n").append(this.getService().formatStats(true));
            WrapperGuardable._trace(sb.toString(), 1);
        }

        @Override
        public void setContext(Guardian.GuardContext context) {
            this.getGuardable().setContext(context);
        }

        public void setGuardable(Guardable guardable) {
            this.__m_Guardable = guardable;
        }

        @Override
        public void terminate() {
            Grid service = this.getService();
            ((com.tangosol.coherence.component.net.Cluster)service.getCluster()).onGuardableTerminate();
            this.reportOutstandingPolls();
            service.reportTransportStats();
            WrapperGuardable._trace(service.formatStats(true), 5);
            this.getServiceFailurePolicy().onGuardableTerminate(this.getGuardable(), service);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{WrapperGuardable ").append(this.getGuardable().toString()).append(" Service=").append(this.getService()).append('}');
            return sb.toString();
        }
    }

    public static class ServiceConfig
    extends com.tangosol.coherence.component.util.ServiceConfig {
        public ServiceConfig() {
            this(null, null, true);
        }

        public ServiceConfig(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setPendingConfigUpdates(new LinkedList());
                this.setPendingPolls(new LiteMap());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new ServiceConfig.ConfigListener("ConfigListener", this, true), "ConfigListener");
            this._addChild(new Map("Map", this, true), "Map");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ServiceConfig();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ServiceConfig".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public static class Map
        extends ServiceConfig.Map {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("EntrySet", EntrySet.get_CLASS());
                __mapChildren.put("KeySet", KeySet.get_CLASS());
                __mapChildren.put("Values", Values.get_CLASS());
            }

            public Map() {
                this(null, null, true);
            }

            public Map(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Map();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ServiceConfig$Map".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected java.util.Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            public int getMapType() {
                return 1;
            }

            static {
                Map.__initStatic();
            }

            public static class EntrySet
            extends ServiceConfig.Map.EntrySet {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Entry", Entry.get_CLASS());
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public EntrySet() {
                    this(null, null, true);
                }

                public EntrySet(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new EntrySet();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ServiceConfig$Map$EntrySet".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected java.util.Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    EntrySet.__initStatic();
                }

                public static class Entry
                extends ServiceConfig.Map.EntrySet.Entry {
                    public Entry() {
                        this(null, null, true);
                    }

                    public Entry(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Entry();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ServiceConfig$Map$EntrySet$Entry".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }

                public static class Iterator
                extends ServiceConfig.Map.EntrySet.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ServiceConfig$Map$EntrySet$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }

            public static class KeySet
            extends ServiceConfig.Map.KeySet {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public KeySet() {
                    this(null, null, true);
                }

                public KeySet(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new KeySet();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ServiceConfig$Map$KeySet".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected java.util.Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    KeySet.__initStatic();
                }

                public static class Iterator
                extends ServiceConfig.Map.KeySet.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ServiceConfig$Map$KeySet$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }

            public static class Values
            extends ServiceConfig.Map.Values {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Iterator", Iterator.get_CLASS());
                }

                public Values() {
                    this(null, null, true);
                }

                public Values(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Values();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ServiceConfig$Map$Values".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected java.util.Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    Values.__initStatic();
                }

                public static class Iterator
                extends ServiceConfig.Map.Values.Iterator {
                    public Iterator() {
                        this(null, null, true);
                    }

                    public Iterator(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Iterator();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ServiceConfig$Map$Values$Iterator".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }
        }
    }

    public static class PollArray
    extends ConcurrentWindowedArray {
        private NullableSortedMap __m_ExpiryMap;
        private transient long __m_LastNullPollId;
        private transient long __m_LastNullPollIdTimeout;
        public static final long POLL_EXPIRY_RESOLUTION = 256L;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("PlaceHolder", PlaceHolder.get_CLASS());
        }

        public PollArray() {
            this(null, null, true);
        }

        public PollArray(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setExpiryMap(new NullableSortedMap());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new PollArray();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$PollArray".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public long add(Object o) {
            Poll poll = (Poll)o;
            PollArray._assert(poll.getService() == null && poll.getPollId() == 0L && !poll.isClosed());
            Grid service = (Grid)this.get_Module();
            poll.setService(service);
            poll.setTracingSpan(service.newTracingSpan("request", poll).startSpan());
            Set setExpiry = this.getExpirySet(poll);
            if (setExpiry != null) {
                Set setExpiryPost = setExpiry;
                do {
                    setExpiry = setExpiryPost;
                    setExpiry.add(poll);
                } while (setExpiry != (setExpiryPost = this.getExpirySet(poll)));
            }
            return super.add(o);
        }

        @Override
        protected void assignIndexToValue(long lVirtual, Object o) {
            ((Poll)o).setPollId(lVirtual);
        }

        public void checkPolls() {
            long ldtNow = Base.getSafeTimeMillis();
            this.validatePolls(ldtNow);
            this.expirePolls(ldtNow);
        }

        protected void expirePolls(long ldt) {
            NullableSortedMap map = (NullableSortedMap)this.getExpiryMap();
            try {
                if (map.isEmpty() || (Long)map.firstKey() > ldt) {
                    return;
                }
            }
            catch (NoSuchElementException e) {
                return;
            }
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                long ldtExpiry = (Long)entry.getKey();
                if (ldtExpiry > ldt) {
                    return;
                }
                iter.remove();
                Iterator iterPoll = ((Set)entry.getValue()).iterator();
                while (iterPoll.hasNext()) {
                    ((Poll)iterPoll.next()).close();
                }
            }
        }

        @Override
        public Object get(long lVirtual) {
            if (lVirtual == 0L) {
                return null;
            }
            Object o = this.optimisticGet(lVirtual);
            return o == null ? super.get(lVirtual) : o;
        }

        public Map getExpiryMap() {
            return this.__m_ExpiryMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set getExpirySet(Poll poll) {
            Long LdtGroup;
            long ldtExpiry = poll.getExpiryTimeMillis();
            if (ldtExpiry <= 0L || ldtExpiry >= 0x7FFFFFFFFFFFFEFFL) {
                return null;
            }
            Map mapExpiry = this.getExpiryMap();
            Set setPoll = (Set)mapExpiry.get(LdtGroup = Long.valueOf(ldtExpiry + 256L - 1L & 0xFFFFFFFFFFFFFF00L));
            if (setPoll == null) {
                Map map = mapExpiry;
                synchronized (map) {
                    setPoll = (Set)mapExpiry.get(LdtGroup);
                    if (setPoll == null) {
                        setPoll = new InflatableSet();
                    }
                    mapExpiry.put(LdtGroup, setPoll);
                }
            }
            return setPoll;
        }

        public long getLastNullPollId() {
            return this.__m_LastNullPollId;
        }

        public long getLastNullPollIdTimeout() {
            return this.__m_LastNullPollIdTimeout;
        }

        @Override
        public Object remove(long lVirtual) {
            Set setExpiry;
            Poll poll = (Poll)super.remove(lVirtual);
            if (poll != null && (setExpiry = this.getExpirySet(poll)) != null) {
                setExpiry.remove(poll);
            }
            return poll;
        }

        @Override
        protected long retrieveIndexFromValue(Object o) {
            return ((Poll)o).getPollId();
        }

        protected void setExpiryMap(Map mapExpiry) {
            this.__m_ExpiryMap = (NullableSortedMap)mapExpiry;
        }

        public void setLastNullPollId(long pLastNullPollId) {
            this.__m_LastNullPollId = pLastNullPollId;
        }

        protected void setLastNullPollIdTimeout(long ldtTimeout) {
            this.__m_LastNullPollIdTimeout = ldtTimeout;
        }

        protected void validatePolls(long ldtNow) {
            try {
                boolean fEmpty;
                long lFirst = this.getFirstIndex();
                long lLast = this.getLastIndex();
                boolean bl = fEmpty = lFirst > lLast;
                if (fEmpty) {
                    return;
                }
                Poll poll = (Poll)this.get(lFirst);
                if (poll == null) {
                    long lLastNullPollId = this.getLastNullPollId();
                    if (lLastNullPollId == lFirst) {
                        if (this.getLastNullPollIdTimeout() < ldtNow) {
                            this.remove(lFirst);
                            PollArray._trace("validatePolls: Removed empty poll element #" + lFirst + " from array " + this.formatStats(), 1);
                        }
                    } else {
                        this.setLastNullPollId(lFirst);
                        Guardian.GuardContext ctx = ((Grid)this.get_Module()).getGuardable().getContext();
                        this.setLastNullPollIdTimeout(ldtNow + (ctx == null ? 1000L : ctx.getSoftTimeoutMillis()));
                    }
                    return;
                }
                Grid service = (Grid)this.get_Module();
                long cMillisAge = ldtNow - poll.getInitTimeMillis();
                if (cMillisAge < service.getStartupTimeout() >>> 1) {
                    return;
                }
                if (poll.getPollId() > service.getSuspendPollLimit().get()) {
                    return;
                }
                this.validatePollsExtra(poll, lFirst, lLast, cMillisAge, ldtNow);
            }
            catch (Throwable e) {
                PollArray._trace("validatePolls: Non-fatal exception detected during processing:", 1);
                PollArray._trace(e);
                PollArray._trace("validatePolls: Exception has been logged; continuing processing.", 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void validatePollsExtra(Poll poll, long lFirst, long lLast, long cMillisAge, long ldtNow) {
            Object sPoll = poll.getClass().getName();
            try {
                sPoll = poll.toString();
                if (poll.get_Parent() != null) {
                    sPoll = (String)sPoll + "\nRequest=" + poll.get_Parent().toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Poll poll2 = poll;
            synchronized (poll2) {
                if (lFirst != this.getFirstIndex()) {
                    return;
                }
                if (poll.isClosed()) {
                    this.remove(lFirst);
                    PollArray._trace("validatePolls: Removed closed poll: " + (String)sPoll + " from array " + this.formatStats(), 1);
                    return;
                }
                MemberSet setRemain = poll.getRemainingMemberSet();
                if (setRemain == null || setRemain.isEmpty()) {
                    poll.close();
                    PollArray._trace("validatePolls: Closed poll that had no remaining members: " + (String)sPoll + " within array " + this.formatStats(), 1);
                    return;
                }
                Grid service = (Grid)this.get_Module();
                ServiceMemberSet setService = service.getServiceMemberSet();
                MasterMemberSet setMaster = service.getClusterMemberSet();
                boolean fClose = false;
                int nMember = setRemain.getFirstId();
                while (nMember > 0) {
                    if (!setService.contains(nMember)) {
                        Member member;
                        MasterMemberSet masterMemberSet = setMaster;
                        synchronized (masterMemberSet) {
                            member = setMaster.getMember(nMember);
                        }
                        if (member == null) {
                            member = setMaster.getRecycleSet().getMember(nMember);
                            if (member == null) {
                                fClose = setRemain.size() == 1 || cMillisAge > 60000L;
                            } else if (ldtNow > member.getTimestamp() + 30000L) {
                                poll.onLeft(member);
                                PollArray._trace("validatePolls: Removed missing member " + String.valueOf(member) + " from poll: " + (String)sPoll + " within array " + this.formatStats(), 1);
                            }
                        }
                    }
                    nMember = setRemain.getNextId(nMember);
                }
                if (poll.isClosed()) {
                    return;
                }
                if (fClose) {
                    poll.close();
                    PollArray._trace("validatePolls: Closed poll that had missing member: " + (String)sPoll + " within array " + this.formatStats(), 1);
                    return;
                }
                StringBuilder sbRemain = new StringBuilder("\nRemaining members info:\n  {");
                int nMember2 = setRemain.getFirstId();
                while (nMember2 > 0) {
                    Member member = setMaster.getMember(nMember2);
                    if (member != null) {
                        sbRemain.append("\n  ").append(service.collectTransportStats(member));
                    }
                    nMember2 = setRemain.getNextId(nMember2);
                }
                sbRemain.append("\n  }");
                long cGap = lLast - lFirst;
                if (cGap > 0x400000L) {
                    poll.close();
                    PollArray._trace("validatePolls: Manual intervention is required to stop this node or the members that have not responded to this poll (gap size=" + cGap + "): " + (String)sPoll + String.valueOf(sbRemain) + " within array " + this.formatStats(), 1);
                } else if (service.getServiceState() == 4 && !service.isAcceptingClients()) {
                    PollArray._trace("validatePolls: This service timed-out due to unanswered handshake request. Manual intervention is required to stop the members that have not responded to this " + (String)sPoll + String.valueOf(sbRemain) + "\n" + service.formatStats(true), 1);
                }
            }
        }

        static {
            PollArray.__initStatic();
        }

        public static class PlaceHolder
        extends ConcurrentWindowedArray.PlaceHolder {
            public PlaceHolder() {
                this(null, null, true);
            }

            public PlaceHolder(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setVirtualOffset(-1L);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new PlaceHolder();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$PollArray$PlaceHolder".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class EventDispatcher
    extends Service.EventDispatcher {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Queue", Service.EventDispatcher.Queue.get_CLASS());
        }

        public EventDispatcher() {
            this(null, null, true);
        }

        public EventDispatcher(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setCloggedCount(1024);
                this.setCloggedDelay(32);
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new Service.EventDispatcher.Guard("Guard", this, true), "Guard");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EventDispatcher();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$EventDispatcher".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        public Grid getService() {
            return (Grid)this.get_Module();
        }

        @Override
        protected void onEnter() {
            super.onEnter();
            ContainerHelper.initializeThreadContext((Grid)this.get_Module());
        }

        static {
            EventDispatcher.__initStatic();
        }
    }

    public static class Guard
    extends Daemon.Guard {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("StopService", StopService.get_CLASS());
        }

        public Guard() {
            this(null, null, true);
        }

        public Guard(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Guard();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$Guard".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void terminate() {
            Grid service = (Grid)this.get_Parent();
            Thread threadStop = Base.makeThread(null, (Runnable)((Object)this._newChild("StopService")), "StopService");
            threadStop.setDaemon(true);
            threadStop.start();
            Grid.sleep(1000L);
            if (service.getServiceState() != 4) {
                try {
                    Thread threadService = service.getThread();
                    Guard._trace("onServiceFailed: Failed to stop service " + service.getServiceName() + " with state=" + service.getServiceState() + ", isAlive=" + (threadService != null && threadService.isAlive() ? "true" : "false") + ", stop service thread isAlive=" + threadStop.isAlive(), 1);
                    if (threadService != null && threadService.isAlive()) {
                        Guard._trace("onServiceFailed: Service thread: " + Base.getStackTrace(threadService), 1);
                    }
                    if (threadStop.isAlive()) {
                        Guard._trace("onServiceFailed: Stop service thread: " + Base.getStackTrace(threadStop), 1);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                service.getServiceFailurePolicy().onServiceFailed(service.getCluster());
            }
        }

        static {
            Guard.__initStatic();
        }

        public static class StopService
        extends Component
        implements Runnable {
            public StopService() {
                this(null, null, true);
            }

            public StopService(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new StopService();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$Guard$StopService".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void run() {
                ((Grid)this.get_Module()).stop();
            }
        }
    }

    public static class ReceiveQueue
    extends SingleConsumerQueue {
        private transient boolean __m_PreprocessingEnabled;

        public ReceiveQueue() {
            this(null, null, true);
        }

        public ReceiveQueue(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setBatchSize(1);
                this.setDelegate(new ConcurrentLinkedQueue());
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ReceiveQueue();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$ReceiveQueue".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public boolean add(Object oElement) {
            return this.isPreprocessingEnabled() && ((Message)oElement).preprocess() || super.add(oElement);
        }

        public boolean isPreprocessingEnabled() {
            return this.__m_PreprocessingEnabled;
        }

        @Override
        public void onInit() {
            this.setPreprocessingEnabled(Boolean.parseBoolean(Config.getProperty("coherence.grid.preprocess", "true")));
            this.setBatchSize(Integer.parseInt(Config.getProperty("coherence.service.batch", "8")));
            super.onInit();
        }

        protected void setPreprocessingEnabled(boolean fEnabled) {
            this.__m_PreprocessingEnabled = fEnabled;
        }
    }

    public static class MemberConfigListener
    extends Util
    implements MapListener {
        public MemberConfigListener() {
            this(null, null, true);
        }

        public MemberConfigListener(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new MemberConfigListener();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$MemberConfigListener".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public void entryDeleted(MapEvent event) {
            this.onEvent(event);
        }

        public void entryInserted(MapEvent event) {
            this.onEvent(event);
        }

        public void entryUpdated(MapEvent event) {
            this.onEvent(event);
        }

        protected void onEvent(MapEvent event) {
            Grid service = (Grid)this.get_Module();
            MemberConfigUpdate msg = (MemberConfigUpdate)service.instantiateMessage("MemberConfigUpdate");
            msg.setKey(event.getKey());
            msg.setValue(event.getNewValue());
            msg.setRemove(event.getId() == 3);
            msg.setToMemberSet(service.getOthersMemberSet());
            service.send(msg);
        }
    }

    public static class DaemonPool
    extends Service.DaemonPool {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Daemon", Daemon.get_CLASS());
            __mapChildren.put("ResizeTask", Service.DaemonPool.ResizeTask.get_CLASS());
            __mapChildren.put("ScheduleTask", Service.DaemonPool.ScheduleTask.get_CLASS());
            __mapChildren.put("StartTask", Service.DaemonPool.StartTask.get_CLASS());
            __mapChildren.put("StopTask", Service.DaemonPool.StopTask.get_CLASS());
            __mapChildren.put("WorkSlot", Service.DaemonPool.WorkSlot.get_CLASS());
            __mapChildren.put("WrapperTask", Service.DaemonPool.WrapperTask.get_CLASS());
        }

        public DaemonPool() {
            this(null, null, true);
        }

        public DaemonPool(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAbandonThreshold(8);
                this.setDaemonCountMax(Integer.MAX_VALUE);
                this.setDaemonCountMin(1);
                this.setScheduledTasks(new HashSet());
                this.setStatsTaskAddCount(new AtomicLong());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DaemonPool();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$DaemonPool".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        static {
            DaemonPool.__initStatic();
        }

        public static class Daemon
        extends Service.DaemonPool.Daemon {
            public Daemon() {
                this(null, null, true);
            }

            public Daemon(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setDaemonState(0);
                    this.setDefaultGuardRecovery(0.9f);
                    this.setDefaultGuardTimeout(60000L);
                    this.setNotifier(new SingleWaiterMultiNotifier());
                    this.setThreadName("Worker");
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new Service.DaemonPool.Daemon.Guard("Guard", this, true), "Guard");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Daemon();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/service/Grid$DaemonPool$Daemon".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected void onEnter() {
                super.onEnter();
                ContainerHelper.initializeThreadContext((Grid)this.get_Module());
            }

            @Override
            protected void onExit() {
                ((Grid)this.get_Module()).flush();
                super.onExit();
            }

            @Override
            protected void onWait() throws InterruptedException {
                ((Grid)this.get_Module()).flush();
                super.onWait();
            }
        }
    }
}

