/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.PacketBundle;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.coherence.component.util.queue.concurrentQueue.BalancedQueue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.balancedQueue.BundlingQueue;
import com.tangosol.coherence.config.Config;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.util.Map;

public class PacketSpeaker
extends PacketProcessor {
    private transient long __m_StatsCpu;
    private transient long __m_StatsReset;
    private transient long __m_StatsSent;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("BundlingQueue", BundlingQueue.get_CLASS());
        __mapChildren.put("InQueue", InQueue.get_CLASS());
    }

    public PacketSpeaker() {
        this(null, null, true);
    }

    public PacketSpeaker(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Daemon.Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new PacketSpeaker();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketSpeaker".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public String formatStats() {
        long ldtNow = Base.getSafeTimeMillis();
        long cCpu = this.getStatsCpu();
        long cTotal = ldtNow - this.getStartTimestamp();
        long lSent = this.getStatsSent();
        double dCpu = cTotal == 0L ? 0.0 : (double)cCpu / (double)cTotal;
        double dThru = cCpu == 0L ? 0.0 : (double)lSent * 1000.0 / (double)cCpu;
        dCpu = (double)((int)(dCpu * 1000.0)) / 10.0;
        return "Cpu=" + cCpu + "ms (" + dCpu + "%), PacketsSent=" + lSent + ", Throughput=" + (int)dThru + "pkt/sec, Queued=" + this.getQueue().size();
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    @Override
    protected Queue instantiateQueue() {
        return (BundlingQueue)this._newChild("BundlingQueue");
    }

    @Override
    protected void onEnter() {
        super.onEnter();
        ((BundlingQueue)this.getQueue()).setSpeakerEnabled(true);
    }

    @Override
    protected void onExit() {
        ((BundlingQueue)this.getQueue()).setSpeakerEnabled(false);
        super.onExit();
    }

    @Override
    protected void onNotify() {
        Queue queue = this.getQueue();
        int cPackets = 0;
        long ldtStart = System.currentTimeMillis();
        while (!this.isExiting()) {
            PacketBundle bundle = (PacketBundle)queue.removeNoWait();
            if (bundle == null) {
                this.updateStats(cPackets, ldtStart);
                bundle = (PacketBundle)queue.remove();
                cPackets = 0;
                ldtStart = System.currentTimeMillis();
            }
            if ((cPackets += bundle.getAddressCount()) > 30000) {
                this.updateStats(cPackets, ldtStart);
                cPackets = 0;
                ldtStart = System.currentTimeMillis();
            }
            try {
                bundle.send();
            }
            catch (RuntimeException e) {
                if (this.isExiting()) {
                    return;
                }
                if (bundle.getUdpSocket().getState() == 2) continue;
                throw e;
            }
        }
    }

    @Override
    protected void onWait() throws InterruptedException {
    }

    public void resetStats() {
        this.setStatsSent(0L);
        this.setStatsCpu(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
        ((BundlingQueue)this.getQueue()).resetStats();
    }

    protected void setStatsCpu(long lMillis) {
        this.__m_StatsCpu = lMillis;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    protected void setStatsSent(long cPackets) {
        this.__m_StatsSent = cPackets;
    }

    @Override
    public String toString() {
        return this.get_Name() + ":" + this.formatStats();
    }

    protected void updateStats(int cPackets, long ldtStart) {
        if (cPackets > 0) {
            long lDelta = System.currentTimeMillis() - ldtStart;
            if (lDelta > 0L) {
                this.setStatsCpu(this.getStatsCpu() + lDelta);
            }
            this.setStatsSent(this.getStatsSent() + (long)cPackets);
        }
    }

    static {
        PacketSpeaker.__initStatic();
    }

    public static class BundlingQueue
    extends com.tangosol.coherence.component.util.queue.concurrentQueue.balancedQueue.BundlingQueue {
        private int __m_CloggedCount;
        private int __m_CloggedDelay;
        public static final Object MULTIPOINT_TARGET;
        private transient int __m_PendingAsyncFlushCount;
        private boolean __m_SpeakerEnabled;
        private transient int __m_SynchronousAddCount;
        private transient int __m_SynchronousSendCount;
        private transient int __m_VolumeThreshold;
        private transient boolean __m_VolumeTunable;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Iterator", Iterator.get_CLASS());
            __mapChildren.put("TargetQueue", TargetQueue.get_CLASS());
        }

        public BundlingQueue() {
            this(null, null, true);
        }

        public BundlingQueue(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setBatchSize(4);
                this.setBundlingEnabled(true);
                this.setCloggedCount(1024);
                this.setCloggedDelay(32);
                this.setElementList(new RecyclingLinkedList());
                this.setTargetMap(new SafeHashMap());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BundlingQueue();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketSpeaker$BundlingQueue".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public boolean add(Object oElement) {
            PacketBundle bundle = (PacketBundle)oElement;
            int cSyncSends = this.getSynchronousSendCount();
            int cAddr = bundle.getAddressCount();
            if (!this.isSpeakerEnabled() || this.getDeferralThresholdNanos() == 0L && this.getPendingAsyncFlushCount() == 0 && cSyncSends <= this.getVolumeThreshold() && this.isEmpty()) {
                block4: {
                    try {
                        bundle.send();
                        this.setSynchronousSendCount(cSyncSends + cAddr);
                    }
                    catch (Exception e) {
                        if (bundle.getUdpSocket().getState() == 2) break block4;
                        throw Base.ensureRuntimeException(e);
                    }
                }
                return false;
            }
            if (this.size() > this.getCloggedCount()) {
                this.drainOverflow();
            }
            this.setSynchronousAddCount(this.getSynchronousAddCount() + cAddr);
            return super.add(oElement);
        }

        protected void drainOverflow() {
            int cMaxPackets = this.getCloggedCount();
            if (cMaxPackets == 0) {
                return;
            }
            PacketSpeaker speaker = (PacketSpeaker)this.get_Module();
            long ldtStart = Base.getSafeTimeMillis();
            long ldtAlarmNext = ldtStart + 10000L;
            long cDelayMillis = this.getCloggedDelay();
            this.flush();
            int cPackets = this.size();
            while (cPackets > cMaxPackets) {
                if (!PacketSpeaker.sleep(cDelayMillis)) break;
                long ldtNow = Base.getSafeTimeMillis();
                if (ldtNow >= ldtAlarmNext) {
                    BundlingQueue._trace("Overloaded speaker queue; " + cPackets + "/" + cMaxPackets + " packet limit, Duration=" + (ldtNow - ldtStart) / 1000L + "s", 2);
                    ldtAlarmNext = ldtNow + 10000L;
                }
                cPackets = this.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void flush(boolean fAuto) {
            boolean fUnderLimit;
            boolean fSpeakerIdle;
            int cPackets = this.size();
            if (cPackets == 0) {
                if (!fAuto) {
                    this.setSynchronousSendCount(0);
                    this.setSynchronousAddCount(0);
                }
                return;
            }
            int cPending = this.getPendingAsyncFlushCount();
            int cSyncSends = this.getSynchronousSendCount();
            int cSyncAdds = this.getSynchronousAddCount();
            double dAggression = this.getBundlingAggression();
            boolean bl = fSpeakerIdle = this.getFlushState() == 0 && cSyncAdds == cPackets;
            if (this.isVolumeTunable() && dAggression != 0.0) {
                fUnderLimit = (double)cSyncSends < (double)this.getVolumeThreshold() / (dAggression + 1.0);
            } else {
                boolean bl2 = fUnderLimit = cSyncSends < this.getVolumeThreshold();
            }
            if (fSpeakerIdle && fUnderLimit && cPending == 0) {
                PacketSpeaker speaker = (PacketSpeaker)this.get_Module();
                long cNanos = this.getDeferralThresholdNanos();
                try {
                    if (cNanos != 0L) {
                        this.setDeferralThresholdNanos(0L);
                    }
                    Object oNext = this.removeNoWait();
                    while (oNext != null) {
                        block15: {
                            PacketBundle bundle = (PacketBundle)oNext;
                            try {
                                bundle.send();
                                cSyncSends += bundle.getAddressCount();
                            }
                            catch (Exception e) {
                                if (bundle.getUdpSocket().getState() == 2) break block15;
                                throw Base.ensureRuntimeException(e);
                            }
                        }
                        oNext = this.removeNoWait();
                    }
                }
                finally {
                    if (cNanos != 0L) {
                        this.setDeferralThresholdNanos(cNanos);
                    }
                }
                if (!fAuto) {
                    cSyncSends = 0;
                }
            } else {
                super.flush(fAuto);
                cSyncSends = 0;
                this.setPendingAsyncFlushCount(fUnderLimit ? Math.max(0, cPending - 1) : Math.min(1024, cPending + (int)dAggression));
            }
            this.setSynchronousAddCount(0);
            this.setSynchronousSendCount(cSyncSends);
        }

        public int getCloggedCount() {
            return this.__m_CloggedCount;
        }

        public int getCloggedDelay() {
            return this.__m_CloggedDelay;
        }

        public int getPendingAsyncFlushCount() {
            return this.__m_PendingAsyncFlushCount;
        }

        public int getSynchronousAddCount() {
            return this.__m_SynchronousAddCount;
        }

        public int getSynchronousSendCount() {
            return this.__m_SynchronousSendCount;
        }

        @Override
        public Object getTarget(Object oElement) {
            PacketBundle bundle = (PacketBundle)oElement;
            return bundle.getAddressCount() == 1 ? bundle.getAddress(0) : MULTIPOINT_TARGET;
        }

        public int getVolumeThreshold() {
            return this.__m_VolumeThreshold;
        }

        public boolean isSpeakerEnabled() {
            return this.__m_SpeakerEnabled;
        }

        public boolean isVolumeTunable() {
            return this.__m_VolumeTunable;
        }

        @Override
        public void onInit() {
            this.setBundlingEnabled(Boolean.valueOf(Config.getProperty("coherence.speaker.bundling.enabled", "true")));
            this.setBatchSize(Integer.parseInt(Config.getProperty("coherence.speaker.batch", "8")));
            super.onInit();
        }

        public void setCloggedCount(int nCount) {
            this.__m_CloggedCount = nCount;
        }

        public void setCloggedDelay(int nDelay) {
            this.__m_CloggedDelay = Math.max(1, nDelay);
        }

        public void setPendingAsyncFlushCount(int cFlush) {
            this.__m_PendingAsyncFlushCount = cFlush;
        }

        public void setSpeakerEnabled(boolean fEnabled) {
            this.__m_SpeakerEnabled = fEnabled;
        }

        protected void setSynchronousAddCount(int cPackets) {
            this.__m_SynchronousAddCount = cPackets;
        }

        protected void setSynchronousSendCount(int cPackets) {
            this.__m_SynchronousSendCount = cPackets;
        }

        public void setVolumeThreshold(int nThreshold) {
            this.__m_VolumeThreshold = nThreshold;
        }

        public void setVolumeTunable(boolean fTuneable) {
            this.__m_VolumeTunable = fTuneable;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            sb.append(", threshold=").append(this.getVolumeThreshold());
            return sb.toString();
        }

        public void tuneVolumeThreshold(int cPacketsBacklog) {
            if (this.isVolumeTunable()) {
                int nVolume = this.getVolumeThreshold();
                if (cPacketsBacklog > 0) {
                    if (nVolume > 0) {
                        nVolume -= Math.max(1, Math.min(cPacketsBacklog << 4, nVolume >>> 2));
                        this.setVolumeThreshold(nVolume);
                    }
                } else if (this.getSynchronousSendCount() >= nVolume) {
                    nVolume += Math.max(1, nVolume);
                    this.setVolumeThreshold(nVolume);
                }
            }
        }

        static {
            try {
                MULTIPOINT_TARGET = new Object();
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            BundlingQueue.__initStatic();
        }

        public static class Iterator
        extends Queue.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketSpeaker$BundlingQueue$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class TargetQueue
        extends BundlingQueue.TargetQueue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public TargetQueue() {
                this(null, null, true);
            }

            public TargetQueue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setElementList(new RecyclingLinkedList());
                    this.setHeadElementList(new RecyclingLinkedList());
                    this.setHeadLock(new Object());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new TargetQueue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketSpeaker$BundlingQueue$TargetQueue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            protected boolean bundle(Object oSrc, Object oDst) {
                return ((PacketBundle)oDst).append((PacketBundle)oSrc);
            }

            static {
                TargetQueue.__initStatic();
            }

            public static class Iterator
            extends BalancedQueue.TargetQueue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketSpeaker$BundlingQueue$TargetQueue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }

    public static class InQueue
    extends DualQueue {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Iterator", Iterator.get_CLASS());
        }

        public InQueue() {
            this(null, null, true);
        }

        public InQueue(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setBatchSize(1);
                this.setElementList(new RecyclingLinkedList());
                this.setHeadElementList(new RecyclingLinkedList());
                this.setHeadLock(new Object());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new InQueue();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketSpeaker$InQueue".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        static {
            InQueue.__initStatic();
        }

        public static class Iterator
        extends Queue.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketSpeaker$InQueue$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }
}

