/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.collections.ConcurrentLinkedQueue;
import com.oracle.coherence.common.io.BufferSequence;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.PacketBundle;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.SingleMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.packet.DiagnosticPacket;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.net.packet.notifyPacket.Ack;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker;
import com.tangosol.coherence.component.util.queue.OptimisticQueue;
import com.tangosol.coherence.component.util.queue.SingleConsumerQueue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.util.MessagePublisher;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.internal.PacketComparator;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class PacketPublisher
extends PacketProcessor
implements MessagePublisher {
    private int __m_AckDelay;
    private transient List __m_AckdPacketListTemp;
    private AckQueue __m_AckQueue;
    private Set __m_BroadcastAddresses;
    private int __m_CloggedCount;
    private int __m_CloggedDelay;
    private transient ByteBuffer __m_ClusterNameBuffer;
    private ConfirmationQueue __m_ConfirmationQueue;
    private Queue __m_DeferredReadyQueue;
    private long __m_FromMessageId;
    private transient Queue[] __m_IncomingPacketQueues;
    private volatile long __m_LastTrafficJamWarningTimeMillis;
    private transient List __m_LostPacketListTemp;
    private int __m_MaximumPacketLength;
    private transient MultiBufferWriteBuffer.WriteBufferPool __m_MessageBufferAllocator;
    private WindowedArray __m_MessageOutgoing;
    private transient Message[] __m_MsgArrayTemp;
    private transient long[] __m_MsgIdArrayTemp;
    private InetSocketAddress __m_MulticastAddress;
    private transient int __m_MulticastBypassCount;
    private boolean __m_MulticastEnabled;
    private double __m_MulticastThreshold;
    private transient long __m_NackDelayMillis;
    private transient boolean __m_NackEnabled;
    private transient Queue __m_PacketAdapterQueue;
    private int __m_PreferredPacketLength;
    private int __m_ResendDelay;
    private ResendQueue __m_ResendQueue;
    private int __m_ResendTimeout;
    private transient Queue __m_SendQueue;
    private transient SingleMemberSet __m_SingleMemberSetTemp;
    private transient long __m_StatsCpu;
    private transient long __m_StatsNacksSent;
    private transient long __m_StatsResent;
    private transient long __m_StatsResentEarly;
    private transient long __m_StatsResentExcess;
    private transient long __m_StatsReset;
    private transient long __m_StatsSent;
    private UdpSocket __m_UdpSocketMulticast;
    private UnicastUdpSocket __m_UdpSocketUnicast;

    public PacketPublisher() {
        this(null, null, true);
    }

    public PacketPublisher(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setAckdPacketListTemp(new RecyclingLinkedList());
            this.setCloggedCount(1024);
            this.setCloggedDelay(32);
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setLostPacketListTemp(new RecyclingLinkedList());
            this.setMulticastEnabled(true);
            this.setMulticastThreshold(0.25);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setSingleMemberSetTemp(new SingleMemberSet());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new AckQueue("AckQueue", this, true), "AckQueue");
        this._addChild(new ConfirmationQueue("ConfirmationQueue", this, true), "ConfirmationQueue");
        this._addChild(new Daemon.Guard("Guard", this, true), "Guard");
        this._addChild(new InQueue("InQueue", this, true), "InQueue");
        this._addChild(new OutgoingMessageArray("OutgoingMessageArray", this, true), "OutgoingMessageArray");
        this._addChild(new ResendQueue("ResendQueue", this, true), "ResendQueue");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new PacketPublisher();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addressMany(PacketBundle bundle) {
        Packet packet = bundle.getPacket(0);
        if (packet instanceof MessagePacket) {
            DependentMemberSet setTo = ((MessagePacket)packet).getToMemberSet();
            if (setTo != null && packet.isConfirmationRequired()) {
                int[] anToId = setTo.toIdArray();
                int cAddrs = anToId.length;
                boolean fMulticast = false;
                if (this.isMulticastEnabled() && this.isMulticast(cAddrs)) {
                    int cBypass = this.getMulticastBypassCount();
                    if (cBypass > 0) {
                        this.setMulticastBypassCount(cBypass - 1);
                    } else if (packet.getSentCount() > 0) {
                        this.setMulticastBypassCount(Member.FlowControl.getSuccessGoal());
                    } else {
                        fMulticast = true;
                    }
                }
                if (fMulticast) {
                    bundle.setUdpSocket(this.getUdpSocketMulticast());
                    bundle.addDestination(this.getMulticastAddress());
                } else {
                    bundle.setUdpSocket(this.getUdpSocketUnicast());
                    for (int i = 0; i < cAddrs; ++i) {
                        Member member = this.getMember(anToId[i]);
                        if (member == null) continue;
                        bundle.addDestination(this.getSocketAddress(member, packet));
                    }
                }
                int cbPref = this.getPreferredPacketLength();
                long ldtNow = Base.getLastSafeTimeMillis();
                for (int i = 0; i < cAddrs; ++i) {
                    Member member = this.getMember(anToId[i]);
                    if (member == null) continue;
                    member.setLastOutgoingMillis(ldtNow);
                    cbPref = Math.min(cbPref, member.getPreferredPacketLength());
                }
                bundle.setMaximumLength(cbPref);
            } else if (packet instanceof Broadcast) {
                if (this.isMulticastEnabled() && ((Broadcast)packet).getToAddress() == null) {
                    bundle.setUdpSocket(this.getUdpSocketMulticast());
                    bundle.addDestination(this.getMulticastAddress());
                } else {
                    bundle.setUdpSocket(this.getUdpSocketUnicast());
                    if (((Broadcast)packet).getToAddress() == null) {
                        Set setBroadcast;
                        Set cAddrs = setBroadcast = this.getBroadcastAddresses();
                        synchronized (cAddrs) {
                            bundle.addDestinations(setBroadcast);
                        }
                    } else {
                        InetSocketAddress[] aAddr = ((Broadcast)packet).getToAddress();
                        int c = aAddr.length;
                        for (int i = 0; i < c; ++i) {
                            bundle.addDestination(aAddr[i]);
                        }
                    }
                }
            }
        }
        return bundle.getAddressCount();
    }

    public void assignMessageIds(Message msg) {
        long lIdFrom = this.getFromMessageId() + 1L;
        this.setFromMessageId(lIdFrom);
        msg.setFromMessageId(lIdFrom);
        MessagePacket packetFirst = msg.getPacket(0);
        if (packetFirst instanceof Directed) {
            Directed packetHead = (Directed)packetFirst;
            DependentMemberSet setTo = packetHead.getToMemberSet();
            if (setTo == null) {
                Member memberTo = this.getMember(packetHead.getToId());
                if (memberTo != null) {
                    packetHead.setToMessageId(memberTo.getNextDestinationMessageId());
                }
            } else {
                Object[] aMember = setTo.toArray();
                for (int i = aMember.length - 1; i >= 0; --i) {
                    Member memberTo = (Member)aMember[i];
                    setTo.setDestinationMessageId(memberTo.getId(), memberTo.getNextDestinationMessageId());
                }
            }
            long lFromMsgId = this.getMessageOutgoing().add(msg);
            long lSetId = msg.getFromMessageId();
            if (lSetId != lFromMsgId) {
                throw new IllegalStateException("Set MsgFromId " + lSetId + " != expected " + lFromMsgId);
            }
            int c = msg.getMessagePartCount();
            for (int i = 0; i < c; ++i) {
                msg.getPacket(i).setFromMessageId(lFromMsgId);
            }
        } else {
            WindowedArray wa = this.getMessageOutgoing();
            wa.remove(wa.add(msg));
        }
    }

    protected int computePreferredPacketLength(MemberSet setTo) {
        int cTo;
        int cbStd = 1452;
        int cbPref = this.getPreferredPacketLength();
        int n = cTo = setTo == null ? 0 : setTo.size();
        if (cTo == 1) {
            Member memberTo = this.getMemberSet().getMember(setTo.getFirstId());
            if (memberTo != null) {
                int cbPrefThat = memberTo.getPreferredPacketLength();
                cbPref = Math.min(cbPref, cbPrefThat == 0 ? Math.min(cbStd, this.getMaximumPacketLength()) : cbPrefThat);
            }
            return cbPref;
        }
        if (cTo == 0) {
            return cbPref;
        }
        if (this.isMulticastEnabled() && this.isMulticast(cTo)) {
            cbPref = Math.min(cbPref, Math.min(cbStd, this.getMaximumPacketLength()));
        }
        if (setTo instanceof ActualMemberSet) {
            for (Member memberTo : setTo) {
                int cbPrefThat = memberTo.getPreferredPacketLength();
                cbPref = Math.min(cbPref, cbPrefThat == 0 ? Math.min(cbStd, this.getMaximumPacketLength()) : cbPrefThat);
            }
        } else {
            MasterMemberSet setCluster = this.getMemberSet();
            int[] anToId = setTo.toIdArray();
            int c = anToId.length;
            for (int i = 0; i < c; ++i) {
                Member memberTo = ((MemberSet)setCluster).getMember(anToId[i]);
                if (memberTo == null) continue;
                int cbPrefThat = memberTo.getPreferredPacketLength();
                cbPref = Math.min(cbPref, cbPrefThat == 0 ? Math.min(cbStd, this.getMaximumPacketLength()) : cbPrefThat);
            }
        }
        return cbPref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deferPacket(Member member, MessagePacket packet) {
        boolean fResult = false;
        Member.FlowControl flowControl = member.getFlowControl();
        if (flowControl != null) {
            if (packet.getDeliveryState() == 4) {
                return false;
            }
            int cThreshold = flowControl.isPaused() ? 1 : flowControl.getOutstandingPacketThreshold();
            int cOutstanding = flowControl.getOutstandingPacketCount();
            boolean fOverLimit = cOutstanding > cThreshold;
            boolean fDeferring = flowControl.isDeferring();
            int nState = packet.getDeliveryState();
            if (nState == 4) {
                fResult = false;
            } else if (fOverLimit) {
                Member.FlowControl flowControl2 = flowControl;
                synchronized (flowControl2) {
                    flowControl.getDeferredQueue().add(packet);
                }
                packet.setDeliveryState(2, member);
                fResult = true;
            } else if (fDeferring && nState != 2) {
                Member.FlowControl flowControl3 = flowControl;
                synchronized (flowControl3) {
                    Queue deferredQueue = flowControl.getDeferredQueue();
                    if (deferredQueue.isEmpty()) {
                        this.getDeferredReadyQueue().add(packet);
                    } else {
                        deferredQueue.add(packet);
                    }
                }
                packet.setDeliveryState(2, member);
                fResult = true;
            }
        }
        return fResult;
    }

    protected void doEarlyLossDetection(Member member, MessagePacket packetNewestTo, PacketIdentifier ptidNewestFrom) {
        MessagePacket packet;
        if (PacketComparator.compare(ptidNewestFrom, member.getContiguousFromPacketId()) > 0) {
            this.scheduleNack(member);
        }
        Member.SentQueue queueRecent = member.getRecentPacketQueue();
        int nMemberId = member.getId();
        if (packetNewestTo == null) {
            MessagePacket packet2;
            do {
                if ((packet2 = (MessagePacket)queueRecent.peekNoWait()) != null && !packet2.isAddressedTo(nMemberId)) continue;
                return;
            } while (packet2 == queueRecent.removeNoWait());
            throw new IllegalStateException();
        }
        PacketIdentifier ptidContTo = member.getContiguousToPacketId();
        long ldtNow = Base.getSafeTimeMillis();
        List listLost = this.getLostPacketListTemp();
        List listAckd = this.getAckdPacketListTemp();
        boolean fAdded = false;
        do {
            if ((packet = (MessagePacket)queueRecent.removeNoWait()) == null) {
                fAdded = false;
                break;
            }
            if (!packet.isAddressedTo(nMemberId) || packet.getResendScheduled() <= ldtNow) continue;
            if (PacketComparator.compare(ptidContTo, packet) >= 0) {
                if (!packet.registerAck(member)) continue;
                listAckd.add(packet);
                continue;
            }
            listLost.add(packet);
            fAdded = true;
        } while (packet != packetNewestTo);
        if (!listAckd.isEmpty()) {
            this.onAcknowledgedPacket(member, listAckd);
        }
        if (fAdded) {
            this.getResendQueue().addAllHead(listLost, true);
        }
    }

    public void drainDeferredPackets(Member member) {
        Queue queueReady;
        Queue queueDeferred;
        int cThreshold;
        int cSpots;
        Member.FlowControl flowControl = member.getFlowControl();
        if (flowControl != null && (cSpots = (cThreshold = flowControl.isPaused() ? 1 : flowControl.getOutstandingPacketThreshold()) - flowControl.getOutstandingPacketCount()) > 0 && (queueDeferred = flowControl.getDeferredQueue()) != (queueReady = this.getDeferredReadyQueue())) {
            Packet packet;
            while ((packet = (Packet)queueDeferred.removeNoWait()) != null) {
                queueReady.add(packet);
                if (packet.getToId() != 0) {
                    --cSpots;
                }
                if (cSpots > 0) continue;
            }
        }
    }

    public long drainOverflow(Set setDest, long cMillisTimeout) throws InterruptedException {
        int cMaxPackets = this.getCloggedCount();
        if (cMaxPackets <= 0 || setDest == null) {
            return cMillisTimeout;
        }
        MemberSet setMember = (MemberSet)setDest;
        Member member = this.getMember(setMember.getFirstId());
        if (Member.FlowControl.isEnabled() && setMember.size() == 1 && member != null && member != this.getThisMember()) {
            long cPackets = this.getResendQueue().getMultipointPacketCount() + this.getDeferredReadyQueue().size();
            Member.FlowControl flowControl = member.getFlowControl();
            if (flowControl != null) {
                cPackets += (long)flowControl.getPendingPacketCount();
            }
            if (cPackets < (long)cMaxPackets) {
                return cMillisTimeout;
            }
        }
        return this.drainOverflowComplex(setMember, cMillisTimeout);
    }

    protected long drainOverflowComplex(MemberSet setMembers, long cMillisTimeout) throws InterruptedException {
        int cMaxPackets = this.getCloggedCount();
        Queue queueIn = this.getPacketAdapterQueue();
        Queue queueReady = this.getDeferredReadyQueue();
        ResendQueue queueResend = this.getResendQueue();
        boolean fFlowcontrol = Member.FlowControl.isEnabled();
        Member memberThis = this.getThisMember();
        int[] anToId = null;
        long ldtNow = 0L;
        long ldtStart = 0L;
        long ldtAlarmNext = 0L;
        long ldtTimeout = 0L;
        int cIters = 0;
        while (this.isStarted()) {
            int cPackets;
            int cPacketsIn = cPackets = queueIn.size();
            int cPacketsResend = -1;
            int cPacketsReady = -1;
            int cPacketsMp = -1;
            int cPacketsPending = -1;
            Member memberJammed = null;
            if (fFlowcontrol) {
                cPacketsMp = queueResend.getMultipointPacketCount();
                cPackets += cPacketsMp;
                cPacketsReady = queueReady.size();
                cPackets += cPacketsReady;
                if (setMembers == null) break;
                if (setMembers.size() == 1) {
                    Member.FlowControl flowControl;
                    Member member = this.getMember(setMembers.getFirstId());
                    if (member != null && (flowControl = member.getFlowControl()) != null) {
                        memberJammed = member;
                        cPacketsPending = flowControl.getPendingPacketCount();
                        cPackets += cPacketsPending;
                    }
                } else {
                    anToId = setMembers.toIdArray();
                    int c = anToId.length;
                    for (int i = 0; i < c; ++i) {
                        int cPending;
                        Member.FlowControl flowControl;
                        Member member = this.getMember(anToId[i]);
                        if (member == null || (flowControl = member.getFlowControl()) == null || cPackets + (cPending = flowControl.getPendingPacketCount()) <= cMaxPackets) continue;
                        memberJammed = member;
                        cPacketsPending = cPending;
                        cPackets += cPacketsPending;
                        break;
                    }
                }
            } else {
                cPacketsResend = queueResend.size();
                cPackets += cPacketsResend;
            }
            if (cPackets > cMaxPackets && ldtNow <= ldtTimeout) {
                if (ldtNow >= ldtAlarmNext) {
                    if (ldtStart == 0L) {
                        ldtStart = ldtNow = Base.getSafeTimeMillis();
                        ldtTimeout = cMillisTimeout == 0L ? Long.MAX_VALUE : ldtStart + cMillisTimeout;
                    } else {
                        PacketPublisher._trace("Overloaded packet queue; " + cPackets + "/" + cMaxPackets + " packet limit, Duration=" + (ldtNow - ldtStart) / 1000L + "s, InQueue=" + cPacketsIn + ", ResendQueue=" + cPacketsResend + ", MultiPoint=" + cPacketsMp + ", Pending=" + cPacketsPending + ", Ready=" + cPacketsReady + ", " + String.valueOf(memberJammed) + ", com.tangosol.coherence.component.net.Member.FlowControl(" + String.valueOf(memberJammed == null ? null : memberJammed.getFlowControl()) + ")", 2);
                    }
                    ldtAlarmNext = ldtNow + (long)(this.getResendTimeout() / 4);
                }
            } else {
                if (cPackets != 0 || cIters <= true || (ldtNow = Base.getSafeTimeMillis()) <= this.getLastTrafficJamWarningTimeMillis() + 60000L) break;
                PacketPublisher._trace("The \"traffic-jam\" settings may be overly cautious; consider increasing the \"maximum-packets\", or decreasing \"pause-milliseconds\"", 3);
                this.setLastTrafficJamWarningTimeMillis(ldtNow);
                break;
            }
            this.getQueue().flush();
            Blocking.sleep(this.getCloggedDelay());
            ldtNow = Base.getSafeTimeMillis();
            ++cIters;
        }
        if (cMillisTimeout == 0L || ldtTimeout == 0L) {
            return cMillisTimeout;
        }
        if (ldtTimeout > ldtNow) {
            return ldtTimeout - ldtNow;
        }
        throw new RequestTimeoutException("Request timed out");
    }

    protected Message[] ensureMsgArrayTemp(int cMinSize) {
        Message[] aMsgTemp = this.getMsgArrayTemp();
        if (aMsgTemp == null || aMsgTemp.length < cMinSize) {
            aMsgTemp = new Message[cMinSize];
            this.setMsgArrayTemp(aMsgTemp);
        }
        return aMsgTemp;
    }

    protected long[] ensureMsgIdArrayTemp(int cMinSize) {
        long[] alTemp = this.getMsgIdArrayTemp();
        if (alTemp == null || alTemp.length < cMinSize) {
            alTemp = new long[cMinSize];
            this.setMsgIdArrayTemp(alTemp);
        }
        return alTemp;
    }

    protected MemberSet ensureSingleMemberSetTemp(Member member) {
        SingleMemberSet setMember = this.getSingleMemberSetTemp();
        setMember.setTheMember(member);
        return setMember;
    }

    @Override
    public void flush() {
        this.getQueue().flush();
    }

    public void flushSend() {
        this.getSendQueue().flush();
    }

    public String formatStats() {
        long cCpu = this.getStatsCpu();
        long cMillis = Base.getSafeTimeMillis() - this.getStartTimestamp();
        long lSent = this.getStatsSent();
        long lResent = this.getStatsResent();
        long lWasted = this.getStatsResentExcess();
        double dCpu = cMillis == 0L ? 0.0 : (double)cCpu / (double)cMillis;
        double dThru = cCpu == 0L ? 0.0 : (double)lSent * 1000.0 / (double)cCpu;
        double dSuccess = lSent == 0L ? 1.0 : 1.0 - (double)lResent / (double)lSent;
        double dEfficiency = lSent == 0L ? 1.0 : (double)((float)(1.0 - (double)lWasted / (double)lSent));
        dCpu = (double)((int)(dCpu * 1000.0)) / 10.0;
        dSuccess = (double)((int)(dSuccess * 10000.0)) / 10000.0;
        dEfficiency = (double)((int)(dEfficiency * 10000.0)) / 10000.0;
        return "Cpu=" + cCpu + "ms (" + dCpu + "%), PacketsSent=" + lSent + ", PacketsResent=" + lResent + ", SuccessRate=" + dSuccess + ", Efficiency=" + dEfficiency + ", Throughput=" + (int)dThru + "pkt/sec";
    }

    public int getAckDelay() {
        return this.getAckQueue().getDelayMillis();
    }

    protected List getAckdPacketListTemp() {
        List list = this.__m_AckdPacketListTemp;
        list.clear();
        return list;
    }

    public AckQueue getAckQueue() {
        return this.__m_AckQueue;
    }

    public Set getBroadcastAddresses() {
        return this.__m_BroadcastAddresses;
    }

    public ByteArrayWriteBuffer.Allocator getBufferAllocator(int cb) {
        return null;
    }

    public int getCloggedCount() {
        return this.__m_CloggedCount;
    }

    public int getCloggedDelay() {
        return this.__m_CloggedDelay;
    }

    public ByteBuffer getClusterNameBuffer() {
        return this.__m_ClusterNameBuffer;
    }

    public ConfirmationQueue getConfirmationQueue() {
        return this.__m_ConfirmationQueue;
    }

    public Queue getDeferredReadyQueue() {
        return this.__m_DeferredReadyQueue;
    }

    public long getFromMessageId() {
        return this.__m_FromMessageId;
    }

    protected Queue[] getIncomingPacketQueues() {
        return this.__m_IncomingPacketQueues;
    }

    public long getLastTrafficJamWarningTimeMillis() {
        return this.__m_LastTrafficJamWarningTimeMillis;
    }

    protected List getLostPacketListTemp() {
        List list = this.__m_LostPacketListTemp;
        list.clear();
        return list;
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public MultiBufferWriteBuffer.WriteBufferPool getMessageBufferAllocator() {
        return this.__m_MessageBufferAllocator;
    }

    public WindowedArray getMessageOutgoing() {
        return this.__m_MessageOutgoing;
    }

    public Message[] getMsgArrayTemp() {
        return this.__m_MsgArrayTemp;
    }

    public long[] getMsgIdArrayTemp() {
        return this.__m_MsgIdArrayTemp;
    }

    public InetSocketAddress getMulticastAddress() {
        return this.__m_MulticastAddress;
    }

    public int getMulticastBypassCount() {
        return this.__m_MulticastBypassCount;
    }

    public double getMulticastThreshold() {
        return this.__m_MulticastThreshold;
    }

    public long getNackDelayMillis() {
        return this.__m_NackDelayMillis;
    }

    public Queue getPacketAdapterQueue() {
        return this.__m_PacketAdapterQueue;
    }

    public int getPreferredPacketLength() {
        return this.__m_PreferredPacketLength;
    }

    public int getResendDelay() {
        return this.getResendQueue().getResendMillis();
    }

    public ResendQueue getResendQueue() {
        return this.__m_ResendQueue;
    }

    public int getResendTimeout() {
        return this.getResendQueue().getTimeoutMillis();
    }

    public Queue getSendQueue() {
        return this.__m_SendQueue;
    }

    protected SingleMemberSet getSingleMemberSetTemp() {
        return this.__m_SingleMemberSetTemp;
    }

    protected SocketAddress getSocketAddress(Member member, Packet packetData) {
        switch (packetData.getPacketType()) {
            case 232718547: 
            case 232718548: 
            case 232718549: {
                if (packetData.getSentCount() >= member.getTxDebugDropCount()) break;
                return new InetSocketAddress("0.0.0.0", 0);
            }
        }
        return packetData.getLength() <= member.getPreferredPacketLength() ? member.getPreferredSocketAddress() : member.getSocketAddress();
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsNacksSent() {
        return this.__m_StatsNacksSent;
    }

    public long getStatsResent() {
        return this.__m_StatsResent;
    }

    public long getStatsResentEarly() {
        return this.__m_StatsResentEarly;
    }

    public long getStatsResentExcess() {
        return this.__m_StatsResentExcess;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public UdpSocket getUdpSocketMulticast() {
        return this.__m_UdpSocketMulticast;
    }

    public UnicastUdpSocket getUdpSocketUnicast() {
        return this.__m_UdpSocketUnicast;
    }

    @Override
    public long getWaitMillis() {
        long lWaitResend = this.getResendQueue().getWaitMillis();
        long lWaitAck = this.getAckQueue().getWaitMillis();
        if (lWaitResend == 0L && lWaitAck == 0L) {
            return 0L;
        }
        if (lWaitResend == 0L) {
            lWaitResend = 60000L;
        }
        if (lWaitAck == 0L) {
            lWaitAck = 60000L;
        }
        return Math.min(lWaitResend, lWaitAck);
    }

    @Override
    protected void halt() {
        this.setUdpSocketMulticast(null);
        this.setUdpSocketUnicast(null);
        super.halt();
    }

    @Override
    protected Queue instantiateQueue() {
        return (InQueue)this._findChild("InQueue");
    }

    public boolean isMulticast(int cToMembers) {
        if (cToMembers <= 1) {
            return false;
        }
        int cOtherMembers = this.getMemberSet().size() - 1;
        double dflMulticastThreshold = this.getMulticastThreshold();
        return cToMembers > (int)(dflMulticastThreshold * (double)cOtherMembers);
    }

    public boolean isMulticastEnabled() {
        return this.__m_MulticastEnabled;
    }

    public boolean isNackEnabled() {
        return this.__m_NackEnabled;
    }

    protected void onAcknowledgedPacket(Member member, Collection collAcknowledged) {
        Member.FlowControl flowControl = member.getFlowControl();
        if (flowControl != null) {
            int cNewAcks = 0;
            for (MessagePacket packet : collAcknowledged) {
                if (!packet.isDeferrable()) continue;
                ++cNewAcks;
                packet.setDeliveryState(4, member);
            }
            int cSeqAcks = flowControl.getSequentialConfirmedCount();
            int cSeqLost = flowControl.getSequentialLostCount();
            if (cSeqLost > 0) {
                flowControl.setPaused(false);
                flowControl.setSequentialLostCount(0);
                flowControl.setSequentialConfirmedCount(cNewAcks);
            } else {
                flowControl.setSequentialConfirmedCount(cSeqAcks + cNewAcks);
            }
            if (flowControl.isAdjustable()) {
                boolean fNearCap;
                int cThreshold = flowControl.getOutstandingPacketThreshold();
                int cEffectiveAcks = cSeqLost == 0 ? cSeqAcks : cSeqAcks / cSeqLost;
                int iGoalDelta = cEffectiveAcks - Member.FlowControl.getSuccessGoal();
                boolean bl = fNearCap = flowControl.getOutstandingPacketHighMark() > cThreshold - (cThreshold >>> 2);
                if (iGoalDelta < 0 && cSeqLost > 0) {
                    cThreshold -= Math.max(1, cThreshold / Member.FlowControl.getAggressionFactor());
                    flowControl.setOutstandingPacketThreshold(cThreshold);
                } else if (iGoalDelta > 0 && fNearCap) {
                    flowControl.setOutstandingPacketHighMark(flowControl.getOutstandingPacketCount());
                    cThreshold += Math.max(1, cThreshold / Member.FlowControl.getAggressionFactor());
                    flowControl.setOutstandingPacketThreshold(cThreshold);
                }
            }
            this.drainDeferredPackets(member);
        }
    }

    protected void onConfirmation(Ack packetAck) {
        Member memberThis;
        Object[] aMsgAck;
        long[] alMsgId;
        int nFromId = packetAck.getFromId();
        Member member = this.getMember(nFromId);
        if (member == null) {
            return;
        }
        WindowedArray waMsg = this.getMessageOutgoing();
        long lMsgFirst = waMsg.getFirstIndex();
        long lMsgId = 0L;
        int cUniqueMsgs = 0;
        try {
            int cNotify = packetAck.getNotifyCount();
            alMsgId = this.ensureMsgIdArrayTemp(cNotify + 1);
            int iLastTrint = -1;
            for (int iNotify = 0; iNotify < cNotify; ++iNotify) {
                int iMsgIdTrint = packetAck.getMessageId(iNotify);
                if (iMsgIdTrint == iLastTrint) continue;
                lMsgId = Packet.translateTrint(iMsgIdTrint, lMsgFirst);
                iLastTrint = iMsgIdTrint;
                alMsgId[cUniqueMsgs++] = lMsgId;
            }
        }
        catch (Exception e) {
            PacketPublisher._trace("Exception while translating Trints from Ack " + String.valueOf(packetAck) + " front of outgoing message array is " + String.valueOf(waMsg.get(lMsgFirst)) + " array window size is " + waMsg.getWindowSize(), 1);
            throw Base.ensureRuntimeException(e);
        }
        boolean fUseNacks = this.isNackEnabled();
        PacketIdentifier ptidNewestTo = packetAck.getNewestFromPacketId(lMsgFirst);
        MessagePacket packetNewestTo = null;
        if (fUseNacks && ptidNewestTo != null) {
            long lNewestMsgId = ptidNewestTo.getFromMessageId();
            if (lNewestMsgId != lMsgId) {
                alMsgId[cUniqueMsgs++] = lNewestMsgId;
            }
            aMsgAck = this.ensureMsgArrayTemp(cUniqueMsgs);
            waMsg.getAll(alMsgId, cUniqueMsgs, aMsgAck);
            Object msgNewest = aMsgAck[cUniqueMsgs - 1];
            int iPacket = ptidNewestTo.getMessagePartIndex();
            if (msgNewest != null && iPacket < ((Message)msgNewest).getMessagePartCount() && (packetNewestTo = ((Message)msgNewest).getPacket(iPacket)) != null && !packetNewestTo.isAddressedTo(nFromId)) {
                packetNewestTo = null;
            }
        } else {
            aMsgAck = this.ensureMsgArrayTemp(cUniqueMsgs);
            waMsg.getAll(alMsgId, cUniqueMsgs, aMsgAck);
        }
        MessagePacket packetLast = this.registerAcks(packetAck, member, (Message[])aMsgAck);
        PacketIdentifier ptidCont = packetAck.getContiguousFromPacketId(lMsgFirst);
        if (PacketComparator.compare(ptidCont, member.getContiguousToPacketId()) > 0) {
            member.setContiguousToPacketId(ptidCont);
        }
        if (fUseNacks) {
            this.doEarlyLossDetection(member, packetNewestTo == null || packetNewestTo.isOutgoingMultipoint() ? packetLast : packetNewestTo, packetAck.getNewestToPacketId(member.getLastIncomingMessageId()));
        }
        if ((memberThis = this.getThisMember()) != null) {
            long lRecvTime = packetAck.getReceivedMillis();
            memberThis.setLastIncomingMillis(lRecvTime);
            if (member != memberThis) {
                member.setLastIncomingMillis(lRecvTime);
            }
        }
    }

    @Override
    protected void onEnter() {
        super.onEnter();
        this.resetStats();
    }

    @Override
    public void onException(Throwable e) {
        super.onException(e);
    }

    @Override
    public void onInit() {
        this.setMessageOutgoing((OutgoingMessageArray)this._findChild("OutgoingMessageArray"));
        this.setAckQueue((AckQueue)this._findChild("AckQueue"));
        this.setResendQueue((ResendQueue)this._findChild("ResendQueue"));
        this.setConfirmationQueue((ConfirmationQueue)this._findChild("ConfirmationQueue"));
        super.onInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMemberLeft(Member member) {
        Queue queueReady;
        Queue queueDeferred;
        Member.FlowControl flowControl = member.getFlowControl();
        if (flowControl != null && (queueDeferred = flowControl.getDeferredQueue()) != (queueReady = this.getDeferredReadyQueue())) {
            Member.FlowControl flowControl2 = flowControl;
            synchronized (flowControl2) {
                flowControl.setDeferredQueue(this.getDeferredReadyQueue());
            }
            Object o = queueDeferred.removeNoWait();
            while (o != null) {
                queueReady.add(o);
                o = queueDeferred.removeNoWait();
            }
        }
    }

    protected void onNoRecipientPacket(Packet packet) {
        if (packet.isConfirmationRequired()) {
            ((MessagePacket)packet).clearRecipients();
            this.getResendQueue().addHead(packet);
        }
    }

    @Override
    protected void onNotify() {
        try {
            long ldtStart = Base.getLastSafeTimeMillis();
            Queue[] aQueue = this.getIncomingPacketQueues();
            Queue queueReady = this.getDeferredReadyQueue();
            ConfirmationQueue queueConfirm = this.getConfirmationQueue();
            Queue queueIn = this.getPacketAdapterQueue();
            int cQueues = aQueue.length;
            int cPacketsStart = queueIn.size();
            int cSentPackets = 0;
            int cResentPackets = 0;
            int cEarlyPackets = 0;
            while (true) {
                Ack ack;
                if ((ack = (Ack)((Queue)queueConfirm).removeNoWait()) != null) {
                    this.onConfirmation(ack);
                    continue;
                }
                boolean fMore = false;
                int iQueue = 0;
                int cDeferred = 0;
                while (iQueue < cQueues) {
                    Queue queue = aQueue[iQueue];
                    Packet packet = (Packet)queue.removeNoWait();
                    if (packet != null) {
                        boolean fResend = packet.getSentMillis() != 0L;
                        int cSent = this.onPacket(packet);
                        fMore = true;
                        cSentPackets += cSent;
                        if (fResend) {
                            cResentPackets += cSent;
                            if (((MessagePacket)packet).getPendingResendSkips() > 0) {
                                cEarlyPackets += cSent;
                            }
                        }
                        if (queue == queueReady) {
                            if (cDeferred-- > 0) {
                                continue;
                            }
                        } else if (cSent == 0 && packet.isDeferrable()) {
                            ++cDeferred;
                        }
                    }
                    ++iQueue;
                }
                if (!fMore || cSentPackets >= 100) {
                    long ldtNow = Base.getSafeTimeMillis();
                    if (!fMore || cSentPackets >= 30000) {
                        int cPacketsNow = fMore ? queueIn.size() : 0;
                        ((PacketSpeaker.BundlingQueue)this.getSendQueue()).tuneVolumeThreshold(cPacketsNow - cPacketsStart);
                        this.setStatsSent(this.getStatsSent() + (long)cSentPackets);
                        this.setStatsResent(this.getStatsResent() + (long)cResentPackets);
                        this.setStatsResentEarly(this.getStatsResentEarly() + (long)cEarlyPackets);
                        this.setStatsCpu(this.getStatsCpu() + ldtNow - ldtStart);
                        cEarlyPackets = 0;
                        cResentPackets = 0;
                        cSentPackets = 0;
                        cPacketsStart = cPacketsNow;
                        ldtStart = ldtNow;
                    }
                }
                if (!fMore) break;
            }
        }
        catch (Exception e) {
            if (this.isExiting()) {
                return;
            }
            throw Base.ensureRuntimeException(e);
        }
    }

    protected int onPacket(Packet packet) {
        Member memberSingle;
        if (packet.getSentMillis() > 0L && !this.verifyResendNecessary((MessagePacket)packet)) {
            this.onNoRecipientPacket(packet);
            return 0;
        }
        int nToId = packet.getToId();
        Member member = memberSingle = nToId > 0 ? this.getMember(nToId) : null;
        if (memberSingle != null && packet.isDeferrable() && this.deferPacket(memberSingle, (MessagePacket)packet)) {
            return 0;
        }
        long ldtNow = Base.getLastSafeTimeMillis();
        boolean fReliable = packet.isConfirmationRequired();
        int cAddresses = 0;
        PacketBundle bundle = new PacketBundle();
        bundle.addPacket(packet);
        if (memberSingle == null) {
            cAddresses = this.addressMany(bundle);
            if (cAddresses == 0) {
                this.onNoRecipientPacket(packet);
                return 0;
            }
        } else {
            bundle.setUdpSocket(this.getUdpSocketUnicast());
            bundle.addDestination(this.getSocketAddress(memberSingle, packet));
            bundle.setMaximumLength(Math.min(this.getPreferredPacketLength(), memberSingle.getPreferredPacketLength()));
            cAddresses = 1;
            if (fReliable) {
                memberSingle.setLastOutgoingMillis(ldtNow);
            }
        }
        this.onSendPacket(packet);
        int cSent = packet.getSentCount();
        if (cSent == 0) {
            this.getSendQueue().add(bundle);
        } else {
            bundle.send();
            ldtNow = Base.getLastSafeTimeMillis();
        }
        packet.setSentMillis(ldtNow);
        packet.setSentCount(cSent + 1);
        if (fReliable) {
            this.getResendQueue().add(packet);
        }
        return cAddresses;
    }

    protected void onSendPacket(Member member, Packet packet) {
        MessagePacket msgPacket;
        Member.FlowControl flowControl = member.getFlowControl();
        if (flowControl != null && packet.isDeferrable() && (msgPacket = (MessagePacket)packet).getDeliveryState() != 4) {
            msgPacket.setDeliveryState(1, member);
        }
        if (this.isNackEnabled() && packet.isConfirmationRequired() && !packet.isOutgoingMultipoint()) {
            if (packet.getSentMillis() == 0L) {
                member.setNewestToPacketId((MessagePacket)packet);
            }
            member.getRecentPacketQueue().add(packet);
        }
        member.setStatsSent(member.getStatsSent() + 1L);
        if (packet.getSentMillis() > 0L) {
            member.setStatsResent(member.getStatsResent() + 1L);
        }
    }

    protected void onSendPacket(Packet packet) {
        if (packet.isOutgoingMultipoint()) {
            int[] anToId = ((MessagePacket)packet).getToMemberSet().toIdArray();
            int c = anToId.length;
            for (int i = 0; i < c; ++i) {
                Member member = this.getMember(anToId[i]);
                if (member == null) continue;
                this.onSendPacket(member, packet);
            }
        } else {
            Member member = this.getMember(packet.getToId());
            if (member != null) {
                this.onSendPacket(member, packet);
            }
        }
    }

    public void onSlowPacket(MessagePacket packet) {
    }

    public void onUndeliverablePacket(MessagePacket packet) {
        DependentMemberSet setMemberTo;
        int nMemberTo = packet.getToId();
        if (nMemberTo != 0) {
            Member member = this.getMember(nMemberTo);
            if (member != null) {
                this.getMemberSet().remove(member);
            }
            packet.setToId(0);
        }
        if ((setMemberTo = packet.getToMemberSet()) != null) {
            this.getMemberSet().removeAll((Collection)setMemberTo);
            setMemberTo.clear();
        }
    }

    @Override
    protected void onWait() throws InterruptedException {
        this.flushSend();
        super.onWait();
    }

    public boolean packetizeMessage(Message msg) {
        ReadBuffer bufferRead;
        Disposable controller = msg.getBufferController();
        if (controller == null) {
            try {
                MultiBufferWriteBuffer buffer = new MultiBufferWriteBuffer(this.getMessageBufferAllocator());
                msg.setBufferController(buffer, 1);
                msg.getService().serializeMessage(msg, buffer.getBufferOutput());
                bufferRead = buffer.getUnsafeReadBuffer();
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e);
            }
        } else {
            int c = msg.getToMemberSet().size() - 1;
            for (int i = 0; i < c; ++i) {
                msg.releaseOutgoing(true);
            }
            BufferSequence bufseq = (BufferSequence)controller;
            int cBuffers = bufseq.getBufferCount();
            if (cBuffers == 1) {
                bufferRead = new ByteBufferReadBuffer(bufseq.getBuffer(0));
            } else {
                ReadBuffer[] abuf = new ReadBuffer[cBuffers];
                for (int i = 0; i < cBuffers; ++i) {
                    abuf[i] = new ByteBufferReadBuffer(bufseq.getBuffer(i));
                }
                bufferRead = new MultiBufferReadBuffer(abuf);
            }
            msg.setReadBuffer(bufferRead);
        }
        return msg.packetize(this, this.getMemberSet(), bufferRead, this.computePreferredPacketLength(msg.getToMemberSet()), this.getMaximumPacketLength());
    }

    public boolean post(Object oMsg) {
        return this.getQueue().add(oMsg);
    }

    protected MessagePacket registerAcks(Ack packetAck, Member member, Message[] aMsgAck) {
        Message msgLast = null;
        MessagePacket packetLast = null;
        List listAckd = this.getAckdPacketListTemp();
        int cNotify = packetAck.getNotifyCount();
        int cNewAck = 0;
        int iLastTrint = -1;
        int iMsg = 0;
        for (int i = 0; i < cNotify; ++i) {
            MessagePacket packetMsg;
            int iMsgIdTrint = packetAck.getMessageId(i);
            if (iMsgIdTrint != iLastTrint) {
                msgLast = aMsgAck[iMsg];
                aMsgAck[iMsg++] = null;
                iLastTrint = iMsgIdTrint;
            }
            if (msgLast == null || (packetMsg = msgLast.getPacket(packetAck.getMessagePartIndex(i))) == null || !packetMsg.registerAck(member)) continue;
            listAckd.add(packetMsg);
            if (!packetMsg.isOutgoingMultipoint()) {
                packetLast = packetMsg;
            }
            ++cNewAck;
        }
        if (cNewAck < cNotify) {
            this.setStatsResentExcess(Math.min(this.getStatsResent(), this.getStatsResentExcess() + (long)(cNotify - cNewAck)));
        }
        this.onAcknowledgedPacket(member, listAckd);
        return packetLast;
    }

    public void resetStats() {
        this.setStatsSent(0L);
        this.setStatsResent(0L);
        this.setStatsResentEarly(0L);
        this.setStatsResentExcess(0L);
        this.setStatsNacksSent(0L);
        this.setStatsCpu(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void scheduleNack(Member member) {
        Ack packetAck = member.getPacketAck();
        long ldtSend = Base.getSafeTimeMillis() + this.getNackDelayMillis();
        if (packetAck != null && packetAck.getScheduledMillis() <= ldtSend) {
            if (!packetAck.isFlushed()) {
                return;
            }
            packetAck = null;
        }
        if (packetAck == null) {
            packetAck = new Ack();
            packetAck.setFromId(this.getMemberId());
            packetAck.setToId(member.getId());
        }
        packetAck.setScheduledMillis(ldtSend);
        this.setStatsNacksSent(this.getStatsNacksSent() + 1L);
        this.getAckQueue().addHead(packetAck);
    }

    public void sendDiagnosticPacket(DiagnosticPacket packet) {
        block3: {
            try {
                Member memberTo = this.getMember(packet.getToId());
                if (memberTo == null) {
                    PacketPublisher._trace("Aborting diagnostic to unknown member " + String.valueOf(packet), 3);
                    return;
                }
                PacketBundle bundle = new PacketBundle();
                bundle.addPacket(packet);
                packet.setFromId(this.getThisMember().getId());
                bundle.setUdpSocket(this.getUdpSocketUnicast());
                bundle.addDestination(packet.isPreferredPortUsed() ? memberTo.getPreferredSocketAddress() : memberTo.getSocketAddress());
                packet.setSentMillis(Base.getSafeTimeMillis());
                SingleMemberSet setTo = new SingleMemberSet();
                setTo.add(memberTo);
                bundle.send();
                packet.setSentCount(1);
                PacketPublisher._trace("Sent " + String.valueOf(packet), 6);
            }
            catch (Exception e) {
                if (this.isExiting()) break block3;
                PacketPublisher._trace("Failed to send " + String.valueOf(packet) + " due to exception: " + String.valueOf(e), 1);
            }
        }
    }

    public void setAckDelay(int cMillis) {
        this.getAckQueue().setDelayMillis(cMillis);
    }

    protected void setAckdPacketListTemp(List listPacket) {
        this.__m_AckdPacketListTemp = listPacket;
    }

    protected void setAckQueue(AckQueue queue) {
        this.__m_AckQueue = queue;
    }

    public void setBroadcastAddresses(Set list) {
        this.__m_BroadcastAddresses = list;
    }

    public void setCloggedCount(int cMaxPackets) {
        this.__m_CloggedCount = cMaxPackets;
    }

    public void setCloggedDelay(int cMillis) {
        this.__m_CloggedDelay = Math.max(1, cMillis);
    }

    public void setClusterNameBuffer(ByteBuffer bufBuffer) {
        this.__m_ClusterNameBuffer = bufBuffer;
    }

    protected void setConfirmationQueue(ConfirmationQueue queue) {
        this.__m_ConfirmationQueue = queue;
    }

    public void setDeferredReadyQueue(Queue queue) {
        this.__m_DeferredReadyQueue = queue;
    }

    protected void setFromMessageId(long lId) {
        this.__m_FromMessageId = lId;
    }

    protected void setIncomingPacketQueues(Queue[] aQueue) {
        this.__m_IncomingPacketQueues = aQueue;
    }

    protected void setLastTrafficJamWarningTimeMillis(long cMillis) {
        this.__m_LastTrafficJamWarningTimeMillis = cMillis;
    }

    protected void setLostPacketListTemp(List listPacket) {
        this.__m_LostPacketListTemp = listPacket;
    }

    public void setMaximumPacketLength(int cbMax) {
        this.__m_MaximumPacketLength = cbMax;
    }

    public void setMessageBufferAllocator(MultiBufferWriteBuffer.WriteBufferPool allocator) {
        this.__m_MessageBufferAllocator = allocator;
    }

    protected void setMessageOutgoing(WindowedArray waMsg) {
        this.__m_MessageOutgoing = waMsg;
    }

    protected void setMsgArrayTemp(Message[] aMsg) {
        this.__m_MsgArrayTemp = aMsg;
    }

    protected void setMsgIdArrayTemp(long[] alMsgId) {
        this.__m_MsgIdArrayTemp = alMsgId;
    }

    public void setMulticastAddress(InetSocketAddress addressMulticast) {
        this.__m_MulticastAddress = addressMulticast;
    }

    protected void setMulticastBypassCount(int nCount) {
        this.__m_MulticastBypassCount = nCount;
    }

    public void setMulticastEnabled(boolean fEnabled) {
        this.__m_MulticastEnabled = fEnabled;
    }

    public void setMulticastThreshold(double dflThresholdPercent) {
        this.__m_MulticastThreshold = dflThresholdPercent;
    }

    public void setNackDelayMillis(long cDelayMillis) {
        this.__m_NackDelayMillis = cDelayMillis;
    }

    public void setNackEnabled(boolean fEnabled) {
        this.__m_NackEnabled = fEnabled;
    }

    protected void setPacketAdapterQueue(Queue queue) {
        this.__m_PacketAdapterQueue = queue;
    }

    public void setPreferredPacketLength(int cbPacket) {
        this.__m_PreferredPacketLength = cbPacket;
    }

    public void setResendDelay(int cMillis) {
        ResendQueue queue = this.getResendQueue();
        if (queue != null) {
            queue.setResendMillis(cMillis);
        }
    }

    protected void setResendQueue(ResendQueue queue) {
        this.__m_ResendQueue = queue;
    }

    public void setResendTimeout(int cMillis) {
        ResendQueue queue = this.getResendQueue();
        if (queue != null) {
            queue.setTimeoutMillis(cMillis);
        }
    }

    public void setSendQueue(Queue queue) {
        this.__m_SendQueue = queue;
    }

    protected void setSingleMemberSetTemp(SingleMemberSet set) {
        this.__m_SingleMemberSetTemp = set;
    }

    protected void setStatsCpu(long cMillis) {
        this.__m_StatsCpu = cMillis;
    }

    protected void setStatsNacksSent(long cPackets) {
        this.__m_StatsNacksSent = cPackets;
    }

    protected void setStatsResent(long cPackets) {
        this.__m_StatsResent = cPackets;
    }

    protected void setStatsResentEarly(long cPackets) {
        this.__m_StatsResentEarly = cPackets;
    }

    protected void setStatsResentExcess(long cPackets) {
        this.__m_StatsResentExcess = cPackets;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    protected void setStatsSent(long cPackets) {
        this.__m_StatsSent = cPackets;
    }

    public void setUdpSocketMulticast(UdpSocket socket) {
        this.__m_UdpSocketMulticast = socket;
    }

    public void setUdpSocketUnicast(UnicastUdpSocket socket) {
        this.__m_UdpSocketUnicast = socket;
    }

    @Override
    public synchronized void start() {
        if (this.getSendQueue() == null) {
            throw new IllegalStateException("SendQueue is required!");
        }
        if (this.getMaximumPacketLength() == 0) {
            throw new IllegalStateException("MaximumPacketLength is required!");
        }
        if (this.getPreferredPacketLength() == 0) {
            throw new IllegalStateException("PreferredPacketLength is required!");
        }
        if (this.getUdpSocketUnicast() == null) {
            throw new IllegalStateException("UdpSocketUnicast is required!");
        }
        if (this.getUdpSocketMulticast() == null && this.isMulticastEnabled()) {
            throw new IllegalStateException("UdpSocketMulticast is required!");
        }
        this.setPacketAdapterQueue(((InQueue)this.getQueue()).getPacketAdapter());
        Queue queueDeferred = this.getDeferredReadyQueue();
        Queue[] aQueue = new Queue[queueDeferred == null ? 3 : 4];
        int iQueue = 0;
        aQueue[iQueue++] = this.getAckQueue();
        aQueue[iQueue++] = this.getPacketAdapterQueue();
        aQueue[iQueue++] = this.getResendQueue();
        if (queueDeferred != null) {
            aQueue[iQueue++] = queueDeferred;
        }
        this.setIncomingPacketQueues(aQueue);
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        try {
            UdpSocket socket = this.getUdpSocketMulticast();
            if (socket != null) {
                socket.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return this.get_Name() + ":" + this.formatStats();
    }

    public boolean verifyResendNecessary(MessagePacket packet) {
        PacketPublisher publisher = (PacketPublisher)this.get_Module();
        long lMsgId = packet.getFromMessageId();
        boolean fLiveMembers = false;
        if (packet.isOutgoingMultipoint()) {
            int[] anToId = packet.getToMemberSet().toIdArray();
            int c = anToId.length;
            for (int i = 0; i < c; ++i) {
                Member member = publisher.getMember(anToId[i]);
                if (member == null) continue;
                fLiveMembers = true;
                if (PacketComparator.compare(member.getContiguousToPacketId(), packet) < 0 || !packet.registerAck(member)) continue;
                this.onAcknowledgedPacket(member, Collections.singleton(packet));
            }
        } else {
            Member member = publisher.getMember(packet.getToId());
            if (member != null) {
                fLiveMembers = true;
                if (PacketComparator.compare(member.getContiguousToPacketId(), packet) >= 0 && packet.registerAck(member)) {
                    this.onAcknowledgedPacket(member, Collections.singleton(packet));
                }
            }
        }
        return fLiveMembers && packet.isResendNecessary();
    }

    public static class AckQueue
    extends DualQueue {
        private int __m_DelayMillis;
        private int __m_LastKnownReadyIndex;
        public static final long UPDATE_ONLY_FLAG = 0x100000000L;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Iterator", Iterator.get_CLASS());
        }

        public AckQueue() {
            this(null, null, true);
        }

        public AckQueue(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setBatchSize(1);
                this.setDelayMillis(10);
                this.setElementList(new RecyclingLinkedList());
                this.setHeadElementList(new RecyclingLinkedList());
                this.setHeadLock(new Object());
                this.setLastKnownReadyIndex(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new AckQueue();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher$AckQueue".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public boolean add(Object oElement) {
            MasterMemberSet memberSet;
            Member member;
            Ack packet = (Ack)oElement;
            int cDelayMillis = this.getDelayMillis();
            if (cDelayMillis > 0) {
                packet.setScheduledMillis(Base.getSafeTimeMillis() + (long)cDelayMillis);
            }
            if ((member = ((MemberSet)(memberSet = ((PacketPublisher)this.get_Module()).getMemberSet())).getMember(packet.getToId())) != null) {
                member.setPacketAck(packet);
            }
            return super.add(packet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addHead(Object oElement) {
            int iIndex;
            Ack packet = (Ack)oElement;
            Member member = ((PacketPublisher)this.get_Module()).getMember(packet.getToId());
            long ldtNow = Base.getSafeTimeMillis();
            if (member != null) {
                member.setPacketAck(packet);
            }
            boolean fAdded = false;
            Object object = this.getHeadLock();
            synchronized (object) {
                RecyclingLinkedList listHead = this.getHeadElementList();
                int cHeadSize = listHead.size();
                int iLast = this.getLastKnownReadyIndex();
                if (iLast >= cHeadSize || cHeadSize == 0) {
                    int iStart = iLast < 0 ? 0 : iLast - cHeadSize;
                    RecyclingLinkedList listTail = this.getElementList();
                    long lResult = this.orderedInsert(listTail, iStart, packet);
                    if (lResult < 0L) {
                        iIndex = listTail.size();
                        listTail.add(iIndex, packet);
                        fAdded = true;
                    } else {
                        iIndex = (int)lResult;
                        fAdded = (lResult & 0x100000000L) == 0L;
                    }
                    iIndex += cHeadSize;
                } else {
                    int iStart = iLast < 0 ? 0 : iLast;
                    long lResult = this.orderedInsert(listHead, iStart, packet);
                    if (lResult < 0L) {
                        RecyclingLinkedList listTail = this.getElementList();
                        lResult = this.orderedInsert(listTail, iStart, packet);
                        if (lResult < 0L) {
                            iIndex = listTail.size();
                            listTail.add(iIndex, packet);
                            fAdded = true;
                        } else {
                            iIndex = (int)lResult;
                            fAdded = (lResult & 0x100000000L) == 0L;
                        }
                        iIndex += cHeadSize;
                    } else {
                        iIndex = (int)lResult;
                        boolean bl = fAdded = (lResult & 0x100000000L) == 0L;
                    }
                }
                if (packet.getScheduledMillis() <= ldtNow) {
                    this.setLastKnownReadyIndex(iIndex);
                }
            }
            if (fAdded) {
                this.onAddElement();
            }
            if (iIndex == 0) {
                this.updateFlushState(0);
                this.flush();
            }
            return true;
        }

        @Override
        protected void flush(boolean fAuto) {
            if (((PacketPublisher)this.get_Module()).getThread() != Thread.currentThread()) {
                super.flush(fAuto);
            }
        }

        public int getDelayMillis() {
            return this.__m_DelayMillis;
        }

        protected int getLastKnownReadyIndex() {
            return this.__m_LastKnownReadyIndex;
        }

        public long getWaitMillis() {
            Ack packet = (Ack)this.peekNoWait();
            if (packet == null) {
                return 0L;
            }
            long ldtScheduled = packet.getScheduledMillis();
            if (ldtScheduled < 0L) {
                return -1L;
            }
            long cMillisWait = ldtScheduled - Base.getSafeTimeMillis();
            return cMillisWait <= 0L ? -1L : cMillisWait;
        }

        @Override
        public void onInit() {
            super.onInit();
            this.setNotifier(((PacketPublisher)this.get_Module()).getNotifier());
        }

        protected long orderedInsert(List list, int iStart, Ack packet) {
            long ldtScheduled = packet.getScheduledMillis();
            int c = list.size();
            for (int i = iStart; i < c; ++i) {
                Ack pktCur = (Ack)list.get(i);
                if (pktCur == packet) {
                    return 0x100000000L | (long)i;
                }
                if (pktCur.getScheduledMillis() <= ldtScheduled) continue;
                list.add(i, packet);
                return i;
            }
            return -1L;
        }

        @Override
        public Object remove(long cMillis) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object removeNoWait() {
            Ack packet;
            long ldtNow = 0L;
            PacketPublisher publisher = (PacketPublisher)this.get_Module();
            Object object = this.getHeadLock();
            synchronized (object) {
                do {
                    if ((packet = (Ack)this.peekNoWait()) == null) {
                        return null;
                    }
                    long ldtSchedule = packet.getScheduledMillis();
                    if (ldtNow == 0L) {
                        ldtNow = Base.getSafeTimeMillis();
                    }
                    if (ldtSchedule > ldtNow) {
                        return null;
                    }
                    if (packet != super.removeNoWait()) {
                        throw new IllegalStateException();
                    }
                    this.setLastKnownReadyIndex(this.getLastKnownReadyIndex() - 1);
                } while (packet.getSentMillis() > 0L);
            }
            packet.close(publisher.getMember(packet.getToId()));
            return packet;
        }

        public void setDelayMillis(int cMillis) {
            this.__m_DelayMillis = Math.max(1, cMillis);
        }

        protected void setLastKnownReadyIndex(int i) {
            this.__m_LastKnownReadyIndex = i;
        }

        static {
            AckQueue.__initStatic();
        }

        public static class Iterator
        extends Queue.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher$AckQueue$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class ConfirmationQueue
    extends SingleConsumerQueue {
        public ConfirmationQueue() {
            this(null, null, true);
        }

        public ConfirmationQueue(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setBatchSize(1);
                this.setDelegate(new ConcurrentLinkedQueue());
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ConfirmationQueue();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher$ConfirmationQueue".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onInit() {
            super.onInit();
            this.setNotifier(((PacketPublisher)this.get_Module()).getNotifier());
            this.setBatchSize(Integer.parseInt(Config.getProperty("coherence.publisher.batch", "8")));
        }
    }

    public static class InQueue
    extends SingleConsumerQueue {
        private transient PacketAdapter __m_PacketAdapter;
        private boolean __m_YieldOnFlush;

        public InQueue() {
            this(null, null, true);
        }

        public InQueue(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setBatchSize(1);
                this.setDelegate(new ConcurrentLinkedQueue());
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new PacketAdapter("PacketAdapter", this, true), "PacketAdapter");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new InQueue();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher$InQueue".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public boolean add(Object oElement) {
            Message message;
            PacketPublisher publisher = (PacketPublisher)this.get_Module();
            if (!publisher.packetizeMessage(message = (Message)oElement)) {
                message.releaseOutgoing(true);
                return false;
            }
            try {
                super.add(message);
                this.getPacketAdapter().getPacketCounter().addAndGet(message.getMessagePartCount());
                return true;
            }
            catch (Throwable e) {
                publisher.onException(e);
                throw Base.ensureRuntimeException(e);
            }
        }

        @Override
        public void flush() {
            super.flush();
            if (this.isYieldOnFlush() && Thread.currentThread().getThreadGroup() != ((PacketPublisher)this.get_Module()).getThreadGroup()) {
                Thread.yield();
            }
        }

        public PacketAdapter getPacketAdapter() {
            return this.__m_PacketAdapter;
        }

        public boolean isYieldOnFlush() {
            return this.__m_YieldOnFlush;
        }

        @Override
        public void onInit() {
            this.setPacketAdapter((PacketAdapter)this._findChild("PacketAdapter"));
            this.setBatchSize(Integer.parseInt(Config.getProperty("coherence.publisher.batch", "8")));
            this.setYieldOnFlush(Boolean.valueOf(Config.getProperty("coherence.publisher.yieldonflush", "false")));
            super.onInit();
        }

        @Override
        public Object removeNoWait() {
            Message msg = (Message)super.removeNoWait();
            if (msg != null) {
                ((PacketPublisher)this.get_Module()).assignMessageIds(msg);
            }
            return msg;
        }

        protected void setPacketAdapter(PacketAdapter packetAdapter) {
            this.__m_PacketAdapter = packetAdapter;
        }

        protected void setYieldOnFlush(boolean fYield) {
            this.__m_YieldOnFlush = fYield;
        }

        public static class PacketAdapter
        extends Queue {
            private transient int __m_LastPacketIndex;
            private transient Message __m_NextMessage;
            private transient int __m_NextPacketIndex;
            private transient AtomicLong __m_PacketCounter;
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public PacketAdapter() {
                this(null, null, true);
            }

            public PacketAdapter(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setElementList(new RecyclingLinkedList());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new PacketAdapter();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher$InQueue$PacketAdapter".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            public boolean add(Object oElement) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addHead(Object oElement) {
                throw new UnsupportedOperationException();
            }

            @Override
            public RecyclingLinkedList getElementList() {
                return super.getElementList();
            }

            public int getLastPacketIndex() {
                return this.__m_LastPacketIndex;
            }

            public Message getNextMessage() {
                return this.__m_NextMessage;
            }

            public int getNextPacketIndex() {
                return this.__m_NextPacketIndex;
            }

            public AtomicLong getPacketCounter() {
                return this.__m_PacketCounter;
            }

            @Override
            public boolean isEmpty() {
                return this.size() == 0;
            }

            @Override
            public java.util.Iterator iterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void onInit() {
                this.setPacketCounter(new AtomicLong());
                super.onInit();
            }

            @Override
            public Object peekNoWait() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object remove(long cMillis) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object removeNoWait() {
                int iPacketLast;
                int iPacket;
                boolean fNewMessage;
                Message message = this.getNextMessage();
                if (message == null) {
                    message = (Message)((Queue)this.get_Parent()).removeNoWait();
                    if (message == null) {
                        return null;
                    }
                    fNewMessage = true;
                    iPacket = 0;
                    iPacketLast = message.getMessagePartCount() - 1;
                } else {
                    fNewMessage = false;
                    iPacket = this.getNextPacketIndex();
                    iPacketLast = this.getLastPacketIndex();
                }
                if (iPacket < iPacketLast) {
                    if (fNewMessage) {
                        this.setNextMessage(message);
                        this.setLastPacketIndex(iPacketLast);
                    }
                    this.setNextPacketIndex(iPacket + 1);
                } else if (!fNewMessage) {
                    this.setNextMessage(null);
                }
                this.getPacketCounter().decrementAndGet();
                return message.getPacket(iPacket);
            }

            protected void setLastPacketIndex(int i) {
                this.__m_LastPacketIndex = i;
            }

            protected void setNextMessage(Message message) {
                this.__m_NextMessage = message;
            }

            protected void setNextPacketIndex(int i) {
                this.__m_NextPacketIndex = i;
            }

            protected void setPacketCounter(AtomicLong counter) {
                this.__m_PacketCounter = counter;
            }

            @Override
            public int size() {
                return (int)this.getPacketCounter().get();
            }

            @Override
            public String toString() {
                return this.get_Name() + "{size=" + this.size() + ", NextIndex=" + this.getNextPacketIndex() + ", LastIndex=" + this.getLastPacketIndex() + "}";
            }

            static {
                PacketAdapter.__initStatic();
            }

            public static class Iterator
            extends Queue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher$InQueue$PacketAdapter$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }
    }

    public static class OutgoingMessageArray
    extends WindowedArray {
        public OutgoingMessageArray() {
            this(null, null, true);
        }

        public OutgoingMessageArray(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new OutgoingMessageArray();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher$OutgoingMessageArray".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void onInit() {
            super.onInit();
            this.remove(this.add(null));
        }

        @Override
        public void setFirstStuckIndex(long lIndex) {
            super.setFirstStuckIndex(lIndex);
        }

        @Override
        public void setLastSizeWarningMillis(long ldtMillis) {
            super.setLastSizeWarningMillis(ldtMillis);
        }
    }

    public static class ResendQueue
    extends OptimisticQueue {
        private transient MemberSet __m_DiagnosticMemberSet;
        private byte __m_DiagnosticTimeToLive;
        private long __m_DiagnosticWindowMillis;
        public static final long IMMEDIATE = -1L;
        private transient long __m_LastDiagnosticMillis;
        private volatile transient int __m_MultipointPacketCount;
        private int __m_ResendMillis;
        private int __m_TimeoutMillis;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Iterator", Iterator.get_CLASS());
        }

        public ResendQueue() {
            this(null, null, true);
        }

        public ResendQueue(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setElementList(new RecyclingLinkedList());
                this.setResendMillis(400);
                this.setTimeoutMillis(20000);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ResendQueue();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher$ResendQueue".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public boolean add(Object oElement) {
            MessagePacket packet = (MessagePacket)oElement;
            if (packet.isNackInProgress()) {
                return this.addHead(packet);
            }
            packet.setResendScheduled(packet.getSentMillis() + (long)this.getResendMillis());
            this.onPacketAdd(packet);
            return super.add(packet);
        }

        public boolean addAllHead(List listPackets, boolean fNack) {
            int iInsert;
            long ldtScheduled = Base.getSafeTimeMillis();
            RecyclingLinkedList list = this.getElementList();
            int cPackets = list.size();
            for (iInsert = 0; iInsert < cPackets && ((MessagePacket)list.get(iInsert)).getResendScheduled() <= ldtScheduled; ++iInsert) {
            }
            int iStart = 0;
            int iCurr = 0;
            for (MessagePacket packet : listPackets) {
                packet.setResendScheduled(ldtScheduled);
                if (fNack) {
                    if (packet.isNackInProgress()) {
                        if (iCurr != iStart) {
                            list.addAll(iInsert, listPackets.subList(iStart, iCurr));
                        }
                        iStart = ++iCurr;
                        continue;
                    }
                    packet.setNackInProgress(true);
                }
                this.onPacketAdd(packet);
                ++iCurr;
            }
            if (iStart == 0) {
                list.addAll(iInsert, listPackets);
            } else {
                list.addAll(iInsert, listPackets.subList(iStart, iCurr));
            }
            return true;
        }

        @Override
        public boolean addHead(Object oElement) {
            int iInsert;
            MessagePacket packet = (MessagePacket)oElement;
            packet.setResendScheduled(-1L);
            this.onPacketAdd(packet);
            RecyclingLinkedList listPackets = this.getElementList();
            int cPackets = listPackets.size();
            for (iInsert = 0; iInsert < cPackets && ((MessagePacket)listPackets.get(iInsert)).getResendScheduled() <= -1L; ++iInsert) {
            }
            listPackets.add(iInsert, packet);
            return true;
        }

        public MemberSet getDiagnosticMemberSet() {
            return this.__m_DiagnosticMemberSet;
        }

        public byte getDiagnosticTimeToLive() {
            return this.__m_DiagnosticTimeToLive;
        }

        public long getDiagnosticWindowMillis() {
            return this.__m_DiagnosticWindowMillis;
        }

        public long getLastDiagnosticMillis() {
            return this.__m_LastDiagnosticMillis;
        }

        public WindowedArray getMessageOutgoing() {
            return ((PacketPublisher)this.get_Module()).getMessageOutgoing();
        }

        public int getMultipointPacketCount() {
            return this.__m_MultipointPacketCount;
        }

        public int getResendMillis() {
            return this.__m_ResendMillis;
        }

        public int getTimeoutMillis() {
            return this.__m_TimeoutMillis;
        }

        public long getWaitMillis() {
            MessagePacket packet = (MessagePacket)this.peekNoWait();
            if (packet == null) {
                return 0L;
            }
            long ldtScheduled = packet.getResendScheduled();
            if (ldtScheduled < 0L) {
                return -1L;
            }
            long cMillisWait = ldtScheduled - Base.getSafeTimeMillis();
            return cMillisWait <= 0L ? -1L : cMillisWait;
        }

        @Override
        public void onInit() {
            this.setDiagnosticTimeToLive(Byte.parseByte(Config.getProperty("coherence.tcmp.diag.ttl", "2")));
            this.setDiagnosticWindowMillis(Long.parseLong(Config.getProperty("coherence.tcmp.diag.window", "2000")));
            this.setDiagnosticMemberSet(new MemberSet());
            super.onInit();
        }

        protected void onPacketAdd(MessagePacket packet) {
            if (packet.getResendTimeout() == 0L) {
                packet.setResendTimeout(packet.getSentMillis() + (long)this.getTimeoutMillis());
                if (packet.isOutgoingMultipoint()) {
                    this.setMultipointPacketCount(this.getMultipointPacketCount() + 1);
                }
            }
        }

        protected void onPacketDone(MessagePacket packet) {
            long lMsgId;
            WindowedArray waMsg;
            Message msg;
            if (packet.isOutgoingMultipoint()) {
                this.setMultipointPacketCount(this.getMultipointPacketCount() - 1);
            }
            if ((msg = (Message)(waMsg = this.getMessageOutgoing()).get(lMsgId = packet.getFromMessageId())) == null) {
                ResendQueue._trace("Encountered orphan packet:\n" + String.valueOf(packet) + "\nOutgoing Message Array:\n" + String.valueOf(waMsg), 1);
                throw new IllegalStateException("Encountered orphan packet");
            }
            msg.setPacket(packet.getMessagePartIndex(), null);
            if (msg.getNullPacketCount() == msg.getMessagePartCount()) {
                msg.releaseOutgoing(true, false);
                if (lMsgId == waMsg.getFirstIndex()) {
                    long lLastId = waMsg.getLastIndex();
                    do {
                        waMsg.remove(lMsgId);
                        msg.releaseOutgoingComplete();
                        msg = null;
                        while (msg == null && lMsgId < lLastId) {
                            msg = (Message)waMsg.get(++lMsgId);
                        }
                    } while (msg != null && msg.getNullPacketCount() == msg.getMessagePartCount());
                } else if (!msg.isNotifyDelivery()) {
                    waMsg.remove(lMsgId);
                    msg.releaseOutgoingComplete();
                }
            }
        }

        protected void onPacketLost(Member member, MessagePacket packet) {
            PacketPublisher publisher = (PacketPublisher)this.get_Module();
            boolean fTimedout = packet.getPendingResendSkips() == 0;
            Member.FlowControl flowControl = member.getFlowControl();
            long ldtNow = Base.getLastSafeTimeMillis();
            if (flowControl != null && packet.isDeferrable()) {
                int cSeqLost = flowControl.getSequentialLostCount();
                flowControl.setSequentialLostCount(++cSeqLost);
                if (fTimedout) {
                    int iLostPacketThreshold = flowControl.getLostPacketThreshold();
                    if (iLostPacketThreshold > 0 && cSeqLost > iLostPacketThreshold && !flowControl.isPaused()) {
                        if (ldtNow - packet.getResendScheduled() < publisher.getClockResolutionMillis()) {
                            flowControl.setPaused(true);
                        }
                    }
                }
                packet.setDeliveryState(3, member);
                publisher.drainDeferredPackets(member);
            }
            if (publisher.isNackEnabled() && fTimedout) {
                member.getRecentPacketQueue().remove(packet);
            }
            long ldtTimeout = packet.getResendTimeout();
            if (!member.isDeaf() && ldtTimeout - ldtNow < this.getDiagnosticWindowMillis() && ldtTimeout > ldtNow) {
                if (ldtNow >= this.getLastDiagnosticMillis() + (long)this.getResendMillis()) {
                    this.getDiagnosticMemberSet().clear();
                    this.setLastDiagnosticMillis(ldtNow);
                }
                if (this.getDiagnosticMemberSet().add(member)) {
                    DiagnosticPacket packetDiag;
                    int nToId = member.getId();
                    byte nTTL = this.getDiagnosticTimeToLive();
                    if (member.getPreferredPort() != 0) {
                        packetDiag = new DiagnosticPacket();
                        packetDiag.setPreferredPortUsed(true);
                        packetDiag.setToId(nToId);
                        packetDiag.setTimeToLive(nTTL);
                        publisher.sendDiagnosticPacket(packetDiag);
                    }
                    packetDiag = new DiagnosticPacket();
                    packetDiag.setToId(nToId);
                    packetDiag.setTimeToLive(nTTL);
                    publisher.sendDiagnosticPacket(packetDiag);
                }
            }
        }

        protected void onPacketLost(MessagePacket packet) {
            PacketPublisher publisher = (PacketPublisher)this.get_Module();
            if (packet.isOutgoingMultipoint()) {
                int[] anToId = packet.getToMemberSet().toIdArray();
                int c = anToId.length;
                for (int i = 0; i < c; ++i) {
                    Member member = publisher.getMember(anToId[i]);
                    if (member == null) continue;
                    this.onPacketLost(member, packet);
                }
            } else {
                Member member = publisher.getMember(packet.getToId());
                if (member != null) {
                    this.onPacketLost(member, packet);
                }
            }
            if (packet.isNackInProgress()) {
                packet.setNackInProgress(false);
            }
        }

        @Override
        public Object peekNoWait() {
            RecyclingLinkedList list = this.getElementList();
            while (!list.isEmpty()) {
                MessagePacket packet = (MessagePacket)list.get(0);
                if (packet == null) {
                    return null;
                }
                if (packet.isNackInProgress()) {
                    packet.setNackInProgress(false);
                    packet.setPendingResendSkips(packet.getPendingResendSkips() + 1);
                } else if (packet.getPendingResendSkips() > 0) {
                    if (packet == list.remove(0)) {
                        packet.setPendingResendSkips(packet.getPendingResendSkips() - 1);
                        continue;
                    }
                    throw new IllegalStateException();
                }
                return packet;
            }
            return null;
        }

        @Override
        public Object remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object removeNoWait() {
            MessagePacket packet = (MessagePacket)this.peekNoWait();
            while (packet != null) {
                block13: {
                    block10: {
                        block11: {
                            PacketPublisher publisher;
                            long ldtSlowTimeout;
                            long ldtScheduled;
                            block14: {
                                long ldtResendTimeout;
                                long ldtNow;
                                block12: {
                                    if (!packet.isResendNecessary()) break block10;
                                    ldtNow = Base.getSafeTimeMillis();
                                    ldtScheduled = packet.getResendScheduled();
                                    if (ldtScheduled > ldtNow) break;
                                    if (packet != super.removeNoWait()) {
                                        throw new IllegalStateException();
                                    }
                                    ldtResendTimeout = packet.getResendTimeout();
                                    long cMillisTimeout = this.getTimeoutMillis();
                                    long ldtHeuristicTimeout = ldtResendTimeout - (cMillisTimeout >> 1);
                                    ldtSlowTimeout = ldtResendTimeout - (cMillisTimeout >> 2);
                                    if (ldtScheduled <= ldtHeuristicTimeout) break block11;
                                    publisher = (PacketPublisher)this.get_Module();
                                    if (publisher.verifyResendNecessary(packet)) break block12;
                                    this.onPacketDone(packet);
                                    break block13;
                                }
                                int nToId = packet.getToId();
                                if (nToId != 0) {
                                    Member member = publisher.getMember(nToId);
                                    if (member != null) {
                                        member.setLastHeuristicDeathMillis(ldtNow);
                                    }
                                } else {
                                    DependentMemberSet setToMember = packet.getToMemberSet();
                                    if (setToMember != null) {
                                        for (Member member : setToMember) {
                                            member.setLastHeuristicDeathMillis(ldtNow);
                                        }
                                    }
                                }
                                if (ldtScheduled <= ldtResendTimeout) break block14;
                                publisher.onUndeliverablePacket(packet);
                                if (packet.isResendNecessary()) break block11;
                                this.onPacketDone(packet);
                                break block13;
                            }
                            if (ldtScheduled > ldtSlowTimeout) {
                                publisher.onSlowPacket(packet);
                            }
                        }
                        this.onPacketLost(packet);
                        return packet;
                    }
                    if (packet == super.removeNoWait()) {
                        this.onPacketDone(packet);
                    } else {
                        throw new IllegalStateException();
                    }
                }
                packet = (MessagePacket)this.peekNoWait();
            }
            return null;
        }

        public void setDiagnosticMemberSet(MemberSet setMember) {
            this.__m_DiagnosticMemberSet = setMember;
        }

        protected void setDiagnosticTimeToLive(byte cTrips) {
            this.__m_DiagnosticTimeToLive = cTrips;
        }

        protected void setDiagnosticWindowMillis(long cMillis) {
            this.__m_DiagnosticWindowMillis = cMillis;
        }

        public void setLastDiagnosticMillis(long lMillis) {
            this.__m_LastDiagnosticMillis = lMillis;
        }

        protected void setMultipointPacketCount(int cPackets) {
            this.__m_MultipointPacketCount = cPackets;
        }

        public void setResendMillis(int cMillis) {
            this.__m_ResendMillis = Math.max(1, cMillis);
        }

        public void setTimeoutMillis(int cMillis) {
            this.__m_TimeoutMillis = Math.max(10, cMillis);
        }

        static {
            ResendQueue.__initStatic();
        }

        public static class Iterator
        extends Queue.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher$ResendQueue$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }
}

