/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.io.BufferManager;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;

public class PacketListener
extends PacketProcessor {
    private BufferManager __m_BufferManager;
    private int __m_PacketLength;
    private transient long __m_StatsCpu;
    private transient long __m_StatsReset;
    private UdpSocket __m_UdpSocket;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Queue", QueueProcessor.Queue.get_CLASS());
    }

    public PacketListener() {
        this(null, null, true);
    }

    public PacketListener(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Daemon.Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new PacketListener();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/packetProcessor/PacketListener".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public String formatStats() {
        long cCpu = this.getStatsCpu();
        long cTotal = Base.getSafeTimeMillis() - this.getStartTimestamp();
        double dCpu = cTotal == 0L ? 0.0 : (double)cCpu / (double)cTotal;
        return "Cpu=" + cCpu + "ms (" + (float)dCpu + "%)";
    }

    public BufferManager getBufferManager() {
        return this.__m_BufferManager;
    }

    public int getPacketLength() {
        return this.__m_PacketLength;
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public UdpSocket getUdpSocket() {
        return this.__m_UdpSocket;
    }

    @Override
    protected void onEnter() {
        super.onEnter();
        this.resetStats();
    }

    @Override
    protected void onNotify() {
        BufferManager mgr = this.getBufferManager();
        ByteBuffer buffer = mgr.acquire(this.getPacketLength());
        SocketAddress addrSrc = this.getUdpSocket().receive(buffer);
        if (addrSrc == null) {
            mgr.release(buffer);
        } else {
            this.onPacket(addrSrc, mgr.truncate(buffer));
        }
    }

    protected void onPacket(SocketAddress addrSource, ByteBuffer bufPacket) {
    }

    public void onReceiveException(Exception e) {
        throw new EventDeathException(e.toString());
    }

    @Override
    protected void onWait() throws InterruptedException {
    }

    public void resetStats() {
        this.setStatsCpu(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void setBufferManager(BufferManager mgr) {
        this.__m_BufferManager = mgr;
    }

    public void setPacketLength(int pPacketLength) {
        this.__m_PacketLength = pPacketLength;
    }

    protected void setStatsCpu(long cMillis) {
        this.__m_StatsCpu = cMillis;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    public void setUdpSocket(UdpSocket socket) {
        PacketListener._assert(!this.isStarted());
        this.__m_UdpSocket = socket;
    }

    @Override
    public synchronized void start() {
        if (this.getUdpSocket() == null) {
            throw new IllegalStateException("DatagramSocket is required!");
        }
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.getUdpSocket().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return this.get_Name() + ":" + this.formatStats();
    }

    public synchronized boolean tryStart() {
        if (this.getDaemonState() == 0) {
            try {
                this.getUdpSocket().open();
                this.start();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static {
        PacketListener.__initStatic();
    }
}

