/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.LegacyXmlServiceHelper;
import com.tangosol.internal.tracing.Scope;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.io.WrapperBufferInput;
import com.tangosol.io.WrapperBufferOutput;
import com.tangosol.io.WriteBuffer;
import com.tangosol.license.LicensedObject;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.HashHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.SafeLinkedList;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Service
extends QueueProcessor
implements com.tangosol.util.Service {
    private boolean __m_AcceptingClients;
    private transient ClassLoader __m_ContextClassLoader;
    private transient com.tangosol.coherence.component.util.DaemonPool __m_DaemonPool;
    private ServiceDependencies __m_Dependencies;
    private transient EventDispatcher __m_EventDispatcher;
    private Listeners __m_EventListeners;
    private OperationalContext __m_OperationalContext;
    private transient Serializer __m_Serializer;
    private SerializerFactory __m_SerializerFactory;
    private Map __m_SerializerMap;
    public static final int SERVICE_INITIAL = 0;
    public static final int SERVICE_STARTED = 2;
    public static final int SERVICE_STARTING = 1;
    public static final int SERVICE_STOPPED = 4;
    public static final int SERVICE_STOPPING = 3;
    private XmlElement __m_ServiceConfig;
    private String __m_ServiceName;
    private volatile int __m_ServiceState;
    private transient long __m_StartupTimeout;
    private transient long __m_StatsCpu;
    private transient long __m_StatsReceived;
    private transient long __m_StatsReset;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("DispatchEvent", DispatchEvent.get_CLASS());
        __mapChildren.put("Queue", QueueProcessor.Queue.get_CLASS());
    }

    public Service(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_EventListeners = new Listeners();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    @Override
    public boolean isNonBlocking() {
        return true;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    protected void addEventListener(EventListener l) {
        this.ensureEventDispatcher();
        this.getEventListeners().add(l);
    }

    @Override
    public void addServiceListener(ServiceListener l) {
        this.addEventListener(l);
    }

    public static long adjustTimeout(long lDefaultTimeout, long lContextTimeout) {
        long TIMEOUT_DEFAULT = 0L;
        long TIMEOUT_NONE = -1L;
        return lContextTimeout == 0L ? lDefaultTimeout : (lContextTimeout == -1L ? 0L : lContextTimeout);
    }

    protected DefaultServiceDependencies cloneDependencies(ServiceDependencies deps) {
        return new DefaultServiceDependencies(deps);
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        this.setDependencies(LegacyXmlServiceHelper.fromXml(xml, new DefaultServiceDependencies(), this.getOperationalContext()));
        this.setServiceConfig(xml);
    }

    protected void dispatchEvent(EventObject evt, Listeners listeners) {
        if (listeners.isEmpty()) {
            return;
        }
        EventListener[] aSyncListeners = listeners.getSynchronousListeners();
        EventListener[] aAsyncListeners = listeners.getAsynchronousListeners();
        DispatchEvent task = this.instantiateDispatchEvent();
        task.setEvent(evt);
        if (aSyncListeners.length > 0) {
            try {
                task.setListeners(aSyncListeners);
                task.run();
            }
            catch (Throwable t) {
                Service._trace("An exception occurred while dispatching the following event:\n" + String.valueOf(task), 1);
                Service._trace(t);
                Service._trace("The service thread has logged the exception and is continuing.", 1);
            }
        }
        if (aAsyncListeners.length > 0) {
            task.setListeners(aAsyncListeners);
            this.ensureEventDispatcher().getQueue().add(task);
        }
    }

    public void dispatchServiceEvent(int nEvent) {
        Listeners listeners = this.getEventListeners();
        if (!listeners.isEmpty()) {
            this.dispatchEvent(new ServiceEvent(this, nEvent), listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventDispatcher ensureEventDispatcher() {
        EventDispatcher dispatcher = this.getEventDispatcher();
        if (dispatcher == null) {
            Service service = this;
            synchronized (service) {
                dispatcher = this.getEventDispatcher();
                if (dispatcher == null) {
                    dispatcher = (EventDispatcher)this._findChild("EventDispatcher");
                    if (!this.isExiting()) {
                        long cTimeout = this.getDefaultGuardTimeout();
                        String sTimeout = Config.getProperty("coherence.events.timeout");
                        if (sTimeout != null) {
                            try {
                                cTimeout = Long.parseLong(sTimeout);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (cTimeout > 0L) {
                            this.guard(dispatcher.getGuardable(), cTimeout, this.getDefaultGuardRecovery());
                        }
                        dispatcher.setPriority(this.getDependencies().getEventDispatcherThreadPriority());
                        dispatcher.setThreadGroup(this.getThreadGroup());
                        dispatcher.start();
                    }
                    this.setEventDispatcher(dispatcher);
                }
            }
        }
        return dispatcher;
    }

    public Serializer ensureSerializer() {
        Serializer serializer = this.getSerializer();
        if (serializer == null) {
            serializer = this.instantiateSerializer(this.getContextClassLoader());
            this.setSerializer(serializer);
        }
        return serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializer ensureSerializer(ClassLoader loader) {
        Map map;
        ClassLoader loaderCtx = this.getContextClassLoader();
        if (loader == null) {
            loader = loaderCtx;
        }
        Serializer serializer = this.ensureSerializer();
        if (loader == loaderCtx || !(serializer instanceof ClassLoaderAware)) {
            return serializer;
        }
        SerializerFactory factory = this.getSerializerFactory();
        if (factory == null) {
            return ExternalizableHelper.ensureSerializer(loader);
        }
        Map map2 = map = this.getSerializerMap();
        synchronized (map2) {
            serializer = (Serializer)map.get(loader);
            if (serializer == null) {
                serializer = factory.createSerializer(loader);
                map.put(loader, serializer);
            }
        }
        return serializer;
    }

    public static String ensureStringValue(XmlElement xmlConfig, String sName, String sDefault) {
        String sValue = xmlConfig.getSafeElement(sName).getString(sDefault);
        if (sValue == null || sValue.length() == 0) {
            throw new IllegalArgumentException("the required \"" + sName + "\" configuration element is missing or empty");
        }
        return sValue;
    }

    public static String formatServiceStateName(int nState) {
        switch (nState) {
            case 0: {
                return "SERVICE_INITIAL";
            }
            case 1: {
                return "SERVICE_STARTING";
            }
            case 2: {
                return "SERVICE_STARTED";
            }
            case 3: {
                return "SERVICE_STOPPING";
            }
            case 4: {
                return "SERVICE_STOPPED";
            }
        }
        return "<unknown>";
    }

    public String formatStats() {
        long cCpu = this.getStatsCpu();
        long cTotal = Base.getSafeTimeMillis() - this.getStatsReset();
        long cMsgs = this.getStatsReceived();
        double dCpu = cTotal == 0L ? 0.0 : (double)cCpu / (double)cTotal;
        double dThru = cCpu == 0L ? 0.0 : (double)cMsgs * 1000.0 / (double)cCpu;
        dCpu = (double)((int)(dCpu * 1000.0)) / 10.0;
        StringBuffer sb = new StringBuffer();
        sb.append("Cpu=").append(cCpu).append("ms (").append(dCpu).append("%), Messages=").append(cMsgs).append(", Throughput=").append((float)dThru).append("msg/sec");
        com.tangosol.coherence.component.util.DaemonPool pool = this.getDaemonPool();
        if (pool.isStarted()) {
            long cPoolTotal = pool.getStatsActiveMillis();
            long cTasks = pool.getStatsTaskCount();
            long cHung = pool.getStatsHungCount();
            float flAvgThread = cTotal == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTotal);
            float flAvgTask = cTasks == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTasks);
            sb.append(", AverageActiveThreadCount=").append(flAvgThread).append(", Tasks=").append(cTasks).append(", AverageTaskDuration=").append(flAvgTask).append("ms, MaximumBacklog=").append(pool.getStatsMaxBacklog());
            if (cHung > 0L) {
                sb.append(", HungTaskCount=").append(cHung).append(", HungMaxDuration=").append(pool.getStatsHungDuration()).append(", HungMaxId=").append(pool.getStatsHungTaskId());
            }
        }
        return sb.toString();
    }

    @Override
    public final Object get_Feed() {
        try {
            LicensedObject.LicenseData[] aLic = LicensedObject.getLicenseData();
            ArrayList<LicensedObject.LicenseData> list = new ArrayList<LicensedObject.LicenseData>();
            int nMaxType = -1;
            for (LicensedObject.LicenseData lic : aLic) {
                int nType;
                if (LicensedObject.getLicenseFailure(lic) != null || (nType = lic.nLicenseType) < nMaxType) continue;
                nMaxType = nType;
                list.add(lic);
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                LicensedObject.LicenseData lic = (LicensedObject.LicenseData)iter.next();
                if (lic.nLicenseType >= nMaxType) continue;
                iter.remove();
            }
            return list.toArray(new LicensedObject.LicenseData[list.size()]);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.__m_ContextClassLoader;
    }

    public com.tangosol.coherence.component.util.DaemonPool getDaemonPool() {
        com.tangosol.coherence.component.util.DaemonPool pool = this.__m_DaemonPool;
        if (pool == null) {
            pool = (com.tangosol.coherence.component.util.DaemonPool)this._findChild("DaemonPool");
            this.setDaemonPool(pool);
        }
        return pool;
    }

    public String getDecoratedThreadName() {
        int nState = this.getServiceState();
        String sState = nState == 2 ? "" : "|" + Service.formatServiceStateName(nState);
        return this.getThreadName() + sState;
    }

    public ServiceDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public String getDescription() {
        return null;
    }

    public EventDispatcher getEventDispatcher() {
        return this.__m_EventDispatcher;
    }

    public Listeners getEventListeners() {
        return this.__m_EventListeners;
    }

    public OperationalContext getOperationalContext() {
        return this.__m_OperationalContext;
    }

    public Serializer getSerializer() {
        return this.__m_Serializer;
    }

    public SerializerFactory getSerializerFactory() {
        return this.__m_SerializerFactory;
    }

    public Map getSerializerMap() {
        return this.__m_SerializerMap;
    }

    public XmlElement getServiceConfig() {
        return this.__m_ServiceConfig;
    }

    public String getServiceName() {
        String sName = this.__m_ServiceName;
        return sName == null ? this.get_Name() : sName;
    }

    public int getServiceState() {
        return this.__m_ServiceState;
    }

    public String getServiceStateName() {
        return Service.formatServiceStateName(this.getServiceState());
    }

    public long getStartupTimeout() {
        return this.__m_StartupTimeout;
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsReceived() {
        return this.__m_StatsReceived;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    @Override
    public String getThreadName() {
        return this.getServiceName();
    }

    @Override
    public long getWaitMillis() {
        long cHungThreshold;
        long cWait = super.getWaitMillis();
        com.tangosol.coherence.component.util.DaemonPool pool = this.getDaemonPool();
        if (pool.isStarted() && (cHungThreshold = pool.getHungThreshold()) > 0L) {
            long cWaitHungCheck = Math.max(1L, Math.min(cHungThreshold >> 2, 1000L));
            cWait = cWait == 0L ? cWaitHungCheck : Math.min(cWait, cWaitHungCheck);
        }
        return cWait;
    }

    @Override
    protected void halt() {
        super.halt();
        ((DaemonPool)this.getDaemonPool()).halt();
    }

    @Override
    protected void heartbeat(long cMillis) {
        if (!((DaemonPool)this.getDaemonPool()).isStuck()) {
            super.heartbeat(cMillis);
        }
    }

    protected DispatchEvent instantiateDispatchEvent() {
        return (DispatchEvent)this._newChild("DispatchEvent");
    }

    protected Serializer instantiateSerializer(ClassLoader loader) {
        SerializerFactory factory = this.getSerializerFactory();
        return factory == null ? ExternalizableHelper.ensureSerializer(loader) : factory.createSerializer(loader);
    }

    public boolean isAcceptingClients() {
        return this.__m_AcceptingClients;
    }

    @Override
    public boolean isRunning() {
        return this.isAcceptingClients() && !this.isExiting();
    }

    public boolean isServiceThread(boolean fStrict) {
        Thread thread = Thread.currentThread();
        EventDispatcher dispatcher = this.getEventDispatcher();
        if (thread == this.getThread() || dispatcher != null && thread == dispatcher.getThread()) {
            return true;
        }
        if (!fStrict) {
            com.tangosol.coherence.component.util.DaemonPool pool = this.getDaemonPool();
            return pool != null && pool.getThreadGroup() == thread.getThreadGroup();
        }
        return false;
    }

    public boolean isStopped() {
        return this.getServiceState() == 4;
    }

    public Span.Builder newTracingSpan(String sStage, Object op) {
        Span.Builder bldSpan = TracingHelper.newSpan(sStage, op).withMetadata(Span.Type.COMPONENT.key(), this.getServiceName());
        if (op instanceof RequestMessage) {
            bldSpan.withMetadata("internal.message", ((RequestMessage)op).getMessageType() < 0);
        }
        return bldSpan;
    }

    public static void notifyBacklogNormal(SafeLinkedList list) {
        Continuation cont;
        if (list == null) {
            return;
        }
        while ((cont = (Continuation)list.removeFirst()) != null) {
            try {
                cont.proceed(null);
            }
            catch (Throwable e) {
                Service._trace("The following exception was thrown by the backlog continuation:", 1);
                Service._trace(e);
                Service._trace("(The service thread has logged the exception and is continuing.)", 1);
            }
        }
    }

    protected void onDependencies(ServiceDependencies deps) {
        int cThreads = deps.getWorkerThreadCountMin();
        if (cThreads > 0) {
            com.tangosol.coherence.component.util.DaemonPool pool = this.getDaemonPool();
            pool.setDaemonCount(cThreads);
            pool.setDaemonCountMax(deps.getWorkerThreadCountMax());
            pool.setDaemonCountMin(cThreads);
            pool.setHungThreshold(deps.getTaskHungThresholdMillis());
            pool.setName(this.getServiceName());
            pool.setTaskTimeout(deps.getTaskTimeoutMillis());
            pool.setThreadPriority(deps.getWorkerThreadPriority());
        }
        this.setPriority(deps.getThreadPriority());
        this.setSerializerFactory(deps.getSerializerFactory());
    }

    @Override
    protected void onEnter() {
        super.onEnter();
        this.resetStats();
        this.setServiceState(2);
    }

    @Override
    public void onException(Throwable e) {
        if (this.getServiceState() < 2 || this.getServiceState() == 2 && !this.isAcceptingClients()) {
            this.setStartException(e);
        }
        super.onException(e);
    }

    @Override
    protected void onExit() {
        Security security;
        super.onExit();
        com.tangosol.coherence.component.util.DaemonPool pool = this.getDaemonPool();
        if (pool.isStarted()) {
            int cActive;
            pool.stop();
            if (!pool.join(1000L) && (cActive = pool.getActiveDaemonCount()) > 0) {
                Service._trace("failed to stop " + cActive + " worker threads; abandoning", 2);
            }
        }
        try {
            this.setServiceState(4);
        }
        catch (Throwable e) {
            Service._trace("Exception occurred during exiting:\n " + Service.getStackTrace(e), 4);
        }
        EventDispatcher daemon = this.getEventDispatcher();
        if (daemon != null) {
            daemon.stop();
            if (!daemon.join(1000L)) {
                Service._trace("failed to stop " + String.valueOf(daemon) + "; abandoning", 2);
            }
        }
        if ((security = Security.getInstance()) != null) {
            security.releaseSecureContext(this.getServiceName());
        }
    }

    @Override
    protected void onInterval() {
        com.tangosol.coherence.component.util.DaemonPool pool = this.getDaemonPool();
        if (pool.isStarted()) {
            pool.checkHungTasks();
        }
        super.onInterval();
    }

    public void onServiceStarted() {
        this.setAcceptingClients(true);
    }

    protected void onServiceStarting() {
    }

    protected void onServiceState(int nState) {
        switch (nState) {
            case 1: {
                this.onServiceStarting();
                break;
            }
            case 2: {
                this.onServiceStarted();
                break;
            }
            case 3: {
                this.onServiceStopping();
                break;
            }
            case 4: {
                this.onServiceStopped();
                break;
            }
            default: {
                Service._assert(false);
            }
        }
    }

    protected void onServiceStopped() {
        this.setAcceptingClients(false);
    }

    protected void onServiceStopping() {
        this.setAcceptingClients(false);
    }

    protected void onStartupTimeout() {
    }

    protected static long parseTime(XmlElement xml, String sName, long cDefault) {
        return XmlHelper.parseTime(xml, sName, cDefault);
    }

    public Object readObject(ReadBuffer.BufferInput in) throws IOException {
        return this.ensureSerializer().deserialize(in);
    }

    public Object readObject(DataInput in) throws IOException {
        return this.ensureSerializer().deserialize(in instanceof ReadBuffer.BufferInput ? (ReadBuffer.BufferInput)in : new WrapperBufferInput(in, this.getContextClassLoader()));
    }

    protected void removeEventListener(EventListener l) {
        this.getEventListeners().remove(l);
    }

    @Override
    public void removeServiceListener(ServiceListener l) {
        this.removeEventListener(l);
    }

    public void resetStats() {
        this.getDaemonPool().resetStats();
        this.setStatsCpu(0L);
        this.setStatsReceived(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
        EventDispatcher dispatcher = this.getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.resetStats();
        }
    }

    public synchronized void setAcceptingClients(boolean fAccepting) {
        this.__m_AcceptingClients = fAccepting;
        this.notifyAll();
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        if (this.getContextClassLoader() != loader) {
            this.__m_ContextClassLoader = loader;
            if (this.getSerializer() != null) {
                this.setSerializer(this.instantiateSerializer(loader));
            }
        }
    }

    protected void setDaemonPool(com.tangosol.coherence.component.util.DaemonPool pool) {
        this.__m_DaemonPool = pool;
    }

    public final void setDependencies(ServiceDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Dependencies already set");
        }
        if (this.getServiceState() > 0) {
            throw new IllegalStateException("Service has already been initialized");
        }
        this.__m_Dependencies = this.cloneDependencies(deps).validate();
        this.onDependencies(this.getDependencies());
    }

    private void setEventDispatcher(EventDispatcher daemon) {
        this.__m_EventDispatcher = daemon;
    }

    private void setEventListeners(Listeners listeners) {
        this.__m_EventListeners = listeners;
    }

    public void setOperationalContext(OperationalContext ctx) {
        Service._assert(this.getOperationalContext() == null);
        this.__m_OperationalContext = ctx;
    }

    protected void setSerializer(Serializer serializer) {
        this.__m_Serializer = serializer;
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this.__m_SerializerFactory = factory;
    }

    protected void setSerializerMap(Map map) {
        this.__m_SerializerMap = map;
    }

    public void setServiceConfig(XmlElement xml) {
        if (this.getServiceState() != 0) {
            throw new IllegalStateException("Configuration cannot be specified once the service has been started: " + String.valueOf(this));
        }
        this.__m_ServiceConfig = xml;
    }

    public void setServiceName(String sName) {
        Service._assert(!this.isStarted());
        this.__m_ServiceName = sName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceState(int nState) {
        int nPrevState;
        Service service = this;
        synchronized (service) {
            nPrevState = this.getServiceState();
            if (nState > nPrevState) {
                this.__m_ServiceState = nState;
            }
        }
        if (nState > nPrevState) {
            this.updateServiceThreadName();
            this.onServiceState(nState);
            switch (nState) {
                case 1: {
                    this.dispatchServiceEvent(1);
                    break;
                }
                case 2: {
                    this.dispatchServiceEvent(2);
                    break;
                }
                case 3: {
                    this.dispatchServiceEvent(3);
                    break;
                }
                case 4: {
                    this.dispatchServiceEvent(4);
                    break;
                }
                default: {
                    Service._assert(false);
                    break;
                }
            }
        } else {
            Service._assert(nState == nPrevState);
        }
    }

    public void setStartupTimeout(long cMillis) {
        this.__m_StartupTimeout = cMillis;
    }

    protected void setStatsCpu(long cMillis) {
        this.__m_StatsCpu = cMillis;
    }

    protected void setStatsReceived(long cMsgs) {
        this.__m_StatsReceived = cMsgs;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    @Override
    public synchronized void shutdown() {
        this.stop();
        if (this.getThread() != Thread.currentThread()) {
            while (this.getDaemonState() != 4) {
                try {
                    Blocking.wait(this, 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread();
                    Thread.interrupted();
                    throw Base.ensureRuntimeException(e);
                }
            }
            this.waitForEventDispatcher();
        }
    }

    @Override
    public synchronized void start() {
        long ldtCutoff;
        Service._assert(this.getServiceState() <= 2, "Service restart is illegal (ServiceName=" + this.getServiceName() + ")");
        super.start();
        long cTimeout = this.getStartupTimeout();
        long l = ldtCutoff = cTimeout > 0L ? Base.getSafeTimeMillis() + cTimeout : Long.MAX_VALUE;
        while (this.isStarted() && this.getServiceState() <= 2 && !this.isAcceptingClients()) {
            try {
                Blocking.wait(this, 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WrapperException(e);
            }
            if (Base.getSafeTimeMillis() <= ldtCutoff) continue;
            this.onStartupTimeout();
            break;
        }
        if (this.getServiceState() != 2) {
            Throwable e = this.getStartException();
            String s = "Failed to start Service \"" + this.getServiceName() + "\" (ServiceState=" + this.getServiceStateName() + ")";
            throw e == null ? new RuntimeException(s) : new WrapperException(e, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.isStarted()) {
            Service service = this;
            synchronized (service) {
                if (!this.isStarted()) {
                    this.setServiceState(4);
                    return;
                }
            }
        }
        super.stop();
        if (this.getThread() == Thread.currentThread()) {
            this.setServiceState(4);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{Name=").append(this.getServiceName()).append(", State=").append("(").append(this.getServiceStateName()).append(')');
        String sDesc = this.getDescription();
        if (sDesc != null && sDesc.length() > 0) {
            sb.append(", ").append(sDesc);
        }
        sb.append('}');
        return sb.toString();
    }

    public String toString(String s) {
        return HashHelper.hash(s);
    }

    protected void updateServiceThreadName() {
        Thread thread = this.getThread();
        if (thread != null) {
            try {
                thread.setName(this.getDecoratedThreadName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAcceptingClients() {
        while (!this.isAcceptingClients()) {
            Service service = this;
            synchronized (service) {
                if (this.getServiceState() > 2) {
                    Throwable e = this.getStartException();
                    String s = "Failed to start Service \"" + this.getServiceName() + "\" (ServiceState=" + this.getServiceStateName() + ")";
                    throw e == null ? new RuntimeException(s) : new WrapperException(e, s);
                }
                if (!this.isAcceptingClients()) {
                    try {
                        Blocking.wait(this);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new WrapperException(e);
                    }
                }
            }
        }
    }

    protected void waitForEventDispatcher() {
        EventDispatcher dispatcher = this.getEventDispatcher();
        if (dispatcher != null) {
            try {
                dispatcher.drainOverflow(5000L, 1);
                if (dispatcher.isDispatching()) {
                    Blocking.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    public void writeObject(WriteBuffer.BufferOutput out, Object o) throws IOException {
        this.ensureSerializer().serialize(out, o);
    }

    public void writeObject(DataOutput out, Object o) throws IOException {
        this.ensureSerializer().serialize(out instanceof WriteBuffer.BufferOutput ? (WriteBuffer.BufferOutput)out : new WrapperBufferOutput(out), o);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new UnsupportedOperationException("Service is not serializable: " + String.valueOf(this));
    }

    static {
        Service.__initStatic();
    }

    public static class DispatchEvent
    extends Util
    implements Runnable {
        private EventObject __m_Event;
        private EventListener[] __m_Listeners;

        public DispatchEvent() {
            this(null, null, true);
        }

        public DispatchEvent(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DispatchEvent();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$DispatchEvent".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public EventObject getEvent() {
            return this.__m_Event;
        }

        public EventListener[] getListeners() {
            return this.__m_Listeners;
        }

        @Override
        public void onInit() {
        }

        @Override
        public void run() {
            ((ServiceEvent)this.getEvent()).dispatch(this.getListeners());
        }

        public void setEvent(EventObject evt) {
            this.__m_Event = evt;
        }

        public void setListeners(EventListener[] listeners) {
            this.__m_Listeners = listeners;
        }

        @Override
        public String toString() {
            return this.get_Name() + ": " + String.valueOf(this.getEvent());
        }
    }

    public static class EventDispatcher
    extends QueueProcessor {
        private volatile SafeLinkedList __m_BacklogContinuations;
        private int __m_CloggedCount;
        private int __m_CloggedDelay;
        private volatile boolean __m_Dispatching;
        private volatile long __m_EventCount;
        private transient long __m_LastLogTime;
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Queue", Queue.get_CLASS());
        }

        public EventDispatcher() {
            this(null, null, true);
        }

        public EventDispatcher(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setCloggedCount(1024);
                this.setCloggedDelay(32);
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new Guard("Guard", this, true), "Guard");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EventDispatcher();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$EventDispatcher".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkBacklog(Continuation continuation) {
            long cMaxEvents = this.getCloggedCount();
            if (cMaxEvents > 0L && (long)this.getQueue().size() > cMaxEvents) {
                if (continuation != null) {
                    SafeLinkedList list = this.getBacklogContinuations();
                    if (list == null) {
                        EventDispatcher eventDispatcher = this;
                        synchronized (eventDispatcher) {
                            list = this.getBacklogContinuations();
                            if (list == null) {
                                list = new SafeLinkedList();
                                this.setBacklogContinuations(list);
                            }
                        }
                    }
                    list.add(continuation);
                    Service service = (Service)this.get_Module();
                    if (service.getServiceState() == 4) {
                        return !list.remove(continuation);
                    }
                }
                return true;
            }
            return false;
        }

        public long drainOverflow(long cMillisTimeout) throws InterruptedException {
            return this.drainOverflow(cMillisTimeout, this.getCloggedCount());
        }

        public long drainOverflow(long cMillisTimeout, int cMaxEvents) throws InterruptedException {
            return cMaxEvents <= 0 || this.getQueue().size() < cMaxEvents ? cMillisTimeout : this.drainOverflowComplex(cMillisTimeout, cMaxEvents);
        }

        protected long drainOverflowComplex(long cMillisTimeout, int cMaxEvents) throws InterruptedException {
            int cEvents;
            if (Thread.currentThread() == this.getThread()) {
                return cMillisTimeout;
            }
            com.tangosol.coherence.component.util.Queue queue = this.getQueue();
            Object oHead = null;
            int cEventsPrev = 0;
            int nIter = 0;
            long lGrowthInterval = 5000L;
            long ldtGrowthCheck = 0L;
            long ldtTimeout = 0L;
            long cMillisDelay = this.getCloggedDelay();
            while (this.isStarted() && (cEvents = queue.size()) >= cMaxEvents) {
                long ldtNow = Base.getSafeTimeMillis();
                if (nIter == 0) {
                    oHead = queue.peekNoWait();
                    ldtGrowthCheck = ldtNow + lGrowthInterval;
                    cEventsPrev = cEvents;
                    if (cMillisTimeout != 0L) {
                        ldtTimeout = ldtNow + cMillisTimeout;
                        cMillisDelay = Math.min(cMillisDelay, cMillisTimeout);
                    }
                } else if (cMillisTimeout != 0L) {
                    long cMillisLeft = ldtTimeout - ldtNow;
                    if (cMillisLeft <= 0L) {
                        throw new RequestTimeoutException("Request timed out");
                    }
                    cMillisDelay = Math.min(cMillisDelay, cMillisLeft);
                }
                Blocking.sleep(cMillisDelay);
                if (++nIter % 10 != 0) continue;
                Object oHeadCurrent = queue.peekNoWait();
                if (oHead == oHeadCurrent) {
                    Service service = (Service)this.get_Module();
                    if (service.isStopped() || ldtNow <= this.getLastLogTime() + 60000L) break;
                    EventDispatcher._trace("The event queue appears to be stuck.", 2);
                    GuardSupport.logStackTraces();
                    this.setLastLogTime(ldtNow);
                    break;
                }
                if (ldtNow > ldtGrowthCheck) {
                    if (cEvents >= cEventsPrev) {
                        EventDispatcher._trace("The events are processed at a slower rate than they arrive. During the last " + lGrowthInterval + "ms, the event  backlog went from " + cEventsPrev + " to " + cEvents, 2);
                    }
                    ldtGrowthCheck = ldtNow + lGrowthInterval;
                    cEventsPrev = cEvents;
                }
                oHead = oHeadCurrent;
            }
            return cMillisTimeout == 0L ? 0L : Math.max(1L, ldtTimeout - Base.getSafeTimeMillis());
        }

        protected void evaluateBacklog() {
            SafeLinkedList list = this.getBacklogContinuations();
            if (list != null && !list.isEmpty()) {
                long cNormal = (this.getCloggedCount() >> 2) * 3;
                if ((long)this.getQueue().size() < cNormal) {
                    Service.notifyBacklogNormal(list);
                }
            }
        }

        public SafeLinkedList getBacklogContinuations() {
            return this.__m_BacklogContinuations;
        }

        public int getCloggedCount() {
            return this.__m_CloggedCount;
        }

        public int getCloggedDelay() {
            return this.__m_CloggedDelay;
        }

        public long getEventCount() {
            return this.__m_EventCount;
        }

        public long getLastLogTime() {
            return this.__m_LastLogTime;
        }

        @Override
        public String getThreadName() {
            return ((Service)this.get_Module()).getThreadName() + ":" + super.getThreadName();
        }

        @Override
        public long getWaitMillis() {
            long cWait = super.getWaitMillis();
            if (this.isGuarded() || this.isGuardian()) {
                long cMaxWait = 1000L;
                cWait = cWait == 0L ? cMaxWait : Math.min(cWait, cMaxWait);
            }
            return cWait;
        }

        public boolean isDispatching() {
            return this.__m_Dispatching;
        }

        @Override
        protected void onEnter() {
            super.onEnter();
            if (this.isGuarded()) {
                GuardSupport.setThreadContext(this.getGuardable().getContext());
            }
        }

        @Override
        protected void onException(Throwable e) {
            if (!this.isExiting()) {
                EventDispatcher._trace("The following exception was caught by the event dispatcher:", 1);
                EventDispatcher._trace(e);
                EventDispatcher._trace("(The service event thread has logged the exception and is continuing.)", 1);
            }
        }

        @Override
        protected void onExit() {
            this.onNotify();
            super.onExit();
        }

        @Override
        public void onInit() {
            try {
                String sMaxEvents = Config.getProperty("coherence.events.limit");
                String sDelay = Config.getProperty("coherence.events.delay");
                if (sMaxEvents != null) {
                    this.setCloggedCount(Integer.parseInt(sMaxEvents));
                }
                if (sDelay != null) {
                    this.setCloggedDelay(Integer.parseInt(sDelay));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.onInit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onNotify() {
            super.onNotify();
            com.tangosol.coherence.component.util.Queue queue = this.getQueue();
            Runnable task = null;
            this.setDispatching(true);
            try {
                int cEvents = 0;
                long cMax = 1L;
                long cSoftTimeout = (long)((float)this.getDefaultGuardTimeout() * this.getDefaultGuardRecovery());
                long ldtStartTime = Base.getSafeTimeMillis();
                long ldtSoftTimeout = ldtStartTime + cSoftTimeout;
                do {
                    if ((task = (Runnable)queue.removeNoWait()) == null) {
                        Service.notifyBacklogNormal(this.getBacklogContinuations());
                        break;
                    }
                    task.run();
                    long ldtNow = Base.getSafeTimeMillis();
                    cMax = Math.max(cMax, ldtNow - ldtStartTime);
                    if (ldtNow + (cMax << 2) > ldtSoftTimeout) {
                        this.heartbeat();
                        ldtSoftTimeout = ldtNow + cSoftTimeout;
                    }
                    ldtStartTime = ldtNow;
                } while (++cEvents < 512);
                if (cEvents > 0) {
                    this.setEventCount(this.getEventCount() + (long)cEvents);
                }
                this.evaluateBacklog();
            }
            catch (Throwable e) {
                if (((Service)this.get_Module()).isRunning()) {
                    EventDispatcher._trace("An exception occurred while dispatching the following event:\n" + String.valueOf(task), 1);
                    this.onException(e);
                }
            }
            finally {
                this.setDispatching(false);
            }
        }

        @Override
        protected void onWait() throws InterruptedException {
            if (this.isGuarded()) {
                this.heartbeat();
            }
            super.onWait();
        }

        public void resetStats() {
            this.setEventCount(0L);
        }

        protected void setBacklogContinuations(SafeLinkedList listContinuations) {
            this.__m_BacklogContinuations = listContinuations;
        }

        public void setCloggedCount(int cMaxEvents) {
            this.__m_CloggedCount = cMaxEvents;
        }

        public void setCloggedDelay(int cMillis) {
            this.__m_CloggedDelay = Math.max(1, cMillis);
        }

        protected void setDispatching(boolean fDispatching) {
            this.__m_Dispatching = fDispatching;
        }

        protected void setEventCount(long cMillis) {
            this.__m_EventCount = cMillis;
        }

        protected void setLastLogTime(long ldtLog) {
            this.__m_LastLogTime = ldtLog;
        }

        static {
            EventDispatcher.__initStatic();
        }

        public static class Queue
        extends QueueProcessor.Queue {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Iterator", Iterator.get_CLASS());
            }

            public Queue() {
                this(null, null, true);
            }

            public Queue(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setElementList(new RecyclingLinkedList());
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Queue();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$EventDispatcher$Queue".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            @Override
            public boolean add(Object oElement) {
                Service service = (Service)this.get_Module();
                int nState = service.getServiceState();
                switch (nState) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return super.add((Runnable)oElement);
                    }
                }
                throw new IllegalStateException("Illegal service state " + nState + " for service " + String.valueOf(service));
            }

            static {
                Queue.__initStatic();
            }

            public static class Iterator
            extends QueueProcessor.Queue.Iterator {
                public Iterator() {
                    this(null, null, true);
                }

                public Iterator(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Iterator();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$EventDispatcher$Queue$Iterator".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }
            }
        }

        public static class Guard
        extends Daemon.Guard {
            public Guard() {
                this(null, null, true);
            }

            public Guard(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Guard();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$EventDispatcher$Guard".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public void terminate() {
                Service service = (Service)this.get_Module();
                service.getGuardable().terminate();
            }
        }
    }

    public static class DaemonPool
    extends com.tangosol.coherence.component.util.DaemonPool {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Daemon", Daemon.get_CLASS());
            __mapChildren.put("ResizeTask", ResizeTask.get_CLASS());
            __mapChildren.put("ScheduleTask", ScheduleTask.get_CLASS());
            __mapChildren.put("StartTask", StartTask.get_CLASS());
            __mapChildren.put("StopTask", StopTask.get_CLASS());
            __mapChildren.put("WorkSlot", WorkSlot.get_CLASS());
            __mapChildren.put("WrapperTask", WrapperTask.get_CLASS());
        }

        public DaemonPool() {
            this(null, null, true);
        }

        public DaemonPool(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setAbandonThreshold(8);
                this.setDaemonCountMax(Integer.MAX_VALUE);
                this.setDaemonCountMin(1);
                this.setScheduledTasks(new HashSet());
                this.setStatsTaskAddCount(new AtomicLong());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new DaemonPool();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$DaemonPool".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public String getName() {
            Object sName = super.getName();
            if (sName == null) {
                sName = ((Service)this.get_Module()).getServiceName() + "Pool";
            }
            return sName;
        }

        @Override
        public void halt() {
            super.halt();
        }

        static {
            DaemonPool.__initStatic();
        }

        public static class Daemon
        extends DaemonPool.Daemon {
            public Daemon() {
                this(null, null, true);
            }

            public Daemon(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setDaemonState(0);
                    this.setDefaultGuardRecovery(0.9f);
                    this.setDefaultGuardTimeout(60000L);
                    this.setNotifier(new SingleWaiterMultiNotifier());
                    this.setThreadName("Worker");
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this._addChild(new Guard("Guard", this, true), "Guard");
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Daemon();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$DaemonPool$Daemon".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Thread instantiateThread() {
                Service service = (Service)this.get_Module();
                Thread thread = super.instantiateThread();
                thread.setContextClassLoader(service.getContextClassLoader());
                return thread;
            }

            @Override
            protected void onException(Throwable e) {
                if (this.isExiting()) {
                    super.onException(e);
                } else {
                    ((Service)this.get_Module()).onException(e);
                }
            }

            public static class Guard
            extends DaemonPool.Daemon.Guard {
                private static ListMap __mapChildren;

                private static void __initStatic() {
                    __mapChildren = new ListMap();
                    __mapChildren.put("Abandon", Abandon.get_CLASS());
                }

                public Guard() {
                    this(null, null, true);
                }

                public Guard(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Guard();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$DaemonPool$Daemon$Guard".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                protected Map get_ChildClasses() {
                    return __mapChildren;
                }

                static {
                    Guard.__initStatic();
                }

                public static class Abandon
                extends DaemonPool.Daemon.Guard.Abandon {
                    public Abandon() {
                        this(null, null, true);
                    }

                    public Abandon(String sName, Component compParent, boolean fInit) {
                        super(sName, compParent, false);
                        if (fInit) {
                            this.__init();
                        }
                    }

                    @Override
                    public void __init() {
                        this.__initPrivate();
                        this.set_Constructed(true);
                    }

                    @Override
                    protected void __initPrivate() {
                        super.__initPrivate();
                    }

                    public static Component get_Instance() {
                        return new Abandon();
                    }

                    public static Class get_CLASS() {
                        Class<?> clz;
                        try {
                            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$DaemonPool$Daemon$Guard$Abandon".replace('/', '.'));
                        }
                        catch (ClassNotFoundException e) {
                            throw new NoClassDefFoundError(e.getMessage());
                        }
                        return clz;
                    }

                    private Component get_Module() {
                        return this.get_Parent().get_Parent().get_Parent().get_Parent();
                    }
                }
            }
        }

        public static class ResizeTask
        extends DaemonPool.ResizeTask {
            public ResizeTask() {
                this(null, null, true);
            }

            public ResizeTask(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ResizeTask();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$DaemonPool$ResizeTask".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class ScheduleTask
        extends DaemonPool.ScheduleTask {
            public ScheduleTask() {
                this(null, null, true);
            }

            public ScheduleTask(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new ScheduleTask();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$DaemonPool$ScheduleTask".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class StartTask
        extends DaemonPool.StartTask {
            public StartTask() {
                this(null, null, true);
            }

            public StartTask(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new StartTask();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$DaemonPool$StartTask".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class StopTask
        extends DaemonPool.StopTask {
            public StopTask() {
                this(null, null, true);
            }

            public StopTask(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new StopTask();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$DaemonPool$StopTask".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class WorkSlot
        extends DaemonPool.WorkSlot {
            public WorkSlot() {
                this(null, null, true);
            }

            public WorkSlot(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                try {
                    this.setIndex(-1);
                }
                catch (Exception e) {
                    throw new WrapperException(e);
                }
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new WorkSlot();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$DaemonPool$WorkSlot".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }

        public static class WrapperTask
        extends DaemonPool.WrapperTask {
            private volatile Span __m_ParentTracingSpan;

            public WrapperTask() {
                this(null, null, true);
            }

            public WrapperTask(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new WrapperTask();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Service$DaemonPool$WrapperTask".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            public Span getParentTracingSpan() {
                return this.__m_ParentTracingSpan;
            }

            @Override
            public void onInit() {
                super.onInit();
                this.setParentTracingSpan(TracingHelper.getActiveSpan());
            }

            @Override
            public void run() {
                Span span = ((Service)this.get_Module()).newTracingSpan("process", this.getTask()).setParent(this.getParentTracingSpan()).startSpan();
                Scope scope = TracingHelper.getTracer().withSpan(span);
                try {
                    super.run();
                }
                catch (RuntimeException e) {
                    TracingHelper.augmentSpanWithErrorDetails(span, true, e);
                    throw e;
                }
                finally {
                    scope.close();
                    span.end();
                }
            }

            public void setParentTracingSpan(Span spanTracing) {
                this.__m_ParentTracingSpan = spanTracing;
            }
        }
    }
}

