/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Application;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.LogOutput;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.ShutdownHook;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.logOutput.Jdk;
import com.tangosol.coherence.component.util.logOutput.Log4j2;
import com.tangosol.coherence.component.util.logOutput.SLF4J;
import com.tangosol.coherence.component.util.logOutput.Standard;
import com.tangosol.internal.net.logging.DefaultLoggingDependencies;
import com.tangosol.internal.net.logging.LoggingDependencies;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class Logger
extends QueueProcessor {
    private LoggingDependencies __m_Dependencies;
    private String __m_Destination;
    private String __m_Format;
    private static Integer[] __s_Integer;
    private int __m_Level;
    public static final int LEVEL_ALL = 10;
    public static final int LEVEL_D4 = 4;
    public static final int LEVEL_D5 = 5;
    public static final int LEVEL_D6 = 6;
    public static final int LEVEL_D7 = 7;
    public static final int LEVEL_D8 = 8;
    public static final int LEVEL_D9 = 9;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_INTERNAL = 0;
    public static final int LEVEL_NONE = -1;
    public static final String[] LEVEL_TEXT;
    public static final int LEVEL_WARNING = 2;
    private int __m_Limit;
    private static Level[] __s_LogLevel;
    private LogOutput __m_LogOutput;
    private volatile transient boolean __m_Overflowed;
    private volatile int __m_OverflowedLevel;
    private String[] __m_Parameters;
    public static final int QUEUE_DROP_SIZE = 500;
    public static final int QUEUE_MAX_THRESHOLD = 8000;
    private int __m_QueueHalfThreshold;
    public static final char THREAD_NAME_DELIM = '|';
    private static ListMap __mapChildren;

    private static void _initStatic$Default() {
        Logger.__initStatic();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Queue", QueueProcessor.Queue.get_CLASS());
    }

    public Logger() {
        this(null, null, true);
    }

    public Logger(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setLevel(10);
            this.setLimit(65536);
            this.setNotifier(new SingleWaiterMultiNotifier());
            this.setOverflowed(false);
            String[] a0 = new String[]{"{logRecord}", "{uptime}", "{thread}"};
            this.setParameters(a0);
            this.setPriority(3);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Daemon.Guard("Guard", this, true), "Guard");
        this._addChild(new ShutdownHook("ShutdownHook", this, true), "ShutdownHook");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new Logger();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Logger".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public boolean checkDiagnosability() {
        return false;
    }

    protected DefaultLoggingDependencies cloneDependencies(LoggingDependencies deps) {
        return new DefaultLoggingDependencies(deps);
    }

    protected Object[] collectLogParameters() {
        return null;
    }

    protected Object[] createMessage(int nLevel, Throwable throwable, String sMessage) {
        Object[] aoParam = this.collectLogParameters();
        int cParams = aoParam == null ? 0 : aoParam.length;
        Object[] aoMessage = new Object[3 + cParams];
        LogRecord logRecord = this.instantiateLogRecord(Logger.getLogLevel(nLevel), sMessage);
        logRecord.setMillis(System.currentTimeMillis());
        logRecord.setThrown(throwable);
        aoMessage[0] = logRecord;
        aoMessage[1] = Base.getUpTimeMillis();
        aoMessage[2] = Thread.currentThread();
        if (cParams > 0) {
            System.arraycopy(aoParam, 0, aoMessage, 3, cParams);
        }
        return aoMessage;
    }

    protected String formatLogRecord(String sFormat, LogRecord logRecord) {
        String sMessage = sFormat;
        sMessage = Base.replace(sMessage, "{text}", this.formatParameter("{text}", logRecord.getMessage()));
        sMessage = Base.replace(sMessage, "{date}", this.formatParameter("{date}", new Timestamp(logRecord.getMillis())));
        sMessage = Base.replace(sMessage, "{level}", this.formatParameter("{level}", logRecord.getLevel()));
        return sMessage;
    }

    public String formatMessage(Object[] aoParam) {
        LogRecord logRecord = (LogRecord)aoParam[0];
        String sMessage = logRecord.getMessage();
        if (logRecord.getLevel().intValue() != 0) {
            String sFormat = this.getFormat();
            String[] aoParamName = this.getParameters();
            int cParamNames = aoParamName == null ? 0 : aoParamName.length;
            int cParams = aoParam.length;
            if (sFormat != null) {
                sMessage = this.formatLogRecord(sFormat, logRecord);
                for (int i = 1; i < cParamNames; ++i) {
                    String sParamName = aoParamName[i];
                    Object oParamValue = i < cParams ? aoParam[i] : null;
                    sMessage = Base.replace(sMessage, sParamName, this.formatParameter(sParamName, oParamValue));
                }
            }
            logRecord.setMessage(sMessage);
        }
        return sMessage;
    }

    protected String formatParameter(String sParamName, Object oParamValue) {
        Object sParam = null;
        if (sParamName != null && sParamName.length() > 2) {
            switch (sParamName.charAt(1)) {
                case 'd': {
                    if (!sParamName.equals("{date}") || !(oParamValue instanceof Timestamp) || ((String)(sParam = oParamValue.toString())).length() >= 23) break;
                    sParam = ((String)sParam + "000").substring(0, 23);
                    break;
                }
                case 'u': {
                    if (!sParamName.equals("{uptime}") || !(oParamValue instanceof Long)) break;
                    long cMillisUp = (Long)oParamValue;
                    long cSec = cMillisUp / 1000L;
                    long cMillis = cMillisUp % 1000L;
                    if (cMillis < 10L) {
                        sParam = cSec + ".00" + cMillis;
                        break;
                    }
                    if (cMillis < 100L) {
                        sParam = cSec + ".0" + cMillis;
                        break;
                    }
                    sParam = cSec + "." + cMillis;
                    break;
                }
                case 'l': {
                    if (!sParamName.equals("{level}") || !(oParamValue instanceof Level)) break;
                    sParam = LEVEL_TEXT[((Level)oParamValue).intValue()];
                    break;
                }
                case 't': {
                    if (sParamName.equals("{thread}") && oParamValue instanceof Thread) {
                        sParam = ((Thread)oParamValue).getName();
                        int ofDecor = ((String)sParam).indexOf(124);
                        if (ofDecor <= 0) break;
                        sParam = ((String)sParam).substring(0, ofDecor);
                        break;
                    }
                    if (!sParamName.equals("{text}")) break;
                    Object object = sParam = oParamValue instanceof String ? (String)oParamValue : "";
                }
            }
        }
        if (sParam == null) {
            return oParamValue == null ? "n/a" : oParamValue.toString();
        }
        return sParam;
    }

    public LoggingDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public String getDestination() {
        return this.__m_Destination;
    }

    public String getFormat() {
        return this.__m_Format;
    }

    protected static Integer[] getInteger() {
        return __s_Integer;
    }

    protected static Integer getInteger(int nIndex) {
        nIndex = Math.max(nIndex, 0);
        nIndex = Math.min(nIndex, 9);
        return Logger.getInteger()[nIndex + 1];
    }

    public int getLevel() {
        return this.__m_Level;
    }

    public int getLimit() {
        return this.__m_Limit;
    }

    public static Level[] getLogLevel() {
        return __s_LogLevel;
    }

    public static Level getLogLevel(int nLevel) {
        nLevel = Math.max(nLevel, 0);
        nLevel = Math.min(nLevel, 9);
        return Logger.getLogLevel()[nLevel];
    }

    protected LogOutput getLogOutput() {
        return this.__m_LogOutput;
    }

    public int getOverflowedLevel() {
        return this.__m_OverflowedLevel;
    }

    public String[] getParameters() {
        return this.__m_Parameters;
    }

    public int getQueueHalfThreshold() {
        return this.__m_QueueHalfThreshold;
    }

    protected LogRecord instantiateLogRecord(Level level, String sMessage) {
        return new LogRecord(level, sMessage);
    }

    public static boolean isDiagnosabilityEnabled() {
        return ((Coherence)Application.get_Instance()).getLogger().checkDiagnosability();
    }

    public boolean isEnabled(int nLevel) {
        LogOutput logOutput = this.getLogOutput();
        nLevel = Logger.getInteger(nLevel);
        return logOutput == null || logOutput.isInheritLogLevel() ? nLevel <= this.getLevel() : logOutput.isEnabled(nLevel);
    }

    public boolean isOverflowed() {
        return this.__m_Overflowed;
    }

    public void log(int nLevel, String sMessage) {
        this.log(nLevel, null, sMessage);
    }

    public void log(int nLevel, Throwable throwable) {
        this.log(nLevel, throwable, null);
    }

    public void log(int nLevel, Throwable throwable, String sMessage) {
        if (this.isEnabled(nLevel)) {
            int cHalf;
            nLevel = Math.max(nLevel, -1);
            nLevel = Math.min(nLevel, 10);
            Queue queue = this.getQueue();
            int cSize = queue.size();
            if (cSize >= (cHalf = this.getQueueHalfThreshold())) {
                boolean fOverflow = this.isOverflowed();
                if (fOverflow) {
                    if (nLevel > this.getOverflowedLevel() && cSize >= 2 * cHalf) {
                        return;
                    }
                } else {
                    boolean bl = fOverflow = cSize >= 2 * cHalf;
                }
                if (fOverflow) {
                    this.processOverflow(this.createMessage(nLevel, throwable, sMessage), throwable);
                    return;
                }
            }
            queue.add(this.createMessage(nLevel, throwable, sMessage));
        }
    }

    protected void onDependencies(LoggingDependencies deps) {
        LogOutput output;
        String sDest = deps.getDestination();
        try {
            output = "jdk".equalsIgnoreCase(sDest) ? new Jdk() : ("log4j2".equalsIgnoreCase(sDest) ? new Log4j2() : ("slf4j".equalsIgnoreCase(sDest) ? new SLF4J() : new Standard()));
            output.configure(deps);
        }
        catch (Throwable e) {
            ((DefaultLoggingDependencies)deps).setDestination("stderr");
            output = new Standard();
            output.configure(deps);
            output.log(Logger.getInteger(1), e, "Error configuring logger '" + sDest + "'; using default settings instead.");
        }
        this.setDestination(deps.getDestination());
        this.setFormat(deps.getMessageFormat());
        this.setLevel(deps.getSeverityLevel());
        this.setLimit(deps.getCharacterLimit());
        this.setLogOutput(output);
        if (this.isEnabled(Logger.getInteger(6))) {
            System.out.println(String.format("Logger configured with destination '%s', severity level '%s' and a character limit of '%s'.", deps.getDestination(), deps.getSeverityLevel(), deps.getCharacterLimit()));
        }
    }

    @Override
    protected void onException(Throwable e) {
        System.err.println("Logger: " + String.valueOf(e));
        e.printStackTrace(System.err);
    }

    @Override
    public void onInit() {
        try {
            ShutdownHook hook = (ShutdownHook)this._findName("ShutdownHook");
            hook.register();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onInit();
    }

    protected void onLog() {
    }

    @Override
    protected void onNotify() {
        int MAX_TOTAL = this.getLimit();
        int cchTotal = 0;
        boolean fTruncate = false;
        int cTruncate = 0;
        int cTruncateLines = 0;
        int cchTruncate = 0;
        boolean fDone = false;
        do {
            Object[] aoMessage;
            if ((aoMessage = (Object[])this.getQueue().removeNoWait()) == null) {
                if (!fTruncate || cTruncate <= 0) break;
                aoMessage = this.createMessage(2, null, "Asynchronous logging character limit exceeded; discarding " + cTruncate + " log messages (lines=" + cTruncateLines + ", chars=" + cchTruncate + ")");
                fDone = true;
            }
            if (aoMessage.length == 0) {
                this.setExiting(true);
                return;
            }
            LogRecord logRecord = (LogRecord)aoMessage[0];
            if (!this.isEnabled(logRecord.getLevel().intValue())) continue;
            String sText = this.formatMessage(aoMessage);
            String sTextSafe = sText == null ? "" : sText;
            Throwable throwable = logRecord.getThrown();
            String sThrowable = throwable == null ? "" : Logger.getStackTrace(throwable);
            cchTotal += sTextSafe.length() + sThrowable.length();
            if (fTruncate && !fDone) {
                ++cTruncate;
                cTruncateLines += Base.parseDelimitedString(sTextSafe, '\n').length;
                cTruncateLines += Base.parseDelimitedString(sThrowable, '\n').length;
                cchTruncate += sTextSafe.length();
                cchTruncate += sThrowable.length();
                continue;
            }
            if (cchTotal > MAX_TOTAL) {
                fTruncate = true;
            }
            this.onLog();
            LogOutput out = this.getLogOutput();
            if (out == null) {
                try {
                    System.err.println(sTextSafe);
                    if (throwable == null) continue;
                    throwable.printStackTrace();
                }
                catch (Throwable throwable2) {}
                continue;
            }
            out.log(logRecord);
        } while (!fDone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processOverflow(Object[] aoMessage, Throwable throwable) {
        Queue queue = this.getQueue();
        int cHalf = this.getQueueHalfThreshold();
        int cDrop = 0;
        Queue queue2 = queue;
        synchronized (queue2) {
            if (this.isOverflowed()) {
                int cSize = queue.size();
                if (cSize <= cHalf + 500) {
                    this.setOverflowed(false);
                    queue.add(aoMessage);
                    return;
                }
                cDrop = (cSize - 2 * cHalf + 500) / 500;
            } else {
                this.setOverflowed(true);
                this.setOverflowedLevel(this.getLevel());
                cDrop = 1;
            }
        }
        int nLevelCurrent = this.getOverflowedLevel();
        if (nLevelCurrent > 1) {
            int nLevelTarget;
            queue.add(aoMessage);
            if (cDrop > 0 && (nLevelTarget = Math.max(1, this.getLevel() - cDrop)) < nLevelCurrent) {
                this.setOverflowedLevel(nLevelTarget);
                String sMsg = "The configured logger is stuck or too slow (backlog of " + queue.size() + " messages) at threshold log level of \"" + LEVEL_TEXT[nLevelCurrent] + "\"" + (String)(nLevelTarget == 1 ? "; switching to synchronous \"err\" logging" : "; lowering the threshold to \"" + LEVEL_TEXT[nLevelTarget] + "\"");
                queue.add(this.createMessage(nLevelCurrent, null, sMsg));
                if (nLevelTarget == 1) {
                    System.err.println(this.formatMessage(this.createMessage(1, null, sMsg)));
                }
            }
        } else {
            String sText = this.formatMessage(aoMessage);
            System.err.println(sText == null ? "" : sText);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }

    public void setDependencies(LoggingDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Dependencies already set");
        }
        this.__m_Dependencies = this.cloneDependencies(deps).validate();
        this.onDependencies(this.getDependencies());
    }

    protected void setDestination(String sDestination) {
        this.__m_Destination = sDestination;
    }

    public void setFormat(String sFormat) {
        this.__m_Format = sFormat;
    }

    protected static void setInteger(Integer[] aInteger) {
        __s_Integer = aInteger;
    }

    protected static void setInteger(int nIndex, Integer integer) {
        Logger.getInteger()[nIndex] = integer;
    }

    public void setLevel(int nLevel) {
        this.__m_Level = nLevel;
        LogOutput out = this.getLogOutput();
        if (out != null) {
            out.setLevel(nLevel);
        }
    }

    public void setLevel(Integer ILevel) {
        this.setLevel((int)ILevel);
        LogOutput out = this.getLogOutput();
        if (out != null) {
            out.setLevel(ILevel);
        }
    }

    public void setLimit(int nLimit) {
        this.setQueueHalfThreshold(Math.min(4000, nLimit / 256));
        this.__m_Limit = nLimit;
    }

    protected static void setLogLevel(Level[] aLevel) {
        __s_LogLevel = aLevel;
    }

    protected static void setLogLevel(int i, Level level) {
        Logger.getLogLevel()[i] = level;
    }

    protected void setLogOutput(LogOutput output) {
        this.__m_LogOutput = output;
    }

    protected void setOverflowed(boolean fOverflowed) {
        this.__m_Overflowed = fOverflowed;
    }

    protected void setOverflowedLevel(int nLevel) {
        this.__m_OverflowedLevel = nLevel;
    }

    protected void setParameters(String[] asParams) {
        this.__m_Parameters = asParams;
    }

    public void setQueueHalfThreshold(int nLimit) {
        this.__m_QueueHalfThreshold = nLimit;
    }

    public synchronized void shutdown() {
        ShutdownHook hook = (ShutdownHook)this._findName("ShutdownHook");
        hook.unregister();
        if (this.isStarted()) {
            this.getQueue().add(new Object[0]);
            if (this.getThread() != Thread.currentThread()) {
                try {
                    Blocking.wait(this, 1000L);
                }
                catch (InterruptedException e) {
                    this.stop();
                }
                finally {
                    this.getLogOutput().close();
                }
            }
        } else {
            this.onNotify();
        }
    }

    static {
        Logger._initStatic$Default();
        LEVEL_TEXT = new String[]{"Internal", "Error", "Warning", "Info", "D4", "D5", "D6", "D7", "D8", "D9"};
        Integer[] ai = new Integer[]{-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        Logger.setInteger(ai);
        Level[] aLogLevel = new Level[]{Level.parse("0"), Level.parse("1"), Level.parse("2"), Level.parse("3"), Level.parse("4"), Level.parse("5"), Level.parse("6"), Level.parse("7"), Level.parse("8"), Level.parse("9")};
        Logger.setLogLevel(aLogLevel);
    }

    public static class ShutdownHook
    extends com.tangosol.coherence.component.util.ShutdownHook {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("UnregisterAction", UnregisterAction.get_CLASS());
        }

        public ShutdownHook() {
            this(null, null, true);
        }

        public ShutdownHook(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ShutdownHook();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Logger$ShutdownHook".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void run() {
            if (this.getThread() != null) {
                ((Logger)this.get_Module()).shutdown();
            }
        }

        static {
            ShutdownHook.__initStatic();
        }

        public static class UnregisterAction
        extends ShutdownHook.UnregisterAction {
            public UnregisterAction() {
                this(null, null, true);
            }

            public UnregisterAction(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new UnregisterAction();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/daemon/queueProcessor/Logger$ShutdownHook$UnregisterAction".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }
}

