/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.deltaMap.TransactionMap;
import com.tangosol.coherence.component.util.deltaMap.transactionMap.Optimistic;
import com.tangosol.coherence.component.util.deltaMap.transactionMap.optimistic.Commited;
import com.tangosol.coherence.component.util.deltaMap.transactionMap.optimistic.Serializable;
import com.tangosol.coherence.component.util.deltaMap.transactionMap.pessimistic.Repeatable;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TransactionCache
extends Util
implements NamedCache,
ConcurrentMap,
com.tangosol.util.TransactionMap {
    private transient int __m_Concurrency;
    private transient ConcurrentMap __m_Map;
    private transient NamedCache __m_NamedCache;
    private transient int __m_Status;
    private transient int __m_TransactionIsolation;
    private transient int __m_TransactionTimeout;
    private TransactionMap.Validator __m_Validator;
    private boolean __m_ValuesImmutable;

    public TransactionCache() {
        this(null, null, true);
    }

    public TransactionCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setStatus(6);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new TransactionCache();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/TransactionCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public boolean containsKey(Object oKey) {
        return this.getMap().containsKey(oKey);
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.getMap().containsValue(oValue);
    }

    @Override
    public Set entrySet() {
        return this.getMap().entrySet();
    }

    @Override
    public Object get(Object oKey) {
        return this.getMap().get(oKey);
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public Set keySet() {
        return this.getMap().keySet();
    }

    @Override
    public boolean lock(Object oKey) {
        return this.getMap().lock(oKey);
    }

    @Override
    public boolean lock(Object oKey, long cWait) {
        return this.getMap().lock(oKey, cWait);
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        return this.getMap().put(oKey, oValue);
    }

    @Override
    public void putAll(Map map) {
        this.getMap().putAll(map);
    }

    @Override
    public Object remove(Object oKey) {
        return this.getMap().remove(oKey);
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public boolean unlock(Object oKey) {
        return this.getMap().unlock(oKey);
    }

    @Override
    public Collection values() {
        return this.getMap().values();
    }

    @Override
    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMapListener(MapListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void begin() {
        int nStatus = this.getStatus();
        if (nStatus == 6 || nStatus == 4 || nStatus == 3) {
            ConcurrentMap map = this.getMap();
            if (map instanceof com.tangosol.util.TransactionMap) {
                com.tangosol.util.TransactionMap mapTx = (com.tangosol.util.TransactionMap)map;
                mapTx.setTransactionTimeout(this.getTransactionTimeout());
                mapTx.setValidator(this.getValidator());
                mapTx.begin();
            }
        } else {
            throw this.invalidStatus("begin");
        }
        this.setStatus(0);
    }

    @Override
    public void commit() {
        if (this.getStatus() == 2) {
            try {
                this.setStatus(8);
                ConcurrentMap map = this.getMap();
                if (map instanceof com.tangosol.util.TransactionMap) {
                    ((com.tangosol.util.TransactionMap)map).commit();
                }
                this.setStatus(3);
            }
            catch (RuntimeException e) {
                this.setStatus(5);
                throw e;
            }
        } else {
            throw this.invalidStatus("commit");
        }
    }

    @Override
    public void destroy() {
        this.rollback();
        this.getNamedCache().destroy();
    }

    @Override
    public Set entrySet(Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set entrySet(Filter filter, Comparator comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TransactionCache) {
            return this.getMap().equals(((TransactionCache)obj).getMap());
        }
        return false;
    }

    public static String formatStatus(int nStatus) {
        switch (nStatus) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 1: {
                return "STATUS_ROLLEDBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 5: {
                return "STATUS_UNKNWON";
            }
        }
        throw new IllegalArgumentException("Invalid status: " + nStatus);
    }

    @Override
    public Map getAll(Collection colKeys) {
        HashMap mapResult = new HashMap(colKeys.size());
        for (Object oKey : colKeys) {
            if (!this.containsKey(oKey)) continue;
            mapResult.put(oKey, this.get(oKey));
        }
        return mapResult;
    }

    @Override
    public ConcurrentMap getBaseMap() {
        return this.getNamedCache();
    }

    @Override
    public String getCacheName() {
        return this.getNamedCache().getCacheName();
    }

    @Override
    public CacheService getCacheService() {
        return this.getNamedCache().getCacheService();
    }

    @Override
    public int getConcurrency() {
        return this.__m_Concurrency;
    }

    public ConcurrentMap getMap() {
        return this.__m_Map;
    }

    public NamedCache getNamedCache() {
        return this.__m_NamedCache;
    }

    public int getStatus() {
        return this.__m_Status;
    }

    @Override
    public int getTransactionIsolation() {
        return this.__m_TransactionIsolation;
    }

    @Override
    public int getTransactionTimeout() {
        return this.__m_TransactionTimeout;
    }

    @Override
    public TransactionMap.Validator getValidator() {
        return this.__m_Validator;
    }

    @Override
    public int hashCode() {
        return this.getMap().hashCode();
    }

    public void initialize(NamedCache cache) {
        TransactionCache._assert(cache != null && this.getNamedCache() == null, "NamedCache is not resettable");
        TransactionCache._assert(cache.getCacheService().getInfo().getServiceType() != "RemoteCache", "RemoteNamedCache does not support local transactions");
        this.setNamedCache(cache);
        this.setMap(cache);
    }

    protected TransactionMap instantiateTransactionMap() {
        int nConcur = this.getConcurrency();
        int nIsolation = this.getTransactionIsolation();
        TransactionMap mapTx = TransactionCache.instantiateTransactionMap(nConcur, nIsolation);
        return mapTx;
    }

    public static TransactionMap instantiateTransactionMap(int nConcur, int nIsolation) {
        boolean fExternal = false;
        if (nConcur == 3) {
            nConcur = 2;
            fExternal = true;
        }
        TransactionMap mapTx = switch (nConcur * 8 + nIsolation) {
            case 9 -> new com.tangosol.coherence.component.util.deltaMap.transactionMap.pessimistic.Commited();
            case 10 -> new Repeatable();
            case 11 -> new com.tangosol.coherence.component.util.deltaMap.transactionMap.pessimistic.Serializable();
            case 17 -> new Commited();
            case 18 -> new com.tangosol.coherence.component.util.deltaMap.transactionMap.optimistic.Repeatable();
            case 19 -> new Serializable();
            default -> throw new IllegalArgumentException("Invalid concurrency or isolation level: " + nConcur + ", " + nIsolation);
        };
        if (fExternal) {
            ((Optimistic)mapTx).setLockExternal(true);
        }
        return mapTx;
    }

    protected RuntimeException invalidStatus(String sMethod) {
        return new IllegalStateException(sMethod + "-- invalid transaction status: " + String.valueOf(this));
    }

    @Override
    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isActive() {
        return this.getNamedCache().isActive();
    }

    @Override
    public boolean isReady() {
        return this.getNamedCache().isReady();
    }

    @Override
    public boolean isValuesImmutable() {
        return this.__m_ValuesImmutable;
    }

    @Override
    public Set keySet(Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void prepare() {
        if (this.getStatus() == 0) {
            try {
                this.setStatus(7);
                ConcurrentMap map = this.getMap();
                if (map instanceof com.tangosol.util.TransactionMap) {
                    ((com.tangosol.util.TransactionMap)map).prepare();
                }
                this.setStatus(2);
            }
            catch (RuntimeException e) {
                this.setStatus(1);
                throw e;
            }
        } else {
            throw this.invalidStatus("prepare");
        }
    }

    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        if (cMillis == 0L) {
            return this.put(oKey, oValue);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void release() {
        this.rollback();
        this.getNamedCache().release();
    }

    @Override
    public void removeIndex(ValueExtractor extractor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeMapListener(MapListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeMapListener(MapListener listener, Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeMapListener(MapListener listener, Object oKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback() {
        try {
            this.setStatus(9);
            ConcurrentMap map = this.getMap();
            if (map instanceof com.tangosol.util.TransactionMap) {
                ((com.tangosol.util.TransactionMap)map).rollback();
            }
        }
        finally {
            this.setStatus(4);
        }
    }

    @Override
    public void setConcurrency(int nConcurrency) {
        this.__m_Concurrency = nConcurrency;
    }

    protected void setMap(ConcurrentMap map) {
        this.__m_Map = map;
    }

    protected void setNamedCache(NamedCache cache) {
        this.__m_NamedCache = cache;
    }

    public void setStatus(int pStatus) {
        this.__m_Status = pStatus;
    }

    @Override
    public void setTransactionIsolation(int nIsolation) {
        this.__m_TransactionIsolation = nIsolation;
    }

    @Override
    public void setTransactionTimeout(int nTimeout) {
        this.__m_TransactionTimeout = nTimeout;
    }

    @Override
    public void setValidator(TransactionMap.Validator validator) {
        this.__m_Validator = validator;
    }

    @Override
    public void setValuesImmutable(boolean fImmutable) {
        this.__m_ValuesImmutable = fImmutable;
    }

    @Override
    public String toString() {
        return "TransactionalCache: " + TransactionCache.formatStatus(this.getStatus()) + "\n  BaseMap=" + String.valueOf(this.getNamedCache()) + "\n  DeltaMap=" + Base.indentString(this.getMap().toString(), "    ", false);
    }
}

