/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

public abstract class ShutdownHook
extends Util
implements Runnable {
    private transient boolean __m_Graceful;
    private transient Thread __m_Thread;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("UnregisterAction", UnregisterAction.get_CLASS());
    }

    public ShutdownHook(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/ShutdownHook".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public Thread getThread() {
        return this.__m_Thread;
    }

    public boolean isGraceful() {
        return this.__m_Graceful;
    }

    public void register() {
        Thread thread = Base.makeThread(null, this, this.get_Name());
        Runtime.getRuntime().addShutdownHook(thread);
        this.setThread(thread);
    }

    @Override
    public void run() {
    }

    public void setGraceful(boolean fGraceful) {
        this.__m_Graceful = fGraceful;
    }

    public void setThread(Thread thread) {
        this.__m_Thread = thread;
    }

    public void unregister() {
        if (System.getSecurityManager() == null) {
            this.unregisterInternal();
        } else {
            AccessController.doPrivileged(new DoAsAction((UnregisterAction)this._newChild("UnregisterAction")));
        }
    }

    public void unregisterInternal() {
        Thread thread = this.getThread();
        if (thread != null) {
            this.setThread(null);
            try {
                if (Thread.currentThread() != thread && Runtime.getRuntime().removeShutdownHook(thread)) {
                    thread.start();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        ShutdownHook.__initStatic();
    }

    public static class UnregisterAction
    extends Util
    implements PrivilegedAction {
        public UnregisterAction() {
            this(null, null, true);
        }

        public UnregisterAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new UnregisterAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/ShutdownHook$UnregisterAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object run() {
            ((ShutdownHook)this.get_Module()).unregisterInternal();
            return null;
        }
    }
}

