/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Lockable;
import com.oracle.coherence.common.base.Timeout;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.extend.RemoteService;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.io.Serializer;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.management.Registry;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.WrapperException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntPredicate;
import javax.security.auth.Subject;

public class SafeService
extends Util
implements Lockable,
MemberListener,
com.tangosol.net.Service,
ServiceListener {
    private transient XmlElement __m_Config;
    private ClassLoader __m_ContextClassLoader;
    private ServiceDependencies __m_Dependencies;
    private PrivilegedAction __m_EnsureServiceAction;
    private transient com.tangosol.net.Service __m_InternalService;
    private ReentrantLock __m_Lock;
    private Listeners __m_MemberListeners;
    private ResourceRegistry __m_ResourceRegistry;
    private transient boolean __m_Restarting;
    private transient SafeCluster __m_SafeCluster;
    private int __m_SafeServiceState;
    public static final int SERVICE_INITIAL = 0;
    public static final int SERVICE_STARTED = 1;
    public static final int SERVICE_STOPPED = 2;
    private Listeners __m_ServiceListeners;
    private String __m_ServiceName;
    private String __m_ServiceType;
    private Subject __m_Subject;
    private Unlockable __m_Unlockable;
    private Object __m_UserContext;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("EnsureServiceAction", EnsureServiceAction.get_CLASS());
        __mapChildren.put("StartAction", StartAction.get_CLASS());
        __mapChildren.put("Unlockable", Unlockable.get_CLASS());
    }

    public SafeService() {
        this(null, null, true);
    }

    public SafeService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setLock(new ReentrantLock());
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setSafeServiceState(0);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_MemberListeners = new Listeners();
            this.__m_ServiceListeners = new Listeners();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public static Component get_Instance() {
        return new SafeService();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/SafeService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public ServiceInfo getInfo() {
        return ((com.tangosol.net.Service)this.getRunningService()).getInfo();
    }

    @Override
    public Serializer getSerializer() {
        return ((com.tangosol.net.Service)this.getRunningService()).getSerializer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMemberListener(MemberListener l) {
        this.ensureLocked();
        try {
            com.tangosol.net.Service service = this.getInternalService();
            if (l instanceof SynchronousListener) {
                if (service != null && service.isRunning()) {
                    service.addMemberListener(l);
                }
            } else {
                Listeners listeners = this.getMemberListeners();
                boolean fWasEmpty = listeners.isEmpty();
                listeners.add(l);
                if (fWasEmpty && !listeners.isEmpty() && service != null && service.isRunning()) {
                    service.addMemberListener(this);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(ServiceListener l) {
        this.ensureLocked();
        try {
            com.tangosol.net.Service service = this.getInternalService();
            if (l instanceof SynchronousListener) {
                if (service != null && service.isRunning()) {
                    service.addServiceListener(l);
                }
            } else {
                Listeners listeners = this.getServiceListeners();
                boolean fWasEmpty = listeners.isEmpty();
                listeners.add(l);
                if (fWasEmpty && !listeners.isEmpty() && service != null && service.isRunning()) {
                    service.addServiceListener(this);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    protected void checkClientThread(String sMethod) {
        if (this.isServiceThread()) {
            SafeService._trace("Application code running on \"" + this.getServiceName() + "\" service thread(s) should not call " + sMethod + " as this may result in deadlock. The most common case is a CacheFactory call from a custom CacheStore implementation.", 2);
            if (SafeService._isTraceEnabled(7)) {
                SafeService._trace("Stack trace:\n" + SafeService.get_StackTrace(), 7);
            }
        }
    }

    private void checkInternalAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(LocalPermission.INTERNAL_SERVICE);
        }
    }

    protected void cleanup() {
        this.setInternalService(null);
        this.setContextClassLoader(null);
        this.getMemberListeners().removeAll();
        this.getServiceListeners().removeAll();
        this.getResourceRegistry().dispose();
        this.setResourceRegistry(new SimpleResourceRegistry());
    }

    @Override
    public void configure(XmlElement xmlConfig) {
        this.setConfig(xmlConfig);
    }

    public void ensureGlobalLock() {
        SafeCluster cluster = this.getSafeCluster();
        ServiceDependencies deps = this.getDependencies();
        long cTimeout = deps == null ? -1L : deps.getRequestTimeoutMillis();
        cluster.ensureLocked(cTimeout == 0L ? -1L : cTimeout);
        try {
            this.ensureLocked();
        }
        catch (RuntimeException e) {
            cluster.unlock();
            throw e;
        }
    }

    public void ensureLocked() {
        ServiceDependencies deps = this.getDependencies();
        long cRequestTimeout = deps == null ? 0L : deps.getRequestTimeoutMillis();
        long cTimeout = Timeout.isSet() ? Timeout.remainingTimeoutMillis() : cRequestTimeout;
        ReentrantLock lock = this.getLock();
        try {
            if (lock.tryLock(cTimeout <= 0L ? Long.MAX_VALUE : cTimeout, TimeUnit.MILLISECONDS)) {
                return;
            }
            throw Base.ensureRuntimeException(new RequestTimeoutException("Failed to acquire service lock in " + cTimeout + "ms"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e, "Interrupted while attempting to acquire service lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public com.tangosol.net.Service ensureRunningService() {
        this.checkInternalAccess();
        service = this.getInternalService();
        if (service == null || !service.isRunning()) {
            fRegister = true;
            cluster = this.getSafeCluster();
            this.ensureGlobalLock();
            try {
                sName = this.getServiceName();
                sType = this.getServiceType();
                sCacheName = "Invocation".equals(sType) != false || "Proxy".equals(sType) != false ? null : "*";
                service = this.getInternalService();
                switch (this.getSafeServiceState()) {
                    case 0: {
                        Security.checkPermission(cluster, sName, sCacheName, "join");
                        if (service == null) {
                            service = this.restartService();
                            this.setInternalService(service);
                            ** break;
lbl19:
                            // 1 sources

                        } else {
                            this.startService(service);
                            ** break;
                        }
lbl22:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        Security.checkPermission(cluster, sName, sCacheName, "join");
                        if (service == null || !service.isRunning()) {
                            service = null;
                            this.setInternalService(null);
                            SafeService._trace("Restarting Service: " + this.getServiceName(), 3);
                            service = this.restartService();
                            this.setInternalService(service);
                            ** break;
lbl32:
                            // 1 sources

                        } else {
                            fRegister = false;
                            ** break;
                        }
lbl35:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        throw new IllegalStateException("SafeService was explicitly stopped");
                    }
                    ** default:
lbl39:
                    // 1 sources

                    break;
                }
            }
            finally {
                this.unlockGlobal();
            }
            if (fRegister) {
                this.register();
            }
        }
        return service;
    }

    @Override
    public Lockable.Unlockable exclusively() {
        this.ensureLocked();
        return this.getUnlockable();
    }

    @Override
    public Cluster getCluster() {
        return this.getSafeCluster();
    }

    public XmlElement getConfig() {
        return this.__m_Config;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        ClassLoader loader = this.__m_ContextClassLoader;
        if (loader == null) {
            loader = Base.getContextClassLoader(this);
        }
        return loader;
    }

    @Override
    public ServiceDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public PrivilegedAction getEnsureServiceAction() {
        return this.__m_EnsureServiceAction;
    }

    protected com.tangosol.net.Service getInternalService() {
        return this.__m_InternalService;
    }

    public ReentrantLock getLock() {
        return this.__m_Lock;
    }

    protected Listeners getMemberListeners() {
        return this.__m_MemberListeners;
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        return this.__m_ResourceRegistry;
    }

    public com.tangosol.util.Service getRunningService() {
        if (System.getSecurityManager() == null) {
            return this.ensureRunningService();
        }
        return (com.tangosol.net.Service)AccessController.doPrivileged(new DoAsAction(this.getEnsureServiceAction()));
    }

    public SafeCluster getSafeCluster() {
        return this.__m_SafeCluster;
    }

    public int getSafeServiceState() {
        return this.__m_SafeServiceState;
    }

    public com.tangosol.net.Service getService() {
        this.checkInternalAccess();
        return this.getInternalService();
    }

    protected Listeners getServiceListeners() {
        return this.__m_ServiceListeners;
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceType() {
        return this.__m_ServiceType;
    }

    public Subject getSubject() {
        return this.__m_Subject;
    }

    public Unlockable getUnlockable() {
        return this.__m_Unlockable;
    }

    @Override
    public Object getUserContext() {
        return this.__m_UserContext;
    }

    public boolean isLocalService() {
        this.getSafeCluster();
        return SafeCluster.isLocalService(this.getServiceType());
    }

    public boolean isRestarting() {
        return this.__m_Restarting;
    }

    @Override
    public boolean isRunning() {
        com.tangosol.net.Service service = this.getInternalService();
        return service != null && service.isRunning() && (this.isLocalService() || service.getCluster().isRunning());
    }

    public boolean isServiceThread() {
        com.tangosol.net.Service _service = this.getInternalService();
        if (_service instanceof Service) {
            return ((Service)((Object)_service)).isServiceThread(false);
        }
        if (_service instanceof RemoteService) {
            return ((RemoteService)_service).isServiceThread(false);
        }
        return false;
    }

    @Override
    public boolean isSuspended() {
        if (this.isLocalService()) {
            return false;
        }
        com.tangosol.net.Service service = this.getInternalService();
        return service != null && service.isSuspended();
    }

    @Override
    public void memberJoined(MemberEvent evt) {
        this.translateEvent(evt);
    }

    @Override
    public void memberLeaving(MemberEvent evt) {
        this.translateEvent(evt);
    }

    @Override
    public void memberLeft(MemberEvent evt) {
        this.translateEvent(evt);
    }

    @Override
    public void memberRecovered(MemberEvent evt) {
        this.translateEvent(evt);
    }

    @Override
    public void onInit() {
        this.setEnsureServiceAction((EnsureServiceAction)this._newChild("EnsureServiceAction"));
        this.setUnlockable((Unlockable)this._newChild("Unlockable"));
        super.onInit();
    }

    protected void register() {
        Member member;
        Registry registry = this.getSafeCluster().getManagement();
        if (registry != null && !this.getServiceType().equals("Cluster") && !(this.getInternalService() instanceof RemoteService) && (member = this.getSafeCluster().getLocalMember()) != null) {
            Object sName = "type=Service,name=" + this.getServiceName();
            sName = registry.ensureGlobalName((String)sName);
            registry.register((String)sName, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMemberListener(MemberListener l) {
        this.ensureLocked();
        try {
            com.tangosol.net.Service service = this.getInternalService();
            if (l instanceof SynchronousListener) {
                if (service != null && service.isRunning()) {
                    service.removeMemberListener(l);
                }
            } else {
                Listeners listeners = this.getMemberListeners();
                if (!listeners.isEmpty()) {
                    listeners.remove(l);
                    if (listeners.isEmpty() && service != null && service.isRunning()) {
                        service.removeMemberListener(this);
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(ServiceListener l) {
        this.ensureLocked();
        try {
            com.tangosol.net.Service service = this.getInternalService();
            if (l instanceof SynchronousListener) {
                if (service != null && service.isRunning()) {
                    service.removeServiceListener(l);
                }
            } else {
                Listeners listeners = this.getServiceListeners();
                if (!listeners.isEmpty()) {
                    listeners.remove(l);
                    if (listeners.isEmpty() && service != null && service.isRunning()) {
                        service.removeServiceListener(this);
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    protected com.tangosol.net.Service restartService() {
        this.setRestarting(true);
        try {
            com.tangosol.net.Service service = this.getSafeCluster().instantiateService(this.getServiceName(), this.getServiceType());
            this.startService(service);
            com.tangosol.net.Service service2 = service;
            return service2;
        }
        finally {
            this.setRestarting(false);
        }
    }

    @Override
    public void serviceStarted(ServiceEvent evt) {
        this.translateEvent(evt);
    }

    @Override
    public void serviceStarting(ServiceEvent evt) {
        this.translateEvent(evt);
    }

    @Override
    public void serviceStopped(ServiceEvent evt) {
        this.translateEvent(evt);
    }

    @Override
    public void serviceStopping(ServiceEvent evt) {
        this.translateEvent(evt);
    }

    public void setConfig(XmlElement xmlConfig) {
        this.__m_Config = xmlConfig;
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        SecurityManager security = System.getSecurityManager();
        if (security != null && loader != null) {
            security.checkPermission(new LocalPermission("BackingMapManagerContext.setClassLoader"));
        }
        this.__m_ContextClassLoader = loader;
        com.tangosol.net.Service service = this.getInternalService();
        if (service != null) {
            service.setContextClassLoader(loader);
        }
    }

    @Override
    public void setDependencies(ServiceDependencies deps) {
        this.__m_Dependencies = deps;
    }

    protected void setEnsureServiceAction(PrivilegedAction action) {
        this.__m_EnsureServiceAction = action;
    }

    public void setInternalService(com.tangosol.net.Service service) {
        this.__m_InternalService = service;
    }

    public void setLock(ReentrantLock lock) {
        this.__m_Lock = lock;
    }

    private void setMemberListeners(Listeners listeners) {
        this.__m_MemberListeners = listeners;
    }

    protected void setResourceRegistry(ResourceRegistry registry) {
        this.__m_ResourceRegistry = registry;
    }

    protected void setRestarting(boolean fRestarting) {
        this.__m_Restarting = fRestarting;
    }

    public void setSafeCluster(SafeCluster cluster) {
        this.__m_SafeCluster = cluster;
    }

    protected void setSafeServiceState(int nState) {
        this.__m_SafeServiceState = nState;
    }

    private void setServiceListeners(Listeners listeners) {
        this.__m_ServiceListeners = listeners;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public void setServiceType(String sType) {
        this.__m_ServiceType = sType;
    }

    public void setSubject(Subject subject) {
        this.__m_Subject = subject;
    }

    public void setUnlockable(Unlockable unlockable) {
        this.__m_Unlockable = unlockable;
    }

    @Override
    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
        com.tangosol.net.Service service = this.getInternalService();
        if (service != null) {
            service.setUserContext(oCtx);
        }
    }

    @Override
    public void shutdown() {
        this.ensureGlobalLock();
        try {
            if (this.getSafeServiceState() != 2) {
                com.tangosol.net.Service service = this.getInternalService();
                if (service != null) {
                    service.shutdown();
                }
                this.unregister();
                this.cleanup();
                this.setSafeServiceState(2);
            }
        }
        finally {
            this.unlockGlobal();
        }
    }

    @Override
    public void start() {
        AccessController.doPrivileged(new DoAsAction((StartAction)this._newChild("StartAction")));
    }

    public void startInternal() {
        this.ensureGlobalLock();
        try {
            if (this.getSafeServiceState() == 2) {
                this.setSafeServiceState(0);
            }
            this.ensureRunningService();
        }
        finally {
            this.setSafeServiceState(1);
            this.unlockGlobal();
        }
    }

    protected void startService(com.tangosol.net.Service service) {
        Listeners listenersService;
        if (service instanceof RemoteService) {
            ((RemoteService)service).setOperationalContext(this.getSafeCluster());
        } else if (service instanceof Service) {
            ((Service)((Object)service)).setOperationalContext(this.getSafeCluster());
        }
        if (service instanceof Grid) {
            ((Grid)service).setResourceRegistry(this.getResourceRegistry());
        }
        service.setContextClassLoader(this.getContextClassLoader());
        try {
            XmlElement xmlConfig = this.getConfig();
            if (xmlConfig == null) {
                service.setDependencies(this.getDependencies());
            } else {
                service.configure(xmlConfig);
            }
        }
        catch (Throwable e) {
            SafeService._trace("Error while configuring service \"" + this.getServiceName() + "\": " + SafeService.getStackTrace(e), 1);
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (RuntimeException)e;
        }
        service.setUserContext(this.getUserContext());
        Listeners listenersMember = this.getMemberListeners();
        if (!listenersMember.isEmpty()) {
            service.addMemberListener(this);
        }
        if (!(listenersService = this.getServiceListeners()).isEmpty()) {
            service.addServiceListener(this);
        }
        try {
            service.start();
        }
        catch (Throwable e) {
            SafeService._trace("Error while starting service \"" + this.getServiceName() + "\": " + SafeService.getStackTrace(e), 1);
            try {
                service.stop();
            }
            catch (Throwable e2) {
                SafeService._trace("Failed to stop service \"" + this.getServiceName() + "\": " + SafeService.getStackTrace(e2), 2);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (RuntimeException)e;
        }
    }

    @Override
    public void stop() {
        this.ensureGlobalLock();
        try {
            if (this.getSafeServiceState() != 2) {
                com.tangosol.net.Service service = this.getInternalService();
                if (service != null) {
                    service.stop();
                }
                this.cleanup();
                this.setSafeServiceState(2);
            }
        }
        finally {
            this.unlockGlobal();
        }
    }

    @Override
    public String toString() {
        com.tangosol.net.Service service = this.getInternalService();
        return this.get_Name() + ": " + (service == null ? "STOPPED" : service.toString());
    }

    protected void translateEvent(MemberEvent evtMember) {
        Listeners listeners;
        com.tangosol.net.Service service = this.getInternalService();
        if (service == null) {
            this.ensureLocked();
            service = this.getInternalService();
            this.unlock();
        }
        if (!(listeners = this.getMemberListeners()).isEmpty()) {
            com.tangosol.net.Service serviceSource = evtMember.getService();
            MemberEvent evtSafe = new MemberEvent(service == serviceSource ? this : serviceSource, evtMember.getId(), evtMember.getMember());
            evtSafe.dispatch(listeners);
        }
    }

    protected void translateEvent(ServiceEvent evtService) {
        Listeners listeners;
        com.tangosol.net.Service service = this.getInternalService();
        if (service == null) {
            this.ensureLocked();
            service = this.getInternalService();
            this.unlock();
        }
        if (!(listeners = this.getServiceListeners()).isEmpty()) {
            com.tangosol.net.Service serviceSource = (com.tangosol.net.Service)evtService.getService();
            ServiceEvent evtSafe = new ServiceEvent(service == serviceSource ? this : serviceSource, evtService.getId());
            evtSafe.dispatch(listeners);
        }
    }

    public void unlock() {
        this.getLock().unlock();
    }

    public void unlockGlobal() {
        this.getLock().unlock();
        this.getSafeCluster().getLock().unlock();
    }

    protected void unregister() {
        Member member;
        Registry registry = this.getSafeCluster().getManagement();
        if (registry != null && !this.getServiceType().equals("Cluster") && !(this.getInternalService() instanceof RemoteService) && (member = this.getSafeCluster().getLocalMember()) != null) {
            Object sName = "type=Service,name=" + this.getServiceName();
            sName = registry.ensureGlobalName((String)sName);
            registry.unregister((String)sName);
        }
    }

    @Override
    public boolean isVersionCompatible(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        return this.getService().isVersionCompatible(nMajor, nMinor, nMicro, nPatchSet, nPatch);
    }

    @Override
    public boolean isVersionCompatible(int nYear, int nMonth, int nPatch) {
        return this.getService().isVersionCompatible(nYear, nMonth, nPatch);
    }

    @Override
    public boolean isVersionCompatible(int nVersion) {
        return this.getService().isVersionCompatible(nVersion);
    }

    @Override
    public boolean isVersionCompatible(IntPredicate predicate) {
        return this.getService().isVersionCompatible(predicate);
    }

    @Override
    public int getMinimumServiceVersion() {
        return this.getService().getMinimumServiceVersion();
    }

    static {
        SafeService.__initStatic();
    }

    public static class EnsureServiceAction
    extends Util
    implements PrivilegedAction {
        public EnsureServiceAction() {
            this(null, null, true);
        }

        public EnsureServiceAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EnsureServiceAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeService$EnsureServiceAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object run() {
            return ((SafeService)this.get_Module()).ensureRunningService();
        }
    }

    public static class StartAction
    extends Util
    implements PrivilegedAction {
        public StartAction() {
            this(null, null, true);
        }

        public StartAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new StartAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeService$StartAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object run() {
            ((SafeService)this.get_Module()).startInternal();
            return null;
        }
    }

    public static class Unlockable
    extends Util
    implements Lockable.Unlockable {
        public Unlockable() {
            this(null, null, true);
        }

        public Unlockable(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Unlockable();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeService$Unlockable".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void close() {
            ((SafeService)this.get_Module()).unlock();
        }
    }
}

