/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Timeout;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.safeService.safeCacheService.safeDistributedCacheService.SafePagedTopicService;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicPublisher;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicSubscriber;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.TopicService;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.net.topic.Publisher;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;

public class SafeNamedTopic
extends Util
implements NamedTopic {
    private transient ClassLoader __m_ClassLoader;
    private boolean __m_Destroyed;
    private PrivilegedAction __m_EnsureTopicAction;
    private NamedTopic __m_InternalNamedTopic;
    private ReentrantLock __m_Lock;
    private PagedTopicCaches __m_PagedTopicCaches;
    private boolean __m_Released;
    private PrivilegedAction __m_RestartTopicAction;
    private SafePagedTopicService __m_SafeTopicService;
    private volatile boolean __m_Started;
    private Subject __m_Subject;
    private String __m_TopicName;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("EnsureTopicAction", EnsureTopicAction.get_CLASS());
        __mapChildren.put("RestartTopicAction", RestartTopicAction.get_CLASS());
    }

    public SafeNamedTopic() {
        this(null, null, true);
    }

    public SafeNamedTopic(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setLock(new ReentrantLock());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new SafeNamedTopic();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/SafeNamedTopic".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public int getChannelCount() {
        return this.getRunningNamedTopic().getChannelCount();
    }

    @Override
    public int getRemainingMessages(String sSubscriberGroup) {
        return this.getRunningNamedTopic().getRemainingMessages(sSubscriberGroup);
    }

    @Override
    public int getRemainingMessages(String Param_1, int[] Param_2) {
        return this.getRunningNamedTopic().getRemainingMessages(Param_1, Param_2);
    }

    private Service getService$Router() {
        return this.getRunningNamedTopic().getService();
    }

    @Override
    public Service getService() {
        return this.getSafeTopicService();
    }

    public Set getSubscriberGroups() {
        return this.getRunningNamedTopic().getSubscriberGroups();
    }

    private void checkInternalAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(LocalPermission.INTERNAL_SERVICE);
        }
    }

    public Publisher createPublisher(Publisher.Option[] options) {
        PagedTopicCaches pagedTopicCaches = this.getPagedTopicCaches();
        if (!pagedTopicCaches.isActive()) {
            throw new IllegalStateException("This topic is no longer active");
        }
        return new PagedTopicPublisher(this, pagedTopicCaches, options);
    }

    public Subscriber createSubscriber(Subscriber.Option[] options) {
        PagedTopicCaches pagedTopicCaches = this.getPagedTopicCaches();
        if (!pagedTopicCaches.isActive()) {
            throw new IllegalStateException("This topic is no longer active");
        }
        pagedTopicCaches.ensureConnected();
        return new PagedTopicSubscriber(this, pagedTopicCaches, options);
    }

    @Override
    public void destroy() {
        SafePagedTopicService safeservice = this.getSafeTopicService();
        this.getPagedTopicCaches().destroy();
        safeservice.destroyTopic(this);
        this.ensureGlobalLock();
        try {
            this.setDestroyed(true);
            this.setReleased(true);
            this.setInternalNamedTopic(null);
        }
        finally {
            this.unlockGlobal();
        }
    }

    @Override
    public void destroySubscriberGroup(String sGroupName) {
        if (sGroupName == null) {
            throw new IllegalArgumentException("invalid group name");
        }
        PagedTopicCaches pagedTopicCaches = this.getPagedTopicCaches();
        PagedTopicSubscriber.destroy(pagedTopicCaches, SubscriberGroupId.withName(sGroupName), 0L);
    }

    public void ensureGlobalLock() {
        SafePagedTopicService service = this.getSafeTopicService();
        service.ensureGlobalLock();
        try {
            this.ensureLocked();
        }
        catch (RuntimeException e) {
            service.unlockGlobal();
            throw e;
        }
    }

    public void ensureLocked() {
        ServiceDependencies deps = this.getSafeTopicService().getDependencies();
        long cRequestTimeout = deps == null ? 0L : deps.getRequestTimeoutMillis();
        long cTimeout = Timeout.isSet() ? Timeout.remainingTimeoutMillis() : cRequestTimeout;
        ReentrantLock lock = this.getLock();
        try {
            if (lock.tryLock(cTimeout <= 0L ? Long.MAX_VALUE : cTimeout, TimeUnit.MILLISECONDS)) {
                return;
            }
            throw Base.ensureRuntimeException(new RequestTimeoutException("Failed to acquire NamedTopic lock in " + cTimeout + "ms"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e, "Interrupted while attempting to acquire NamedTopic lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedTopic ensureRunningNamedTopic() {
        this.checkInternalAccess();
        NamedTopic topic = this.getInternalNamedTopic();
        SafePagedTopicService serviceSafe = this.getSafeTopicService();
        if (!(serviceSafe != null && serviceSafe.isRunning() && topic != null && topic.isActive() && this.isStarted())) {
            if ((serviceSafe == null || !serviceSafe.isRunning()) && serviceSafe.isServiceThread()) {
                throw new IllegalStateException("Service can not be restarted on a thread owned by the service");
            }
            this.ensureGlobalLock();
            try {
                topic = this.getInternalNamedTopic();
                serviceSafe = this.getSafeTopicService();
                if (!(serviceSafe != null && serviceSafe.isRunning() && topic != null && topic.isActive() && this.isStarted())) {
                    if (this.isReleased() || this.isDestroyed()) {
                        String reason = this.isDestroyed() ? "destroyed" : "released";
                        throw new IllegalStateException("SafeNamedTopic was explicitly " + reason);
                    }
                    if (topic != null) {
                        this.setInternalNamedTopic(null);
                        SafeNamedTopic._trace("Restarting NamedTopic: " + this.getTopicName(), 3);
                    }
                    topic = this.restartNamedTopic();
                    this.setInternalNamedTopic(topic);
                    this.setStarted(true);
                }
            }
            finally {
                this.unlockGlobal();
            }
        }
        return topic;
    }

    public void ensureSubscriberGroup(String sGroupName, Filter filter, ValueExtractor extractor) {
        if (sGroupName == null) {
            throw new IllegalArgumentException("invalid group name");
        }
        PagedTopicCaches pagedTopicCaches = this.getPagedTopicCaches();
        pagedTopicCaches.ensureSubscriberGroup(sGroupName, filter, extractor);
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    public PrivilegedAction getEnsureTopicAction() {
        return this.__m_EnsureTopicAction;
    }

    public NamedTopic getInternalNamedTopic() {
        return this.__m_InternalNamedTopic;
    }

    public ReentrantLock getLock() {
        return this.__m_Lock;
    }

    @Override
    public String getName() {
        return this.getTopicName();
    }

    public NamedTopic getNamedTopic() {
        this.checkInternalAccess();
        return this.getInternalNamedTopic();
    }

    public PagedTopicCaches getPagedTopicCaches() {
        return this.__m_PagedTopicCaches;
    }

    public PrivilegedAction getRestartTopicAction() {
        return this.__m_RestartTopicAction;
    }

    protected NamedTopic getRunningNamedTopic() {
        if (System.getSecurityManager() == null) {
            return this.ensureRunningNamedTopic();
        }
        return (NamedTopic)AccessController.doPrivileged(new DoAsAction(this.getEnsureTopicAction()));
    }

    public SafePagedTopicService getSafeTopicService() {
        return this.__m_SafeTopicService;
    }

    public Subject getSubject() {
        return this.__m_Subject;
    }

    public String getTopicName() {
        return this.__m_TopicName;
    }

    @Override
    public boolean isActive() {
        try {
            return this.getInternalNamedTopic().isActive();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public boolean isDestroyed() {
        try {
            return this.__m_Destroyed || this.getInternalNamedTopic().isDestroyed();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public boolean isReleased() {
        try {
            return this.__m_Released || this.getInternalNamedTopic().isReleased();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isStarted() {
        return this.__m_Started;
    }

    @Override
    public void onInit() {
        this.setEnsureTopicAction((EnsureTopicAction)this._newChild("EnsureTopicAction"));
        this.setRestartTopicAction((RestartTopicAction)this._newChild("RestartTopicAction"));
    }

    @Override
    public void release() {
        SafePagedTopicService safeservice = this.getSafeTopicService();
        this.getPagedTopicCaches().release();
        safeservice.releaseTopic(this);
        this.ensureGlobalLock();
        try {
            this.setReleased(true);
            this.setClassLoader(null);
            this.setInternalNamedTopic(null);
        }
        finally {
            this.unlockGlobal();
        }
    }

    protected NamedTopic restartNamedTopic() {
        NamedTopic topic;
        Subject subject = this.getSubject();
        if (subject == null) {
            TopicService service = (TopicService)this.getSafeTopicService().getRunningService();
            topic = service.ensureTopic(this.getTopicName(), this.getClassLoader());
        } else {
            topic = (NamedTopic)Subject.doAs(subject, this.getRestartTopicAction());
        }
        return topic;
    }

    public void setClassLoader(ClassLoader loaderClass) {
        this.__m_ClassLoader = loaderClass;
    }

    private void setDestroyed(boolean fDestroyed) {
        this.__m_Destroyed = fDestroyed;
    }

    protected void setEnsureTopicAction(PrivilegedAction actionTopic) {
        this.__m_EnsureTopicAction = actionTopic;
    }

    public void setInternalNamedTopic(NamedTopic topic) {
        if (topic == null) {
            this.setStarted(false);
        }
        this.__m_InternalNamedTopic = topic;
    }

    public void setLock(ReentrantLock lock) {
        this.__m_Lock = lock;
    }

    public void setPagedTopicCaches(PagedTopicCaches cachesTopic) {
        this.__m_PagedTopicCaches = cachesTopic;
    }

    public void setReleased(boolean fRelease) {
        this.ensureLocked();
        try {
            if (this.isReleased() && !fRelease) {
                throw new IllegalStateException("Topic cannot be un-released");
            }
            this.__m_Released = fRelease;
        }
        finally {
            this.getLock().unlock();
        }
    }

    protected void setRestartTopicAction(PrivilegedAction actionTopic) {
        this.__m_RestartTopicAction = actionTopic;
    }

    public void setSafeTopicService(SafePagedTopicService sProperty) {
        this.__m_SafeTopicService = sProperty;
    }

    public void setStarted(boolean fStarted) {
        this.__m_Started = fStarted;
    }

    public void setSubject(Subject subject) {
        this.__m_Subject = subject;
    }

    public void setTopicName(String sName) {
        this.__m_TopicName = sName;
    }

    @Override
    public String toString() {
        return this.get_Name() + ": " + String.valueOf(this.getInternalNamedTopic());
    }

    public void unlock() {
        this.getLock().unlock();
    }

    public void unlockGlobal() {
        this.unlock();
        this.getSafeTopicService().unlockGlobal();
    }

    static {
        SafeNamedTopic.__initStatic();
    }

    public static class EnsureTopicAction
    extends Util
    implements PrivilegedAction {
        public EnsureTopicAction() {
            this(null, null, true);
        }

        public EnsureTopicAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EnsureTopicAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeNamedTopic$EnsureTopicAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object run() {
            return ((SafeNamedTopic)this.get_Module()).ensureRunningNamedTopic();
        }
    }

    public static class RestartTopicAction
    extends Util
    implements PrivilegedAction {
        public RestartTopicAction() {
            this(null, null, true);
        }

        public RestartTopicAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new RestartTopicAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeNamedTopic$RestartTopicAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object run() {
            SafeNamedTopic topicSafe = (SafeNamedTopic)this.get_Module();
            TopicService service = (TopicService)topicSafe.getSafeTopicService().getRunningService();
            return service.ensureTopic(topicSafe.getTopicName(), topicSafe.getClassLoader());
        }
    }
}

