/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Lockable;
import com.oracle.coherence.common.base.NonBlocking;
import com.oracle.coherence.common.base.Timeout;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.SafeAsyncNamedCache;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.safeService.SafeCacheService;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.internal.util.listener.VersionAwareListeners;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceStoppedException;
import com.tangosol.net.cache.BinaryEntryStore;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.partition.VersionAwareMapListener;
import com.tangosol.net.partition.VersionedPartitions;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.util.AsynchronousAgent;
import com.tangosol.util.Base;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.security.auth.Subject;

public class SafeNamedCache
extends Util
implements Lockable,
ClassLoaderAware,
NamedCache,
BinaryEntryStore,
CacheStore,
VersionAwareMapListener {
    private transient String __m_CacheName;
    private transient ClassLoader __m_ClassLoader;
    private boolean __m_Destroyed;
    private PrivilegedAction __m_EnsureCacheAction;
    private volatile NamedCache __m_InternalNamedCache;
    private transient MapListenerSupport __m_ListenerSupport;
    private ReentrantLock __m_Lock;
    private boolean __m_Released;
    private PrivilegedAction __m_RestartCacheAction;
    private SafeAsyncNamedCache __m_SafeAsyncNamedCache;
    private SafeCacheService __m_SafeCacheService;
    private volatile boolean __m_Started;
    private Subject __m_Subject;
    private ThreadLocal __m_TloListenerVersions;
    private Unlockable __m_Unlockable;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("EnsureCacheAction", EnsureCacheAction.get_CLASS());
        __mapChildren.put("RestartCacheAction", RestartCacheAction.get_CLASS());
        __mapChildren.put("Unlockable", Unlockable.get_CLASS());
    }

    public SafeNamedCache() {
        this(null, null, true);
    }

    public SafeNamedCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setListenerSupport(new MapListenerSupport());
            this.setLock(new ReentrantLock());
            this.setTloListenerVersions(new ThreadLocal());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new SafeNamedCache();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/SafeNamedCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private void addIndex$Router(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.getRunningNamedCache().addIndex(extractor, fOrdered, comparator);
    }

    @Override
    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.addIndex$Router(this.prepareExtractor(extractor), fOrdered, comparator);
    }

    private Object aggregate$Router(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.getRunningNamedCache().aggregate(filter, agent);
    }

    @Override
    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        NamedCache cache = this.getNonblockingCache(agent);
        return cache == null ? this.aggregate$Router(filter, agent) : cache.aggregate(filter, agent);
    }

    private Object aggregate$Router(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return this.getRunningNamedCache().aggregate(collKeys, agent);
    }

    @Override
    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        NamedCache cache = this.getNonblockingCache(agent);
        return cache == null ? this.aggregate$Router(collKeys, agent) : cache.aggregate(collKeys, agent);
    }

    @Override
    public void clear() {
        this.getRunningNamedCache().clear();
    }

    @Override
    public Object compute(Object key, Remote.BiFunction function) {
        return this.getRunningNamedCache().compute(key, function);
    }

    @Override
    public Object compute(Object oKey, BiFunction function) {
        return this.getRunningNamedCache().compute(oKey, function);
    }

    @Override
    public Object computeIfAbsent(Object key, Remote.Function function) {
        return this.getRunningNamedCache().computeIfAbsent(key, function);
    }

    @Override
    public Object computeIfAbsent(Object oKey, Function function) {
        return this.getRunningNamedCache().computeIfAbsent(oKey, function);
    }

    @Override
    public Object computeIfPresent(Object key, Remote.BiFunction function) {
        return this.getRunningNamedCache().computeIfPresent(key, function);
    }

    @Override
    public Object computeIfPresent(Object oKey, BiFunction function) {
        return this.getRunningNamedCache().computeIfPresent(oKey, function);
    }

    @Override
    public boolean containsKey(Object oKey) {
        return this.getRunningNamedCache().containsKey(oKey);
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.getRunningNamedCache().containsValue(oValue);
    }

    @Override
    public Set entrySet() {
        return this.getRunningNamedCache().entrySet();
    }

    @Override
    public Set entrySet(Filter filter) {
        return this.getRunningNamedCache().entrySet(filter);
    }

    @Override
    public Set entrySet(Filter filter, Comparator comparator) {
        return this.getRunningNamedCache().entrySet(filter, comparator);
    }

    @Override
    public void forEach(Filter filter, BiConsumer action) {
        this.getRunningNamedCache().forEach(filter, action);
    }

    @Override
    public void forEach(Collection collKeys, BiConsumer action) {
        this.getRunningNamedCache().forEach(collKeys, action);
    }

    @Override
    public void forEach(BiConsumer consumer) {
        this.getRunningNamedCache().forEach(consumer);
    }

    @Override
    public Object get(Object oKey) {
        return this.getRunningNamedCache().get(oKey);
    }

    @Override
    public Map getAll(Collection col) {
        return this.getRunningNamedCache().getAll(col);
    }

    @Override
    public Object getOrDefault(Object oKey, Object oValue) {
        return this.getRunningNamedCache().getOrDefault(oKey, oValue);
    }

    private Object invoke$Router(Object oKey, InvocableMap.EntryProcessor agent) {
        return this.getRunningNamedCache().invoke(oKey, agent);
    }

    @Override
    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        NamedCache cache = this.getNonblockingCache(agent);
        return cache == null ? this.invoke$Router(oKey, agent) : cache.invoke(oKey, agent);
    }

    private Map invokeAll$Router(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.getRunningNamedCache().invokeAll(filter, agent);
    }

    @Override
    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        NamedCache cache = this.getNonblockingCache(agent);
        return cache == null ? this.invokeAll$Router(filter, agent) : cache.invokeAll(filter, agent);
    }

    private Map invokeAll$Router(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return this.getRunningNamedCache().invokeAll(collKeys, agent);
    }

    @Override
    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        NamedCache cache = this.getNonblockingCache(agent);
        return cache == null ? this.invokeAll$Router(collKeys, agent) : cache.invokeAll(collKeys, agent);
    }

    @Override
    public boolean isEmpty() {
        return this.getRunningNamedCache().isEmpty();
    }

    @Override
    public Set keySet() {
        return this.getRunningNamedCache().keySet();
    }

    @Override
    public Set keySet(Filter filter) {
        return this.getRunningNamedCache().keySet(filter);
    }

    @Override
    public boolean lock(Object oKey) {
        return this.getRunningNamedCache().lock(oKey);
    }

    @Override
    public boolean lock(Object oKey, long cMillis) {
        return this.getRunningNamedCache().lock(oKey, cMillis);
    }

    @Override
    public Object merge(Object key, Object value, Remote.BiFunction function) {
        return this.getRunningNamedCache().merge(key, value, function);
    }

    @Override
    public Object merge(Object oKey, Object oValue, BiFunction function) {
        return this.getRunningNamedCache().merge(oKey, oValue, function);
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        return this.getRunningNamedCache().put(oKey, oValue);
    }

    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.getRunningNamedCache().put(oKey, oValue, cMillis);
    }

    @Override
    public void putAll(Map map) {
        this.getRunningNamedCache().putAll(map);
    }

    @Override
    public Object putIfAbsent(Object oKey, Object oValue) {
        return this.getRunningNamedCache().putIfAbsent(oKey, oValue);
    }

    @Override
    public Object remove(Object oKey) {
        return this.getRunningNamedCache().remove(oKey);
    }

    @Override
    public boolean remove(Object oKey, Object oValue) {
        return this.getRunningNamedCache().remove(oKey, oValue);
    }

    private void removeIndex$Router(ValueExtractor extractor) {
        this.getRunningNamedCache().removeIndex(extractor);
    }

    @Override
    public void removeIndex(ValueExtractor extractor) {
        this.removeIndex$Router(this.prepareExtractor(extractor));
    }

    @Override
    public Object replace(Object oKey, Object oValue) {
        return this.getRunningNamedCache().replace(oKey, oValue);
    }

    @Override
    public boolean replace(Object oKey, Object oValueOld, Object oValueNew) {
        return this.getRunningNamedCache().replace(oKey, oValueOld, oValueNew);
    }

    @Override
    public void replaceAll(Filter filter, Remote.BiFunction function) {
        this.getRunningNamedCache().replaceAll(filter, function);
    }

    @Override
    public void replaceAll(Remote.BiFunction function) {
        this.getRunningNamedCache().replaceAll(function);
    }

    @Override
    public void replaceAll(Collection collKeys, Remote.BiFunction function) {
        this.getRunningNamedCache().replaceAll(collKeys, function);
    }

    @Override
    public void replaceAll(BiFunction function) {
        this.getRunningNamedCache().replaceAll(function);
    }

    @Override
    public int size() {
        return this.getRunningNamedCache().size();
    }

    @Override
    public RemoteStream stream() {
        return this.getRunningNamedCache().stream();
    }

    @Override
    public RemoteStream stream(Filter filter) {
        return this.getRunningNamedCache().stream(filter);
    }

    @Override
    public RemoteStream stream(Filter filter, ValueExtractor extractor) {
        return this.getRunningNamedCache().stream(filter, extractor);
    }

    @Override
    public RemoteStream stream(ValueExtractor extractor) {
        return this.getRunningNamedCache().stream(extractor);
    }

    @Override
    public RemoteStream stream(Collection collKeys) {
        return this.getRunningNamedCache().stream(collKeys);
    }

    @Override
    public RemoteStream stream(Collection collKeys, ValueExtractor extractor) {
        return this.getRunningNamedCache().stream(collKeys, extractor);
    }

    @Override
    public void truncate() {
        this.getRunningNamedCache().truncate();
    }

    @Override
    public boolean unlock(Object oKey) {
        return this.getRunningNamedCache().unlock(oKey);
    }

    @Override
    public Collection values() {
        return this.getRunningNamedCache().values();
    }

    @Override
    public Collection values(Filter filter) {
        return this.getRunningNamedCache().values(filter);
    }

    @Override
    public Collection values(Filter filter, Comparator comparator) {
        return this.getRunningNamedCache().values(filter, comparator);
    }

    @Override
    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        if (listener == this) {
            NamedCache cache = this.getRunningNamedCache();
            try {
                cache.addMapListener(listener, filter, fLite);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null || !cache.isActive() || !cache.getCacheService().isRunning()) return;
                throw e;
            }
        }
        if (listener instanceof MapListenerSupport.SynchronousListener || listener instanceof MapTriggerListener) {
            this.getRunningNamedCache().addMapListener(listener, filter, fLite);
            return;
        }
        if (listener == null) return;
        MapListenerSupport support = this.getListenerSupport();
        boolean fRegister = false;
        MapListenerSupport mapListenerSupport = support;
        synchronized (mapListenerSupport) {
            listener = VersionAwareListeners.createListener(listener);
            fRegister = support.addListenerWithCheck(listener, filter, fLite);
        }
        if (!fRegister) return;
        try {
            if (listener.isVersionAware()) {
                this.getTloListenerVersions().set(((VersionAwareMapListener)listener).getVersions());
            }
            this.addMapListener((MapListener)this, filter, fLite);
            return;
        }
        catch (RuntimeException e) {
            this.getListenerSupport().removeListener(listener, filter);
            throw e;
        }
        finally {
            this.getTloListenerVersions().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        if (listener == this) {
            NamedCache cache = this.getRunningNamedCache();
            try {
                cache.addMapListener(listener, oKey, fLite);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null || !cache.isActive() || !cache.getCacheService().isRunning()) return;
                throw e;
            }
        }
        if (listener instanceof MapListenerSupport.SynchronousListener) {
            this.getRunningNamedCache().addMapListener(listener, oKey, fLite);
            return;
        }
        if (listener == null) return;
        MapListenerSupport support = this.getListenerSupport();
        boolean fRegister = false;
        MapListenerSupport mapListenerSupport = support;
        synchronized (mapListenerSupport) {
            listener = VersionAwareListeners.createListener(listener);
            fRegister = support.addListenerWithCheck(listener, oKey, fLite);
        }
        if (!fRegister) return;
        try {
            if (listener.isVersionAware()) {
                this.getTloListenerVersions().set(((VersionAwareMapListener)listener).getVersions());
            }
            this.addMapListener((MapListener)this, oKey, fLite);
            return;
        }
        catch (RuntimeException e) {
            this.getListenerSupport().removeListener(listener, oKey);
            throw e;
        }
        finally {
            this.getTloListenerVersions().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncNamedCache async(AsyncNamedMap.Option[] options) {
        SafeAsyncNamedCache cacheAsync = this.getSafeAsyncNamedCache();
        if (cacheAsync == null) {
            this.ensureLocked();
            try {
                NamedCache cache = this.getRunningNamedCache();
                SafeAsyncNamedCache cacheSafe = new SafeAsyncNamedCache();
                cacheSafe.setCacheName(this.getCacheName());
                cacheSafe.setSafeNamedCache(this);
                cacheSafe.setSafeCacheService(this.getSafeCacheService());
                cacheSafe.setClassLoader(this.getClassLoader());
                cacheSafe.setOptions(options);
                cacheSafe.setInternalNamedCache((AsyncNamedCache)cache.async(options));
                cacheSafe.setStarted(true);
                cacheAsync = cacheSafe;
                this.setSafeAsyncNamedCache(cacheAsync);
            }
            finally {
                this.unlock();
            }
        }
        return cacheAsync;
    }

    @Override
    public int characteristics() {
        return 2;
    }

    private void checkInternalAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(LocalPermission.INTERNAL_SERVICE);
        }
    }

    @Override
    public void destroy() {
        SafeCacheService safeservice = this.getSafeCacheService();
        SafeCluster safecluster = safeservice.getSafeCluster();
        this.releaseListeners();
        safeservice.destroyCache(this);
        this.ensureGlobalLock();
        try {
            this.setDestroyed(true);
            this.setReleased(true);
            this.setInternalNamedCache(null);
        }
        finally {
            this.unlockGlobal();
        }
    }

    public void ensureGlobalLock() {
        SafeCacheService service = this.getSafeCacheService();
        service.ensureGlobalLock();
        try {
            this.ensureLocked();
        }
        catch (RuntimeException e) {
            service.unlockGlobal();
            throw e;
        }
    }

    public void ensureLocked() {
        ServiceDependencies deps = this.getSafeCacheService().getDependencies();
        long cRequestTimeout = deps == null ? 0L : deps.getRequestTimeoutMillis();
        long cTimeout = Timeout.isSet() ? Timeout.remainingTimeoutMillis() : cRequestTimeout;
        ReentrantLock lock = this.getLock();
        try {
            if (lock.tryLock(cTimeout <= 0L ? Long.MAX_VALUE : cTimeout, TimeUnit.MILLISECONDS)) {
                return;
            }
            throw Base.ensureRuntimeException(new RequestTimeoutException("Failed to acquire NamedCache lock in " + cTimeout + "ms"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e, "Interrupted while attempting to acquire NamedCache lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedCache ensureRunningNamedCache() {
        this.checkInternalAccess();
        NamedCache cache = this.getInternalNamedCache();
        SafeCacheService serviceSafe = this.getSafeCacheService();
        if (!(serviceSafe != null && serviceSafe.isRunning() && cache != null && cache.isActive() && this.isStarted())) {
            if ((serviceSafe == null || !serviceSafe.isRunning()) && serviceSafe.isServiceThread()) {
                throw new IllegalStateException("Service can not be restarted on a thread owned by the service");
            }
            this.ensureGlobalLock();
            try {
                cache = this.getInternalNamedCache();
                serviceSafe = this.getSafeCacheService();
                if (!(serviceSafe != null && serviceSafe.isRunning() && cache != null && cache.isActive() && this.isStarted())) {
                    if (this.isReleased() || this.isDestroyed()) {
                        String reason = this.isDestroyed() ? "destroyed" : "released";
                        throw new IllegalStateException("SafeNamedCache was explicitly " + reason);
                    }
                    if (cache != null) {
                        this.setInternalNamedCache(null);
                        SafeNamedCache._trace("Restarting NamedCache: " + this.getCacheName(), 3);
                    }
                    cache = this.restartNamedCache();
                    this.setInternalNamedCache(cache);
                    this.registerListeners(cache);
                    this.setStarted(true);
                }
            }
            finally {
                this.unlockGlobal();
            }
        }
        return cache;
    }

    @Override
    public void entryDeleted(MapEvent evt) {
        this.translateMapEvent(evt);
    }

    @Override
    public void entryInserted(MapEvent evt) {
        this.translateMapEvent(evt);
    }

    @Override
    public void entryUpdated(MapEvent evt) {
        this.translateMapEvent(evt);
    }

    public void erase(BinaryEntry binEntry) {
        this.getRunningBinaryEntryStore().erase(binEntry);
    }

    public void erase(Object oKey) {
        this.getRunningCacheStore().erase(oKey);
    }

    public void eraseAll(Collection colKeys) {
        this.getRunningCacheStore().eraseAll(colKeys);
    }

    public void eraseAll(Set setBinEntries) {
        this.getRunningBinaryEntryStore().eraseAll(setBinEntries);
    }

    @Override
    public Lockable.Unlockable exclusively() {
        this.ensureLocked();
        return (Unlockable)this._newChild("Unlockable");
    }

    @Override
    public String getCacheName() {
        return this.__m_CacheName;
    }

    @Override
    public CacheService getCacheService() {
        return this.getSafeCacheService();
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.getClassLoader();
    }

    public PrivilegedAction getEnsureCacheAction() {
        return this.__m_EnsureCacheAction;
    }

    protected NamedCache getInternalNamedCache() {
        return this.__m_InternalNamedCache;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public ReentrantLock getLock() {
        return this.__m_Lock;
    }

    public NamedCache getNamedCache() {
        this.checkInternalAccess();
        return this.getInternalNamedCache();
    }

    protected NamedCache getNonblockingCache() {
        NamedCache cache;
        if (NonBlocking.isNonBlockingCaller()) {
            cache = this.getInternalNamedCache();
            if (cache == null) {
                throw new ServiceStoppedException("Service has been terminated");
            }
        } else {
            cache = null;
        }
        return cache;
    }

    protected NamedCache getNonblockingCache(InvocableMap.EntryAggregator agent) {
        return agent instanceof AsynchronousAgent ? this.getNonblockingCache() : null;
    }

    protected NamedCache getNonblockingCache(InvocableMap.EntryProcessor agent) {
        return agent instanceof AsynchronousAgent ? this.getNonblockingCache() : null;
    }

    public PrivilegedAction getRestartCacheAction() {
        return this.__m_RestartCacheAction;
    }

    protected BinaryEntryStore getRunningBinaryEntryStore() {
        NamedCache cache = this.getRunningNamedCache();
        try {
            return (BinaryEntryStore)((Object)cache);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    protected CacheLoader getRunningCacheLoader() {
        NamedCache cache = this.getRunningNamedCache();
        try {
            return (CacheLoader)((Object)cache);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    protected CacheStore getRunningCacheStore() {
        NamedCache cache = this.getRunningNamedCache();
        try {
            return (CacheStore)((Object)cache);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException();
        }
    }

    protected NamedCache getRunningNamedCache() {
        if (System.getSecurityManager() == null) {
            return this.ensureRunningNamedCache();
        }
        return (NamedCache)AccessController.doPrivileged(new DoAsAction(this.getEnsureCacheAction()));
    }

    public SafeAsyncNamedCache getSafeAsyncNamedCache() {
        return this.__m_SafeAsyncNamedCache;
    }

    public SafeCacheService getSafeCacheService() {
        return this.__m_SafeCacheService;
    }

    public Subject getSubject() {
        return this.__m_Subject;
    }

    public ThreadLocal getTloListenerVersions() {
        return this.__m_TloListenerVersions;
    }

    public Unlockable getUnlockable() {
        return this.__m_Unlockable;
    }

    @Override
    public VersionedPartitions getVersions() {
        return (VersionedPartitions)this.getTloListenerVersions().get();
    }

    @Override
    public boolean isActive() {
        try {
            return this.getInternalNamedCache().isActive();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public boolean isReady() {
        try {
            return this.getInternalNamedCache().isReady();
        }
        catch (UnsupportedOperationException uoe) {
            throw uoe;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public boolean isDestroyed() {
        try {
            return this.__m_Destroyed || this.getInternalNamedCache().isDestroyed();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public boolean isReleased() {
        try {
            return this.__m_Released || this.getInternalNamedCache().isReleased();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean isStarted() {
        return this.__m_Started;
    }

    @Override
    public void load(BinaryEntry binEntry) {
        this.getRunningBinaryEntryStore().load(binEntry);
    }

    @Override
    public Object load(Object oKey) {
        return this.getRunningCacheLoader().load(oKey);
    }

    @Override
    public Map loadAll(Collection colKeys) {
        return this.getRunningCacheLoader().loadAll(colKeys);
    }

    public void loadAll(Set setBinEntries) {
        this.getRunningBinaryEntryStore().loadAll(setBinEntries);
    }

    @Override
    public void onInit() {
        this.setEnsureCacheAction((EnsureCacheAction)this._newChild("EnsureCacheAction"));
        this.setRestartCacheAction((RestartCacheAction)this._newChild("RestartCacheAction"));
        this.setUnlockable((Unlockable)this._newChild("Unlockable"));
        super.onInit();
    }

    protected ValueExtractor prepareExtractor(ValueExtractor extractor) {
        return Lambdas.ensureRemotable(extractor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerListeners(NamedCache cache) {
        MapListenerSupport support;
        Filter[] aFilter = new Filter[]{};
        Object[] aoKey = new Object[]{};
        MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
        synchronized (mapListenerSupport) {
            if (!support.isEmpty()) {
                aFilter = support.getFilterSet().toArray(aFilter);
                aoKey = support.getKeySet().toArray();
            }
        }
        for (Filter filter : aFilter) {
            this.getTloListenerVersions().set(support.getMinVersions(filter));
            cache.addMapListener(this, filter, !support.containsStandardListeners(filter));
            this.getTloListenerVersions().remove();
        }
        for (Object oKey : aoKey) {
            this.getTloListenerVersions().set(support.getMinVersions(oKey));
            cache.addMapListener(this, oKey, !support.containsStandardListeners(oKey));
            this.getTloListenerVersions().remove();
        }
    }

    @Override
    public void release() {
        SafeCacheService safeservice = this.getSafeCacheService();
        SafeCluster safecluster = safeservice.getSafeCluster();
        this.releaseListeners();
        safeservice.releaseCache(this);
        this.ensureGlobalLock();
        try {
            this.setReleased(true);
            this.setClassLoader(null);
            this.setInternalNamedCache(null);
        }
        finally {
            this.unlockGlobal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseListeners() {
        MapListenerSupport support = this.getListenerSupport();
        if (!support.isEmpty()) {
            LinkedList listFilter = new LinkedList();
            LinkedList listKeys = new LinkedList();
            MapListenerSupport mapListenerSupport = support;
            synchronized (mapListenerSupport) {
                if (!support.isEmpty()) {
                    listFilter.addAll(support.getFilterSet());
                    listKeys.addAll(support.getKeySet());
                    support.clear();
                }
            }
            Iterator iter = listFilter.iterator();
            while (iter.hasNext()) {
                this.removeMapListener((MapListener)this, (Filter)iter.next());
            }
            iter = listKeys.iterator();
            while (iter.hasNext()) {
                this.removeMapListener((MapListener)this, iter.next());
            }
        }
    }

    @Override
    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeMapListener(MapListener listener, Filter filter) {
        if (listener == this || listener instanceof MapListenerSupport.SynchronousListener || listener instanceof MapTriggerListener) {
            NamedCache cache = this.getInternalNamedCache();
            try {
                cache.removeMapListener(listener, filter);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null || !cache.isActive() || !cache.getCacheService().isRunning()) return;
                throw e;
            }
        } else {
            MapListenerSupport support;
            boolean fUnregister;
            if (listener == null || !(fUnregister = (support = this.getListenerSupport()).removeListenerWithCheck(listener, filter))) return;
            this.removeMapListener((MapListener)this, filter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeMapListener(MapListener listener, Object oKey) {
        if (listener == this || listener instanceof MapListenerSupport.SynchronousListener) {
            NamedCache cache = this.getInternalNamedCache();
            try {
                cache.removeMapListener(listener, oKey);
                return;
            }
            catch (RuntimeException e) {
                if (cache == null || !cache.isActive() || !cache.getCacheService().isRunning()) return;
                throw e;
            }
        } else {
            MapListenerSupport support;
            boolean fUnregister;
            if (listener == null || !(fUnregister = (support = this.getListenerSupport()).removeListenerWithCheck(listener, oKey))) return;
            this.removeMapListener((MapListener)this, oKey);
        }
    }

    protected NamedCache restartNamedCache() {
        NamedCache cache;
        Subject subject = this.getSubject();
        if (subject == null) {
            CacheService service = (CacheService)this.getSafeCacheService().getRunningService();
            cache = service.ensureCache(this.getCacheName(), this.getClassLoader());
        } else {
            cache = (NamedCache)Subject.doAs(subject, this.getRestartCacheAction());
        }
        return cache;
    }

    public void setCacheName(String sName) {
        this.__m_CacheName = sName;
    }

    public void setClassLoader(ClassLoader loader) {
        this.__m_ClassLoader = loader;
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    private void setDestroyed(boolean fDestroyed) {
        this.__m_Destroyed = fDestroyed;
    }

    protected void setEnsureCacheAction(PrivilegedAction action) {
        this.__m_EnsureCacheAction = action;
    }

    public void setInternalNamedCache(NamedCache cache) {
        if (cache == null) {
            this.setStarted(false);
        }
        this.__m_InternalNamedCache = cache;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    public void setLock(ReentrantLock lock) {
        this.__m_Lock = lock;
    }

    public void setReleased(boolean fRelease) {
        this.ensureLocked();
        try {
            if (this.isReleased() && !fRelease) {
                throw new IllegalStateException("Cache cannot be un-released");
            }
            this.__m_Released = fRelease;
        }
        finally {
            this.getLock().unlock();
        }
    }

    protected void setRestartCacheAction(PrivilegedAction action) {
        this.__m_RestartCacheAction = action;
    }

    public void setSafeAsyncNamedCache(SafeAsyncNamedCache sProperty) {
        this.__m_SafeAsyncNamedCache = sProperty;
    }

    public void setSafeCacheService(SafeCacheService service) {
        this.__m_SafeCacheService = service;
    }

    public void setStarted(boolean fStarted) {
        this.__m_Started = fStarted;
    }

    public void setSubject(Subject subject) {
        this.__m_Subject = subject;
    }

    public void setTloListenerVersions(ThreadLocal localVersions) {
        this.__m_TloListenerVersions = localVersions;
    }

    public void setUnlockable(Unlockable unlockable) {
        this.__m_Unlockable = unlockable;
    }

    public void store(BinaryEntry binEntry) {
        this.getRunningBinaryEntryStore().store(binEntry);
    }

    public void store(Object oKey, Object oValue) {
        this.getRunningCacheStore().store(oKey, oValue);
    }

    public void storeAll(Map mapEntries) {
        this.getRunningCacheStore().storeAll(mapEntries);
    }

    public void storeAll(Set setBinEntries) {
        this.getRunningBinaryEntryStore().storeAll(setBinEntries);
    }

    @Override
    public String toString() {
        return this.get_Name() + ": " + String.valueOf(this.getInternalNamedCache());
    }

    protected void translateMapEvent(MapEvent evt) {
        if (evt.getSource() == this.getInternalNamedCache()) {
            evt = MapListenerSupport.convertEvent(evt, this, null, null);
            this.getListenerSupport().fireEvent(evt, true);
        } else {
            SafeNamedCache._trace("Ah ha!\nevent.source: " + String.valueOf(evt.getSource()) + "\nInternalCache: " + String.valueOf(this.getInternalNamedCache()), 3);
        }
    }

    public void unlock() {
        this.getLock().unlock();
    }

    public void unlockGlobal() {
        this.unlock();
        this.getSafeCacheService().unlockGlobal();
    }

    static {
        SafeNamedCache.__initStatic();
    }

    public static class EnsureCacheAction
    extends Util
    implements PrivilegedAction {
        public EnsureCacheAction() {
            this(null, null, true);
        }

        public EnsureCacheAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EnsureCacheAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeNamedCache$EnsureCacheAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object run() {
            return ((SafeNamedCache)this.get_Module()).ensureRunningNamedCache();
        }
    }

    public static class RestartCacheAction
    extends Util
    implements PrivilegedAction {
        public RestartCacheAction() {
            this(null, null, true);
        }

        public RestartCacheAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new RestartCacheAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeNamedCache$RestartCacheAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object run() {
            SafeNamedCache cacheSafe = (SafeNamedCache)this.get_Module();
            CacheService service = (CacheService)cacheSafe.getSafeCacheService().getRunningService();
            return service.ensureCache(cacheSafe.getCacheName(), cacheSafe.getClassLoader());
        }
    }

    public static class Unlockable
    extends Util
    implements Lockable.Unlockable {
        public Unlockable() {
            this(null, null, true);
        }

        public Unlockable(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Unlockable();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeNamedCache$Unlockable".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void close() {
            ((SafeNamedCache)this.get_Module()).unlock();
        }
    }
}

