/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.base.Lockable;
import com.oracle.coherence.common.base.Timeout;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.extend.RemoteService;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteCacheService;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteInvocationService;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.util.LocalCache;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.ShutdownHook;
import com.tangosol.coherence.component.util.safeService.SafeCacheService;
import com.tangosol.coherence.component.util.safeService.SafeInvocationService;
import com.tangosol.coherence.component.util.safeService.SafeProxyService;
import com.tangosol.coherence.component.util.safeService.safeCacheService.SafeDistributedCacheService;
import com.tangosol.coherence.component.util.safeService.safeCacheService.safeDistributedCacheService.SafePagedTopicService;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilderRegistry;
import com.tangosol.config.expression.SystemPropertyParameterResolver;
import com.tangosol.internal.net.cluster.DefaultClusterDependencies;
import com.tangosol.internal.net.cluster.LegacyXmlClusterDependencies;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.internal.util.Daemons;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.PagedTopicService;
import com.tangosol.net.ProxyService;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.internal.ClusterJoinException;
import com.tangosol.net.internal.ScopedServiceReferenceStore;
import com.tangosol.net.management.Registry;
import com.tangosol.net.security.DoAsAction;
import com.tangosol.net.security.IdentityAsserter;
import com.tangosol.net.security.IdentityTransformer;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.WrapperException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class SafeCluster
extends Util
implements Lockable,
com.tangosol.net.Cluster,
OperationalContext,
ServiceListener,
SynchronousListener {
    private ClassLoader __m_ContextClassLoader;
    private volatile ClusterDependencies __m_Dependencies;
    private boolean __m_Disposed;
    private PrivilegedAction __m_EnsureClusterAction;
    private transient Cluster __m_InternalCluster;
    private Set __m_LocalServices;
    private ReentrantLock __m_Lock;
    private transient Registry __m_Management;
    private boolean __m_Restart;
    private ScopedServiceReferenceStore __m_ScopedServiceStore;
    private transient Map __m_ServiceContext;
    private ShutdownHook __m_ShutdownHook;
    private com.tangosol.coherence.component.net.Member __m_SurrogateMember;
    private Unlockable __m_Unlockable;
    private DaemonPool m_commonDaemon;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("EnsureClusterAction", EnsureClusterAction.get_CLASS());
        __mapChildren.put("EnsureSafeServiceAction", EnsureSafeServiceAction.get_CLASS());
        __mapChildren.put("ParseDependenciesAction", ParseDependenciesAction.get_CLASS());
        __mapChildren.put("ShutdownHook", ShutdownHook.get_CLASS());
        __mapChildren.put("Unlockable", Unlockable.get_CLASS());
    }

    public SafeCluster() {
        this(null, null, true);
    }

    public SafeCluster(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setLock(new ReentrantLock());
            this.setRestart(true);
            this.setScopedServiceStore(new ScopedServiceReferenceStore());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_ServiceContext = new SafeHashMap();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public static Component get_Instance() {
        return new SafeCluster();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/SafeCluster".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public String getClusterName() {
        return this.getRunningCluster().getClusterName();
    }

    public Set getMemberSet() {
        return this.getRunningCluster().getMemberSet();
    }

    @Override
    public Member getOldestMember() {
        return this.getRunningCluster().getOldestMember();
    }

    @Override
    public Disposable getResource(String sName) {
        return this.getRunningCluster().getResource(sName);
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        return this.getRunningCluster().getResourceRegistry();
    }

    @Override
    public ServiceInfo getServiceInfo(String sName) {
        return this.getRunningCluster().getServiceInfo(sName);
    }

    public Enumeration getServiceNames() {
        return this.getRunningCluster().getServiceNames();
    }

    @Override
    public void registerResource(String sName, Disposable disposable) {
        this.getRunningCluster().registerResource(sName, disposable);
    }

    @Override
    public Disposable unregisterResource(String sName) {
        return this.getRunningCluster().unregisterResource(sName);
    }

    private void checkInternalAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(LocalPermission.INTERNAL_SERVICE);
        }
    }

    protected void cleanup() {
        this.setInternalCluster(null);
        this.setSurrogateMember(null);
        if (this.m_commonDaemon != null) {
            this.m_commonDaemon.shutdown();
        }
        this.getScopedServiceStore().clear();
        this.getLocalServices().clear();
    }

    @Override
    public void configure(XmlElement xmlConfig) {
        ParseDependenciesAction action = (ParseDependenciesAction)this._newChild("ParseDependenciesAction");
        action.setXmlConfig(xmlConfig);
        this.setDependencies((ClusterDependencies)AccessController.doPrivileged(action));
    }

    public void dispose() {
        this.ensureLocked();
        try {
            if (!this.isDisposed()) {
                this.setDisposed(true);
                this.shutdown();
            }
        }
        finally {
            this.unlock();
        }
    }

    public ClusterDependencies ensureDependencies() {
        ClusterDependencies deps = this.getDependencies();
        if (deps == null) {
            this.configure(CacheFactory.getClusterConfig());
            deps = this.getDependencies();
        }
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service ensureLocalService(String sName, String sType) {
        Component serviceLocal;
        if (sType.equals("LocalCache")) {
            service = new LocalCache();
            ((LocalCache)service).setServiceName(sName);
            ((LocalCache)service).setCluster(this);
            serviceLocal = service;
        } else if (sType.equals("RemoteCache")) {
            service = new RemoteCacheService();
            ((RemoteService)service).setServiceName(sName);
            ((RemoteService)service).setCluster(this);
            serviceLocal = service;
        } else if (sType.equals("RemoteInvocation")) {
            service = new RemoteInvocationService();
            ((RemoteService)service).setServiceName(sName);
            ((RemoteService)service).setCluster(this);
            serviceLocal = service;
        } else {
            ClusterDependencies.ServiceProvider provider = this.getDependencies().getLocalServiceProvider(sType);
            Component component = serviceLocal = provider == null ? null : provider.createService(sName, this);
            if (serviceLocal == null) {
                throw new IllegalArgumentException("illegal local service type: " + sType);
            }
        }
        serviceLocal.addServiceListener(this);
        String sHook = Config.getProperty("coherence.shutdownhook.local", "true");
        Set setLocal = this.getLocalServices();
        if (setLocal.isEmpty() && this.getShutdownHook() == null && "true".equals(sHook)) {
            Set set = setLocal;
            synchronized (set) {
                if (setLocal.isEmpty() && this.getShutdownHook() == null) {
                    try {
                        ShutdownHook hook = new ShutdownHook();
                        hook.set_Feed(new WeakReference<SafeCluster>(this));
                        this.setShutdownHook(hook);
                        hook.register();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        setLocal.add(serviceLocal);
        return serviceLocal;
    }

    public void ensureLocked() {
        this.ensureLocked(-1L);
    }

    public void ensureLocked(long cRequestTimeout) {
        ReentrantLock lock = this.getLock();
        long cTimeout = Timeout.isSet() || cRequestTimeout == -1L ? Timeout.remainingTimeoutMillis() : cRequestTimeout;
        try {
            if (lock.tryLock(cTimeout, TimeUnit.MILLISECONDS)) {
                return;
            }
            throw Base.ensureRuntimeException(new RequestTimeoutException("Failed to acquire cluster lock in " + cTimeout + "ms"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e, "Interrupted while attempting to acquire cluster lock");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cluster ensureRunningCluster() {
        Gateway registry;
        this.checkInternalAccess();
        Cluster cluster = this.getInternalCluster();
        if (cluster != null && cluster.isRunning()) return cluster;
        this.ensureLocked();
        boolean fInit = true;
        try {
            cluster = this.getInternalCluster();
            if (cluster == null || !cluster.isRunning()) {
                if (!this.isRestart()) throw new IllegalStateException(this.isDisposed() ? "SafeCluster has been shutdown" : "SafeCluster has been explicitly stopped or has not been started");
                if (cluster != null) {
                    if (cluster.isHalted()) {
                        throw new IllegalStateException("The cluster has been halted and is not restartable. This cluster member's JVM process must be restarted.");
                    }
                    cluster.ensureStopped();
                    cluster = null;
                    this.setInternalCluster(null);
                    SafeCluster._trace("Restarting cluster", 3);
                }
                cluster = this.restartCluster();
                this.setInternalCluster(cluster);
            } else {
                fInit = false;
            }
        }
        finally {
            this.unlock();
        }
        if (!fInit || (registry = (Gateway)this.getManagement()) == null) return cluster;
        registry.reset();
        String sNodeName = registry.ensureGlobalName("type=Node");
        registry.register(sNodeName, this.getLocalMember());
        String sP2PName = registry.ensureGlobalName("type=PointToPoint");
        registry.register(sP2PName, cluster.getClusterService().getClusterMemberSet());
        registry.registerReporter();
        registry.registerCustomBeans();
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SafeService ensureSafeService(String sName, String sType) {
        ScopedServiceReferenceStore store = this.getScopedServiceStore();
        SafeService serviceSafe = (SafeService)store.getService(sName);
        if (serviceSafe == null) {
            this.ensureLocked();
            try {
                serviceSafe = (SafeService)store.getService(sName);
                if (serviceSafe == null) {
                    serviceSafe = this.instantiateSafeService(this.instantiateService(sName, sType));
                    serviceSafe.setContextClassLoader(this.getContextClassLoader());
                    serviceSafe.setSafeCluster(this);
                    serviceSafe.setServiceName(sName);
                    serviceSafe.setServiceType(sType);
                    serviceSafe.setSubject(SecurityHelper.getCurrentSubject());
                    store.putService(serviceSafe, sName, sType);
                }
            }
            finally {
                this.unlock();
            }
        }
        if (!serviceSafe.getServiceType().equals(sType)) {
            throw new IllegalArgumentException("Requested service type \"" + sType + "\", but the existing service has type \"" + serviceSafe.getServiceType() + "\"");
        }
        return serviceSafe;
    }

    @Override
    public Service ensureService(String sName, String sType) {
        String sCacheName = "Invocation".equals(sType) || "Proxy".equals(sType) ? null : "*";
        Security.checkPermission(this.getInternalCluster(), sName, sCacheName, "join");
        EnsureSafeServiceAction action = (EnsureSafeServiceAction)this._newChild("EnsureSafeServiceAction");
        action.setServiceName(sName);
        action.setServiceType(sType);
        return (Service)(System.getSecurityManager() == null ? action.run() : AccessController.doPrivileged(new DoAsAction(action)));
    }

    @Override
    public Lockable.Unlockable exclusively() {
        this.ensureLocked();
        return this.getUnlockable();
    }

    public Map getAddressProviderMap() {
        return this.ensureDependencies().getAddressProviderMap();
    }

    @Override
    public ParameterizedBuilderRegistry getBuilderRegistry() {
        return this.ensureDependencies().getBuilderRegistry();
    }

    public Cluster getCluster() {
        this.checkInternalAccess();
        return this.getInternalCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DaemonPool getCommonDaemonPool() {
        DaemonPool pool = this.m_commonDaemon;
        if (pool == null) {
            SafeCluster safeCluster = this;
            synchronized (safeCluster) {
                pool = this.m_commonDaemon;
                if (pool == null) {
                    ParameterizedBuilder<DaemonPool> builder = this.getBuilderRegistry().getBuilder(DaemonPool.class, "common-daemon-pool");
                    if (builder != null) {
                        SystemPropertyParameterResolver resolver = new SystemPropertyParameterResolver();
                        ClassLoader loader = Classes.getContextClassLoader();
                        pool = this.m_commonDaemon = builder.realize(resolver, loader, null);
                    }
                    if (pool == null) {
                        pool = Daemons.newDaemonPool(new DefaultDaemonPoolDependencies());
                    }
                    pool.start();
                }
            }
        }
        return pool;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        ClassLoader loader = this.__m_ContextClassLoader;
        if (loader == null) {
            loader = Base.getContextClassLoader(this);
        }
        return loader;
    }

    @Override
    public ClusterDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    @Override
    public InetAddress getDiscoveryInterface() {
        return this.ensureDependencies().getGroupInterface();
    }

    @Override
    public int getDiscoveryTimeToLive() {
        return this.ensureDependencies().getGroupTimeToLive();
    }

    @Override
    public int getEdition() {
        return this.ensureDependencies().getEdition();
    }

    @Override
    public String getEditionName() {
        return Coherence.EDITION_NAMES[this.ensureDependencies().getEdition()];
    }

    public PrivilegedAction getEnsureClusterAction() {
        return this.__m_EnsureClusterAction;
    }

    public Map getFilterMap() {
        return this.ensureDependencies().getFilterMap();
    }

    @Override
    public IdentityAsserter getIdentityAsserter() {
        Security.getInstance();
        return Security.getIdentityAsserter();
    }

    @Override
    public IdentityTransformer getIdentityTransformer() {
        Security.getInstance();
        return Security.getIdentityTransformer();
    }

    protected Cluster getInternalCluster() {
        return this.__m_InternalCluster;
    }

    @Override
    public Member getLocalMember() {
        Cluster cluster = this.getInternalCluster();
        return cluster == null ? this.getSurrogateMember() : cluster.getLocalMember();
    }

    protected Set getLocalServices() {
        return this.__m_LocalServices;
    }

    @Override
    public int getLocalTcpPort() {
        Cluster cluster = this.getCluster();
        return cluster == null ? 0 : cluster.getSocketManager().getAcceptorChannel().getPort();
    }

    public ReentrantLock getLock() {
        return this.__m_Lock;
    }

    @Override
    public Registry getManagement() {
        return this.__m_Management;
    }

    public Cluster getRunningCluster() {
        if (System.getSecurityManager() == null) {
            return this.ensureRunningCluster();
        }
        return (Cluster)AccessController.doPrivileged(new DoAsAction(this.getEnsureClusterAction()));
    }

    public ScopedServiceReferenceStore getScopedServiceStore() {
        return this.__m_ScopedServiceStore;
    }

    public Map getSerializerMap() {
        return this.ensureDependencies().getSerializerMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service getService(String sName) {
        Security.checkPermission(this.getInternalCluster(), sName, null, "join");
        ScopedServiceReferenceStore store = this.getScopedServiceStore();
        SafeService serviceSafe = (SafeService)store.getService(sName);
        if (serviceSafe == null) {
            this.ensureLocked();
            try {
                Service service;
                serviceSafe = (SafeService)store.getService(sName);
                if (serviceSafe == null && (service = this.getRunningCluster().getService(sName)) != null) {
                    serviceSafe = this.instantiateSafeService(service);
                    serviceSafe.setSafeCluster(this);
                    serviceSafe.setServiceName(sName);
                    String sServiceType = service.getInfo().getServiceType();
                    serviceSafe.setServiceType(sServiceType);
                    serviceSafe.setContextClassLoader(this.getContextClassLoader());
                    store.putService(serviceSafe, sName, sServiceType);
                }
            }
            finally {
                this.unlock();
            }
        }
        return serviceSafe;
    }

    protected Map getServiceContext() {
        return this.__m_ServiceContext;
    }

    public ShutdownHook getShutdownHook() {
        return this.__m_ShutdownHook;
    }

    public Map getSnapshotArchiverMap() {
        return this.ensureDependencies().getSnapshotArchiverMap();
    }

    @Override
    public SocketProviderFactory getSocketProviderFactory() {
        return this.ensureDependencies().getSocketProviderFactory();
    }

    public long getStartupTimeout() {
        return 0L;
    }

    public com.tangosol.coherence.component.net.Member getSurrogateMember() {
        com.tangosol.coherence.component.net.Member member = this.__m_SurrogateMember;
        if (member == null) {
            ClusterDependencies deps = this.ensureDependencies();
            member = new com.tangosol.coherence.component.net.Member();
            member.configure(deps.getMemberIdentity(), deps.getLocalAddress());
            this.setSurrogateMember(member);
        }
        return member;
    }

    @Override
    public long getTimeMillis() {
        try {
            return this.getInternalCluster().getTimeMillis();
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    public Unlockable getUnlockable() {
        return this.__m_Unlockable;
    }

    protected SafeService instantiateSafeService(Service service) {
        SafeService serviceSafe = service instanceof CacheService ? (service instanceof PagedTopicService ? new SafePagedTopicService() : (service instanceof DistributedCacheService ? new SafeDistributedCacheService() : new SafeCacheService())) : (service instanceof InvocationService ? new SafeInvocationService() : (service instanceof ProxyService ? new SafeProxyService() : new SafeService()));
        serviceSafe.setInternalService(service);
        return serviceSafe;
    }

    public Service instantiateService(String sName, String sType) {
        return SafeCluster.isLocalService(sType) ? this.ensureLocalService(sName, sType) : this.getRunningCluster().ensureService(sName, sType);
    }

    public boolean isDisposed() {
        return this.__m_Disposed;
    }

    public static boolean isLocalService(String sType) {
        return sType.equals("LocalCache") || sType.equals("RemoteCache") || sType.equals("RemoteGrpcCache") || sType.equals("RemoteInvocation");
    }

    public boolean isRestart() {
        return this.__m_Restart;
    }

    @Override
    public boolean isRunning() {
        Cluster cluster = this.getInternalCluster();
        return cluster != null && this.isRestart() && cluster.isRunning();
    }

    @Override
    public boolean isSubjectScopingEnabled() {
        Security.getInstance();
        return Security.isSubjectScoped();
    }

    @Override
    public void onInit() {
        this.setLocalServices(new SafeHashSet(5, 1.0f, 1.0f));
        this.setEnsureClusterAction((EnsureClusterAction)this._newChild("EnsureClusterAction"));
        this.setUnlockable((Unlockable)this._newChild("Unlockable"));
        super.onInit();
    }

    protected Cluster restartCluster() {
        int cAttempts = 0;
        while (true) {
            Cluster cluster = null;
            try {
                cluster = new Cluster();
                this.startCluster(cluster);
                return cluster;
            }
            catch (Throwable e) {
                if (!(e instanceof ClusterJoinException) && !(e.getCause() instanceof ClusterJoinException) || ++cAttempts >= 5) {
                    SafeCluster._trace("Error while starting cluster: " + SafeCluster.getStackTrace(e), 1);
                    try {
                        if (this.isRunning()) {
                            cluster.stop();
                        }
                    }
                    catch (Throwable e2) {
                        SafeCluster._trace("Failed to stop cluster: " + SafeCluster.getStackTrace(e2), 2);
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw (RuntimeException)e;
                }
                SafeCluster._trace("Cluster seniority changed during join; rejoining the cluster", 3);
                ++cAttempts;
                continue;
            }
            break;
        }
    }

    @Override
    public void resumeService(String sService) {
        Cluster cluster = this.getRunningCluster();
        if (cluster != null) {
            Security.checkPermission(cluster, Base.equals(sService, "Cluster") ? "*" : sService, null, "create");
            cluster.resumeService(sService);
        }
    }

    @Override
    public void serviceStarted(ServiceEvent evt) {
    }

    @Override
    public void serviceStarting(ServiceEvent evt) {
    }

    @Override
    public void serviceStopped(ServiceEvent evt) {
        Service service = (Service)evt.getService();
        if (SafeCluster.isLocalService(service.getInfo().getServiceType())) {
            this.getLocalServices().remove(service);
        }
    }

    @Override
    public void serviceStopping(ServiceEvent evt) {
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
    }

    @Override
    public void setDependencies(ClusterDependencies deps) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot configure running cluster");
        }
        this.__m_Dependencies = new DefaultClusterDependencies(deps).validate();
        this.setSurrogateMember(null);
    }

    protected void setDisposed(boolean fDispose) {
        this.__m_Disposed = fDispose;
    }

    protected void setEnsureClusterAction(PrivilegedAction action) {
        this.__m_EnsureClusterAction = action;
    }

    protected void setInternalCluster(Cluster cluster) {
        this.__m_InternalCluster = cluster;
    }

    protected void setLocalServices(Set set) {
        this.__m_LocalServices = set;
    }

    public void setLock(ReentrantLock lock) {
        this.__m_Lock = lock;
    }

    @Override
    public void setManagement(Registry registry) {
        this.__m_Management = registry;
        Cluster cluster = this.getInternalCluster();
        if (cluster != null) {
            cluster.setManagement(registry);
        }
    }

    protected void setRestart(boolean fRestart) {
        this.__m_Restart = fRestart;
    }

    protected void setScopedServiceStore(ScopedServiceReferenceStore store) {
        this.__m_ScopedServiceStore = store;
    }

    private void setServiceContext(Map mapContext) {
        this.__m_ServiceContext = mapContext;
    }

    protected void setShutdownHook(ShutdownHook hook) {
        this.__m_ShutdownHook = hook;
    }

    protected void setSurrogateMember(com.tangosol.coherence.component.net.Member member) {
        this.__m_SurrogateMember = member;
    }

    public void setUnlockable(Unlockable unlockable) {
        this.__m_Unlockable = unlockable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.ensureLocked();
        try {
            this.setRestart(false);
            Cluster cluster = this.getInternalCluster();
            if (cluster != null) {
                Cluster cluster2 = cluster;
                synchronized (cluster2) {
                    if (cluster.isRunning()) {
                        cluster.shutdown();
                    }
                }
            }
            this.shutdownLocalServices();
            this.cleanup();
        }
        finally {
            this.unlock();
        }
    }

    public void shutdownLocalServices() {
        ShutdownHook hook = this.getShutdownHook();
        if (hook != null) {
            hook.unregister();
            this.setShutdownHook(null);
        }
        try {
            Iterator iter = this.getLocalServices().iterator();
            while (iter.hasNext()) {
                Service service = (Service)iter.next();
                iter.remove();
                service.removeServiceListener(this);
                service.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void start() {
        if (!this.isDisposed()) {
            this.ensureLocked();
            try {
                if (!this.isDisposed()) {
                    this.setRestart(true);
                }
                this.getRunningCluster();
            }
            finally {
                this.unlock();
            }
        }
    }

    protected void startCluster(Cluster cluster) {
        cluster.setDependencies(this.ensureDependencies());
        cluster.setOperationalContext(this);
        cluster.setManagement(this.getManagement());
        cluster.getClusterService().setServiceContext(this.getServiceContext());
        cluster.start();
        SafeCluster._trace("Started cluster " + String.valueOf(cluster), 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.ensureLocked();
        try {
            this.setRestart(false);
            Cluster cluster = this.getInternalCluster();
            if (cluster != null) {
                Cluster cluster2 = cluster;
                synchronized (cluster2) {
                    if (cluster.isRunning()) {
                        cluster.stop();
                    }
                }
            }
            this.shutdownLocalServices();
            this.cleanup();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void suspendService(String sService) {
        Cluster cluster = this.getRunningCluster();
        if (cluster != null) {
            Security.checkPermission(cluster, Base.equals(sService, "Cluster") ? "*" : sService, null, "destroy");
            cluster.suspendService(sService);
        }
    }

    @Override
    public String toString() {
        return this.get_Name() + ": " + String.valueOf(this.getInternalCluster());
    }

    public void unlock() {
        this.getLock().unlock();
    }

    static {
        SafeCluster.__initStatic();
    }

    public static class EnsureClusterAction
    extends Util
    implements PrivilegedAction {
        public EnsureClusterAction() {
            this(null, null, true);
        }

        public EnsureClusterAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EnsureClusterAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeCluster$EnsureClusterAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object run() {
            return ((SafeCluster)this.get_Module()).ensureRunningCluster();
        }
    }

    public static class EnsureSafeServiceAction
    extends Util
    implements PrivilegedAction {
        private String __m_ServiceName;
        private String __m_ServiceType;

        public EnsureSafeServiceAction() {
            this(null, null, true);
        }

        public EnsureSafeServiceAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EnsureSafeServiceAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeCluster$EnsureSafeServiceAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public String getServiceName() {
            return this.__m_ServiceName;
        }

        public String getServiceType() {
            return this.__m_ServiceType;
        }

        public Object run() {
            return ((SafeCluster)this.get_Module()).ensureSafeService(this.getServiceName(), this.getServiceType());
        }

        public void setServiceName(String sName) {
            this.__m_ServiceName = sName;
        }

        public void setServiceType(String sType) {
            this.__m_ServiceType = sType;
        }
    }

    public static class ParseDependenciesAction
    extends Util
    implements PrivilegedAction {
        private XmlElement __m_XmlConfig;

        public ParseDependenciesAction() {
            this(null, null, true);
        }

        public ParseDependenciesAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ParseDependenciesAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeCluster$ParseDependenciesAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public XmlElement getXmlConfig() {
            return this.__m_XmlConfig;
        }

        public Object run() {
            return new LegacyXmlClusterDependencies().fromXml(this.getXmlConfig());
        }

        public void setXmlConfig(XmlElement xmlConfig) {
            this.__m_XmlConfig = xmlConfig;
        }
    }

    public static class ShutdownHook
    extends com.tangosol.coherence.component.util.ShutdownHook {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("UnregisterAction", UnregisterAction.get_CLASS());
        }

        public ShutdownHook() {
            this(null, null, true);
        }

        public ShutdownHook(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ShutdownHook();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeCluster$ShutdownHook".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public void run() {
            WeakReference refSafe;
            SafeCluster clusterSafe;
            if (this.getThread() != null && (clusterSafe = (SafeCluster)(refSafe = (WeakReference)this.get_Feed()).get()) != null) {
                clusterSafe.shutdownLocalServices();
            }
        }

        static {
            ShutdownHook.__initStatic();
        }

        public static class UnregisterAction
        extends ShutdownHook.UnregisterAction {
            public UnregisterAction() {
                this(null, null, true);
            }

            public UnregisterAction(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new UnregisterAction();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/SafeCluster$ShutdownHook$UnregisterAction".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class Unlockable
    extends Util
    implements Lockable.Unlockable {
        public Unlockable() {
            this(null, null, true);
        }

        public Unlockable(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Unlockable();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/SafeCluster$Unlockable".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void close() {
            ((SafeCluster)this.get_Module()).unlock();
        }
    }
}

