/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Lockable;
import com.oracle.coherence.common.base.Timeout;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.SafeNamedCache;
import com.tangosol.coherence.component.util.safeService.SafeCacheService;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.WrapperException;
import com.tangosol.util.function.Remote;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class SafeAsyncNamedCache
extends Util
implements Lockable,
ClassLoaderAware,
AsyncNamedCache {
    private transient String __m_CacheName;
    private transient ClassLoader __m_ClassLoader;
    private AsyncNamedCache __m_InternalNamedCache;
    private ReentrantLock __m_Lock;
    private AsyncNamedMap.Option[] __m_Options;
    private SafeCacheService __m_SafeCacheService;
    private SafeNamedCache __m_SafeNamedCache;
    private boolean __m_Started;

    public SafeAsyncNamedCache() {
        this(null, null, true);
    }

    public SafeAsyncNamedCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setLock(new ReentrantLock());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new SafeAsyncNamedCache();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/SafeAsyncNamedCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    public CompletableFuture aggregate(Filter Param_1, InvocableMap.EntryAggregator Param_2) {
        return this.getRunningNamedCache().aggregate(Param_1, Param_2);
    }

    @Override
    public CompletableFuture aggregate(InvocableMap.EntryAggregator aggregator) {
        return this.getRunningNamedCache().aggregate(aggregator);
    }

    @Override
    public CompletableFuture aggregate(Collection Param_1, InvocableMap.EntryAggregator Param_2) {
        return this.getRunningNamedCache().aggregate(Param_1, Param_2);
    }

    @Override
    public CompletableFuture clear() {
        return this.getRunningNamedCache().clear();
    }

    @Override
    public CompletableFuture compute(Object key, Remote.BiFunction remappingFunction) {
        return this.getRunningNamedCache().compute(key, remappingFunction);
    }

    @Override
    public CompletableFuture computeIfAbsent(Object key, Remote.Function mappingFunction) {
        return this.getRunningNamedCache().computeIfAbsent(key, mappingFunction);
    }

    @Override
    public CompletableFuture computeIfPresent(Object key, Remote.BiFunction remappingFunction) {
        return this.getRunningNamedCache().computeIfPresent(key, remappingFunction);
    }

    @Override
    public CompletableFuture containsKey(Object key) {
        return this.getRunningNamedCache().containsKey(key);
    }

    @Override
    public CompletableFuture entrySet() {
        return this.getRunningNamedCache().entrySet();
    }

    @Override
    public CompletableFuture entrySet(Filter filter) {
        return this.getRunningNamedCache().entrySet(filter);
    }

    @Override
    public CompletableFuture entrySet(Filter filter, Comparator comparator) {
        return this.getRunningNamedCache().entrySet(filter, comparator);
    }

    @Override
    public CompletableFuture entrySet(Filter filter, BiConsumer callback) {
        return this.getRunningNamedCache().entrySet(filter, callback);
    }

    @Override
    public CompletableFuture entrySet(Filter filter, Consumer callback) {
        return this.getRunningNamedCache().entrySet(filter, callback);
    }

    @Override
    public CompletableFuture entrySet(BiConsumer callback) {
        return this.getRunningNamedCache().entrySet(callback);
    }

    @Override
    public CompletableFuture entrySet(Consumer callback) {
        return this.getRunningNamedCache().entrySet(callback);
    }

    @Override
    public CompletableFuture get(Object key) {
        return this.getRunningNamedCache().get(key);
    }

    @Override
    public CompletableFuture getAll(Filter filter) {
        return this.getRunningNamedCache().getAll(filter);
    }

    @Override
    public CompletableFuture getAll(Collection colKeys) {
        return this.getRunningNamedCache().getAll(colKeys);
    }

    @Override
    public CompletableFuture getAll(Collection colKeys, BiConsumer callback) {
        return this.getRunningNamedCache().getAll(colKeys, callback);
    }

    @Override
    public CompletableFuture getAll(Collection colKeys, Consumer callback) {
        return this.getRunningNamedCache().getAll(colKeys, callback);
    }

    @Override
    public CompletableFuture getOrDefault(Object key, Object valueDefault) {
        return this.getRunningNamedCache().getOrDefault(key, valueDefault);
    }

    @Override
    public CompletableFuture invoke(Object Param_1, InvocableMap.EntryProcessor Param_2) {
        return this.getRunningNamedCache().invoke(Param_1, Param_2);
    }

    @Override
    public CompletableFuture invokeAll(Filter Param_1, InvocableMap.EntryProcessor Param_2) {
        return this.getRunningNamedCache().invokeAll(Param_1, Param_2);
    }

    @Override
    public CompletableFuture invokeAll(Filter filter, InvocableMap.EntryProcessor processor, BiConsumer callback) {
        return this.getRunningNamedCache().invokeAll(filter, processor, callback);
    }

    @Override
    public CompletableFuture invokeAll(Filter Param_1, InvocableMap.EntryProcessor Param_2, Consumer Param_3) {
        return this.getRunningNamedCache().invokeAll(Param_1, Param_2, Param_3);
    }

    @Override
    public CompletableFuture invokeAll(InvocableMap.EntryProcessor processor) {
        return this.getRunningNamedCache().invokeAll(processor);
    }

    @Override
    public CompletableFuture invokeAll(InvocableMap.EntryProcessor processor, BiConsumer callback) {
        return this.getRunningNamedCache().invokeAll(processor, callback);
    }

    @Override
    public CompletableFuture invokeAll(InvocableMap.EntryProcessor processor, Consumer callback) {
        return this.getRunningNamedCache().invokeAll(processor, callback);
    }

    @Override
    public CompletableFuture invokeAll(Collection Param_1, InvocableMap.EntryProcessor Param_2) {
        return this.getRunningNamedCache().invokeAll(Param_1, Param_2);
    }

    @Override
    public CompletableFuture invokeAll(Collection collKeys, InvocableMap.EntryProcessor processor, BiConsumer callback) {
        return this.getRunningNamedCache().invokeAll(collKeys, processor, callback);
    }

    @Override
    public CompletableFuture invokeAll(Collection Param_1, InvocableMap.EntryProcessor Param_2, Consumer Param_3) {
        return this.getRunningNamedCache().invokeAll(Param_1, Param_2, Param_3);
    }

    @Override
    public CompletableFuture isEmpty() {
        return this.getRunningNamedCache().isEmpty();
    }

    @Override
    public CompletableFuture keySet() {
        return this.getRunningNamedCache().keySet();
    }

    @Override
    public CompletableFuture keySet(Filter filter) {
        return this.getRunningNamedCache().keySet(filter);
    }

    @Override
    public CompletableFuture keySet(Filter filter, Consumer callback) {
        return this.getRunningNamedCache().keySet(filter, callback);
    }

    @Override
    public CompletableFuture keySet(Consumer callback) {
        return this.getRunningNamedCache().keySet(callback);
    }

    @Override
    public CompletableFuture merge(Object key, Object value, Remote.BiFunction remappingFunction) {
        return this.getRunningNamedCache().merge(key, value, remappingFunction);
    }

    @Override
    public CompletableFuture put(Object key, Object value) {
        return this.getRunningNamedCache().put(key, value);
    }

    public CompletableFuture put(Object key, Object value, long cMillis) {
        return this.getRunningNamedCache().put(key, value, cMillis);
    }

    @Override
    public CompletableFuture putAll(Map map) {
        return this.getRunningNamedCache().putAll(map);
    }

    public CompletableFuture putAll(Map map, long cMillis) {
        return this.getRunningNamedCache().putAll(map, cMillis);
    }

    @Override
    public CompletableFuture putIfAbsent(Object key, Object value) {
        return this.getRunningNamedCache().putIfAbsent(key, value);
    }

    @Override
    public CompletableFuture remove(Object key) {
        return this.getRunningNamedCache().remove(key);
    }

    @Override
    public CompletableFuture remove(Object key, Object value) {
        return this.getRunningNamedCache().remove(key, value);
    }

    @Override
    public CompletableFuture removeAll(Filter filter) {
        return this.getRunningNamedCache().removeAll(filter);
    }

    @Override
    public CompletableFuture removeAll(Collection colKeys) {
        return this.getRunningNamedCache().removeAll(colKeys);
    }

    @Override
    public CompletableFuture replace(Object key, Object value) {
        return this.getRunningNamedCache().replace(key, value);
    }

    @Override
    public CompletableFuture replace(Object key, Object oldValue, Object newValue) {
        return this.getRunningNamedCache().replace(key, oldValue, newValue);
    }

    @Override
    public CompletableFuture replaceAll(Filter filter, Remote.BiFunction function) {
        return this.getRunningNamedCache().replaceAll(filter, function);
    }

    @Override
    public CompletableFuture replaceAll(Remote.BiFunction function) {
        return this.getRunningNamedCache().replaceAll(function);
    }

    @Override
    public CompletableFuture replaceAll(Collection collKeys, Remote.BiFunction function) {
        return this.getRunningNamedCache().replaceAll(collKeys, function);
    }

    @Override
    public CompletableFuture size() {
        return this.getRunningNamedCache().size();
    }

    @Override
    public CompletableFuture values() {
        return this.getRunningNamedCache().values();
    }

    @Override
    public CompletableFuture values(Filter filter) {
        return this.getRunningNamedCache().values(filter);
    }

    @Override
    public CompletableFuture values(Filter filter, Comparator comparator) {
        return this.getRunningNamedCache().values(filter, comparator);
    }

    @Override
    public CompletableFuture values(Filter filter, Consumer callback) {
        return this.getRunningNamedCache().values(filter, callback);
    }

    @Override
    public CompletableFuture values(Consumer callback) {
        return this.getRunningNamedCache().values(callback);
    }

    public void ensureGlobalLock() {
        SafeCacheService service = this.getSafeCacheService();
        service.ensureGlobalLock();
        try {
            this.ensureLocked();
        }
        catch (RuntimeException e) {
            service.unlockGlobal();
            throw e;
        }
    }

    public void ensureLocked() {
        ServiceDependencies deps = this.getSafeCacheService().getDependencies();
        long cRequestTimeout = deps == null ? 0L : deps.getRequestTimeoutMillis();
        long cTimeout = Timeout.isSet() ? Timeout.remainingTimeoutMillis() : cRequestTimeout;
        ReentrantLock lock = this.getLock();
        try {
            if (lock.tryLock(cTimeout <= 0L ? Long.MAX_VALUE : cTimeout, TimeUnit.MILLISECONDS)) {
                return;
            }
            throw Base.ensureRuntimeException(new RequestTimeoutException("Failed to acquire AsyncNamedCache lock in " + cTimeout + "ms"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e, "Interrupted while attempting to acquire NamedCache lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncNamedCache ensureRunningNamedCache() {
        AsyncNamedMap asyncCache = this.getInternalNamedCache();
        NamedCache cache = asyncCache.getNamedCache();
        SafeCacheService serviceSafe = this.getSafeCacheService();
        if (!(serviceSafe != null && serviceSafe.isRunning() && cache != null && cache.isActive() && this.isStarted())) {
            if ((serviceSafe == null || !serviceSafe.isRunning()) && serviceSafe.isServiceThread()) {
                throw new IllegalStateException("Service can not be restarted on a thread owned by the service");
            }
            this.ensureGlobalLock();
            try {
                asyncCache = this.getInternalNamedCache();
                cache = asyncCache.getNamedCache();
                serviceSafe = this.getSafeCacheService();
                if (!(serviceSafe != null && serviceSafe.isRunning() && cache != null && cache.isActive() && this.isStarted())) {
                    if (cache.isReleased() || cache.isDestroyed()) {
                        String reason = cache.isDestroyed() ? "destroyed" : "released";
                        throw new IllegalStateException("SafeAsyncNamedCache was explicitly " + reason);
                    }
                    if (cache != null) {
                        this.setInternalNamedCache(null);
                        SafeAsyncNamedCache._trace("Restarting AsyncNamedCache: " + this.getCacheName(), 3);
                    }
                    SafeNamedCache cacheSafe = this.getSafeNamedCache();
                    asyncCache = cacheSafe.ensureRunningNamedCache().async(this.getOptions());
                    this.setInternalNamedCache((AsyncNamedCache)asyncCache);
                    this.setStarted(true);
                }
            }
            finally {
                this.unlockGlobal();
            }
        }
        return asyncCache;
    }

    public AsyncNamedCache getAsyncNamedCache() {
        return this.getInternalNamedCache();
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return null;
    }

    public AsyncNamedCache getInternalNamedCache() {
        return this.__m_InternalNamedCache;
    }

    public ReentrantLock getLock() {
        return this.__m_Lock;
    }

    public NamedCache getNamedCache() {
        return this.getSafeNamedCache();
    }

    @Override
    public NamedMap getNamedMap() {
        return this.getSafeNamedCache();
    }

    public AsyncNamedMap.Option[] getOptions() {
        return this.__m_Options;
    }

    public AsyncNamedMap.Option getOptions(int i) {
        return this.getOptions()[i];
    }

    public AsyncNamedCache getRunningNamedCache() {
        return this.ensureRunningNamedCache();
    }

    public SafeCacheService getSafeCacheService() {
        return this.__m_SafeCacheService;
    }

    public SafeNamedCache getSafeNamedCache() {
        return this.__m_SafeNamedCache;
    }

    public boolean isStarted() {
        return this.__m_Started;
    }

    public void setCacheName(String sName) {
        this.__m_CacheName = sName;
    }

    public void setClassLoader(ClassLoader loaderClass) {
        this.__m_ClassLoader = loaderClass;
    }

    @Override
    public void setContextClassLoader(ClassLoader Param_1) {
    }

    public void setInternalNamedCache(AsyncNamedCache cache) {
        if (cache == null) {
            this.setStarted(false);
        }
        this.__m_InternalNamedCache = cache;
    }

    public void setLock(ReentrantLock lock) {
        this.__m_Lock = lock;
    }

    public void setOptions(AsyncNamedMap.Option[] sProperty) {
        this.__m_Options = sProperty;
    }

    public void setOptions(int i, AsyncNamedMap.Option optionOptions) {
        this.getOptions()[i] = optionOptions;
    }

    public void setSafeCacheService(SafeCacheService serviceCache) {
        this.__m_SafeCacheService = serviceCache;
    }

    public void setSafeNamedCache(SafeNamedCache cacheNamed) {
        this.__m_SafeNamedCache = cacheNamed;
    }

    public void setStarted(boolean fStarted) {
        this.__m_Started = fStarted;
    }

    public void unlock() {
        this.getLock().unlock();
    }

    public void unlockGlobal() {
        this.unlock();
        this.getSafeCacheService().unlockGlobal();
    }
}

