/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Notifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class Queue
extends Util
implements Notifier {
    private volatile RecyclingLinkedList __m_ElementList;
    private volatile transient boolean __m_Signaled;
    private static ListMap __mapChildren;
    protected final ReentrantLock f_lock = new ReentrantLock();
    protected final Condition f_notEmpty = this.f_lock.newCondition();

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Iterator", Iterator.get_CLASS());
    }

    public Queue() {
        this(null, null, true);
    }

    public Queue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setElementList(new RecyclingLinkedList());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new Queue();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/Queue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public boolean add(Object oElement) {
        this.lock();
        try {
            this.getElementList().add(oElement);
            this.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public boolean addHead(Object oElement) {
        this.lock();
        try {
            this.getElementList().add(0, oElement);
            this.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void await() throws InterruptedException {
        this.await(0L);
    }

    @Override
    public void await(long cMillis) throws InterruptedException {
        this.lock();
        try {
            if (!this.isAvailable() && !this.isSignaled()) {
                this.f_notEmpty.await(cMillis, TimeUnit.MILLISECONDS);
            }
            this.setSignaled(false);
        }
        finally {
            this.unlock();
        }
    }

    public void flush() {
    }

    protected RecyclingLinkedList getElementList() {
        return this.__m_ElementList;
    }

    public boolean isAvailable() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        this.lock();
        try {
            boolean bl = this.getElementList().isEmpty();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    protected boolean isSignaled() {
        return this.__m_Signaled;
    }

    public java.util.Iterator iterator() {
        this.lock();
        try {
            Iterator iter = (Iterator)this._newChild("Iterator");
            iter.setList(this.getElementList());
            Iterator iterator = iter;
            return iterator;
        }
        finally {
            this.unlock();
        }
    }

    public Object peekNoWait() {
        this.lock();
        try {
            Object object = this.getElementList().getFirst();
            return object;
        }
        finally {
            this.unlock();
        }
    }

    public Object remove() {
        return this.remove(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long cMillis) {
        this.lock();
        try {
            Object o = this.removeNoWait();
            while (o == null) {
                long cWait = cMillis <= 0L ? 1000L : Math.min(1000L, cMillis);
                try {
                    this.await(cWait);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
                o = this.removeNoWait();
                if (cMillis <= 0L || (cMillis -= cWait) > 0L) continue;
                break;
            }
            Object object = o;
            return object;
        }
        finally {
            this.unlock();
        }
    }

    public Object removeNoWait() {
        this.lock();
        try {
            Object object = this.getElementList().removeFirst();
            return object;
        }
        finally {
            this.unlock();
        }
    }

    protected void setElementList(RecyclingLinkedList list) {
        this.__m_ElementList = list;
    }

    protected void setSignaled(boolean fSignaled) {
        this.__m_Signaled = fSignaled;
    }

    @Override
    public void signal() {
        this.lock();
        try {
            this.setSignaled(true);
            this.f_notEmpty.signalAll();
        }
        finally {
            this.unlock();
        }
    }

    public int size() {
        this.lock();
        try {
            int n = this.getElementList().size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public void lock() {
        this.f_lock.lock();
    }

    public void unlock() {
        this.f_lock.unlock();
    }

    static {
        Queue.__initStatic();
    }

    public static class Iterator
    extends com.tangosol.coherence.component.util.Iterator {
        private List __m_List;
        private int __m_RemoveCount;

        public Iterator() {
            this(null, null, true);
        }

        public Iterator(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Iterator();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/Queue$Iterator".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        protected List getList() {
            return this.__m_List;
        }

        protected int getRemoveCount() {
            return this.__m_RemoveCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void remove() {
            if (!this.isCanRemove()) throw new IllegalStateException();
            this.setCanRemove(false);
            int cRemoved = this.getRemoveCount();
            int iIndex = this.getNextIndex() - 1;
            Object oElement = this.getItem(iIndex);
            int iGuess = iIndex - cRemoved;
            List list = this.getList();
            Queue queue = (Queue)this.get_Parent();
            queue.lock();
            try {
                if (list.get(iGuess) == oElement) {
                    list.remove(iGuess);
                } else if (!list.remove(oElement)) {
                    throw new ConcurrentModificationException();
                }
            }
            finally {
                queue.unlock();
            }
            this.setRemoveCount(cRemoved + 1);
        }

        public void setList(List list) {
            Iterator._assert(list != null);
            Iterator._assert(this.getList() == null);
            this.__m_List = list;
            Queue queue = (Queue)this.get_Parent();
            queue.lock();
            try {
                this.setItem(list.toArray());
            }
            finally {
                queue.unlock();
            }
        }

        protected void setRemoveCount(int pRemoveCount) {
            this.__m_RemoveCount = pRemoveCount;
        }
    }
}

