/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.application.ContainerHelper;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.BackingMapManagerContext;
import com.tangosol.coherence.component.util.CacheEvent;
import com.tangosol.coherence.component.util.ConcurrentMap;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.io.Serializer;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.SimpleResourceRegistry;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.IntPredicate;

public class LocalCache
extends Util
implements CacheService,
ServiceInfo {
    private transient BackingMapContext __m_BackingMapContext;
    private transient BackingMapManager __m_BackingMapManager;
    private transient Map __m_CacheHandlerMap;
    private transient Cluster __m_Cluster;
    private ClassLoader __m_ContextClassLoader;
    private boolean __m_LockingEnforced;
    private long __m_LockWaitMillis;
    private ResourceRegistry __m_ResourceRegistry;
    private transient boolean __m_Running;
    private transient Serializer __m_Serializer;
    private Listeners __m_ServiceListeners;
    private String __m_ServiceName;
    private String __m_ServiceType;
    private String __m_ServiceVersion;
    private Object __m_UserContext;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("BackingMapContext", BackingMapContext.get_CLASS());
        __mapChildren.put("CacheHandler", CacheHandler.get_CLASS());
    }

    public LocalCache() {
        this(null, null, true);
    }

    public LocalCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setCacheHandlerMap(new SafeHashMap());
            this.setLockingEnforced(false);
            this.setLockWaitMillis(0L);
            this.setResourceRegistry(new SimpleResourceRegistry());
            this.setServiceListeners(new Listeners());
            this.setServiceType("LocalCache");
            this.setServiceVersion("2.2");
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new LocalCache();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/LocalCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public void addMemberListener(MemberListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        this.getServiceListeners().add(listener);
    }

    @Override
    public void configure(XmlElement xml) {
        if (xml != null) {
            this.setLockingEnforced(xml.getSafeElement("lock-enforce").getBoolean());
            this.setLockWaitMillis(xml.getSafeElement("lock-wait").getLong());
        }
    }

    @Override
    public void destroyCache(NamedCache map) {
        CacheHandler handler = (CacheHandler)map;
        this.getCacheHandlerMap().remove(handler.getCacheName());
        handler.invalidate();
    }

    @Override
    public synchronized NamedCache ensureCache(String sName, ClassLoader loader) {
        CacheHandler handler;
        Map mapCache = this.getCacheHandlerMap();
        if (sName == null || sName.length() == 0) {
            sName = "Default";
        }
        if ((handler = (CacheHandler)mapCache.get(sName)) == null) {
            Map map;
            BackingMapManager manager = this.getBackingMapManager();
            Map map2 = map = manager == null ? new SafeHashMap() : manager.instantiateBackingMap(sName);
            if (map == null) {
                throw new RuntimeException("BackingMapManager returned \"null\" for map " + sName);
            }
            handler = (CacheHandler)this._newChild("CacheHandler");
            handler._initFeed(map, this.isLockingEnforced(), this.getLockWaitMillis());
            handler.setCacheName(sName);
            mapCache.put(sName, handler);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackingMapContext getBackingMapContext() {
        BackingMapContext context = this.__m_BackingMapContext;
        if (context == null) {
            LocalCache localCache = this;
            synchronized (localCache) {
                context = this.__m_BackingMapContext;
                if (context == null) {
                    context = (BackingMapContext)this._newChild("BackingMapContext");
                    this.setBackingMapContext(context);
                }
            }
        }
        return context;
    }

    @Override
    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    public Map getCacheHandlerMap() {
        return this.__m_CacheHandlerMap;
    }

    @Override
    public Enumeration getCacheNames() {
        return new IteratorEnumerator(this.getCacheHandlerMap().keySet().iterator());
    }

    @Override
    public Cluster getCluster() {
        return this.__m_Cluster;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.__m_ContextClassLoader;
    }

    @Override
    public ServiceDependencies getDependencies() {
        return null;
    }

    @Override
    public ServiceInfo getInfo() {
        return this;
    }

    public long getLockWaitMillis() {
        return this.__m_LockWaitMillis;
    }

    @Override
    public Member getOldestMember() {
        return null;
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        return this.__m_ResourceRegistry;
    }

    @Override
    public Serializer getSerializer() {
        return this.__m_Serializer;
    }

    public Listeners getServiceListeners() {
        return this.__m_ServiceListeners;
    }

    @Override
    public Member getServiceMember(int nId) {
        return null;
    }

    @Override
    public Set getServiceMembers() {
        return NullImplementation.getSet();
    }

    @Override
    public String getServiceName() {
        return this.__m_ServiceName;
    }

    @Override
    public String getServiceType() {
        return this.__m_ServiceType;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    @Override
    public String getServiceVersion(Member member) {
        return this.getServiceVersion();
    }

    @Override
    public Object getUserContext() {
        return this.__m_UserContext;
    }

    public boolean isLockingEnforced() {
        return this.__m_LockingEnforced;
    }

    @Override
    public boolean isRunning() {
        return this.__m_Running;
    }

    @Override
    public boolean isSuspended() {
        return false;
    }

    @Override
    public void releaseCache(NamedCache map) {
        this.destroyCache(map);
    }

    @Override
    public void removeMemberListener(MemberListener listener) {
    }

    @Override
    public void removeServiceListener(ServiceListener listener) {
        this.getServiceListeners().remove(listener);
    }

    protected void setBackingMapContext(BackingMapContext ctx) {
        this.__m_BackingMapContext = ctx;
    }

    @Override
    public void setBackingMapManager(BackingMapManager manager) {
        if (this.isRunning()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_BackingMapManager = manager;
    }

    protected void setCacheHandlerMap(Map map) {
        this.__m_CacheHandlerMap = map;
    }

    public void setCluster(Cluster cluster) {
        this.__m_Cluster = cluster;
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
    }

    @Override
    public void setDependencies(ServiceDependencies Param_1) {
    }

    public void setLockingEnforced(boolean fEnforced) {
        this.__m_LockingEnforced = fEnforced;
    }

    public void setLockWaitMillis(long cWaitMillis) {
        this.__m_LockWaitMillis = cWaitMillis;
    }

    protected void setResourceRegistry(ResourceRegistry registry) {
        this.__m_ResourceRegistry = registry;
    }

    protected void setRunning(boolean fRunning) {
        this.__m_Running = fRunning;
    }

    protected void setSerializer(Serializer serializer) {
        this.__m_Serializer = serializer;
    }

    protected void setServiceListeners(Listeners listeners) {
        this.__m_ServiceListeners = listeners;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    protected void setServiceType(String sType) {
        this.__m_ServiceType = sType;
    }

    protected void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    @Override
    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
    }

    @Override
    public void shutdown() {
        this.stop();
    }

    @Override
    public synchronized void start() {
        this.setRunning(true);
        BackingMapManager manager = this.getBackingMapManager();
        if (manager != null) {
            BackingMapContext ctx = this.getBackingMapContext();
            ctx.setManager(manager);
            manager.init(ctx);
        }
        this.setSerializer(ExternalizableHelper.ensureSerializer(this.getContextClassLoader()));
    }

    @Override
    public synchronized void stop() {
        if (this.isRunning()) {
            Map mapHandler = this.getCacheHandlerMap();
            Iterator iter = mapHandler.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                CacheHandler handler = (CacheHandler)entry.getValue();
                handler.invalidate();
                iter.remove();
            }
            ServiceEvent event = new ServiceEvent(this, 4);
            event.dispatch(this.getServiceListeners());
            this.setRunning(false);
        }
    }

    @Override
    public boolean isVersionCompatible(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        int nEncoded = ServiceMemberSet.encodeVersion(nMajor, nMinor, nMicro, nPatchSet, nPatch);
        return CacheFactory.VERSION_ENCODED >= nEncoded;
    }

    @Override
    public boolean isVersionCompatible(int nYear, int nMonth, int nPatch) {
        int nEncoded = ServiceMemberSet.encodeVersion(nYear, nMonth, nPatch);
        return CacheFactory.VERSION_ENCODED >= nEncoded;
    }

    @Override
    public boolean isVersionCompatible(int nVersion) {
        return CacheFactory.VERSION_ENCODED >= nVersion;
    }

    @Override
    public boolean isVersionCompatible(IntPredicate predicate) {
        return predicate.test(CacheFactory.VERSION_ENCODED);
    }

    @Override
    public int getMinimumServiceVersion() {
        return CacheFactory.VERSION_ENCODED;
    }

    @Override
    public String toString() {
        return this.get_Name() + "{" + this.getServiceName() + "}";
    }

    static {
        LocalCache.__initStatic();
    }

    public static class BackingMapContext
    extends BackingMapManagerContext {
        public BackingMapContext() {
            this(null, null, true);
        }

        public BackingMapContext(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackingMapContext();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/LocalCache$BackingMapContext".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Map getBackingMap(String sCacheName) {
            CacheHandler handler = (CacheHandler)((LocalCache)this.get_Module()).getCacheHandlerMap().get(sCacheName);
            return handler == null ? null : handler.getActualMap();
        }

        @Override
        public String toString() {
            return super.toString() + "@" + this.hashCode();
        }
    }

    public static class CacheHandler
    extends ConcurrentMap
    implements NamedCache,
    MapListener {
        private String __m_CacheName;
        private Listeners __m_DeactivationListeners;
        private Map __m_IndexMap;
        private transient MapListenerSupport __m_ListenerSupport;

        public CacheHandler() {
            this(null, null, true);
        }

        public CacheHandler(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDeactivationListeners(new Listeners());
                this.setListenerSupport(new MapListenerSupport());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new CacheHandler();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/LocalCache$CacheHandler".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
            InvocableMapHelper.addIndex(extractor, fOrdered, comparator, this, this.ensureIndexMap());
        }

        @Override
        public void addMapListener(MapListener listener) {
            this.addMapListener(listener, (Filter)null, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
            if (listener instanceof NamedCacheDeactivationListener) {
                this.getDeactivationListeners().add(listener);
            } else if (listener == this) {
                super.addMapListener((MapListener)this, filter, fLite);
            } else if (listener != null) {
                boolean fWasLite;
                boolean fWasEmpty;
                MapListenerSupport support;
                MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
                synchronized (mapListenerSupport) {
                    fWasEmpty = support.isEmpty(filter);
                    fWasLite = fWasEmpty || !support.containsStandardListeners(filter);
                    support.addListener(this.wrap(listener), filter, fLite);
                }
                if (fWasEmpty || fWasLite && !fLite) {
                    try {
                        this.addMapListener((MapListener)this, filter, fLite);
                    }
                    catch (RuntimeException e) {
                        support.removeListener(listener, filter);
                        throw e;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
            if (listener == this) {
                super.addMapListener((MapListener)this, oKey, fLite);
            } else if (listener != null) {
                boolean fWasLite;
                boolean fWasEmpty;
                MapListenerSupport support;
                MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
                synchronized (mapListenerSupport) {
                    fWasEmpty = support.isEmpty(oKey);
                    fWasLite = fWasEmpty || !support.containsStandardListeners(oKey);
                    support.addListener(this.wrap(listener), oKey, fLite);
                }
                if (fWasEmpty || fWasLite && !fLite) {
                    try {
                        this.addMapListener((MapListener)this, oKey, fLite);
                    }
                    catch (RuntimeException e) {
                        support.removeListener(listener, oKey);
                        throw e;
                    }
                }
            }
        }

        @Override
        public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
            return this.aggregate((Collection)this.keySet(filter), agent);
        }

        @Override
        public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
            return agent.aggregate(InvocableMapHelper.makeEntrySet(this.getActualMap(), collKeys, true));
        }

        @Override
        public AsyncNamedCache async(AsyncNamedMap.Option ... options) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void destroy() {
            this.getCacheService().destroyCache(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map ensureIndexMap() {
            SafeHashMap mapIndex = this.getIndexMap();
            if (mapIndex == null) {
                CacheHandler cacheHandler = this;
                synchronized (cacheHandler) {
                    mapIndex = this.getIndexMap();
                    if (mapIndex == null) {
                        mapIndex = new SafeHashMap();
                        this.setIndexMap(mapIndex);
                    }
                }
            }
            return mapIndex;
        }

        public void entryDeleted(MapEvent evt) {
            this.translateMapEvent(evt);
        }

        public void entryInserted(MapEvent evt) {
            this.translateMapEvent(evt);
        }

        @Override
        public Set entrySet(Filter filter) {
            return InvocableMapHelper.query(this, this.getIndexMap(), filter, true, false, null);
        }

        @Override
        public Set entrySet(Filter filter, Comparator comparator) {
            return InvocableMapHelper.query(this, this.getIndexMap(), filter, true, true, comparator);
        }

        public void entryUpdated(MapEvent evt) {
            this.translateMapEvent(evt);
        }

        @Override
        public Map getAll(Collection colKeys) {
            Map map = this.getActualMap();
            if (map instanceof CacheMap) {
                return ((CacheMap)map).getAll(colKeys);
            }
            HashMap mapResult = new HashMap(colKeys.size());
            for (Object oKey : colKeys) {
                Object oVal = this.get(oKey);
                if (oVal == null && !this.containsKey(oKey)) continue;
                mapResult.put(oKey, oVal);
            }
            return mapResult;
        }

        @Override
        public String getCacheName() {
            return this.__m_CacheName;
        }

        @Override
        public CacheService getCacheService() {
            return (LocalCache)this.get_Module();
        }

        public Listeners getDeactivationListeners() {
            return this.__m_DeactivationListeners;
        }

        public Map getIndexMap() {
            return this.__m_IndexMap;
        }

        public MapListenerSupport getListenerSupport() {
            return this.__m_ListenerSupport;
        }

        public void invalidate() {
            Listeners listeners;
            BackingMapManager manager;
            MapListenerSupport support = this.getListenerSupport();
            if (!support.isEmpty()) {
                for (int i = 0; i < 3; ++i) {
                    try {
                        Iterator iter = support.getFilterSet().iterator();
                        while (iter.hasNext()) {
                            this.removeMapListener((MapListener)this, (Filter)iter.next());
                        }
                        iter = support.getKeySet().iterator();
                        while (iter.hasNext()) {
                            this.removeMapListener((MapListener)this, iter.next());
                        }
                        break;
                    }
                    catch (ConcurrentModificationException iter) {
                        continue;
                    }
                }
                support.clear();
            }
            if ((manager = this.getCacheService().getBackingMapManager()) != null) {
                manager.releaseBackingMap(this.getCacheName(), this.getActualMap());
            }
            if (!(listeners = this.getDeactivationListeners()).isEmpty()) {
                com.tangosol.net.cache.CacheEvent<Object, Object> evt = new com.tangosol.net.cache.CacheEvent<Object, Object>(this, 3, null, null, null, true);
                CacheEvent.dispatchSafe(evt, listeners, null);
            }
        }

        @Override
        public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
            return InvocableMapHelper.invokeLocked(this, InvocableMapHelper.makeEntry(this.getActualMap(), oKey), agent);
        }

        @Override
        public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
            return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.duplicateEntrySet(this.getActualMap(), this.entrySet(filter), false), agent);
        }

        @Override
        public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
            return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.makeEntrySet(this.getActualMap(), collKeys, false), agent);
        }

        @Override
        public boolean isActive() {
            return ((LocalCache)this.get_Module()).getCacheHandlerMap().get(this.getCacheName()) == this;
        }

        @Override
        public boolean isDestroyed() {
            return !this.isActive();
        }

        @Override
        public boolean isReleased() {
            return !this.isActive();
        }

        @Override
        public Set keySet(Filter filter) {
            return InvocableMapHelper.query(this, this.getIndexMap(), filter, false, false, null);
        }

        @Override
        public Object put(Object oKey, Object oValue, long cMillis) {
            Map map = this.getActualMap();
            if (map instanceof CacheMap) {
                return ((CacheMap)map).put(oKey, oValue, cMillis);
            }
            if (cMillis <= 0L) {
                return this.put(oKey, oValue);
            }
            throw new UnsupportedOperationException("Class \"" + map.getClass().getName() + "\" does not implement CacheMap interface");
        }

        @Override
        public void release() {
            this.getCacheService().releaseCache(this);
        }

        @Override
        public void removeIndex(ValueExtractor extractor) {
            InvocableMapHelper.removeIndex(extractor, this, this.ensureIndexMap());
        }

        @Override
        public void removeMapListener(MapListener listener) {
            this.removeMapListener(listener, (Filter)null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeMapListener(MapListener listener, Filter filter) {
            if (listener instanceof NamedCacheDeactivationListener) {
                this.getDeactivationListeners().remove(listener);
            } else if (listener == this) {
                super.removeMapListener((MapListener)this, filter);
            } else {
                boolean fEmpty;
                MapListenerSupport support;
                MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
                synchronized (mapListenerSupport) {
                    support.removeListener(this.wrap(listener), filter);
                    fEmpty = support.isEmpty(filter);
                }
                if (fEmpty) {
                    this.removeMapListener((MapListener)this, filter);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeMapListener(MapListener listener, Object oKey) {
            if (listener == this) {
                super.removeMapListener((MapListener)this, oKey);
            } else {
                boolean fEmpty;
                MapListenerSupport support;
                MapListenerSupport mapListenerSupport = support = this.getListenerSupport();
                synchronized (mapListenerSupport) {
                    support.removeListener(this.wrap(listener), oKey);
                    fEmpty = support.isEmpty(oKey);
                }
                if (fEmpty) {
                    this.removeMapListener((MapListener)this, oKey);
                }
            }
        }

        public void setCacheName(String sName) {
            this.__m_CacheName = sName;
        }

        protected void setDeactivationListeners(Listeners listeners) {
            this.__m_DeactivationListeners = listeners;
        }

        protected void setIndexMap(Map support) {
            this.__m_IndexMap = support;
        }

        protected void setListenerSupport(MapListenerSupport support) {
            this.__m_ListenerSupport = support;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.get_Name()).append("{Name=").append(this.getCacheName()).append(", ServiceName=").append(this.getCacheService().getInfo().getServiceName()).append('}');
            return sb.toString();
        }

        protected void translateMapEvent(MapEvent evt) {
            evt = MapListenerSupport.convertEvent(evt, this, null, null);
            this.getListenerSupport().fireEvent(evt, true);
        }

        protected MapListener wrap(MapListener listener) {
            return ContainerHelper.getContextAwareListener(this.getCacheService(), listener);
        }
    }
}

