/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import java.io.File;
import java.io.IOException;

public abstract class FileHelper
extends Util {
    public FileHelper(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/FileHelper".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public static String getRelativePath(String sPath, String sRoot) {
        char SEP = File.separatorChar;
        try {
            String sRootAbs = new File(sRoot).getCanonicalPath();
            String sPathAbs = new File(sPath).getCanonicalPath();
            if (sPathAbs.equals(sRootAbs)) {
                return "./";
            }
            if (sPathAbs.startsWith(sRootAbs + SEP)) {
                return "./" + sPathAbs.substring(sRootAbs.length() + 1).replace(SEP, '/');
            }
            char[] achRoot = sRootAbs.toCharArray();
            char[] achPath = sPathAbs.toCharArray();
            int cMin = Math.min(achRoot.length, achPath.length);
            int ofRoot = -1;
            int ofDiff = cMin;
            for (int of = 0; of < cMin; ++of) {
                char ch = achPath[of];
                if (ch == achRoot[of]) {
                    if (ch != SEP) continue;
                    ofRoot = of;
                    continue;
                }
                ofDiff = of;
                break;
            }
            if (ofRoot > 0) {
                StringBuilder sbPath = new StringBuilder();
                for (int of = achRoot.length - 1; of >= ofRoot; --of) {
                    if (achRoot[of] != SEP) continue;
                    sbPath.append("../");
                }
                sbPath.append(sPathAbs.substring(ofRoot + 1).replace(SEP, '/'));
                FileHelper._assert(new File(new File(sRoot), sbPath.toString()).getCanonicalPath().equals(sPathAbs));
                return sbPath.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sPath.replace('\\', '/');
    }

    public static boolean isFullyAccessible(File file) {
        try {
            file = file.getCanonicalFile();
            if (file.exists()) {
                if (!file.canRead() || !file.canWrite()) {
                    return false;
                }
                File fileTmp = File.createTempFile("tmp", ".tmp", file.getParentFile());
                fileTmp.delete();
                if (!file.renameTo(fileTmp)) {
                    return false;
                }
                if (!fileTmp.renameTo(file)) {
                    throw new IllegalStateException("File: " + String.valueOf(file) + " was temporarily renamed to: " + String.valueOf(fileTmp) + " but could not be renamed back. The operation should be performed manually.");
                }
                return true;
            }
            if (file.createNewFile()) {
                file.delete();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

