/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Associated;
import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.base.Notifier;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.oracle.coherence.common.util.AssociationPile;
import com.oracle.coherence.common.util.ConcurrentAssociationPile;
import com.oracle.coherence.common.util.Timers;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.queue.ConcurrentQueue;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.util.DaemonPoolDependencies;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.internal.util.VirtualThreads;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Gate;
import com.tangosol.util.ListMap;
import com.tangosol.util.ThreadGateLite;
import com.tangosol.util.WrapperException;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DaemonPool
extends Util
implements com.tangosol.internal.util.DaemonPool,
Guardian {
    private int __m_AbandonThreshold;
    private boolean __m_AutoStart;
    public static final int DAEMON_ABANDONED = 2;
    public static final int DAEMON_NONPOOLED = 1;
    public static final int DAEMON_STANDARD = 0;
    private int __m_DaemonCount;
    private int __m_DaemonCountMax;
    private int __m_DaemonCountMin;
    private AtomicInteger __m_DaemonIndex;
    private transient Daemon[] __m_Daemons;
    private DaemonPoolDependencies __m_Dependencies;
    private long __m_HungThreshold;
    private transient Guardian __m_InternalGuardian;
    private volatile transient boolean __m_InTransition;
    private String __m_Name;
    private transient AssociationPile[] __m_Queues;
    private volatile ResizeTask __m_ResizeTask;
    private Set __m_ScheduledTasks;
    private volatile transient boolean __m_Started;
    public final Object STATS_MONITOR = new Object();
    private transient int __m_StatsAbandonedCount;
    private transient long __m_StatsActiveMillis;
    private transient int __m_StatsHungCount;
    private transient long __m_StatsHungDuration;
    private transient String __m_StatsHungTaskId;
    private int __m_StatsLastBacklog;
    private transient long __m_StatsLastResetMillis;
    private transient long __m_StatsLastResizeMillis;
    private long __m_StatsLastTaskAddCount;
    private long __m_StatsLastTaskCount;
    private transient int __m_StatsMaxBacklog;
    private transient AtomicLong __m_StatsTaskAddCount;
    private transient long __m_StatsTaskCount;
    private transient int __m_StatsTimeoutCount;
    private long __m_TaskTimeout;
    private transient ThreadGroup __m_ThreadGroup;
    private int __m_ThreadPriority;
    private transient WorkSlot[] __m_WorkSlot;
    private int __m_WorkSlotCount;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Daemon", Daemon.get_CLASS());
        __mapChildren.put("ResizeTask", ResizeTask.get_CLASS());
        __mapChildren.put("ScheduleTask", ScheduleTask.get_CLASS());
        __mapChildren.put("StartTask", StartTask.get_CLASS());
        __mapChildren.put("StopTask", StopTask.get_CLASS());
        __mapChildren.put("WorkSlot", WorkSlot.get_CLASS());
        __mapChildren.put("WrapperTask", WrapperTask.get_CLASS());
    }

    public DaemonPool() {
        this(null, null, true);
    }

    public DaemonPool(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setAbandonThreshold(8);
            this.setDaemonCountMax(Integer.MAX_VALUE);
            this.setDaemonCountMin(1);
            this.setScheduledTasks(new HashSet());
            this.setStatsTaskAddCount(new AtomicLong());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_DaemonIndex = new AtomicInteger();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public long getRecoveryDelay() {
        return 50L;
    }

    public static Component get_Instance() {
        return new DaemonPool();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/DaemonPool".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public void add(Runnable task) {
        this.add(task, false);
    }

    public void add(Runnable task, boolean fAggressiveTimeout) {
        if (this.isStarted()) {
            WrapperTask taskWrapper = this.instantiateWrapperTask(task, fAggressiveTimeout);
            int iPriority = taskWrapper.getPriority();
            if (iPriority == 2 || iPriority == 1) {
                Daemon daemon = this.instantiateDaemon(1, null);
                daemon.setWrapperTask(taskWrapper);
                daemon.start();
                return;
            }
            Object oAssoc = taskWrapper.getAssociatedKey();
            long cAdded = taskWrapper.isManagementTask() ? this.getStatsTaskAddCount().get() : this.getStatsTaskAddCount().getAndIncrement();
            WorkSlot slot = oAssoc == null ? this.findMinBacklogSlot((int)cAdded) : this.getWorkSlot(Base.mod(oAssoc.hashCode(), this.getWorkSlotCount()));
            slot.add(taskWrapper);
        } else {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkHungTasks() {
        int c;
        this.getBacklog();
        long cHungThreshold = this.getHungThreshold();
        if (cHungThreshold == 0L) {
            return;
        }
        long ldtNow = Base.getSafeTimeMillis();
        WrapperTask taskLongest = null;
        long cLongest = -1L;
        int cHung = 0;
        Daemon[] aDaemon = this.getDaemons();
        int n = c = aDaemon == null ? 0 : aDaemon.length;
        for (int i = 0; i < c; ++i) {
            long ldtStart;
            long cDuration;
            Daemon daemon = aDaemon[i];
            WrapperTask wrapper = daemon.getWrapperTask();
            if (wrapper == null || (cDuration = ldtNow - (ldtStart = wrapper.getStartTime())) <= cHungThreshold) continue;
            if (cDuration > cLongest) {
                cLongest = cDuration;
                taskLongest = wrapper;
            }
            ++cHung;
        }
        Object object = this.STATS_MONITOR;
        synchronized (object) {
            if (cHung == 0) {
                this.setStatsHungCount(0);
                this.setStatsHungDuration(0L);
                this.setStatsHungTaskId("");
            } else {
                this.setStatsHungCount(cHung);
                this.setStatsHungDuration(cLongest);
                this.setStatsHungTaskId(taskLongest.getTaskId());
            }
        }
    }

    protected DefaultDaemonPoolDependencies cloneDependencies(DaemonPoolDependencies deps) {
        return new DefaultDaemonPoolDependencies(deps);
    }

    @Override
    public void configure(XmlElement xml) {
        throw new UnsupportedOperationException();
    }

    public static Object[] copyOnAdd(Object[] ao, Object oAdd) {
        int c = ao.length;
        Object[] aoNew = (Object[])Array.newInstance(ao.getClass().getComponentType(), c + 1);
        System.arraycopy(ao, 0, aoNew, 0, c);
        aoNew[c] = oAdd;
        return aoNew;
    }

    public static Object[] copyOnRemove(Object[] ao, Object oRemove) {
        int c = ao.length;
        for (int i = 0; i < c; ++i) {
            if (ao[i] != oRemove) continue;
            Object[] aoNew = (Object[])Array.newInstance(ao.getClass().getComponentType(), c - 1);
            if (i > 0) {
                System.arraycopy(ao, 0, aoNew, 0, i);
            }
            if (i < c - 1) {
                System.arraycopy(ao, i + 1, aoNew, i, c - 1 - i);
            }
            return aoNew;
        }
        return ao;
    }

    protected WorkSlot findMaxDaemonSharingSlot() {
        int[] acShare = new int[this.getQueues().length];
        Daemon[] aDaemon = this.getDaemons();
        int c = aDaemon.length;
        for (int i = 0; i < c; ++i) {
            int iQ = this.indexOf(aDaemon[i].getQueue());
            DaemonPool._assert(iQ >= 0);
            int n = iQ;
            acShare[n] = acShare[n] + 1;
        }
        int cMax = 1;
        int iSlot = -1;
        int c2 = this.getWorkSlotCount();
        for (int i = 0; i < c2; ++i) {
            WorkSlot slot = this.getWorkSlot(i);
            int iQ = this.indexOf(slot.getQueue());
            DaemonPool._assert(iQ >= 0);
            int cShare = acShare[iQ];
            if (cShare <= cMax) continue;
            cMax = cShare;
            iSlot = i;
        }
        return iSlot == -1 ? null : this.getWorkSlot(iSlot);
    }

    protected WorkSlot findMaxQueueSharingSlot() {
        int[] acShare = new int[this.getQueues().length];
        int cMax = 1;
        int iSlot = -1;
        int c = this.getWorkSlotCount();
        for (int i = 0; i < c; ++i) {
            WorkSlot slot = this.getWorkSlot(i);
            int iQ = this.indexOf(slot.getQueue());
            DaemonPool._assert(iQ >= 0);
            int n = iQ;
            int n2 = acShare[n] + 1;
            acShare[n] = n2;
            int cShare = n2;
            if (cShare <= cMax) continue;
            cMax = cShare;
            iSlot = i;
        }
        return iSlot == -1 ? null : this.getWorkSlot(iSlot);
    }

    protected WorkSlot findMinBacklogSlot(int iSeed) {
        WorkSlot slotMin = null;
        int cSlots = this.getWorkSlotCount();
        int cMinSize = Integer.MAX_VALUE;
        for (int i = 0; i < cSlots; ++i) {
            WorkSlot slot = this.getWorkSlot(Base.mod(iSeed + i, cSlots));
            int cSize = slot.getQueue().size();
            if (cSize == 0) {
                return slot;
            }
            if (cSize >= cMinSize) continue;
            cMinSize = cSize;
            slotMin = slot;
        }
        return slotMin;
    }

    protected AssociationPile findMinDaemonSharingQueue() {
        int iQ;
        AssociationPile[] aQueue = this.getQueues();
        int cQueues = aQueue.length;
        int[] acShare = new int[cQueues];
        Daemon[] aDaemon = this.getDaemons();
        int c = aDaemon.length;
        for (int i = 0; i < c; ++i) {
            iQ = this.indexOf(aDaemon[i].getQueue());
            DaemonPool._assert(iQ >= 0);
            int n = iQ;
            acShare[n] = acShare[n] + 1;
        }
        int cMin = Integer.MAX_VALUE;
        int iQueue = -1;
        for (iQ = 0; iQ < cQueues; ++iQ) {
            if (acShare[iQ] >= cMin) continue;
            cMin = acShare[iQ];
            iQueue = iQ;
        }
        return aQueue[iQueue];
    }

    protected AssociationPile findMinSlotSharingQueue(AssociationPile queueExcept) {
        AssociationPile[] aQueue = this.getQueues();
        int cQueues = aQueue.length;
        int[] acShare = new int[cQueues];
        int c = this.getWorkSlotCount();
        for (int i = 0; i < c; ++i) {
            WorkSlot slot = this.getWorkSlot(i);
            int iQ = this.indexOf(slot.getQueue());
            DaemonPool._assert(iQ >= 0);
            int n = iQ;
            acShare[n] = acShare[n] + 1;
        }
        int cMin = Integer.MAX_VALUE;
        int iQueue = -1;
        for (int iQ = 0; iQ < cQueues; ++iQ) {
            if (acShare[iQ] >= cMin || aQueue[iQ] == queueExcept) continue;
            cMin = acShare[iQ];
            iQueue = iQ;
        }
        return iQueue == -1 ? null : aQueue[iQueue];
    }

    protected WorkSlot findSlot(AssociationPile queue) {
        int c = this.getWorkSlotCount();
        for (int i = 0; i < c; ++i) {
            WorkSlot slot = this.getWorkSlot(i);
            if (slot.getQueue() != queue) continue;
            return slot;
        }
        return null;
    }

    public void flushStats() {
        int c;
        Daemon[] aDaemon = this.getDaemons();
        int n = c = aDaemon == null ? 0 : aDaemon.length;
        for (int i = 0; i < c; ++i) {
            aDaemon[i].setFlushStats(true);
        }
    }

    public int getAbandonThreshold() {
        return this.__m_AbandonThreshold;
    }

    public int getActiveDaemonCount() {
        int c;
        Daemon[] aDaemon = this.getDaemons();
        int cActive = 0;
        int n = c = aDaemon == null ? 0 : aDaemon.length;
        for (int i = 0; i < c; ++i) {
            Daemon daemon = aDaemon[i];
            if (daemon.getWrapperTask() == null) continue;
            ++cActive;
        }
        return cActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBacklog() {
        int c;
        AssociationPile[] aQueue = this.getQueues();
        int cBacklog = 0;
        int n = c = aQueue == null ? 0 : aQueue.length;
        for (int i = 0; i < c; ++i) {
            cBacklog += aQueue[i].size();
        }
        Object object = this.STATS_MONITOR;
        synchronized (object) {
            if (cBacklog > this.getStatsMaxBacklog()) {
                this.setStatsMaxBacklog(cBacklog);
            }
        }
        return cBacklog;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return null;
    }

    public int getDaemonCount() {
        return this.isStarted() ? this.getDaemons().length : this.__m_DaemonCount;
    }

    public int getDaemonCountMax() {
        return this.__m_DaemonCountMax;
    }

    public int getDaemonCountMin() {
        return this.__m_DaemonCountMin;
    }

    protected AtomicInteger getDaemonIndex() {
        return this.__m_DaemonIndex;
    }

    public Daemon[] getDaemons() {
        return this.__m_Daemons;
    }

    @Override
    public float getDefaultGuardRecovery() {
        Guardian guardian = this.getInternalGuardian();
        return guardian == null ? 0.0f : guardian.getDefaultGuardRecovery();
    }

    @Override
    public long getDefaultGuardTimeout() {
        Guardian guardian = this.getInternalGuardian();
        return guardian == null ? 0L : guardian.getDefaultGuardTimeout();
    }

    @Override
    public DaemonPoolDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    @Override
    public Guardian getGuardian() {
        return this;
    }

    public long getHungThreshold() {
        return this.__m_HungThreshold;
    }

    protected Guardian getInternalGuardian() {
        Component parent;
        Guardian guardian = this.__m_InternalGuardian;
        if (guardian == null && (parent = this.get_Parent()) instanceof Guardian) {
            guardian = (Guardian)((Object)parent);
            this.setInternalGuardian(guardian);
        }
        return guardian;
    }

    public String getName() {
        return this.__m_Name;
    }

    public AssociationPile[] getQueues() {
        return this.__m_Queues;
    }

    public ResizeTask getResizeTask() {
        return this.__m_ResizeTask;
    }

    public Set getScheduledTasks() {
        return this.__m_ScheduledTasks;
    }

    public int getStatsAbandonedCount() {
        return this.__m_StatsAbandonedCount;
    }

    public long getStatsActiveMillis() {
        return this.__m_StatsActiveMillis;
    }

    public int getStatsHungCount() {
        return this.__m_StatsHungCount;
    }

    public long getStatsHungDuration() {
        return this.__m_StatsHungDuration;
    }

    public String getStatsHungTaskId() {
        return this.__m_StatsHungTaskId;
    }

    public int getStatsLastBacklog() {
        return this.__m_StatsLastBacklog;
    }

    public long getStatsLastResetMillis() {
        return this.__m_StatsLastResetMillis;
    }

    public long getStatsLastResizeMillis() {
        return this.__m_StatsLastResizeMillis;
    }

    public long getStatsLastTaskAddCount() {
        return this.__m_StatsLastTaskAddCount;
    }

    public long getStatsLastTaskCount() {
        return this.__m_StatsLastTaskCount;
    }

    public int getStatsMaxBacklog() {
        return this.__m_StatsMaxBacklog;
    }

    public AtomicLong getStatsTaskAddCount() {
        return this.__m_StatsTaskAddCount;
    }

    public long getStatsTaskCount() {
        return this.__m_StatsTaskCount;
    }

    public int getStatsTimeoutCount() {
        return this.__m_StatsTimeoutCount;
    }

    public long getTaskTimeout() {
        return this.__m_TaskTimeout;
    }

    public ThreadGroup getThreadGroup() {
        return this.__m_ThreadGroup;
    }

    public int getThreadPriority() {
        return this.__m_ThreadPriority;
    }

    protected WorkSlot[] getWorkSlot() {
        return this.__m_WorkSlot;
    }

    public WorkSlot getWorkSlot(int i) {
        return this.getWorkSlot()[i];
    }

    public int getWorkSlotCount() {
        return this.__m_WorkSlotCount;
    }

    @Override
    public Guardian.GuardContext guard(Guardable guardable) {
        Guardian guardian = this.getInternalGuardian();
        return guardian == null ? null : guardian.guard(guardable);
    }

    @Override
    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        Guardian guardian = this.getInternalGuardian();
        return guardian == null ? null : guardian.guard(guardable, cMillis, flPctRecover);
    }

    protected void halt() {
        if (this.isStarted()) {
            this.setStarted(false);
            Daemon[] aDaemon = this.getDaemons();
            int c = aDaemon.length;
            for (int i = 0; i < c; ++i) {
                aDaemon[i].halt();
            }
        }
    }

    protected int indexOf(AssociationPile queue) {
        AssociationPile[] aQueue = this.getQueues();
        int c = aQueue.length;
        for (int i = 0; i < c; ++i) {
            if (aQueue[i] != queue) continue;
            return i;
        }
        return -1;
    }

    protected Daemon instantiateDaemon(int nType, AssociationPile queue) {
        Daemon daemon = (Daemon)this._newChild("Daemon");
        Object sName = daemon.getThreadName();
        switch (nType) {
            case 1: {
                sName = "Dedicated";
            }
            case 0: {
                int iDaemon = this.getDaemonIndex().getAndIncrement();
                sName = (String)sName + ":";
                sName = (String)sName + (String)(this.isDynamic() ? "0x" + Base.toHexString(iDaemon, Math.max(4, Base.getMaxHexDigits(iDaemon))) + ":" + Base.getUpTimeMillis() / 1000L : String.valueOf(iDaemon));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + nType);
            }
        }
        String sPoolName = this.getName();
        daemon.setThreadName((String)(sPoolName == null ? sName : sPoolName + (String)sName));
        daemon.setDaemonType(nType);
        daemon.setThreadGroup(this.getThreadGroup());
        daemon.setPriority(this.getThreadPriority());
        daemon.setQueue(queue);
        return daemon;
    }

    protected AssociationPile instantiateQueue() {
        return new ConcurrentAssociationPile();
    }

    protected WrapperTask instantiateWrapperTask() {
        WrapperTask task = new WrapperTask();
        this._linkChild(task);
        return task;
    }

    public WrapperTask instantiateWrapperTask(Runnable task, boolean fAggressiveTimeout) {
        long ldtNow = Base.getLastSafeTimeMillis();
        WrapperTask wrapper = this.instantiateWrapperTask();
        wrapper.setTask(task);
        wrapper.setPostTime(ldtNow);
        if (task instanceof PriorityTask) {
            PriorityTask ptask = (PriorityTask)((Object)task);
            int iPriority = ptask.getSchedulingPriority();
            if (iPriority < 0 || iPriority > 2) {
                DaemonPool._trace("Invalid scheduling priority value: " + iPriority + " for " + task.getClass().getName() + "; changing to SCHEDULE_STANDARD", 2);
                iPriority = 0;
            }
            wrapper.setPriority(iPriority);
            long cTimeout = ptask.getExecutionTimeoutMillis();
            if (cTimeout == 0L) {
                cTimeout = this.getTaskTimeout();
            } else if (cTimeout == -1L) {
                cTimeout = 0x7FFFFFFL;
            }
            if (cTimeout > 0L) {
                wrapper.setTimeoutMillis(cTimeout);
                if (fAggressiveTimeout) {
                    wrapper.setStopTime(ldtNow + cTimeout);
                    this.guard(wrapper, cTimeout, 1.0f);
                }
            }
        }
        return wrapper;
    }

    protected boolean isAutoStart() {
        return this.__m_AutoStart;
    }

    public boolean isDynamic() {
        return this.getDaemonCountMin() < this.getDaemonCountMax();
    }

    public boolean isInTransition() {
        return this.__m_InTransition;
    }

    @Override
    public boolean isRunning() {
        return this.isStarted();
    }

    public boolean isStarted() {
        return this.__m_Started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStuck() {
        Object object = this.STATS_MONITOR;
        synchronized (object) {
            int cBacklog = this.getBacklog();
            int cDeltaBacklog = cBacklog - this.getStatsLastBacklog();
            long cAdd = this.getStatsTaskAddCount().get();
            long cDeltaAdd = cAdd - this.getStatsLastTaskAddCount();
            this.setStatsLastBacklog(cBacklog);
            this.setStatsLastTaskAddCount(cAdd);
        }
        return false;
    }

    public boolean join(long cMillis) {
        Daemon[] aDaemon = this.getDaemons();
        if (aDaemon != null) {
            long ldtTimeout = cMillis == 0L ? Long.MAX_VALUE : Base.getSafeTimeMillis() + cMillis;
            int c = aDaemon.length;
            for (int i = 0; i < c; ++i) {
                if (cMillis < 0L || !aDaemon[i].join(cMillis)) {
                    return false;
                }
                cMillis = Base.computeSafeWaitTime(ldtTimeout);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onDaemonStop(Daemon daemon, StopTask taskStop) {
        AssociationPile queue = taskStop.getQueue();
        if (queue != null) {
            AssociationPile queueNext = queue;
            try {
                AssociationPile queueMerge = this.findMinSlotSharingQueue(queue);
                if (queueMerge != null) {
                    Object oTask;
                    while ((oTask = queue.poll()) != null) {
                        queueMerge.add(oTask);
                        queue.release(oTask);
                    }
                    queueNext = queueMerge;
                    DaemonPool._assert(queue.size() == 0);
                    this.setQueues((AssociationPile[])DaemonPool.copyOnRemove(this.getQueues(), queue));
                }
            }
            finally {
                int c = this.getWorkSlotCount();
                for (int i = 0; i < c; ++i) {
                    WorkSlot slot = this.getWorkSlot(i);
                    if (slot.getQueue() != queue) continue;
                    slot.setQueue(queueNext);
                    slot.getGate().open();
                }
            }
        }
        this.setDaemons((Daemon[])DaemonPool.copyOnRemove(this.getDaemons(), daemon));
        taskStop.scheduleNext();
    }

    protected void onDependencies(DaemonPoolDependencies deps) {
        this.setInternalGuardian(deps.getGuardian());
        this.setName(deps.getName());
        this.setDaemonCountMin(deps.getThreadCountMin());
        this.setDaemonCountMax(deps.getThreadCountMax());
        this.setDaemonCount(deps.getThreadCount());
        this.setThreadGroup(deps.getThreadGroup());
        this.setThreadPriority(deps.getThreadPriority());
    }

    @Override
    public void onInit() {
        String sCount = Config.getProperty("coherence.pool.interruptcount");
        if (sCount != null) {
            this.setAbandonThreshold(Integer.parseInt(sCount));
        }
        super.onInit();
        if (this.isAutoStart()) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDaemon(Daemon daemonAbandon) {
        ResizeTask task;
        WrapperTask wrapper = daemonAbandon.getWrapperTask();
        if (wrapper != null && wrapper.getGate() != null && (task = this.getResizeTask()) != null) {
            ResizeTask resizeTask = task;
            synchronized (resizeTask) {
                task = this.getResizeTask();
                if (task != null) {
                    DaemonPool._trace("Stopping the dynamic pool resizing due to an abandoned thread", 2);
                    task.cancel();
                    this.setResizeTask(null);
                }
            }
        }
        DaemonPool daemonPool = this;
        synchronized (daemonPool) {
            for (Daemon daemon : this.getDaemons()) {
                if (daemon != daemonAbandon) continue;
                Daemon daemonNew = this.instantiateDaemon(0, daemon.getQueue());
                daemonNew.start();
                aDaemon[i] = daemonNew;
                return;
            }
        }
        DaemonPool._trace("Failed to replace the abandoned daemon: " + String.valueOf(daemonAbandon), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        Object object = this.STATS_MONITOR;
        synchronized (object) {
            this.setStatsActiveMillis(0L);
            this.setStatsLastBacklog(0);
            this.setStatsLastResizeMillis(0L);
            this.setStatsLastTaskAddCount(0L);
            this.setStatsLastTaskCount(0L);
            this.setStatsMaxBacklog(0);
            this.getStatsTaskAddCount().set(Math.max(0L, this.getStatsTaskAddCount().get() - this.getStatsTaskCount()));
            this.setStatsTaskCount(0L);
            this.setStatsTimeoutCount(0);
            this.setStatsLastResetMillis(Base.getSafeTimeMillis());
        }
    }

    public void runCanceled(PriorityTask task, boolean fAbandoned) {
        try {
            task.runCanceled(fAbandoned);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(Runnable task, long cMillis) {
        if (cMillis > 0L) {
            if (this.isStarted()) {
                Set setScheduled;
                ScheduleTask taskSchedule = (ScheduleTask)this._newChild("ScheduleTask");
                taskSchedule.setDelayMillis(cMillis);
                taskSchedule.setTask(task);
                Set set = setScheduled = this.getScheduledTasks();
                synchronized (set) {
                    if (this.isStarted()) {
                        Timers.scheduleNonBlockingTask(taskSchedule, cMillis, setScheduled);
                    }
                }
            }
        } else {
            this.add(task);
        }
    }

    protected void scheduleDaemonStart(int cStart) {
        DaemonPool._assert(cStart > 0);
        StartTask taskStart = (StartTask)this._newChild("StartTask");
        taskStart.setStartCount(cStart);
        this.add(taskStart, false);
    }

    protected void scheduleDaemonStop(int cStop) {
        DaemonPool._assert(cStop > 0);
        StopTask taskStop = (StopTask)this._newChild("StopTask");
        taskStop.setStopCount(cStop);
        this.add(taskStop, false);
    }

    public void setAbandonThreshold(int cThreads) {
        this.__m_AbandonThreshold = cThreads;
    }

    protected void setAutoStart(boolean fAutoStart) {
        DaemonPool._assert(!this.is_Constructed());
        this.__m_AutoStart = fAutoStart;
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    public synchronized void setDaemonCount(int cThreads) {
        int cOrig = this.getDaemonCount();
        if (cThreads != cOrig) {
            if (cThreads <= 0) {
                throw new IllegalArgumentException("Requested number of threads (" + cThreads + ") is invalid");
            }
            if (this.isStarted()) {
                if (this.isInTransition()) {
                    DaemonPool._trace("DaemonPool \"" + this.getName() + "\" : ignoring a repetitive pool resize request; actual size=" + cOrig + ", target=" + cThreads, 2);
                    return;
                }
                this.setInTransition(true);
                if (cThreads > cOrig) {
                    this.scheduleDaemonStart(cThreads - cOrig);
                } else {
                    this.scheduleDaemonStop(cOrig - cThreads);
                }
            }
            this.__m_DaemonCount = cThreads;
        }
    }

    public void setDaemonCountMax(int cThreads) {
        if (this.is_Constructed() && cThreads < 1) {
            throw new IllegalArgumentException("Maximum daemon count must be greater than 0");
        }
        this.__m_DaemonCountMax = cThreads;
    }

    public void setDaemonCountMin(int cThreads) {
        if (this.is_Constructed() && cThreads < 1) {
            throw new IllegalArgumentException("Minimum daemon count must be greater than 0");
        }
        this.__m_DaemonCountMin = cThreads;
    }

    private void setDaemonIndex(AtomicInteger atomic) {
        this.__m_DaemonIndex = atomic;
    }

    protected void setDaemons(Daemon[] aDaemon) {
        this.__m_Daemons = aDaemon;
    }

    @Override
    public void setDependencies(DaemonPoolDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Dependencies already set");
        }
        if (this.isStarted()) {
            throw new IllegalStateException("DaemonPool has been started");
        }
        this.__m_Dependencies = this.cloneDependencies(deps).validate();
        this.onDependencies(this.getDependencies());
    }

    public void setHungThreshold(long cMillis) {
        this.__m_HungThreshold = cMillis;
    }

    protected synchronized void setInternalGuardian(Guardian guardian) {
        if (this.isStarted()) {
            throw new IllegalStateException("cannot modify the Guardian while the pool is running");
        }
        this.__m_InternalGuardian = guardian;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInTransition(boolean fTransition) {
        if (!fTransition) {
            Object object = this.STATS_MONITOR;
            synchronized (object) {
                this.setStatsLastResizeMillis(Base.getSafeTimeMillis());
            }
        }
        this.__m_InTransition = fTransition;
    }

    public synchronized void setName(String sName) {
        if (this.isStarted()) {
            throw new IllegalStateException("cannot modify the name while the pool is running");
        }
        this.__m_Name = sName;
    }

    protected void setQueues(AssociationPile[] aQueue) {
        this.__m_Queues = aQueue;
    }

    protected void setResizeTask(ResizeTask task) {
        this.__m_ResizeTask = task;
    }

    protected void setScheduledTasks(Set setTasks) {
        this.__m_ScheduledTasks = setTasks;
    }

    protected void setStarted(boolean fStarted) {
        DaemonPool._assert(!fStarted || this.is_Constructed());
        this.__m_Started = fStarted;
    }

    public void setStatsAbandonedCount(int cThreads) {
        this.__m_StatsAbandonedCount = cThreads;
    }

    protected void setStatsActiveMillis(long cMillis) {
        this.__m_StatsActiveMillis = cMillis;
    }

    protected void setStatsHungCount(int cHung) {
        this.__m_StatsHungCount = cHung;
    }

    protected void setStatsHungDuration(long cDuration) {
        this.__m_StatsHungDuration = cDuration;
    }

    protected void setStatsHungTaskId(String sTaskId) {
        this.__m_StatsHungTaskId = sTaskId;
    }

    protected void setStatsLastBacklog(int cTasks) {
        this.__m_StatsLastBacklog = cTasks;
    }

    protected void setStatsLastResetMillis(long ldtReset) {
        this.__m_StatsLastResetMillis = ldtReset;
    }

    protected void setStatsLastResizeMillis(long ldtResize) {
        this.__m_StatsLastResizeMillis = ldtResize;
    }

    protected void setStatsLastTaskAddCount(long cTasks) {
        this.__m_StatsLastTaskAddCount = cTasks;
    }

    protected void setStatsLastTaskCount(long cTasks) {
        this.__m_StatsLastTaskCount = cTasks;
    }

    protected void setStatsMaxBacklog(int cTasks) {
        this.__m_StatsMaxBacklog = cTasks;
    }

    protected void setStatsTaskAddCount(AtomicLong cTasks) {
        this.__m_StatsTaskAddCount = cTasks;
    }

    protected void setStatsTaskCount(long cTasks) {
        this.__m_StatsTaskCount = cTasks;
    }

    public void setStatsTimeoutCount(int cTasks) {
        this.__m_StatsTimeoutCount = cTasks;
    }

    public void setTaskTimeout(long cMillis) {
        this.__m_TaskTimeout = cMillis;
    }

    public synchronized void setThreadGroup(ThreadGroup group) {
        if (this.isStarted()) {
            throw new IllegalStateException("cannot modify the ThreadGroup while the pool is running");
        }
        this.__m_ThreadGroup = group;
    }

    public synchronized void setThreadPriority(int nPriority) {
        if (nPriority < 1 || nPriority > 10) {
            throw new IllegalArgumentException("invalid daemon thread priority: " + nPriority);
        }
        this.__m_ThreadPriority = nPriority;
        if (this.isStarted()) {
            int c;
            Daemon[] daemons = this.getDaemons();
            int n = c = daemons == null ? 0 : daemons.length;
            for (int i = 0; i < c; ++i) {
                daemons[i].getThread().setPriority(nPriority);
            }
        }
    }

    protected void setWorkSlot(WorkSlot[] aSlot) {
        DaemonPool._assert(aSlot != null && this.getWorkSlot() == null, "Must not change");
        this.__m_WorkSlot = aSlot;
    }

    protected void setWorkSlot(int i, WorkSlot slot) {
        DaemonPool._assert(slot != null && this.getWorkSlot(i) == null, "Must not change");
        this.getWorkSlot()[i] = slot;
    }

    protected void setWorkSlotCount(int cSlots) {
        DaemonPool._assert(cSlots > 0 && this.getWorkSlotCount() == 0, "Must not change");
        this.__m_WorkSlotCount = cSlots;
    }

    @Override
    public void shutdown() {
        this.stop();
    }

    @Override
    public synchronized void start() {
        DaemonPool._assert(this.is_Constructed());
        if (!this.isStarted()) {
            int i;
            int cSlots = Runtime.getRuntime().availableProcessors();
            try {
                String sSlots = Config.getProperty("coherence.daemonpool.slots");
                if (sSlots != null) {
                    cSlots = Math.abs(Integer.parseInt(sSlots));
                }
            }
            catch (RuntimeException sSlots) {
                // empty catch block
            }
            this.setWorkSlot(new WorkSlot[cSlots]);
            this.setWorkSlotCount(cSlots);
            for (int i2 = 0; i2 < cSlots; ++i2) {
                WorkSlot slot = (WorkSlot)this._newChild("WorkSlot");
                slot.setIndex(i2);
                this.setWorkSlot(i2, slot);
            }
            int cDaemons = Math.max(this.getDaemonCount(), this.getDaemonCountMin());
            DaemonPool._assert(cDaemons > 0);
            Daemon[] aDaemon = new Daemon[cDaemons];
            int cQueues = Math.min(cDaemons, cSlots);
            AssociationPile[] aQueue = new AssociationPile[cQueues];
            for (i = 0; i < cQueues; ++i) {
                AssociationPile queue = this.instantiateQueue();
                this.getWorkSlot(i).setQueue(queue);
                aQueue[i] = queue;
                aDaemon[i] = this.instantiateDaemon(0, queue);
            }
            if (cSlots >= cDaemons) {
                for (int iSlot = cDaemons; iSlot < cSlots; ++iSlot) {
                    this.getWorkSlot(iSlot).setQueue(this.getWorkSlot(iSlot % cDaemons).getQueue());
                }
            } else {
                for (int iDaemon = cSlots; iDaemon < cDaemons; ++iDaemon) {
                    aDaemon[iDaemon] = this.instantiateDaemon(0, this.getWorkSlot(iDaemon % cSlots).getQueue());
                }
            }
            this.setDaemonCount(cDaemons);
            this.setQueues(aQueue);
            this.setDaemons(aDaemon);
            for (i = 0; i < cSlots; ++i) {
                this.getWorkSlot(i).setActive(true);
            }
            for (i = 0; i < cDaemons; ++i) {
                aDaemon[i].start();
            }
            this.setStarted(true);
            Object[] ao = new Object[]{cDaemons, this.getDaemonCountMax(), this.getDaemonCountMin(), Boolean.valueOf(this.isDynamic()).toString(), cQueues, cSlots};
            DaemonPool._trace(String.format("Started DaemonPool \"" + this.getName() + "\": [DeamonCount=%d, DaemonCountMax=%d, DaemonCountMin=%d, Dynamic=%s QueueSize=%d, WorkSlots=%d]", ao), 4);
            if (this.isDynamic()) {
                ResizeTask task = (ResizeTask)this._newChild("ResizeTask");
                this.setResizeTask(task);
                this.schedule(task, task.getPeriodMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startDaemon(StartTask taskStart) {
        int cSlots = this.getWorkSlotCount();
        Object[] aDaemon = this.getDaemons();
        int cDaemons = aDaemon.length;
        if (cDaemons < cSlots) {
            WorkSlot slotSplit = this.findMaxQueueSharingSlot();
            DaemonPool._assert(slotSplit != null && slotSplit.isActive());
            AssociationPile queueOld = slotSplit.getQueue();
            Gate gate = slotSplit.getGate();
            if (!gate.close(1L)) {
                this.add(taskStart, false);
                return;
            }
            AssociationPile queue = this.instantiateQueue();
            Daemon daemon = this.instantiateDaemon(0, queue);
            this.setQueues((AssociationPile[])DaemonPool.copyOnAdd(this.getQueues(), queue));
            this.setDaemons((Daemon[])DaemonPool.copyOnAdd(aDaemon, daemon));
            try {
                slotSplit.setActive(false);
                slotSplit.setQueue(queue);
            }
            finally {
                gate.open();
            }
            int cStart = taskStart.getStartCount();
            taskStart = (StartTask)this._newChild("StartTask");
            taskStart.setDaemon(daemon);
            taskStart.setWorkSlotActivate(slotSplit);
            taskStart.setStartCount(cStart);
            taskStart.setQueue(queueOld);
            queueOld.add(this.instantiateWrapperTask(taskStart, false));
        } else {
            AssociationPile queue = this.findMinDaemonSharingQueue();
            DaemonPool._assert(queue != null);
            Daemon daemon = this.instantiateDaemon(0, queue);
            this.setDaemons((Daemon[])DaemonPool.copyOnAdd(aDaemon, daemon));
            daemon.start();
            taskStart.scheduleNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.isStarted()) {
            ResizeTask task = this.getResizeTask();
            if (task != null && task.getDaemonPool() != null) {
                task.cancel();
                this.setResizeTask(null);
            }
            DaemonPool daemonPool = this;
            synchronized (daemonPool) {
                if (this.isStarted()) {
                    Set setScheduled;
                    this.setStarted(false);
                    Daemon[] aDaemon = this.getDaemons();
                    int c = aDaemon.length;
                    for (int i = 0; i < c; ++i) {
                        aDaemon[i].stop();
                    }
                    Set set = setScheduled = this.getScheduledTasks();
                    synchronized (set) {
                        Iterator iter = this.getScheduledTasks().iterator();
                        while (iter.hasNext()) {
                            Disposable disposable = (Disposable)iter.next();
                            iter.remove();
                            disposable.dispose();
                        }
                    }
                    this.setInTransition(false);
                }
            }
        }
    }

    public synchronized void stopDaemon(StopTask taskStop) {
        WorkSlot slot;
        int cSlots = this.getWorkSlotCount();
        Daemon[] aDaemon = this.getDaemons();
        int cDaemons = aDaemon.length;
        if (cDaemons > cSlots) {
            slot = this.findMaxDaemonSharingSlot();
            DaemonPool._assert(slot != null);
            taskStop.setWorkSlot(slot);
        } else {
            AssociationPile queue = this.findMinSlotSharingQueue(null);
            slot = this.findSlot(queue);
            DaemonPool._assert(slot != null);
            taskStop.setQueue(queue);
        }
        slot.add(this.instantiateWrapperTask(taskStop, false));
    }

    @Override
    public String toString() {
        int c;
        StringBuilder sb = new StringBuilder(this.get_Name());
        sb.append("\nWorkSlots:");
        int c2 = this.getWorkSlotCount();
        for (int i = 0; i < c2; ++i) {
            sb.append("\n  ").append(this.getWorkSlot(i));
        }
        Daemon[] aDaemon = this.getDaemons();
        sb.append("\n Daemons:");
        int n = c = aDaemon == null ? 0 : aDaemon.length;
        for (int i = 0; i < c; ++i) {
            sb.append("\n  ").append(aDaemon[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateStats(Daemon daemon, int cTasks, long ldtStart) {
        long ldtNow = Base.getSafeTimeMillis();
        if (cTasks > 0 && daemon.getDaemonType() == 0) {
            Object object = this.STATS_MONITOR;
            synchronized (object) {
                this.setStatsTaskCount(this.getStatsTaskCount() + (long)cTasks);
                this.setStatsActiveMillis(this.getStatsActiveMillis() + ldtNow - ldtStart);
            }
        }
        daemon.setFlushStats(false);
        return ldtNow;
    }

    static {
        DaemonPool.__initStatic();
    }

    public static class Daemon
    extends com.tangosol.coherence.component.util.Daemon {
        private int __m_DaemonType;
        private volatile boolean __m_FlushStats;
        private volatile transient int __m_InterruptCount;
        private AssociationPile __m_Queue;
        private volatile transient WrapperTask __m_WrapperTask;

        public Daemon() {
            this(null, null, true);
        }

        public Daemon(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setDaemonState(0);
                this.setDefaultGuardRecovery(0.9f);
                this.setDefaultGuardTimeout(60000L);
                this.setNotifier(new SingleWaiterMultiNotifier());
                this.setThreadName("Worker");
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this._addChild(new Guard("Guard", this, true), "Guard");
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Daemon();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/DaemonPool$Daemon".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abandon() {
            boolean fAbandon = false;
            Thread thread = null;
            Daemon daemon = this;
            synchronized (daemon) {
                thread = this.getThread();
                if (thread == null) {
                    return;
                }
                if (this.isStarted() && !this.isExiting()) {
                    fAbandon = true;
                    this.setExiting(true);
                }
            }
            if (fAbandon) {
                Runnable task;
                DaemonPool pool = (DaemonPool)this.get_Module();
                WrapperTask wrapper = this.getWrapperTask();
                Object sThread = this.getThreadName();
                Object object = pool.STATS_MONITOR;
                synchronized (object) {
                    pool.setStatsAbandonedCount(pool.getStatsAbandonedCount() + 1);
                }
                Object sReason = wrapper == null ? ", while waiting" : " executing task \"" + wrapper.getTaskId() + "\"";
                if (wrapper != null && (task = wrapper.getTask()) instanceof PriorityTask) {
                    pool.runCanceled((PriorityTask)((Object)task), true);
                }
                StringBuilder sbMsg = new StringBuilder();
                sbMsg.append("A worker thread \"").append((String)sThread).append((String)sReason).append(", did not respond to ").append(Math.abs(pool.getAbandonThreshold())).append(" interrupt requests. The execution was canceled.").append(" The thread ");
                int cAttempts = pool.getAbandonThreshold();
                if (cAttempts < 0) {
                    for (int i = cAttempts; i < 0 && thread.isAlive(); ++i) {
                        try {
                            ClassHelper.invoke(thread, "stop", ClassHelper.VOID);
                            Blocking.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                            break;
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                    if (thread.isAlive()) {
                        sbMsg.append("could not be stopped and ");
                    }
                }
                if (thread.isAlive()) {
                    sThread = (String)sThread + "!abandoned";
                    try {
                        thread.setName((String)sThread);
                        thread.setPriority(1);
                    }
                    catch (RuntimeException i) {
                        // empty catch block
                    }
                    sbMsg.append("is abandoned...");
                    try {
                        StackTraceElement[] atrace = thread.getStackTrace();
                        int c = atrace.length;
                        for (int i = 0; i < c; ++i) {
                            sbMsg.append("\n  at ").append(atrace[i]);
                        }
                        sbMsg.append('\n');
                    }
                    catch (Throwable throwable) {}
                } else {
                    sbMsg.append("is stopped.");
                }
                Daemon._trace(sbMsg.toString(), 1);
            }
        }

        public int getDaemonType() {
            return this.__m_DaemonType;
        }

        public int getInterruptCount() {
            return this.__m_InterruptCount;
        }

        public AssociationPile getQueue() {
            return this.__m_Queue;
        }

        @Override
        public long getWaitMillis() {
            long cWait = super.getWaitMillis();
            if (this.isGuarded() || this.isGuardian()) {
                long cMaxWait = 1000L;
                cWait = cWait == 0L ? cMaxWait : Math.min(cWait, cMaxWait);
            }
            return cWait;
        }

        public WrapperTask getWrapperTask() {
            return this.__m_WrapperTask;
        }

        @Override
        public void halt() {
            super.halt();
        }

        @Override
        public void heartbeat(long cMillis) {
            super.heartbeat(cMillis);
        }

        public boolean isFlushStats() {
            return this.__m_FlushStats;
        }

        @Override
        protected void onEnter() {
            super.onEnter();
            if (this.isGuarded()) {
                GuardSupport.setThreadContext(this.getGuardable().getContext());
            }
        }

        @Override
        protected void onException(Throwable e) {
            if (this.isExiting()) {
                super.onException(e);
            } else {
                Daemon._trace("An unhandled exception occurred on worker thread \"" + this.get_Name() + "\":", 1);
                Daemon._trace(e);
            }
        }

        @Override
        protected void onExit() {
            if (!this.isExiting()) {
                int c;
                Daemon[] aDaemon = ((DaemonPool)this.get_Module()).getDaemons();
                int n = c = aDaemon == null ? 0 : aDaemon.length;
                for (int i = 0; i < c; ++i) {
                    if (this != aDaemon[i]) continue;
                    Daemon._trace("Worker thread \"" + this.getThreadName() + "\" is exiting but still remains in its pool", 1);
                    break;
                }
            }
            super.onExit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onNotify() {
            DaemonPool pool = (DaemonPool)this.get_Parent();
            boolean fOnce = this.getQueue() == null;
            long ldtStart = 0L;
            int cTasks = 0;
            WrapperTask wrapper = this.getWrapperTask();
            try {
                while (!this.isExiting()) {
                    if (!fOnce) {
                        wrapper = this.removeFromQueue();
                        if (wrapper == null && (wrapper = this.removeFromAnotherQueue()) == null) {
                            return;
                        }
                        this.setWrapperTask(wrapper);
                        if (this.isFlushStats() || ((long)cTasks & 0xFFL) == 0L) {
                            ldtStart = pool.updateStats(this, cTasks, ldtStart);
                            cTasks = 0;
                        }
                    } else if (wrapper == null) {
                        this.setExiting(true);
                        return;
                    }
                    long ldtStop = wrapper.getStopTime();
                    long cTimeoutMillis = wrapper.getTimeoutMillis();
                    if (ldtStop > 0L) {
                        cTimeoutMillis = Math.min(cTimeoutMillis, Math.max(1L, ldtStop - ldtStart));
                    }
                    if (cTimeoutMillis == 0L) {
                        this.heartbeat();
                    } else {
                        this.heartbeat(cTimeoutMillis);
                    }
                    if (!wrapper.isManagementTask()) {
                        ++cTasks;
                    }
                    try {
                        wrapper.run();
                        if (!fOnce) continue;
                        this.setExiting(true);
                    }
                    catch (EventDeathException e) {
                        Runnable task = wrapper.getTask();
                        if (task instanceof StopTask) {
                            pool.onDaemonStop(this, (StopTask)task);
                            this.setExiting(true);
                            continue;
                        }
                        throw e;
                    }
                    finally {
                        this.setWrapperTask(null);
                        this.release(wrapper);
                        wrapper = null;
                    }
                }
            }
            finally {
                if (cTasks > 0) {
                    pool.updateStats(this, cTasks, ldtStart);
                }
                this.release(wrapper);
                this.heartbeat();
            }
        }

        @Override
        protected void onWait() throws InterruptedException {
            if (this.getWrapperTask() == null) {
                super.onWait();
            }
        }

        protected void release(WrapperTask wrapper) {
            if (wrapper != null) {
                Gate gate;
                AssociationPile queue = (AssociationPile)wrapper.get_Feed();
                if (queue != null) {
                    wrapper.set_Feed(null);
                    queue.release(wrapper);
                }
                if ((gate = wrapper.getGate()) != null) {
                    gate.exit();
                    wrapper.setGate(null);
                }
            }
        }

        protected WrapperTask removeFromAnotherQueue() {
            DaemonPool pool = (DaemonPool)this.get_Parent();
            if (pool.getQueues().length <= 1) {
                return null;
            }
            AssociationPile queueThis = this.getQueue();
            int c = pool.getWorkSlotCount();
            int nHash = this.hashCode();
            for (int i = 0; i < c; ++i) {
                WrapperTask wrapper;
                WorkSlot slotThat = pool.getWorkSlot(Base.mod(nHash + i, c));
                Gate gateThat = slotThat.getGate();
                if (!gateThat.enter(0L)) continue;
                AssociationPile queueThat = slotThat.getQueue();
                if (queueThat != queueThis && slotThat.isActive() && (wrapper = (WrapperTask)queueThat.poll()) != null) {
                    if (wrapper.isManagementTask()) {
                        queueThat.release(wrapper);
                        queueThat.add(wrapper);
                    } else {
                        wrapper.set_Feed(queueThat);
                        wrapper.setGate(gateThat);
                        return wrapper;
                    }
                }
                gateThat.exit();
            }
            return null;
        }

        protected WrapperTask removeFromQueue() {
            AssociationPile queue = this.getQueue();
            WrapperTask wrapper = (WrapperTask)queue.poll();
            if (wrapper != null) {
                wrapper.set_Feed(queue);
            }
            return wrapper;
        }

        public void setDaemonType(int nType) {
            this.__m_DaemonType = nType;
        }

        public void setFlushStats(boolean fFlush) {
            this.__m_FlushStats = fFlush;
        }

        @Override
        public void setGuardSupport(GuardSupport guardSupport) {
            super.setGuardSupport(guardSupport);
        }

        public void setInterruptCount(int cInterrupts) {
            this.__m_InterruptCount = cInterrupts;
        }

        public void setQueue(AssociationPile queue) {
            Daemon._assert(this.getQueue() == null, "Queue is not resettable");
            this.__m_Queue = queue;
            if (queue instanceof Notifier) {
                if (queue instanceof ConcurrentQueue) {
                    this.setNotifier(((ConcurrentQueue)((Object)queue)).getNotifier());
                } else {
                    this.setNotifier((Notifier)((Object)queue));
                }
            }
        }

        public void setWrapperTask(WrapperTask task) {
            Thread thread = this.getThread();
            Daemon._assert(thread == null || thread == Thread.currentThread());
            this.__m_WrapperTask = task;
            if (this.getInterruptCount() > 0) {
                Thread.interrupted();
                this.setInterruptCount(0);
                this.heartbeat();
            }
        }

        @Override
        public void start() {
            ((DaemonPool)this.get_Module()).guard(this.getGuardable());
            super.start();
        }

        @Override
        protected Thread instantiateThread() {
            Thread thread = this.useVirtualThreads() ? VirtualThreads.makeThread(this.getThreadGroup(), this, this.getThreadName()) : Base.makeThread(this.getThreadGroup(), this, this.getThreadName());
            thread.setDaemon(true);
            int nPriority = this.getPriority();
            if (nPriority != 0) {
                thread.setPriority(nPriority);
            }
            return thread;
        }

        protected boolean useVirtualThreads() {
            DaemonPool pool = (DaemonPool)this.get_Module();
            return VirtualThreads.isSupported() && VirtualThreads.isEnabled(pool.getName()) && (pool.isDynamic() || this.getDaemonType() == 1);
        }

        @Override
        public String toString() {
            return this.getThreadName() + "@" + System.identityHashCode(this) + " QueueId=" + System.identityHashCode(this.getQueue());
        }

        public static class Guard
        extends Daemon.Guard {
            private static ListMap __mapChildren;

            private static void __initStatic() {
                __mapChildren = new ListMap();
                __mapChildren.put("Abandon", Abandon.get_CLASS());
            }

            public Guard() {
                this(null, null, true);
            }

            public Guard(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Guard();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/DaemonPool$Daemon$Guard".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            protected Map get_ChildClasses() {
                return __mapChildren;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recover() {
                DaemonPool pool = (DaemonPool)this.get_Module();
                Daemon daemon = (Daemon)this.get_Parent();
                Object object = pool.STATS_MONITOR;
                synchronized (object) {
                    pool.setStatsTimeoutCount(pool.getStatsTimeoutCount() + 1);
                }
                if (daemon.isStarted() && !daemon.isExiting()) {
                    WrapperTask wrapper = daemon.getWrapperTask();
                    if (wrapper != null) {
                        String sTaskId = wrapper.getTaskId();
                        Thread thread = daemon.getThread();
                        int cInterrupts = daemon.getInterruptCount();
                        Guardian.GuardContext context = this.getContext();
                        if (cInterrupts == 0) {
                            long cTime = Base.getSafeTimeMillis() - wrapper.getStartTime();
                            Guard._trace("A worker thread has been executing task: " + sTaskId + " for " + cTime + "ms and appears to be stuck; attempting to interrupt: " + daemon.getThreadName(), 2);
                        }
                        long cRecoveryMillis = pool.getRecoveryDelay();
                        int c = pool.getAbandonThreshold();
                        for (int i = 0; i < c; ++i) {
                            daemon.setInterruptCount(++cInterrupts);
                            thread.interrupt();
                            Daemon.sleep(cRecoveryMillis);
                            if (daemon.getInterruptCount() == 0 || context == null) break;
                            if (context.getState() != 1) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        daemon.getThread().interrupt();
                    }
                }
            }

            @Override
            public void terminate() {
                DaemonPool pool = (DaemonPool)this.get_Module();
                Daemon daemon = (Daemon)this.get_Parent();
                daemon.setDaemonType(2);
                Base.makeThread(null, (Runnable)((Object)this._newChild("Abandon")), "Abandon").start();
                pool.replaceDaemon(daemon);
            }

            static {
                Guard.__initStatic();
            }

            public static class Abandon
            extends Component
            implements Runnable {
                public Abandon() {
                    this(null, null, true);
                }

                public Abandon(String sName, Component compParent, boolean fInit) {
                    super(sName, compParent, false);
                    if (fInit) {
                        this.__init();
                    }
                }

                @Override
                public void __init() {
                    this.__initPrivate();
                    this.set_Constructed(true);
                }

                @Override
                protected void __initPrivate() {
                    super.__initPrivate();
                }

                public static Component get_Instance() {
                    return new Abandon();
                }

                public static Class get_CLASS() {
                    Class<?> clz;
                    try {
                        clz = Class.forName("com.tangosol.coherence/component/util/DaemonPool$Daemon$Guard$Abandon".replace('/', '.'));
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    return clz;
                }

                private Component get_Module() {
                    return this.get_Parent().get_Parent().get_Parent();
                }

                @Override
                public void run() {
                    ((Daemon)this.get_Parent().get_Parent()).abandon();
                }
            }
        }
    }

    public static class ResizeTask
    extends Util
    implements Runnable {
        private transient double __m_ActiveCountAverage;
        public static final int ADJUST_FASTER = 1;
        public static final int ADJUST_SLOWER = 2;
        private static boolean __s_Debug;
        private static double __s_IdleFraction;
        private static int __s_IdleLimit;
        private long __m_LastActiveMillis;
        private int __m_LastResize;
        private long __m_LastResizeMillis;
        private long __m_LastRunMillis;
        private long __m_LastShakeMillis;
        private long __m_LastTaskCount;
        private int __m_LastThreadCount;
        private double __m_LastThroughput;
        private static long __s_PeriodAdjust;
        private static long __s_PeriodMax;
        private long __m_PeriodMillis;
        private static long __s_PeriodMin;
        private static long __s_PeriodShake;
        private static double __s_ResizeGrow;
        private static double __s_ResizeJitter;
        private static double __s_ResizeShake;
        private static double __s_ResizeShrink;

        private static void _initStatic$Default() {
            ResizeTask.__initStatic();
        }

        private static void __initStatic() {
            try {
                ResizeTask.setIdleFraction(0.333);
                ResizeTask.setIdleLimit(20);
                ResizeTask.setPeriodAdjust(250L);
                ResizeTask.setPeriodMax(10000L);
                ResizeTask.setPeriodMin(100L);
                ResizeTask.setPeriodShake(600000L);
                ResizeTask.setResizeGrow(1.0);
                ResizeTask.setResizeJitter(0.05);
                ResizeTask.setResizeShake(0.15);
                ResizeTask.setResizeShrink(0.25);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
        }

        public ResizeTask() {
            this(null, null, true);
        }

        public ResizeTask(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ResizeTask();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/DaemonPool$ResizeTask".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        protected long adjustPeriod(int nAdjust, int cThreadsOld, int cThreadsNew) {
            long cMillis = this.getPeriodMillis();
            switch (nAdjust) {
                case 1: {
                    if (cThreadsOld == cThreadsNew) break;
                    this.setPeriodMillis(Math.max(ResizeTask.getPeriodMin(), cMillis - ResizeTask.getPeriodAdjust()));
                    cMillis = ResizeTask.getPeriodMin();
                    break;
                }
                case 2: {
                    cMillis = Math.min(ResizeTask.getPeriodMax(), cMillis + ResizeTask.getPeriodAdjust());
                    this.setPeriodMillis(cMillis);
                }
            }
            return cMillis;
        }

        public synchronized void cancel() {
            DaemonPool pool = this.getDaemonPool();
            if (pool != null) {
                this.get_Parent()._unlinkChild(this);
            }
        }

        private static String format2f(double dfl) {
            return String.format("%.2f", dfl);
        }

        public double getActiveCountAverage() {
            return this.__m_ActiveCountAverage;
        }

        public int getDaemonCount() {
            return this.getDaemonPool().getDaemonCount();
        }

        public DaemonPool getDaemonPool() {
            return (DaemonPool)this.get_Module();
        }

        protected static double getDoubleProperty(String sName, double dflDefault) {
            try {
                return Double.parseDouble(Config.getProperty(sName));
            }
            catch (RuntimeException e) {
                return dflDefault;
            }
        }

        public static double getIdleFraction() {
            return __s_IdleFraction;
        }

        public static int getIdleLimit() {
            return __s_IdleLimit;
        }

        protected static int getIntegerProperty(String sName, int nDefault) {
            try {
                return Config.getInteger(sName, nDefault);
            }
            catch (RuntimeException e) {
                return nDefault;
            }
        }

        public long getLastActiveMillis() {
            return this.__m_LastActiveMillis;
        }

        public int getLastResize() {
            return this.__m_LastResize;
        }

        public long getLastResizeMillis() {
            return this.__m_LastResizeMillis;
        }

        public long getLastRunMillis() {
            return this.__m_LastRunMillis;
        }

        public long getLastShakeMillis() {
            return this.__m_LastShakeMillis;
        }

        public long getLastTaskCount() {
            return this.__m_LastTaskCount;
        }

        public int getLastThreadCount() {
            return this.__m_LastThreadCount;
        }

        public double getLastThroughput() {
            return this.__m_LastThroughput;
        }

        protected static long getLongProperty(String sName, long nDefault) {
            try {
                return Config.getLong(sName, nDefault);
            }
            catch (RuntimeException e) {
                return nDefault;
            }
        }

        public static long getPeriodAdjust() {
            return __s_PeriodAdjust;
        }

        public static long getPeriodMax() {
            return __s_PeriodMax;
        }

        public long getPeriodMillis() {
            return this.__m_PeriodMillis;
        }

        public static long getPeriodMin() {
            return __s_PeriodMin;
        }

        public static long getPeriodShake() {
            return __s_PeriodShake;
        }

        public static double getResizeGrow() {
            return __s_ResizeGrow;
        }

        public static double getResizeJitter() {
            return __s_ResizeJitter;
        }

        public static double getResizeShake() {
            return __s_ResizeShake;
        }

        public static double getResizeShrink() {
            return __s_ResizeShrink;
        }

        protected int growDaemonPool(String sReason) {
            int cThreads = this.getDaemonCount();
            return this.isDaemonPoolUnderutilized() ? cThreads : this.resizeDaemonPool(Math.max(1, (int)((double)cThreads * ResizeTask.getResizeGrow())), sReason);
        }

        protected boolean isDaemonPoolOverutilized() {
            int cThreads = this.getDaemonCount();
            double dflActive = this.getActiveCountAverage();
            int cIdle = (int)((double)cThreads - dflActive);
            return cThreads < this.getDaemonPool().getDaemonCountMax() && dflActive > (double)cThreads * (1.0 - ResizeTask.getIdleFraction()) && cIdle < ResizeTask.getIdleLimit() && this.getLastThroughput() > 0.0;
        }

        protected boolean isDaemonPoolUnderutilized() {
            int cThreads = this.getDaemonCount();
            return cThreads > this.getDaemonPool().getDaemonCountMin() && (this.getActiveCountAverage() < (double)cThreads * ResizeTask.getIdleFraction() || this.getLastThroughput() == 0.0);
        }

        public static boolean isDebug() {
            return __s_Debug;
        }

        protected static boolean isStatisticsSuspect(long ldtLastRun, long ldtLastResize, long ldtResizeEnd, long ldtReset) {
            return ldtLastRun <= ldtReset || ldtLastRun == ldtLastResize && ldtResizeEnd - ldtLastResize > ResizeTask.getPeriodMin() / 10L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInit() {
            long ldtNow = Base.getSafeTimeMillis();
            this.setLastRunMillis(ldtNow);
            this.setLastShakeMillis(ldtNow);
            this.setPeriodMillis(ResizeTask.getPeriodMin());
            DaemonPool pool = this.getDaemonPool();
            Object object = pool.STATS_MONITOR;
            synchronized (object) {
                this.setLastActiveMillis(pool.getStatsActiveMillis());
                this.setLastTaskCount(pool.getStatsTaskCount());
            }
            this.setLastThreadCount(pool.getDaemonCount());
            super.onInit();
        }

        protected static String reasonToString(String sReason) {
            if (sReason == null || sReason.isEmpty()) {
                return "";
            }
            return " due to " + sReason;
        }

        protected int resizeDaemonPool(int cDelta, String sReason) {
            DaemonPool pool = this.getDaemonPool();
            int cCurrent = pool.getDaemonCount();
            int cNew = cCurrent + cDelta;
            if (cDelta == 0 || cNew < pool.getDaemonCountMin() || cNew > pool.getDaemonCountMax()) {
                return cCurrent;
            }
            if (ResizeTask.isDebug()) {
                ResizeTask._trace("DaemonPool \"" + pool.getName() + "\" " + (cDelta > 0 ? "increasing" : "decreasing") + " the pool size from " + cCurrent + " to " + cNew + " thread(s)" + ResizeTask.reasonToString(sReason), 5);
            }
            pool.setDaemonCount(cNew);
            return cNew;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            int cThreads;
            DaemonPool pool = this.getDaemonPool();
            if (pool == null) {
                return;
            }
            pool.flushStats();
            long ldtNow = Base.getSafeTimeMillis();
            long cPeriod = this.getPeriodMillis();
            long cTasks = 0L;
            long cActiveMillis = 0L;
            int cNew = cThreads = pool.getDaemonCount();
            if (pool.isInTransition()) {
                pool.schedule(this, ResizeTask.getPeriodMin());
                if (ResizeTask.isDebug()) {
                    ResizeTask._trace("DaemonPool \"" + pool.getName() + "\": skipping analysis due to the pool resize in progress", 3);
                }
                return;
            }
            try {
                long ldtResizeEnd;
                long ldtReset;
                Object object = pool.STATS_MONITOR;
                synchronized (object) {
                    cActiveMillis = pool.getStatsActiveMillis();
                    cTasks = pool.getStatsTaskCount();
                    ldtReset = pool.getStatsLastResetMillis();
                    ldtResizeEnd = pool.getStatsLastResizeMillis();
                }
                long ldtLastRun = this.getLastRunMillis();
                long ldtLastResize = this.getLastResizeMillis();
                if (cThreads != this.getLastThreadCount()) {
                    if (ResizeTask.isDebug()) {
                        ResizeTask._trace("DaemonPool \"" + pool.getName() + "\": skipping analysis because the pool was resized externally (expected=" + this.getLastThreadCount() + ", current=" + cThreads + ")", 3);
                    }
                    this.setLastResize(cThreads - this.getLastThreadCount());
                    return;
                }
                if (ResizeTask.isStatisticsSuspect(ldtLastRun, ldtLastResize, ldtResizeEnd, ldtReset)) {
                    if (ResizeTask.isDebug()) {
                        ResizeTask._trace("DaemonPool \"" + pool.getName() + "\": skipping analysis to gather new statistics after a resize or reset", 3);
                    }
                    cPeriod = ResizeTask.getPeriodMin();
                    return;
                }
                long cTasksDelta = cTasks - this.getLastTaskCount();
                long cMillisDelta = ldtNow - ldtLastRun;
                double dflTP = cTasksDelta <= 0L || cMillisDelta <= 0L ? 0.0 : (double)cTasksDelta * 1000.0 / (double)cMillisDelta;
                double dflActive = (this.getActiveCountAverage() + (double)pool.getActiveDaemonCount()) / 2.0;
                int cLast = this.getLastResize();
                double dflTPLast = this.getLastThroughput();
                double dflTPDelta = dflTP - dflTPLast;
                double dflTPJitter = dflTP * ResizeTask.getResizeJitter();
                if (ResizeTask.isDebug() && cTasksDelta > 0L) {
                    double dflUtilization = cMillisDelta <= 0L ? 0.0 : (double)(cActiveMillis - this.getLastActiveMillis()) / (double)cMillisDelta;
                    Object[] ao = new Object[]{cThreads, dflActive, cTasksDelta, cMillisDelta, dflTP, dflUtilization};
                    ResizeTask._trace(String.format("DaemonPool \"" + pool.getName() + "\": [Size=%d, Active=%.2f, DeltaTasks=%d, DeltaMills=%d, Throughput=%.1f, Utilization=%.2f]", ao), 3);
                }
                this.setLastThroughput(dflTP);
                this.setActiveCountAverage(dflActive);
                if (ldtNow >= this.getLastShakeMillis() + ResizeTask.getPeriodShake()) {
                    this.setLastShakeMillis(ldtNow);
                    if (dflTP > 0.0) {
                        cNew = this.shakeDaemonPool();
                        this.setLastResize(cNew - cThreads);
                        return;
                    }
                }
                if (Math.abs(dflTPDelta) > dflTPJitter) {
                    if (cLast > 0) {
                        if (dflTPDelta > 0.0) {
                            cNew = this.growDaemonPool("an increase in throughput of " + ResizeTask.format2f(dflTPDelta) + "op/sec");
                            cPeriod = this.adjustPeriod(1, cThreads, cNew);
                        } else {
                            cNew = this.shrinkDaemonPool("a decrease in throughput of " + ResizeTask.format2f(-dflTPDelta) + "op/sec");
                            cPeriod = this.adjustPeriod(2, cThreads, cNew);
                        }
                    } else if (cLast < 0) {
                        if (dflTPDelta > 0.0) {
                            cNew = this.shrinkDaemonPool("an increase in throughput of " + ResizeTask.format2f(dflTPDelta) + "op/sec");
                            cPeriod = this.adjustPeriod(1, cThreads, cNew);
                        } else {
                            cNew = this.growDaemonPool("a decrease in throughput of " + ResizeTask.format2f(-dflTPDelta) + "op/sec");
                            cPeriod = this.adjustPeriod(2, cThreads, cNew);
                        }
                    } else if (!(dflTPDelta > 0.0)) {
                        if (this.isDaemonPoolUnderutilized()) {
                            cNew = this.shrinkDaemonPool("a decrease in throughput and the pool been underutilized");
                            cPeriod = this.adjustPeriod(1, cThreads, cNew);
                        } else if (this.isDaemonPoolOverutilized()) {
                            cNew = this.growDaemonPool("an decrease in throughput and the pool being overutilized");
                            cPeriod = this.adjustPeriod(1, cThreads, cNew);
                        }
                    }
                } else if (ldtNow > ldtLastResize + cPeriod) {
                    if (this.isDaemonPoolOverutilized()) {
                        cNew = this.growDaemonPool("the pool being overutilized");
                        cPeriod = this.adjustPeriod(1, cThreads, cNew);
                    } else if (this.isDaemonPoolUnderutilized()) {
                        cNew = this.shrinkDaemonPool("the pool being underutilized");
                        cPeriod = this.adjustPeriod(1, cThreads, cNew);
                    } else {
                        cPeriod = this.adjustPeriod(2, cThreads, cNew);
                    }
                }
                this.setLastResize(cNew - cThreads);
            }
            finally {
                if (cNew != cThreads) {
                    this.setLastResizeMillis(ldtNow);
                }
                this.setLastRunMillis(ldtNow);
                this.setLastTaskCount(cTasks);
                this.setLastThreadCount(cNew);
                this.setLastActiveMillis(cActiveMillis);
                pool.schedule(this, cPeriod);
            }
        }

        protected void setActiveCountAverage(double dflAverage) {
            this.__m_ActiveCountAverage = dflAverage;
        }

        public static void setDebug(boolean fDebug) {
            __s_Debug = fDebug;
        }

        public static void setIdleFraction(double dFraction) {
            __s_IdleFraction = dFraction;
        }

        public static void setIdleLimit(int nLimit) {
            __s_IdleLimit = nLimit;
        }

        protected void setLastActiveMillis(long cMillis) {
            this.__m_LastActiveMillis = cMillis;
        }

        protected void setLastResize(int cThreads) {
            this.__m_LastResize = cThreads;
        }

        protected void setLastResizeMillis(long ldtResize) {
            this.__m_LastResizeMillis = ldtResize;
        }

        protected void setLastRunMillis(long ldtRun) {
            this.__m_LastRunMillis = ldtRun;
        }

        protected void setLastShakeMillis(long ldtDown) {
            this.__m_LastShakeMillis = ldtDown;
        }

        protected void setLastTaskCount(long cTasks) {
            this.__m_LastTaskCount = cTasks;
        }

        protected void setLastThreadCount(int cThreads) {
            this.__m_LastThreadCount = cThreads;
        }

        protected void setLastThroughput(double dflTP) {
            this.__m_LastThroughput = dflTP;
        }

        public static void setPeriodAdjust(long lAdjust) {
            __s_PeriodAdjust = lAdjust;
        }

        public static void setPeriodMax(long lAdjust) {
            __s_PeriodMax = lAdjust;
        }

        protected void setPeriodMillis(long cMillis) {
            this.__m_PeriodMillis = cMillis;
        }

        public static void setPeriodMin(long lAdjust) {
            __s_PeriodMin = lAdjust;
        }

        public static void setPeriodShake(long lAdjust) {
            __s_PeriodShake = lAdjust;
        }

        public static void setResizeGrow(double dGrow) {
            __s_ResizeGrow = dGrow;
        }

        public static void setResizeJitter(double dGrow) {
            __s_ResizeJitter = dGrow;
        }

        public static void setResizeShake(double dGrow) {
            __s_ResizeShake = dGrow;
        }

        public static void setResizeShrink(double dGrow) {
            __s_ResizeShrink = dGrow;
        }

        protected int shakeDaemonPool() {
            int cDelta = Math.max(1, (int)((double)this.getDaemonCount() * ResizeTask.getResizeShake()));
            int cRange = 2 * cDelta + 1;
            return this.resizeDaemonPool(Base.getRandom().nextInt(cRange) - cDelta, "the pool being shaken");
        }

        protected int shrinkDaemonPool(String sReason) {
            return this.resizeDaemonPool(-Math.max(1, (int)((double)this.getDaemonCount() * ResizeTask.getResizeShrink())), sReason);
        }

        @Override
        public String toString() {
            return this.get_Name() + " for " + String.valueOf(this.getDaemonPool());
        }

        static {
            ResizeTask._initStatic$Default();
            ResizeTask.setDebug(Config.getBoolean("coherence.daemonpool.debug"));
            ResizeTask.setIdleFraction(ResizeTask.getDoubleProperty("coherence.daemonpool.idle.fraction", ResizeTask.getIdleFraction()));
            ResizeTask.setIdleLimit(ResizeTask.getIntegerProperty("coherence.daemonpool.idle.threshold", ResizeTask.getIdleLimit()));
            ResizeTask.setPeriodAdjust(ResizeTask.getLongProperty("coherence.daemonpool.adjust.period", ResizeTask.getPeriodAdjust()));
            ResizeTask.setPeriodMax(ResizeTask.getLongProperty("coherence.daemonpool.max.period", ResizeTask.getPeriodMax()));
            ResizeTask.setPeriodMin(ResizeTask.getLongProperty("coherence.daemonpool.min.period", ResizeTask.getPeriodMin()));
            ResizeTask.setPeriodShake(ResizeTask.getLongProperty("coherence.daemonpool.shake.period", ResizeTask.getPeriodShake()));
            ResizeTask.setResizeGrow(ResizeTask.getDoubleProperty("coherence.daemonpool.grow.percentage", ResizeTask.getResizeGrow()));
            ResizeTask.setResizeJitter(ResizeTask.getDoubleProperty("coherence.daemonpool.jitter.percentage", ResizeTask.getResizeJitter()));
            ResizeTask.setResizeShake(ResizeTask.getDoubleProperty("coherence.daemonpool.shake.percentage", ResizeTask.getResizeShake()));
            ResizeTask.setResizeShrink(ResizeTask.getDoubleProperty("coherence.daemonpool.shrink.percentage", ResizeTask.getResizeShrink()));
            if (ResizeTask.isDebug()) {
                Object[] ao = new Object[]{ResizeTask.getIdleFraction(), ResizeTask.getIdleLimit(), ResizeTask.getPeriodAdjust(), ResizeTask.getPeriodMax(), ResizeTask.getPeriodMin(), ResizeTask.getPeriodShake(), ResizeTask.getResizeGrow(), ResizeTask.getResizeJitter(), ResizeTask.getResizeShake(), ResizeTask.getResizeShrink()};
                ResizeTask._trace(String.format("ResizeTask[IdleFraction=%.2f, IdleLimit=%d, PeriodAdjust=%d, PeriodMax=%d, PeriodMin=%d, PeriodShake=%d, ResizeGrow=%.3f, ResizeJitter=%.3f, ResizeShake=%.3f, ResizeShrink=%.3f]", ao), 3);
            }
        }
    }

    public static class ScheduleTask
    extends Util
    implements PriorityTask,
    Runnable {
        private long __m_DelayMillis;
        private Runnable __m_Task;

        public ScheduleTask() {
            this(null, null, true);
        }

        public ScheduleTask(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ScheduleTask();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/DaemonPool$ScheduleTask".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public DaemonPool getDaemonPool() {
            return (DaemonPool)this.get_Module();
        }

        public long getDelayMillis() {
            return this.__m_DelayMillis;
        }

        @Override
        public long getExecutionTimeoutMillis() {
            Runnable task = this.getTask();
            return this.getDelayMillis() + (task instanceof PriorityTask ? ((PriorityTask)((Object)task)).getExecutionTimeoutMillis() : this.getDaemonPool().getTaskTimeout());
        }

        @Override
        public long getRequestTimeoutMillis() {
            return this.getExecutionTimeoutMillis();
        }

        @Override
        public int getSchedulingPriority() {
            Runnable task = this.getTask();
            return task instanceof PriorityTask ? ((PriorityTask)((Object)task)).getSchedulingPriority() : 0;
        }

        public Runnable getTask() {
            return this.__m_Task;
        }

        @Override
        public void run() {
            Runnable task = this.getTask();
            if (task instanceof ResizeTask) {
                task.run();
            } else {
                this.getDaemonPool().add(task);
            }
        }

        @Override
        public void runCanceled(boolean fAbandoned) {
            Runnable task = this.getTask();
            if (task instanceof PriorityTask) {
                ((PriorityTask)((Object)task)).runCanceled(fAbandoned);
            }
        }

        public void setDelayMillis(long cMillis) {
            this.__m_DelayMillis = cMillis;
        }

        public void setTask(Runnable task) {
            this.__m_Task = task;
        }

        @Override
        public String toString() {
            return this.get_Name() + " for " + String.valueOf(this.getDaemonPool());
        }
    }

    public static class StartTask
    extends Util
    implements Associated,
    Runnable {
        private Daemon __m_Daemon;
        private AssociationPile __m_Queue;
        private int __m_StartCount;
        private WorkSlot __m_WorkSlotActivate;

        public StartTask() {
            this(null, null, true);
        }

        public StartTask(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new StartTask();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/DaemonPool$StartTask".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Object getAssociatedKey() {
            return this.getDaemon() == null ? null : AssociationPile.ASSOCIATION_ALL;
        }

        public Daemon getDaemon() {
            return this.__m_Daemon;
        }

        public AssociationPile getQueue() {
            return this.__m_Queue;
        }

        public int getStartCount() {
            return this.__m_StartCount;
        }

        public WorkSlot getWorkSlotActivate() {
            return this.__m_WorkSlotActivate;
        }

        @Override
        public void run() {
            Daemon daemon = this.getDaemon();
            DaemonPool pool = (DaemonPool)this.get_Module();
            if (daemon == null) {
                pool.startDaemon(this);
            } else {
                WorkSlot slot = this.getWorkSlotActivate();
                Gate gate = slot.getGate();
                if (!gate.close(1L)) {
                    this.getQueue().add(pool.instantiateWrapperTask(this, false));
                    return;
                }
                slot.setActive(true);
                gate.open();
                daemon.start();
                this.scheduleNext();
            }
        }

        public void scheduleNext() {
            DaemonPool pool = (DaemonPool)this.get_Module();
            int cStart = this.getStartCount() - 1;
            if (cStart > 0) {
                StartTask task = (StartTask)pool._newChild("StartTask");
                task.setStartCount(cStart);
                pool.add(task, false);
            } else {
                pool.setInTransition(false);
            }
        }

        public void setDaemon(Daemon daemon) {
            this.__m_Daemon = daemon;
        }

        public void setQueue(AssociationPile queue) {
            this.__m_Queue = queue;
        }

        public void setStartCount(int nCount) {
            this.__m_StartCount = nCount;
        }

        public void setWorkSlotActivate(WorkSlot slot) {
            this.__m_WorkSlotActivate = slot;
        }

        @Override
        public String toString() {
            return this.get_Name() + " for Daemon " + String.valueOf(this.getDaemon());
        }
    }

    public static class StopTask
    extends Util
    implements Runnable {
        private AssociationPile __m_Queue;
        private int __m_StopCount;
        private WorkSlot __m_WorkSlot;

        public StopTask() {
            this(null, null, true);
        }

        public StopTask(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new StopTask();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/DaemonPool$StopTask".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public AssociationPile getQueue() {
            return this.__m_Queue;
        }

        public int getStopCount() {
            return this.__m_StopCount;
        }

        public WorkSlot getWorkSlot() {
            return this.__m_WorkSlot;
        }

        @Override
        public void run() {
            DaemonPool pool = (DaemonPool)this.get_Module();
            AssociationPile queue = this.getQueue();
            if (queue != null || this.getWorkSlot() != null) {
                if (queue != null) {
                    int c = pool.getWorkSlotCount();
                    for (int i = 0; i < c; ++i) {
                        WorkSlot slot = pool.getWorkSlot(i);
                        if (slot.getQueue() != queue || slot.getGate().close(1L)) continue;
                        for (int j = 0; j < i; ++j) {
                            WorkSlot slotTest = pool.getWorkSlot(j);
                            if (slotTest.getQueue() != queue) continue;
                            slotTest.getGate().open();
                        }
                        slot.add(pool.instantiateWrapperTask(this, false));
                        return;
                    }
                }
                throw new EventDeathException(this.get_Name());
            }
            pool.stopDaemon(this);
        }

        public void scheduleNext() {
            DaemonPool pool = (DaemonPool)this.get_Module();
            int cStop = this.getStopCount() - 1;
            if (cStop > 0) {
                this.setWorkSlot(null);
                this.setQueue(null);
                this.setStopCount(cStop);
                pool.add(this, false);
            } else {
                pool.setInTransition(false);
            }
        }

        public void setQueue(AssociationPile queue) {
            this.__m_Queue = queue;
        }

        public void setStopCount(int nCount) {
            this.__m_StopCount = nCount;
        }

        public void setWorkSlot(WorkSlot slot) {
            this.__m_WorkSlot = slot;
        }

        @Override
        public String toString() {
            return this.get_Name() + " for QueueId=" + System.identityHashCode(this.getQueue()) + "; Count=" + this.getStopCount();
        }
    }

    public static class WorkSlot
    extends Util {
        private boolean __m_Active;
        private Gate __m_Gate;
        private int __m_Index;
        private AssociationPile __m_Queue;

        public WorkSlot() {
            this(null, null, true);
        }

        public WorkSlot(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setIndex(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new WorkSlot();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/DaemonPool$WorkSlot".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public void add(WrapperTask task) {
            Gate gate = this.getGate();
            gate.enter(-1L);
            try {
                this.getQueue().add(task);
            }
            finally {
                gate.exit();
            }
        }

        public Gate getGate() {
            return this.__m_Gate;
        }

        public int getIndex() {
            return this.__m_Index;
        }

        public AssociationPile getQueue() {
            return this.__m_Queue;
        }

        public boolean isActive() {
            return this.__m_Active;
        }

        @Override
        public void onInit() {
            this.setGate(new ThreadGateLite());
            super.onInit();
        }

        public void setActive(boolean fActive) {
            this.__m_Active = fActive;
        }

        protected void setGate(Gate gate) {
            this.__m_Gate = gate;
        }

        public void setIndex(int nIndex) {
            WorkSlot._assert(!this.is_Constructed() || this.getIndex() == -1 && nIndex >= 0, "Must not change");
            this.__m_Index = nIndex;
        }

        public void setQueue(AssociationPile queue) {
            this.__m_Queue = queue;
        }

        @Override
        public String toString() {
            return this.get_Name() + "[" + this.getIndex() + "] QueueId=" + System.identityHashCode(this.getQueue()) + ", PendingJobs=" + this.getQueue().size();
        }
    }

    public static class WrapperTask
    extends Util
    implements Guardable,
    KeyAssociation,
    Runnable {
        private Gate __m_Gate;
        private transient Guardian.GuardContext __m_GuardContext;
        private boolean __m_ManagementTask;
        private transient long __m_PostTime;
        private transient int __m_Priority;
        private transient long __m_StartTime;
        private transient long __m_StopTime;
        private transient Runnable __m_Task;
        private transient long __m_TimeoutMillis;

        public WrapperTask() {
            this(null, null, true);
        }

        public WrapperTask(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new WrapperTask();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/DaemonPool$WrapperTask".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(long ldtTime) {
            WrapperTask wrapperTask = this;
            synchronized (wrapperTask) {
                if (this.getStartTime() > 0L) {
                    WrapperTask._trace("Cannot cancel already started: " + String.valueOf(this), 3);
                    return;
                }
                this.setStartTime(ldtTime);
                this.setStopTime(0L);
                Guardian.GuardContext context = this.getGuardContext();
                if (context != null) {
                    context.release();
                }
            }
            ((DaemonPool)this.get_Module()).runCanceled((PriorityTask)((Object)this.getTask()), false);
        }

        @Override
        public Object getAssociatedKey() {
            Runnable task = this.getTask();
            return task instanceof Associated ? ((Associated)((Object)task)).getAssociatedKey() : null;
        }

        @Override
        public Guardian.GuardContext getContext() {
            return this.getGuardContext();
        }

        public Gate getGate() {
            return this.__m_Gate;
        }

        public Guardian.GuardContext getGuardContext() {
            return this.__m_GuardContext;
        }

        public long getPostTime() {
            return this.__m_PostTime;
        }

        public int getPriority() {
            return this.__m_Priority;
        }

        public long getStartTime() {
            return this.__m_StartTime;
        }

        public long getStopTime() {
            return this.__m_StopTime;
        }

        public Runnable getTask() {
            return this.__m_Task;
        }

        public String getTaskId() {
            Runnable task = this.getTask();
            try {
                return String.valueOf(task);
            }
            catch (RuntimeException e) {
                return task.getClass().getName() + "@" + task.hashCode();
            }
        }

        public long getTimeoutMillis() {
            return this.__m_TimeoutMillis;
        }

        public boolean isManagementTask() {
            return this.__m_ManagementTask;
        }

        @Override
        public void onInit() {
        }

        @Override
        public void recover() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WrapperTask wrapperTask = this;
            synchronized (wrapperTask) {
                long cTimeout;
                Guardian.GuardContext context = this.getGuardContext();
                if (context != null) {
                    context.release();
                    this.setGuardContext(null);
                }
                if (this.getStartTime() > 0L) {
                    return;
                }
                long ldtNow = Base.getSafeTimeMillis();
                this.setStartTime(ldtNow);
                if (this.getStopTime() == 0L && (cTimeout = this.getTimeoutMillis()) > 0L) {
                    this.setStopTime(ldtNow + cTimeout);
                }
            }
            this.run(this.getTask());
        }

        protected void run(Runnable task) {
            task.run();
        }

        @Override
        public void setContext(Guardian.GuardContext context) {
            this.setGuardContext(context);
        }

        public void setGate(Gate gate) {
            this.__m_Gate = gate;
        }

        public void setGuardContext(Guardian.GuardContext task) {
            this.__m_GuardContext = task;
        }

        protected void setManagementTask(boolean fMgmt) {
            this.__m_ManagementTask = fMgmt;
        }

        public void setPostTime(long ldt) {
            this.__m_PostTime = ldt;
        }

        public void setPriority(int iPriority) {
            this.__m_Priority = iPriority;
        }

        protected void setStartTime(long ldt) {
            this.__m_StartTime = ldt;
        }

        public void setStopTime(long ldt) {
            this.__m_StopTime = ldt;
        }

        public void setTask(Runnable task) {
            this.setManagementTask(task instanceof StartTask || task instanceof StopTask);
            this.__m_Task = task;
        }

        public void setTimeoutMillis(long cMillis) {
            this.__m_TimeoutMillis = cMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void terminate() {
            DaemonPool pool = (DaemonPool)this.get_Module();
            Object object = pool.STATS_MONITOR;
            synchronized (object) {
                pool.setStatsTimeoutCount(pool.getStatsTimeoutCount() + 1);
            }
            this.cancel(Base.getSafeTimeMillis());
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Task(").append(this.getTaskId());
            switch (this.getPriority()) {
                case 0: {
                    sb.append(", SCHEDULE_STANDARD");
                    break;
                }
                case 1: {
                    sb.append(", SCHEDULE_FIRST");
                    break;
                }
                case 2: {
                    sb.append(", SCHEDULE_IMMEDIATE");
                }
            }
            long ldtStart = this.getStartTime();
            long ldtStop = this.getStopTime();
            long ldtPost = this.getPostTime();
            long ldtNow = Base.getSafeTimeMillis();
            if (ldtStart > 0L) {
                sb.append(", Running for ").append(ldtNow - ldtStart).append("ms");
            } else if (ldtPost > 0L) {
                sb.append(", Queued for ").append(ldtNow - ldtPost).append("ms");
            }
            if (ldtStop > 0L) {
                long cTimeout = ldtStop - ldtNow;
                if (cTimeout >= 0L) {
                    sb.append(", Timeout in ").append(cTimeout).append("ms");
                } else {
                    sb.append(", Stopping for ").append(-cTimeout).append("ms");
                }
            } else if (this.getTimeoutMillis() > 0L) {
                sb.append(", Not started");
            } else {
                sb.append(", No timeout");
            }
            return sb.toString();
        }
    }
}

