/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.NonBlocking;
import com.oracle.coherence.common.base.Notifier;
import com.oracle.coherence.common.base.SingleWaiterMultiNotifier;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;

public class Daemon
extends Util
implements Guardian,
Runnable {
    private boolean __m_AutoStart;
    private static transient long __s_ClockResolutionMillis;
    public static final int DAEMON_EXITED = 4;
    public static final int DAEMON_EXITING = 3;
    public static final int DAEMON_INITIAL = 0;
    public static final int DAEMON_RUNNING = 2;
    public static final int DAEMON_STARTING = 1;
    private volatile transient int __m_DaemonState;
    private transient float __m_DefaultGuardRecovery;
    private transient long __m_DefaultGuardTimeout;
    private transient boolean __m_Exiting;
    private Object __m_ExitMonitor;
    private Guard __m_Guardable;
    private GuardSupport __m_GuardSupport;
    private transient long __m_IntervalNextMillis;
    private transient Notifier __m_Notifier;
    private int __m_Priority;
    private transient Throwable __m_StartException;
    private transient long __m_StartTimestamp;
    private transient Thread __m_Thread;
    private transient ThreadGroup __m_ThreadGroup;
    private String __m_ThreadName;
    private long __m_WaitMillis;

    private static void _initStatic$Default() {
        Daemon.__initStatic();
    }

    private static void __initStatic() {
        try {
            Daemon.setClockResolutionMillis(1L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public Daemon() {
        this(null, null, true);
    }

    public Daemon(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setNotifier(new SingleWaiterMultiNotifier());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_ExitMonitor = new Object();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public boolean isNonBlocking() {
        return false;
    }

    public static Component get_Instance() {
        return new Daemon();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/Daemon".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    protected void checkGuardables() {
        if (this.isGuardian()) {
            this.getGuardSupport().check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GuardSupport ensureGuardSupport() {
        GuardSupport support = this.getGuardSupport();
        if (support == null) {
            Daemon daemon = this;
            synchronized (daemon) {
                support = this.getGuardSupport();
                if (support == null) {
                    support = new GuardSupport(this);
                    this.setGuardSupport(support);
                }
            }
        }
        return support;
    }

    protected void finalize() throws Throwable {
        try {
            this.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    public static long getClockResolutionMillis() {
        return __s_ClockResolutionMillis;
    }

    public int getDaemonState() {
        return this.__m_DaemonState;
    }

    @Override
    public float getDefaultGuardRecovery() {
        return this.__m_DefaultGuardRecovery;
    }

    @Override
    public long getDefaultGuardTimeout() {
        return this.__m_DefaultGuardTimeout;
    }

    protected Object getExitMonitor() {
        return this.__m_ExitMonitor;
    }

    public Guard getGuardable() {
        return this.__m_Guardable;
    }

    public GuardSupport getGuardSupport() {
        return this.__m_GuardSupport;
    }

    public long getIntervalNextMillis() {
        return this.__m_IntervalNextMillis;
    }

    public Notifier getNotifier() {
        return this.__m_Notifier;
    }

    public int getPriority() {
        return this.__m_Priority;
    }

    public Throwable getStartException() {
        return this.__m_StartException;
    }

    public long getStartTimestamp() {
        return this.__m_StartTimestamp;
    }

    public Thread getThread() {
        return this.__m_Thread;
    }

    public ThreadGroup getThreadGroup() {
        return this.__m_ThreadGroup;
    }

    public String getThreadName() {
        String sName = this.__m_ThreadName;
        return sName == null ? this.get_Name() : sName;
    }

    public long getWaitMillis() {
        return this.__m_WaitMillis;
    }

    @Override
    public Guardian.GuardContext guard(Guardable guardable) {
        return this.guard(guardable, this.getDefaultGuardTimeout(), this.getDefaultGuardRecovery());
    }

    @Override
    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        GuardSupport support = this.ensureGuardSupport();
        support.remove(guardable);
        return cMillis == 0L ? null : support.add(guardable, cMillis, flPctRecover);
    }

    protected void halt() {
        this.setDaemonState(3);
        Thread thread = this.getThread();
        if (thread != null) {
            try {
                thread.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setThread(null);
    }

    protected void heartbeat() {
        this.heartbeat(0L);
    }

    protected void heartbeat(long cMillis) {
        Guardian.GuardContext context;
        Guard guard = this.getGuardable();
        if (guard != null && (context = guard.getContext()) != null) {
            if (cMillis == 0L) {
                context.heartbeat();
            } else {
                context.heartbeat(cMillis);
            }
        }
    }

    protected Thread instantiateThread() {
        Thread thread = Base.makeThread(this.getThreadGroup(), this, this.getThreadName());
        thread.setDaemon(true);
        int nPriority = this.getPriority();
        if (nPriority != 0) {
            thread.setPriority(nPriority);
        }
        return thread;
    }

    public boolean isAutoStart() {
        return this.__m_AutoStart;
    }

    public boolean isExiting() {
        return this.getDaemonState() == 3;
    }

    public boolean isGuarded() {
        Guard guard = this.getGuardable();
        return guard != null && guard.getContext() != null;
    }

    public boolean isGuardian() {
        GuardSupport support = this.getGuardSupport();
        return support != null && support.getGuardableCount() > 0;
    }

    public boolean isStarted() {
        int nState = this.getDaemonState();
        return nState > 0 && nState < 4;
    }

    public boolean join(long cMillis) {
        try {
            Thread thread = this.getThread();
            if (thread != null) {
                thread.join(cMillis);
                return !thread.isAlive();
            }
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    protected void onEnter() {
        this.setStartTimestamp(Base.getSafeTimeMillis());
    }

    protected void onException(Throwable e) {
        if (this.isExiting()) {
            Daemon._trace(this.get_Name() + " caught an unhandled exception (" + e.getClass().getName() + ": " + e.getMessage() + ") while exiting.", 4);
            Daemon._trace(Daemon.getStackTrace(e), 9);
        } else {
            try {
                Daemon._trace("Terminating " + this.get_Name() + " due to unhandled exception: " + e.getClass().getName(), 1);
                Daemon._trace(Daemon.getStackTrace(e), 2);
            }
            finally {
                this.stop();
            }
        }
    }

    protected void onExit() {
        Guardian.GuardContext context;
        Guard guard = this.getGuardable();
        Guardian.GuardContext guardContext = context = guard == null ? null : guard.getContext();
        if (context != null) {
            context.release();
        }
        if (this.isGuardian()) {
            this.getGuardSupport().release();
        }
    }

    @Override
    public void onInit() {
        super.onInit();
        this.setGuardable((Guard)this._findChild("Guard"));
        if (this.isAutoStart()) {
            this.start();
        }
    }

    protected void onInterrupt(InterruptedException e) {
        if (!this.isExiting()) {
            Daemon._trace("Interrupted " + this.get_Name() + ", " + String.valueOf(Thread.currentThread()));
        }
    }

    protected void onInterval() {
        this.heartbeat();
        this.checkGuardables();
    }

    protected void onNotify() {
    }

    protected void onUnexpectedThread() {
        String sMsg;
        Thread threadThis;
        Thread threadDaemon = this.getThread();
        Daemon._assert(threadDaemon != (threadThis = Thread.currentThread()));
        if (System.identityHashCode(threadThis) == System.identityHashCode(threadDaemon) && Base.equals(threadThis.getName(), threadDaemon.getName())) {
            sMsg = "thread identity corruption detected; the running thread " + String.valueOf(threadThis) + " has failed a reference equality check with " + String.valueOf(threadDaemon) + " but matches the daemon's name and identity hash code; this indicates a JVM error.";
            threadThis.setName(new UUID().toString());
            sMsg = Base.equals(threadThis.getName(), threadDaemon.getName()) ? "Positive " + (String)sMsg : (threadThis.getThreadGroup() == threadDaemon.getThreadGroup() ? "Probable " + (String)sMsg : "Possible " + (String)sMsg);
        } else {
            sMsg = "run() invoked on unexpected thread " + String.valueOf(threadThis);
        }
        throw new IllegalStateException(sMsg);
    }

    protected void onWait() throws InterruptedException {
        long cMillis = this.getWaitMillis();
        if (cMillis >= 0L) {
            this.getNotifier().await(cMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Thread.currentThread() != this.getThread()) {
            this.onUnexpectedThread();
        }
        NonBlocking nonBlocking = null;
        try {
            try {
                this.onEnter();
            }
            catch (Throwable e) {
                this.setStartException(e);
                this.setExiting(true);
                this.onException(e);
                try {
                    try {
                        Object object = this.getExitMonitor();
                        synchronized (object) {
                            Thread.interrupted();
                        }
                        if (nonBlocking != null) {
                            nonBlocking.close();
                        }
                        this.onExit();
                    }
                    finally {
                        this.setThread(null);
                        this.setDaemonState(4);
                    }
                }
                catch (Throwable e2) {
                    this.onException(e2);
                }
                return;
            }
            if (this.isNonBlocking()) {
                nonBlocking = new NonBlocking();
            }
            this.setDaemonState(2);
            while (!this.isExiting()) {
                try {
                    this.onWait();
                    if (this.isExiting()) continue;
                    long ldtNow = Base.getSafeTimeMillis();
                    if (ldtNow >= this.getIntervalNextMillis()) {
                        this.onInterval();
                        this.setIntervalNextMillis(ldtNow + Math.min(1000L, this.getWaitMillis()));
                    }
                    this.onNotify();
                }
                catch (EventDeathException ldtNow) {
                }
                catch (InterruptedException e) {
                    this.onInterrupt(e);
                }
                catch (Throwable e) {
                    this.onException(e);
                }
            }
        }
        finally {
            try {
                try {
                    Object object = this.getExitMonitor();
                    synchronized (object) {
                        Thread.interrupted();
                    }
                    if (nonBlocking != null) {
                        nonBlocking.close();
                    }
                    this.onExit();
                }
                finally {
                    this.setThread(null);
                    this.setDaemonState(4);
                }
            }
            catch (Throwable e) {
                this.onException(e);
            }
        }
    }

    public void setAutoStart(boolean fAutoStart) {
        this.__m_AutoStart = fAutoStart;
    }

    protected static void setClockResolutionMillis(long cMillis) {
        __s_ClockResolutionMillis = Math.max(1L, cMillis);
    }

    protected synchronized void setDaemonState(int nState) {
        if (nState > this.getDaemonState()) {
            this.__m_DaemonState = nState;
            this.notifyAll();
        }
    }

    public void setDefaultGuardRecovery(float flPctRecover) {
        this.__m_DefaultGuardRecovery = flPctRecover;
    }

    public void setDefaultGuardTimeout(long cTimeoutMillis) {
        this.__m_DefaultGuardTimeout = cTimeoutMillis;
    }

    protected void setExiting(boolean fExiting) {
        this.setDaemonState(3);
    }

    private void setExitMonitor(Object oMonitor) {
        this.__m_ExitMonitor = oMonitor;
    }

    protected void setGuardable(Guard guardable) {
        this.__m_Guardable = guardable;
    }

    protected void setGuardSupport(GuardSupport guardSupport) {
        this.__m_GuardSupport = guardSupport;
    }

    protected void setIntervalNextMillis(long ldtNext) {
        this.__m_IntervalNextMillis = ldtNext;
    }

    protected void setNotifier(Notifier notifier) {
        this.__m_Notifier = notifier;
    }

    public void setPriority(int nPriority) {
        this.__m_Priority = nPriority;
    }

    public void setStartException(Throwable e) {
        this.__m_StartException = e;
    }

    protected void setStartTimestamp(long lMillis) {
        this.__m_StartTimestamp = lMillis;
    }

    protected void setThread(Thread thread) {
        this.__m_Thread = thread;
    }

    public void setThreadGroup(ThreadGroup group) {
        this.__m_ThreadGroup = group;
    }

    public void setThreadName(String sName) {
        this.__m_ThreadName = sName;
    }

    public void setWaitMillis(long cMillis) {
        this.__m_WaitMillis = cMillis;
    }

    public static boolean sleep(long lMillis) {
        try {
            if (lMillis == 0L) {
                Thread.yield();
            } else {
                Blocking.sleep(lMillis);
            }
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.getDaemonState() == 4) {
            throw new IllegalStateException("Daemon is not restartable");
        }
        Thread thread = this.instantiateThread();
        this.setThread(thread);
        this.setStartException(null);
        this.setDaemonState(1);
        thread.start();
        try {
            do {
                Blocking.wait(this, 1000L);
            } while (this.getDaemonState() < 2 && thread.isAlive());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WrapperException(e);
        }
        Throwable e = this.getStartException();
        if (e != null) {
            this.setStartException(null);
            throw new WrapperException(e);
        }
        if (this.getDaemonState() == 1) {
            throw new IllegalStateException("daemon thread start failed: " + String.valueOf(thread));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.getExitMonitor();
        synchronized (object) {
            if (!this.isExiting()) {
                this.setExiting(true);
                Thread thread = this.getThread();
                if (thread != null && thread != Thread.currentThread()) {
                    try {
                        thread.interrupt();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static {
        Daemon._initStatic$Default();
        try {
            String sMillis = Config.getProperty("coherence.clock_resolution");
            if (sMillis == null) {
                String sOS = System.getProperty("os.name", "");
                if (sOS.contains("Windows")) {
                    if (Runtime.getRuntime().availableProcessors() > 1) {
                        Daemon.setClockResolutionMillis(16L);
                    } else {
                        Daemon.setClockResolutionMillis(10L);
                    }
                } else {
                    Daemon.setClockResolutionMillis(20L);
                }
            } else {
                Daemon.setClockResolutionMillis(Integer.parseInt(sMillis));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Guard
    extends Component
    implements Guardable {
        private Guardian.GuardContext __m_Context;

        public Guard() {
            this(null, null, true);
        }

        public Guard(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Guard();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/Daemon$Guard".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Guardian.GuardContext getContext() {
            return this.__m_Context;
        }

        public String getTimeoutDescription() {
            return null;
        }

        @Override
        public void recover() {
            Daemon daemon = (Daemon)this.get_Parent();
            Thread thread = daemon.getThread();
            if (thread != null) {
                thread.interrupt();
            }
        }

        @Override
        public void setContext(Guardian.GuardContext context) {
            this.__m_Context = context;
        }

        @Override
        public void terminate() {
        }

        @Override
        public String toString() {
            Object sCause = this.getTimeoutDescription();
            sCause = sCause == null ? "" : " " + (String)sCause;
            return this.get_Name() + "{Daemon=" + ((Daemon)this.get_Parent()).getThreadName() + "}" + (String)sCause;
        }
    }
}

