/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Application;
import com.tangosol.coherence.component.Util;
import com.tangosol.util.WrapperException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class Config
extends Util {
    private Properties __m__Properties;
    private char __m_ArrayDelimiter;
    public static final String CONFIG_DIRECTORY = "/META-INF";
    public static final String CONFIG_EXTENSION = ".properties";

    public Config() {
        this(null, null, true);
    }

    public Config(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setArrayDelimiter(':');
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m__Properties = new Properties();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public static Component get_Instance() {
        return new Config();
    }

    public static Class get_CLASS() {
        return Config.class;
    }

    private Component get_Module() {
        return this;
    }

    public void clear() {
        this.get_Properties().clear();
    }

    public boolean containsKey(String sKey) {
        return this.get_Properties().containsKey(sKey);
    }

    public static String decodePath(String sPath) {
        int ofEnd;
        int ofStart;
        while ((ofStart = ((String)sPath).indexOf(123)) >= 0 && (ofEnd = ((String)sPath).indexOf(125, ofStart)) > ofStart) {
            String sProp = ((String)sPath).substring(ofStart + 1, ofEnd);
            String sVal = System.getProperty(sProp, "");
            sPath = ((String)sPath).substring(0, ofStart) + sVal + ((String)sPath).substring(ofEnd + 1);
        }
        return sPath;
    }

    public static String encodePath(String sPath, String[] asEnv) {
        for (String sEnv : asEnv) {
            int of;
            String sVal = System.getProperty(sEnv);
            int n = of = sVal == null || sVal.length() == 0 ? -1 : ((String)sPath).indexOf(sVal);
            if (of == -1) continue;
            sPath = ((String)sPath).substring(0, of) + "{" + sEnv + "}" + ((String)sPath).substring(of + sVal.length() + 1);
        }
        return sPath;
    }

    private Properties get_Properties() {
        return this.__m__Properties;
    }

    public char getArrayDelimiter() {
        return this.__m_ArrayDelimiter;
    }

    public boolean getBoolean(String sKey) {
        return this.getBoolean(sKey, false);
    }

    public boolean getBoolean(String sKey, boolean fDefaultValue) {
        String sValue = this.get_Properties().getProperty(sKey);
        return sValue != null ? Boolean.valueOf(sValue) : fDefaultValue;
    }

    public Config getConfig(String sKey) {
        Config config = new Config();
        Properties propThis = this.get_Properties();
        Properties propThat = config.get_Properties();
        Enumeration<Object> e = propThis.keys();
        while (e.hasMoreElements()) {
            String sKeyThis = (String)e.nextElement();
            if (!sKeyThis.startsWith(sKey)) continue;
            String sKeyThat = sKeyThis.substring(sKey.length());
            propThat.setProperty(sKeyThat, propThis.getProperty(sKeyThis));
        }
        return config;
    }

    public int getInt(String sKey) {
        return this.getInt(sKey, 0);
    }

    public int getInt(String sKey, int iDefaultValue) {
        String sValue = this.get_Properties().getProperty(sKey);
        if (sValue != null) {
            try {
                return Integer.parseInt(sValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return iDefaultValue;
    }

    public int[] getIntArray(String sKey) {
        String sValue = this.get_Properties().getProperty(sKey);
        if (sValue != null && sValue.length() > 0) {
            char cDelim = this.getArrayDelimiter();
            char[] ach = sValue.toCharArray();
            int cnt = 1;
            for (int of = 0; of < ach.length; ++of) {
                if (ach[of] != cDelim) continue;
                ++cnt;
            }
            int[] aInt = new int[cnt];
            try {
                int ix = 0;
                int ofStart = 0;
                for (int of = 0; of < ach.length; ++of) {
                    if (ach[of] != cDelim) continue;
                    aInt[ix++] = Integer.parseInt(new String(ach, ofStart, of - ofStart));
                    ofStart = of + 1;
                }
                aInt[ix] = Integer.parseInt(new String(ach, ofStart, ach.length - ofStart));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return aInt;
        }
        return new int[0];
    }

    public String getString(String sKey) {
        return this.get_Properties().getProperty(sKey);
    }

    public String getString(String sKey, String sDefaultValue) {
        return this.get_Properties().getProperty(sKey, sDefaultValue);
    }

    public String[] getStringArray(String sKey) {
        String sValue = this.get_Properties().getProperty(sKey);
        if (sValue != null && sValue.length() > 0) {
            char cDelim = this.getArrayDelimiter();
            char[] ach = sValue.toCharArray();
            int cnt = 1;
            for (int of = 0; of < ach.length; ++of) {
                if (ach[of] != cDelim) continue;
                ++cnt;
            }
            String[] aString = new String[cnt];
            int ix = 0;
            int ofStart = 0;
            for (int of = 0; of < ach.length; ++of) {
                if (ach[of] != cDelim) continue;
                aString[ix++] = new String(ach, ofStart, of - ofStart);
                ofStart = of + 1;
            }
            aString[ix] = new String(ach, ofStart, ach.length - ofStart);
            return aString;
        }
        return new String[0];
    }

    public String[] getStringArray(String sKey, char cDelim) {
        char cDelimOrig = this.getArrayDelimiter();
        this.setArrayDelimiter(cDelim);
        String[] asResult = this.getStringArray(sKey);
        this.setArrayDelimiter(cDelimOrig);
        return asResult;
    }

    public boolean isEmpty() {
        return this.get_Properties().isEmpty();
    }

    public Enumeration keys() {
        return this.get_Properties().keys();
    }

    public void list() {
        this.list(new PrintWriter(System.out));
    }

    public void list(PrintWriter writer) {
        this.get_Properties().list(writer);
        writer.flush();
    }

    public void load(InputStream inStream) throws IOException {
        this.get_Properties().load(inStream);
    }

    public void load(String sName) {
        InputStream in;
        block15: {
            String sFile;
            String sPath;
            Application app = (Application)Application.get_Instance();
            if ((sName.startsWith("/") || (in = app.getResourceAsStream(sPath = Config.resolvePath(sName))) == null) && (in = app.getResourceAsStream(sFile = Config.resolveName(sName))) == null) {
                block16: {
                    File file;
                    String sDir2;
                    block14: {
                        try {
                            sDir2 = app.getProperty("user.home");
                            if (sDir2 == null || sDir2.length() <= 0 || !(file = new File(sDir2, sFile)).isFile() || !file.exists() || !file.canRead()) break block14;
                            in = new FileInputStream(file);
                            break block15;
                        }
                        catch (SecurityException sDir2) {
                        }
                        catch (IOException sDir2) {
                            // empty catch block
                        }
                    }
                    try {
                        sDir2 = app.getProperty("user.dir");
                        if (sDir2 == null || sDir2.length() <= 0 || !(file = new File(sDir2, sFile)).isFile() || !file.exists() || !file.canRead()) break block16;
                        in = new FileInputStream(file);
                        break block15;
                    }
                    catch (SecurityException sDir3) {
                    }
                    catch (IOException sDir3) {
                        // empty catch block
                    }
                }
                try {
                    File file = new File("", sFile);
                    if (file.isFile() && file.exists() && file.canRead()) {
                        in = new FileInputStream(file);
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (in != null) {
            try {
                this.load(in);
            }
            catch (IOException e) {
                Config._trace("Exception loading configuration: " + sName);
                Config._trace(e);
            }
        }
    }

    public void putBoolean(String sKey, boolean fValue) {
        this.get_Properties().setProperty(sKey, String.valueOf(fValue));
    }

    public void putConfig(String sKey, Config config) {
        this.remove(sKey);
        String sPrefix = sKey + ".";
        Iterator<Object> iter = this.get_Properties().keySet().iterator();
        while (iter.hasNext()) {
            String sEachKey = (String)iter.next();
            if (!sEachKey.startsWith(sPrefix)) continue;
            iter.remove();
        }
        if (config != null && !config.isEmpty()) {
            Properties propThis = this.get_Properties();
            Properties propThat = config.get_Properties();
            Enumeration<Object> e = propThat.keys();
            while (e.hasMoreElements()) {
                String sKeyThat = (String)e.nextElement();
                propThis.setProperty(sKey + sKeyThat, propThat.getProperty(sKeyThat));
            }
        }
    }

    public void putInt(String sKey, int iValue) {
        this.get_Properties().setProperty(sKey, String.valueOf(iValue));
    }

    public void putIntArray(String sKey, int[] aiValue) {
        if (aiValue == null) {
            this.remove(sKey);
        } else {
            char cDelim = this.getArrayDelimiter();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < aiValue.length; ++i) {
                if (i > 0) {
                    sb.append(cDelim);
                }
                sb.append(aiValue[i]);
            }
            this.get_Properties().setProperty(sKey, sb.toString());
        }
    }

    public void putString(String sKey, String sValue) {
        if (sValue == null) {
            this.remove(sKey);
        } else {
            this.get_Properties().setProperty(sKey, sValue);
        }
    }

    public void putStringArray(String sKey, String[] asValue) {
        if (asValue == null) {
            this.remove(sKey);
        } else {
            char cDelim = this.getArrayDelimiter();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < asValue.length; ++i) {
                if (i > 0) {
                    sb.append(cDelim);
                }
                sb.append(asValue[i]);
            }
            this.get_Properties().setProperty(sKey, sb.toString());
        }
    }

    public void putStringArray(String sKey, String[] asValue, char cDelim) {
        char cDelimOrig = this.getArrayDelimiter();
        this.setArrayDelimiter(cDelim);
        this.putStringArray(sKey, asValue);
        this.setArrayDelimiter(cDelimOrig);
    }

    public void remove(String sName) {
        this.get_Properties().remove(sName);
    }

    public static String resolveName(String sName) {
        return sName.startsWith("/") ? sName : "/" + sName + CONFIG_EXTENSION;
    }

    public static String resolvePath(String sName) {
        return sName.startsWith("/") ? sName : CONFIG_DIRECTORY + Config.resolveName(sName);
    }

    private void set_Properties(Properties p_Properties) {
        this.__m__Properties = p_Properties;
    }

    public void setArrayDelimiter(char pArrayDelimiter) {
        this.__m_ArrayDelimiter = pArrayDelimiter;
    }

    public void store(OutputStream outStream, String sHeader) throws IOException {
        this.get_Properties().store(outStream, sHeader);
    }

    @Override
    public String toString() {
        return this.get_Properties().toString();
    }
}

