/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.application.ContainerHelper;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.message.CacheMessage;
import com.tangosol.coherence.component.util.CacheEvent;
import com.tangosol.coherence.component.util.TransactionValidator;
import com.tangosol.coherence.component.util.collections.WrapperSet;
import com.tangosol.coherence.component.util.collections.wrapperSet.EntrySet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ReplicatedCache;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.io.AbstractWriteBuffer;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.OverflowMap;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableHashMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.InKeySetFilter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CacheHandler
extends Util
implements ClassLoaderAware,
NamedCache,
XmlSerializable,
Converter {
    private transient MapListener __m_BackingMapListener;
    private int __m_CacheIndex;
    private String __m_CacheName;
    private transient ClassLoader __m_ClassLoader;
    private transient Converter __m_ConverterFromInternal;
    private transient Converter __m_ConverterToInternal;
    private Listeners __m_DeactivationListeners;
    private transient Object __m_IgnoreKey;
    private transient Map __m_IndexMap;
    private transient Map __m_LeaseMap;
    private transient MapListenerSupport __m_ListenerSupport;
    public static final int MAX_MAP_RETRIES = 32;
    private transient CacheHandler __m_NextHandler;
    private boolean __m_PutExpiryWarned;
    private transient Map __m_ResourceMap;
    private transient Serializer __m_Serializer;
    private long __m_StandardLeaseMillis;
    private boolean __m_UseEventDaemon;
    private boolean __m_Valid;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("BackingMapListener", BackingMapListener.get_CLASS());
        __mapChildren.put("EntrySet", EntrySet.get_CLASS());
        __mapChildren.put("KeySet", KeySet.get_CLASS());
        __mapChildren.put("Validator", Validator.get_CLASS());
    }

    public CacheHandler() {
        this(null, null, true);
    }

    public CacheHandler(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setCacheIndex(-1);
            this.setDeactivationListeners(new Listeners());
            this.setIgnoreKey(new Object());
            this.setPutExpiryWarned(false);
            this.setStandardLeaseMillis(20000L);
            this.setUseEventDaemon(true);
            this.setValid(true);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new CacheHandler();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/CacheHandler".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        InvocableMapHelper.addIndex(extractor, fOrdered, comparator, this, this.ensureIndexMap());
    }

    @Override
    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, (Filter)null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        if (listener instanceof NamedCacheDeactivationListener) {
            this.getDeactivationListeners().add(listener);
            return;
        } else {
            CacheHandler._assert(listener != null);
            MapListenerSupport support = this.getListenerSupport();
            if (support == null) {
                support = new MapListenerSupport();
                this.setListenerSupport(support);
            }
            if (MapListenerSupport.isPrimingListener(listener)) {
                if (!(filter instanceof InKeySetFilter)) throw new UnsupportedOperationException("Priming listeners are only supported with InKeySetFilter");
                Set<?> colKeys = ((InKeySetFilter)filter).getKeys();
                Iterator iter = colKeys.iterator();
                while (iter.hasNext()) {
                    this.addMapListener(listener, iter.next(), fLite);
                }
                return;
            } else {
                support.addListener(this.wrap(listener), filter, fLite);
            }
        }
    }

    @Override
    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        CacheHandler._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(this.wrap(listener), oKey, fLite);
    }

    @Override
    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.aggregate((Collection)this.keySet(filter), agent);
    }

    @Override
    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return agent.aggregate(InvocableMapHelper.makeEntrySet(this, collKeys, true));
    }

    protected void checkAccess() {
        if (Thread.currentThread() != this.getService().getThread() && !this.isValid()) {
            throw new IllegalStateException("Map has been invalidated:\n" + String.valueOf(this));
        }
    }

    @Override
    public void clear() {
        Enumeration e = this.getResourceKeys();
        while (e.hasMoreElements()) {
            Object oKey = e.nextElement();
            this.remove(oKey, false);
        }
    }

    @Override
    public boolean containsKey(Object oKey) {
        this.checkAccess();
        return this.getResourceMap().containsKey(oKey);
    }

    @Override
    public boolean containsValue(Object oValue) {
        this.checkAccess();
        Map mapResource = this.getResourceMap();
        return mapResource.containsValue(oValue) || mapResource.containsValue(ExternalizableHelper.toBinary(oValue, this.getSerializer()));
    }

    @Override
    public Object convert(Object o) {
        return this.getCachedResource(o);
    }

    @Override
    public void destroy() {
        this.getCacheService().destroyCache(this);
    }

    protected void dispatchEvent(MapEvent event) {
        if (event != null) {
            CacheHandler handler = this;
            do {
                MapListenerSupport support;
                if ((support = handler.getListenerSupport()) == null) continue;
                handler.dispatchEvent(event, support);
            } while ((handler = handler.getNextHandler()) != null);
        }
    }

    public void dispatchEvent(MapEvent event, MapListenerSupport support) {
        event = MapListenerSupport.convertEvent(event, this, null, this.getConverterFromInternal());
        if (this.isUseEventDaemon()) {
            Listeners listeners = support.collectListeners(event);
            CacheEvent.dispatchSafe(MapListenerSupport.enrichEvent(event, listeners), listeners, this.getService().ensureEventDispatcher().getQueue());
        } else {
            support.fireEvent(event, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map ensureIndexMap() {
        SafeHashMap mapIndex = this.getIndexMap();
        if (mapIndex == null) {
            CacheHandler cacheHandler = this;
            synchronized (cacheHandler) {
                mapIndex = this.getIndexMap();
                if (mapIndex == null) {
                    mapIndex = new SafeHashMap();
                    this.setIndexMap(mapIndex);
                }
            }
        }
        return mapIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lease ensureLease(Object oKey) {
        Lease lease = this.getLease(oKey);
        if (lease == null) {
            Map mapLease;
            Map map = mapLease = this.getLeaseMap();
            synchronized (map) {
                lease = this.getLease(oKey);
                if (lease == null) {
                    lease = Lease.instantiate(this.getCacheIndex(), oKey, this.getService());
                    mapLease.put(oKey, lease);
                }
            }
        }
        return lease;
    }

    @Override
    public Set entrySet() {
        this.checkAccess();
        EntrySet set = (EntrySet)this._newChild("EntrySet");
        set.setMap(this);
        set.setSet(this.getResourceMap().entrySet());
        return set;
    }

    @Override
    public Set entrySet(Filter filter) {
        return InvocableMapHelper.query(this, this.getIndexMap(), filter, true, false, null);
    }

    @Override
    public Set entrySet(Filter filter, Comparator comparator) {
        return InvocableMapHelper.query(this, this.getIndexMap(), filter, true, true, comparator);
    }

    @Override
    public void fromXml(XmlElement xml) {
        CacheHandler._assert(xml.getName().equals(this.get_Name()));
        this.setCacheName(xml.getElement("CacheName").getString());
        this.setCacheIndex(xml.getElement("CacheIndex").getInt());
        this.setStandardLeaseMillis(xml.getElement("StandardLeaseMillis").getLong());
    }

    @Override
    public Object get(Object oKey) {
        return this.getCachedResource(oKey);
    }

    @Override
    public Map getAll(Collection colKeys) {
        HashMap mapResult = new HashMap(colKeys.size());
        for (Object oKey : colKeys) {
            Object oVal = this.get(oKey);
            if (oVal == null && !this.containsKey(oKey)) continue;
            mapResult.put(oKey, oVal);
        }
        return mapResult;
    }

    protected MapListener getBackingMapListener() {
        return this.__m_BackingMapListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedResource(Object oKey) {
        ClassLoader loaderResource;
        Object oResource;
        this.checkAccess();
        boolean fNew = false;
        Map mapResource = this.getResourceMap();
        Lease lease = this.getLease(oKey);
        if (lease == null) {
            if (!mapResource.containsKey(oKey)) {
                return null;
            }
            lease = this.ensureLease(oKey);
            fNew = true;
        }
        Lease lease2 = lease;
        synchronized (lease2) {
            oResource = mapResource.get(oKey);
            loaderResource = lease.getClassLoader();
            if (fNew) {
                lease.incrementResourceVersion();
            }
        }
        ClassLoader loaderCache = this.getClassLoader();
        if (loaderResource != null && loaderResource != loaderCache) {
            oResource = this.releaseClassLoader(lease);
        }
        if (oResource instanceof Binary) {
            Binary binValue = (Binary)oResource;
            try {
                oResource = this.getConverterFromInternal().convert(binValue);
            }
            catch (WrapperException e) {
                throw new WrapperException(e.getOriginalException(), "CacheName=" + this.getCacheName() + ", Key=" + String.valueOf(oKey));
            }
            Lease lease3 = lease;
            synchronized (lease3) {
                if (binValue == mapResource.get(oKey)) {
                    lease.setClassLoader(loaderCache);
                    lease.setResourceSize(binValue.length());
                    mapResource.put(oKey, oResource);
                }
            }
        }
        return oResource;
    }

    public int getCacheIndex() {
        return this.__m_CacheIndex;
    }

    @Override
    public String getCacheName() {
        return this.__m_CacheName;
    }

    @Override
    public CacheService getCacheService() {
        return this.getService();
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Converter getConverterFromInternal() {
        Converter conv = this.__m_ConverterFromInternal;
        if (conv == null) {
            CacheHandler cacheHandler = this;
            synchronized (cacheHandler) {
                conv = this.__m_ConverterFromInternal;
                if (conv == null) {
                    ClassLoader loader = this.getClassLoader();
                    conv = loader == NullImplementation.getClassLoader() ? NullImplementation.getConverter() : this.getService().instantiateConverterFromInternal(loader);
                    this.setConverterFromInternal(conv);
                }
            }
        }
        return conv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Converter getConverterToInternal() {
        Converter conv = this.__m_ConverterToInternal;
        if (conv == null) {
            CacheHandler cacheHandler = this;
            synchronized (cacheHandler) {
                conv = this.__m_ConverterToInternal;
                if (conv == null) {
                    ClassLoader loader = this.getClassLoader();
                    conv = loader == NullImplementation.getClassLoader() ? NullImplementation.getConverter() : this.getService().instantiateConverterToInternal(loader);
                    this.setConverterToInternal(conv);
                }
            }
        }
        return conv;
    }

    public Listeners getDeactivationListeners() {
        return this.__m_DeactivationListeners;
    }

    public Object getIgnoreKey() {
        return this.__m_IgnoreKey;
    }

    public Map getIndexMap() {
        return this.__m_IndexMap;
    }

    public Lease getLease(Object oKey) {
        return (Lease)this.getLeaseMap().get(oKey);
    }

    public Enumeration getLeaseKeys() {
        return new SimpleEnumerator<Object>(this.getLeaseMap().keySet().toArray());
    }

    public Map getLeaseMap() {
        return this.__m_LeaseMap;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public Object getLockedResource(Object oKey) {
        this.checkAccess();
        if (this.getService().lockResource(this, oKey, this.getStandardLeaseMillis(), -1L)) {
            return this.getCachedResource(oKey);
        }
        throw new IllegalStateException();
    }

    public CacheHandler getNextHandler() {
        return this.__m_NextHandler;
    }

    public Enumeration getResourceKeys() {
        return new SimpleEnumerator<Object>(this.getResourceMap().keySet().toArray());
    }

    public Map getResourceMap() {
        return this.__m_ResourceMap;
    }

    public Serializer getSerializer() {
        return this.__m_Serializer;
    }

    @Override
    public ReplicatedCache getService() {
        return (ReplicatedCache)this.get_Parent();
    }

    public long getStandardLeaseMillis() {
        return this.__m_StandardLeaseMillis;
    }

    public TransactionMap.Validator getValidator() {
        return (Validator)this._newChild("Validator");
    }

    protected boolean hasListeners() {
        CacheHandler handler = this;
        do {
            MapListenerSupport support;
            if ((support = handler.getListenerSupport()) == null) continue;
            return true;
        } while ((handler = handler.getNextHandler()) != null);
        return false;
    }

    private Map instantiateBackingMap(BackingMapManager manager, String sName) {
        Map map = null;
        try {
            map = manager.instantiateBackingMap(sName);
            if (map == null) {
                CacheHandler._trace("BackingMapManager " + manager.getClass().getName() + ": returned \"null\" for a cache: " + sName, 1);
            } else if (!map.isEmpty()) {
                map.clear();
            }
        }
        catch (RuntimeException e) {
            CacheHandler._trace("BackingMapManager " + manager.getClass().getName() + ": failed to instantiate a cache: " + sName, 1);
            CacheHandler._trace(e);
        }
        if (map instanceof ObservableMap) {
            ((ObservableMap)map).addMapListener(this.instantiateBackingMapListener());
        }
        return map;
    }

    protected MapListener instantiateBackingMapListener() {
        BackingMapListener listener = (BackingMapListener)this._newChild("BackingMapListener");
        this.setBackingMapListener(listener);
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        CacheHandler cacheHandler = this;
        synchronized (cacheHandler) {
            String sName;
            BackingMapManager manager;
            if (!this.isValid()) {
                return;
            }
            Map mapResource = this.getResourceMap();
            MapListener listener = this.getBackingMapListener();
            if (listener != null) {
                ((ObservableMap)mapResource).removeMapListener(listener);
                this.setBackingMapListener(null);
            }
            if ((manager = this.getService().getBackingMapManager()) != null && (sName = this.getCacheName()) != null) {
                try {
                    manager.releaseBackingMap(sName, mapResource);
                }
                catch (RuntimeException e) {
                    CacheHandler._trace("BackingMapManager " + manager.getClass().getName() + ": failed to release a cache: " + sName, 1);
                    CacheHandler._trace(e);
                }
            }
            this.setClassLoader(null);
            this.setListenerSupport(null);
            this.setConverterFromInternal(null);
            this.setConverterToInternal(null);
            this.getLeaseMap().clear();
            this.setResourceMap(new SafeHashMap());
            this.setValid(false);
        }
        Listeners listeners = this.getDeactivationListeners();
        if (!listeners.isEmpty()) {
            com.tangosol.net.cache.CacheEvent<Object, Object> evt = new com.tangosol.net.cache.CacheEvent<Object, Object>(this, 3, null, null, null, true);
            CacheEvent.dispatchSafe(evt, listeners, null);
        }
    }

    @Override
    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeLocked(this, InvocableMapHelper.makeEntry(this, oKey), agent);
    }

    @Override
    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.invokeAll((Collection)this.keySet(filter), agent);
    }

    @Override
    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.makeEntrySet(this, collKeys, false), agent);
    }

    @Override
    public boolean isActive() {
        return this.getClassLoader() != null;
    }

    @Override
    public boolean isEmpty() {
        this.checkAccess();
        return this.getResourceMap().isEmpty();
    }

    public boolean isPutExpiryWarned() {
        return this.__m_PutExpiryWarned;
    }

    public boolean isUseEventDaemon() {
        return this.__m_UseEventDaemon;
    }

    public boolean isValid() {
        return this.__m_Valid;
    }

    @Override
    public Set keySet() {
        this.checkAccess();
        KeySet set = (KeySet)this._newChild("KeySet");
        set.setMap(this);
        set.setSet(this.getResourceMap().keySet());
        return set;
    }

    @Override
    public Set keySet(Filter filter) {
        return InvocableMapHelper.query(this, this.getIndexMap(), filter, false, false, null);
    }

    @Override
    public boolean lock(Object oKey) {
        this.checkAccess();
        return this.getService().lockResource(this, oKey, this.getStandardLeaseMillis(), 0L);
    }

    @Override
    public boolean lock(Object oKey, long cWait) {
        this.checkAccess();
        return this.getService().lockResource(this, oKey, this.getStandardLeaseMillis(), cWait);
    }

    public void onFarewell(Member member) {
        Enumeration e = this.getLeaseKeys();
        while (e.hasMoreElements()) {
            Object oKey = e.nextElement();
            Lease lease = this.getLease(oKey);
            if (lease == null) continue;
            this.validateLease(lease);
        }
    }

    @Override
    public void onInit() {
        super.onInit();
        if (this.getLeaseMap() == null) {
            Map mapLease;
            int nGraveyardSize = this.getService().getReplicatedCacheDependencies().getGraveyardSize();
            if (nGraveyardSize > 0) {
                ObservableHashMap mapFront = new ObservableHashMap();
                LocalCache mapBack = new LocalCache(nGraveyardSize, 0);
                mapBack.setEvictionType(1);
                mapLease = new OverflowMap(mapFront, mapBack);
            } else {
                mapLease = new SafeHashMap();
            }
            this.setLeaseMap(mapLease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeaseRemove(Lease lease) {
        Object oKey = lease.getResourceKey();
        Lease leaseCurrent = this.getLease(oKey);
        if (leaseCurrent == null) {
            return;
        }
        int iCompare = leaseCurrent.compareTo(lease);
        if (iCompare >= 0) {
            CacheHandler._trace("Rejected remove: " + String.valueOf(leaseCurrent) + "\n by " + String.valueOf(lease), 4);
            throw new EventDeathException();
        }
        MapEvent<Object, Object> event = null;
        Lease lease2 = leaseCurrent;
        synchronized (lease2) {
            Object oValueOld;
            CacheHandler handlerNext;
            boolean fNotify = this.isActive() && this.hasListeners() && this.containsKey(oKey);
            CacheHandler handlerBase = this;
            while ((handlerNext = handlerBase.getNextHandler()) != null) {
                handlerBase = handlerNext;
            }
            handlerBase.setIgnoreKey(oKey);
            try {
                oValueOld = this.getResourceMap().remove(oKey);
            }
            finally {
                handlerBase.setIgnoreKey(this);
            }
            if (fNotify) {
                event = new MapEvent<Object, Object>(this, 3, oKey, oValueOld, null);
            }
            if (leaseCurrent.getStatus() == 2) {
                this.terminateLease(oKey);
            }
        }
        if (event != null) {
            this.dispatchEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeaseUpdate(Lease lease, boolean fUpdateResource, Object oValue, long cExpiryMillis) {
        Object oKey = lease.getResourceKey();
        Lease leaseCurrent = this.ensureLease(oKey);
        int iCompare = leaseCurrent.compareTo(lease);
        if (iCompare >= 0) {
            CacheHandler._trace("Rejected update: " + String.valueOf(leaseCurrent) + "\n by " + String.valueOf(lease), 4);
            throw new EventDeathException();
        }
        MapEvent<Object, Object> event = null;
        Lease lease2 = leaseCurrent;
        synchronized (lease2) {
            leaseCurrent.copyFrom(lease);
            Map mapResource = this.getResourceMap();
            if (fUpdateResource) {
                Object oValueOld;
                int nEventId = 0;
                if (this.isActive() && this.hasListeners()) {
                    nEventId = this.containsKey(oKey) ? 2 : 1;
                }
                leaseCurrent.setClassLoader(oValue instanceof Binary ? null : this.getClassLoader());
                if (mapResource instanceof CacheMap) {
                    oValueOld = ((CacheMap)mapResource).put(oKey, oValue, cExpiryMillis);
                } else {
                    if (cExpiryMillis > 0L) {
                        CacheHandler._trace("UnsupportedOperation: class \"" + mapResource.getClass().getName() + "\" does not implement CacheMap interface", 1);
                    }
                    oValueOld = mapResource.put(oKey, oValue);
                }
                if (nEventId > 0) {
                    event = new MapEvent<Object, Object>(this, nEventId, oKey, oValueOld, oValue);
                }
            } else if (leaseCurrent.getStatus() == 2 && !mapResource.containsKey(oKey)) {
                this.terminateLease(oKey);
            }
        }
        if (event != null) {
            this.dispatchEvent(event);
        }
    }

    public void populateCache(CacheMessage msg) {
        ReplicatedCache service = this.getService();
        int iCache = this.getCacheIndex();
        int cLease = msg.getLeaseCount();
        ReadBuffer.BufferInput input = new ByteArrayReadBuffer(msg.getCacheData()).getBufferInput();
        for (int i = 0; i < cLease; ++i) {
            try {
                Object oKey = msg.readObject(input);
                Lease lease = Lease.instantiate(iCache, oKey, service);
                lease.read(input);
                Binary binResource = (Binary)msg.readObject(input);
                if (binResource == null) {
                    this.onLeaseUpdate(lease, false, null, 0L);
                    continue;
                }
                lease.setResourceSize(binResource.length());
                this.onLeaseUpdate(lease, true, binResource, 0L);
                continue;
            }
            catch (EventDeathException e) {
                continue;
            }
            catch (IOException e) {
                CacheHandler._trace("An exception (" + String.valueOf(e) + ") occurred while populating cache: " + String.valueOf(this), 1);
                CacheHandler._trace(e);
                break;
            }
        }
    }

    public Enumeration populateUpdateMessage(CacheMessage msg, int cbSize, Enumeration enumLeaseKeys) {
        ReplicatedCache service = this.getService();
        int nThisId = service.getThisMember().getId();
        int nOldestId = service.getServiceOldestMember().getId();
        Serializer serializer = this.getSerializer();
        Map mapResource = this.getResourceMap();
        ByteArrayOutputStream streamBytes = new ByteArrayOutputStream(1024);
        DataOutputStream streamData = new DataOutputStream(streamBytes);
        AbstractWriteBuffer resBytes = null;
        WriteBuffer.BufferOutput output = null;
        int cLease = 0;
        if (enumLeaseKeys == null) {
            enumLeaseKeys = this.getLeaseKeys();
        }
        while (enumLeaseKeys.hasMoreElements()) {
            Object oKey = enumLeaseKeys.nextElement();
            Lease lease = this.getLease(oKey);
            if (lease == null) continue;
            lease.validate();
            boolean fInclude = false;
            switch (lease.getStatus()) {
                case 1: {
                    lease.setIssuerId(nOldestId);
                }
                case 2: 
                case 3: 
                case 4: {
                    fInclude = lease.getIssuerId() == nThisId;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!fInclude) continue;
            try {
                Binary binResource = null;
                if (mapResource.containsKey(oKey)) {
                    Object oResource = mapResource.get(oKey);
                    Binary binary = binResource = oResource instanceof Binary ? (Binary)oResource : ExternalizableHelper.toBinary(oResource, serializer);
                }
                if (resBytes == null) {
                    int cb = lease.getResourceSize();
                    resBytes = new ByteArrayWriteBuffer(cb <= 0 ? 256 : 32 + cb);
                } else {
                    resBytes.clear();
                }
                output = resBytes.getBufferOutput();
                msg.writeObject(output, oKey);
                lease.write(output);
                msg.writeObject(output, binResource);
            }
            catch (IOException e) {
                CacheHandler._trace("An exception (" + String.valueOf(e) + ") occurred while serializing " + String.valueOf(lease) + " for " + String.valueOf(this), 1);
                CacheHandler._trace(e);
                continue;
            }
            try {
                streamData.write(((ByteArrayWriteBuffer)resBytes).toByteArray());
            }
            catch (IOException e) {
                CacheHandler._trace("An exception (" + String.valueOf(e) + ") occurred while streaming the message " + String.valueOf(msg) + " for " + String.valueOf(this), 1);
                CacheHandler._trace(e);
                msg.setLeaseCount(0);
                msg.setCacheData(new byte[0]);
                return null;
            }
            ++cLease;
            if (streamData.size() <= cbSize) continue;
            break;
        }
        msg.setLeaseCount(cLease);
        msg.setCacheData(streamBytes.toByteArray());
        return enumLeaseKeys.hasMoreElements() ? enumLeaseKeys : null;
    }

    @Override
    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, 0L, true);
    }

    @Override
    public Object put(Object oKey, Object oValue, long cMillis) {
        if (cMillis != 0L && !this.isPutExpiryWarned()) {
            CacheHandler._trace("ReplicatedCache does not support per-entry expiration; proceeding with the cache-configured expiry.", 2);
            this.setPutExpiryWarned(true);
        }
        return this.put(oKey, oValue, cMillis, true);
    }

    public Object put(Object oKey, Object oValue, long cMillis, boolean fReturn) {
        this.checkAccess();
        ConcurrentModificationException cme = null;
        int c = 32;
        for (int i = 1; i <= c; ++i) {
            try {
                return this.getService().updateResource(this, oKey, oValue, cMillis, false, fReturn);
            }
            catch (ConcurrentModificationException e) {
                cme = e;
                try {
                    Blocking.sleep(i << 4);
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        throw cme;
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), 0L, false);
        }
    }

    public Object putFinal(Object oKey, Object oValue, boolean fReturn) throws ConcurrentModificationException {
        this.checkAccess();
        return this.getService().updateResource(this, oKey, oValue, 0L, true, fReturn);
    }

    @Override
    public void release() {
        this.getCacheService().releaseCache(this);
    }

    public void releaseClassLoader() {
        ClassLoader loader = this.getClassLoader();
        if (loader != null) {
            this.setClassLoader(null);
            ReplicatedCache service = this.getService();
            Enumeration e = this.getLeaseKeys();
            while (e.hasMoreElements()) {
                Object oKey = e.nextElement();
                Lease lease = this.getLease(oKey);
                if (lease == null) continue;
                if (service.getThreadStatus(lease) == 3) {
                    service.unlockResource(this, oKey);
                }
                if (lease.getClassLoader() != loader) continue;
                this.releaseClassLoader(lease);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object releaseClassLoader(Lease lease) {
        Lease lease2 = lease;
        synchronized (lease2) {
            Map mapResource = this.getResourceMap();
            Object oKey = lease.getResourceKey();
            Object oValue = mapResource.get(oKey);
            lease.setClassLoader(null);
            if (oValue != null || mapResource.containsKey(oKey)) {
                try {
                    Object oInternal = this.getConverterToInternal().convert(oValue);
                    if (oInternal != oValue) {
                        oValue = oInternal;
                        mapResource.put(oKey, oValue);
                    }
                }
                catch (WrapperException e) {
                    throw new WrapperException(e.getOriginalException(), "CacheName=" + this.getCacheName() + ", Key=" + String.valueOf(oKey));
                }
            }
            return oValue;
        }
    }

    public void releaseIndexMap() {
        Map mapIndex = this.getIndexMap();
        if (mapIndex != null) {
            HashSet setExtractors = new HashSet(mapIndex.keySet());
            Iterator iter = setExtractors.iterator();
            while (iter.hasNext()) {
                this.removeIndex((ValueExtractor)iter.next());
            }
            this.setIndexMap(null);
        }
    }

    @Override
    public Object remove(Object oKey) {
        return this.remove(oKey, true);
    }

    public Object remove(Object oKey, boolean fReturn) {
        this.checkAccess();
        ConcurrentModificationException cme = null;
        int c = 32;
        for (int i = 1; i <= c; ++i) {
            try {
                return this.getService().removeResource(this, oKey, fReturn);
            }
            catch (ConcurrentModificationException e) {
                cme = e;
                try {
                    Blocking.sleep(i << 4);
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        throw cme;
    }

    @Override
    public void removeIndex(ValueExtractor extractor) {
        InvocableMapHelper.removeIndex(extractor, this, this.ensureIndexMap());
    }

    @Override
    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, (Filter)null);
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        if (listener instanceof NamedCacheDeactivationListener) {
            this.getDeactivationListeners().remove(listener);
        } else {
            CacheHandler._assert(listener != null);
            MapListenerSupport support = this.getListenerSupport();
            if (support != null) {
                support.removeListener(this.wrap(listener), filter);
                if (support.isEmpty()) {
                    this.setListenerSupport(null);
                }
            }
        }
    }

    @Override
    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        CacheHandler._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(this.wrap(listener), oKey);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    protected void setBackingMapListener(MapListener listener) {
        this.__m_BackingMapListener = listener;
    }

    public void setCacheIndex(int index) {
        int indexOld;
        if (this.is_Constructed() && (indexOld = this.getCacheIndex()) != -1 && index != indexOld) {
            throw new IllegalStateException("Attempt to modify the CacheIndex: " + String.valueOf(this) + " to " + index);
        }
        this.__m_CacheIndex = index;
    }

    public void setCacheName(String sName) {
        if (this.is_Constructed()) {
            Map mapActual;
            boolean fClone;
            String sNameOld = this.getCacheName();
            if (sNameOld != null && !sNameOld.equals(sName)) {
                throw new IllegalStateException("Attempt to modify the CacheName: " + String.valueOf(this) + " to " + sName);
            }
            BackingMapManager manager = this.getService().getBackingMapManager();
            Map map = this.getResourceMap();
            boolean bl = fClone = this.getNextHandler() != null;
            if (fClone) {
                CacheHandler._assert(map != null, "Resource map must be copied");
            } else if (map == null) {
                if (manager != null) {
                    if (sName == null) {
                        CacheHandler._trace("Creating a temporary map: " + this.getCacheIndex(), 5);
                    } else {
                        map = this.instantiateBackingMap(manager, sName);
                    }
                }
                this.setResourceMap(map == null ? new SafeHashMap() : map);
            } else if (sName != null && sNameOld == null && manager != null && (mapActual = this.instantiateBackingMap(manager, sName)) != null) {
                if (!map.isEmpty()) {
                    CacheHandler._trace("Transferring " + map.size() + " to: " + sName, 5);
                    mapActual.putAll(map);
                }
                this.setResourceMap(mapActual);
            }
        }
        this.__m_CacheName = sName;
    }

    public synchronized void setClassLoader(ClassLoader loader) {
        this.__m_ClassLoader = loader;
        this.setConverterFromInternal(null);
        this.setSerializer(loader == null ? null : this.getService().ensureSerializer(loader));
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    protected void setConverterFromInternal(Converter conv) {
        this.__m_ConverterFromInternal = conv;
    }

    protected void setConverterToInternal(Converter pConverterToInternal) {
        this.__m_ConverterToInternal = pConverterToInternal;
    }

    protected void setDeactivationListeners(Listeners listeners) {
        this.__m_DeactivationListeners = listeners;
    }

    protected void setIgnoreKey(Object oKey) {
        this.__m_IgnoreKey = oKey;
    }

    public void setIndexMap(Map map) {
        this.__m_IndexMap = map;
    }

    public void setLeaseMap(Map map) {
        this.__m_LeaseMap = map;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    public void setNextHandler(CacheHandler handler) {
        this.__m_NextHandler = handler;
    }

    protected void setPutExpiryWarned(boolean fWarned) {
        this.__m_PutExpiryWarned = fWarned;
    }

    public void setResourceMap(Map map) {
        this.__m_ResourceMap = map;
    }

    protected void setSerializer(Serializer serializer) {
        this.__m_Serializer = serializer;
    }

    public void setStandardLeaseMillis(long lMillis) {
        this.__m_StandardLeaseMillis = Math.max(0L, lMillis);
    }

    public void setUseEventDaemon(boolean pUseEventDaemon) {
        this.__m_UseEventDaemon = pUseEventDaemon;
    }

    protected void setValid(boolean fValid) {
        this.__m_Valid = fValid;
    }

    @Override
    public int size() {
        this.checkAccess();
        return this.getResourceMap().size();
    }

    public void terminateLease(Object oKey) {
        Map mapLease = this.getLeaseMap();
        if (mapLease instanceof OverflowMap) {
            ObservableMap mapFront = ((OverflowMap)mapLease).getFrontMap();
            mapFront.remove(oKey);
        } else {
            mapLease.remove(oKey);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{Name=").append(this.getCacheName()).append(", Index=").append(this.getCacheIndex()).append(", ServiceName=").append(this.getService().getServiceName());
        if (this.isValid()) {
            sb.append(", ClassLoader=").append(this.getClassLoader());
        } else {
            sb.append(", INVALID");
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public XmlElement toXml() {
        SimpleElement xml = new SimpleElement(this.get_Name());
        xml.addElement("CacheName").setString(this.getCacheName());
        xml.addElement("CacheIndex").setInt(this.getCacheIndex());
        xml.addElement("StandardLeaseMillis").setLong(this.getStandardLeaseMillis());
        return xml;
    }

    @Override
    public boolean unlock(Object oKey) {
        this.checkAccess();
        return this.getService().unlockResource(this, oKey);
    }

    protected void validateLease(Lease lease) {
        ReplicatedCache service = this.getService();
        int nThisId = service.getThisMember().getId();
        lease.validate();
        switch (lease.getStatus()) {
            case 1: {
                lease.setIssuerId(service.getServiceOldestMember().getId());
            }
            case 2: {
                Object oKey = lease.getResourceKey();
                if (this.getResourceMap().containsKey(oKey)) break;
                this.terminateLease(oKey);
                break;
            }
            case 3: 
            case 4: {
                if (lease.getIssuerId() != 0) break;
                lease.setIssuerId(lease.getHolderId());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public Collection values() {
        this.checkAccess();
        return ConverterCollections.getCollection(this.getResourceMap().keySet(), this, NullImplementation.getConverter());
    }

    protected MapListener wrap(MapListener listener) {
        return ContainerHelper.getContextAwareListener(this.getService(), listener);
    }

    static {
        CacheHandler.__initStatic();
    }

    public static class BackingMapListener
    extends Util
    implements MapListener {
        public BackingMapListener() {
            this(null, null, true);
        }

        public BackingMapListener(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new BackingMapListener();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/CacheHandler$BackingMapListener".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public void entryDeleted(MapEvent evt) {
            CacheHandler handler = (CacheHandler)this.get_Parent();
            Object oKey = evt.getKey();
            if (!Base.equals(handler.getIgnoreKey(), oKey)) {
                handler.terminateLease(oKey);
            }
        }

        public void entryInserted(MapEvent evt) {
        }

        public void entryUpdated(MapEvent evt) {
        }
    }

    public static class EntrySet
    extends com.tangosol.coherence.component.util.collections.wrapperSet.EntrySet {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Entry", Entry.get_CLASS());
            __mapChildren.put("Iterator", Iterator.get_CLASS());
        }

        public EntrySet() {
            this(null, null, true);
        }

        public EntrySet(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new EntrySet();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/CacheHandler$EntrySet".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public boolean remove(Object o) {
            Object oKey;
            CacheHandler handler = (CacheHandler)this.getMap();
            Map.Entry entry = (Map.Entry)o;
            Object v0 = oKey = entry == null ? null : entry.getKey();
            if (handler.containsKey(oKey)) {
                handler.remove((Object)oKey, false);
                return true;
            }
            return false;
        }

        static {
            EntrySet.__initStatic();
        }

        public static class Entry
        extends EntrySet.Entry {
            public Entry() {
                this(null, null, true);
            }

            public Entry(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Entry();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/CacheHandler$EntrySet$Entry".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }

            @Override
            public Object getValue() {
                return ((CacheHandler)this.get_Module()).convert(this.getKey());
            }

            @Override
            public Object setValue(Object oValue) {
                Object oValueOld = this.getValue();
                super.setValue(oValue);
                return oValueOld;
            }

            @Override
            public String toString() {
                return this.get_Name() + ": key=\"" + String.valueOf(this.getKey()) + "\", value=\"" + String.valueOf(this.getValue()) + "\"";
            }
        }

        public static class Iterator
        extends EntrySet.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/CacheHandler$EntrySet$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class KeySet
    extends com.tangosol.coherence.component.util.collections.wrapperSet.KeySet {
        private static ListMap __mapChildren;

        private static void __initStatic() {
            __mapChildren = new ListMap();
            __mapChildren.put("Iterator", Iterator.get_CLASS());
        }

        public KeySet() {
            this(null, null, true);
        }

        public KeySet(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new KeySet();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/CacheHandler$KeySet".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected Map get_ChildClasses() {
            return __mapChildren;
        }

        @Override
        public boolean remove(Object o) {
            CacheHandler handler = (CacheHandler)this.getMap();
            if (handler.containsKey(o)) {
                handler.remove(o, false);
                return true;
            }
            return false;
        }

        static {
            KeySet.__initStatic();
        }

        public static class Iterator
        extends WrapperSet.Iterator {
            public Iterator() {
                this(null, null, true);
            }

            public Iterator(String sName, Component compParent, boolean fInit) {
                super(sName, compParent, false);
                if (fInit) {
                    this.__init();
                }
            }

            @Override
            public void __init() {
                this.__initPrivate();
                this.set_Constructed(true);
            }

            @Override
            protected void __initPrivate() {
                super.__initPrivate();
            }

            public static Component get_Instance() {
                return new Iterator();
            }

            public static Class get_CLASS() {
                Class<?> clz;
                try {
                    clz = Class.forName("com.tangosol.coherence/component/util/CacheHandler$KeySet$Iterator".replace('/', '.'));
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
                return clz;
            }

            private Component get_Module() {
                return this.get_Parent().get_Parent();
            }
        }
    }

    public static class Validator
    extends TransactionValidator {
        private transient SafeHashMap __m_LeaseMap;

        public Validator() {
            this(null, null, true);
        }

        public Validator(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setLeaseMap(new SafeHashMap());
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Validator();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/util/CacheHandler$Validator".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void enlist(TransactionMap map, Object oKey) {
            CacheHandler handler = (CacheHandler)this.get_Parent();
            Validator._assert(handler == map.getBaseMap());
            Lease lease = handler.getLease(oKey);
            this.getLeaseMap().put(oKey, lease == null ? null : lease.clone());
            super.enlist(map, oKey);
        }

        public SafeHashMap getLeaseMap() {
            return this.__m_LeaseMap;
        }

        public void setLeaseMap(SafeHashMap pLeaseMap) {
            this.__m_LeaseMap = pLeaseMap;
        }

        @Override
        public void validate(TransactionMap map, Set setInsert, Set setUpdate, Set setDelete, Set setRead, Set setFanthom) throws ConcurrentModificationException {
            super.validate(map, setInsert, setUpdate, setDelete, setRead, setFanthom);
            CacheHandler handler = (CacheHandler)this.get_Parent();
            Validator._assert(handler == map.getBaseMap());
            this.validateInsert(map, setInsert);
            this.validateVersion(map, setUpdate);
            this.validateVersion(map, setDelete);
            this.validateValue(map, setRead);
            boolean fFail = false;
            Object sMsg = "";
            if (!setInsert.isEmpty()) {
                sMsg = (String)sMsg + "\ninserts=" + String.valueOf(setInsert);
                fFail = true;
            }
            if (!setUpdate.isEmpty()) {
                sMsg = (String)sMsg + "\nupdates=" + String.valueOf(setUpdate);
                fFail = true;
            }
            if (!setDelete.isEmpty()) {
                sMsg = (String)sMsg + "\ndeletes=" + String.valueOf(setDelete);
                fFail = true;
            }
            if (!setRead.isEmpty()) {
                sMsg = (String)sMsg + "\nreads=" + String.valueOf(setRead);
                fFail = true;
            }
            if (!setFanthom.isEmpty()) {
                sMsg = (String)sMsg + "\nfanthoms=" + String.valueOf(setFanthom);
                fFail = true;
            }
            if (fFail) {
                throw new ConcurrentModificationException("validation failed: " + (String)sMsg);
            }
        }

        protected void validateInsert(TransactionMap map, Set set) {
            ConcurrentMap mapBase = map.getBaseMap();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                Object oKey = iter.next();
                if (mapBase.containsKey(oKey)) continue;
                iter.remove();
            }
        }

        protected void validateValue(TransactionMap map, Set set) {
            ConcurrentMap mapBase = map.getBaseMap();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                Object oValCurr;
                Object oKey = iter.next();
                Object oValBase = mapBase.get(oKey);
                if (!Base.equals(oValBase, oValCurr = map.get(oKey))) continue;
                iter.remove();
            }
        }

        protected void validateVersion(TransactionMap map, Set set) {
            CacheHandler handler = (CacheHandler)this.get_Parent();
            SafeHashMap mapLease = this.getLeaseMap();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                Object oKey = iter.next();
                Lease leaseOrig = (Lease)mapLease.get(oKey);
                Lease leaseCurr = handler.getLease(oKey);
                if (leaseOrig == null || leaseCurr == null || leaseOrig.getResourceVersion() != leaseCurr.getResourceVersion()) continue;
                iter.remove();
            }
        }
    }
}

