/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.internal.tracing.Scope;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Listeners;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.SynchronousListener;
import java.util.EventListener;

public class CacheEvent
extends Util
implements Runnable {
    private Listeners __m_Listeners;
    private MapListenerSupport __m_ListenerSupport;
    private MapEvent __m_MapEvent;
    private MapListener __m_MapListener;
    private Span __m_ParentTracingSpan;

    public CacheEvent() {
        this(null, null, true);
    }

    public CacheEvent(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new CacheEvent();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/util/CacheEvent".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispatchSafe(MapEvent event, Listeners listeners, Queue queue) {
        if (listeners != null) {
            EventListener[] aListener = listeners.listeners();
            int c = aListener.length;
            for (int i = 0; i < c; ++i) {
                MapListener listener = (MapListener)aListener[i];
                if (listener instanceof SynchronousListener) {
                    NamedCache cache = (NamedCache)event.getSource();
                    CacheService svc = cache.getCacheService();
                    boolean fTracing = TracingHelper.isEnabled();
                    Span span = null;
                    Scope scope = null;
                    if (fTracing) {
                        span = TracingHelper.newSpan("process", event).withMetadata(Span.Type.COMPONENT.key(), svc == null ? "n/a" : svc.getInfo().getServiceName()).withMetadata("cache", cache.getCacheName()).withMetadata("event.action", MapEvent.getDescription(event.getId())).withMetadata("listener", listener.getClass().getName()).startSpan();
                        scope = TracingHelper.getTracer().withSpan(span);
                    }
                    try {
                        event.dispatch(listener);
                        continue;
                    }
                    catch (Throwable e) {
                        if (fTracing) {
                            TracingHelper.augmentSpanWithErrorDetails(span, true, e);
                        }
                        CacheEvent._trace("An exception occurred while dispatching synchronous event:" + String.valueOf(event), 1);
                        CacheEvent._trace(e);
                        CacheEvent._trace("(The exception has been logged and execution is continuing.)", 1);
                        continue;
                    }
                    finally {
                        if (fTracing) {
                            scope.close();
                            span.end();
                        }
                    }
                }
                queue.add(CacheEvent.instantiate(event, listener));
            }
        }
    }

    public Listeners getListeners() {
        return this.__m_Listeners;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public MapEvent getMapEvent() {
        return this.__m_MapEvent;
    }

    public MapListener getMapListener() {
        return this.__m_MapListener;
    }

    public Span getParentTracingSpan() {
        return this.__m_ParentTracingSpan;
    }

    public static CacheEvent instantiate(MapEvent event, Listeners listeners) {
        CacheEvent._assert(event != null && listeners != null);
        CacheEvent task = new CacheEvent();
        task.setMapEvent(event);
        task.setListeners(listeners);
        return task;
    }

    public static CacheEvent instantiate(MapEvent event, MapListener listener) {
        CacheEvent._assert(event != null && listener != null);
        CacheEvent task = new CacheEvent();
        task.setMapEvent(event);
        task.setMapListener(listener);
        task.setParentTracingSpan(TracingHelper.getActiveSpan());
        return task;
    }

    public static CacheEvent instantiate(MapEvent event, MapListenerSupport support) {
        CacheEvent._assert(event != null && support != null);
        CacheEvent task = new CacheEvent();
        task.setMapEvent(event);
        task.setListenerSupport(support);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MapEvent event = this.getMapEvent();
        NamedCache cache = (NamedCache)event.getSource();
        if (cache.isActive()) {
            MapListenerSupport support = this.getListenerSupport();
            Service svc = (Service)((Object)cache.getCacheService());
            try (Scope scope = svc == null ? null : TracingHelper.getTracer().withSpan(svc.newTracingSpan("process", event).setParent(this.getParentTracingSpan()).withMetadata("cache", cache.getCacheName()).withMetadata("event.action", MapEvent.getDescription(event.getId())).startSpan());){
                if (support == null) {
                    Listeners listeners = this.getListeners();
                    if (listeners == null) {
                        event.dispatch(this.getMapListener());
                    } else {
                        event.dispatch(listeners, true);
                    }
                } else {
                    support.fireEvent(event, true);
                }
            }
        }
    }

    protected void setListeners(Listeners listeners) {
        this.__m_Listeners = listeners;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    protected void setMapEvent(MapEvent event) {
        this.__m_MapEvent = event;
    }

    protected void setMapListener(MapListener listener) {
        this.__m_MapListener = listener;
    }

    public void setParentTracingSpan(Span spanTracing) {
        this.__m_ParentTracingSpan = spanTracing;
    }

    @Override
    public String toString() {
        return this.get_Name() + ": " + String.valueOf(this.getMapEvent());
    }
}

