/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.socket.udpSocket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.util.HashHelper;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;

public class MulticastUdpSocket
extends UdpSocket {
    private SocketAddress __m_Address;
    private InetAddress __m_InterfaceInetAddress;
    private int __m_TimeToLive;

    public MulticastUdpSocket() {
        this(null, null, true);
    }

    public MulticastUdpSocket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setIgnoreSendErrors(false);
            this.setPacketLength(0);
            this.setRxDebugDropRate(0);
            this.setSoTimeout(-1);
            this.setTimeToLive(-1);
            this.setTxDebugDropRate(0);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new MulticastUdpSocket();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/socket/udpSocket/MulticastUdpSocket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected void bind(DatagramSocket socket) throws IOException {
        MulticastSocket socketMulti = (MulticastSocket)socket;
        socketMulti.bind(new InetSocketAddress(this.getPort()));
        socketMulti.joinGroup(this.getInetAddress());
    }

    public SocketAddress getAddress() {
        SocketAddress addr = this.__m_Address;
        if (addr == null) {
            addr = new InetSocketAddress(this.getInetAddress(), this.getPort());
            this.setAddress(addr);
        }
        return addr;
    }

    @Override
    public String getDescription() {
        StringBuffer sb = new StringBuffer(super.getDescription());
        sb.append(", InterfaceAddress=").append(MulticastUdpSocket.toString(this.getInterfaceInetAddress())).append(", TimeToLive=").append(this.getTimeToLive());
        return sb.toString();
    }

    public InetAddress getInterfaceInetAddress() {
        return this.__m_InterfaceInetAddress;
    }

    public int getTimeToLive() {
        return this.__m_TimeToLive;
    }

    @Override
    public int hashCode() {
        return HashHelper.hash(this.getTimeToLive() == 0, super.hashCode());
    }

    @Override
    protected void initializeDatagramSocket(DatagramSocket socket) throws IOException {
        super.initializeDatagramSocket(socket);
        MulticastSocket socketMulti = (MulticastSocket)socket;
        socketMulti.setTimeToLive(this.getTimeToLive());
        socketMulti.setInterface(this.getInterfaceInetAddress());
    }

    @Override
    protected DatagramSocket instantiateDatagramSocket() throws IOException {
        return this.getDatagramSocketProvider().openMulticastSocket();
    }

    protected void setAddress(SocketAddress addr) {
        this.__m_Address = addr;
    }

    @Override
    public void setInetAddress(InetAddress addr) {
        if (addr == null || !addr.isMulticastAddress()) {
            throw new IllegalArgumentException("MulticastUdpSocket.InetAddress is not in the multicast range: " + MulticastUdpSocket.toString(addr));
        }
        super.setInetAddress(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterfaceInetAddress(InetAddress addr) {
        if (addr != null && addr.isMulticastAddress()) {
            throw new IllegalArgumentException("MulticastUdpSocket.InterfaceInetAddress is in the multicast range: " + MulticastUdpSocket.toString(addr));
        }
        Object object = this.getLock();
        synchronized (object) {
            MulticastUdpSocket._assert(this.getState() != 1, "InterfaceInetAddress cannot be modified once the socket is open");
            this.__m_InterfaceInetAddress = addr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeToLive(int ttl) {
        if (ttl < 0) {
            return;
        }
        if (ttl > 255) {
            throw new IllegalArgumentException("MulticastUdpSocket.TimeToLive is out of range (0..255): " + ttl);
        }
        Object object = this.getLock();
        synchronized (object) {
            MulticastUdpSocket._assert(this.getState() != 1, "TimeToLive cannot be modified once the socket is open");
            this.__m_TimeToLive = ttl;
        }
    }
}

