/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.socket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.PacketBundle;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.coherence.config.Config;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.DatagramSocketProvider;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.Base;
import com.tangosol.util.HashHelper;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Set;

public abstract class UdpSocket
extends Socket {
    private int __m_BufferReceivedBytes;
    private int __m_BufferSentBytes;
    private long __m_BytesReceived;
    private long __m_BytesSent;
    private int __m_CountReceived;
    private int __m_CountSent;
    private DatagramSocket __m_DatagramSocket;
    private DatagramSocketProvider __m_DatagramSocketProvider;
    private transient boolean __m_IgnoreSendErrors;
    private transient DatagramPacket __m_IncomingPacket;
    private transient WriteBuffer.BufferOutput __m_OutgoingBuffer;
    private transient DatagramPacket __m_OutgoingPacket;
    private int __m_PacketLength;
    private transient Set __m_RxDebugDropAddresses;
    private transient int __m_RxDebugDropRate;
    private Object __m_SendLock;
    private transient Set __m_TxDebugDropAddresses;
    private transient int __m_TxDebugDropRate;

    public UdpSocket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_SendLock = new Object();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/socket/UdpSocket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    protected void bind(DatagramSocket socket) throws IOException {
        socket.bind(new InetSocketAddress(this.getInetAddress(), this.getPort()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != 2) {
                DatagramSocket socket = this.getDatagramSocket();
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.setState(2);
            }
        }
    }

    public int getBufferReceivedBytes() {
        return this.__m_BufferReceivedBytes;
    }

    public int getBufferSentBytes() {
        return this.__m_BufferSentBytes;
    }

    public long getBytesReceived() {
        return this.__m_BytesReceived;
    }

    public long getBytesSent() {
        return this.__m_BytesSent;
    }

    public int getCountReceived() {
        return this.__m_CountReceived;
    }

    public int getCountSent() {
        return this.__m_CountSent;
    }

    public DatagramSocket getDatagramSocket() {
        return this.__m_DatagramSocket;
    }

    public DatagramSocketProvider getDatagramSocketProvider() {
        return this.__m_DatagramSocketProvider;
    }

    public DatagramPacket getIncomingPacket() {
        return this.__m_IncomingPacket;
    }

    public WriteBuffer.BufferOutput getOutgoingBuffer() {
        WriteBuffer.BufferOutput buffer = this.__m_OutgoingBuffer;
        buffer.setOffset(0);
        return buffer;
    }

    public DatagramPacket getOutgoingPacket() {
        return this.__m_OutgoingPacket;
    }

    public int getPacketLength() {
        return this.__m_PacketLength;
    }

    public Set getRxDebugDropAddresses() {
        return this.__m_RxDebugDropAddresses;
    }

    public int getRxDebugDropRate() {
        return this.__m_RxDebugDropRate;
    }

    protected Object getSendLock() {
        return this.__m_SendLock;
    }

    public Set getTxDebugDropAddresses() {
        return this.__m_TxDebugDropAddresses;
    }

    public int getTxDebugDropRate() {
        return this.__m_TxDebugDropRate;
    }

    public int hashCode() {
        return HashHelper.hash(this.getInetAddress(), this.getPort());
    }

    protected void initializeDatagramSocket(DatagramSocket socket) throws IOException {
        int cMillis;
        int cbRecv;
        int cbPacket = this.getPacketLength();
        UdpSocket._assert(cbPacket > 0, "UdpSocket.open: PacketLength property is required and must be greater than zero");
        byte[] abPacket = new byte[cbPacket];
        this.setOutgoingBuffer(new ByteArrayWriteBuffer(abPacket).getBufferOutput());
        this.setOutgoingPacket(new DatagramPacket(abPacket, cbPacket));
        int cbSend = this.getBufferSentBytes();
        if (cbSend > 0) {
            int cbReq = cbSend;
            int cbActual = socket.getSendBufferSize();
            while (cbActual < cbReq) {
                try {
                    socket.setSendBufferSize(cbReq);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                cbActual = socket.getSendBufferSize();
                cbReq = Math.max(cbActual, cbReq * 3 / 4);
            }
            this.validateBufferSize("send", cbActual, cbSend, cbPacket);
        }
        if ((cbRecv = this.getBufferReceivedBytes()) > 0) {
            int cbReq = cbRecv;
            int cbActual = socket.getReceiveBufferSize();
            while (cbActual < cbReq) {
                try {
                    socket.setReceiveBufferSize(cbReq);
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
                cbActual = socket.getReceiveBufferSize();
                cbReq = Math.max(cbActual, cbReq * 3 / 4);
            }
            this.validateBufferSize("receive", cbActual, cbRecv, cbPacket);
        }
        if ((cMillis = this.getSoTimeout()) >= 0) {
            socket.setSoTimeout(cMillis);
            this.validateSoTimeout(socket.getSoTimeout(), cMillis);
        }
    }

    protected DatagramSocket instantiateDatagramSocket() throws IOException {
        return this.getDatagramSocketProvider().openDatagramSocket();
    }

    public boolean isIgnoreSendErrors() {
        return this.__m_IgnoreSendErrors;
    }

    private boolean isRxDebugDrop(SocketAddress socketAddress) {
        int iDropRate = this.getRxDebugDropRate();
        if (iDropRate == 0 || iDropRate < Base.getRandom().nextInt(100000)) {
            return false;
        }
        Set setAddress = this.getRxDebugDropAddresses();
        return setAddress == null || setAddress.contains(socketAddress);
    }

    private boolean isTxDebugDrop(SocketAddress socketAddress) {
        int iDropRate = this.getTxDebugDropRate();
        if (iDropRate == 0 || iDropRate < Base.getRandom().nextInt(100000)) {
            return false;
        }
        Set setAddress = this.getTxDebugDropAddresses();
        return setAddress == null || setAddress.contains(socketAddress);
    }

    @Override
    public void onException(IOException eException) {
        super.onException(eException);
    }

    @Override
    public void onInit() {
        this.setIgnoreSendErrors(Config.getBoolean("coherence.udp.ignoretxerror"));
        this.setIncomingPacket(new DatagramPacket(new byte[0], 0));
        super.onInit();
    }

    protected void onReceiveException(IOException eException) {
        this.onException(eException);
    }

    protected void onSendException(IOException eException) {
        this.onException(eException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != 1) {
                DatagramSocket socket = null;
                try {
                    socket = this.instantiateDatagramSocket();
                    this.initializeDatagramSocket(socket);
                    this.bind(socket);
                    if (this.getPort() == 0) {
                        this.setPort(socket.getLocalPort());
                    }
                    this.setDatagramSocket(socket);
                }
                catch (IOException e) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw e;
                }
                this.setCountSent(0);
                this.setCountReceived(0);
                this.setBytesSent(0L);
                this.setBytesReceived(0L);
                this.setState(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(InetAddress addr) throws IOException {
        DatagramSocket socket = this.getDatagramSocket();
        if (!socket.getLocalAddress().isAnyLocalAddress()) {
            throw new IOException("not bound to wildcard address");
        }
        DatagramSocket socketNew = this.instantiateDatagramSocket();
        this.initializeDatagramSocket(socketNew);
        Object object = this.getLock();
        synchronized (object) {
            int nPort = socket.getLocalPort();
            socket.close();
            DatagramPacket datagramPacket = this.getIncomingPacket();
            synchronized (datagramPacket) {
                socketNew.bind(new InetSocketAddress(addr, nPort));
            }
            this.setInetAddress(addr);
            this.setDatagramSocket(socketNew);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress receive(ByteBuffer buffer) {
        DatagramSocket socket = this.getDatagramSocket();
        try {
            int cb;
            DatagramPacket dgPacket;
            int cPos = buffer.position();
            DatagramPacket datagramPacket = dgPacket = this.getIncomingPacket();
            synchronized (datagramPacket) {
                dgPacket.setData(buffer.array(), buffer.arrayOffset() + cPos, buffer.remaining());
                socket.receive(dgPacket);
                cb = dgPacket.getLength();
                if (this.getRxDebugDropRate() != 0 && this.isRxDebugDrop(dgPacket.getSocketAddress())) {
                    return null;
                }
            }
            buffer.limit(cPos + cb);
            this.setCountReceived(this.getCountReceived() + 1);
            this.setBytesReceived(this.getBytesReceived() + (long)cb);
            return dgPacket.getSocketAddress();
        }
        catch (InterruptedIOException e) {
            this.onInterruptedIOException(e);
        }
        catch (IOException e) {
            if (socket.isClosed()) {
                Object object = this.getLock();
                synchronized (object) {
                    if (this.getDatagramSocket() == socket) {
                        throw new ConnectionException(e);
                    }
                    return null;
                }
            }
            this.onReceiveException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(PacketBundle bundle) {
        IOException eIO = null;
        DatagramSocket socket = this.getDatagramSocket();
        int iDropRate = this.getTxDebugDropRate();
        try {
            Object object = this.getSendLock();
            synchronized (object) {
                DatagramPacket packet = this.getOutgoingPacket();
                int cb = bundle.write(this.getOutgoingBuffer());
                if (cb > 0) {
                    int cAddr = bundle.getAddressCount();
                    packet.setLength(cb);
                    for (int i = 0; i < cAddr; ++i) {
                        InetSocketAddress addr = (InetSocketAddress)bundle.getAddress(i);
                        if (iDropRate != 0 && this.isTxDebugDrop(addr)) continue;
                        packet.setAddress(addr.getAddress());
                        packet.setPort(addr.getPort());
                        try {
                            socket.send(packet);
                            continue;
                        }
                        catch (IOException e) {
                            eIO = e;
                        }
                    }
                    this.setCountSent(this.getCountSent() + cAddr);
                    this.setBytesSent(this.getBytesSent() + (long)(cb * cAddr));
                    if (eIO != null) {
                        throw eIO;
                    }
                }
                return;
            }
        }
        catch (IOException e) {
            if (socket.isClosed()) {
                Object object = this.getLock();
                synchronized (object) {
                    if (this.getDatagramSocket() == socket) {
                        throw new ConnectionException(e);
                    }
                    return;
                }
            }
            this.onSendException(e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferReceivedBytes(int cPackets) {
        Object object = this.getLock();
        synchronized (object) {
            UdpSocket._assert(this.getState() != 1, "BufferReceived cannot be modified once the socket is open");
            this.__m_BufferReceivedBytes = cPackets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSentBytes(int cPackets) {
        Object object = this.getLock();
        synchronized (object) {
            UdpSocket._assert(this.getState() != 1, "BufferSent cannot be modified once the socket is open");
            this.__m_BufferSentBytes = cPackets;
        }
    }

    public void setBytesReceived(long cBytes) {
        this.__m_BytesReceived = cBytes;
    }

    public void setBytesSent(long cBytes) {
        this.__m_BytesSent = cBytes;
    }

    protected void setCountReceived(int cReceived) {
        this.__m_CountReceived = cReceived;
    }

    protected void setCountSent(int cSent) {
        this.__m_CountSent = cSent;
    }

    protected void setDatagramSocket(DatagramSocket socket) {
        this.__m_DatagramSocket = socket;
    }

    public void setDatagramSocketProvider(DatagramSocketProvider providerSocket) {
        this.__m_DatagramSocketProvider = providerSocket;
    }

    public void setIgnoreSendErrors(boolean fIgnore) {
        this.__m_IgnoreSendErrors = fIgnore;
    }

    protected void setIncomingPacket(DatagramPacket packetIncoming) {
        this.__m_IncomingPacket = packetIncoming;
    }

    protected void setOutgoingBuffer(WriteBuffer.BufferOutput output) {
        this.__m_OutgoingBuffer = output;
    }

    protected void setOutgoingPacket(DatagramPacket packetOutgoing) {
        this.__m_OutgoingPacket = packetOutgoing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPacketLength(int cb) {
        Object object = this.getLock();
        synchronized (object) {
            UdpSocket._assert(this.getState() != 1, "PacketLength cannot be modified once the socket is open");
            this.__m_PacketLength = cb;
        }
    }

    public void setRxDebugDropAddresses(Set set) {
        this.__m_RxDebugDropAddresses = set;
    }

    public void setRxDebugDropRate(int iRate) {
        if (iRate != this.getRxDebugDropRate()) {
            Set setAddr = this.getRxDebugDropAddresses();
            this.__m_RxDebugDropRate = iRate;
            UdpSocket._trace("Configuring " + String.valueOf(this) + " to drop " + (float)iRate / 1000.0f + "% of incoming packets" + (String)(setAddr == null ? "." : " from " + String.valueOf(setAddr)), 2);
        }
    }

    private void setSendLock(Object oLock) {
        this.__m_SendLock = oLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSoTimeout(int cMillis) {
        if (cMillis >= 0) {
            Object object = this.getLock();
            synchronized (object) {
                if (this.getState() == 1) {
                    DatagramSocket socket = this.getDatagramSocket();
                    try {
                        socket.setSoTimeout(cMillis);
                        this.validateSoTimeout(socket.getSoTimeout(), cMillis);
                    }
                    catch (SocketException e) {
                        throw new WrapperException(e);
                    }
                }
                super.setSoTimeout(cMillis);
            }
        }
    }

    public void setTxDebugDropAddresses(Set set) {
        this.__m_TxDebugDropAddresses = set;
    }

    public void setTxDebugDropRate(int iRate) {
        if (iRate != this.getTxDebugDropRate()) {
            Set setAddr = this.getTxDebugDropAddresses();
            this.__m_TxDebugDropRate = iRate;
            UdpSocket._trace("Configuring " + String.valueOf(this) + " to drop " + (float)iRate / 1000.0f + "% of outgoing packets" + (String)(setAddr == null ? "." : " to " + String.valueOf(setAddr)), 2);
        }
    }

    @Override
    protected void validateBufferSize(String sBufferName, int cbActualSize, int cbRequestedSize, int cbMinimumSize) {
        if (cbActualSize < cbRequestedSize) {
            int nPct = cbActualSize * 100 / cbRequestedSize;
            int iPacketLength = this.getPacketLength();
            String sMsg = this.get_Name() + " failed to set " + sBufferName + " buffer size to " + cbRequestedSize / iPacketLength + " packets (" + Base.toMemorySizeString(cbRequestedSize, false) + "); actual size is " + nPct + "%, " + cbActualSize / iPacketLength + " packets (" + Base.toMemorySizeString(cbActualSize, false) + "). Consult your OS documentation regarding increasing the maximum socket buffer size.";
            if (cbActualSize < cbMinimumSize) {
                UdpSocket._trace(sMsg, 1);
                throw new RuntimeException(sMsg);
            }
            if (nPct < 80) {
                sMsg = sMsg + " Proceeding with the actual value may cause sub-optimal performance.";
                UdpSocket._trace(sMsg, nPct < 50 ? 2 : 6);
            }
        }
    }
}

