/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.socket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Map;

public class TcpSocketAccepter
extends Socket {
    private int __m_Backlog;
    private ServerSocket __m_ServerSocket;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("TcpSocket", TcpSocket.get_CLASS());
    }

    public TcpSocketAccepter() {
        this(null, null, true);
    }

    public TcpSocketAccepter(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setBacklog(32);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new TcpSocketAccepter();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/socket/TcpSocketAccepter".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TcpSocket accept() {
        while (true) {
            IOException eIO = null;
            ServerSocket socketSrv = this.getServerSocket();
            try {
                if (socketSrv != null) {
                    java.net.Socket socket = socketSrv.accept();
                    TcpSocket socketTcp = (TcpSocket)this._newChild("TcpSocket");
                    socketTcp.setSocket(socket);
                    return socketTcp;
                }
            }
            catch (InterruptedIOException e) {
                this.onInterruptedIOException(e);
                return null;
            }
            catch (IOException e) {
                eIO = e;
            }
            Object object = this.getLock();
            synchronized (object) {
                if (socketSrv == this.getServerSocket()) {
                    switch (this.getState()) {
                        case 1: {
                            this.onAcceptException(eIO);
                            break;
                        }
                        default: {
                            throw new ConnectionException("TcpSocketAccepter.accept: unable to reopen socket; State=" + TcpSocketAccepter.formatStateName(this.getState()), eIO);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != 2) {
                ServerSocket socket = this.getServerSocket();
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setServerSocket(null);
                }
                this.setState(2);
            }
        }
    }

    public int getBacklog() {
        return this.__m_Backlog;
    }

    @Override
    public String getDescription() {
        if (this.getState() == 1) {
            ServerSocket socket = this.getServerSocket();
            return "ServerSocket=" + TcpSocketAccepter.toString(socket.getInetAddress()) + ":" + socket.getLocalPort();
        }
        return super.getDescription();
    }

    public ServerSocket getServerSocket() {
        return this.__m_ServerSocket;
    }

    protected ServerSocket instantiateServerSocket() throws IOException {
        InetAddress addr = this.getInetAddress();
        int nPort = this.getPort();
        int cBacklog = this.getBacklog();
        TcpSocketAccepter._assert(addr != null, "TcpSocketAccepter.open: InetAddress is required");
        TcpSocketAccepter._assert(nPort >= 0 && nPort <= 65535, "TcpSocketAccepter.open: Port out of range (" + nPort + ")");
        TcpSocketAccepter._assert(cBacklog > 0 && cBacklog <= 65535, "TcpSocketAccepter.open: Backlog out of range (" + cBacklog + ")");
        ServerSocket socket = this.getProvider().openServerSocket();
        try {
            socket.bind(new InetSocketAddress(addr, nPort), cBacklog);
        }
        catch (IOException e) {
            socket.close();
            throw e;
        }
        return socket;
    }

    protected void onAcceptException(IOException eException) {
        this.onException(eException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != 1) {
                ServerSocket socket = this.instantiateServerSocket();
                try {
                    try {
                        int cMillis = this.getSoTimeout();
                        TcpSocketAccepter._assert(cMillis >= 0, "TcpSocketAccepter.open: ReceiveTimeout property must be greater than or equal to zero");
                        socket.setSoTimeout(cMillis);
                        this.validateSoTimeout(socket.getSoTimeout(), cMillis);
                    }
                    catch (SocketException e) {
                        throw new WrapperException(e);
                    }
                    if (this.getPort() == 0) {
                        this.setPort(socket.getLocalPort());
                    }
                    this.setServerSocket(socket);
                }
                catch (RuntimeException e) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setServerSocket(null);
                    throw e;
                }
                this.setState(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBacklog(int cItems) {
        Object object = this.getLock();
        synchronized (object) {
            TcpSocketAccepter._assert(this.getState() == 0, "Backlog cannot be modified once the socket has been opened");
            this.__m_Backlog = cItems;
        }
    }

    protected void setServerSocket(ServerSocket socket) {
        this.__m_ServerSocket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSoTimeout(int cMillis) {
        Object object = this.getLock();
        synchronized (object) {
            TcpSocketAccepter._assert(cMillis >= 0);
            if (this.getState() == 1) {
                ServerSocket socket = this.getServerSocket();
                try {
                    socket.setSoTimeout(cMillis);
                    this.validateSoTimeout(socket.getSoTimeout(), cMillis);
                }
                catch (IOException e) {
                    throw new WrapperException(e);
                }
            }
            super.setSoTimeout(cMillis);
        }
    }

    static {
        TcpSocketAccepter.__initStatic();
    }

    public static class TcpSocket
    extends com.tangosol.coherence.component.net.socket.TcpSocket {
        public TcpSocket() {
            this(null, null, true);
        }

        public TcpSocket(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            try {
                this.setSoLinger(-1);
                this.setSoTimeout(-1);
            }
            catch (Exception e) {
                throw new WrapperException(e);
            }
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new TcpSocket();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/socket/TcpSocketAccepter$TcpSocket".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        protected java.net.Socket instantiateSocket() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void open() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSocket(java.net.Socket socket) {
            if (socket != null) {
                TcpSocket._assert(this.getSocket() == null, "Socket is not resettable");
                this.setInetAddress(socket.getLocalAddress());
                this.setPort(socket.getLocalPort());
                this.setRemoteInetAddress(socket.getInetAddress());
                this.setRemotePort(socket.getPort());
                try {
                    this.initializeSocket(socket);
                }
                catch (IOException e) {
                    throw new WrapperException(e);
                }
                this.setState(1);
            }
            super.setSocket(socket);
        }
    }
}

