/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.socket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class TcpSocket
extends Socket {
    private int __m_BufferLength;
    private boolean __m_KeepAlive;
    private InetAddress __m_RemoteInetAddress;
    private int __m_RemotePort;
    private java.net.Socket __m_Socket;
    private int __m_SoLinger;
    private boolean __m_TcpNoDelay;

    public TcpSocket() {
        this(null, null, true);
    }

    public TcpSocket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setSoLinger(-1);
            this.setSoTimeout(-1);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new TcpSocket();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/socket/TcpSocket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != 2) {
                java.net.Socket socket = this.getSocket();
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setSocket(null);
                }
                this.setState(2);
            }
        }
    }

    public int getBufferLength() {
        return this.__m_BufferLength;
    }

    @Override
    public String getDescription() {
        if (this.getState() == 1) {
            return "Socket=" + String.valueOf(this.getSocket());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Remote address:port=").append(TcpSocket.toString(this.getRemoteInetAddress())).append(':').append(this.getRemotePort());
        if (this.getInetAddress() != null) {
            sb.append(", Local address:port=").append(TcpSocket.toString(this.getInetAddress())).append(':').append(this.getPort());
        }
        return sb.toString();
    }

    public InputStream getInputStream() {
        if (this.getState() != 1) {
            throw new IllegalStateException("Socket is closed");
        }
        try {
            return this.getSocket().getInputStream();
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public OutputStream getOutputStream() {
        if (this.getState() != 1) {
            throw new IllegalStateException("Socket is closed");
        }
        try {
            return this.getSocket().getOutputStream();
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public InetAddress getRemoteInetAddress() {
        return this.__m_RemoteInetAddress;
    }

    public int getRemotePort() {
        return this.__m_RemotePort;
    }

    public java.net.Socket getSocket() {
        return this.__m_Socket;
    }

    public int getSoLinger() {
        return this.__m_SoLinger;
    }

    protected void initializeSocket(java.net.Socket socket) throws IOException {
        int cLinger;
        int cMillis;
        int cbBuffer = this.getBufferLength();
        if (cbBuffer > 0) {
            socket.setSendBufferSize(cbBuffer);
            this.validateBufferSize("send", socket.getSendBufferSize(), cbBuffer, cbBuffer);
            socket.setReceiveBufferSize(cbBuffer);
            this.validateBufferSize("receive", socket.getReceiveBufferSize(), cbBuffer, cbBuffer);
        }
        if ((cMillis = this.getSoTimeout()) >= 0) {
            socket.setSoTimeout(cMillis);
            this.validateSoTimeout(socket.getSoTimeout(), cMillis);
        }
        socket.setSoLinger((cLinger = this.getSoLinger()) >= 0, Math.max(cLinger, 0));
        socket.setTcpNoDelay(this.isTcpNoDelay());
        socket.setKeepAlive(this.isKeepAlive());
    }

    protected java.net.Socket instantiateSocket() throws IOException {
        InetAddress addrLocal = this.getInetAddress();
        InetAddress addrRemote = this.getRemoteInetAddress();
        int nPortRemote = this.getRemotePort();
        TcpSocket._assert(addrRemote != null, "TcpSocket.open: RemoteInetAddress is required");
        TcpSocket._assert(nPortRemote > 0 && nPortRemote <= 65535, "TcpSocket.open: RemotePort out of range (" + nPortRemote + ")");
        java.net.Socket socket = this.getProvider().openSocket();
        try {
            if (addrLocal != null) {
                int nPortLocal = this.getPort();
                TcpSocket._assert(nPortLocal > 0 && nPortLocal <= 65535, "TcpSocket.open: Port out of range (" + nPortLocal + ")");
                socket.bind(new InetSocketAddress(addrLocal, nPortLocal));
            }
            socket.connect(new InetSocketAddress(addrRemote, nPortRemote), this.getSoTimeout());
        }
        catch (IOException e) {
            socket.close();
            throw e;
        }
        return socket;
    }

    public boolean isKeepAlive() {
        return this.__m_KeepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.__m_TcpNoDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() != 1) {
                java.net.Socket socket = this.instantiateSocket();
                try {
                    this.initializeSocket(socket);
                    this.setSocket(socket);
                }
                catch (RuntimeException e) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setSocket(null);
                    throw e;
                }
                this.setState(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferLength(int cb) {
        TcpSocket._assert(cb > 0);
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == 1) {
                java.net.Socket socket = this.getSocket();
                try {
                    socket.setSendBufferSize(cb);
                    this.validateBufferSize("send", socket.getSendBufferSize(), cb, cb);
                    socket.setReceiveBufferSize(cb);
                    this.validateBufferSize("receive", socket.getReceiveBufferSize(), cb, cb);
                }
                catch (SocketException e) {
                    throw new WrapperException(e);
                }
            }
            this.__m_BufferLength = cb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeepAlive(boolean fKeepAlive) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == 1) {
                try {
                    this.getSocket().setKeepAlive(fKeepAlive);
                }
                catch (SocketException e) {
                    throw new WrapperException(e);
                }
                catch (NoSuchMethodError e) {
                    return;
                }
            }
            this.__m_KeepAlive = fKeepAlive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteInetAddress(InetAddress addr) {
        Object object = this.getLock();
        synchronized (object) {
            TcpSocket._assert(this.getState() == 0, "RemoteInetAddress cannot be modified once the socket has been opened");
            this.__m_RemoteInetAddress = addr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemotePort(int nPort) {
        Object object = this.getLock();
        synchronized (object) {
            TcpSocket._assert(this.getState() == 0, "RemotePort cannot be modified once the socket has been opened");
            this.__m_RemotePort = nPort;
        }
    }

    protected void setSocket(java.net.Socket socket) {
        this.__m_Socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoLinger(int cLinger) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == 1) {
                try {
                    this.getSocket().setSoLinger(cLinger >= 0, Math.max(cLinger, 0));
                }
                catch (SocketException e) {
                    throw new WrapperException(e);
                }
            }
            this.__m_SoLinger = cLinger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSoTimeout(int cMillis) {
        if (cMillis >= 0) {
            Object object = this.getLock();
            synchronized (object) {
                if (this.getState() == 1) {
                    java.net.Socket socket = this.getSocket();
                    try {
                        socket.setSoTimeout(cMillis);
                        this.validateSoTimeout(socket.getSoTimeout(), cMillis);
                    }
                    catch (SocketException e) {
                        throw new WrapperException(e);
                    }
                }
                super.setSoTimeout(cMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTcpNoDelay(boolean fNoDelay) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == 1) {
                try {
                    this.getSocket().setTcpNoDelay(fNoDelay);
                }
                catch (SocketException e) {
                    throw new WrapperException(e);
                }
            }
            this.__m_TcpNoDelay = fNoDelay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownInput() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == 1) {
                try {
                    this.getSocket().shutdownInput();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownOutput() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            if (this.getState() == 1) {
                try {
                    this.getSocket().shutdownOutput();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
    }
}

