/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.security;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.internal.net.security.DefaultStandardDependencies;
import com.tangosol.internal.net.security.StandardDependencies;
import com.tangosol.net.ClusterPermission;
import com.tangosol.net.Service;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.security.AccessController;
import com.tangosol.net.security.PermissionInfo;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.security.AccessControlException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;

public class Standard
extends Security {
    private StandardDependencies __m_Dependencies;
    private transient Map __m_ServiceContext;
    private transient ThreadLocal __m_ThreadContext;
    private Map __m_ValidSubjects;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("CheckPermissionAction", Security.CheckPermissionAction.get_CLASS());
        __mapChildren.put("ConfigAction", Security.ConfigAction.get_CLASS());
        __mapChildren.put("CreateLoginCtxAction", CreateLoginCtxAction.get_CLASS());
        __mapChildren.put("RefAction", Security.RefAction.get_CLASS());
    }

    public Standard() {
        this(null, null, true);
    }

    public Standard(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_ServiceContext = new SafeHashMap();
            this.__m_ThreadContext = new ThreadLocal();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public static Component get_Instance() {
        return new Standard();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/security/Standard".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public void checkPermission(com.tangosol.net.Cluster cluster, ClusterPermission permission, Subject subject) {
        Cluster.ClusterService clusterservice;
        Grid service;
        String sService = permission.getServiceName();
        Standard._assert(sService != null);
        if (subject == null) {
            subject = (Subject)this.getThreadContext().get();
        }
        if (subject == null) {
            subject = SecurityHelper.getCurrentSubject();
        }
        boolean fValid = false;
        if (subject == null) {
            subject = this.loginSecure(this.getDependencies().getCallbackHandler(), null);
        } else {
            try {
                this.validateSubject(sService, subject);
                fValid = true;
            }
            catch (SecurityException ex) {
                subject = this.loginSecure(this.getDependencies().getCallbackHandler(), subject);
            }
        }
        if (subject == null) {
            throw new SecurityException("Attempt to access a protected resource was made without credentials");
        }
        if (!fValid) {
            this.validateSubject(sService, subject);
        }
        AccessController controller = this.getDependencies().getAccessController();
        controller.checkPermission(permission, subject);
        if (cluster == null || !cluster.isRunning()) {
            return;
        }
        if (cluster instanceof SafeCluster) {
            cluster = ((SafeCluster)cluster).getCluster();
        }
        if ((service = (clusterservice = ((Cluster)cluster).getClusterService()).getService(sService)) != null && service.isRunning()) {
            return;
        }
        clusterservice.getServiceContext().put(sService, this.encryptPermissionInfo(permission, subject));
    }

    protected PermissionInfo encryptPermissionInfo(ClusterPermission permission, Subject subject) {
        try {
            return new PermissionInfo(permission, permission.getServiceName(), this.getDependencies().getAccessController().encrypt(permission, subject), subject);
        }
        catch (Exception e) {
            throw new SecurityException("Invalid subject credentials: " + String.valueOf(e));
        }
    }

    public StandardDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    private Map getServiceContext() {
        return this.__m_ServiceContext;
    }

    private ThreadLocal getThreadContext() {
        return this.__m_ThreadContext;
    }

    private Map getValidSubjects() {
        return this.__m_ValidSubjects;
    }

    @Override
    public Subject impersonate(Subject subject, String sNameOld, String sNameNew) {
        Subject subjectNew = new Subject();
        for (Principal p : subject.getPrincipals()) {
            String sName = p.getName();
            if (sName.indexOf(sNameOld) >= 0) {
                try {
                    sName = Base.replace(sName, sNameOld, sNameNew);
                    p = (Principal)ClassHelper.newInstance(p.getClass(), new Object[]{sName});
                    Standard._trace("Successfully impersonated " + String.valueOf(p) + "@" + String.valueOf(p.getClass()));
                }
                catch (Exception e) {
                    Standard._trace("Cannot impersonate " + String.valueOf(p) + "@" + String.valueOf(p.getClass()));
                }
            }
            subjectNew.getPrincipals().add(p);
        }
        subjectNew.getPublicCredentials().addAll(subject.getPublicCredentials());
        subjectNew.getPrivateCredentials().addAll(subject.getPrivateCredentials());
        return subjectNew;
    }

    @Override
    protected Subject loginSecure(CallbackHandler handler, Subject subject) {
        CreateLoginCtxAction action = new CreateLoginCtxAction();
        action.setDependencies(this.getDependencies());
        action.setHandler(handler);
        action.setSubject(subject);
        LoginContext lc = (LoginContext)java.security.AccessController.doPrivileged(action);
        try {
            lc.login();
            return lc.getSubject();
        }
        catch (Exception e) {
            throw new SecurityException("Authentication failed: " + e.getMessage());
        }
    }

    protected void onDependencies(StandardDependencies deps) {
        Standard.processDependencies(deps);
    }

    @Override
    public void onInit() {
        this.setValidSubjects(new LocalCache(Integer.MAX_VALUE, 300000));
        super.onInit();
    }

    @Override
    public Object processSecureRequest(Member memberThis, Member memberFrom, PermissionInfo piRequest) {
        ClusterPermission permission;
        Subject subjCurrent;
        AccessController controller = this.getDependencies().getAccessController();
        String sService = piRequest.getServiceName();
        Subject subjRequestor = piRequest.getSubject();
        try {
            subjCurrent = (Subject)this.getServiceContext().get(sService);
            if (subjCurrent == null) {
                return new RuntimeException("No service context");
            }
            permission = memberFrom.equals(memberThis) ? piRequest.getPermission() : (ClusterPermission)controller.decrypt(piRequest.getSignedPermission(), subjRequestor, subjCurrent);
            Standard._trace("Remote permission request: " + String.valueOf(permission) + " by " + String.valueOf(memberFrom), 3);
            controller.checkPermission(permission, subjRequestor);
        }
        catch (Exception e) {
            return Base.ensureRuntimeException(e, "Remote permission check failed");
        }
        try {
            return this.encryptPermissionInfo(permission, subjCurrent);
        }
        catch (Exception e) {
            return Base.ensureRuntimeException(e, "Remote encryption failed");
        }
    }

    @Override
    public void releaseSecureContext(String sServiceName) {
        this.getServiceContext().remove(sServiceName);
    }

    public static Object runAnonymously(Object oAction) throws PrivilegedActionException {
        return Security.runAnonymously(oAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object runSecure(Subject subject, Object oAction) throws PrivilegedActionException {
        if (subject == null) {
            return Standard.runAnonymously(oAction);
        }
        this.getThreadContext().set(subject);
        try {
            Object t = oAction instanceof PrivilegedAction ? Subject.doAs(subject, (PrivilegedAction)oAction) : Subject.doAs(subject, (PrivilegedExceptionAction)oAction);
            return t;
        }
        finally {
            this.getThreadContext().set(null);
        }
    }

    public void setDependencies(StandardDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Dependencies already set");
        }
        this.__m_Dependencies = new DefaultStandardDependencies(deps).validate();
        this.onDependencies(this.getDependencies());
    }

    private void setServiceContext(Map mapCtx) {
        this.__m_ServiceContext = mapCtx;
    }

    private void setThreadContext(ThreadLocal ctx) {
        this.__m_ThreadContext = ctx;
    }

    private void setValidSubjects(Map cache) {
        this.__m_ValidSubjects = cache;
    }

    protected void validateSubject(String sService, Subject subject) {
        Map mapContext;
        Subject subjCurrent;
        Map mapValid = this.getValidSubjects();
        if (!mapValid.containsKey(subject)) {
            AccessController controller = this.getDependencies().getAccessController();
            Double oTest = Math.random();
            try {
                Object o = controller.decrypt(controller.encrypt(oTest, subject), subject, null);
                Standard._assert(o.equals(oTest));
                mapValid.put(subject, null);
            }
            catch (Exception e) {
                Standard._trace("Failed to verify the subject: " + String.valueOf(subject) + " due to: " + e.getMessage(), 3);
                throw new SecurityException("Failed to verify the subject");
            }
        }
        if ((subjCurrent = (Subject)(mapContext = this.getServiceContext()).get(sService)) == null) {
            mapContext.put(sService, subject);
        }
    }

    @Override
    public void verifySecureResponse(Service service, PermissionInfo info) {
        Subject subject = (Subject)this.getServiceContext().get(service.getInfo().getServiceName());
        ClusterPermission permission = null;
        try {
            permission = (ClusterPermission)this.getDependencies().getAccessController().decrypt(info.getSignedPermission(), info.getSubject(), subject);
        }
        catch (GeneralSecurityException e) {
            throw new AccessControlException("Security configuration mismatch or break-in attempt", permission);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Security configuration mismatch");
        }
    }

    static {
        Standard.__initStatic();
    }

    public static class CreateLoginCtxAction
    extends Util
    implements PrivilegedAction {
        private StandardDependencies __m_Dependencies;
        private CallbackHandler __m_Handler;
        private Subject __m_Subject;

        public CreateLoginCtxAction() {
            this(null, null, true);
        }

        public CreateLoginCtxAction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new CreateLoginCtxAction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/security/Standard$CreateLoginCtxAction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public StandardDependencies getDependencies() {
            return this.__m_Dependencies;
        }

        public CallbackHandler getHandler() {
            return this.__m_Handler;
        }

        public Subject getSubject() {
            return this.__m_Subject;
        }

        public Object run() {
            LoginContext lc;
            StandardDependencies dps = this.getDependencies();
            CallbackHandler handler = this.getHandler();
            Subject subject = this.getSubject();
            try {
                lc = handler == null ? (subject == null ? new LoginContext(dps.getLoginModuleName()) : new LoginContext(dps.getLoginModuleName(), subject)) : (subject == null ? new LoginContext(dps.getLoginModuleName(), handler) : new LoginContext(dps.getLoginModuleName(), subject, handler));
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Failed to create LoginContext");
            }
            return lc;
        }

        public void setDependencies(StandardDependencies dependencies) {
            this.__m_Dependencies = dependencies;
        }

        public void setHandler(CallbackHandler handler) {
            this.__m_Handler = handler;
        }

        public void setSubject(Subject subject) {
            this.__m_Subject = subject;
        }
    }
}

