/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet.messagePacket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.sql.Time;
import java.util.Iterator;

public class Sequel
extends MessagePacket {
    public Sequel() {
        this(null, null, true);
    }

    public Sequel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDeliveryState(0);
            this.setPacketType(232718552);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    @Override
    public boolean isConfirmationRequired() {
        return true;
    }

    public static Component get_Instance() {
        return new Sequel();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/packet/messagePacket/Sequel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public static int calcHeaderLength(MemberSet memberSet) {
        switch (Sequel.selectType(memberSet)) {
            case 0: {
                return 0;
            }
            case 232718553: {
                return 16;
            }
            case 232718551: {
                return 5 + 2 * memberSet.size() + 2 + 3 + 3 + 2;
            }
            case 232718552: {
                return 5 + 4 * ((memberSet.getLastId() + 31) / 32) + 2 + 3 + 3 + 2;
            }
        }
        throw new IllegalArgumentException("Unknown type");
    }

    @Override
    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("ToMemberSet=");
        DependentMemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            sb.append("null");
        } else {
            sb.append('[');
            boolean fFirst = true;
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                Member member = (Member)iter.next();
                int nMember = member.getId();
                sb.append(nMember);
            }
            sb.append(']');
        }
        long ldtResend = this.getResendScheduled();
        long ldtTimeout = this.getResendTimeout();
        String sResend = ldtResend <= 0L ? "none" : new Time(ldtResend).toString() + "." + ldtResend % 1000L;
        String sTimeout = ldtTimeout <= 0L ? "none" : new Time(ldtTimeout).toString() + "." + ldtTimeout % 1000L;
        sb.append(", ServiceId=").append(this.getServiceId()).append(", MessageType=").append(this.getMessageType()).append(", FromMessageId=").append(this.getFromMessageId()).append(", MessagePartCount=").append(this.getMessagePartCount()).append(", MessagePartIndex=").append(this.getMessagePartIndex()).append(", NackInProgress=").append(this.isNackInProgress()).append(", ResendScheduled=").append(sResend).append(", Timeout=").append(sTimeout).append(", PendingResendSkips=").append(this.getPendingResendSkips()).append(", DeliveryState=").append(this.formatDeliveryState(this.getDeliveryState())).append(", Body=");
        if (this.isOutgoing()) {
            sb.append(this.getReadBuffer() == null ? "Empty" : Base.toHexEscape(this.getReadBuffer().toByteArray()));
        } else {
            sb.append(this.getByteBuffer() == null ? "Empty" : Base.toHexEscape(new ByteBufferReadBuffer(this.getByteBuffer()).toByteArray()));
        }
        return sb.toString();
    }

    @Override
    public int getHeaderLength() {
        return Sequel.calcHeaderLength(this.getToMemberSet());
    }

    @Override
    public void read(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
        switch (this.getPacketType()) {
            case 232718553: {
                input.readUnsignedShort();
                break;
            }
            case 232718551: {
                input.skip(input.readUnsignedByte() << 1);
                break;
            }
            case 232718552: {
                input.skip(input.readUnsignedByte() << 2);
                break;
            }
            default: {
                throw new IOException("unknown packet type: " + this.getPacketType());
            }
        }
        this.setFromId(input.readUnsignedShort());
        this.setFromMessageId(Sequel.readUnsignedTrint(input));
        this.setMessagePartIndex(Sequel.readUnsignedTrint(input));
        this.setBodyLength(input.readUnsignedShort());
        Sequel.assertIO(input.available() >= this.getBodyLength());
    }

    protected static int selectType(MemberSet memberSet) {
        int cMembers = memberSet == null ? 1 : memberSet.size();
        switch (cMembers) {
            case 0: {
                return 0;
            }
            case 1: {
                return 232718553;
            }
            case 2: {
                return 232718551;
            }
        }
        if (cMembers > 255) {
            return 232718552;
        }
        return 15 + 2 * cMembers <= 15 + 4 * ((memberSet.getLastId() + 31) / 32) ? 232718551 : 232718552;
    }

    public static void skip(ReadBuffer.BufferInput input, int nType) throws IOException {
        int cbSkip = 0;
        switch (nType) {
            case 232718553: {
                cbSkip += 2;
                break;
            }
            case 232718551: {
                cbSkip += input.readUnsignedByte() << 1;
                break;
            }
            case 232718552: {
                cbSkip += input.readUnsignedByte() << 2;
                break;
            }
            default: {
                throw new IOException("unknown packet type: " + nType);
            }
        }
        Sequel.ensureSkipBytes(input, cbSkip += 8);
        Sequel.ensureSkipBytes(input, input.readUnsignedShort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(WriteBuffer.BufferOutput output) throws IOException {
        DependentMemberSet memberSet = this.getToMemberSet();
        if (memberSet == null) {
            this.setPacketType(232718553);
            output.writeInt(232718553);
            output.writeShort(this.getToId());
        } else {
            DependentMemberSet dependentMemberSet = memberSet;
            synchronized (dependentMemberSet) {
                int nType = Sequel.selectType(memberSet);
                if (nType == 0) {
                    return;
                }
                this.setPacketType(nType);
                output.writeInt(nType);
                switch (nType) {
                    case 232718553: {
                        memberSet.writeOne(output);
                        break;
                    }
                    case 232718551: {
                        memberSet.writeFew(output);
                        break;
                    }
                    case 232718552: {
                        memberSet.writeMany(output);
                        break;
                    }
                    default: {
                        throw new IOException("unknown packet type: " + nType);
                    }
                }
            }
        }
        output.writeShort(this.getFromId());
        Sequel.writeTrint(output, this.getFromMessageId());
        Sequel.writeTrint(output, this.getMessagePartIndex());
        output.writeShort(this.getBodyLength());
        output.writeBuffer(this.getReadBuffer());
    }
}

