/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet.messagePacket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.sql.Time;
import java.util.Iterator;

public class Directed
extends MessagePacket {
    private int __m_ToMessageId;

    public Directed() {
        this(null, null, true);
    }

    public Directed(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDeliveryState(0);
            this.setPacketType(232718548);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    @Override
    public boolean isConfirmationRequired() {
        return true;
    }

    public static Component get_Instance() {
        return new Directed();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/packet/messagePacket/Directed".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public static int calcHeaderLength(MemberSet memberSet) {
        switch (Directed.selectType(memberSet)) {
            case 0: {
                return 0;
            }
            case 232718549: {
                return 23;
            }
            case 232718547: {
                return 19 + 5 * memberSet.size();
            }
            case 232718548: {
                return 21 + 3 * memberSet.size() + 4 * (memberSet.getLastId() + 31) / 32;
            }
        }
        throw new IllegalArgumentException("Unknwon type");
    }

    @Override
    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("ToMemberSet=");
        DependentMemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            sb.append("null");
        } else {
            sb.append('[');
            boolean fFirst = true;
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                Member member = (Member)iter.next();
                int nMember = member.getId();
                sb.append(nMember);
                int nToMsgId = setMember.getDestinationMessageId(nMember);
                if (nToMsgId == 0) continue;
                sb.append('(').append(nToMsgId).append(')');
            }
            sb.append(']');
        }
        long ldtResend = this.getResendScheduled();
        long ldtTimeout = this.getResendTimeout();
        String sResend = ldtResend <= 0L ? "none" : new Time(ldtResend).toString() + "." + ldtResend % 1000L;
        String sTimeout = ldtTimeout <= 0L ? "none" : new Time(ldtTimeout).toString() + "." + ldtTimeout % 1000L;
        sb.append(", ServiceId=").append(this.getServiceId()).append(", MessageType=").append(this.getMessageType()).append(", FromMessageId=").append(this.getFromMessageId()).append(", ToMessageId=").append(this.getToMessageId()).append(", MessagePartCount=").append(this.getMessagePartCount()).append(", MessagePartIndex=").append(this.getMessagePartIndex()).append(", NackInProgress=").append(this.isNackInProgress()).append(", ResendScheduled=").append(sResend).append(", Timeout=").append(sTimeout).append(", PendingResendSkips=").append(this.getPendingResendSkips()).append(", DeliveryState=").append(this.formatDeliveryState(this.getDeliveryState())).append(", HeaderLength=").append(this.getHeaderLength()).append(", BodyLength=").append(this.getBodyLength()).append(", Body=");
        if (this.isOutgoing()) {
            sb.append(this.getReadBuffer() == null ? "Empty" : Base.toHexEscape(this.getReadBuffer().toByteArray()));
        } else {
            sb.append(this.getByteBuffer() == null ? "Empty" : Base.toHexEscape(new ByteBufferReadBuffer(this.getByteBuffer()).toByteArray()));
        }
        return sb.toString();
    }

    public int getDestinationMessageId(int nMemberId) {
        if (nMemberId == this.getToId()) {
            return this.getToMessageId();
        }
        DependentMemberSet setMember = this.getToMemberSet();
        if (setMember != null) {
            return setMember.getDestinationMessageId(nMemberId);
        }
        return 0;
    }

    @Override
    public int getHeaderLength() {
        return Directed.calcHeaderLength(this.getToMemberSet());
    }

    public int getToMessageId() {
        return this.__m_ToMessageId;
    }

    @Override
    public void read(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
        int cMembers = 0;
        int iMember = -1;
        switch (this.getPacketType()) {
            case 232718549: {
                int nIdTmp = input.readUnsignedShort();
                Directed.assertIO(nIdTmp == nMemberId);
                cMembers = 1;
                iMember = 0;
                break;
            }
            case 232718547: {
                cMembers = input.readUnsignedByte();
                for (int i = 0; i < cMembers; ++i) {
                    if (input.readUnsignedShort() != nMemberId) continue;
                    iMember = i;
                }
                break;
            }
            case 232718548: {
                int cBitSets = input.readUnsignedByte();
                int nTheSet = Member.calcByteOffset(nMemberId);
                int nTheMask = Member.calcByteMask(nMemberId);
                int nPartial = nTheMask >>> 1;
                int i = 1;
                int iShift = 1;
                while (i <= 5) {
                    nPartial |= nPartial >>> iShift;
                    ++i;
                    iShift <<= 1;
                }
                for (i = 0; i < cBitSets; ++i) {
                    int nBits = input.readInt();
                    if (i == nTheSet) {
                        Directed.assertIO((nBits & nTheMask) != 0);
                        iMember = cMembers + MemberSet.countBits(nBits & nPartial);
                    }
                    cMembers += MemberSet.countBits(nBits);
                }
                int cMembersTmp = input.readUnsignedShort();
                Directed.assertIO(cMembersTmp == cMembers);
                break;
            }
            default: {
                throw new IOException("unknown packet type: " + this.getPacketType());
            }
        }
        Directed.assertIO(cMembers > 0 && iMember >= 0 && iMember < cMembers);
        int cbSkip = iMember * 3;
        if (cbSkip > 0) {
            long cbSkipped = input.skip(cbSkip);
            Directed.assertIO(cbSkipped == (long)cbSkip);
        }
        this.setToMessageId(Directed.readUnsignedTrint(input));
        cbSkip = (cMembers - iMember - 1) * 3;
        if (cbSkip > 0) {
            long cbSkipped = input.skip(cbSkip);
            Directed.assertIO(cbSkipped == (long)cbSkip);
        }
        this.setFromId(input.readUnsignedShort());
        this.setFromMessageId(Directed.readUnsignedTrint(input));
        this.setMessagePartCount(Directed.readUnsignedTrint(input));
        this.setServiceId(input.readUnsignedShort());
        this.setMessageType(input.readShort());
        this.setBodyLength(input.readUnsignedShort());
        Directed.assertIO(input.available() >= this.getBodyLength());
    }

    protected static int selectType(MemberSet memberSet) {
        int cMembers = memberSet == null ? 1 : memberSet.size();
        switch (cMembers) {
            case 0: {
                return 0;
            }
            case 1: {
                return 232718549;
            }
            case 2: 
            case 3: {
                return 232718547;
            }
        }
        if (cMembers > 255) {
            return 232718548;
        }
        return 19 + 5 * cMembers <= 21 + 3 * cMembers + 4 * ((memberSet.getLastId() + 31) / 32) ? 232718547 : 232718548;
    }

    public void setToMessageId(int nId) {
        this.__m_ToMessageId = nId;
    }

    public static void skip(ReadBuffer.BufferInput input, int nType) throws IOException {
        int cMembers = 0;
        int cbSkip = 0;
        switch (nType) {
            case 232718549: {
                cMembers = 1;
                cbSkip += 2;
                break;
            }
            case 232718547: {
                cMembers = input.readUnsignedByte();
                cbSkip += cMembers << 1;
                break;
            }
            case 232718548: {
                int cBitSets = input.readUnsignedByte();
                Directed.ensureSkipBytes(input, cbSkip += cBitSets << 2);
                cbSkip = 0;
                cMembers = input.readUnsignedShort();
                break;
            }
            default: {
                throw new IOException("unknown packet type: " + nType);
            }
        }
        cbSkip += cMembers * 3;
        Directed.ensureSkipBytes(input, cbSkip += 12);
        Directed.ensureSkipBytes(input, input.readUnsignedShort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(WriteBuffer.BufferOutput output) throws IOException {
        DependentMemberSet memberSet = this.getToMemberSet();
        if (memberSet == null) {
            this.setPacketType(232718549);
            output.writeInt(232718549);
            output.writeShort(this.getToId());
            Directed.writeTrint(output, this.getToMessageId());
        } else {
            DependentMemberSet dependentMemberSet = memberSet;
            synchronized (dependentMemberSet) {
                int nType = Directed.selectType(memberSet);
                if (nType == 0) {
                    return;
                }
                this.setPacketType(nType);
                output.writeInt(nType);
                switch (nType) {
                    case 232718549: {
                        memberSet.writeOneWithMessageId(output);
                        break;
                    }
                    case 232718547: {
                        memberSet.writeFewWithMessageId(output);
                        break;
                    }
                    case 232718548: {
                        memberSet.writeManyWithMessageId(output);
                        break;
                    }
                    default: {
                        throw new IOException("unknown packet type: " + nType);
                    }
                }
            }
        }
        output.writeShort(this.getFromId());
        Directed.writeTrint(output, this.getFromMessageId());
        Directed.writeTrint(output, this.getMessagePartCount());
        output.writeShort(this.getServiceId());
        output.writeShort(this.getMessageType());
        output.writeShort(this.getBodyLength());
        output.writeBuffer(this.getReadBuffer());
    }
}

