/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet.messagePacket;

import com.oracle.coherence.common.base.Disposable;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class Broadcast
extends MessagePacket {
    private transient Disposable __m_BufferController;
    private transient ByteBuffer __m_ClusterNameBuffer;
    private InetSocketAddress __m_FromAddress;
    private transient InetSocketAddress[] __m_ToAddress;

    public Broadcast() {
        this(null, null, true);
    }

    public Broadcast(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setDeliveryState(0);
            this.setMessagePartCount(1);
            this.setMessagePartIndex(0);
            this.setPacketType(232718546);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    @Override
    public boolean isOutgoingBroadcast() {
        return true;
    }

    public static Component get_Instance() {
        return new Broadcast();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/packet/messagePacket/Broadcast".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public static int calcBodyLength(int cbHeader, int cbPref, int cbMax) {
        return cbMax - cbHeader;
    }

    public int calcHeaderLength() {
        return 10 + this.getClusterNameBuffer().remaining();
    }

    public Disposable getBufferController() {
        return this.__m_BufferController;
    }

    public ByteBuffer getClusterNameBuffer() {
        return this.__m_ClusterNameBuffer;
    }

    @Override
    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("MessageType=").append(this.getMessageType()).append(", ServiceId=").append(this.getServiceId()).append(", MessagePartCount=").append(this.getMessagePartCount()).append(", MessagePartIndex=").append(this.getMessagePartIndex()).append(", Body=");
        if (this.isOutgoing()) {
            sb.append(this.getReadBuffer() == null ? "Empty" : Base.toHexEscape(this.getReadBuffer().toByteArray()));
        } else {
            sb.append(this.getByteBuffer() == null ? "Empty" : Base.toHexEscape(new ByteBufferReadBuffer(this.getByteBuffer()).toByteArray()));
        }
        return sb.toString();
    }

    public InetSocketAddress getFromAddress() {
        return this.__m_FromAddress;
    }

    @Override
    public int getHeaderLength() {
        return this.calcHeaderLength();
    }

    public InetSocketAddress[] getToAddress() {
        return this.__m_ToAddress;
    }

    public InetSocketAddress getToAddress(int i) {
        return this.getToAddress()[i];
    }

    @Override
    public void read(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
        Broadcast.ensureSkipBytes(input, input.readUnsignedShort());
        this.setFromId(input.readUnsignedShort());
        this.setMessageType(input.readShort());
        this.setBodyLength(input.readUnsignedShort());
        Broadcast.assertIO(input.available() >= this.getBodyLength());
    }

    public void setBufferController(Disposable controller) {
        this.__m_BufferController = controller;
    }

    public void setClusterNameBuffer(ByteBuffer bufBuffer) {
        this.__m_ClusterNameBuffer = bufBuffer;
    }

    public void setFromAddress(InetSocketAddress addressFrom) {
        this.__m_FromAddress = addressFrom;
    }

    public void setToAddress(InetSocketAddress[] aaddressTo) {
        this.__m_ToAddress = aaddressTo;
    }

    public void setToAddress(int i, InetSocketAddress addressTo) {
        this.getToAddress()[i] = addressTo;
    }

    public static void skip(ReadBuffer.BufferInput input, int nType) throws IOException {
        Broadcast.ensureSkipBytes(input, input.readUnsignedShort());
        input.readUnsignedShort();
        input.readShort();
        Broadcast.ensureSkipBytes(input, input.readUnsignedShort());
    }

    @Override
    public void write(WriteBuffer.BufferOutput output) throws IOException {
        ByteBuffer bufName = this.getClusterNameBuffer();
        output.writeInt(232718546);
        output.write(bufName.array(), bufName.arrayOffset() + bufName.position(), bufName.remaining());
        output.writeShort(this.getFromId());
        output.writeShort(this.getMessageType());
        output.writeShort(this.getBodyLength());
        output.writeBuffer(this.getReadBuffer());
    }
}

