/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.BackupRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import java.io.IOException;
import java.util.Map;

public abstract class BackupSingleRequest
extends BackupRequest
implements Continuation {
    private int __m_Partition;
    private long __m_PartitionVersion;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Poll", Poll.get_CLASS());
    }

    public BackupSingleRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/message/requestMessage/chainedRequest/backupRequest/BackupSingleRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public Message cloneMessage() {
        BackupSingleRequest msg = (BackupSingleRequest)super.cloneMessage();
        msg.setPartition(this.getPartition());
        msg.setPartitionVersion(this.getPartitionVersion());
        msg.setSyncMsg(this.isSyncMsg());
        return msg;
    }

    public void doBackup() {
    }

    @Override
    public String getDescription() {
        return super.getDescription() + "\nPartition=" + this.getPartition() + "\nPartitionVersion=" + this.getPartitionVersion();
    }

    public int getPartition() {
        return this.__m_Partition;
    }

    public long getPartitionVersion() {
        return this.__m_PartitionVersion;
    }

    @Override
    public void onReceived() {
        int nPartition;
        PartitionedService service = (PartitionedService)this.getService();
        PartitionedService.PartitionControl control = service.getPartitionControl(nPartition = this.getPartition());
        if (control != null && (service.isBackupOwner(nPartition) || control.isTransferringOut())) {
            service.processBackup(this);
        } else {
            int nMemberOriginator = this.getOriginatingMemberId();
            Member memberOriginator = service.getServiceMemberSet().getMember(nMemberOriginator);
            if (this.isConfirmed() || memberOriginator == null) {
                BackupSingleRequest._trace("Discarding " + this.get_Name() + " for unowned partition " + nPartition + " originating from member " + nMemberOriginator, 5);
                this.forwardOrReply(this);
            } else {
                service.sendPingRequest(memberOriginator, this);
            }
        }
    }

    public void proceed(Object oResult) {
        this.setConfirmed(true);
        this.onReceived();
    }

    @Override
    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        this.setPartition(ExternalizableHelper.readInt(input));
        this.setPartitionVersion(ExternalizableHelper.readLong(input));
    }

    public void setPartition(int iPart) {
        this.__m_Partition = iPart;
    }

    public void setPartitionVersion(long lVersion) {
        this.__m_PartitionVersion = lVersion;
    }

    @Override
    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        ExternalizableHelper.writeInt(output, this.getPartition());
        ExternalizableHelper.writeLong(output, this.getPartitionVersion());
    }

    static {
        BackupSingleRequest.__initStatic();
    }

    public static class Poll
    extends BackupRequest.Poll {
        public Poll() {
            this(null, null, true);
        }

        public Poll(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Poll();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/message/requestMessage/chainedRequest/backupRequest/BackupSingleRequest$Poll".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public boolean isCloseableOnDelivery() {
            BackupSingleRequest msgBackup;
            PartitionedService.PartitionControl control;
            return super.isCloseableOnDelivery() && (control = ((PartitionedService)(msgBackup = (BackupSingleRequest)this.get_Module()).getService()).getPartitionControl(msgBackup.getPartition())) != null && control.getVersionBackup() == msgBackup.getPartitionVersion() - 1L;
        }
    }
}

