/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.backupRequest;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.message.requestMessage.chainedRequest.BackupRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.PrimitiveSparseArray;
import java.io.IOException;
import java.util.Map;

public abstract class BackupMultiRequest
extends BackupRequest
implements Continuation {
    private PrimitiveSparseArray __m_PartitionVersions;
    private transient PartitionSet __m_SkipPartitions;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Poll", Poll.get_CLASS());
    }

    public BackupMultiRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/message/requestMessage/chainedRequest/backupRequest/BackupMultiRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public Message cloneMessage() {
        BackupMultiRequest msg = (BackupMultiRequest)super.cloneMessage();
        msg.setPartitionVersions(new PrimitiveSparseArray(this.getPartitionVersions()));
        msg.setSyncMsg(this.isSyncMsg());
        return msg;
    }

    public void doBackup(PartitionSet partsSkip) {
    }

    @Override
    public String getDescription() {
        PartitionSet partsSkip = this.getSkipPartitions();
        return super.getDescription() + "\nPartitionVersions=" + String.valueOf(this.getPartitionVersions()) + (String)(partsSkip == null ? "" : "\nSkip=" + String.valueOf(partsSkip)) + "\nSyncMsg=" + this.isSyncMsg() + "; Confirmed=" + this.isConfirmed();
    }

    public PartitionSet getPartitionSet() {
        PartitionSet parts = new PartitionSet(((PartitionedService)this.getService()).getPartitionCount());
        PrimitiveSparseArray.Iterator iter = this.getPartitionVersions().iterator();
        while (iter.hasNext()) {
            iter.nextPrimitive();
            parts.add((int)iter.getIndex());
        }
        PartitionSet partsSkip = this.getSkipPartitions();
        if (partsSkip != null) {
            parts.remove(partsSkip);
        }
        return parts;
    }

    public PrimitiveSparseArray getPartitionVersions() {
        return this.__m_PartitionVersions;
    }

    public PartitionSet getSkipPartitions() {
        return this.__m_SkipPartitions;
    }

    @Override
    public void onReceived() {
        PartitionedService service = (PartitionedService)this.getService();
        PartitionSet partsReject = null;
        PrimitiveSparseArray paVersions = this.getPartitionVersions();
        PrimitiveSparseArray.Iterator iter = paVersions.iterator();
        while (iter.hasNext()) {
            iter.nextPrimitive();
            int nPartition = (int)iter.getIndex();
            PartitionedService.PartitionControl control = service.getPartitionControl(nPartition);
            if (control != null && (service.isBackupOwner(nPartition) || control.isTransferringOut())) continue;
            if (partsReject == null) {
                partsReject = new PartitionSet(service.getPartitionCount());
            }
            partsReject.add(nPartition);
        }
        if (partsReject == null) {
            service.processBackupMulti(this);
        } else {
            int nMemberOriginator = this.getOriginatingMemberId();
            Member memberOriginator = service.getServiceMemberSet().getMember(nMemberOriginator);
            if (this.isConfirmed() || memberOriginator == null) {
                BackupMultiRequest._trace("Discarding " + this.get_Name() + " for unowned " + String.valueOf(partsReject) + " originating from member " + nMemberOriginator, 5);
                this.skipPartitions(partsReject);
                if (this.getPartitionSet().isEmpty()) {
                    this.forwardOrReply(this);
                } else {
                    service.processBackupMulti(this);
                }
            } else {
                service.sendPingRequest(memberOriginator, this);
            }
        }
    }

    public void proceed(Object oResult) {
        this.setConfirmed(true);
        this.onReceived();
    }

    @Override
    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        PrimitiveSparseArray paVersions = this.getPartitionVersions();
        int cPartitions = ExternalizableHelper.readInt(input);
        for (int i = 0; i < cPartitions; ++i) {
            int nPartition = ExternalizableHelper.readInt(input);
            long lVersion = ExternalizableHelper.readLong(input);
            paVersions.setPrimitive(nPartition, lVersion);
        }
    }

    public void setPartitionVersions(PrimitiveSparseArray arrayVersions) {
        this.__m_PartitionVersions = arrayVersions;
    }

    protected void setSkipPartitions(PartitionSet parts) {
        this.__m_SkipPartitions = parts;
    }

    public void skipPartition(int nPartition) {
        PartitionSet partsSkip = this.getSkipPartitions();
        if (partsSkip == null) {
            partsSkip = new PartitionSet(((PartitionedService)this.getService()).getPartitionCount());
            this.setSkipPartitions(partsSkip);
        }
        partsSkip.add(nPartition);
    }

    public void skipPartitions(PartitionSet partsSkip) {
        PartitionSet partsSkipped = this.getSkipPartitions();
        if (partsSkipped == null) {
            this.setSkipPartitions(new PartitionSet(partsSkip));
        } else {
            partsSkipped.add(partsSkip);
        }
    }

    @Override
    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        PrimitiveSparseArray paVersions = this.getPartitionVersions();
        int cPartitions = paVersions.getSize();
        ExternalizableHelper.writeInt(output, cPartitions);
        if (!this.isEstimating()) {
            PrimitiveSparseArray.Iterator iter = paVersions.iterator();
            while (iter.hasNext()) {
                long lVersion = iter.nextPrimitive();
                int nPartition = (int)iter.getIndex();
                ExternalizableHelper.writeInt(output, nPartition);
                ExternalizableHelper.writeLong(output, lVersion);
            }
        }
    }

    static {
        BackupMultiRequest.__initStatic();
    }

    public static class Poll
    extends BackupRequest.Poll {
        public Poll() {
            this(null, null, true);
        }

        public Poll(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Poll();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/message/requestMessage/chainedRequest/backupRequest/BackupMultiRequest$Poll".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public boolean isCloseableOnDelivery() {
            if (super.isCloseableOnDelivery()) {
                BackupMultiRequest msgBackup = (BackupMultiRequest)this.get_Module();
                PartitionedService service = (PartitionedService)msgBackup.getService();
                PrimitiveSparseArray.Iterator iter = msgBackup.getPartitionVersions().iterator();
                while (iter.hasNext()) {
                    iter.next();
                    PartitionedService.PartitionControl control = service.getPartitionControl((int)iter.getIndex());
                    if (control != null && control.getVersionBackup() == iter.getPrimitiveValue() - 1L) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

