/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message.requestMessage;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.memberSet.EmptyMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ListMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChainedRequest
extends RequestMessage {
    private transient ChainedRequest __m_IncomingRequest;
    private List __m_MemberList;
    private int __m_OriginatingMemberId;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Poll", Poll.get_CLASS());
    }

    public ChainedRequest() {
        this(null, null, true);
    }

    public ChainedRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new ChainedRequest();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/message/requestMessage/ChainedRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public Message cloneMessage() {
        ChainedRequest msg = (ChainedRequest)super.cloneMessage();
        msg.setMemberList(new ArrayList(this.getMemberList()));
        msg.setOriginatingMemberId(this.getOriginatingMemberId());
        return msg;
    }

    @Override
    protected void dispatch(Message msg) {
        ChainedRequest req = (ChainedRequest)msg;
        if (req.getOriginatingMemberId() == 0) {
            req.setOriginatingMemberId(req.getService().getThisMember().getId());
        }
        super.dispatch(req);
    }

    protected boolean forwardMessage(ChainedRequest msgIncoming) {
        if (this.isTerminal()) {
            return false;
        }
        ChainedRequest msgNext = (ChainedRequest)this.cloneMessage();
        msgNext.setIncomingRequest(msgIncoming);
        this.getService().post(msgNext);
        return true;
    }

    public void forwardOrReply(ChainedRequest msgIncoming) {
        if (!this.forwardMessage(msgIncoming)) {
            if (msgIncoming == null) {
                this.onRequestCompleted();
            } else {
                this.onRequestDelivered();
                Message msgResponse = msgIncoming.instantiateResponse();
                msgResponse.respondTo(msgIncoming);
                this.getService().post(msgResponse);
            }
        }
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        List listMembers = this.getMemberList();
        if (listMembers == null) {
            sb.append("all");
        } else {
            Iterator iter = listMembers.iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                sb.append(member.getId());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(']');
        return "MemberList=" + sb.toString();
    }

    public ChainedRequest getIncomingRequest() {
        return this.__m_IncomingRequest;
    }

    public List getMemberList() {
        return this.__m_MemberList;
    }

    public Member getOriginatingMember() {
        return this.getService().getServiceMemberSet().getMember(this.getOriginatingMemberId());
    }

    public int getOriginatingMemberId() {
        return this.__m_OriginatingMemberId;
    }

    @Override
    protected com.tangosol.coherence.component.net.Poll instantiatePoll() {
        return (Poll)this._newChild("Poll");
    }

    public Message instantiateResponse() {
        return this.getService().instantiateMessage("Response");
    }

    public boolean isTerminal() {
        List listMembers = this.getMemberList();
        if (listMembers == null) {
            return this.getIncomingRequest() != null && this.getService().getServiceMemberSet().getSuccessorMember() == null;
        }
        return listMembers.isEmpty();
    }

    @Override
    public void onReceived() {
        this.forwardOrReply(this);
    }

    public void onRequestCompleted() {
    }

    public void onRequestDelivered() {
    }

    @Override
    public void post() {
        List listMembers = this.getMemberList();
        if (listMembers == null) {
            this.setToMemberSet(MemberSet.instantiate(this.getIncomingRequest() == null ? this.getService().getServiceOldestMember() : this.getService().getServiceMemberSet().getSuccessorMember()));
        } else if (listMembers.isEmpty()) {
            this.setToMemberSet((EmptyMemberSet)EmptyMemberSet.get_Instance());
        } else {
            this.setToMemberSet(MemberSet.instantiate((Member)listMembers.remove(0)));
            if (listMembers.isEmpty()) {
                this.setMemberList(Collections.emptyList());
            }
        }
        super.post();
    }

    @Override
    public void read(ReadBuffer.BufferInput input) throws IOException {
        List listMembers;
        super.read(input);
        this.setOriginatingMemberId(input.readInt());
        int cMembers = input.readShort();
        if (cMembers == -1) {
            listMembers = null;
        } else if (cMembers == 0) {
            listMembers = Collections.emptyList();
        } else {
            ServiceMemberSet setMembers = this.getService().getServiceMemberSet();
            listMembers = new ArrayList(cMembers);
            for (int i = 0; i < cMembers; ++i) {
                int nMember = input.readInt();
                Member member = ((MemberSet)setMembers).getMember(nMember);
                if (member == null) continue;
                listMembers.add(member);
            }
        }
        this.setMemberList(listMembers);
    }

    protected void setIncomingRequest(ChainedRequest msg) {
        this.__m_IncomingRequest = msg;
    }

    public void setMemberList(List listMember) {
        this.__m_MemberList = listMember;
    }

    public void setOriginatingMemberId(int nId) {
        this.__m_OriginatingMemberId = nId;
    }

    @Override
    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        output.writeInt(this.getOriginatingMemberId());
        List listMembers = this.getMemberList();
        int cMembers = listMembers == null ? -1 : listMembers.size();
        output.writeShort(cMembers);
        if (cMembers > 0) {
            for (int i = 0; i < cMembers; ++i) {
                Member member = (Member)listMembers.get(i);
                output.writeInt(member.getId());
            }
        }
    }

    static {
        ChainedRequest.__initStatic();
    }

    public static class Poll
    extends com.tangosol.coherence.component.net.Poll {
        private transient Message __m_Response;

        public Poll() {
            this(null, null, true);
        }

        public Poll(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        @Override
        public boolean isPreprocessable() {
            return true;
        }

        public static Component get_Instance() {
            return new Poll();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/message/requestMessage/ChainedRequest$Poll".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        protected Message getResponse() {
            return this.__m_Response;
        }

        @Override
        protected void onCompletion() {
            ChainedRequest msgRequest = (ChainedRequest)this.get_Module();
            ChainedRequest msgIn = msgRequest.getIncomingRequest();
            Message msgResponse = (Message)this.getResult();
            if (msgResponse == null) {
                if (this.getService().getServiceState() != 4) {
                    msgRequest.forwardOrReply(msgIn);
                }
            } else if (msgIn == null) {
                msgRequest.onRequestCompleted();
            } else {
                msgRequest.onRequestDelivered();
                msgResponse = msgResponse.cloneMessage();
                msgResponse.respondTo(msgIn);
                this.getService().post(msgResponse);
            }
        }

        @Override
        public void onResponse(Message msg) {
            this.setResult(msg);
            super.onResponse(msg);
        }

        protected void setResponse(Message msgResponse) {
            this.__m_Response = msgResponse;
        }
    }
}

