/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.RequestContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.util.Base;
import java.io.IOException;
import java.util.Map;

public class RequestMessage
extends Message {
    private long __m_FromPollId;
    private RequestContext __m_RequestContext;
    private Poll __m_RequestPoll;
    private transient long __m_RequestTimeout;

    public RequestMessage() {
        this(null, null, true);
    }

    public RequestMessage(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public boolean isSuspendable() {
        return false;
    }

    public static Component get_Instance() {
        return new RequestMessage();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/message/RequestMessage".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    public void _addChild(Component child, String name) {
        super._addChild(child, name);
        if (child instanceof Poll && this.getRequestPoll() == null) {
            this.setRequestPoll((Poll)child);
        }
    }

    public long checkTimeoutRemaining() {
        long ldtTimeout = this.getRequestTimeout();
        if (ldtTimeout == Long.MAX_VALUE) {
            return 0L;
        }
        long cMillis = ldtTimeout - Base.getSafeTimeMillis();
        if (cMillis > 0L) {
            return cMillis;
        }
        throw new RequestTimeoutException();
    }

    @Override
    public Message cloneMessage() {
        RequestMessage msg = (RequestMessage)super.cloneMessage();
        msg.setRequestContext(this.getRequestContext());
        msg.setRequestTimeout(this.getRequestTimeout());
        return msg;
    }

    public Poll ensureRequestPoll() {
        Poll poll = this.getRequestPoll();
        if (poll == null) {
            poll = this.instantiatePoll();
            this.setRequestPoll(poll);
        }
        if (this.getFromPollId() == 0L) {
            this.setFromPollId(this.getService().getPollArray().add(poll));
        }
        return poll;
    }

    @Override
    public int getEstimatedByteSize() {
        return super.getEstimatedByteSize() + 3 + 1;
    }

    public long getFromPollId() {
        return this.__m_FromPollId;
    }

    public RequestContext getRequestContext() {
        return this.__m_RequestContext;
    }

    public Poll getRequestPoll() {
        return this.__m_RequestPoll;
    }

    public long getRequestTimeout() {
        long ldtTimeout = this.__m_RequestTimeout;
        if (ldtTimeout == 0L) {
            Grid service = this.getService();
            long cMillis = service.calculateRequestTimeout(this);
            ldtTimeout = service.adjustWaitTime(cMillis - 1L, -2L);
            this.setRequestTimeout(ldtTimeout);
        }
        return ldtTimeout;
    }

    protected Poll instantiatePoll() {
        Map map = this.get_ChildClasses();
        if (map != null) {
            Class clz = (Class)map.get("Poll");
            if (clz == null) {
                Class clzPoll = Poll.get_CLASS();
                for (Class clzChild : map.values()) {
                    if (!clzPoll.isAssignableFrom(clzChild)) continue;
                    clz = clzChild;
                    break;
                }
            }
            if (clz != null) {
                try {
                    return (Poll)clz.newInstance();
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e);
                }
            }
        }
        return new Poll();
    }

    protected RequestContext instantiateRequestContext() {
        RequestContext ctx = this.getService().instantiateRequestContext();
        if (ctx == null) {
            throw new IllegalStateException("Failed to instantiate RequestContext for " + this.get_Name());
        }
        return ctx;
    }

    @Override
    public void onDelivery() {
        this.ensureRequestPoll().onDelivery(this);
    }

    @Override
    public void post() {
        try {
            this.ensureRequestPoll().prepareDispatch(this);
            super.post();
        }
        catch (Throwable e) {
            RequestMessage._trace("Failure (" + e.getMessage() + ") while sending " + String.valueOf(this), 2);
            this.getService().doPollClose(this.ensureRequestPoll(), e);
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        if (input.readBoolean()) {
            RequestContext ctx = this.instantiateRequestContext();
            ctx.readExternal(input);
            this.setRequestContext(ctx);
        }
    }

    @Override
    public void readInternal(ReadBuffer.BufferInput input) throws IOException {
        super.readInternal(input);
        int nPollId = Packet.readUnsignedTrint(input);
        this.setFromPollId(0x1000000 | nPollId);
    }

    public void setFromPollId(long pFromPollId) {
        this.__m_FromPollId = pFromPollId;
    }

    public void setRequestContext(RequestContext ctx) {
        this.__m_RequestContext = ctx;
    }

    protected void setRequestPoll(Poll poll) {
        this.__m_RequestPoll = poll;
    }

    protected void setRequestTimeout(long ldtTimeout) {
        this.__m_RequestTimeout = ldtTimeout;
    }

    @Override
    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        RequestContext ctx = this.getRequestContext();
        if (ctx == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            ctx.writeExternal(output);
        }
    }

    @Override
    public void writeInternal(WriteBuffer.BufferOutput output) throws IOException {
        super.writeInternal(output);
        long lPollId = this.getFromPollId();
        RequestMessage._assert(lPollId != 0L);
        Packet.writeTrint(output, lPollId);
    }
}

