/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.io.DeltaCompressor;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapEvent;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MapEventMessage
extends Message {
    private long __m_CacheId;
    public static final int ENTRY_DELETED = 3;
    public static final int ENTRY_INSERTED = 1;
    public static final int ENTRY_UPDATED = 2;
    private long __m_EventSUID;
    private int __m_EventType;
    public static final int EVT_DELTA_COMPRESSED = 16;
    public static final int EVT_EXPIRED = 128;
    public static final int EVT_OPT_NEW_SKIP = 256;
    public static final int EVT_OPT_NEW_SWAP = 512;
    public static final int EVT_OPT_OLD_SKIP = 1024;
    public static final int EVT_OPT_OLD_SWAP = 2048;
    public static final int EVT_PRIMING = 64;
    public static final int EVT_SYNTHETIC = 8;
    public static final int EVT_TRANSFORMED = 32;
    public static final int EVT_TYPE_MASK = 7;
    private long[] __m_FilterId;
    private Binary __m_Key;
    private Binary __m_NewValue;
    private long __m_OldestPendingEventSUID;
    private Binary __m_OldValue;
    private int __m_Partition;
    private long __m_Version;

    public MapEventMessage() {
        this(null, null, true);
    }

    public MapEventMessage(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setNotifyDelivery(true);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new MapEventMessage();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/message/MapEventMessage".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public static Object compressEventHolder(Object oEvent, Binary binValueOld, Binary binValueNew) {
        if (oEvent instanceof MapEventMessage) {
            MapEventMessage msgEvent = (MapEventMessage)oEvent;
            int nType = msgEvent.getEventType();
            if (binValueOld != null) {
                if (binValueOld.equals(msgEvent.getOldValue())) {
                    nType |= 0x400;
                } else if (binValueOld.equals(msgEvent.getNewValue())) {
                    nType |= 0x200;
                }
            }
            if (binValueNew != null) {
                if (binValueNew.equals(msgEvent.getNewValue())) {
                    nType |= 0x100;
                } else if (binValueNew.equals(msgEvent.getOldValue())) {
                    nType |= 0x800;
                }
            }
            msgEvent.setEventType(nType);
        } else if (oEvent != null) {
            Iterator iter = ((List)oEvent).iterator();
            while (iter.hasNext()) {
                MapEventMessage.compressEventHolder(iter.next(), binValueOld, binValueNew);
            }
        }
        return oEvent;
    }

    public static Object decompressEventHolder(Object oEvent, long lCacheId, Binary binKey, Binary binValueOld, Binary binValueNew) {
        if (oEvent instanceof MapEventMessage) {
            MapEventMessage msgEvent = (MapEventMessage)oEvent;
            msgEvent.setCacheId(lCacheId);
            msgEvent.setKey(binKey);
            int nType = msgEvent.getEventType();
            switch (nType & 0xC00) {
                case 1024: {
                    msgEvent.setOldValue(binValueOld);
                    nType &= 0xFFFFFBFF;
                    break;
                }
                case 2048: {
                    msgEvent.setOldValue(binValueNew);
                    nType &= 0xFFFFF7FF;
                }
            }
            switch (nType & 0x300) {
                case 256: {
                    msgEvent.setNewValue(binValueNew);
                    nType &= 0xFFFFFEFF;
                    break;
                }
                case 512: {
                    msgEvent.setNewValue(binValueOld);
                    nType &= 0xFFFFFDFF;
                }
            }
            msgEvent.setEventType(nType);
        } else if (oEvent != null) {
            Iterator iter = ((List)oEvent).iterator();
            while (iter.hasNext()) {
                MapEventMessage.decompressEventHolder(iter.next(), lCacheId, binKey, binValueOld, binValueNew);
            }
        }
        return oEvent;
    }

    public long getCacheId() {
        return this.__m_CacheId;
    }

    public String getCacheName() {
        return "[" + String.valueOf(this.getCacheId()) + "]";
    }

    public DeltaCompressor getDeltaCompressor() {
        return NullImplementation.getDeltaCompressor();
    }

    @Override
    public String getDescription() {
        return "CacheName=" + this.getCacheName() + ", EventType=" + MapEvent.getDescription(this.getEventType() & 7) + ", Key=" + String.valueOf(this.getKey()) + ", OldValue=" + String.valueOf(this.getOldValue()) + ", NewValue=" + String.valueOf(this.getNewValue());
    }

    public long getEventSUID() {
        return this.__m_EventSUID;
    }

    public int getEventType() {
        return this.__m_EventType;
    }

    public long[] getFilterId() {
        return this.__m_FilterId;
    }

    public Binary getKey() {
        return this.__m_Key;
    }

    public Binary getNewValue() {
        return this.__m_NewValue;
    }

    public long getOldestPendingEventSUID() {
        return this.__m_OldestPendingEventSUID;
    }

    public Binary getOldValue() {
        return this.__m_OldValue;
    }

    public int getPartition() {
        return this.__m_Partition;
    }

    public long getVersion() {
        return this.__m_Version;
    }

    public static boolean isCompressedNewValue(Object oEventHolder) {
        if (oEventHolder == null) {
            return false;
        }
        if (oEventHolder instanceof MapEventMessage) {
            MapEventMessage msgEvent = (MapEventMessage)oEventHolder;
            int nType = msgEvent.getEventType();
            return (nType & 0x300) != 0;
        }
        Iterator iter = ((List)oEventHolder).iterator();
        while (iter.hasNext()) {
            if (!MapEventMessage.isCompressedNewValue(iter.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompressedOldValue(Object oEventHolder) {
        if (oEventHolder == null) {
            return false;
        }
        if (oEventHolder instanceof MapEventMessage) {
            MapEventMessage msgEvent = (MapEventMessage)oEventHolder;
            int nType = msgEvent.getEventType();
            return (nType & 0xC00) != 0;
        }
        Iterator iter = ((List)oEventHolder).iterator();
        while (iter.hasNext()) {
            if (!MapEventMessage.isCompressedOldValue(iter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isExpired() {
        return (this.getEventType() & 0x80) != 0;
    }

    public boolean isPriming() {
        return (this.getEventType() & 0x40) != 0;
    }

    public boolean isSynthetic() {
        return (this.getEventType() & 8) != 0;
    }

    public boolean isTransformed() {
        return (this.getEventType() & 0x20) != 0;
    }

    @Override
    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        this.readImpl(input, false);
    }

    protected void readImpl(ReadBuffer.BufferInput stream, boolean fSupplemental) throws IOException {
        this.setEventSUID(ExternalizableHelper.readLong(stream));
        this.setOldestPendingEventSUID(ExternalizableHelper.readLong(stream));
        int nType = ExternalizableHelper.readInt(stream);
        if (fSupplemental) {
            this.ensureToMemberSet().readExternal(stream);
            int nEvent = nType & 7;
            if (nEvent != 1 && (nType & 0xC00) == 0) {
                this.setOldValue((Binary)ExternalizableHelper.readObject(stream, null));
            }
            if (nEvent != 3 && (nType & 0x300) == 0) {
                this.setNewValue((Binary)ExternalizableHelper.readObject(stream, null));
            }
        } else {
            this.setCacheId(ExternalizableHelper.readLong(stream));
            this.setKey((Binary)ExternalizableHelper.readObject(stream, null));
            Binary binValueOld = (Binary)ExternalizableHelper.readObject(stream, null);
            Binary binValueNew = (Binary)ExternalizableHelper.readObject(stream, null);
            if ((nType & 0x10) != 0) {
                binValueNew = this.getDeltaCompressor().applyDelta(binValueOld, binValueNew).toBinary();
                nType &= 0xFFFFFFEF;
            }
            this.setOldValue(binValueOld);
            this.setNewValue(binValueNew);
        }
        this.setEventType(nType);
        int cFilters = stream.readUnsignedShort();
        if (cFilters > 0) {
            long[] alFilterId = new long[cFilters];
            for (int i = 0; i < cFilters; ++i) {
                alFilterId[i] = ExternalizableHelper.readLong(stream);
            }
            this.setFilterId(alFilterId);
        }
        if (stream.available() > 0) {
            this.setVersion(ExternalizableHelper.readLong(stream));
        }
        if (stream.available() > 0) {
            this.setPartition(ExternalizableHelper.readInt(stream));
        }
    }

    public static Object readSupplemental(ReadBuffer.BufferInput stream, Grid service) throws IOException {
        int cEvents = ExternalizableHelper.readInt(stream);
        switch (cEvents) {
            case 0: {
                return null;
            }
            case 1: {
                int nMsgType = ExternalizableHelper.readInt(stream);
                MapEventMessage event = (MapEventMessage)service.instantiateMessage(nMsgType);
                event.readImpl(stream, true);
                return event;
            }
        }
        LinkedList<MapEventMessage> listEvents = new LinkedList<MapEventMessage>();
        for (int i = 0; i < cEvents; ++i) {
            int nMsgType = ExternalizableHelper.readInt(stream);
            MapEventMessage event = (MapEventMessage)service.instantiateMessage(nMsgType);
            event.readImpl(stream, true);
            listEvents.add(event);
        }
        return listEvents;
    }

    public void setCacheId(long lId) {
        this.__m_CacheId = lId;
    }

    public void setEventSUID(long lSUID) {
        this.__m_EventSUID = lSUID;
    }

    public void setEventType(int nType) {
        this.__m_EventType = nType;
    }

    public void setFilterId(long[] alFilterId) {
        this.__m_FilterId = alFilterId;
    }

    public void setKey(Binary binKey) {
        this.__m_Key = binKey;
    }

    public void setNewValue(Binary binValue) {
        this.__m_NewValue = binValue;
    }

    public void setOldestPendingEventSUID(long lSUID) {
        this.__m_OldestPendingEventSUID = lSUID;
    }

    public void setOldValue(Binary binValue) {
        this.__m_OldValue = binValue;
    }

    public void setPartition(int nPartition) {
        this.__m_Partition = nPartition;
    }

    public void setVersion(long nPartition) {
        this.__m_Version = nPartition;
    }

    @Override
    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        this.writeImpl(output, false);
    }

    protected void writeImpl(WriteBuffer.BufferOutput stream, boolean fSupplemental) throws IOException {
        int nType = this.getEventType();
        ExternalizableHelper.writeLong(stream, this.getEventSUID());
        ExternalizableHelper.writeLong(stream, this.getOldestPendingEventSUID());
        if (fSupplemental) {
            ExternalizableHelper.writeInt(stream, nType);
            this.ensureToMemberSet().writeExternal(stream);
            int nEvent = nType & 7;
            if (nEvent != 1 && (nType & 0xC00) == 0) {
                ExternalizableHelper.writeObject(stream, this.getOldValue());
            }
            if (nEvent != 3 && (nType & 0x300) == 0) {
                ExternalizableHelper.writeObject(stream, this.getNewValue());
            }
        } else {
            Binary binValueOld = this.getOldValue();
            Binary binValueNew = this.getNewValue();
            if (binValueOld != null && binValueNew != null) {
                ReadBuffer bufDelta = this.getDeltaCompressor().extractDelta(binValueOld, binValueNew);
                binValueNew = bufDelta == null ? null : bufDelta.toBinary();
                nType |= 0x10;
            }
            ExternalizableHelper.writeInt(stream, nType);
            ExternalizableHelper.writeLong(stream, this.getCacheId());
            ExternalizableHelper.writeObject(stream, this.getKey());
            ExternalizableHelper.writeObject(stream, binValueOld);
            ExternalizableHelper.writeObject(stream, binValueNew);
        }
        long[] alFilterId = this.getFilterId();
        int cFilters = alFilterId == null ? 0 : alFilterId.length;
        stream.writeShort(cFilters);
        for (int i = 0; i < cFilters; ++i) {
            ExternalizableHelper.writeLong(stream, alFilterId[i]);
        }
        ExternalizableHelper.writeLong(stream, this.getVersion());
        ExternalizableHelper.writeInt(stream, this.getPartition());
    }

    public static void writeSupplemental(WriteBuffer.BufferOutput stream, Object oEventHolder) throws IOException {
        if (oEventHolder == null) {
            ExternalizableHelper.writeInt(stream, 0);
        } else if (oEventHolder instanceof MapEventMessage) {
            MapEventMessage msgEvent = (MapEventMessage)oEventHolder;
            ExternalizableHelper.writeInt(stream, 1);
            ExternalizableHelper.writeInt(stream, msgEvent.getMessageType());
            msgEvent.writeImpl(stream, true);
        } else {
            List listEvents = (List)oEventHolder;
            ExternalizableHelper.writeInt(stream, listEvents.size());
            for (MapEventMessage msgEvent : listEvents) {
                ExternalizableHelper.writeInt(stream, msgEvent.getMessageType());
                msgEvent.writeImpl(stream, true);
            }
        }
    }
}

