/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.message;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import java.io.DataInput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class DiscoveryMessage
extends Message {
    private InetSocketAddress __m_ExternalAddress;
    private transient boolean __m_ReadError;
    private SocketAddress __m_SourceAddress;
    private Member __m_ToMember;

    public DiscoveryMessage() {
        this(null, null, true);
    }

    public DiscoveryMessage(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new DiscoveryMessage();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/message/DiscoveryMessage".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public void ensureEOS(DataInput stream) throws IOException {
        if (stream.skipBytes(1) == 0) {
            return;
        }
        throw new IOException("message contains more data then expected");
    }

    public String getClusterName() {
        return this.getFromMember().getClusterName();
    }

    public InetSocketAddress getExternalAddress() {
        return this.__m_ExternalAddress;
    }

    public SocketAddress getSourceAddress() {
        return this.__m_SourceAddress;
    }

    public Member getToMember() {
        return this.__m_ToMember;
    }

    public boolean isReadError() {
        return this.__m_ReadError;
    }

    @Override
    public boolean packetize(PacketPublisher publisher, ServiceMemberSet setMembersBase, ReadBuffer buffer, int cbPreferred, int cbMax) {
        if (this.getToMemberSet() == null) {
            Broadcast packet = new Broadcast();
            packet.setClusterNameBuffer(publisher.getClusterNameBuffer());
            int cbMsg = buffer.length();
            int cbBody = Broadcast.calcBodyLength(packet.calcHeaderLength(), cbPreferred, cbMax);
            if (cbMsg > cbBody) {
                throw new IllegalStateException("Broadcast Message is too large (max=" + cbBody + ", actual=" + buffer.length() + ", " + String.valueOf(this));
            }
            packet.setFromId(this.getFromMember().getId());
            packet.setMessageType(this.getMessageType());
            packet.defineBufferView((ReadBuffer)buffer.clone(), 0, cbMsg);
            this.getBufferController().dispose();
            this.setBufferController(null);
            Member memberTo = this.getToMember();
            InetSocketAddress addrExt = this.getExternalAddress();
            int cAddr = (memberTo == null ? 0 : 1) + (addrExt == null ? 0 : 1);
            if (cAddr > 0) {
                InetSocketAddress[] aAddr = new InetSocketAddress[cAddr];
                if (memberTo != null) {
                    aAddr[0] = memberTo.getSocketAddress();
                }
                if (addrExt != null) {
                    aAddr[aAddr.length - 1] = addrExt;
                }
                packet.setToAddress(aAddr);
            }
            this.setMessagePartCount(1);
            this.setPacket(0, packet);
            return true;
        }
        return super.packetize(publisher, setMembersBase, buffer, cbPreferred, cbMax);
    }

    @Override
    public void read(ReadBuffer.BufferInput input) throws IOException {
        Member memberFrom = new Member();
        memberFrom.readExternal(input);
        this.setFromMember(memberFrom);
        if (this.getSourceAddress() == null) {
            this.setSourceAddress(memberFrom.getSocketAddress());
        }
        if (input.readBoolean()) {
            Member memberTo = new Member();
            memberTo.readExternal(input);
            this.setToMember(memberTo);
        }
    }

    public void setExternalAddress(InetSocketAddress addressExternal) {
        this.__m_ExternalAddress = addressExternal;
    }

    @Override
    public void setPacket(int i, MessagePacket packet) {
        super.setPacket(i, packet);
        if (packet instanceof Broadcast) {
            this.setSourceAddress(((Broadcast)packet).getFromAddress());
        }
    }

    public void setReadError(boolean fReadError) {
        this.__m_ReadError = fReadError;
    }

    public void setSourceAddress(SocketAddress pSourceAddress) {
        this.__m_SourceAddress = pSourceAddress;
    }

    public void setToMember(Member member) {
        this.__m_ToMember = member;
    }

    @Override
    public void write(WriteBuffer.BufferOutput output) throws IOException {
        Member memberFrom = this.getFromMember();
        Member memberTo = this.getToMember();
        memberFrom.writeExternal(output);
        if (memberTo == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            memberTo.writeExternal(output);
        }
    }
}

