/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.license.LicensedObject;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.net.SocketAddress;
import java.util.Map;

public class MasterMemberSet
extends ServiceMemberSet {
    private Map __m_AddressMap;
    private long __m_AscensionTimestamp;
    public static final int MAX_MEMBERS = 8160;
    public static final String TRANSPORT_COMPATIBILITY = "Compat[";
    private transient int __m_MaximumPacketLength;
    private Map __m_MemberMap;
    private int __m_RecycleMillis;
    private ActualMemberSet __m_RecycleSet;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Iterator", MemberSet.Iterator.get_CLASS());
    }

    public MasterMemberSet() {
        this(null, null, true);
    }

    public MasterMemberSet(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setAddressMap(new SafeHashMap());
            this.setMemberMap(new SafeHashMap());
            this.setRecycleMillis(60000);
            this.setRecycleSet(new ActualMemberSet());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new MasterMemberSet();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/memberSet/actualMemberSet/serviceMemberSet/MasterMemberSet".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public synchronized boolean add(Object o) {
        if (super.add(o)) {
            Member memberNew = (Member)o;
            this.getMemberMap().put(memberNew.getUid32(), memberNew);
            this.getAddressMap().put(memberNew.getSocketAddress(), memberNew);
            this.getRecycleSet().remove(memberNew.getId());
            return true;
        }
        return false;
    }

    @Override
    protected void appendEdition(StringBuilder sb, int nMember) {
        Member member = this.getMember(nMember);
        String sEdition = member == null ? "UNKNOWN" : Coherence.EDITION_NAMES[member.getEdition()];
        sb.append('|').append(sEdition);
    }

    @Override
    protected void appendEditionHeader(StringBuilder sb) {
        sb.append("|Edition");
    }

    @Override
    protected void appendTransport(StringBuilder sb, int nMember) {
    }

    @Override
    protected void appendTransportHeader(StringBuilder sb) {
    }

    @Override
    protected void appendVersion(StringBuilder sb, int nMember) {
        int nState = this.getState(nMember);
        sb.append('|');
        if (nState <= 1) {
            sb.append(TRANSPORT_COMPATIBILITY);
        }
        sb.append(this.getServiceVersionExternal(nMember));
        if (nState <= 1) {
            sb.append("]");
        }
    }

    @Override
    protected void appendVersionHeader(StringBuilder sb) {
        sb.append("|Version");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long compareSeniority(Member memberA, Member memberB) {
        return memberA.getUid32().compareTo(memberB.getUid32());
    }

    @Override
    public synchronized ObservableMap ensureMemberConfigMap(int i) {
        return null;
    }

    public Member findDeadMember(Member member) {
        Member memberDead = this.getRecycleSet().getMember(member.getId());
        return memberDead != null && memberDead.getUid32().equals(member.getUid32()) ? memberDead : null;
    }

    public Map getAddressMap() {
        return this.__m_AddressMap;
    }

    public long getAscensionTimestamp() {
        return this.__m_AscensionTimestamp;
    }

    @Override
    public String getDescription() {
        return "\n  ThisMember=" + String.valueOf(this.getThisMember()) + super.getDescription() + "\n  RecycleMillis=" + this.getRecycleMillis() + "\n  RecycleSet=" + Base.indentString(this.getRecycleSet().toString(), "  ", false);
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public Member getMember(UUID uid) {
        return (Member)this.getMemberMap().get(uid);
    }

    public Member getMember(SocketAddress addr) {
        return (Member)this.getAddressMap().get(addr);
    }

    protected Map getMemberMap() {
        return this.__m_MemberMap;
    }

    public int getRecycleMillis() {
        return this.__m_RecycleMillis;
    }

    public ActualMemberSet getRecycleSet() {
        return this.__m_RecycleSet;
    }

    public final synchronized int induct(Member memberNew, ClusterService service) {
        MasterMemberSet._assert(memberNew != null && memberNew.getId() <= 1);
        MasterMemberSet._assert(this.getThisMember() == this.getOldestMember());
        if (!((Cluster)service.getCluster()).isAuthorizedHost(memberNew.getAddress())) {
            return 8161;
        }
        if (LicensedObject.isExpired()) {
            return 8164;
        }
        if (memberNew.getTimestamp() <= this.getLastJoinTime()) {
            return 8170;
        }
        long lCutoffMillis = Base.getSafeTimeMillis() - (long)this.getRecycleMillis();
        ActualMemberSet setRecycle = this.getRecycleSet();
        for (int i = 1; i <= 8160; ++i) {
            Member memberDead;
            if (this.contains(i) || (memberDead = ((MemberSet)setRecycle).getMember(i)) != null && memberDead.getTimestamp() >= lCutoffMillis) continue;
            memberNew.setId(i);
            this.add(memberNew);
            if (Directed.calcHeaderLength(this) <= this.getMaximumPacketLength()) {
                return 8171;
            }
            this.remove(memberNew);
            this.getRecycleSet().remove(memberNew);
            break;
        }
        return 8160;
    }

    @Override
    public synchronized boolean remove(Object o) {
        MasterMemberSet._assert(o != this.getThisMember());
        if (super.remove(o)) {
            Member member = (Member)o;
            this.getMemberMap().remove(member.getUid32());
            this.getAddressMap().remove(member.getSocketAddress());
            member.setDead(true);
            this.getRecycleSet().add(member);
            return true;
        }
        return false;
    }

    public void setAddressMap(Map mapAddress) {
        this.__m_AddressMap = mapAddress;
    }

    public void setAscensionTimestamp(long lTimestamp) {
        this.__m_AscensionTimestamp = lTimestamp;
    }

    public void setMaximumPacketLength(int cb) {
        this.__m_MaximumPacketLength = cb;
    }

    protected void setMemberMap(Map map) {
        this.__m_MemberMap = map;
    }

    @Override
    protected synchronized void setOldestMember(Member member) {
        super.setOldestMember(member);
        this.setAscensionTimestamp(Base.getSafeTimeMillis());
    }

    public void setRecycleMillis(int cMillis) {
        this.__m_RecycleMillis = cMillis;
    }

    protected void setRecycleSet(ActualMemberSet set) {
        this.__m_RecycleSet = set;
    }

    static {
        MasterMemberSet.__initStatic();
    }
}

