/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.memberSet.actualMemberSet;

import com.oracle.coherence.common.net.exabus.EndPoint;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.ActualMemberSet;
import com.tangosol.internal.util.VersionHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableHashMap;
import com.tangosol.util.ObservableMap;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntPredicate;

public class ServiceMemberSet
extends ActualMemberSet {
    private transient AtomicLong[] __m_BackloggedAtomic;
    private long __m_LastJoinTime;
    public static final int MEMBER_JOINED = 2;
    public static final int MEMBER_JOINING = 1;
    public static final int MEMBER_LEAVING = 3;
    public static final int MEMBER_NEW = 0;
    private ObservableMap[] __m_MemberConfigMap;
    private Member __m_OldestLocalMember;
    private Member __m_OldestMember;
    private transient boolean[] __m_ServiceBacklogged;
    private transient EndPoint[] __m_ServiceEndPoint;
    private transient String[] __m_ServiceEndPointName;
    private transient int __m_ServiceId;
    private long[] __m_ServiceJoinTime;
    private transient String __m_ServiceName;
    private int[] __m_ServiceVersionInt;
    private int m_nVersionMin;
    private int m_nVersionMax;
    private int[] __m_State;
    private Member __m_SuccessorMember;
    private Member __m_ThisMember;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Iterator", MemberSet.Iterator.get_CLASS());
    }

    public ServiceMemberSet() {
        this(null, null, true);
    }

    public ServiceMemberSet(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new ServiceMemberSet();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/memberSet/actualMemberSet/ServiceMemberSet".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    protected void appendEdition(StringBuilder sb, int nMember) {
    }

    protected void appendEditionHeader(StringBuilder sb) {
    }

    protected void appendTransport(StringBuilder sb, int nMember) {
        sb.append('|').append(ServiceMemberSet.formatEndPoint(this.getServiceEndPointName(nMember)));
    }

    protected void appendTransportHeader(StringBuilder sb) {
        sb.append("|EndPoint");
    }

    protected void appendVersion(StringBuilder sb, int nMember) {
    }

    protected void appendVersionHeader(StringBuilder sb) {
    }

    @Override
    public synchronized void clear() {
        throw new UnsupportedOperationException();
    }

    public long compareSeniority(Member memberA, Member memberB) {
        return this.getServiceJoinTime(memberA.getId()) - this.getServiceJoinTime(memberB.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(ServiceMemberSet setMember) {
        ServiceMemberSet._assert(this.isEmpty());
        this.setServiceId(setMember.getServiceId());
        this.setServiceName(setMember.getServiceName());
        ServiceMemberSet serviceMemberSet = setMember;
        synchronized (serviceMemberSet) {
            for (Member member : setMember) {
                int nMember = member.getId();
                this.add(member);
                this.setServiceVersion(nMember, setMember.getServiceVersion(nMember));
                this.setServiceJoinTime(nMember, setMember.getServiceJoinTime(nMember));
                this.setServiceEndPointName(nMember, setMember.getServiceEndPointName(nMember));
                this.setState(nMember, setMember.getState(nMember));
                ObservableMap mapConfig = this.ensureMemberConfigMap(nMember);
                if (mapConfig == null) continue;
                mapConfig.putAll(setMember.getMemberConfigMap(nMember));
            }
            ServiceMemberSet._assert(this.equals(setMember) && this.getOldestMember() == setMember.getOldestMember());
        }
    }

    public static int encodeVersion(int nYear, int nMonth, int nPatch) {
        return VersionHelper.encodeVersion(nYear, nMonth, nPatch);
    }

    public static int encodeVersion(int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        return VersionHelper.encodeVersion(nMajor, nMinor, nMicro, nPatchSet, nPatch);
    }

    public synchronized ObservableMap ensureMemberConfigMap(int i) {
        ObservableHashMap map;
        ObservableMap[] amap = this.getMemberConfigMap();
        ObservableHashMap observableHashMap = map = amap == null || i >= amap.length ? null : amap[i];
        if (map == null) {
            map = new ObservableHashMap();
            this.setMemberConfigMap(i, map);
        }
        return map;
    }

    public static String formatEndPoint(String sName) {
        return sName == null || sName.length() == 0 ? "shared" : sName;
    }

    public static String formatJoinTime(long ldt) {
        return new Timestamp(ldt).toString();
    }

    public static String formatStateName(int nState) {
        switch (nState) {
            case 0: {
                return "NEW";
            }
            case 1: {
                return "JOINING";
            }
            case 2: {
                return "JOINED";
            }
            case 3: {
                return "LEAVING";
            }
        }
        return "<unknown>";
    }

    protected AtomicLong[] getBackloggedAtomic() {
        return this.__m_BackloggedAtomic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AtomicLong getBackloggedAtomic(int i) {
        AtomicLong[] aBits = this.getBackloggedAtomic();
        if (aBits == null || i >= aBits.length) {
            ServiceMemberSet serviceMemberSet = this;
            synchronized (serviceMemberSet) {
                aBits = this.getBackloggedAtomic();
                if (aBits == null || i >= aBits.length) {
                    int j;
                    AtomicLong[] aBitsNew = new AtomicLong[i + 8];
                    if (aBits != null) {
                        System.arraycopy(aBits, 0, aBitsNew, 0, aBits.length);
                    }
                    int n = j = aBits == null ? 0 : aBits.length;
                    while (j < aBitsNew.length) {
                        aBitsNew[j] = new AtomicLong();
                        ++j;
                    }
                    aBits = aBitsNew;
                    this.setBackloggedAtomic(aBits);
                }
            }
        }
        return aBits[i];
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n  OldestMember=" + String.valueOf(this.getOldestMember())).append("\n  ActualMemberSet=" + Base.indentString(this.toString(0), "  ", false)).append("\n  MemberId|ServiceJoined|MemberState");
        this.appendTransportHeader(sb);
        this.appendVersionHeader(sb);
        this.appendEditionHeader(sb);
        boolean fFirst = true;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append(',');
            }
            int nMember = ((Member)iter.next()).getId();
            sb.append("\n    ").append(nMember).append('|').append(ServiceMemberSet.formatJoinTime(this.getServiceJoinTime(nMember))).append('|').append(ServiceMemberSet.formatStateName(this.getState(nMember)));
            this.appendTransport(sb, nMember);
            this.appendVersion(sb, nMember);
            this.appendEdition(sb, nMember);
        }
        return sb.toString();
    }

    public Member getJoinedMember(long ldtJoined) {
        long[] aldtJoined = this.getServiceJoinTime();
        int c = aldtJoined.length;
        for (int i = 0; i < c; ++i) {
            if (aldtJoined[i] != ldtJoined) continue;
            return this.getMember(i);
        }
        return null;
    }

    public long getLastJoinTime() {
        return this.__m_LastJoinTime;
    }

    protected ObservableMap[] getMemberConfigMap() {
        return this.__m_MemberConfigMap;
    }

    public ObservableMap getMemberConfigMap(int i) {
        ObservableMap map;
        ObservableMap[] amap = this.getMemberConfigMap();
        ObservableMap observableMap = map = amap == null || i >= amap.length ? null : amap[i];
        if (map == null) {
            map = NullImplementation.getObservableMap();
        }
        return map;
    }

    public Member getOldestLocalMember() {
        return this.__m_OldestLocalMember;
    }

    public Member getOldestMember() {
        return this.__m_OldestMember;
    }

    protected EndPoint[] getServiceEndPoint() {
        return this.__m_ServiceEndPoint;
    }

    public EndPoint getServiceEndPoint(int i) {
        EndPoint[] aPoint = this.getServiceEndPoint();
        return aPoint == null || i >= aPoint.length ? null : aPoint[i];
    }

    protected String[] getServiceEndPointName() {
        return this.__m_ServiceEndPointName;
    }

    public String getServiceEndPointName(int i) {
        String[] asEndPoint = this.getServiceEndPointName();
        return asEndPoint == null || i >= asEndPoint.length ? null : asEndPoint[i];
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    protected long[] getServiceJoinTime() {
        return this.__m_ServiceJoinTime;
    }

    public long getServiceJoinTime(int i) {
        long[] alMillis = this.getServiceJoinTime();
        return alMillis == null || i >= alMillis.length ? 0L : alMillis[i];
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public boolean isVersionConsistent() {
        return this.m_nVersionMax == this.m_nVersionMin;
    }

    public int getMinimumVersion() {
        return this.m_nVersionMin;
    }

    public boolean isVersionCompatible(int nVersion) {
        return this.m_nVersionMin >= nVersion;
    }

    public boolean isVersionCompatible(IntPredicate predicate) {
        return predicate.test(this.m_nVersionMin);
    }

    public boolean isPatchCompatible(int nMember, int nEncodedVersion) {
        int nVersion = this.getServiceVersionInt(nMember);
        return VersionHelper.isPatchCompatible(nEncodedVersion, nVersion);
    }

    public boolean isPatchCompatible(int nEncodedVersion) {
        return VersionHelper.isPatchCompatible(nEncodedVersion, this.m_nVersionMin);
    }

    public String getServiceVersion(int i) {
        return ServiceMemberSet.toVersionString(this.getServiceVersionInt(i), true);
    }

    public String getServiceVersionExternal(int nMember) {
        Member member = this.getMember(nMember);
        int nVersion = this.getServiceVersionInt(nMember);
        int nYear = (nVersion & 0xFC0) >> 6;
        int nPatch = nVersion & 0x3F;
        if (nYear >= 20 && member.getEdition() == 3) {
            int nPatchActual = nPatch & 0xFFFFFFDF;
            String sVersion = nYear + ".";
            sVersion = (nPatch & 0x20) == 0 ? sVersion + (nYear <= 22 ? "06" : "03") : sVersion + (nYear <= 21 ? "12" : "09");
            return sVersion + "." + nPatchActual;
        }
        return this.getServiceVersion(nMember);
    }

    public int getServiceVersionInt(int i) {
        int[] anVersion = this.__m_ServiceVersionInt;
        return anVersion == null || i >= anVersion.length ? 0 : anVersion[i];
    }

    protected int[] getState() {
        return this.__m_State;
    }

    public int getState(int i) {
        int[] anState = this.getState();
        return anState == null || i >= anState.length ? 0 : anState[i];
    }

    public Member getSuccessorMember() {
        return this.__m_SuccessorMember;
    }

    public Member getThisMember() {
        return this.__m_ThisMember;
    }

    public static int getVersionPrefix(int nYear, int nMonth) {
        return VersionHelper.getVersionPrefix(nYear, nMonth);
    }

    protected static boolean isCalendarVersion(int nVersion) {
        return VersionHelper.isCalendarVersion(nVersion);
    }

    public boolean isMemberConfigured(int nMember) {
        ObservableMap[] amap = this.getMemberConfigMap();
        ObservableMap map = amap == null || nMember >= amap.length ? null : amap[nMember];
        return map != null;
    }

    public boolean isServiceBacklogged(int i) {
        return (this.getBackloggedAtomic(i / 64).get() & 1L << i % 64) != 0L;
    }

    public boolean isServiceJoined(int nMember) {
        return this.getState(nMember) == 2;
    }

    public boolean isServiceJoining(int nMember) {
        return this.getState(nMember) == 1;
    }

    public boolean isServiceLeaving(int nMember) {
        return this.getState(nMember) == 3;
    }

    public static int parseVersion(String sVersion) {
        return VersionHelper.parseVersion(sVersion);
    }

    @Override
    public synchronized boolean remove(Object o) {
        if (super.remove(o)) {
            Member memberLeft = (Member)o;
            int nId = memberLeft.getId();
            this.setServiceVersion(nId, null);
            this.setServiceJoinTime(nId, 0L);
            this.setServiceEndPoint(nId, null);
            this.setServiceBacklogged(nId, false);
            this.setMemberConfigMap(nId, null);
            this.setState(nId, 0);
            if (memberLeft == this.getOldestMember() || memberLeft == this.getOldestLocalMember() || memberLeft == this.getSuccessorMember()) {
                Member memberThis = this.getThisMember();
                Member memberOldest = null;
                Member memberOldestLocal = memberThis;
                Member memberSuccessor = null;
                for (Member member : this) {
                    if (memberOldest == null || this.compareSeniority(member, memberOldest) < 0L) {
                        memberOldest = member;
                    }
                    if (memberOldestLocal != null && memberOldestLocal.isCollocated(member) && this.compareSeniority(member, memberOldestLocal) < 0L) {
                        memberOldestLocal = member;
                    }
                    if (memberThis == null || this.compareSeniority(memberThis, member) >= 0L || memberSuccessor != null && this.compareSeniority(member, memberSuccessor) >= 0L) continue;
                    memberSuccessor = member;
                }
                this.setOldestMember(memberOldest);
                this.setOldestLocalMember(memberOldestLocal);
                this.setSuccessorMember(memberSuccessor);
            }
            return true;
        }
        return false;
    }

    protected void setBackloggedAtomic(AtomicLong[] aPoint) {
        this.__m_BackloggedAtomic = aPoint;
    }

    protected void setBackloggedAtomic(int i, AtomicLong point) {
        this.getBackloggedAtomic()[i] = point;
    }

    protected void setLastJoinTime(long ldt) {
        this.__m_LastJoinTime = ldt;
    }

    protected void setMemberConfigMap(ObservableMap[] amap) {
        this.__m_MemberConfigMap = amap;
    }

    protected synchronized void setMemberConfigMap(int i, ObservableMap map) {
        boolean fBeyondBounds;
        ObservableMap[] amap = this.getMemberConfigMap();
        boolean bl = fBeyondBounds = amap == null || i >= amap.length;
        if (map != null && fBeyondBounds) {
            ObservableMap[] amapNew = new ObservableMap[i + 8];
            if (amap != null) {
                System.arraycopy(amap, 0, amapNew, 0, amap.length);
            }
            amap = amapNew;
            this.setMemberConfigMap(amap);
            fBeyondBounds = false;
        }
        if (!fBeyondBounds) {
            amap[i] = map;
        }
    }

    protected void setOldestLocalMember(Member member) {
        this.__m_OldestLocalMember = member;
    }

    protected void setOldestMember(Member member) {
        this.__m_OldestMember = member;
    }

    public void setServiceBacklogged(int i, boolean fBacklogged) {
        long lCur;
        AtomicLong atl = this.getBackloggedAtomic(i / 64);
        long iBit = 1L << i % 64;
        while (!atl.compareAndSet(lCur = atl.get(), fBacklogged ? lCur | iBit : lCur & (iBit ^ 0xFFFFFFFFFFFFFFFFL))) {
        }
    }

    protected void setServiceEndPoint(EndPoint[] aPoint) {
        this.__m_ServiceEndPoint = aPoint;
    }

    public void setServiceEndPoint(int i, EndPoint point) {
        boolean fBeyondBounds;
        EndPoint[] aPoint = this.getServiceEndPoint();
        boolean bl = fBeyondBounds = aPoint == null || i >= aPoint.length;
        if (point != null && fBeyondBounds) {
            EndPoint[] aPointNew = new EndPoint[i + 8];
            if (aPoint != null) {
                System.arraycopy(aPoint, 0, aPointNew, 0, aPoint.length);
            }
            aPoint = aPointNew;
            this.setServiceEndPoint(aPoint);
            fBeyondBounds = false;
        }
        if (!fBeyondBounds) {
            aPoint[i] = point;
            this.setServiceBacklogged(i, false);
        }
    }

    protected void setServiceEndPointName(String[] asName) {
        this.__m_ServiceEndPointName = asName;
    }

    public void setServiceEndPointName(int i, String sEndPoint) {
        boolean fBeyondBounds;
        String[] asEndPoint = this.getServiceEndPointName();
        boolean bl = fBeyondBounds = asEndPoint == null || i >= asEndPoint.length;
        if (sEndPoint != null && fBeyondBounds) {
            String[] asEndPointNew = new String[i + 8];
            if (asEndPoint != null) {
                System.arraycopy(asEndPoint, 0, asEndPointNew, 0, asEndPoint.length);
            }
            asEndPoint = asEndPointNew;
            this.setServiceEndPointName(asEndPoint);
            fBeyondBounds = false;
        }
        if (!fBeyondBounds) {
            asEndPoint[i] = sEndPoint;
        }
    }

    public void setServiceId(int nId) {
        this.__m_ServiceId = nId;
    }

    public void setServiceJoined(int nMember) {
        this.setState(nMember, 2);
    }

    public void setServiceJoining(int nMember) {
        this.setState(nMember, 1);
    }

    protected void setServiceJoinTime(long[] alMillis) {
        this.__m_ServiceJoinTime = alMillis;
    }

    public synchronized void setServiceJoinTime(int i, long lMillis) {
        long[] alMillis;
        boolean fBeyondBounds;
        if (lMillis > this.getLastJoinTime()) {
            this.setLastJoinTime(lMillis);
        }
        boolean bl = fBeyondBounds = (alMillis = this.getServiceJoinTime()) == null || i >= alMillis.length;
        if (lMillis != 0L && fBeyondBounds) {
            long[] alMillisNew = new long[i + 8];
            if (alMillis != null) {
                System.arraycopy(alMillis, 0, alMillisNew, 0, alMillis.length);
            }
            alMillis = alMillisNew;
            this.setServiceJoinTime(alMillis);
            fBeyondBounds = false;
        }
        if (!fBeyondBounds) {
            alMillis[i] = lMillis;
            Member member = this.getMember(i);
            if (member != null) {
                Member memberOldest = this.getOldestMember();
                if (memberOldest == null || this.compareSeniority(member, memberOldest) < 0L) {
                    this.setOldestMember(member);
                }
                if ((memberOldest = this.getOldestLocalMember()) != null && memberOldest.isCollocated(member) && this.compareSeniority(member, memberOldest) < 0L) {
                    this.setOldestLocalMember(member);
                }
                memberOldest = this.getSuccessorMember();
                Member memberThis = this.getThisMember();
                if (memberThis != null && this.compareSeniority(memberThis, member) < 0L && (memberOldest == null || this.compareSeniority(member, memberOldest) < 0L)) {
                    this.setSuccessorMember(member);
                }
            }
        }
    }

    public void setServiceLeaving(int nMember) {
        this.setState(nMember, 3);
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    public void setServiceVersion(int i, String sVersion) {
        this.setServiceVersionInt(i, ServiceMemberSet.parseVersion(sVersion));
    }

    private synchronized void setServiceVersionInt(int i, int nVersion) {
        boolean fBeyondBounds;
        int[] anVersion = this.__m_ServiceVersionInt;
        boolean bl = fBeyondBounds = anVersion == null || i >= anVersion.length;
        if (nVersion != 0 && fBeyondBounds) {
            int[] anVersionNew = new int[i + 8];
            if (anVersion != null) {
                System.arraycopy(anVersion, 0, anVersionNew, 0, anVersion.length);
            }
            this.__m_ServiceVersionInt = anVersion = anVersionNew;
            fBeyondBounds = false;
        }
        if (!fBeyondBounds) {
            anVersion[i] = nVersion;
        }
        if (anVersion != null) {
            int nMin = Integer.MAX_VALUE;
            int nMax = Integer.MIN_VALUE;
            for (int n : anVersion) {
                if (n == 0) continue;
                nMin = Math.min(n, nMin);
                nMax = Math.max(n, nMax);
            }
            this.m_nVersionMin = nMin;
            this.m_nVersionMax = nMax;
        }
    }

    protected void setState(int[] aiState) {
        this.__m_State = aiState;
    }

    public synchronized void setState(int i, int nState) {
        int[] anState = this.getState();
        if (anState == null || i >= anState.length) {
            int[] anStateNew = new int[i + 8];
            if (anState != null) {
                System.arraycopy(anState, 0, anStateNew, 0, anState.length);
            }
            anState = anStateNew;
            this.setState(anState);
        }
        anState[i] = nState;
    }

    public void setSuccessorMember(Member memberSuccessor) {
        this.__m_SuccessorMember = memberSuccessor;
    }

    public void setThisMember(Member memberThis) {
        ServiceMemberSet._assert(memberThis != null && memberThis.getId() != 0);
        ServiceMemberSet._assert(this.getThisMember() == null || memberThis == this.getThisMember());
        ServiceMemberSet._assert(this.contains(memberThis));
        this.__m_ThisMember = memberThis;
        Member memberOldestLocal = memberThis;
        Member memberSuccessor = null;
        for (Member member : this) {
            if (memberThis.isCollocated(member) && this.compareSeniority(member, memberOldestLocal) < 0L) {
                memberOldestLocal = member;
            }
            if (this.compareSeniority(memberThis, member) >= 0L || memberSuccessor != null && this.compareSeniority(member, memberSuccessor) >= 0L) continue;
            memberSuccessor = member;
        }
        this.setOldestLocalMember(memberOldestLocal);
        this.setSuccessorMember(memberSuccessor);
    }

    @Override
    public String toString() {
        return this.get_Name() + "(" + this.getDescription() + "\n  )";
    }

    public static int[] toVersionArray(String sVersion) {
        return VersionHelper.toVersionArray(sVersion);
    }

    protected static String toVersionString(int nVersion, boolean fIncludePrefix) {
        return VersionHelper.toVersionString(nVersion, fIncludePrefix);
    }

    public void updateMemberConfigMap(int nMember, Map map) {
        ObservableMap mapConfig;
        if (map != null && (mapConfig = this.ensureMemberConfigMap(nMember)) != null) {
            mapConfig.clear();
            mapConfig.putAll(map);
        }
    }

    static {
        ServiceMemberSet.__initStatic();
    }
}

