/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.memberSet;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class DependentMemberSet
extends MemberSet
implements Cloneable {
    private MemberSet __m_BaseSet;
    private int[] __m_DestinationMessageId;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Iterator", MemberSet.Iterator.get_CLASS());
    }

    public DependentMemberSet() {
        this(null, null, true);
    }

    public DependentMemberSet(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new DependentMemberSet();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/memberSet/DependentMemberSet".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public synchronized boolean addAll() {
        return this.addAll((Collection)this.getBaseSet());
    }

    public Object clone() {
        int[] aBits;
        DependentMemberSet that;
        try {
            that = (DependentMemberSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
        Member[] aMember = this.getMember();
        if (aMember != null) {
            that.setMember((Member[])aMember.clone());
        }
        if ((aBits = this.getBitSet()) != null) {
            that.setBitSet((int[])aBits.clone());
        }
        return that;
    }

    @Override
    public synchronized boolean contains(int nId) {
        return super.contains(nId) && this.getBaseSet().contains(nId);
    }

    @Override
    public synchronized boolean contains(Object o) {
        return super.contains(o) && this.getBaseSet().contains(o);
    }

    @Override
    public synchronized boolean containsAll(Collection collection) {
        this.sync();
        return super.containsAll(collection);
    }

    public MemberSet getBaseSet() {
        return this.__m_BaseSet;
    }

    protected int[] getDestinationMessageId() {
        return this.__m_DestinationMessageId;
    }

    public int getDestinationMessageId(int i) {
        int[] an = this.getDestinationMessageId();
        return an != null && i < an.length ? an[i] : 0;
    }

    @Override
    public Member getMember(int i) {
        return this.getBaseSet().getMember(i);
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.getBaseSet().isEmpty()) {
            this.clear();
            return true;
        }
        this.sync();
        return super.isEmpty();
    }

    public void setBaseSet(MemberSet set) {
        DependentMemberSet._assert(this.getBaseSet() == null && set != null);
        this.__m_BaseSet = set;
    }

    protected void setDestinationMessageId(int[] an) {
        this.__m_DestinationMessageId = an;
    }

    public void setDestinationMessageId(int i, int nId) {
        int[] an = this.getDestinationMessageId();
        if (an == null || i >= an.length) {
            int cNew = Math.max(i + (i >>> 1), i + 4);
            int[] anNew = new int[cNew];
            if (an != null) {
                System.arraycopy(an, 0, anNew, 0, an.length);
            }
            an = anNew;
            this.setDestinationMessageId(anNew);
        }
        an[i] = nId;
    }

    @Override
    public synchronized int size() {
        this.sync();
        return super.size();
    }

    public void sync() {
        this.retainAll((Collection)this.getBaseSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object[] toArray(Object[] ao) {
        MemberSet setBase;
        MemberSet memberSet = setBase = this.getBaseSet();
        synchronized (memberSet) {
            int c = this.size();
            if (ao == null) {
                ao = new Member[c];
            } else if (ao.length < c) {
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), c);
            } else if (ao.length > c) {
                ao[c] = null;
            }
            int of = 0;
            for (Member member : setBase) {
                if (!this.contains(member)) continue;
                ao[of++] = member;
            }
            return ao;
        }
    }

    public void writeFewWithMessageId(WriteBuffer.BufferOutput output) throws IOException {
        int cMembers = this.size();
        this.writeFew(output);
        DependentMemberSet._assert(cMembers <= 255);
        if (cMembers > 0) {
            int c = this.getBitSetCount();
            for (int i = 0; i < c && cMembers > 0; ++i) {
                int n = this.getBitSet(i);
                if (n == 0) continue;
                int nBase = i << 5;
                int of = 1;
                int nMask = 1;
                while (of <= 32) {
                    if ((n & nMask) != 0) {
                        int nMemberId = nBase + of;
                        int nMessageTo = this.getDestinationMessageId(nMemberId);
                        Packet.writeTrint(output, nMessageTo);
                        --cMembers;
                    }
                    ++of;
                    nMask <<= 1;
                }
            }
        }
    }

    public void writeManyWithMessageId(WriteBuffer.BufferOutput output) throws IOException {
        int cMembers = this.size();
        this.writeMany(output);
        output.writeShort(cMembers);
        if (cMembers > 0) {
            int c = this.getBitSetCount();
            for (int i = 0; i < c && cMembers > 0; ++i) {
                int n = this.getBitSet(i);
                if (n == 0) continue;
                int nBase = i << 5;
                int of = 1;
                int nMask = 1;
                while (of <= 32) {
                    if ((n & nMask) != 0) {
                        int nMemberId = nBase + of;
                        int nMessageTo = this.getDestinationMessageId(nMemberId);
                        Packet.writeTrint(output, nMessageTo);
                        --cMembers;
                    }
                    ++of;
                    nMask <<= 1;
                }
            }
        }
    }

    public void writeOneWithMessageId(WriteBuffer.BufferOutput output) throws IOException {
        this.writeOne(output);
        int nMemberTo = this.getFirstId();
        DependentMemberSet._assert(nMemberTo != 0);
        int nMessageTo = this.getDestinationMessageId(nMemberTo);
        Packet.writeTrint(output, nMessageTo);
    }

    static {
        DependentMemberSet.__initStatic();
    }
}

