/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.notificationHandler;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.management.Connector;
import com.tangosol.coherence.component.net.management.NotificationHandler;
import com.tangosol.coherence.component.net.management.listenerHolder.RemoteHolder;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.WrapperException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Notification;

public class RemoteHandler
extends NotificationHandler {
    private Connector __m_Connector;

    public RemoteHandler() {
        this(null, null, true);
    }

    public RemoteHandler(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setSubscriptions(new SafeHashSet());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new RemoteHandler();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/notificationHandler/RemoteHandler".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    protected Connector ensureRunningConnector() {
        Connector conn = this.getConnector();
        if (conn.isStarted()) {
            return conn;
        }
        conn.startService(null);
        return conn.isStarted() ? conn : null;
    }

    public Connector getConnector() {
        return this.__m_Connector;
    }

    public void handleNotification(Notification notification) {
        Connector connector = this.ensureRunningConnector();
        Set setHolders = this.getSubscriptions();
        if (connector == null) {
            RemoteHandler._trace("Unable to send notification due to an abnormal termination of the management service: " + String.valueOf(notification), 2);
        } else if (setHolders != null) {
            HashSet<Member> setMembers = new HashSet<Member>();
            for (RemoteHolder holder : setHolders) {
                Member member = connector.getMember(holder.getMemberId());
                if (member == null || setMembers.contains(member) || !holder.evaluate(notification)) continue;
                setMembers.add(member);
            }
            if (setMembers.size() > 0) {
                connector.sendNotification(setMembers, this.getName(), notification);
            }
        }
    }

    public void setConnector(Connector connector) {
        this.__m_Connector = connector;
    }

    @Override
    public void setSubscriptions(Set setSubscriptions) {
        super.setSubscriptions(setSubscriptions);
    }

    public void unsubscribe(int nMember, long lHolderId) {
        Iterator iter = this.getSubscriptions().iterator();
        while (iter.hasNext()) {
            RemoteHolder holder = (RemoteHolder)iter.next();
            if (holder.getMemberId() != nMember || holder.getHolderId() != lHolderId) continue;
            iter.remove();
        }
    }

    public void unsubscribeMember(int nMember) {
        Iterator iter = this.getSubscriptions().iterator();
        while (iter.hasNext()) {
            RemoteHolder holder = (RemoteHolder)iter.next();
            if (holder.getMemberId() != nMember) continue;
            iter.remove();
        }
    }
}

