/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache.Storage;
import com.tangosol.internal.util.VersionHelper;
import com.tangosol.net.NamedCache;
import com.tangosol.net.events.internal.StorageDispatcher;
import com.tangosol.net.internal.PartitionSizeAggregator;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.AlwaysFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class StorageManagerModel
extends LocalModel {
    private transient Storage __m__Storage;
    private transient WeakReference __m__StorageRef;
    private long __m_MaxQueryThresholdMillis;

    public StorageManagerModel() {
        this(null, null, true);
    }

    public StorageManagerModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new StorageManagerModel();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/model/localModel/StorageManagerModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public Storage get_Storage() {
        WeakReference wr = this.get_StorageRef();
        return wr == null ? null : (Storage)wr.get();
    }

    protected WeakReference get_StorageRef() {
        return this.__m__StorageRef;
    }

    public String[] getEventInterceptorInfo() {
        StorageDispatcher dispatcher;
        Storage storage = this.get_Storage();
        StorageDispatcher storageDispatcher = dispatcher = storage == null ? null : storage.getEventDispatcher();
        if (dispatcher == null) {
            return new String[0];
        }
        return dispatcher.getStats().toStringArray();
    }

    public long getEventsDispatched() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsEventsDispatched();
    }

    public long getEvictionCount() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsEvictions().get();
    }

    public String[] getIndexInfo() {
        Map mapIndex;
        String[] asInfo = new String[]{};
        Storage storage = this.get_Storage();
        Map map = mapIndex = storage == null ? null : storage.getIndexMap();
        if (mapIndex != null && !mapIndex.isEmpty()) {
            ArrayList<String> listInfo = new ArrayList<String>(mapIndex.size());
            for (int cAttempts = 4; cAttempts > 0; --cAttempts) {
                try {
                    for (MapIndex index : mapIndex.values()) {
                        if (index == null) continue;
                        listInfo.add(index.toString());
                    }
                    break;
                }
                catch (ConcurrentModificationException e) {
                    listInfo.clear();
                    continue;
                }
            }
            asInfo = listInfo.toArray(asInfo);
        }
        return asInfo;
    }

    public long getIndexingTotalMillis() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsIndexingTotalMillis().get();
    }

    public long getIndexTotalUnits() {
        Map mapIndex;
        long cUnits = 0L;
        Storage storage = this.get_Storage();
        Map map = mapIndex = storage == null ? null : storage.getIndexMap();
        if (mapIndex != null && !mapIndex.isEmpty()) {
            for (int cAttempts = 4; cAttempts > 0; --cAttempts) {
                try {
                    for (MapIndex index : mapIndex.values()) {
                        if (index == null) continue;
                        cUnits += index.getUnits();
                    }
                    break;
                }
                catch (ConcurrentModificationException e) {
                    cUnits = 0L;
                    continue;
                }
            }
        }
        return cUnits;
    }

    public long getInsertCount() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsInserts().get();
    }

    public int getListenerFilterCount() {
        Map map;
        Storage storage = this.get_Storage();
        Map map2 = map = storage == null ? null : storage.getListenerMap();
        if (map == null) {
            return 0;
        }
        int cListeners = 0;
        for (int cAttempts = 4; cAttempts > 0; --cAttempts) {
            try {
                for (Map.Entry entry : map.entrySet()) {
                    Map mapMember = (Map)entry.getValue();
                    if (mapMember == null) continue;
                    cListeners += mapMember.size();
                }
                break;
            }
            catch (ConcurrentModificationException e) {
                cListeners = 0;
                continue;
            }
        }
        return cListeners;
    }

    public int getListenerKeyCount() {
        Map map;
        Storage storage = this.get_Storage();
        Map map2 = map = storage == null ? null : storage.getKeyListenerMap();
        if (map == null) {
            return 0;
        }
        int cListeners = 0;
        for (int cAttempts = 4; cAttempts > 0; --cAttempts) {
            try {
                for (Map.Entry entry : map.entrySet()) {
                    Map mapMember = (Map)entry.getValue();
                    if (mapMember == null) continue;
                    cListeners += mapMember.size();
                }
                break;
            }
            catch (ConcurrentModificationException e) {
                cListeners = 0;
                continue;
            }
        }
        return cListeners;
    }

    public long getListenerRegistrations() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsListenerRegistrations().get();
    }

    public int getLocksGranted() {
        Storage storage = this.get_Storage();
        Map mapLocks = storage == null ? null : storage.getLeaseMap();
        return mapLocks == null ? 0 : mapLocks.size();
    }

    public int getLocksPending() {
        Storage storage = this.get_Storage();
        List listRequests = storage == null ? null : storage.getPendingLockRequest();
        return listRequests == null ? 0 : listRequests.size();
    }

    public String getMaxQueryDescription() {
        Storage storage = this.get_Storage();
        return storage == null ? StorageManagerModel.canonicalString(null) : storage.getStatsMaxQueryDescription();
    }

    public long getMaxQueryDurationMillis() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsMaxQueryDurationMillis();
    }

    public long getMaxQueryThresholdMillis() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsMaxQueryThresholdMillis();
    }

    public long getNonOptimizedQueryAverageMillis() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsNonOptimizedQueryAverageMillis();
    }

    public long getNonOptimizedQueryCount() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsNonOptimizedQueryCount().get();
    }

    public long getNonOptimizedQueryTotalMillis() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsNonOptimizedQueryTotalMillis().get();
    }

    public long getOptimizedQueryAverageMillis() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsOptimizedQueryAverageMillis();
    }

    public long getOptimizedQueryCount() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsOptimizedQueryCount().get();
    }

    public long getOptimizedQueryTotalMillis() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsOptimizedQueryTotalMillis().get();
    }

    public long getQueryContentionCount() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsQueryContentionCount().get();
    }

    public long getRemoveCount() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsRemoves().get();
    }

    public long getClearCount() {
        Storage storage = this.get_Storage();
        return storage == null ? -1L : storage.getStatsClears().get();
    }

    public String[] getTriggerInfo() {
        Set setTrigger;
        String[] asInfo = new String[]{};
        Storage storage = this.get_Storage();
        Set set = setTrigger = storage == null ? null : storage.getTriggerSet();
        if (setTrigger != null && !setTrigger.isEmpty()) {
            ArrayList<String> listInfo = new ArrayList<String>(setTrigger.size());
            for (int cAttempts = 4; cAttempts > 0; --cAttempts) {
                try {
                    Iterator iter = setTrigger.iterator();
                    while (iter.hasNext()) {
                        listInfo.add(iter.next().toString());
                    }
                    break;
                }
                catch (ConcurrentModificationException e) {
                    listInfo.clear();
                    continue;
                }
            }
            asInfo = listInfo.toArray(asInfo);
        }
        return asInfo;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("EventInterceptorInfo", ExternalizableHelper.readStringArray(in));
        mapSnapshot.put("EventsDispatched", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("EvictionCount", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("IndexInfo", ExternalizableHelper.readStringArray(in));
        mapSnapshot.put("IndexTotalUnits", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("InsertCount", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("ListenerFilterCount", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("ListenerKeyCount", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("ListenerRegistrations", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("LocksGranted", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("LocksPending", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MaxQueryDescription", ExternalizableHelper.readUTF(in));
        mapSnapshot.put("MaxQueryDurationMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("MaxQueryThresholdMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("NonOptimizedQueryAverageMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("NonOptimizedQueryCount", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("NonOptimizedQueryTotalMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("OptimizedQueryAverageMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("OptimizedQueryCount", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("OptimizedQueryTotalMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("QueryContentionCount", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("RemoveCount", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TriggerInfo", ExternalizableHelper.readStringArray(in));
        if (ExternalizableHelper.isVersionCompatible(in, 21, 6, 0)) {
            mapSnapshot.put("IndexingTotalMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        }
        if (ExternalizableHelper.isVersionCompatible(in, VersionHelper.VERSION_23_09_1) || ExternalizableHelper.isPatchCompatible(in, VersionHelper.VERSION_14_1_2_0) || ExternalizableHelper.isPatchCompatible(in, VersionHelper.VERSION_14_1_1_2206_7)) {
            mapSnapshot.put("ClearCount", ExternalizableHelper.readLong(in));
        }
    }

    public void resetStatistics() {
        Storage storage = this.get_Storage();
        if (storage != null) {
            storage.resetStats();
        }
    }

    public void clearCache() {
        this.checkReadOnly("clearCache");
        Storage storage = this.get_Storage();
        PartitionedCache service = storage.getService();
        if (service != null) {
            NamedCache cache = service.ensureCache(storage.getCacheName(), null);
            cache.clear();
        }
    }

    public void truncateCache() {
        PartitionedCache service;
        this.checkReadOnly("truncateCache");
        Storage storage = this.get_Storage();
        if (storage != null && (service = storage.getService()) != null) {
            NamedCache cache = service.ensureCache(storage.getCacheName(), null);
            cache.truncate();
        }
    }

    public int size() {
        PartitionedCache service;
        Storage storage = this.get_Storage();
        if (storage != null && (service = storage.getService()) != null) {
            return service.ensureCache(storage.getCacheName(), null).size();
        }
        return 0;
    }

    public Object reportPartitionStats(String sFormat) {
        PartitionedCache service;
        Storage storage = this.get_Storage();
        if (storage != null && (service = storage.getService()) != null) {
            NamedCache cache = service.ensureCache(storage.getCacheName(), null);
            Set setResults = (Set)cache.aggregate(AlwaysFilter.INSTANCE(), new PartitionSizeAggregator());
            if ("native".equals(sFormat)) {
                return setResults.toArray();
            }
            String[] asFormats = new String[]{"{\"partitionId\":%d, \"count\": %d, \"totalSize\": %d, \"maxEntrySize\": %d, \"memberId\": %d}", "%d,%d,%d,%d,%d"};
            AtomicInteger index = new AtomicInteger(0);
            String sJoin = ",\n";
            String sFinal = "]";
            StringBuilder sb = new StringBuilder();
            if ("csv".equals(sFormat)) {
                index.set(1);
                sJoin = "\n";
                sFinal = "";
            } else {
                sb.append("[");
            }
            String sResult = setResults.stream().map(v -> String.format(asFormats[index.intValue()], v.getPartitionId(), v.getCount(), v.getTotalSize(), v.getMaxEntrySize(), v.getMemberId())).collect(Collectors.joining(sJoin));
            sb.append(sResult);
            return sb.append(sFinal).toString();
        }
        return "[]]";
    }

    public void set_Storage(Storage storage) {
        this.set_StorageRef(new WeakReference<Storage>(storage));
    }

    protected void set_StorageRef(WeakReference refStorage) {
        this.__m__StorageRef = refStorage;
    }

    public void setMaxQueryThresholdMillis(long cMillis) {
        this.checkReadOnly("setMaxQueryThresholdMillis");
        Storage storage = this.get_Storage();
        if (storage != null) {
            storage.setStatsMaxQueryThresholdMillis(cMillis);
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeStringArray(out, this.getEventInterceptorInfo());
        ExternalizableHelper.writeLong(out, this.getEventsDispatched());
        ExternalizableHelper.writeLong(out, this.getEvictionCount());
        ExternalizableHelper.writeStringArray(out, this.getIndexInfo());
        ExternalizableHelper.writeLong(out, this.getIndexTotalUnits());
        ExternalizableHelper.writeLong(out, this.getInsertCount());
        ExternalizableHelper.writeInt(out, this.getListenerFilterCount());
        ExternalizableHelper.writeInt(out, this.getListenerKeyCount());
        ExternalizableHelper.writeLong(out, this.getListenerRegistrations());
        ExternalizableHelper.writeInt(out, this.getLocksGranted());
        ExternalizableHelper.writeInt(out, this.getLocksPending());
        ExternalizableHelper.writeUTF(out, this.getMaxQueryDescription());
        ExternalizableHelper.writeLong(out, this.getMaxQueryDurationMillis());
        ExternalizableHelper.writeLong(out, this.getMaxQueryThresholdMillis());
        ExternalizableHelper.writeLong(out, this.getNonOptimizedQueryAverageMillis());
        ExternalizableHelper.writeLong(out, this.getNonOptimizedQueryCount());
        ExternalizableHelper.writeLong(out, this.getNonOptimizedQueryTotalMillis());
        ExternalizableHelper.writeLong(out, this.getOptimizedQueryAverageMillis());
        ExternalizableHelper.writeLong(out, this.getOptimizedQueryCount());
        ExternalizableHelper.writeLong(out, this.getOptimizedQueryTotalMillis());
        ExternalizableHelper.writeLong(out, this.getQueryContentionCount());
        ExternalizableHelper.writeLong(out, this.getRemoveCount());
        ExternalizableHelper.writeStringArray(out, this.getTriggerInfo());
        if (ExternalizableHelper.isVersionCompatible(out, 21, 6, 0)) {
            ExternalizableHelper.writeLong(out, this.getIndexingTotalMillis());
        }
        if (ExternalizableHelper.isVersionCompatible(out, VersionHelper.VERSION_23_09_1) || ExternalizableHelper.isPatchCompatible(out, VersionHelper.VERSION_14_1_2_0) || ExternalizableHelper.isPatchCompatible(out, VersionHelper.VERSION_14_1_1_2206_7)) {
            ExternalizableHelper.writeLong(out, this.getClearCount());
        }
    }
}

