/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.net.Member;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConnectionModel
extends LocalModel {
    private TcpAcceptor.TcpConnection __m__TcpConnection;
    private transient boolean __m_MessagingDebug;

    public ConnectionModel() {
        this(null, null, true);
    }

    public ConnectionModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new ConnectionModel();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/model/localModel/ConnectionModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public void closeConnection() {
        this.checkReadOnly("closeConnection");
        this.get_TcpConnection().close(true, null);
    }

    public TcpAcceptor.TcpConnection get_TcpConnection() {
        return this.__m__TcpConnection;
    }

    public String getClientAddress() {
        Member member = this.get_TcpConnection().getMember();
        return member == null ? ConnectionModel.canonicalString(null) : member.getAddress().getHostAddress();
    }

    public String getClientProcessName() {
        Member member = this.get_TcpConnection().getMember();
        return member == null ? ConnectionModel.canonicalString(null) : member.getProcessName();
    }

    public String getClientRole() {
        Member member = this.get_TcpConnection().getMember();
        return member == null ? ConnectionModel.canonicalString(null) : member.getRoleName();
    }

    public long getConnectionTimeMillis() {
        return System.currentTimeMillis() - this.get_TcpConnection().getConnectTimeMillis();
    }

    public String getMember() {
        Member member = this.get_TcpConnection().getMember();
        return member == null ? ConnectionModel.canonicalString(null) : member.toString();
    }

    public long getOutgoingByteBacklog() {
        Queue queue = this.get_TcpConnection().getOutgoingQueue();
        long cBacklog = 0L;
        Iterator iter = queue.iterator();
        while (iter.hasNext()) {
            MultiBufferWriteBuffer buffer = (MultiBufferWriteBuffer)iter.next();
            cBacklog += (long)buffer.length();
        }
        return cBacklog;
    }

    public int getOutgoingMessageBacklog() {
        Queue queue = this.get_TcpConnection().getOutgoingQueue();
        return queue == null ? 0 : queue.size();
    }

    public String getRemoteAddress() {
        Socket socket = this.get_TcpConnection().getSocket();
        if (socket == null) {
            return null;
        }
        InetAddress address = socket.getInetAddress();
        return address == null ? null : address.getHostAddress();
    }

    public int getRemotePort() {
        Socket socket = this.get_TcpConnection().getSocket();
        return socket == null ? 0 : socket.getPort();
    }

    public Date getTimestamp() {
        return new Date(this.get_TcpConnection().getConnectTimeMillis());
    }

    public long getTotalBytesReceived() {
        return this.get_TcpConnection().getStatsBytesReceived();
    }

    public long getTotalBytesSent() {
        return this.get_TcpConnection().getStatsBytesSent();
    }

    public long getTotalMessagesReceived() {
        return this.get_TcpConnection().getStatsReceived();
    }

    public long getTotalMessagesSent() {
        return this.get_TcpConnection().getStatsSent();
    }

    public String getUUID() {
        return String.valueOf(this.get_TcpConnection().getId());
    }

    public boolean isMessagingDebug() {
        return this.get_TcpConnection().isMessagingDebug();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("ConnectionTimeMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("Member", ExternalizableHelper.readUTF(in));
        mapSnapshot.put("OutgoingByteBacklog", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("OutgoingMessageBacklog", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("RemoteAddress", ExternalizableHelper.readUTF(in));
        mapSnapshot.put("RemotePort", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("Timestamp", new Date(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalBytesReceived", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalBytesSent", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalMessagesReceived", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalMessagesSent", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("UUID", ExternalizableHelper.readUTF(in));
        if (ExternalizableHelper.isVersionCompatible(in, 14, 1, 1, 0, 4)) {
            mapSnapshot.put("ClientAddress", ExternalizableHelper.readUTF(in));
            mapSnapshot.put("ClientProcessName", ExternalizableHelper.readUTF(in));
            mapSnapshot.put("ClientRole", ExternalizableHelper.readUTF(in));
        }
    }

    public void resetStatistics() {
        this.get_TcpConnection().resetStats();
    }

    public void set_TcpConnection(TcpAcceptor.TcpConnection connection) {
        this.__m__TcpConnection = connection;
    }

    public void setMessagingDebug(boolean fMessageDebug) {
        this.get_TcpConnection().setMessagingDebug(fMessageDebug);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeLong(out, this.getConnectionTimeMillis());
        ExternalizableHelper.writeUTF(out, this.getMember());
        ExternalizableHelper.writeLong(out, this.getOutgoingByteBacklog());
        ExternalizableHelper.writeInt(out, this.getOutgoingMessageBacklog());
        ExternalizableHelper.writeUTF(out, this.getRemoteAddress());
        ExternalizableHelper.writeInt(out, this.getRemotePort());
        ExternalizableHelper.writeLong(out, this.getTimestamp().getTime());
        ExternalizableHelper.writeLong(out, this.getTotalBytesReceived());
        ExternalizableHelper.writeLong(out, this.getTotalBytesSent());
        ExternalizableHelper.writeLong(out, this.getTotalMessagesReceived());
        ExternalizableHelper.writeLong(out, this.getTotalMessagesSent());
        ExternalizableHelper.writeUTF(out, this.getUUID());
        if (ExternalizableHelper.isVersionCompatible(out, 14, 1, 1, 0, 4)) {
            ExternalizableHelper.writeUTF(out, this.getClientAddress());
            ExternalizableHelper.writeUTF(out, this.getClientProcessName());
            ExternalizableHelper.writeUTF(out, this.getClientRole());
        }
    }
}

