/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.oracle.coherence.common.base.SingleWaiterCooperativeNotifier;
import com.oracle.coherence.common.internal.net.socketbus.AbstractSocketBus;
import com.oracle.coherence.common.internal.util.HeapDump;
import com.oracle.coherence.common.net.exabus.MessageBus;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MessageHandler;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.TcpRing;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.coherence.component.net.socket.udpSocket.UnicastUdpSocket;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketReceiver;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.TransportService;
import com.tangosol.coherence.component.util.queue.concurrentQueue.balancedQueue.BundlingQueue;
import com.tangosol.internal.tracing.TracingShim;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ClusterDependencies;
import com.tangosol.net.ConfigurableQuorumPolicy;
import com.tangosol.net.DescribableAddressProvider;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.Service;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class ClusterNodeModel
extends LocalModel {
    private transient SafeCluster __m__Cluster;
    private transient WeakReference __m__ClusterRef;
    private transient com.tangosol.net.Member __m__Member;
    private transient WeakReference __m__MemberRef;
    private int __m_BufferPublishSize;
    private int __m_BufferReceiveSize;
    private String __m_LoggingFormat;
    private int __m_LoggingLevel;
    private int __m_LoggingLimit;
    private int __m_MulticastThreshold;
    private int __m_ResendDelay;
    private int __m_SendAckDelay;
    private float __m_TracingSamplingRatio;
    private int __m_TrafficJamCount;
    private int __m_TrafficJamDelay;

    public ClusterNodeModel() {
        this(null, null, true);
    }

    public ClusterNodeModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new ClusterNodeModel();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/model/localModel/ClusterNodeModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    protected String createNodeState() {
        this.checkReadOnly("reportNodeState");
        StringBuilder sb = new StringBuilder(GuardSupport.getThreadDump());
        ClusterService clusterService = this.get_ClusterService();
        int cServices = clusterService.getServiceCount();
        for (int i = 0; i < cServices; ++i) {
            List listPolls;
            Grid service = clusterService.getService(i);
            List list = listPolls = service == null ? null : service.getOutstandingPolls(0L);
            if (listPolls == null || listPolls.isEmpty()) continue;
            sb.append("\n\n *** Outstanding polls: ***");
            for (Poll poll : listPolls) {
                Thread thread;
                sb.append('\n').append(poll);
                SingleWaiterCooperativeNotifier notifier = poll.getNotifier();
                if (notifier == null || (thread = notifier.getWaitingThread()) == null) continue;
                sb.append("\nWaiting Thread: ").append(thread).append('\n');
                StackTraceElement[] aElements = thread.getStackTrace();
                for (int j = 0; j < aElements.length; ++j) {
                    sb.append('\t').append(aElements[j]).append('\n');
                }
            }
        }
        return sb.toString();
    }

    public String dumpHeap(String sFileName) {
        this.checkReadOnly("dumpHeap");
        return HeapDump.dumpHeap(sFileName, true);
    }

    public String ensureService(String sServiceName) {
        this.checkReadOnly("ensureService");
        Service service = CacheFactory.getService(sServiceName);
        return service == null ? null : service.getInfo().getServiceType();
    }

    public SafeCluster get_Cluster() {
        WeakReference wr = this.get_ClusterRef();
        return wr == null ? null : (SafeCluster)wr.get();
    }

    protected WeakReference get_ClusterRef() {
        return this.__m__ClusterRef;
    }

    public ClusterService get_ClusterService() {
        SafeCluster clusterSafe = this.get_Cluster();
        return clusterSafe != null && clusterSafe.isRunning() ? clusterSafe.getCluster().getClusterService() : null;
    }

    public PacketListener get_ListenerPreferred() {
        SafeCluster clusterSafe = this.get_Cluster();
        return clusterSafe != null && clusterSafe.isRunning() ? clusterSafe.getCluster().getPreferredListener() : null;
    }

    public com.tangosol.net.Member get_Member() {
        WeakReference wr = this.get_MemberRef();
        return wr == null ? null : (Member)wr.get();
    }

    protected WeakReference get_MemberRef() {
        return this.__m__MemberRef;
    }

    public MessageHandler get_MessageHandler() {
        TransportService transportSvc = this.get_TransportService();
        return transportSvc == null ? null : transportSvc.getMessageHandler();
    }

    public PacketPublisher get_Publisher() {
        SafeCluster clusterSafe = this.get_Cluster();
        return clusterSafe != null && clusterSafe.isRunning() ? clusterSafe.getCluster().getPublisher() : null;
    }

    public PacketReceiver get_Receiver() {
        SafeCluster clusterSafe = this.get_Cluster();
        return clusterSafe != null && clusterSafe.isRunning() ? clusterSafe.getCluster().getReceiver() : null;
    }

    public PacketSpeaker get_Speaker() {
        SafeCluster clusterSafe = this.get_Cluster();
        return clusterSafe != null && clusterSafe.isRunning() ? clusterSafe.getCluster().getSpeaker() : null;
    }

    public TcpRing get_TcpRing() {
        SafeCluster clusterSafe = this.get_Cluster();
        return clusterSafe != null && clusterSafe.isRunning() ? clusterSafe.getCluster().getClusterService().getTcpRing() : null;
    }

    public TransportService get_TransportService() {
        SafeCluster clusterSafe = this.get_Cluster();
        return clusterSafe != null && clusterSafe.isRunning() ? clusterSafe.getCluster().getTransportService() : null;
    }

    public int getBufferPublishSize() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getUdpSocketUnicast().getBufferSentBytes() / publisher.getPreferredPacketLength();
    }

    public int getBufferReceiveSize() {
        PacketListener listener = this.get_ListenerPreferred();
        return listener == null ? -1 : listener.getUdpSocket().getBufferReceivedBytes() / listener.getPacketLength();
    }

    public int getCpuCount() {
        Member member = (Member)this.get_Member();
        return member == null ? -1 : member.getCpuCount();
    }

    @Override
    public String getDescription() {
        Member member = (Member)this.get_Member();
        return member == null ? "n/a" : "Uid=" + String.valueOf(member.getUid());
    }

    public int getGuardRecoverCount() {
        SafeCluster clusterSafe = this.get_Cluster();
        return clusterSafe != null && clusterSafe.isRunning() ? clusterSafe.getCluster().getGuardRecoverCount() : -1;
    }

    public int getGuardTerminateCount() {
        SafeCluster clusterSafe = this.get_Cluster();
        return clusterSafe != null && clusterSafe.isRunning() ? clusterSafe.getCluster().getGuardTerminateCount() : -1;
    }

    public int getId() {
        Member member = (Member)this.get_Member();
        return member == null ? -1 : member.getId();
    }

    public String getLoggingDestination() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence.Logger logger = singleton.getLogger();
        return logger == null ? null : logger.getDestination();
    }

    public String getLoggingFormat() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence.Logger logger = singleton.getLogger();
        return logger == null ? null : logger.getFormat();
    }

    public int getLoggingLevel() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence.Logger logger = singleton.getLogger();
        return logger == null ? -1 : logger.getLevel();
    }

    public int getLoggingLimit() {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence.Logger logger = singleton.getLogger();
        return logger == null ? -1 : logger.getLimit();
    }

    public int getMachineId() {
        Member member = (Member)this.get_Member();
        return member == null ? -1 : member.getMachineId();
    }

    public String getMachineName() {
        Member member = (Member)this.get_Member();
        return member == null ? ClusterNodeModel.canonicalString(null) : ClusterNodeModel.canonicalString(member.getMachineName());
    }

    public String getMemberName() {
        Member member = (Member)this.get_Member();
        return member == null ? ClusterNodeModel.canonicalString(null) : ClusterNodeModel.canonicalString(member.getMemberName());
    }

    public int getMemoryAvailableMB() {
        Runtime runtime = Runtime.getRuntime();
        return (int)((runtime.freeMemory() + runtime.maxMemory() - runtime.totalMemory()) / 0x100000L);
    }

    public int getMemoryMaxMB() {
        return (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
    }

    public String getMulticastAddress() {
        PacketPublisher publisher = this.get_Publisher();
        InetSocketAddress addr = publisher == null ? null : publisher.getMulticastAddress();
        return addr == null ? ClusterNodeModel.canonicalString(null) : String.valueOf(addr.getAddress());
    }

    public int getMulticastPort() {
        ClusterDependencies clusterDeps;
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null && (clusterDeps = cluster.getDependencies()) != null) {
            return clusterDeps.getGroupPort();
        }
        return -1;
    }

    public int getMulticastThreshold() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : (int)(100.0 * publisher.getMulticastThreshold());
    }

    public int getMulticastTTL() {
        SafeCluster cluster = this.get_Cluster();
        return cluster == null ? -1 : cluster.getCluster().getDependencies().getGroupTimeToLive();
    }

    public long getNackSent() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsNacksSent();
    }

    public float getPacketDeliveryEfficiency() {
        PacketPublisher publisher = this.get_Publisher();
        if (publisher == null) {
            return 0.0f;
        }
        long lSent = publisher.getStatsSent();
        long lWasted = publisher.getStatsResentExcess();
        return lSent == 0L ? 1.0f : (float)(1.0 - (double)lWasted / (double)lSent);
    }

    public long getPacketsBundled() {
        PacketSpeaker speaker = this.get_Speaker();
        return speaker == null ? -1L : ((BundlingQueue)speaker.getQueue()).getStatsBundled();
    }

    public long getPacketsReceived() {
        PacketReceiver receiver = this.get_Receiver();
        return receiver == null ? -1L : receiver.getStatsReceived();
    }

    public long getPacketsRepeated() {
        PacketReceiver receiver = this.get_Receiver();
        return receiver == null ? -1L : receiver.getStatsRepeated();
    }

    public long getPacketsResent() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsResent();
    }

    public long getPacketsResentEarly() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsResentEarly();
    }

    public long getPacketsResentExcess() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsResentExcess();
    }

    public long getPacketsSent() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1L : publisher.getStatsSent();
    }

    public int getPriority() {
        Member member = (Member)this.get_Member();
        return member == null ? -1 : member.getPriority();
    }

    public String getProcessName() {
        Member member = (Member)this.get_Member();
        return member == null ? ClusterNodeModel.canonicalString(null) : ClusterNodeModel.canonicalString(member.getProcessName());
    }

    public String getProductEdition() {
        Member member = (Member)this.get_Member();
        return member == null ? "n/a" : Member.EDITION_NAME[member.getEdition()];
    }

    public float getPublisherPacketUtilization() {
        SafeCluster clusterSafe = this.get_Cluster();
        if (clusterSafe != null && clusterSafe.isRunning()) {
            Cluster.SocketManager manager = clusterSafe.getCluster().getSocketManager();
            Cluster.SocketManager.UnicastUdpSocket socket = manager.getUnicastUdpSocket();
            Cluster.SocketManager.PreferredUnicastUdpSocket socketPref = manager.getPreferredUnicastUdpSocket();
            Cluster.SocketManager.BroadcastUdpSocket socketBroad = manager.getBroadcastUdpSocket();
            long cPackets = socketPref.getCountSent() + socket.getCountSent() + socketBroad.getCountSent();
            long cBytes = socketPref.getBytesSent() + socket.getBytesSent() + socketBroad.getBytesSent();
            if (cPackets == 0L) {
                return 1.0f;
            }
            return (float)((double)cBytes / (double)cPackets / (double)socketPref.getPacketLength());
        }
        return 0.0f;
    }

    public float getPublisherSuccessRate() {
        PacketPublisher publisher = this.get_Publisher();
        if (publisher == null) {
            return 0.0f;
        }
        long lSent = publisher.getStatsSent();
        long lResent = publisher.getStatsResent();
        return lSent == 0L ? 1.0f : (float)(1.0 - (double)lResent / (double)lSent);
    }

    public String getQuorumStatus() {
        StringBuilder sbQuorum = new StringBuilder();
        ClusterService service = this.get_ClusterService();
        if (service != null) {
            ActionPolicy policy = service.getActionPolicy();
            String sPolicy = null;
            String sStatus = service.getQuorumControl().formatStatus();
            if (sStatus.length() > 0) {
                sbQuorum.append(sStatus).append("; ");
            }
            if (policy instanceof NullImplementation.NullActionPolicy) {
                sPolicy = "Not configured";
            } else if (policy instanceof ConfigurableQuorumPolicy) {
                sPolicy = ((ConfigurableQuorumPolicy)policy).getStatusDescription();
            } else if (policy != null) {
                sPolicy = policy.toString();
            }
            if (sPolicy != null) {
                sbQuorum.append(sPolicy);
            }
        }
        return ClusterNodeModel.canonicalString(sbQuorum.toString());
    }

    public String getRackName() {
        Member member = (Member)this.get_Member();
        return member == null ? ClusterNodeModel.canonicalString(null) : ClusterNodeModel.canonicalString(member.getRackName());
    }

    public float getReceiverPacketUtilization() {
        SafeCluster clusterSafe = this.get_Cluster();
        if (clusterSafe != null && clusterSafe.isRunning()) {
            Cluster.SocketManager manager = clusterSafe.getCluster().getSocketManager();
            Cluster.SocketManager.UnicastUdpSocket socket = manager.getUnicastUdpSocket();
            Cluster.SocketManager.PreferredUnicastUdpSocket socketPref = manager.getPreferredUnicastUdpSocket();
            Cluster.SocketManager.BroadcastUdpSocket socketBroad = manager.getBroadcastUdpSocket();
            long cPackets = socketPref.getCountReceived() + socket.getCountReceived() + socketBroad.getCountReceived();
            long cBytes = socketPref.getBytesReceived() + socket.getBytesReceived() + socketBroad.getBytesReceived();
            if (cPackets == 0L) {
                return 1.0f;
            }
            return (float)((double)cBytes / (double)cPackets / (double)socketPref.getPacketLength());
        }
        return 0.0f;
    }

    public float getReceiverSuccessRate() {
        PacketReceiver receiver = this.get_Receiver();
        if (receiver == null) {
            return 0.0f;
        }
        long lReceived = receiver.getStatsReceived();
        long lRepeated = receiver.getStatsRepeated();
        return lReceived == 0L ? 1.0f : (float)(1.0 - (double)lRepeated / (double)lReceived);
    }

    public int getResendDelay() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getResendDelay();
    }

    public String getRoleName() {
        Member member = (Member)this.get_Member();
        return member == null ? ClusterNodeModel.canonicalString(null) : ClusterNodeModel.canonicalString(member.getRoleName());
    }

    public int getSendAckDelay() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getAckDelay();
    }

    public int getSendQueueSize() {
        PacketPublisher publisher = this.get_Publisher();
        if (publisher == null) {
            return -1;
        }
        int iSize = ((PacketPublisher.InQueue)publisher.getQueue()).getPacketAdapter().size() + publisher.getResendQueue().size();
        Queue queueDeferred = publisher.getDeferredReadyQueue();
        if (queueDeferred != null) {
            iSize += queueDeferred.size();
        }
        return iSize;
    }

    public String getSiteName() {
        Member member = (Member)this.get_Member();
        return member == null ? ClusterNodeModel.canonicalString(null) : ClusterNodeModel.canonicalString(member.getSiteName());
    }

    public int getSocketCount() {
        Member member = (Member)this.get_Member();
        return member != null ? -1 : member.getSocketCount();
    }

    public String getStatistics() {
        SafeCluster clusterSafe = this.get_Cluster();
        if (clusterSafe != null && clusterSafe.isRunning()) {
            return clusterSafe.getCluster().formatStats();
        }
        return "n/a";
    }

    public long getTcpRingFailures() {
        TcpRing ring = this.get_TcpRing();
        return ring != null ? ring.getStatsFailures() : -1L;
    }

    public Date getTimestamp() {
        Member member = (Member)this.get_Member();
        return member == null ? new Date(0L) : new Date(member.getTimestamp());
    }

    public float getTracingSamplingRatio() {
        TracingShim.Control control;
        SafeCluster clusterSafe = this.get_Cluster();
        if (clusterSafe != null && clusterSafe.isRunning() && (control = clusterSafe.getCluster().getTracingControl()) != null) {
            return control.getDependencies().getSamplingRatio();
        }
        return -1.0f;
    }

    public int getTrafficJamCount() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getCloggedCount();
    }

    public int getTrafficJamDelay() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? -1 : publisher.getCloggedDelay();
    }

    public long getTransportBacklogDelay() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1L : handler.getStatsDrainOverflowDuration().longValue();
    }

    public long getTransportReceivedBytes() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1L : handler.getStatsBusBytesIn();
    }

    public long getTransportReceivedMessages() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1L : handler.getStatsBusReceives();
    }

    public long getTransportRetainedBytes() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1L : handler.getStatsBusBytesOutBuffered().get();
    }

    public long getTransportSentBytes() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1L : handler.getStatsBusBytesOut();
    }

    public long getTransportSentMessages() {
        MessageHandler handler = this.get_MessageHandler();
        return handler == null ? -1L : handler.getStatsBusSends();
    }

    public String getTransportStatus() {
        return this.getTransportStatus(false);
    }

    public String getTransportStatus(boolean fVerbose) {
        String sStats;
        int nPort;
        MessageHandler handler = this.get_MessageHandler();
        if (handler != null) {
            MessageBus messageBus = handler.getMessageBus();
            return messageBus instanceof AbstractSocketBus ? ((AbstractSocketBus)((Object)messageBus)).toString(fVerbose) : messageBus.toString();
        }
        StringBuilder sb = new StringBuilder("Datagram(");
        String sAddress = this.getUnicastAddress();
        if (!"n/a".equals(sAddress)) {
            sb.append('/').append(sAddress);
        }
        if ((nPort = this.getUnicastPort()) != -1) {
            sb.append(':').append(nPort);
        }
        if (!"n/a".equals(sStats = this.getStatistics())) {
            if (sb.length() > 9) {
                sb.append(',');
            }
            sb.append(sStats);
        }
        sb.append(')');
        return sb.toString();
    }

    public String getUID() {
        Member member = (Member)this.get_Member();
        return member == null ? "n/a" : member.getUid().toString();
    }

    public String getUnicastAddress() {
        Member member = (Member)this.get_Member();
        return member == null ? "n/a" : String.valueOf(member.getAddress());
    }

    public int getUnicastPort() {
        Member member = (Member)this.get_Member();
        return member == null ? -1 : member.getPort();
    }

    public int getWeakestChannel() {
        Member memberWorst;
        PacketPublisher publisher = this.get_Publisher();
        if (publisher != null && (memberWorst = Member.findWeakestMember(publisher.getMemberSet())) != null) {
            return memberWorst.getId();
        }
        return -1;
    }

    public String[] getWellKnownAddresses() {
        Set setWka;
        SafeCluster clusterSafe = this.get_Cluster();
        if (clusterSafe == null) {
            return new String[0];
        }
        Set set = setWka = clusterSafe.isRunning() ? clusterSafe.getCluster().getClusterService().getWellKnownAddresses() : null;
        if (setWka == null) {
            return new String[0];
        }
        if (setWka instanceof DescribableAddressProvider) {
            return ((DescribableAddressProvider)((Object)setWka)).getAddressDescriptions();
        }
        return InetAddressHelper.getAddressDescriptions(setWka);
    }

    public boolean isFlowControlEnabled() {
        return Member.FlowControl.isEnabled();
    }

    public boolean isMulticastEnabled() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? false : publisher.isMulticastEnabled();
    }

    public boolean isNackEnabled() {
        PacketPublisher publisher = this.get_Publisher();
        return publisher == null ? false : publisher.isNackEnabled();
    }

    public void logNodeState() {
        this.checkReadOnly("logNodeState");
        ClusterNodeModel._trace(this.createNodeState(), 1);
    }

    public String getNodeDescription() {
        Member member = (Member)this.get_Member();
        return member == null ? "n/a" : member.toString(1);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("BufferPublishSize", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("BufferReceiveSize", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("CpuCount", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("FlowControlEnabled", in.readBoolean());
        mapSnapshot.put("GuardRecoverCount", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("GuardTerminateCount", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("Id", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("LoggingDestination", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("LoggingFormat", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("LoggingLevel", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("LoggingLimit", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MachineId", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MachineName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("MemberName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("MemoryAvailableMB", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MemoryMaxMB", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MulticastAddress", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("MulticastEnabled", in.readBoolean());
        mapSnapshot.put("MulticastPort", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MulticastThreshold", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MulticastTTL", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("NackEnabled", in.readBoolean());
        mapSnapshot.put("NackSent", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketDeliveryEfficiency", Float.valueOf(in.readFloat()));
        mapSnapshot.put("PacketsBundled", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsReceived", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsRepeated", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsResent", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsResentEarly", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsResentExcess", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("PacketsSent", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("Priority", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("ProcessName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("ProductEdition", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("PublisherPacketUtilization", Float.valueOf(in.readFloat()));
        mapSnapshot.put("PublisherSuccessRate", Float.valueOf(in.readFloat()));
        mapSnapshot.put("QuorumStatus", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("RackName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("ReceiverPacketUtilization", Float.valueOf(in.readFloat()));
        mapSnapshot.put("ReceiverSuccessRate", Float.valueOf(in.readFloat()));
        mapSnapshot.put("ResendDelay", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("RoleName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("SendAckDelay", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("SendQueueSize", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("SiteName", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("SocketCount", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("Statistics", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("TcpRingFailures", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("Timestamp", new Date(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TrafficJamCount", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("TrafficJamDelay", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("UID", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("UnicastAddress", ExternalizableHelper.readSafeUTF(in));
        mapSnapshot.put("UnicastPort", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("WellKnownAddresses", ExternalizableHelper.readStringArray(in));
        mapSnapshot.put("WeakestChannel", Base.makeInteger(ExternalizableHelper.readInt(in)));
        if (ExternalizableHelper.isVersionCompatible(in, 12, 2, 1, 4, 0)) {
            mapSnapshot.put("TransportReceivedBytes", ExternalizableHelper.readLong(in));
            mapSnapshot.put("TransportReceivedMessages", ExternalizableHelper.readLong(in));
            mapSnapshot.put("TransportRetainedBytes", ExternalizableHelper.readLong(in));
            mapSnapshot.put("TransportSentBytes", ExternalizableHelper.readLong(in));
            mapSnapshot.put("TransportSentMessages", ExternalizableHelper.readLong(in));
            mapSnapshot.put("TransportStatus", ExternalizableHelper.readSafeUTF(in));
            mapSnapshot.put("TransportBacklogDelay", ExternalizableHelper.readLong(in));
        }
        if (ExternalizableHelper.isVersionCompatible(in, 14, 1, 1, 0, 0)) {
            mapSnapshot.put("TracingSamplingRatio", Float.valueOf(ExternalizableHelper.readBigDecimal(in).floatValue()));
        }
    }

    public String reportEnvironment() {
        this.checkReadOnly("logEnvironment");
        String sJavaVersion = System.getProperty("java.version");
        String sVendorName = System.getProperty("java.vendor");
        String sVendorVersion = System.getProperty("java.vendor.version");
        String sVmName = System.getProperty("java.vm.name");
        String sVmVendor = System.getProperty("java.vm.vendor");
        String sVmVersion = System.getProperty("java.vm.version");
        String sRtName = System.getProperty("java.runtime.name");
        String sRtVersion = System.getProperty("java.runtime.version");
        StringBuilder sb = new StringBuilder();
        sb.append("Java Version: " + sJavaVersion).append('\n').append("Java Vendor:").append('\n').append(" - Name: " + sVendorName).append('\n').append(" - Version: " + sVendorVersion).append('\n').append("Java Virtual Machine:").append('\n').append(" - Name: " + sVmName).append('\n').append(" - Vendor: " + sVmVendor).append('\n').append(" - Version: " + sVmVersion).append('\n').append("Java Runtime Environment:").append('\n').append(" - Name: " + sRtName).append('\n').append(" - Version: " + sRtVersion).append('\n');
        Properties properties = System.getProperties();
        Set<String> keys = properties.stringPropertyNames();
        TreeSet<String> sortedKeys = new TreeSet<String>(keys);
        Iterator iterator = sortedKeys.iterator();
        sb.append('\n').append(sortedKeys.size() + " System Properties:\n");
        while (iterator.hasNext()) {
            String sKey = (String)iterator.next();
            sb.append(sKey + " : " + System.getProperty(sKey) + "\n");
        }
        return sb.toString();
    }

    public String reportNodeState() {
        this.checkReadOnly("reportNodeState");
        return this.createNodeState();
    }

    public void resetStatistics() {
        SafeCluster clusterSafe = this.get_Cluster();
        if (clusterSafe != null && clusterSafe.isRunning()) {
            clusterSafe.getCluster().resetStats();
        }
    }

    public void set_Cluster(SafeCluster cluster) {
        this.set_ClusterRef(new WeakReference<SafeCluster>(cluster));
    }

    protected void set_ClusterRef(WeakReference refCluster) {
        this.__m__ClusterRef = refCluster;
    }

    public void set_Member(com.tangosol.net.Member member) {
        this.set_MemberRef(new WeakReference<com.tangosol.net.Member>(member));
    }

    protected void set_MemberRef(WeakReference refMember) {
        this.__m__MemberRef = refMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferPublishSize(int cPackets) {
        this.checkReadOnly("setBufferPublishSize");
        PacketPublisher publisher = this.get_Publisher();
        if (publisher != null && cPackets != this.getBufferPublishSize()) {
            this.checkRange("BufferPublishSize", cPackets, 1, Integer.MAX_VALUE);
            try {
                UnicastUdpSocket socket = publisher.getUdpSocketUnicast();
                Object object = socket.getLock();
                synchronized (object) {
                    socket.close();
                    socket.setBufferSentBytes(cPackets * publisher.getPreferredPacketLength());
                    socket.open();
                }
            }
            catch (Exception e) {
                ClusterNodeModel._trace("Buffer resizing failed; stopping cluster service", 1);
                this.get_Cluster().stop();
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferReceiveSize(int cPackets) {
        this.checkReadOnly("setBufferReceiveSize");
        PacketListener listener = this.get_ListenerPreferred();
        if (listener != null && cPackets != this.getBufferReceiveSize()) {
            this.checkRange("BufferReceiveSize", cPackets, 1, Integer.MAX_VALUE);
            try {
                UdpSocket socket = listener.getUdpSocket();
                Object object = socket.getLock();
                synchronized (object) {
                    socket.close();
                    socket.setBufferReceivedBytes(cPackets * listener.getPacketLength());
                    socket.open();
                }
            }
            catch (Exception e) {
                ClusterNodeModel._trace("Buffer resizing failed; stopping cluster service", 1);
                this.get_Cluster().stop();
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    public void setLoggingFormat(String sFormat) {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence.Logger logger = singleton.getLogger();
        if (logger != null && !Base.equals(sFormat, this.getLoggingFormat())) {
            this.checkReadOnly("setLoggerFormat");
            logger.setFormat(sFormat);
        }
    }

    public void setLoggingLevel(int nLevel) {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence.Logger logger = singleton.getLogger();
        if (logger != null && nLevel != this.getLoggingLevel()) {
            this.checkRange("setLoggerLevel", nLevel, -1, Integer.MAX_VALUE);
            logger.setLevel(nLevel);
        }
    }

    public void setLoggingLimit(int cChars) {
        Coherence singleton = (Coherence)Coherence.get_Instance();
        Coherence.Logger logger = singleton.getLogger();
        if (logger != null && cChars != this.getLoggingLimit()) {
            this.checkRange("setLoggerLimit", cChars, 0, Integer.MAX_VALUE);
            logger.setLimit(cChars);
        }
    }

    public void setMulticastThreshold(int nThreshold) {
        this.checkReadOnly("setMulticastThreshold");
        PacketPublisher publisher = this.get_Publisher();
        if (publisher != null && nThreshold != this.getMulticastThreshold()) {
            this.checkRange("setMulticastThreshold", nThreshold, 0, 100);
            publisher.setMulticastThreshold(0.01 * (double)nThreshold);
        }
    }

    public void setResendDelay(int cMillis) {
        this.checkReadOnly("setResendDelay");
        PacketPublisher publisher = this.get_Publisher();
        if (publisher != null && cMillis != this.getResendDelay()) {
            this.checkRange("setResendDelay", cMillis, 10, 1000);
            publisher.setResendDelay(cMillis);
        }
    }

    public void setSendAckDelay(int cMillis) {
        this.checkReadOnly("setSendAckDelay");
        PacketPublisher publisher = this.get_Publisher();
        if (publisher != null && cMillis != this.getSendAckDelay()) {
            this.checkRange("setSendAckDelay", cMillis, 1, 100);
            publisher.setAckDelay(cMillis);
        }
    }

    public void setTracingSamplingRatio(float nRatio) {
        SafeCluster clusterSafe = this.get_Cluster();
        if (clusterSafe != null && clusterSafe.isRunning()) {
            TracingShim.Control control = clusterSafe.getCluster().getTracingControl();
            TracingShim.DefaultDependencies deps = new TracingShim.DefaultDependencies(control == null ? null : control.getDependencies()).setSamplingRatio(nRatio);
            if (!clusterSafe.getCluster().configureTracing(deps)) {
                throw new UnsupportedOperationException("initialization failed; tracing is already enabled by an external source");
            }
        }
    }

    public void setTrafficJamCount(int cPackets) {
        this.checkReadOnly("setTrafficJamCount");
        PacketPublisher publisher = this.get_Publisher();
        if (publisher != null && cPackets != this.getTrafficJamCount()) {
            this.checkReadOnly("setTrafficJamCount");
            publisher.setCloggedCount(cPackets);
        }
    }

    public void setTrafficJamDelay(int cMillis) {
        this.checkReadOnly("setTrafficJamDelay");
        PacketPublisher publisher = this.get_Publisher();
        if (publisher != null && cMillis != this.getTrafficJamDelay()) {
            this.checkReadOnly("setTrafficJamDelay");
            publisher.setCloggedDelay(cMillis);
        }
    }

    public String showTransportStatus() {
        return this.getTransportStatus(true);
    }

    public void shutdown() {
        this.checkReadOnly("shutdown");
        SafeCluster clusterSafe = this.get_Cluster();
        if (clusterSafe != null) {
            clusterSafe.shutdown();
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableHelper.writeInt(out, this.getBufferPublishSize());
        ExternalizableHelper.writeInt(out, this.getBufferReceiveSize());
        ExternalizableHelper.writeInt(out, this.getCpuCount());
        out.writeBoolean(this.isFlowControlEnabled());
        ExternalizableHelper.writeInt(out, this.getGuardRecoverCount());
        ExternalizableHelper.writeInt(out, this.getGuardTerminateCount());
        ExternalizableHelper.writeInt(out, this.getId());
        ExternalizableHelper.writeSafeUTF(out, this.getLoggingDestination());
        ExternalizableHelper.writeSafeUTF(out, this.getLoggingFormat());
        ExternalizableHelper.writeInt(out, this.getLoggingLevel());
        ExternalizableHelper.writeInt(out, this.getLoggingLimit());
        ExternalizableHelper.writeInt(out, this.getMachineId());
        ExternalizableHelper.writeSafeUTF(out, this.getMachineName());
        ExternalizableHelper.writeSafeUTF(out, this.getMemberName());
        ExternalizableHelper.writeInt(out, this.getMemoryAvailableMB());
        ExternalizableHelper.writeInt(out, this.getMemoryMaxMB());
        ExternalizableHelper.writeSafeUTF(out, this.getMulticastAddress());
        out.writeBoolean(this.isMulticastEnabled());
        ExternalizableHelper.writeInt(out, this.getMulticastPort());
        ExternalizableHelper.writeInt(out, this.getMulticastThreshold());
        ExternalizableHelper.writeInt(out, this.getMulticastTTL());
        out.writeBoolean(this.isNackEnabled());
        ExternalizableHelper.writeLong(out, this.getNackSent());
        out.writeFloat(this.getPacketDeliveryEfficiency());
        ExternalizableHelper.writeLong(out, this.getPacketsBundled());
        ExternalizableHelper.writeLong(out, this.getPacketsReceived());
        ExternalizableHelper.writeLong(out, this.getPacketsRepeated());
        ExternalizableHelper.writeLong(out, this.getPacketsResent());
        ExternalizableHelper.writeLong(out, this.getPacketsResentEarly());
        ExternalizableHelper.writeLong(out, this.getPacketsResentExcess());
        ExternalizableHelper.writeLong(out, this.getPacketsSent());
        ExternalizableHelper.writeInt(out, this.getPriority());
        ExternalizableHelper.writeSafeUTF(out, this.getProcessName());
        ExternalizableHelper.writeSafeUTF(out, this.getProductEdition());
        out.writeFloat(this.getPublisherPacketUtilization());
        out.writeFloat(this.getPublisherSuccessRate());
        ExternalizableHelper.writeSafeUTF(out, this.getQuorumStatus());
        ExternalizableHelper.writeSafeUTF(out, this.getRackName());
        out.writeFloat(this.getReceiverPacketUtilization());
        out.writeFloat(this.getReceiverSuccessRate());
        ExternalizableHelper.writeInt(out, this.getResendDelay());
        ExternalizableHelper.writeSafeUTF(out, this.getRoleName());
        ExternalizableHelper.writeInt(out, this.getSendAckDelay());
        ExternalizableHelper.writeInt(out, this.getSendQueueSize());
        ExternalizableHelper.writeSafeUTF(out, this.getSiteName());
        ExternalizableHelper.writeInt(out, this.getSocketCount());
        ExternalizableHelper.writeSafeUTF(out, this.getStatistics());
        ExternalizableHelper.writeLong(out, this.getTcpRingFailures());
        ExternalizableHelper.writeLong(out, this.getTimestamp().getTime());
        ExternalizableHelper.writeInt(out, this.getTrafficJamCount());
        ExternalizableHelper.writeInt(out, this.getTrafficJamDelay());
        ExternalizableHelper.writeSafeUTF(out, this.getUID());
        ExternalizableHelper.writeSafeUTF(out, this.getUnicastAddress());
        ExternalizableHelper.writeInt(out, this.getUnicastPort());
        ExternalizableHelper.writeStringArray(out, this.getWellKnownAddresses());
        ExternalizableHelper.writeInt(out, this.getWeakestChannel());
        if (ExternalizableHelper.isVersionCompatible(out, 12, 2, 1, 4, 0)) {
            ExternalizableHelper.writeLong(out, this.getTransportReceivedBytes());
            ExternalizableHelper.writeLong(out, this.getTransportReceivedMessages());
            ExternalizableHelper.writeLong(out, this.getTransportRetainedBytes());
            ExternalizableHelper.writeLong(out, this.getTransportSentBytes());
            ExternalizableHelper.writeLong(out, this.getTransportSentMessages());
            ExternalizableHelper.writeSafeUTF(out, this.getTransportStatus());
            ExternalizableHelper.writeLong(out, this.getTransportBacklogDelay());
        }
        if (ExternalizableHelper.isVersionCompatible(out, 14, 1, 1, 0, 0)) {
            ExternalizableHelper.writeBigDecimal(out, BigDecimal.valueOf(this.getTracingSamplingRatio()));
        }
    }
}

