/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ClusterModel
extends LocalModel {
    private transient SafeCluster __m__Cluster;
    private transient WeakReference __m__ClusterRef;

    public ClusterModel() {
        this(null, null, true);
    }

    public ClusterModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new ClusterModel();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/model/localModel/ClusterModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public void configureTracing(String sRole, Float fRatio) {
        this.checkReadOnly("configureTracing");
        if (fRatio == null) {
            throw new IllegalArgumentException("fRatio cannot be null");
        }
        float fRatioPrim = fRatio.floatValue();
        fRatio = Float.valueOf(fRatioPrim < 0.0f ? -1.0f : Math.min(fRatioPrim, 1.0f));
        SafeCluster cluster = this.get_Cluster();
        if (cluster == null) {
            return;
        }
        MBeanServer server = MBeanHelper.findMBeanServer();
        Gateway gateway = (Gateway)cluster.getManagement();
        boolean fAllMembers = sRole == null || sRole.isEmpty();
        String sNodePrefix = gateway.getDomainName() + ":type=Node";
        for (com.tangosol.net.Member member : cluster.getMemberSet()) {
            if (!fAllMembers && !Objects.equals(member.getRoleName(), sRole)) continue;
            try {
                String sNode = gateway.ensureGlobalName(sNodePrefix, member);
                server.setAttribute(new ObjectName(sNode), new Attribute("TracingSamplingRatio", fRatio));
            }
            catch (Exception exception) {}
        }
    }

    public void dumpClusterHeap(String sRole) {
        this.checkReadOnly("dumpClusterHeap");
        SafeCluster cluster = this.get_Cluster();
        if (cluster == null) {
            return;
        }
        MBeanServer server = MBeanHelper.findMBeanServer();
        Gateway gateway = (Gateway)cluster.getManagement();
        boolean fAllMembers = sRole == null || sRole.isEmpty();
        String sNodePrefix = gateway.getDomainName() + ":type=Node";
        for (com.tangosol.net.Member member : cluster.getMemberSet()) {
            if (!fAllMembers && !Objects.equals(member.getRoleName(), sRole)) continue;
            try {
                String sNode = gateway.ensureGlobalName(sNodePrefix, member);
                String sFileName = (String)server.invoke(new ObjectName(sNode), "dumpHeap", new Object[]{null}, null);
                ClusterModel._trace("Heapdump is created for Node" + member.getId() + " in " + sFileName, 2);
            }
            catch (Exception exception) {}
        }
    }

    public String ensureGlobalFileName(String sOptions, int nMemberId) {
        String FILE_OPTION = "filename";
        String NAME_OPTION = "name";
        int iFilename = sOptions.indexOf("filename");
        while (iFilename >= 0) {
            char chFilePre = sOptions.charAt(Math.max(iFilename - 1, 0));
            char chFilePost = sOptions.charAt(iFilename + "filename".length());
            if (chFilePre == ' ' || chFilePre == ',' || chFilePost == ' ' || chFilePost == '=') {
                int iValueEnd;
                int iValueStart = iFilename + "filename".length();
                while (sOptions.charAt(iValueStart) == ' ' || sOptions.charAt(iValueStart) == '=') {
                    ++iValueStart;
                }
                for (iValueEnd = iValueStart + 1; iValueEnd < sOptions.length() && sOptions.charAt(iValueEnd) != ','; ++iValueEnd) {
                }
                String sFileName = sOptions.substring(iValueStart, iValueEnd);
                int iFileName = sFileName.lastIndexOf(File.separator);
                if (iFileName > 0) {
                    sFileName = sFileName.substring(iFileName + 1);
                }
                int iFileExt = sFileName.length() > 0 ? sFileName.lastIndexOf(".") : -1;
                String sName = "";
                if (iFileExt < 0 || sFileName.length() - iFileExt > 4) {
                    int iBegin = sOptions.indexOf("name");
                    while (iBegin >= 0) {
                        char chNamePre = sOptions.charAt(Math.max(iBegin - 1, 0));
                        char chNamePost = sOptions.charAt(iBegin + "name".length());
                        if (!(iBegin != 0 && chNamePre != ' ' && chNamePre != ',' || chNamePost != ' ' && chNamePost != '=')) {
                            int iEnd;
                            for (iEnd = (iBegin += "name".length()) + 1; iEnd < sOptions.length() && sOptions.charAt(iEnd) != ','; ++iEnd) {
                            }
                            sName = sOptions.substring(iBegin + 1, iEnd);
                            break;
                        }
                        iBegin = sOptions.indexOf("name", iBegin + "name".length());
                    }
                    return sFileName.length() == 0 ? sOptions.substring(0, iValueEnd) + nMemberId + "-" + sName + ".jfr" + sOptions.substring(iValueEnd) : sOptions.substring(0, iValueEnd) + File.separator + nMemberId + "-" + sName + ".jfr" + sOptions.substring(iValueEnd);
                }
                iFileName = sOptions.lastIndexOf(File.separator) + 1;
                if (iFileName > 0) {
                    iValueStart = iFileName;
                }
                return sOptions.substring(0, iValueStart) + nMemberId + "-" + sOptions.substring(iValueStart);
            }
            iFilename = sOptions.indexOf("filename", iFilename + "filename".length());
        }
        return sOptions;
    }

    public void ensureRunning() {
        this.checkReadOnly("ensureRunning");
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null && !cluster.isRunning()) {
            cluster.start();
        }
    }

    public String[] flightRecording(String sRole, String sCmd, String sOptions) {
        this.checkReadOnly("clusterJfr");
        SafeCluster cluster = this.get_Cluster();
        if (cluster == null) {
            return null;
        }
        MBeanServer server = MBeanHelper.findMBeanServer();
        Gateway gateway = (Gateway)cluster.getManagement();
        boolean fAllMembers = sRole == null || sRole.isEmpty();
        String[] sResults = new String[cluster.getMemberSet().size()];
        String sDiagPrefix = gateway.getDomainName() + ":type=DiagnosticCommand,Domain=com.sun.management,subType=DiagnosticCommand";
        int i = 0;
        ArrayList<ObjectName> listMBeanNames = new ArrayList<ObjectName>(cluster.getMemberSet().size());
        for (com.tangosol.net.Member member : cluster.getMemberSet()) {
            if (!fAllMembers && !Objects.equals(member.getRoleName(), sRole)) continue;
            try {
                ObjectName oName = new ObjectName(gateway.ensureGlobalName(sDiagPrefix, member));
                listMBeanNames.add(oName);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, "Unable to unlock commercial features for member " + member.getId() + " due to: " + e.getMessage());
            }
        }
        for (ObjectName oName : listMBeanNames) {
            int nMemberId = Integer.parseInt(oName.getKeyProperty("nodeId"));
            Object sMember = oName.getKeyProperty("member");
            if (sMember == null) {
                sMember = "Member " + nMemberId;
            }
            try {
                String sNodeOptions = sOptions;
                if (sOptions.indexOf("filename=") >= 0) {
                    sNodeOptions = this.ensureGlobalFileName(sOptions, nMemberId);
                }
                String[] aoArguments = sNodeOptions.split(",");
                String sMessage = (String)server.invoke(oName, sCmd, new Object[]{aoArguments}, new String[]{String[].class.getName()});
                sResults[i++] = (String)sMember + "->" + sMessage;
            }
            catch (Exception ignore) {
                String sMessage = "Flight Recorder operation for node " + nMemberId + ", got exception: " + ignore.getMessage();
                sResults[i++] = (String)sMember + "->" + sMessage + "\n";
                ClusterModel._trace(sMessage, 2);
            }
        }
        return sResults;
    }

    public SafeCluster get_Cluster() {
        WeakReference wr = this.get_ClusterRef();
        return wr == null ? null : (SafeCluster)wr.get();
    }

    protected WeakReference get_ClusterRef() {
        return this.__m__ClusterRef;
    }

    public String getClusterConfig() {
        return CacheFactory.getClusterConfig().toString() + "\n" + CacheFactory.getLoggingConfig().toString() + "\n" + CacheFactory.getManagementConfig().toString();
    }

    public String getClusterDescription() {
        SafeCluster cluster = this.get_Cluster();
        return cluster == null ? ClusterModel.canonicalString(null) : ((Object)cluster).toString();
    }

    public String getClusterName() {
        SafeCluster cluster = this.get_Cluster();
        return cluster == null ? ClusterModel.canonicalString(null) : ClusterModel.canonicalString(cluster.getClusterName());
    }

    public int getClusterSize() {
        SafeCluster cluster = this.get_Cluster();
        return cluster != null && cluster.isRunning() ? cluster.getMemberSet().size() : 0;
    }

    @Override
    public String getDescription() {
        SafeCluster cluster = this.get_Cluster();
        return cluster != null && cluster.isRunning() ? "MemberId=" + cluster.getLocalMember().getId() : "Not running";
    }

    public String getLicenseMode() {
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null && cluster.isRunning()) {
            Member member = (Member)cluster.getLocalMember();
            return Member.MODE_NAME[member.getMode()];
        }
        return ClusterModel.canonicalString(null);
    }

    public int getLocalMemberId() {
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null && cluster.isRunning()) {
            return cluster.getLocalMember().getId();
        }
        return -1;
    }

    public int[] getMemberIds() {
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null && cluster.isRunning()) {
            Set<com.tangosol.net.Member> setMember = cluster.getMemberSet();
            int[] anMember = new int[setMember.size()];
            Iterator<com.tangosol.net.Member> iter = setMember.iterator();
            for (int i = 0; iter.hasNext() && i < anMember.length; ++i) {
                anMember[i] = iter.next().getId();
            }
            return anMember;
        }
        return new int[0];
    }

    public String[] getMembers() {
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null && cluster.isRunning()) {
            Set<com.tangosol.net.Member> setMember = cluster.getMemberSet();
            String[] asMember = new String[setMember.size()];
            Iterator<com.tangosol.net.Member> iter = setMember.iterator();
            for (int i = 0; iter.hasNext() && i < asMember.length; ++i) {
                asMember[i] = iter.next().toString();
            }
            return asMember;
        }
        return new String[0];
    }

    public String[] getMembersDeparted() {
        try {
            Cluster clusterReal = this.get_Cluster().getCluster();
            HashSet setMembers = new HashSet(clusterReal.getClusterService().getClusterMemberSet().getRecycleSet());
            String[] asMembers = new String[setMembers.size()];
            Iterator iter = setMembers.iterator();
            int i = 0;
            while (iter.hasNext()) {
                asMembers[i] = String.valueOf(iter.next());
                ++i;
            }
            return asMembers;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public long getMembersDepartureCount() {
        try {
            Cluster clusterReal = this.get_Cluster().getCluster();
            return clusterReal.getClusterService().getStatsMembersDepartureCount();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public int getOldestMemberId() {
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null && cluster.isRunning()) {
            return cluster.getOldestMember().getId();
        }
        return -1;
    }

    public String getVersion() {
        return CacheFactory.VERSION;
    }

    public boolean isRunning() {
        SafeCluster cluster = this.get_Cluster();
        return cluster != null && cluster.isRunning();
    }

    public void logClusterState(String sRole) {
        this.checkReadOnly("logClusterState");
        SafeCluster cluster = this.get_Cluster();
        if (cluster == null) {
            return;
        }
        MBeanServer server = MBeanHelper.findMBeanServer();
        Gateway gateway = (Gateway)cluster.getManagement();
        boolean fAllMembers = sRole == null || sRole.isEmpty();
        String sNodePrefix = gateway.getDomainName() + ":type=Node";
        for (com.tangosol.net.Member member : cluster.getMemberSet()) {
            if (!fAllMembers && !member.getRoleName().equals(sRole)) continue;
            try {
                String sNode = gateway.ensureGlobalName(sNodePrefix, member);
                server.invoke(new ObjectName(sNode), "logNodeState", null, null);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        throw new IllegalStateException("ClusterModel is not global");
    }

    public void resumeService(String sService) {
        this.checkReadOnly("resumeService");
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null) {
            cluster.resumeService(sService);
        }
    }

    public void set_Cluster(SafeCluster cluster) {
        this.set_ClusterRef(new WeakReference<SafeCluster>(cluster));
    }

    protected void set_ClusterRef(WeakReference refCluster) {
        this.__m__ClusterRef = refCluster;
    }

    public void shutdown() {
        this.checkReadOnly("shutdown");
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    public void suspendService(String sService) {
        this.checkReadOnly("suspendService");
        SafeCluster cluster = this.get_Cluster();
        if (cluster != null) {
            cluster.suspendService(sService);
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        throw new IllegalStateException("ClusterModel is not global");
    }
}

