/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.CachingMap;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.NearCache;
import com.tangosol.net.cache.OverflowMap;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.net.cache.SimpleMemoryCalculator;
import com.tangosol.net.cache.SimpleOverflowMap;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class CacheModel
extends LocalModel {
    private transient WeakReference __m__BackingMapRef;
    private transient WeakReference __m__ConfigurableCacheRef;
    private transient Map __m__Map;
    private transient WeakReference __m__MapRef;
    private transient CacheStatistics __m__Stats;
    private double __m_BatchFactor;
    private int __m_ExpiryDelay;
    private int __m_HighUnits;
    private int __m_LowUnits;
    private int __m_QueueDelay;
    private double __m_RefreshFactor;
    private int __m_RequeueThreshold;

    public CacheModel() {
        this(null, null, true);
    }

    public CacheModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new CacheModel();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/model/localModel/CacheModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public double getAverageGetMillis() {
        return this.get_Stats().getAverageGetMillis();
    }

    public double getAverageHitMillis() {
        return this.get_Stats().getAverageHitMillis();
    }

    public double getAverageMissMillis() {
        return this.get_Stats().getAverageMissMillis();
    }

    public double getAveragePutMillis() {
        return this.get_Stats().getAveragePutMillis();
    }

    public long getCacheHits() {
        return this.get_Stats().getCacheHits();
    }

    public long getCacheHitsMillis() {
        return this.get_Stats().getCacheHitsMillis();
    }

    public long getCacheMisses() {
        return this.get_Stats().getCacheMisses();
    }

    public long getCacheMissesMillis() {
        return this.get_Stats().getCacheMissesMillis();
    }

    private long getCachePrunes$Router() {
        return this.get_Stats().getCachePrunes();
    }

    public long getCachePrunes() {
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        Map map = this.get_Map();
        return (map instanceof CachingMap || map instanceof OverflowMap || map instanceof SimpleOverflowMap) && cache instanceof LocalCache ? ((LocalCache)cache).getCacheStatistics().getCachePrunes() : this.getCachePrunes$Router();
    }

    private long getCachePrunesMillis$Router() {
        return this.get_Stats().getCachePrunesMillis();
    }

    public long getCachePrunesMillis() {
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        Map map = this.get_Map();
        return (map instanceof CachingMap || map instanceof OverflowMap || map instanceof SimpleOverflowMap) && cache instanceof LocalCache ? ((LocalCache)cache).getCacheStatistics().getCachePrunesMillis() : this.getCachePrunesMillis$Router();
    }

    public double getHitProbability() {
        return this.get_Stats().getHitProbability();
    }

    public long getTotalGets() {
        return this.get_Stats().getTotalGets();
    }

    public long getTotalGetsMillis() {
        return this.get_Stats().getTotalGetsMillis();
    }

    public long getTotalPuts() {
        return this.get_Stats().getTotalPuts();
    }

    public long getTotalPutsMillis() {
        return this.get_Stats().getTotalPutsMillis();
    }

    private void resetStatistics$Router() {
        this.get_Stats().resetHitStatistics();
    }

    public void resetStatistics() {
        this.resetStatistics$Router();
        try {
            this.get_BackingMap().getCacheStore().resetStatistics();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected ReadWriteBackingMap get_BackingMap() {
        WeakReference wr = this.get_BackingMapRef();
        return wr == null ? null : (ReadWriteBackingMap)wr.get();
    }

    protected WeakReference get_BackingMapRef() {
        return this.__m__BackingMapRef;
    }

    protected ConfigurableCacheMap get_ConfigurableCache() {
        WeakReference wr = this.get_ConfigurableCacheRef();
        return wr == null ? null : (ConfigurableCacheMap)wr.get();
    }

    protected WeakReference get_ConfigurableCacheRef() {
        return this.__m__ConfigurableCacheRef;
    }

    public Map get_Map() {
        WeakReference wr = this.get_MapRef();
        return wr == null ? null : (Map)wr.get();
    }

    protected WeakReference get_MapRef() {
        return this.__m__MapRef;
    }

    public CacheStatistics get_Stats() {
        return this.__m__Stats;
    }

    public double getBatchFactor() {
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && map.isWriteBehind()) {
            return map.getWriteBatchFactor();
        }
        return 0.0;
    }

    public String getCacheStoreType() {
        ReadWriteBackingMap map = this.get_BackingMap();
        String sType = "NONE";
        if (map != null && map.getCacheStore() != null) {
            if (map.isReadOnly()) {
                sType = "READ-ONLY";
            } else if (map.isWriteThrough()) {
                sType = "WRITE-THROUGH";
            } else if (map.isWriteBehind()) {
                sType = "WRITE-BEHIND";
            }
        }
        return sType;
    }

    @Override
    public String getDescription() {
        Map map = this.get_Map();
        return map == null ? CacheModel.canonicalString(null) : "Implementation: " + map.getClass().getName();
    }

    public int getExpiryDelay() {
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        return cache == null ? -1 : cache.getExpiryDelay();
    }

    public int getHighUnits() {
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        return cache == null ? -1 : cache.getHighUnits();
    }

    public int getLowUnits() {
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        return cache == null ? -1 : cache.getLowUnits();
    }

    public String getPersistenceType() {
        return this.getCacheStoreType();
    }

    public int getQueueDelay() {
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && map.isWriteBehind()) {
            return map.getWriteBehindSeconds();
        }
        return -1;
    }

    public int getQueueSize() {
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null) {
            return map.getPendingWrites();
        }
        return -1;
    }

    public double getRefreshFactor() {
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && map.isRefreshAhead()) {
            return map.getRefreshAheadFactor();
        }
        return 0.0;
    }

    public int getRequeueThreshold() {
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && map.isWriteBehind()) {
            return map.getWriteRequeueThreshold();
        }
        return 0;
    }

    public int getSize() {
        Map map = this.get_Map();
        if (map instanceof NearCache) {
            map = ((NearCache)map).getFrontMap();
        }
        return map == null ? -1 : map.keySet().size();
    }

    public long getStoreAverageBatchSize() {
        ReadWriteBackingMap.StoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            return store.getAverageBatchSize();
        }
        return -1L;
    }

    public long getStoreAverageReadMillis() {
        ReadWriteBackingMap.StoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            return store.getAverageLoadMillis();
        }
        return -1L;
    }

    public long getStoreAverageWriteMillis() {
        ReadWriteBackingMap.StoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            long cOps = store.getStoreOps() + store.getEraseOps();
            long cMillis = store.getStoreMillis() + store.getEraseMillis();
            return cOps > 0L ? cMillis / cOps : 0L;
        }
        return -1L;
    }

    public long getStoreFailures() {
        ReadWriteBackingMap.StoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            return store.getLoadFailures() + store.getStoreFailures() + store.getEraseFailures();
        }
        return -1L;
    }

    public long getStoreReadMillis() {
        ReadWriteBackingMap.StoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            return store.getLoadMillis();
        }
        return -1L;
    }

    public long getStoreReads() {
        ReadWriteBackingMap.StoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && (store = map.getCacheStore()) != null) {
            return store.getLoadOps();
        }
        return -1L;
    }

    public long getStoreWriteMillis() {
        ReadWriteBackingMap.StoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && !map.isReadOnly() && (store = map.getCacheStore()) != null) {
            return store.getStoreMillis() + store.getEraseMillis();
        }
        return -1L;
    }

    public long getStoreWrites() {
        ReadWriteBackingMap.StoreWrapper store;
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && !map.isReadOnly() && (store = map.getCacheStore()) != null) {
            return store.getStoreOps() + store.getEraseOps();
        }
        return -1L;
    }

    public int getUnitFactor() {
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        return cache == null ? -1 : cache.getUnitFactor();
    }

    public int getUnits() {
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        return cache == null ? -1 : cache.getUnits();
    }

    public long getUnitsBytes() {
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        return cache == null ? -1L : (long)cache.getUnits() * (long)cache.getUnitFactor();
    }

    public boolean isMemoryUnits() {
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        ConfigurableCacheMap.UnitCalculator calc = cache == null ? null : cache.getUnitCalculator();
        return calc instanceof SimpleMemoryCalculator;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("AverageGetMillis", in.readDouble());
        mapSnapshot.put("AverageHitMillis", in.readDouble());
        mapSnapshot.put("AverageMissMillis", in.readDouble());
        mapSnapshot.put("AveragePutMillis", in.readDouble());
        mapSnapshot.put("BatchFactor", in.readDouble());
        mapSnapshot.put("CacheHits", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("CacheHitsMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("CacheMisses", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("CacheMissesMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("CachePrunes", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("CachePrunesMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("CacheStoreType", ExternalizableHelper.readUTF(in));
        mapSnapshot.put("ExpiryDelay", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("HighUnits", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("HitProbability", in.readDouble());
        mapSnapshot.put("LowUnits", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("MemoryUnits", in.readBoolean());
        mapSnapshot.put("PersistenceType", ExternalizableHelper.readUTF(in));
        mapSnapshot.put("QueueDelay", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("QueueSize", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("RefreshFactor", in.readDouble());
        mapSnapshot.put("RequeueThreshold", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("Size", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("StoreAverageBatchSize", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("StoreAverageReadMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("StoreAverageWriteMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("StoreFailures", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("StoreReadMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("StoreReads", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("StoreWriteMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("StoreWrites", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalGets", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalGetsMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalPuts", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalPutsMillis", Base.makeLong(ExternalizableHelper.readLong(in)));
        int nUnitFactor = ExternalizableHelper.readInt(in);
        int cUnits = ExternalizableHelper.readInt(in);
        mapSnapshot.put("UnitFactor", Base.makeInteger(nUnitFactor));
        mapSnapshot.put("Units", Base.makeInteger(cUnits));
        mapSnapshot.put("UnitsBytes", Base.makeLong((long)cUnits * (long)nUnitFactor));
    }

    protected void set_BackingMapRef(WeakReference refMap) {
        this.__m__BackingMapRef = refMap;
    }

    protected void set_ConfigurableCacheRef(WeakReference cache) {
        this.__m__ConfigurableCacheRef = cache;
    }

    public void set_Map(Map map) {
        this.set_MapRef(new WeakReference<Map>(map));
        if (map instanceof ReadWriteBackingMap) {
            this.set_BackingMapRef(new WeakReference<Map>(map));
            map = ((ReadWriteBackingMap)map).getInternalCache();
        }
        CacheStatistics stats = null;
        try {
            stats = (CacheStatistics)ClassHelper.invoke(map, "getCacheStatistics", ClassHelper.VOID);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (stats == null) {
            stats = new SimpleCacheStatistics();
        }
        this.set_Stats(stats);
        if (map instanceof NearCache) {
            map = ((NearCache)map).getFrontMap();
        }
        if (map instanceof OverflowMap) {
            map = ((OverflowMap)map).getFrontMap();
        }
        if (map instanceof ConfigurableCacheMap) {
            this.set_ConfigurableCacheRef(new WeakReference<ObservableMap>(map));
        }
    }

    protected void set_MapRef(WeakReference refMap) {
        this.__m__MapRef = refMap;
    }

    protected void set_Stats(CacheStatistics stats) {
        this.__m__Stats = stats;
    }

    public void setBatchFactor(double dFactor) {
        this.checkReadOnly("setBatchFactor");
        this.checkRange("setBatchFactor", dFactor, 0.0, 1.0);
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && map.isWriteBehind()) {
            map.setWriteBatchFactor(dFactor);
        }
    }

    public void setExpiryDelay(int cMillis) {
        this.checkReadOnly("setExpiryDelay");
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        if (cache != null) {
            this.checkRange("setExpiryDelay", cMillis, 0, Integer.MAX_VALUE);
            cache.setExpiryDelay(cMillis);
        }
    }

    public void setHighUnits(int cUnits) {
        this.checkReadOnly("setHighUnits");
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        if (cache != null) {
            this.checkRange("setHighUnits", cUnits, 0, Integer.MAX_VALUE);
            cache.setHighUnits(cUnits);
        }
    }

    public void setLowUnits(int cUnits) {
        this.checkReadOnly("setLowUnits");
        ConfigurableCacheMap cache = this.get_ConfigurableCache();
        if (cache != null) {
            this.checkRange("setLowUnits", cUnits, 0, Integer.MAX_VALUE);
            cache.setLowUnits(cUnits);
        }
    }

    public void setQueueDelay(int cDelay) {
        this.checkReadOnly("setQueueDelay");
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && map.isWriteBehind()) {
            map.setWriteBehindSeconds(cDelay);
        }
    }

    public void setRefreshFactor(double dFactor) {
        this.checkReadOnly("setRefreshFactor");
        this.checkRange("setRefreshFactor", dFactor, 0.0, 1.0);
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && map.isRefreshAhead()) {
            map.setRefreshAheadFactor(dFactor);
        }
    }

    public void setRequeueThreshold(int cThreshold) {
        this.checkReadOnly("setRequeueThreshold");
        this.checkRange("setRequeueThreshold", cThreshold, 0, Integer.MAX_VALUE);
        ReadWriteBackingMap map = this.get_BackingMap();
        if (map != null && map.isWriteBehind()) {
            map.setWriteRequeueThreshold(cThreshold);
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        out.writeDouble(this.getAverageGetMillis());
        out.writeDouble(this.getAverageHitMillis());
        out.writeDouble(this.getAverageMissMillis());
        out.writeDouble(this.getAveragePutMillis());
        out.writeDouble(this.getBatchFactor());
        ExternalizableHelper.writeLong(out, this.getCacheHits());
        ExternalizableHelper.writeLong(out, this.getCacheHitsMillis());
        ExternalizableHelper.writeLong(out, this.getCacheMisses());
        ExternalizableHelper.writeLong(out, this.getCacheMissesMillis());
        ExternalizableHelper.writeLong(out, this.getCachePrunes());
        ExternalizableHelper.writeLong(out, this.getCachePrunesMillis());
        ExternalizableHelper.writeUTF(out, this.getCacheStoreType());
        ExternalizableHelper.writeInt(out, this.getExpiryDelay());
        ExternalizableHelper.writeInt(out, this.getHighUnits());
        out.writeDouble(this.getHitProbability());
        ExternalizableHelper.writeInt(out, this.getLowUnits());
        out.writeBoolean(this.isMemoryUnits());
        ExternalizableHelper.writeUTF(out, this.getPersistenceType());
        ExternalizableHelper.writeInt(out, this.getQueueDelay());
        ExternalizableHelper.writeInt(out, this.getQueueSize());
        out.writeDouble(this.getRefreshFactor());
        ExternalizableHelper.writeInt(out, this.getRequeueThreshold());
        try {
            ExternalizableHelper.writeInt(out, this.getSize());
        }
        catch (IllegalStateException e) {
            CacheModel._trace("IllegalStateException serializing the cache model. Size equals zero");
            ExternalizableHelper.writeInt(out, 0);
        }
        ExternalizableHelper.writeLong(out, this.getStoreAverageBatchSize());
        ExternalizableHelper.writeLong(out, this.getStoreAverageReadMillis());
        ExternalizableHelper.writeLong(out, this.getStoreAverageWriteMillis());
        ExternalizableHelper.writeLong(out, this.getStoreFailures());
        ExternalizableHelper.writeLong(out, this.getStoreReadMillis());
        ExternalizableHelper.writeLong(out, this.getStoreReads());
        ExternalizableHelper.writeLong(out, this.getStoreWriteMillis());
        ExternalizableHelper.writeLong(out, this.getStoreWrites());
        ExternalizableHelper.writeLong(out, this.getTotalGets());
        ExternalizableHelper.writeLong(out, this.getTotalGetsMillis());
        ExternalizableHelper.writeLong(out, this.getTotalPuts());
        ExternalizableHelper.writeLong(out, this.getTotalPutsMillis());
        ExternalizableHelper.writeInt(out, this.getUnitFactor());
        ExternalizableHelper.writeInt(out, this.getUnits());
    }
}

