/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.management.Connector;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.listenerHolder.RemoteHolder;
import com.tangosol.coherence.component.net.management.notificationHandler.RemoteHandler;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanException;
import javax.management.Notification;

public abstract class LocalModel
extends Model
implements ExternalizableLite {
    private Object __m__InvocationResult;
    private transient boolean __m__ReadOnly;
    private transient long __m__RefreshTimeMillis;
    private transient RemoteHandler __m__RemoteNotificationHandler;
    private AtomicLong __m__Sequence;
    private transient boolean __m__Snapshot;
    private transient Map __m__SnapshotMap;

    public LocalModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/model/LocalModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    public void _addRemoteNotificationListener(RemoteHolder holder, Connector connector) {
        this._ensureRemoteNotificationHandler(connector).subscribe(holder);
    }

    public boolean _checkExpired(long cRefreshMillis) {
        return this.is_Snapshot() && this.get_RefreshTimeMillis() + cRefreshMillis < Base.getSafeTimeMillis();
    }

    public RemoteHandler _ensureRemoteNotificationHandler(Connector connector) {
        RemoteHandler handler = this.get_RemoteNotificationHandler();
        if (handler == null) {
            handler = new RemoteHandler();
            handler.setName(this.get_ModelName());
            handler.setConnector(connector);
            this.set_RemoteNotificationHandler(handler);
        }
        return handler;
    }

    public void _handleNotification(String sType, String sMessage) throws IllegalArgumentException {
        this._handleNotification(new Notification(sType, this.get_ModelName(), this._nextSequence(), System.currentTimeMillis(), sMessage));
    }

    @Override
    public void _handleNotification(Notification notification) {
        if (notification.getSequenceNumber() < 0L) {
            notification.setSequenceNumber(this._nextSequence());
        }
        super._handleNotification(notification);
        RemoteHandler handler = this.get_RemoteNotificationHandler();
        if (handler != null) {
            handler.handleNotification(notification);
        }
    }

    protected long _nextSequence() {
        return this.get_Sequence().incrementAndGet();
    }

    @Override
    public void _removeNotificationListeners() {
        RemoteHandler handler = this.get_RemoteNotificationHandler();
        if (handler != null) {
            handler.unsubscribeAll();
        }
        super._removeNotificationListeners();
    }

    public void _removeRemoteNotificationListener(int nMember, long lHolderId) {
        RemoteHandler handler = this.get_RemoteNotificationHandler();
        if (handler != null) {
            handler.unsubscribe(nMember, lHolderId);
        }
    }

    protected void checkRange(String sOperation, double dValue, double dMin, double dMax) {
        this.checkReadOnly(sOperation);
        if (dValue < dMin || dValue > dMax) {
            throw new IllegalArgumentException("Operation \"" + sOperation + "\" -- value out of range [" + dMin + ", " + dMax + "]: " + dValue);
        }
    }

    protected void checkRange(String sOperation, int nValue, int nMin, int nMax) {
        this.checkReadOnly(sOperation);
        if (nValue < nMin || nValue > nMax) {
            throw new IllegalArgumentException("Operation \"" + sOperation + "\" -- value out of range [" + nMin + ", " + nMax + "]: " + nValue);
        }
    }

    protected void checkReadOnly(String sOperation) {
        if (this.is_ReadOnly()) {
            throw new SecurityException("Operation is not allowed: " + sOperation);
        }
    }

    public Object get_InvocationResult() {
        return this.__m__InvocationResult;
    }

    public long get_RefreshTimeMillis() {
        return this.is_Snapshot() ? this.__m__RefreshTimeMillis : Base.getSafeTimeMillis();
    }

    public RemoteHandler get_RemoteNotificationHandler() {
        return this.__m__RemoteNotificationHandler;
    }

    protected AtomicLong get_Sequence() {
        AtomicLong counter = this.__m__Sequence;
        if (counter == null) {
            counter = new AtomicLong();
            this.set_Sequence(counter);
        }
        return counter;
    }

    public Map get_SnapshotMap() {
        return this.__m__SnapshotMap;
    }

    public String getDescription() {
        return this.get_Name();
    }

    public Date getRefreshTime() {
        return new Date(this.get_RefreshTimeMillis());
    }

    @Override
    public Object invoke(int nOp, String sName, Object[] aoParam, String[] asSignature) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, MBeanException {
        return this.invoke(sName, aoParam);
    }

    public Object invoke(String sMethod, Object[] aoParam) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return ClassHelper.invoke(this, sMethod, aoParam);
    }

    public boolean is_ReadOnly() {
        return this.__m__ReadOnly;
    }

    public boolean is_Snapshot() {
        return this.__m__Snapshot;
    }

    @Override
    public boolean is_SubscribedTo() {
        if (super.is_SubscribedTo()) {
            return true;
        }
        RemoteHandler handler = this.get_RemoteNotificationHandler();
        return handler != null && handler.isSubscribedTo();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.set_Snapshot(true);
        this.set_ModelName(ExternalizableHelper.readSafeUTF(in));
        this.set_InvocationResult(ExternalizableHelper.readObject(in));
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("Description", ExternalizableHelper.readSafeUTF(in));
        this.set_RefreshTimeMillis(Base.getSafeTimeMillis());
    }

    public void set_InvocationResult(Object oResult) {
        this.__m__InvocationResult = oResult;
    }

    public void set_ReadOnly(boolean flag) {
        this.__m__ReadOnly = flag;
    }

    public void set_RefreshTimeMillis(long ldt) {
        this.__m__RefreshTimeMillis = ldt;
    }

    protected void set_RemoteNotificationHandler(RemoteHandler handler) {
        this.__m__RemoteNotificationHandler = handler;
    }

    protected void set_Sequence(AtomicLong sequence) {
        this.__m__Sequence = sequence;
    }

    protected void set_Snapshot(boolean flag) {
        LocalModel._assert(flag, "One way property");
        this.__m__Snapshot = flag;
        this.set_SnapshotMap(new HashMap());
    }

    protected void set_SnapshotMap(Map map) {
        this.__m__SnapshotMap = map;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        LocalModel._assert(!this.is_Snapshot());
        ExternalizableHelper.writeSafeUTF(out, this.get_ModelName());
        ExternalizableHelper.writeObject(out, this.get_InvocationResult());
        ExternalizableHelper.writeSafeUTF(out, this.getDescription());
    }
}

