/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.gateway;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.management.Connector;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.management.gateway.Local;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.management.model.RemoteModel;
import com.tangosol.coherence.component.net.management.model.localModel.WrapperModel;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.internal.metrics.MetricSupport;
import com.tangosol.internal.net.management.GatewayDependencies;
import com.tangosol.net.InvocationService;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.net.management.NotificationManager;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import com.tangosol.util.function.Remote;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class Remote
extends Gateway {
    private Connector __m_Connector;
    private Local __m_RedirectGateway;
    private transient Set __m_RemoteServers;
    private transient InvocationService __m_Service;
    private boolean __m_Transitioning;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("LocalMBeanServerProxy", LocalMBeanServerProxy.get_CLASS());
    }

    public Remote() {
        this(null, null, true);
    }

    public Remote(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setCustomBeans(new SafeHashMap());
            this.setDomainName("");
            this.setLocalModels(new SafeHashMap());
            this.setMetricSupport(new MetricSupport());
            this.setPrimary(false);
            this.setRegisteredHealthChecks(new SafeHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new Remote();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/gateway/Remote".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public void addNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        LocalModel model = this.getLocalModel(sName);
        if (model != null) {
            model._addNotificationListener(listener, filter, oHandback);
        } else {
            Connector conn = this.ensureRunningConnector();
            if (conn != null) {
                RemoteModel modelRemote = conn.ensureRemoteModel(sName, Remote.extractMemberId(sName));
                if (modelRemote == null) {
                    throw new IllegalArgumentException("Unable to locate model for MBean " + sName);
                }
                modelRemote._addNotificationListener(listener, filter, oHandback);
            }
        }
    }

    public Connector ensureRunningConnector() {
        Connector conn = null;
        if (this.getCluster().isRunning() && !(conn = this.getConnector()).isStarted()) {
            conn.startService(this.getCluster());
        }
        return conn;
    }

    @Override
    protected Object executeInternal(Remote.Function function, Continuation cont) {
        Connector conn = this.ensureRunningConnector();
        return conn == null ? null : conn.sendProxyRequest(conn.createExecuteRequest(function));
    }

    @Override
    public Object getAttribute(String sName, String sAttr) {
        LocalModel model;
        Local gatewayRedirect = this.getRedirectGateway();
        LocalModel localModel = model = gatewayRedirect == null ? this.getLocalModel(sName) : gatewayRedirect.getLocalModel(sName);
        if (model != null) {
            return this.getLocalAttribute(model, sAttr);
        }
        Connector conn = this.ensureRunningConnector();
        return conn == null ? null : conn.sendProxyRequest(conn.createGetRequest(sName, sAttr));
    }

    @Override
    public Map getAttributes(String sName, Filter filter) {
        LocalModel model;
        Local gatewayRedirect = this.getRedirectGateway();
        LocalModel localModel = model = gatewayRedirect == null ? this.getLocalModel(sName) : gatewayRedirect.getLocalModel(sName);
        if (model != null) {
            return this.getLocalAttributes(model, filter);
        }
        Connector conn = this.ensureRunningConnector();
        return conn == null ? null : (Map)conn.sendProxyRequest(conn.createGetRequest(sName, filter));
    }

    public Connector getConnector() {
        return this.__m_Connector;
    }

    public Object getLocalAttribute(LocalModel model, String sAttr) {
        block8: {
            if (model instanceof WrapperModel) {
                try {
                    return ((WrapperModel)model).invoke(1, sAttr, null, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    break block8;
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e);
                }
            }
            Method method = ClassHelper.findMethod(model.getClass(), "get" + sAttr, null, false);
            if (method == null) {
                method = ClassHelper.findMethod(model.getClass(), "is" + sAttr, null, false);
            }
            if (method != null) {
                try {
                    return method.invoke((Object)model, (Object[])null);
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e.getCause());
                }
            }
        }
        throw new IllegalArgumentException("Unknown attribute " + sAttr + " for MBean " + model.get_ModelName());
    }

    public Map getLocalAttributes(LocalModel model, Filter filter) {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        try {
            if (model instanceof WrapperModel) {
                WrapperModel bean = (WrapperModel)model;
                MBeanAttributeInfo[] aAttr = bean.getMBeanInfo().getAttributes();
                int c = aAttr.length;
                for (int i = 0; i < c; ++i) {
                    String sAttr = aAttr[i].getName();
                    if (!filter.evaluate(sAttr)) continue;
                    mapResult.put(sAttr, bean.invoke(1, sAttr, null, null));
                }
            } else {
                for (Method method : model.getClass().getMethods()) {
                    if (method.getParameterCount() != 0 || method.getReturnType() == Void.class) continue;
                    String sName = method.getName();
                    String sAttr = null;
                    if (sName.startsWith("get")) {
                        sAttr = sName.substring(3);
                    } else if (sName.startsWith("is")) {
                        sAttr = sName.substring(2);
                    }
                    if (sAttr == null || filter != null && !filter.evaluate(sAttr)) continue;
                    mapResult.put(sAttr, method.invoke((Object)model, (Object[])null));
                }
            }
            return mapResult;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public synchronized Map getLocalModels() {
        Local gatewayRedirect = this.getRedirectGateway();
        return gatewayRedirect == null ? super.getLocalModels() : gatewayRedirect.getLocalModels();
    }

    @Override
    public MBeanInfo getMBeanInfo(String sName) {
        LocalModel model;
        Local gatewayRedirect = this.getRedirectGateway();
        LocalModel localModel = model = gatewayRedirect == null ? this.getLocalModel(sName) : gatewayRedirect.getLocalModel(sName);
        if (model != null) {
            return this.instantiateModelMBean(model).getMBeanInfo();
        }
        Connector conn = this.ensureRunningConnector();
        return conn == null ? null : (MBeanInfo)conn.sendProxyRequest(conn.createGetMBeanInfoRequest(sName));
    }

    @Override
    public MBeanServerProxy getMBeanServerProxy() {
        Local gatewayRedirect = this.getRedirectGateway();
        return gatewayRedirect == null ? super.getMBeanServerProxy() : gatewayRedirect.getMBeanServerProxy();
    }

    @Override
    public synchronized NotificationManager getNotificationManager() {
        Local gatewayRedirect = this.getRedirectGateway();
        return gatewayRedirect == null ? super.getNotificationManager() : gatewayRedirect.getNotificationManager();
    }

    public Local getRedirectGateway() {
        return this.__m_RedirectGateway;
    }

    public Set getRemoteServers() {
        return this.__m_RemoteServers;
    }

    public InvocationService getService() {
        return this.__m_Service;
    }

    public static Remote instantiate(SafeCluster cluster, Connector connector, GatewayDependencies deps) {
        Remote gateway = new Remote();
        gateway.setCluster(cluster);
        gateway.setConnector(connector);
        gateway.setDependencies(deps);
        return gateway;
    }

    @Override
    public Object invoke(String sName, String sMethodName, Object[] aoParam, String[] asSignature) {
        LocalModel model;
        Local gatewayRedirect = this.getRedirectGateway();
        LocalModel localModel = model = gatewayRedirect == null ? this.getLocalModel(sName) : gatewayRedirect.getLocalModel(sName);
        if (model != null) {
            return this.invokeLocal(model, sMethodName, aoParam, asSignature);
        }
        Connector conn = this.ensureRunningConnector();
        return conn == null ? null : conn.sendProxyRequest(conn.createInvokeRequest(sName, sMethodName, aoParam, asSignature));
    }

    public Object invokeLocal(LocalModel model, String sMethodName, Object[] aoParam, String[] asSignature) {
        try {
            return model.invoke(2, sMethodName, aoParam, asSignature);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Unknown operation " + sMethodName + " for MBean " + model.get_ModelName());
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected boolean isLocalPattern(String sPattern) {
        int cChars = sPattern == null ? 0 : sPattern.length();
        return cChars > 0 && sPattern.charAt(cChars - 1) == '*' && sPattern.contains("nodeId=" + this.getCluster().getLocalMember().getId() + ",");
    }

    @Override
    public boolean isMBeanRegistered(String sName) {
        LocalModel model;
        Local gatewayRedirect = this.getRedirectGateway();
        LocalModel localModel = model = gatewayRedirect == null ? this.getLocalModel(sName) : gatewayRedirect.getLocalModel(sName);
        if (model != null) {
            return true;
        }
        Connector conn = this.ensureRunningConnector();
        return conn != null && (Boolean)conn.sendProxyRequest(conn.createIsRegisteredRequest(sName)) != false;
    }

    @Override
    public boolean isRegistered(String sName) {
        if (sName.equals(this.ensureGlobalName("type=Node"))) {
            this.ensureRunningConnector();
        }
        if (Remote.isGlobal(sName = Remote.extractTenantName(sName)) && this.getCluster().isRunning()) {
            return this.getConnector().isRegisteredModel(sName);
        }
        return false;
    }

    public boolean isTransitioning() {
        return this.__m_Transitioning;
    }

    @Override
    public MBeanServerProxy local() {
        return (LocalMBeanServerProxy)this._newChild("LocalMBeanServerProxy");
    }

    @Override
    public Set queryNames(String sPattern, Filter filter) {
        if (this.isLocalPattern(sPattern)) {
            return this.queryLocalNames(sPattern, filter);
        }
        Connector conn = this.ensureRunningConnector();
        return conn == null ? Collections.EMPTY_SET : (Set)conn.sendProxyRequest(conn.createQueryRequest(sPattern, filter));
    }

    @Override
    public Set queryNames(ObjectName oname, Filter filter) {
        return this.queryNames(oname.getCanonicalName(), filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLocalModel(String sCanonicalName, LocalModel model) {
        Connector conn;
        Remote remote = this;
        synchronized (remote) {
            Local gatewayRedirect = this.getRedirectGateway();
            if (gatewayRedirect != null) {
                gatewayRedirect.registerLocalModel(sCanonicalName, model);
                return;
            }
            super.registerLocalModel(sCanonicalName, model);
            this.registerMetrics(sCanonicalName);
        }
        if (Remote.isGlobal(sCanonicalName) && (conn = this.ensureRunningConnector()) != null && !this.isTransitioning()) {
            conn.registerModel(model);
        }
    }

    @Override
    public void removeNotificationListener(String sName, NotificationListener listener) {
        LocalModel model = this.getLocalModel(sName);
        if (model != null) {
            model._removeNotificationListener(listener);
        } else {
            RemoteModel modelRemote;
            Connector conn = this.ensureRunningConnector();
            if (conn != null && (modelRemote = (RemoteModel)conn.getRemoteModels().get(sName)) != null) {
                modelRemote._removeNotificationListener(listener);
            }
        }
    }

    @Override
    public void removeNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        LocalModel model = this.getLocalModel(sName);
        if (model != null) {
            model._removeNotificationListener(listener, filter, oHandback);
        } else {
            RemoteModel modelRemote;
            Connector conn = this.ensureRunningConnector();
            if (conn != null && (modelRemote = (RemoteModel)conn.getRemoteModels().get(sName)) != null) {
                modelRemote._removeNotificationListener(listener, filter, oHandback);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.getConnector().getLocalRegistry().clear();
    }

    @Override
    public void setAttribute(String sName, String sAttr, Object oValue) {
        LocalModel model;
        Local gatewayRedirect = this.getRedirectGateway();
        LocalModel localModel = model = gatewayRedirect == null ? this.getLocalModel(sName) : gatewayRedirect.getLocalModel(sName);
        if (model != null) {
            this.setLocalAttribute(model, sAttr, oValue);
            return;
        }
        Connector conn = this.ensureRunningConnector();
        if (conn != null) {
            conn.sendProxyRequest(conn.createSetRequest(sName, sAttr, oValue));
        }
    }

    public void setConnector(Connector connector) {
        this.__m_Connector = connector;
    }

    public void setLocalAttribute(LocalModel model, String sAttr, Object oValue) {
        try {
            if (model instanceof WrapperModel) {
                ((WrapperModel)model).invoke(3, sAttr, new Object[]{oValue}, null);
            } else {
                ClassHelper.invoke(model, "set" + sAttr, new Object[]{oValue});
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Unknown or read-only attribute " + sAttr + " for MBean " + model.get_ModelName());
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e.getCause());
        }
    }

    public void setRedirectGateway(Local localGateway) {
        this.__m_RedirectGateway = localGateway;
    }

    protected void setRemoteServers(Set setMember) {
        this.__m_RemoteServers = setMember;
    }

    protected void setService(InvocationService service) {
        this.__m_Service = service;
    }

    public void setTransitioning(boolean fTransitioning) {
        this.__m_Transitioning = fTransitioning;
    }

    public synchronized void transitionToManaging() {
        SafeCluster cluster = this.getCluster();
        Connector connector = this.getConnector();
        GatewayDependencies deps = this.getDependencies();
        Remote gatewayRemote = Remote.instantiate(cluster, connector, deps);
        Local gatewayLocal = Local.instantiate(cluster, connector, deps);
        gatewayRemote.setTransitioning(true);
        gatewayLocal.setRemoteGateway(gatewayRemote);
        for (LocalModel model : this.getLocalModels().values()) {
            gatewayLocal.registerLocalModel(model.get_ModelName(), model);
        }
        gatewayLocal.getRegisteredHealthChecks().putAll(this.getRegisteredHealthChecks());
        gatewayRemote.setTransitioning(false);
        connector.setLocalGateway(gatewayLocal);
        connector.setManagingNode(true);
        this.setRedirectGateway(gatewayLocal);
        cluster.setManagement(gatewayLocal);
    }

    @Override
    public synchronized void trigger(String sName, Notification notification) throws IllegalArgumentException {
        super.trigger(sName, notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLocalModel(String sCanonicalName) {
        Remote remote = this;
        synchronized (remote) {
            Local gatewayRedirect = this.getRedirectGateway();
            if (gatewayRedirect != null) {
                gatewayRedirect.unregisterLocalModel(sCanonicalName);
                return;
            }
            super.unregisterLocalModel(sCanonicalName);
        }
        if (Remote.isGlobal(sCanonicalName)) {
            this.getConnector().unregisterModel(sCanonicalName);
        }
    }

    static {
        Remote.__initStatic();
    }

    public static class LocalMBeanServerProxy
    extends Net
    implements MBeanServerProxy {
        private Remote __m_Remote;

        public LocalMBeanServerProxy() {
            this(null, null, true);
        }

        public LocalMBeanServerProxy(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LocalMBeanServerProxy();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/management/gateway/Remote$LocalMBeanServerProxy".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void addNotificationListener(String Param_1, NotificationListener Param_2, NotificationFilter Param_3, Object Param_4) {
        }

        public Object execute(Remote.Function function) {
            throw new UnsupportedOperationException("execute() is not supported by a local only MBeanServerProxy");
        }

        @Override
        public Object getAttribute(String sName, String sAttr) {
            Remote gateway = (Remote)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            if (model == null) {
                throw new IllegalArgumentException("MBean " + sName + " does not exist");
            }
            return gateway.getLocalAttribute(model, sAttr);
        }

        public Map getAttributes(String sName, Filter filter) {
            Remote gateway = (Remote)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            if (model == null) {
                throw new IllegalArgumentException("MBean " + sName + " does not exist");
            }
            return gateway.getLocalAttributes(model, filter);
        }

        @Override
        public MBeanInfo getMBeanInfo(String sName) {
            Remote gateway = (Remote)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            if (model == null) {
                throw new IllegalArgumentException("MBean " + sName + " does not exist");
            }
            return gateway.getMBeanInfo(sName);
        }

        public Remote getRemote() {
            return this.__m_Remote;
        }

        @Override
        public Object invoke(String sName, String sMethodName, Object[] aoParam, String[] asSignature) {
            Remote gateway = (Remote)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            if (model == null) {
                throw new IllegalArgumentException("MBean " + sName + " does not exist");
            }
            return gateway.invokeLocal(model, sMethodName, aoParam, asSignature);
        }

        @Override
        public boolean isMBeanRegistered(String sName) {
            Remote gateway = (Remote)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            return model != null;
        }

        @Override
        public MBeanServerProxy local() {
            return this;
        }

        public Set queryNames(String sPattern, Filter filter) {
            Remote gateway = (Remote)this.get_Module();
            return gateway.queryLocalNames(sPattern, filter);
        }

        public Set queryNames(ObjectName oname, Filter filter) {
            Remote gateway = (Remote)this.get_Module();
            return gateway.queryLocalNames(oname, filter);
        }

        @Override
        public void removeNotificationListener(String Param_1, NotificationListener Param_2) {
        }

        @Override
        public void removeNotificationListener(String Param_1, NotificationListener Param_2, NotificationFilter Param_3, Object Param_4) {
        }

        @Override
        public void setAttribute(String sName, String sAttr, Object oValue) {
            Remote gateway = (Remote)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            if (model == null) {
                throw new IllegalArgumentException("MBean " + sName + " does not exist");
            }
            gateway.setLocalAttribute(model, sAttr, oValue);
        }

        public void setRemote(Remote sProperty) {
            this.__m_Remote = sProperty;
        }
    }
}

