/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.gateway;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.management.Connector;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.management.gateway.Local;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.management.model.RemoteModel;
import com.tangosol.internal.metrics.MetricSupport;
import com.tangosol.util.Filter;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class Mock
extends Gateway {
    private Connector __m_Connector;

    public Mock() {
        this(null, null, true);
    }

    public Mock(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setCustomBeans(new SafeHashMap());
            this.setDomainName("");
            this.setLocalModels(new SafeHashMap());
            this.setMetricSupport(new MetricSupport());
            this.setPrimary(false);
            this.setRegisteredHealthChecks(new SafeHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new Mock();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/gateway/Mock".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    public void addNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        Connector conn = this.ensureRunningConnector();
        if (conn != null) {
            RemoteModel modelRemote = conn.ensureRemoteModel(sName, Mock.extractMemberId(sName));
            if (modelRemote == null) {
                throw new IllegalArgumentException("Unable to locate model for MBean " + sName);
            }
            modelRemote._addNotificationListener(listener, filter, oHandback);
        }
    }

    public Connector ensureRunningConnector() {
        Connector conn = null;
        if (this.getCluster().isRunning() && !(conn = this.getConnector()).isStarted()) {
            conn.startService(this.getCluster());
        }
        return conn;
    }

    @Override
    public Object getAttribute(String sName, String sAttr) {
        Connector conn = this.ensureRunningConnector();
        return conn == null ? null : conn.sendProxyRequest(conn.createGetRequest(sName, sAttr));
    }

    @Override
    public Map getAttributes(String sName, Filter filter) {
        Connector conn = this.ensureRunningConnector();
        return conn == null ? null : (Map)conn.sendProxyRequest(conn.createGetRequest(sName, filter));
    }

    public Connector getConnector() {
        return this.__m_Connector;
    }

    @Override
    public String getDomainName() {
        Local localGateway = this.getLocalGateway();
        return localGateway == null ? super.getDomainName() : localGateway.getDomainName();
    }

    public Local getLocalGateway() {
        Connector conn = this.getConnector();
        return conn == null ? null : conn.getLocalGateway();
    }

    @Override
    public Object invoke(String sName, String sMethodName, Object[] aoParam, String[] asSignature) {
        Connector conn = this.ensureRunningConnector();
        return conn == null ? null : conn.sendProxyRequest(conn.createInvokeRequest(sName, sMethodName, aoParam, asSignature));
    }

    @Override
    public boolean isMBeanRegistered(String sName) {
        Connector conn = this.ensureRunningConnector();
        return conn != null && (Boolean)conn.sendProxyRequest(conn.createIsRegisteredRequest(sName)) != false;
    }

    @Override
    public boolean isRegistered(String sName) {
        if (sName.equals(this.ensureGlobalName("type=Node"))) {
            this.ensureRunningConnector();
        }
        try {
            return !Mock.isGlobal(sName) && this.getLocalGateway().isRegistered(Mock.extractTenantName(sName));
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public Set queryNames(String sPattern, Filter filter) {
        Connector conn = this.ensureRunningConnector();
        return conn == null ? Collections.EMPTY_SET : (Set)conn.sendProxyRequest(conn.createQueryRequest(sPattern, filter));
    }

    @Override
    public void registerLocalModel(String sCanonicalName, LocalModel model) {
        Local localGateway;
        if (Mock.isGlobal(sCanonicalName)) {
            this.ensureRunningConnector();
        } else if (this.isPrimary() && (localGateway = this.getLocalGateway()) != null) {
            localGateway.registerLocalModel(sCanonicalName, model);
        }
    }

    @Override
    public void registerReporter() {
        Local localGateway = this.getLocalGateway();
        if (localGateway != null) {
            localGateway.registerReporter();
        }
    }

    @Override
    public void removeNotificationListener(String sName, NotificationListener listener) {
        RemoteModel modelRemote;
        Connector conn = this.ensureRunningConnector();
        if (conn != null && (modelRemote = (RemoteModel)conn.getRemoteModels().get(sName)) != null) {
            modelRemote._removeNotificationListener(listener);
        }
    }

    @Override
    public void removeNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        RemoteModel modelRemote;
        Connector conn = this.ensureRunningConnector();
        if (conn != null && (modelRemote = (RemoteModel)conn.getRemoteModels().get(sName)) != null) {
            modelRemote._removeNotificationListener(listener, filter, oHandback);
        }
    }

    @Override
    public void setAttribute(String sName, String sAttr, Object oValue) {
        Connector conn = this.ensureRunningConnector();
        if (conn != null) {
            conn.sendProxyRequest(conn.createSetRequest(sName, sAttr, oValue));
        }
    }

    public void setConnector(Connector connector) {
        this.__m_Connector = connector;
    }

    @Override
    public void unregisterLocalModel(String sCanonicalName) {
        Local localGateway;
        if (!Mock.isGlobal(sCanonicalName) && this.isPrimary() && (localGateway = this.getLocalGateway()) != null) {
            localGateway.unregisterLocalModel(sCanonicalName);
        }
    }
}

