/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.gateway;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Manageable;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.manageable.ModelAdapter;
import com.tangosol.coherence.component.net.management.Connector;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.gateway.Remote;
import com.tangosol.coherence.component.net.management.model.EmptyModel;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.internal.metrics.MetricSupport;
import com.tangosol.internal.net.management.GatewayDependencies;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.WrapperException;
import com.tangosol.util.function.Remote;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;

public class Local
extends Gateway {
    private transient ConcurrentMap __m_ModelAdapters;
    private transient Gateway __m_RemoteGateway;
    private MBeanServer __m_Server;
    private JMXServiceURL __m_ServiceUrl;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("LocalMBeanServerProxy", LocalMBeanServerProxy.get_CLASS());
    }

    public Local() {
        this(null, null, true);
    }

    public Local(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setCustomBeans(new SafeHashMap());
            this.setDomainName("Coherence");
            this.setLocalModels(new SafeHashMap());
            this.setMetricSupport(new MetricSupport());
            this.setModelAdapters(new SegmentedConcurrentMap());
            this.setPrimary(false);
            this.setRegisteredHealthChecks(new SafeHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new Local();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/gateway/Local".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    @Override
    public void addNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        try {
            this.getServer().addNotificationListener(this.getObjectName(Local.extractTenantName(sName)), listener, filter, oHandback);
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sName, null);
        }
    }

    @Override
    protected RuntimeException ensureRuntimeException(Exception e, String sName, String sAttr) {
        if (e instanceof MalformedObjectNameException) {
            return new IllegalArgumentException("Invalid MBean name: " + sName, e);
        }
        if (e instanceof InstanceNotFoundException) {
            return new IllegalArgumentException("Cannot find MBean named: " + sName, e);
        }
        if (e instanceof AttributeNotFoundException) {
            return new IllegalArgumentException("Unknown attribute \"" + sAttr + "\" for MBean " + sName, e);
        }
        if (e instanceof ListenerNotFoundException) {
            return new IllegalArgumentException("The specified NotificationListener has not been added to MBean: " + sName, e);
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    @Override
    public Object executeInternal(Remote.Function function, Continuation cont) {
        Throwable oResult;
        if (cont == null) {
            return function.apply(this.getServer());
        }
        try {
            oResult = function.apply(this.getServer());
        }
        catch (Throwable t) {
            oResult = t;
        }
        cont.proceed(oResult);
        return null;
    }

    @Override
    public Object getAttribute(String sName, String sAttr) {
        try {
            ObjectName name = this.getObjectName(Local.extractTenantName(sName));
            try {
                return this.getServer().getAttribute(name, sAttr);
            }
            catch (Exception e) {
                throw this.ensureRuntimeException(e, name.toString(), sAttr);
            }
        }
        catch (MalformedObjectNameException e) {
            throw this.ensureRuntimeException(e, sName, sAttr);
        }
    }

    @Override
    public Map getAttributes(String sName, Filter filter) {
        MBeanServer mbs = this.getServer();
        LiteMap<String, Object> mapResult = new LiteMap<String, Object>();
        try {
            ObjectName mbeanName = new ObjectName(sName);
            MBeanInfo info = mbs.getMBeanInfo(mbeanName);
            MBeanAttributeInfo[] aAttributes = info.getAttributes();
            int c = aAttributes.length;
            for (int i = 0; i < c; ++i) {
                String sAttribute = aAttributes[i].getName();
                if (!filter.evaluate(sAttribute)) continue;
                mapResult.put(sAttribute, mbs.getAttribute(mbeanName, sAttribute));
            }
            return mapResult;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(String sName) {
        Manageable adapter = null;
        try {
            ObjectName name = this.getObjectName(sName);
            adapter = (ModelAdapter)this.getModelAdapters().get(name);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return adapter == null ? null : adapter.getMBeanInfo();
    }

    public ConcurrentMap getModelAdapters() {
        return this.__m_ModelAdapters;
    }

    public Gateway getRemoteGateway() {
        return this.__m_RemoteGateway;
    }

    public MBeanServer getServer() {
        return this.__m_Server;
    }

    public JMXServiceURL getServiceUrl() {
        return this.__m_ServiceUrl;
    }

    public static Local instantiate(SafeCluster cluster, Connector connector, GatewayDependencies deps) {
        Local gateway = new Local();
        gateway.setCluster(cluster);
        gateway.setDependencies(deps);
        gateway.makePrimary();
        gateway.register(gateway.ensureGlobalName("type=Management"), connector);
        return gateway;
    }

    @Override
    public Object invoke(String sName, String sMethodName, Object[] aoParam, String[] asSignature) {
        try {
            return this.getServer().invoke(this.getObjectName(Local.extractTenantName(sName)), sMethodName, aoParam, asSignature);
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sName, null);
        }
    }

    protected boolean isClusterRunning(String sDomain) {
        try {
            Boolean FRunning;
            ObjectName nameCluster = new ObjectName(sDomain + ":type=Cluster");
            if (this.getServer().isRegistered(nameCluster) && (FRunning = (Boolean)this.getServer().getAttribute(nameCluster, "Running")).booleanValue()) {
                return true;
            }
        }
        catch (JMException jMException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isMBeanRegistered(String sName) {
        return this.isRegistered(sName);
    }

    @Override
    public boolean isRegistered(String sName) {
        if (sName.equals(this.ensureGlobalName("type=Node"))) {
            Remote gatewayRemote = (Remote)this.getRemoteGateway();
            if (gatewayRemote != null) {
                gatewayRemote.ensureRunningConnector();
            }
            return this.getLocalModels().containsKey(sName);
        }
        try {
            return this.getServer().isRegistered(this.getObjectName(Local.extractTenantName(sName)));
        }
        catch (JMException e) {
            return false;
        }
    }

    @Override
    public MBeanServerProxy local() {
        return (LocalMBeanServerProxy)this._newChild("LocalMBeanServerProxy");
    }

    protected void lock(ObjectName oname) {
        if (Local.isResponsibilityMBean(oname.getCanonicalName())) {
            this.getModelAdapters().lock(oname, -1L);
        }
    }

    @Override
    protected void onDependencies(GatewayDependencies deps) {
        Object sCanonicalName;
        String sDomain;
        this.ensureObjectNameCache();
        String sDefaultDomain = deps.getDefaultDomain();
        this.setServer(MBeanHelper.findMBeanServer(sDefaultDomain, deps));
        this.setServiceUrl(MBeanHelper.findJMXServiceUrl(sDefaultDomain, deps));
        Object sPrefix = this.getDomainName();
        String sConfiguredSuffix = deps.getDomainNameSuffix();
        if (sConfiguredSuffix != null && sConfiguredSuffix.length() > 0) {
            sPrefix = (String)sPrefix + "@" + sConfiguredSuffix;
        }
        Object sSuffix = "";
        int iClone = 0;
        while (this.isClusterRunning(sDomain = (String)sPrefix + (String)sSuffix)) {
            sSuffix = "@" + ++iClone;
        }
        this.setDomainName(sDomain);
        if (deps.isExtendedMBeanName()) {
            String sCluster = this.getCluster().getDependencies().getMemberIdentity().getClusterName();
            sCanonicalName = "cluster=" + sCluster + ",*";
        } else {
            sCanonicalName = "*";
        }
        this.unregisterModelMBean((String)sCanonicalName, null);
        this.getReportControl();
    }

    public void onRegistration(int nAction, String sCanonicalName, String sBeanClassName) {
    }

    @Override
    public Set queryNames(String sPattern, Filter filter) {
        try {
            ObjectName oname = sPattern == null ? null : this.getObjectName(sPattern);
            return this.queryNames(oname, filter);
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sPattern, null);
        }
    }

    @Override
    public Set queryNames(ObjectName oname, Filter filter) {
        Set<ObjectName> setONames = this.getServer().queryNames(oname, new MBeanHelper.QueryExpFilter(filter));
        HashSet<String> setNames = new HashSet<String>(setONames.size());
        Iterator<ObjectName> iter = setONames.iterator();
        while (iter.hasNext()) {
            setNames.add(((Object)iter.next()).toString());
        }
        return setNames;
    }

    @Override
    public void registerLocalModel(String sCanonicalName, LocalModel model) {
        Local._assert(this.isPrimary());
        super.registerLocalModel(sCanonicalName, model);
        this.registerModelMBean(sCanonicalName, model);
        Gateway gatewayRemote = this.getRemoteGateway();
        if (gatewayRemote != null) {
            gatewayRemote.registerLocalModel(sCanonicalName, model);
        }
        this.registerMetrics(sCanonicalName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModelMBean(String sCanonicalName, Model model) {
        MBeanServer server = this.getServer();
        try {
            boolean fRetry = true;
            ObjectName name = this.getObjectName(sCanonicalName);
            ConcurrentMap mapAdapters = this.getModelAdapters();
            this.lock(name);
            try {
                while (true) {
                    ModelAdapter adapter;
                    if (server.isRegistered(name)) {
                        adapter = (ModelAdapter)mapAdapters.get(name);
                        if (adapter != null) {
                            adapter.set_Model(model);
                            return;
                        }
                        server.unregisterMBean(name);
                    }
                    try {
                        adapter = this.instantiateModelMBean(model);
                        server.registerMBean(adapter, name);
                        mapAdapters.put(name, adapter);
                    }
                    catch (InstanceAlreadyExistsException e) {
                        if (fRetry) {
                            name = new ObjectName(e.getMessage());
                            fRetry = false;
                            continue;
                        }
                        throw e;
                    }
                    break;
                }
            }
            finally {
                this.unlock(name);
            }
        }
        catch (MalformedObjectNameException e) {
            Local._trace("Failed to register MBean: " + String.valueOf(model) + "; reason=" + Local.getStackTrace(e), 1);
        }
        catch (JMException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public void removeNotificationListener(String sName, NotificationListener listener) {
        try {
            this.getServer().removeNotificationListener(this.getObjectName(Local.extractTenantName(sName)), listener);
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sName, null);
        }
    }

    @Override
    public void removeNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        try {
            this.getServer().removeNotificationListener(this.getObjectName(Local.extractTenantName(sName)), listener, filter, oHandback);
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sName, null);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.unregisterGlobalMBeans();
        Gateway gatewayRemote = this.getRemoteGateway();
        if (gatewayRemote != null) {
            gatewayRemote.reset();
        }
    }

    @Override
    public void setAttribute(String sName, String sAttr, Object oValue) {
        try {
            this.getServer().setAttribute(this.getObjectName(Local.extractTenantName(sName)), new Attribute(sAttr, oValue));
        }
        catch (Exception e) {
            throw this.ensureRuntimeException(e, sName, sAttr);
        }
    }

    protected void setModelAdapters(ConcurrentMap map) {
        this.__m_ModelAdapters = map;
    }

    public void setRemoteGateway(Gateway gateway) {
        this.__m_RemoteGateway = gateway;
    }

    protected void setServer(MBeanServer pServer) {
        this.__m_Server = pServer;
    }

    protected void setServiceUrl(JMXServiceURL url) {
        this.__m_ServiceUrl = url;
    }

    protected void unlock(ObjectName oname) {
        if (Local.isResponsibilityMBean(oname.getCanonicalName())) {
            this.getModelAdapters().unlock(oname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterGlobalMBeans() {
        MBeanServer server = this.getServer();
        try {
            Map mapNames = this.getObjectNameCache();
            Set<ObjectName> setNames = server.queryNames(this.getObjectName("*"), null);
            for (ObjectName oname : setNames) {
                if (!Local.isGlobal(oname.getCanonicalName())) continue;
                this.lock(oname);
                try {
                    mapNames.remove(oname.getKeyPropertyListString());
                    server.unregisterMBean(oname);
                }
                catch (JMException jMException) {}
                continue;
                finally {
                    this.unlock(oname);
                }
            }
        }
        catch (JMException e) {
            Local._trace("Unregister query failed: " + String.valueOf(e), 4);
        }
    }

    @Override
    public void unregisterLocalModel(String sCanonicalName) {
        LocalModel model = (LocalModel)this.getLocalModels().get(sCanonicalName);
        super.unregisterLocalModel(sCanonicalName);
        this.unregisterModelMBean(sCanonicalName, model);
        Gateway gatewayRemote = this.getRemoteGateway();
        if (gatewayRemote != null) {
            gatewayRemote.unregisterLocalModel(sCanonicalName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterModelMBean(String sCanonicalName, Model model) {
        MBeanServer server = this.getServer();
        try {
            Map mapNames = this.getObjectNameCache();
            ConcurrentMap mapAdapters = this.getModelAdapters();
            Set<ObjectName> setNames = server.queryNames(this.getObjectName(sCanonicalName), null);
            Iterator<ObjectName> iter = setNames.iterator();
            while (iter.hasNext()) {
                ObjectName oname = null;
                try {
                    oname = iter.next();
                    this.lock(oname);
                    if (model == null) {
                        mapAdapters.remove(oname);
                        mapNames.remove(oname.getKeyPropertyListString());
                        server.unregisterMBean(oname);
                        continue;
                    }
                    ModelAdapter adapter = (ModelAdapter)mapAdapters.get(oname);
                    if (adapter == null || adapter.get_Model() != model) continue;
                    if (Local.isResponsibilityMBean(sCanonicalName) && model.is_SubscribedTo()) {
                        EmptyModel model0 = new EmptyModel();
                        model0.setMBeanInfo(adapter.getMBeanInfo());
                        adapter.set_Model(model0);
                        continue;
                    }
                    mapAdapters.remove(oname);
                    mapNames.remove(oname.getKeyPropertyListString());
                    server.unregisterMBean(oname);
                }
                catch (Exception e) {
                    Local._trace("Failed to unregister MBean " + String.valueOf(oname) + "; " + String.valueOf(e), 4);
                }
                finally {
                    if (oname == null) continue;
                    this.unlock(oname);
                }
            }
            mapNames.remove(sCanonicalName);
        }
        catch (JMException e) {
            Local._trace("Unregister query failed: " + String.valueOf(e), 4);
        }
    }

    static {
        Local.__initStatic();
    }

    public static class LocalMBeanServerProxy
    extends Util
    implements MBeanServerProxy {
        public LocalMBeanServerProxy() {
            this(null, null, true);
        }

        public LocalMBeanServerProxy(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LocalMBeanServerProxy();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/management/gateway/Local$LocalMBeanServerProxy".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public void addNotificationListener(String Param_1, NotificationListener Param_2, NotificationFilter Param_3, Object Param_4) {
        }

        public Object execute(Remote.Function function) {
            throw new UnsupportedOperationException("execute() is not supported by a local only MBeanServerProxy");
        }

        @Override
        public Object getAttribute(String sName, String sAttr) {
            Local gateway = (Local)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            if (model == null) {
                throw new IllegalArgumentException("MBean " + sName + " does not exist");
            }
            return gateway.getAttribute(sName, sAttr);
        }

        public Map getAttributes(String sName, Filter filter) {
            Local gateway = (Local)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            if (model == null) {
                throw new IllegalArgumentException("MBean " + sName + " does not exist");
            }
            return gateway.getAttributes(sName, filter);
        }

        @Override
        public MBeanInfo getMBeanInfo(String sName) {
            Local gateway = (Local)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            if (model == null) {
                throw new IllegalArgumentException("MBean " + sName + " does not exist");
            }
            return gateway.getMBeanInfo(sName);
        }

        @Override
        public Object invoke(String sName, String sMethodName, Object[] aoParam, String[] asSignature) {
            Local gateway = (Local)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            if (model == null) {
                throw new IllegalArgumentException("MBean " + sName + " does not exist");
            }
            return gateway.invoke(sName, sMethodName, aoParam, asSignature);
        }

        @Override
        public boolean isMBeanRegistered(String sName) {
            Local gateway = (Local)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            return model != null;
        }

        @Override
        public MBeanServerProxy local() {
            return this;
        }

        public Set queryNames(String sPattern, Filter filter) {
            Local gateway = (Local)this.get_Module();
            return gateway.queryLocalNames(sPattern, filter);
        }

        public Set queryNames(ObjectName oname, Filter filter) {
            Local gateway = (Local)this.get_Module();
            return gateway.queryLocalNames(oname, filter);
        }

        @Override
        public void removeNotificationListener(String Param_1, NotificationListener Param_2) {
        }

        @Override
        public void removeNotificationListener(String Param_1, NotificationListener Param_2, NotificationFilter Param_3, Object Param_4) {
        }

        @Override
        public void setAttribute(String sName, String sAttr, Object oValue) {
            Local gateway = (Local)this.get_Module();
            LocalModel model = gateway.getLocalModel(sName);
            if (model == null) {
                throw new IllegalArgumentException("MBean " + sName + " does not exist");
            }
            gateway.setAttribute(sName, sAttr, oValue);
        }
    }
}

