/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.manageable.ModelAdapter;
import com.tangosol.coherence.component.net.Management;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.management.Connector;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.gateway.Local;
import com.tangosol.coherence.component.net.management.gateway.Mock;
import com.tangosol.coherence.component.net.management.gateway.Remote;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.management.model.localModel.CacheModel;
import com.tangosol.coherence.component.net.management.model.localModel.ClusterModel;
import com.tangosol.coherence.component.net.management.model.localModel.ClusterNodeModel;
import com.tangosol.coherence.component.net.management.model.localModel.ConnectionManagerModel;
import com.tangosol.coherence.component.net.management.model.localModel.ConnectionModel;
import com.tangosol.coherence.component.net.management.model.localModel.ManagementModel;
import com.tangosol.coherence.component.net.management.model.localModel.PointToPointModel;
import com.tangosol.coherence.component.net.management.model.localModel.ReporterModel;
import com.tangosol.coherence.component.net.management.model.localModel.ServiceModel;
import com.tangosol.coherence.component.net.management.model.localModel.StorageManagerModel;
import com.tangosol.coherence.component.net.management.model.localModel.WrapperModel;
import com.tangosol.coherence.component.net.management.model.localModel.wrapperModel.WrapperJmxModel;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.partitionedCache.Storage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.coherence.reporter.ReportBatch;
import com.tangosol.coherence.reporter.ReportControl;
import com.tangosol.internal.health.HealthCheckWrapper;
import com.tangosol.internal.health.HealthCheckWrapperMBean;
import com.tangosol.internal.metrics.MetricSupport;
import com.tangosol.internal.net.management.CustomMBeanDependencies;
import com.tangosol.internal.net.management.DefaultGatewayDependencies;
import com.tangosol.internal.net.management.GatewayDependencies;
import com.tangosol.net.Cluster;
import com.tangosol.net.Service;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.management.MBeanReference;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.net.management.NotificationManager;
import com.tangosol.net.management.Registry;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.HealthCheck;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import com.tangosol.util.function.Remote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class Gateway
extends Management
implements MBeanServerProxy,
NotificationManager,
Registry {
    private SafeCluster __m_Cluster;
    private transient Map __m_CustomBeans;
    private GatewayDependencies __m_Dependencies;
    private String __m_DomainName;
    public static final LocalPermission EXECUTE_PERMISSION;
    private Filter __m_Filter;
    private Map __m_LocalModels;
    private MetricSupport __m_MetricSupport;
    private volatile transient Map __m_ObjectNameCache;
    private boolean __m_Primary;
    private Map __m_RegisteredHealthChecks;
    private transient ReportControl __m_ReportControl;

    private static void _initStatic$Default() {
    }

    public Gateway() {
        this(null, null, true);
    }

    public Gateway(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setCustomBeans(new SafeHashMap());
            this.setDomainName("");
            this.setLocalModels(new SafeHashMap());
            this.setMetricSupport(new MetricSupport());
            this.setPrimary(false);
            this.setRegisteredHealthChecks(new SafeHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new Gateway();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/Gateway".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    public void addNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean allHealthChecksLive() {
        Map map = this.getRegisteredHealthChecks();
        if (map.isEmpty()) {
            Logger.fine("Health: Liveness check failed, no health checks registered");
            return false;
        }
        Iterator it = map.values().iterator();
        boolean fOK = true;
        while (it.hasNext()) {
            HealthCheck check = (HealthCheck)it.next();
            if (!check.isMemberHealthCheck() || check.isLive()) continue;
            Logger.fine("Health: Liveness check failed for " + check.getName());
            fOK = false;
        }
        return fOK;
    }

    @Override
    public boolean allHealthChecksReady() {
        Map map = this.getRegisteredHealthChecks();
        if (map.isEmpty()) {
            Logger.fine("Health: Readiness check failed, no health checks registered");
            return false;
        }
        Iterator it = map.values().iterator();
        boolean fOK = true;
        while (it.hasNext()) {
            HealthCheck check = (HealthCheck)it.next();
            if (!check.isMemberHealthCheck() || check.isReady()) continue;
            Logger.fine("Health: Readiness check failed for " + check.getName());
            fOK = false;
        }
        return fOK;
    }

    @Override
    public boolean allHealthChecksSafe() {
        Map map = this.getRegisteredHealthChecks();
        if (map.isEmpty()) {
            Logger.fine("Health: Safety check failed, no health checks registered");
            return false;
        }
        Iterator it = map.values().iterator();
        boolean fOK = true;
        while (it.hasNext()) {
            HealthCheck check = (HealthCheck)it.next();
            if (!check.isMemberHealthCheck() || check.isSafe()) continue;
            Logger.fine("Health: Safety check failed for " + check.getName());
            fOK = false;
        }
        return fOK;
    }

    @Override
    public boolean allHealthChecksStarted() {
        Map map = this.getRegisteredHealthChecks();
        if (map.isEmpty()) {
            Logger.fine("Health: Started check failed, no health checks registered");
            return false;
        }
        Iterator it = map.values().iterator();
        boolean fOK = true;
        while (it.hasNext()) {
            HealthCheck check = (HealthCheck)it.next();
            if (!check.isMemberHealthCheck() || check.isStarted()) continue;
            Logger.fine("Health: Started check failed for " + check.getName());
            fOK = false;
        }
        return fOK;
    }

    public DefaultGatewayDependencies cloneDependencies(GatewayDependencies deps) {
        return new DefaultGatewayDependencies(deps);
    }

    protected String convertSpecialCharacters(String s) {
        return s.replace(':', '_');
    }

    public static Gateway createGateway(GatewayDependencies deps, SafeCluster cluster) {
        boolean fHttpInherit;
        String sManage = deps.getManagedNodes();
        boolean fRemoteMgmt = deps.isAllowRemoteManagement();
        int nEdition = ((Coherence)Coherence.get_Instance()).getEdition();
        if (nEdition == 2) {
            Object sAction = null;
            if (sManage.equals("all")) {
                sManage = "local-only";
                sAction = "switching to the \"" + sManage + "\" mode";
            } else if (sManage.equals("remote-only") || sManage.equals("dynamic")) {
                sManage = "none";
                sAction = "disabling management";
            }
            if (fRemoteMgmt) {
                fRemoteMgmt = false;
                if (sAction == null) {
                    sAction = "disabling remote management";
                }
            }
            if (sAction != null) {
                Gateway._trace("Remote management is not supported for " + Member.EDITION_NAME[nEdition] + "; " + (String)sAction, 3);
            }
        }
        if (sManage.equals("dynamic") && !fRemoteMgmt) {
            Gateway._trace("Turning on the \"remote\" mode for dynamic management", 3);
            fRemoteMgmt = true;
        }
        if (sManage.equals("none") && !fRemoteMgmt) {
            return null;
        }
        String sManageHttp = deps.getHttpManagedNodes();
        if (sManageHttp == null) {
            fHttpInherit = true;
        } else {
            fHttpInherit = sManageHttp.equals("inherit");
            if (sManageHttp.equals("all") && sManage.equals("none")) {
                Gateway._trace("Disabling management over HTTP as this server is not managed", 3);
                sManageHttp = "none";
            }
        }
        Local gatewayLocal = null;
        Remote gatewayRemote = null;
        Mock gatewayMock = null;
        Connector connector = new Connector();
        connector.setManagingNode(sManage.equals("all") || sManage.equals("remote-only"));
        connector.setHttpManagingNode(fHttpInherit ? connector.isManagingNode() : sManageHttp.equals("all"));
        connector.setManagingDynamic(sManage.equals("dynamic"));
        connector.setHttpManagingDynamic(fHttpInherit ? connector.isManagingDynamic() : false);
        connector.setDependencies(deps.getConnectorDependencies());
        if (fRemoteMgmt) {
            gatewayRemote = Remote.instantiate(cluster, connector, deps);
            if (sManage.equals("none") || sManage.equals("dynamic")) {
                gatewayRemote.makePrimary();
                return gatewayRemote;
            }
        }
        try {
            gatewayLocal = Local.instantiate(cluster, connector, deps);
        }
        catch (Throwable e) {
            String sMsg = "This node is not configured for local management; " + (fRemoteMgmt ? "it can only be managed remotely." : "it will not be managed");
            Gateway._trace(sMsg, 2);
            if (!(e instanceof NoClassDefFoundError)) {
                Gateway._trace(e);
            }
            gatewayRemote.makePrimary();
            return gatewayRemote;
        }
        if (fRemoteMgmt) {
            gatewayLocal.setRemoteGateway(gatewayRemote);
        }
        if (sManage.equals("local-only")) {
            return gatewayLocal;
        }
        boolean fRemoteOnly = sManage.equals("remote-only");
        if (!fRemoteOnly) {
            Gateway._assert(sManage.equals("all"), "Unsupported \"managed-nodes\" value: " + sManage);
        }
        connector.setLocalGateway(gatewayLocal);
        if (fRemoteMgmt) {
            if (fRemoteOnly) {
                Gateway._trace("The 'managed-nodes' value of 'remote-only' is incompatible with 'allow-remote-management' value of 'true'; using the 'managed-nodes' value of 'all' instead", 2);
            }
            return gatewayLocal;
        }
        gatewayMock = new Mock();
        gatewayMock.setConnector(connector);
        gatewayMock.setDependencies(deps);
        gatewayMock.setCluster(cluster);
        if (fRemoteOnly) {
            gatewayMock.makePrimary();
            return gatewayMock;
        }
        gatewayLocal.setRemoteGateway(gatewayMock);
        return gatewayLocal;
    }

    @Override
    public String ensureGlobalName(String sName) {
        com.tangosol.net.Member member = this.getCluster().getLocalMember();
        return member == null || sName.isEmpty() ? sName : this.ensureGlobalName(sName, member);
    }

    @Override
    public String ensureGlobalName(String sName, com.tangosol.net.Member member) {
        String sMemberName;
        boolean fWildcard = false;
        if (sName.length() == 1 && sName.charAt(0) == '*') {
            fWildcard = true;
            sName = "";
        } else if (sName.endsWith(",*")) {
            fWildcard = true;
            sName = sName.substring(0, sName.length() - 2);
        }
        StringBuilder sb = new StringBuilder(sName);
        boolean fExtended = this.getDependencies().isExtendedMBeanName();
        if (fExtended) {
            sb.append(',').append("cluster=").append(member.getClusterName());
        }
        if (MBeanHelper.isNonMemberMBean(sName)) {
            if (fWildcard) {
                sb.append(",*");
            }
            return sb.toString();
        }
        if (fExtended && (sMemberName = member.getMemberName()) != null && sMemberName.length() > 0) {
            sb.append(',').append("member=").append(sMemberName);
        }
        sb.append(',').append("nodeId=").append(member.getId());
        if (fWildcard) {
            sb.append(",*");
        }
        return sb.toString();
    }

    protected LocalModel ensureLocalModel(String sName) {
        Map mapModels = this.getLocalModels();
        LocalModel model = (LocalModel)mapModels.get(sName);
        if (model == null) {
            for (String mName : mapModels.keySet()) {
                if (!Gateway.isGlobal(mName)) continue;
                throw new IllegalStateException("Model not found: " + sName);
            }
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map ensureObjectNameCache() {
        Map mapCache = this.getObjectNameCache();
        if (mapCache == null) {
            Gateway gateway = this;
            synchronized (gateway) {
                mapCache = this.getObjectNameCache();
                if (mapCache == null) {
                    mapCache = new LocalCache(100);
                    this.setObjectNameCache(mapCache);
                }
            }
        }
        return mapCache;
    }

    protected RuntimeException ensureRuntimeException(Exception e, String sName, String sAttr) {
        if (e instanceof MalformedObjectNameException) {
            return new IllegalArgumentException("Invalid MBean name: " + sName, e);
        }
        if (e instanceof AttributeNotFoundException) {
            return new IllegalArgumentException("Unknown attribute \"" + sAttr + "\" for MBean " + sName, e);
        }
        return Base.ensureRuntimeException(e, "On attribute \"" + sAttr + "\" for MBean " + sName);
    }

    public Object execute(Remote.Function function) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(EXECUTE_PERMISSION);
        }
        return this.executeInternal(function, null);
    }

    protected Object executeInternal(Remote.Function function, Continuation cont) {
        return null;
    }

    protected static int extractMemberId(String sName) {
        StringBuilder sb = new StringBuilder();
        String[] asPair = Base.parseDelimitedString(sName, ',');
        String sKey = "nodeId=";
        int ofValue = sKey.length();
        for (String sPair : asPair) {
            if (!sPair.startsWith(sKey)) continue;
            String sId = sPair.substring(ofValue);
            return Integer.parseInt(sId);
        }
        return -1;
    }

    protected static String extractTenantName(String sName) {
        if (sName.contains("/")) {
            StringBuilder sb = new StringBuilder();
            String[] asPair = Base.parseDelimitedString(sName, ',');
            String sKey = "service=";
            for (String sPair : asPair) {
                boolean fCopy = true;
                if (sPair.equals("type=Service") || sPair.equals("type=ConnectionManager")) {
                    sKey = "name=";
                } else if (sPair.startsWith(sKey)) {
                    int ofValue = sKey.length();
                    int ofTenant = sPair.indexOf("/");
                    if (ofTenant > 0) {
                        String sTenant = sPair.substring(ofValue, ofTenant);
                        String sService = sPair.substring(ofTenant + 1);
                        sb.append("domainPartition=").append(sTenant).append(',').append(sKey).append(sService);
                        fCopy = false;
                    }
                }
                if (fCopy) {
                    sb.append(sPair);
                }
                sb.append(',');
            }
            return sb.substring(0, sb.length() - 1);
        }
        return sName;
    }

    @Override
    public Object getAttribute(String sName, String sAttr) {
        return null;
    }

    public Map getAttributes(String sName, Filter filter) {
        return null;
    }

    public SafeCluster getCluster() {
        return this.__m_Cluster;
    }

    public Map getCustomBeans() {
        return this.__m_CustomBeans;
    }

    public GatewayDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    @Override
    public String getDomainName() {
        return this.__m_DomainName;
    }

    public Filter getFilter() {
        GatewayDependencies dps = this.getDependencies();
        return dps == null ? null : dps.getFilter();
    }

    public Collection getHealthChecks() {
        Map map = this.getRegisteredHealthChecks();
        return Collections.unmodifiableCollection(map.values());
    }

    public LocalModel getLocalModel(String sName) {
        return (LocalModel)this.getLocalModels().get(sName);
    }

    public Map getLocalModels() {
        return this.__m_LocalModels;
    }

    @Override
    public MBeanInfo getMBeanInfo(String sName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MBeanServerProxy getMBeanServerProxy() {
        if (!this.isPrimary()) {
            throw new IllegalStateException();
        }
        return this;
    }

    public MetricSupport getMetricSupport() {
        return this.__m_MetricSupport;
    }

    @Override
    public NotificationManager getNotificationManager() {
        if (!this.isPrimary()) {
            throw new IllegalStateException();
        }
        return this;
    }

    protected ObjectName getObjectName(String sName) throws MalformedObjectNameException {
        Map map = this.ensureObjectNameCache();
        ObjectName name = (ObjectName)map.get(sName);
        if (name == null) {
            String sDomain = this.getDomainName();
            int ofDomain = sName.indexOf(58);
            int ofEquals = sName.indexOf(61);
            if (0 <= ofEquals && ofEquals < ofDomain) {
                ofDomain = -1;
            }
            name = ofDomain == -1 ? new ObjectName(MBeanHelper.quoteCanonical(sDomain + ":" + sName)) : (ofDomain == 0 ? new ObjectName(MBeanHelper.quoteCanonical(sDomain + sName)) : new ObjectName(MBeanHelper.quoteCanonical(sName)));
            map.put(sName, name);
        }
        return name;
    }

    public Map getObjectNameCache() {
        return this.__m_ObjectNameCache;
    }

    public Map getRegisteredHealthChecks() {
        return this.__m_RegisteredHealthChecks;
    }

    public synchronized ReportControl getReportControl() {
        ReportControl reporter = this.__m_ReportControl;
        if (reporter == null) {
            reporter = new ReportBatch();
            reporter.setDependencies(this.getDependencies().getReporterDependencies());
            this.setReportControl(reporter);
        }
        return reporter;
    }

    protected CacheModel instantiateCacheModel(Map map) {
        CacheModel model = new CacheModel();
        model.set_Map(map);
        return model;
    }

    protected ClusterModel instantiateClusterModel() {
        ClusterModel model = new ClusterModel();
        model.set_Cluster(this.getCluster());
        return model;
    }

    protected ClusterNodeModel instantiateClusterNodeModel(com.tangosol.net.Member member) {
        ClusterNodeModel model = new ClusterNodeModel();
        model.set_Cluster(this.getCluster());
        model.set_Member(member);
        return model;
    }

    protected ConnectionManagerModel instantiateConnectionManagerModel(Acceptor acceptor) {
        ConnectionManagerModel model = new ConnectionManagerModel();
        model.set_Acceptor(acceptor);
        return model;
    }

    protected ConnectionModel instantiateConnectionModel(TcpAcceptor.TcpConnection connection) {
        ConnectionModel model = new ConnectionModel();
        model.set_TcpConnection(connection);
        return model;
    }

    protected LocalModel instantiateLocalModel(Object oBean) {
        LocalModel model;
        Gateway._assert(oBean != null);
        if (oBean instanceof Cluster) {
            Gateway._assert(oBean == this.getCluster());
            model = this.instantiateClusterModel();
        } else {
            model = oBean instanceof ReportControl ? this.instantiateReporterModel((ReportControl)oBean) : (oBean instanceof Connector ? this.instantiateManagementModel((Connector)oBean) : (oBean instanceof com.tangosol.net.Member ? this.instantiateClusterNodeModel((com.tangosol.net.Member)oBean) : (oBean instanceof Acceptor ? this.instantiateConnectionManagerModel((Acceptor)oBean) : (oBean instanceof TcpAcceptor.TcpConnection ? this.instantiateConnectionModel((TcpAcceptor.TcpConnection)oBean) : (oBean instanceof Service ? this.instantiateServiceModel((Service)oBean) : (oBean instanceof Map ? this.instantiateCacheModel((Map)oBean) : (oBean instanceof Storage ? this.instantiateStorageManagerModel((Storage)oBean) : (oBean instanceof MasterMemberSet ? this.instantiatePointToPointModel((MasterMemberSet)oBean) : (oBean instanceof MBeanReference ? this.instantiateWrapperJmxModel((MBeanReference)oBean) : this.instantiateWrapperModel(oBean))))))))));
        }
        if (this.isReadOnly()) {
            model.set_ReadOnly(true);
        }
        return model;
    }

    protected ManagementModel instantiateManagementModel(Connector conn) {
        ManagementModel model = new ManagementModel();
        model.set_Connector(conn);
        return model;
    }

    public ModelAdapter instantiateModelMBean(Model model) {
        String sName = model.get_MBeanComponent();
        ModelAdapter mbean = (ModelAdapter)Gateway._newInstance(sName);
        Gateway._assert(mbean != null, "Invalid MBean name: " + sName);
        mbean.set_Model(model);
        return mbean;
    }

    protected PointToPointModel instantiatePointToPointModel(MasterMemberSet memberset) {
        PointToPointModel model = new PointToPointModel();
        model.set_MemberSet(memberset);
        return model;
    }

    protected ReporterModel instantiateReporterModel(ReportControl control) {
        ReporterModel model = new ReporterModel();
        model.set_ReportControl(control);
        return model;
    }

    protected ServiceModel instantiateServiceModel(Service service) {
        ServiceModel model = new ServiceModel();
        model.set_Service(service);
        if ("Management".equals(service.getInfo().getServiceName())) {
            model.set_ReadOnly(true);
        }
        return model;
    }

    protected StorageManagerModel instantiateStorageManagerModel(Storage storage) {
        StorageManagerModel model = new StorageManagerModel();
        model.set_Storage(storage);
        return model;
    }

    protected WrapperJmxModel instantiateWrapperJmxModel(MBeanReference ref) {
        WrapperJmxModel model = new WrapperJmxModel();
        model.initialize(ref);
        return model;
    }

    protected WrapperModel instantiateWrapperModel(Object oBean) {
        WrapperModel model = new WrapperModel();
        model.setMBean(oBean);
        return model;
    }

    @Override
    public Object invoke(String sName, String sMethodName, Object[] aoParam, String[] asSignature) {
        return null;
    }

    @Override
    public boolean isExtendedMBeanName() {
        return this.getDependencies().isExtendedMBeanName();
    }

    public static boolean isGlobal(String sCanonicalName) {
        return sCanonicalName.contains("nodeId=") || Gateway.isResponsibilityMBean(sCanonicalName);
    }

    @Override
    public boolean isMBeanRegistered(String sName) {
        return false;
    }

    public boolean isPrimary() {
        return this.__m_Primary;
    }

    public boolean isReadOnly() {
        return this.getDependencies().isReadOnly();
    }

    @Override
    public boolean isRegistered(String sName) {
        throw new UnsupportedOperationException();
    }

    public static boolean isResponsibilityMBean(String sCanonicalName) {
        return sCanonicalName.contains("responsibility=");
    }

    @Override
    public boolean isSubscribedTo(String sName) {
        LocalModel model = (LocalModel)this.getLocalModels().get(Gateway.extractTenantName(sName));
        return model != null && model.is_SubscribedTo();
    }

    @Override
    public MBeanServerProxy local() {
        throw new UnsupportedOperationException();
    }

    public void makePrimary() {
        Gateway._assert(!this.isPrimary());
        this.setPrimary(true);
        this.register(this.ensureGlobalName("type=Cluster"), this.getCluster());
    }

    protected void onDependencies(GatewayDependencies deps) {
    }

    public Set queryLocalNames(String sPattern, Filter filter) {
        try {
            ObjectName oname = sPattern == null ? null : this.getObjectName(sPattern);
            return this.queryNames(oname, filter);
        }
        catch (MalformedObjectNameException e) {
            throw this.ensureRuntimeException(e, sPattern, null);
        }
    }

    public Set queryLocalNames(ObjectName oname, Filter filter) {
        HashSet<String> setNames = new HashSet<String>();
        for (String sName : this.getLocalModels().keySet()) {
            try {
                if (oname != null && !oname.apply(this.getObjectName(sName)) || filter != null && !filter.evaluate(oname)) continue;
                setNames.add(sName);
            }
            catch (MalformedObjectNameException e) {
                throw this.ensureRuntimeException(e, sName, null);
            }
        }
        return setNames;
    }

    public Set queryNames(String sPattern, Filter filter) {
        return null;
    }

    public Set queryNames(ObjectName oname, Filter filter) {
        return null;
    }

    @Override
    public void register(HealthCheck healthCheck) {
        HealthCheckWrapperMBean wrapper = healthCheck instanceof HealthCheckWrapperMBean ? (HealthCheckWrapperMBean)healthCheck : new HealthCheckWrapper(healthCheck);
        String sName = this.ensureGlobalName(HealthCheckWrapper.getMBeanName(healthCheck));
        this.registerLocalModel(sName, this.instantiateLocalModel(wrapper));
        this.getRegisteredHealthChecks().put(sName, healthCheck);
        Logger.finest("Health: registered health check " + healthCheck.getName());
    }

    @Override
    public void register(String sName, Object oBean) {
        sName = Gateway.extractTenantName(sName);
        Filter filter = this.getFilter();
        if (filter == null || filter.evaluate(sName)) {
            LocalModel model = this.instantiateLocalModel(oBean);
            this.registerLocalModel(sName, model);
            if (model instanceof HealthCheck) {
                String sSubType = "Application";
                if (model instanceof ClusterModel) {
                    sSubType = "Cluster";
                } else if (model instanceof ServiceModel) {
                    sSubType = "Service";
                }
                HealthCheckWrapper wrapper = new HealthCheckWrapper((HealthCheck)((Object)model), sSubType);
                String sHealthName = this.ensureGlobalName(HealthCheckWrapper.getMBeanName(wrapper));
                this.registerLocalModel(sHealthName, this.instantiateLocalModel(wrapper));
                this.getRegisteredHealthChecks().put(sHealthName, wrapper);
            }
        }
    }

    public void registerCustomBeans() {
        Map mapBeans = this.getCustomBeans();
        Iterable<CustomMBeanDependencies> iterBeanDeps = this.getDependencies().getCustomMBeanDependencies();
        for (CustomMBeanDependencies mbd : iterBeanDeps) {
            String sFactory = mbd.getMBeanFactory();
            String sServerDomain = mbd.getMBeanServerDomain();
            String sQuery = mbd.getMBeanQuery();
            String sClass = mbd.getMBeanClass();
            String sAccessor = mbd.getMBeanAccessor();
            String sMBeanName = mbd.getMBeanName();
            boolean fLocal = mbd.isLocalOnly();
            try {
                boolean fEnabled = mbd.isEnabled();
                boolean fKeep = mbd.isExtendLifecycle();
                if (!fEnabled) continue;
                if (sQuery.length() == 0) {
                    Object oMBean;
                    Object object = oMBean = fKeep ? (Object)mapBeans.get(sMBeanName) : null;
                    if (oMBean == null) {
                        if (sClass.length() == 0) {
                            clzMF = Class.forName(sFactory);
                            oMBean = ClassHelper.invokeStatic(clzMF, sAccessor, null);
                        } else {
                            clzMF = Class.forName(sClass);
                            oMBean = ClassHelper.newInstance(clzMF, null);
                        }
                        if (fKeep) {
                            mapBeans.put(sMBeanName, oMBean);
                        }
                    }
                    if (oMBean instanceof Collection) {
                        Collection colSubBeans = (Collection)oMBean;
                        for (Object oSubMBean : colSubBeans) {
                            try {
                                String sName = (String)ClassHelper.invoke(oSubMBean, "getName", ClassHelper.VOID);
                                String sLocalName = sMBeanName + ",Name=" + sName;
                                this.register((String)(fLocal ? sLocalName : this.ensureGlobalName(sLocalName)), oSubMBean);
                            }
                            catch (Exception e) {
                                Gateway._trace("Unable to call \"getName()\" for MBean \"" + String.valueOf(oSubMBean) + "\". The MBean is not registered.", 2);
                            }
                        }
                        continue;
                    }
                    if (oMBean == null) continue;
                    this.register(fLocal ? sMBeanName : this.ensureGlobalName(sMBeanName), oMBean);
                    continue;
                }
                this.registerQueryMBeans(sServerDomain, sQuery, sMBeanName);
            }
            catch (Exception e) {
                Gateway._trace("Unable to register MBean \"" + sMBeanName + "\" from factory \"" + sFactory + "\"." + Gateway.getStackTrace(e), 2);
            }
        }
    }

    public void registerLocalModel(String sCanonicalName, LocalModel model) {
        if (this.isPrimary()) {
            model.set_ModelName(sCanonicalName);
            this.getLocalModels().put(sCanonicalName, model);
        }
    }

    protected void registerMetrics(String sCanonicalName) {
        if (this.isPrimary()) {
            this.getMetricSupport().register(sCanonicalName);
        }
    }

    protected void registerQueryMBeans(String sMBeanServerDomain, String sQuery, String sPrefix) {
        try {
            MBeanHelper.registerQueryMBeans(sMBeanServerDomain, sQuery, sPrefix, this);
        }
        catch (Throwable e) {
            Gateway._trace("The MBean query \"" + sQuery + "\" failed and will be ignored:\n" + Gateway.getStackTrace(e), 1);
        }
    }

    public void registerReporter() {
        ReportControl reporter = this.getReportControl();
        String sName = "type=Reporter";
        if (!reporter.isCentralized()) {
            sName = this.ensureGlobalName(sName);
        }
        this.register(sName, reporter);
        if (reporter.isAutoStart()) {
            reporter.start();
        }
    }

    public static Set removeByPattern(Map mapRegistry, String sPattern) {
        ImmutableArrayList setPattern = new ImmutableArrayList(Base.parseDelimitedString(sPattern, ','));
        HashSet<String> setRemoved = new HashSet<String>();
        ArrayList listModel = new ArrayList();
        Iterator iter = mapRegistry.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String sName = (String)entry.getKey();
            ImmutableArrayList setParts = new ImmutableArrayList(Base.parseDelimitedString(sName, ','));
            if (!setParts.containsAll(setPattern)) continue;
            listModel.add(entry.getValue());
            setRemoved.add(sName);
            iter.remove();
        }
        for (Model model : listModel) {
            String sHeathName = model.get_HealthModelName();
            if (sHeathName == null) continue;
            mapRegistry.remove(sHeathName);
            setRemoved.add(sHeathName);
        }
        return setRemoved;
    }

    @Override
    public void removeNotificationListener(String sName, NotificationListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        if (this.isPrimary()) {
            Iterator iter = this.getLocalModels().keySet().iterator();
            while (iter.hasNext()) {
                String sName = (String)iter.next();
                if (!Gateway.isGlobal(sName)) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void setAttribute(String sName, String sAttr, Object oValue) {
    }

    public void setCluster(SafeCluster cluster) {
        Gateway._assert(cluster == null || this.getCluster() == null, "Cluster is not resettable");
        this.__m_Cluster = cluster;
    }

    protected void setCustomBeans(Map map) {
        this.__m_CustomBeans = map;
    }

    public void setDependencies(GatewayDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Dependencies already set");
        }
        this.__m_Dependencies = this.cloneDependencies(deps).validate();
        this.onDependencies(this.getDependencies());
    }

    protected void setDomainName(String pDomainName) {
        this.__m_DomainName = pDomainName;
    }

    protected void setFilter(Filter filter) {
        this.__m_Filter = filter;
    }

    protected void setLocalModels(Map map) {
        this.__m_LocalModels = map;
    }

    public void setMetricSupport(MetricSupport supportMetric) {
        this.__m_MetricSupport = supportMetric;
    }

    protected void setObjectNameCache(Map map) {
        this.__m_ObjectNameCache = map;
    }

    protected void setPrimary(boolean primary) {
        this.__m_Primary = primary;
    }

    public void setRegisteredHealthChecks(Map mapChecks) {
        this.__m_RegisteredHealthChecks = mapChecks;
    }

    protected void setReportControl(ReportControl rc) {
        this.__m_ReportControl = rc;
    }

    @Override
    public void trigger(String sName, String sType, String sMessage) throws IllegalArgumentException {
        LocalModel model = this.ensureLocalModel(Gateway.extractTenantName(sName));
        if (model != null) {
            model._handleNotification(sType, sMessage);
        }
    }

    @Override
    public void trigger(String sName, Notification notification) throws IllegalArgumentException {
        LocalModel model = this.ensureLocalModel(Gateway.extractTenantName(sName));
        if (model != null) {
            model._handleNotification(notification);
        }
    }

    @Override
    public void unregister(HealthCheck healthCheck) {
        String sName = this.ensureGlobalName(HealthCheckWrapper.getMBeanName(healthCheck));
        this.unregister(sName);
        if (this.getRegisteredHealthChecks().remove(sName) != null) {
            Logger.finest("Health: unregistered health check " + healthCheck.getName());
        }
    }

    @Override
    public void unregister(String sName) {
        if (this.getDependencies().isExtendedMBeanName() && ((String)sName).charAt(((String)sName).length() - 1) != '*') {
            sName = (String)sName + ",*";
        }
        this.unregisterLocalModel(Gateway.extractTenantName((String)sName));
    }

    public void unregisterLocalModel(String sCanonicalName) {
        if (this.isPrimary()) {
            Map mapModels = this.getLocalModels();
            if (sCanonicalName.endsWith(",*")) {
                String sName = MBeanHelper.stripDomain(sCanonicalName);
                String sPattern = sName.substring(0, sName.length() - 2);
                Set setKeys = Gateway.removeByPattern(mapModels, sPattern);
                for (String sKey : setKeys) {
                    this.unregisterMetrics(sKey);
                }
            } else {
                String sHeathName;
                Model model = (Model)mapModels.remove(sCanonicalName);
                this.unregisterMetrics(sCanonicalName);
                if (model != null && (sHeathName = model.get_HealthModelName()) != null) {
                    mapModels.remove(sHeathName);
                    this.getRegisteredHealthChecks().remove(sHeathName);
                }
            }
        }
    }

    protected void unregisterMetrics(String sCanonicalName) {
        if (this.isPrimary()) {
            this.getMetricSupport().remove(sCanonicalName);
        }
    }

    static {
        Gateway._initStatic$Default();
        EXECUTE_PERMISSION = new LocalPermission("MBeanServerProxy.execute");
    }
}

