/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Management;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.net.management.Model;
import com.tangosol.coherence.component.net.management.gateway.Local;
import com.tangosol.coherence.component.net.management.gateway.Remote;
import com.tangosol.coherence.component.net.management.listenerHolder.LocalHolder;
import com.tangosol.coherence.component.net.management.listenerHolder.RemoteHolder;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.net.management.model.RemoteModel;
import com.tangosol.coherence.component.net.management.model.localModel.WrapperModel;
import com.tangosol.coherence.component.net.management.model.localModel.wrapperModel.WrapperJmxModel;
import com.tangosol.coherence.component.net.management.notificationHandler.RemoteHandler;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.health.HealthHttpHandler;
import com.tangosol.internal.net.management.ConnectorDependencies;
import com.tangosol.internal.net.management.DefaultConnectorDependencies;
import com.tangosol.internal.net.management.HttpHelper;
import com.tangosol.internal.net.metrics.MetricsHttpHelper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationObserver;
import com.tangosol.net.InvocationService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NameService;
import com.tangosol.net.NonBlockingInvocable;
import com.tangosol.net.management.MBeanConnector;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.Resources;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SafeHashSet;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.WrapperException;
import com.tangosol.util.function.Remote;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;

public class Connector
extends Management
implements MemberListener,
NameService.Resolvable,
SynchronousListener {
    private boolean __m_Announced;
    private JMXConnectorServer __m_ConnectorServer;
    private ConnectorDependencies __m_Dependencies;
    private boolean __m_HttpManagingDynamic;
    private boolean __m_HttpManagingNode;
    private Collection __m_JmxListenAddresses;
    private JMXServiceURL __m_JmxServiceUrl;
    private Local __m_LocalGateway;
    private Map __m_LocalRegistry;
    private boolean __m_ManagingDynamic;
    private boolean __m_ManagingNode;
    private static transient String __s_MsgFailure;
    private long __m_RefreshAttributeTimeoutMillis;
    private Map __m_RemoteModels;
    private Set __m_RemoteServers;
    private long __m_RequestTimeout;
    private InvocationService __m_Service;
    private long __m_StatsNotificationCount;
    private long __m_StatsRefreshCount;
    private long __m_StatsRefreshExcessCount;
    private long __m_StatsRefreshPredictionCount;
    private long __m_StatsRefreshTimeoutCount;
    private ThreadLocal __m_ThreadLocalContinuation;
    private static ListMap __mapChildren;

    private static void __initStatic() {
        __mapChildren = new ListMap();
        __mapChildren.put("Announce", Announce.get_CLASS());
        __mapChildren.put("ExecuteFunction", ExecuteFunction.get_CLASS());
        __mapChildren.put("InvokeRemote", InvokeRemote.get_CLASS());
        __mapChildren.put("LookupCallback", LookupCallback.get_CLASS());
        __mapChildren.put("Notify", Notify.get_CLASS());
        __mapChildren.put("Publish", Publish.get_CLASS());
        __mapChildren.put("Register", Register.get_CLASS());
        __mapChildren.put("Subscribe", Subscribe.get_CLASS());
        __mapChildren.put("Unregister", Unregister.get_CLASS());
    }

    public Connector() {
        this(null, null, true);
    }

    public Connector(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    @Override
    public void __init() {
        this.__initPrivate();
        try {
            this.setLocalRegistry(new SafeHashMap());
            this.setRefreshAttributeTimeoutMillis(250L);
            this.setRemoteModels(new ConcurrentHashMap());
            this.setRemoteServers(new SafeHashSet());
            this.setThreadLocalContinuation(new ThreadLocal());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    @Override
    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Component get_Instance() {
        return new Connector();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com.tangosol.coherence/component/net/management/Connector".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private Component get_Module() {
        return this;
    }

    @Override
    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    protected void announce(InvocationService service) {
        com.tangosol.net.Member memberThis = service.getCluster().getLocalMember();
        Set setOther = service.getInfo().getServiceMembers();
        setOther.remove(memberThis);
        Announce task = (Announce)this._newChild("Announce");
        task.setMemberFrom(memberThis.getId());
        task.setManagingNode(this.isManagingNode());
        service.execute(task, setOther, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assumeManagement() {
        JMXConnectorServer jmxServer;
        SafeCluster cluster = this.getCluster();
        Remote remoteGateway = (Remote)cluster.getManagement();
        remoteGateway.transitionToManaging();
        JMXServiceURL jmxUrl = this.getLocalGateway().getServiceUrl();
        if (jmxUrl == null && (jmxServer = this.jmxStartConnector()) != null) {
            this.setConnectorServer(jmxServer);
            jmxUrl = jmxServer.getAddress();
        }
        if (jmxUrl != null) {
            Connector connector = this;
            synchronized (connector) {
                this.setJmxServiceUrl(jmxUrl);
                InetAddress addrDisc = cluster.getDependencies().getLocalDiscoveryAddress();
                this.setJmxListenAddresses(addrDisc.isAnyLocalAddress() ? InetAddressHelper.getLocalBindableAddresses() : Collections.singleton(addrDisc));
            }
            this.jmxPublishConnector(null);
        }
    }

    protected com.tangosol.net.Member chooseRemoteServer(int nAction) {
        Set setServers = this.getRemoteServers();
        if (setServers.isEmpty()) {
            throw new RuntimeException("None of the nodes are managed");
        }
        String sReason = null;
        block4: for (Member member : setServers) {
            switch (nAction) {
                case 4: {
                    if (this.isVersionCompatible(member, 12, 2, 1, 1, 0)) {
                        return member;
                    }
                    sReason = "queryNames(...) method";
                    continue block4;
                }
                case 7: {
                    if (this.isVersionCompatible(member, 12, 2, 1, 4, 0)) {
                        return member;
                    }
                    sReason = "addNotificationListener(...) method";
                    continue block4;
                }
            }
            return member;
        }
        throw new UnsupportedOperationException("All managed nodes running an older version that does not support " + sReason);
    }

    public DefaultConnectorDependencies cloneDependencies(ConnectorDependencies deps) {
        return new DefaultConnectorDependencies(deps);
    }

    public InvokeRemote createExecuteRequest(Remote.Function function) {
        InvokeRemote task = (InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(5);
        task.setFunction(function);
        return task;
    }

    public InvokeRemote createFindOwnerRequest(String sName) {
        InvokeRemote task = (InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(7);
        task.setName(sName);
        return task;
    }

    public InvokeRemote createGetMBeanInfoRequest(String sName) {
        InvokeRemote task = (InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(6);
        task.setName(sName);
        return task;
    }

    public InvokeRemote createGetRequest(String sName, Filter filter) {
        InvokeRemote task = (InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(0);
        task.setName(sName);
        task.setQueryFilter(filter);
        return task;
    }

    public InvokeRemote createGetRequest(String sName, String sAttr) {
        InvokeRemote task = (InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(0);
        task.setName(sName);
        task.setAttributeName(sAttr);
        return task;
    }

    public InvokeRemote createInvokeRequest(String sName, String sMethod, Object[] aoParam, String[] asSignature) {
        InvokeRemote task = (InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(1);
        task.setName(sName);
        task.setMethodName(sMethod);
        task.setParameters(aoParam);
        task.setSignatures(asSignature);
        return task;
    }

    public InvokeRemote createIsRegisteredRequest(String sName) {
        InvokeRemote task = (InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(3);
        task.setName(sName);
        return task;
    }

    public InvokeRemote createQueryRequest(String sPattern, Filter filter) {
        InvokeRemote task = (InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(4);
        task.setQueryPattern(sPattern);
        task.setQueryFilter(filter);
        return task;
    }

    public InvokeRemote createSetRequest(String sName, String sAttr, Object oValue) {
        InvokeRemote task = (InvokeRemote)this._newChild("InvokeRemote");
        task.setAction(2);
        task.setName(sName);
        task.setAttributeName(sAttr);
        task.setAttributeValue(oValue);
        return task;
    }

    public LocalModel ensureFreshSnapshot(RemoteModel model) {
        int nPolicy = this.getRefreshPolicy();
        if (nPolicy == 3) {
            model.acquireExecuteMutex(this.getRefreshRequestTimeoutMillis());
            model.releaseExecuteMutex();
        } else if (model.isRefreshRequired()) {
            this.setStatsRefreshCount(this.getStatsRefreshCount() + 1L);
            if (!model.isAccessed()) {
                this.setStatsRefreshExcessCount(this.getStatsRefreshExcessCount() + 1L);
            }
            switch (nPolicy) {
                case 0: {
                    model.invokeRemote(1, null, null);
                    break;
                }
                case 1: {
                    model.invokeRemote(1, null, null);
                    this.refreshActiveModels(model);
                    break;
                }
                case 2: {
                    boolean fInvoked = model.invokeRemoteAsync();
                    if (!fInvoked) break;
                    this.setStatsRefreshPredictionCount(this.getStatsRefreshPredictionCount() + 1L);
                    break;
                }
            }
        }
        return model.getSnapshot();
    }

    public RemoteModel ensureRemoteModel(String sName, int nMember) {
        Map mapModel = this.getRemoteModels();
        RemoteModel modelRemote = (RemoteModel)mapModel.get(sName);
        if (modelRemote == null) {
            com.tangosol.net.Member member;
            com.tangosol.net.Member member2 = member = nMember > 0 ? this.getMember(nMember) : this.findModelOwner(sName);
            if (member == null) {
                throw new IllegalArgumentException("Unable to locate owning Member for MBean " + sName);
            }
            modelRemote = new RemoteModel();
            mapModel.put(sName, modelRemote);
            modelRemote.set_ModelName(sName);
            modelRemote.setConnector(this);
            modelRemote.setAccessed(false);
            modelRemote.setModelOwner(member);
        }
        return modelRemote;
    }

    public void extractMemberId(String sName) {
    }

    public com.tangosol.net.Member findModelOwner(String sName) {
        if (this.isRegisteredModel(sName)) {
            return this.getMember(this.getLocalMemberId());
        }
        InvokeRemote task = this.createFindOwnerRequest(sName);
        Integer NOwnerId = (Integer)this.sendProxyRequest(task);
        return NOwnerId == null ? null : this.getMember(NOwnerId);
    }

    public String formatRefreshPolicy(int nPolicy) {
        switch (nPolicy) {
            case 0: {
                return "refresh-expired";
            }
            case 1: {
                return "refresh-ahead";
            }
            case 2: {
                return "refresh-behind";
            }
            case 3: {
                return "refresh-onquery";
            }
        }
        return "n/a";
    }

    public SafeCluster getCluster() {
        InvocationService service = this.getService();
        return service == null ? Coherence.getCluster() : (SafeCluster)service.getCluster();
    }

    public JMXConnectorServer getConnectorServer() {
        return this.__m_ConnectorServer;
    }

    public ConnectorDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public com.tangosol.net.Member getDynamicSenior() {
        com.tangosol.net.Member memberOldest = null;
        long ldtOldest = Long.MAX_VALUE;
        SafeService service = (SafeService)((Object)this.getService());
        Grid _service = (Grid)service.getService();
        Member memberThis = _service.getThisMember();
        ServiceMemberSet setMember = _service.getServiceMemberSet();
        for (com.tangosol.net.Member member : setMember) {
            long ldt;
            int nMember = member.getId();
            boolean fDynamic = member == memberThis ? this.isManagingDynamic() : Boolean.TRUE.equals((Boolean)setMember.getMemberConfigMap(nMember).get("dynamic-management"));
            if (!fDynamic || (ldt = setMember.getServiceJoinTime(nMember)) >= ldtOldest) continue;
            memberOldest = member;
            ldtOldest = ldt;
        }
        return memberOldest;
    }

    public Continuation getInvokeContinuation() {
        return (Continuation)this.getThreadLocalContinuation().get();
    }

    public Collection getJmxListenAddresses() {
        return this.__m_JmxListenAddresses;
    }

    public JMXServiceURL getJmxServiceUrl() {
        return this.__m_JmxServiceUrl;
    }

    public Local getLocalGateway() {
        return this.__m_LocalGateway;
    }

    public int getLocalMemberId() {
        SafeCluster cluster = this.getCluster();
        return cluster == null ? 0 : cluster.getLocalMember().getId();
    }

    public Map getLocalRegistry() {
        return this.__m_LocalRegistry;
    }

    public Member getMember(int nId) {
        Grid service;
        SafeService serviceSafe = (SafeService)((Object)this.getService());
        if (serviceSafe != null && (service = (Grid)serviceSafe.getService()) != null && service.isRunning()) {
            return service.getServiceMemberSet().getMember(nId);
        }
        return null;
    }

    private static String getMsgFailure() {
        return __s_MsgFailure;
    }

    protected NameService getNameService() {
        return this.getCluster().getCluster().getNameService();
    }

    public long getRefreshAttributeTimeoutMillis() {
        return this.__m_RefreshAttributeTimeoutMillis;
    }

    public int getRefreshPolicy() {
        return this.getDependencies().getRefreshPolicy();
    }

    public long getRefreshRequestTimeoutMillis() {
        return this.getDependencies().getRefreshRequestTimeoutMillis();
    }

    public long getRefreshTimeoutMillis() {
        return this.getDependencies().getRefreshTimeoutMillis();
    }

    public Map getRemoteModels() {
        return this.__m_RemoteModels;
    }

    public Set getRemoteServers() {
        return this.__m_RemoteServers;
    }

    public long getRequestTimeout() {
        return this.__m_RequestTimeout;
    }

    public InvocationService getService() {
        return this.__m_Service;
    }

    public long getStatsNotificationCount() {
        return this.__m_StatsNotificationCount;
    }

    public long getStatsRefreshCount() {
        return this.__m_StatsRefreshCount;
    }

    public long getStatsRefreshExcessCount() {
        return this.__m_StatsRefreshExcessCount;
    }

    public long getStatsRefreshPredictionCount() {
        return this.__m_StatsRefreshPredictionCount;
    }

    public long getStatsRefreshTimeoutCount() {
        return this.__m_StatsRefreshTimeoutCount;
    }

    public ThreadLocal getThreadLocalContinuation() {
        return this.__m_ThreadLocalContinuation;
    }

    public boolean isAnnounced() {
        return this.__m_Announced;
    }

    public boolean isHttpManagingDynamic() {
        return this.__m_HttpManagingDynamic;
    }

    public boolean isHttpManagingNode() {
        return this.__m_HttpManagingNode;
    }

    public boolean isManagingDynamic() {
        return this.__m_ManagingDynamic;
    }

    public boolean isManagingNode() {
        return this.__m_ManagingNode;
    }

    public boolean isRegisteredModel(String sName) {
        return this.getLocalRegistry().containsKey(sName);
    }

    public boolean isStarted() {
        return this.getService() != null;
    }

    protected boolean isVersionCompatible(Member member, int nMajor, int nMinor, int nMicro, int nPatchSet, int nPatch) {
        Grid service;
        SafeService serviceSafe = (SafeService)((Object)this.getService());
        if (serviceSafe != null && (service = (Grid)serviceSafe.getService()) != null && service.isRunning()) {
            return service.isVersionCompatible(member, nMajor, nMinor, nMicro, nPatchSet, nPatch);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void jmxPublishConnector(Set setMembers) {
        InvocationService service = this.getService();
        Publish task = (Publish)this._newChild("Publish");
        Connector connector = this;
        synchronized (connector) {
            task.setJMXServiceURL(this.getJmxServiceUrl());
            task.setListenAddresses(this.getJmxListenAddresses());
        }
        service.execute(task, setMembers, null);
    }

    protected JMXConnectorServer jmxStartConnector() {
        int nPort;
        Cluster cluster = this.getCluster().getCluster();
        InetAddress addrDisc = cluster.getDependencies().getLocalDiscoveryAddress();
        InetAddress addrMember = cluster.getLocalMember().getAddress();
        InetAddress addrRMI = addrDisc.isAnyLocalAddress() ? (InetAddresses.isLocalAddress(addrMember) ? addrDisc : addrMember) : addrDisc;
        String sAddr = Config.getProperty("coherence.management.remote.host", addrRMI.getHostAddress());
        HashMap<String, String> mapEnv = new HashMap<String, String>();
        int nPortMax = MBeanConnector.getConnectionPortMax();
        if (cluster.getSocketManager().getUnicastUdpSocketProvider().isSecure()) {
            mapEnv.put("com.oracle.coherence.tcmp.ssl", "true");
            nPort = MBeanConnector.getConnectionPort();
        } else {
            String sPort = Config.getProperty("coherence.management.remote.connectionport");
            nPort = sPort == null ? cluster.getLocalMember().getPort() : MBeanConnector.getConnectionPort();
        }
        Exception eLast = null;
        while (true) {
            try {
                JMXConnectorServer connector = MBeanHelper.startRmiConnector(sAddr, 0, nPort, this.getLocalGateway().getServer(), mapEnv);
                Connector._trace("JMXConnectorServer now listening for connections on " + (InetAddresses.isAnyLocalAddress(sAddr) ? InetAddress.getLocalHost().getHostName() : sAddr) + ":" + connector.getAddress().getPort(), 3);
                return connector;
            }
            catch (Exception e) {
                eLast = e;
                if (nPort != 0 && ++nPort <= nPortMax) continue;
                Connector._trace("Could not start JMXConnectorServer on " + sAddr + ":" + nPort + "\n" + eLast.getMessage(), 1);
                return null;
            }
            break;
        }
    }

    @Override
    public void memberJoined(MemberEvent event) {
        InvocationService service = this.getService();
        if (!event.isLocal() && service != null && this.getDynamicSenior() == service.getCluster().getLocalMember()) {
            this.jmxPublishConnector(Collections.singleton(event.getMember()));
        }
    }

    @Override
    public void memberLeaving(MemberEvent event) {
    }

    @Override
    public void memberLeft(MemberEvent event) {
        SafeCluster cluster = this.getCluster();
        Local localGateway = this.getLocalGateway();
        com.tangosol.net.Member member = event.getMember();
        String sNodeId = "nodeId=" + member.getId();
        if (event.isLocal()) {
            if (!cluster.isRunning()) {
                if (localGateway != null) {
                    localGateway.reset();
                }
                this.removeLocalSubscriptions();
            }
            this.getRemoteServers().clear();
            this.getRemoteModels().clear();
            JMXConnectorServer jmxServer = this.getConnectorServer();
            if (jmxServer != null) {
                try {
                    jmxServer.stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.setService(null);
        } else {
            this.getRemoteServers().remove(member);
            this.removeRemoteSubscriptions(member);
            Map mapRemoteModels = this.getRemoteModels();
            HashSet setRemoved = new HashSet();
            Iterator iter = mapRemoteModels.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                RemoteModel model = (RemoteModel)entry.getValue();
                if (!member.equals(model.getModelOwner())) continue;
                setRemoved.add(entry);
                iter.remove();
            }
            if (localGateway != null) {
                for (Map.Entry entry : setRemoved) {
                    localGateway.unregisterModelMBean((String)entry.getKey(), (Model)entry.getValue());
                }
                localGateway.unregisterModelMBean(sNodeId + ",*", null);
            }
            InvocationService service = this.getService();
            if (!this.isManagingNode() && service != null && this.getDynamicSenior() == service.getCluster().getLocalMember()) {
                this.assumeManagement();
                this.announce(service);
            }
        }
    }

    public void onAnnouncement(Announce taskAnnounce) {
        Member memberFrom;
        if (taskAnnounce.isManagingNode() && (memberFrom = this.getMember(taskAnnounce.getMemberFrom())) != null) {
            this.getRemoteServers().add(memberFrom);
            this.registerAll(Collections.singleton(memberFrom));
        }
        taskAnnounce.setResult(this.isManagingNode() ? Boolean.TRUE : Boolean.FALSE);
    }

    public void onAnnouncementCompleted() {
        InvocationService service = this.getService();
        if (service != null && service.isRunning()) {
            this.setAnnounced(true);
            this.registerAll(this.getRemoteServers());
        }
    }

    protected void onDependencies(ConnectorDependencies deps) {
    }

    public void onNotify(Notify taskNotify) {
        String sName = taskNotify.getName();
        RemoteModel model = (RemoteModel)this.getRemoteModels().get(sName);
        if (model == null) {
            Connector._trace("Error handling notification " + sName, 3);
        } else {
            model._handleNotification(taskNotify.getNotification());
            this.setStatsNotificationCount(this.getStatsNotificationCount() + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPublish(Publish taskPublish) {
        Connector connector = this;
        synchronized (connector) {
            this.setJmxServiceUrl(taskPublish.getJMXServiceURL());
            this.setJmxListenAddresses(taskPublish.getListenAddresses());
        }
    }

    public void onRegister(Register taskRegister) {
        Local localGateway = this.getLocalGateway();
        if (localGateway != null) {
            Member member = this.getMember(taskRegister.getMemberFrom());
            if (member == null) {
                return;
            }
            Map mapRemoteModels = this.getRemoteModels();
            for (LocalModel model : taskRegister.getSnapshot()) {
                String sName = model.get_ModelName();
                RemoteModel modelRemote = (RemoteModel)mapRemoteModels.get(sName);
                if (modelRemote == null) {
                    modelRemote = new RemoteModel();
                    mapRemoteModels.put(sName, modelRemote);
                    modelRemote.set_ModelName(sName);
                    modelRemote.setConnector(this);
                    modelRemote.setAccessed(false);
                } else if (!modelRemote.isResponsibilityMBean() && !((Object)member).equals(modelRemote.getModelOwner())) {
                    Connector._trace("Unexpected multi-ownership for MBean: " + sName, 1);
                }
                modelRemote.setSnapshot(model);
                modelRemote.setModelOwner(member);
                try {
                    localGateway.registerModelMBean(sName, modelRemote);
                }
                catch (RuntimeException e) {
                    Connector._trace("Failed to register MBean: " + sName, 1);
                    Connector._trace(e);
                }
            }
        }
    }

    public void onRemoteInvoke(InvokeRemote taskInvoke, Continuation cont) {
        Object oResult;
        boolean fAsync;
        Exception exception = taskInvoke.getReadException();
        if (exception != null) {
            cont.proceed(exception);
            return;
        }
        int nAction = taskInvoke.getAction();
        Grid service = (Grid)((SafeService)((Object)this.getService())).getService();
        String sName = taskInvoke.getName();
        ThreadLocal tlCont = this.getThreadLocalContinuation();
        boolean bl = fAsync = nAction == 5 || nAction != 3 && nAction != 4 && nAction != 7 && sName != null && this.getRemoteModels().containsKey(sName) && service.getThread() == Thread.currentThread();
        if (fAsync) {
            tlCont.set(cont);
        }
        try {
            switch (nAction) {
                case 0: {
                    Filter filter = taskInvoke.getQueryFilter();
                    oResult = filter == null ? this.getLocalGateway().getAttribute(sName, taskInvoke.getAttributeName()) : this.getLocalGateway().getAttributes(sName, filter);
                    break;
                }
                case 2: {
                    this.getLocalGateway().setAttribute(sName, taskInvoke.getAttributeName(), taskInvoke.getAttributeValue());
                    oResult = null;
                    break;
                }
                case 1: {
                    oResult = this.getLocalGateway().invoke(sName, taskInvoke.getMethodName(), taskInvoke.getParameters(), taskInvoke.getSignatures());
                    break;
                }
                case 5: {
                    ExecuteFunction function = (ExecuteFunction)this._newChild("ExecuteFunction");
                    function.setInvocable(taskInvoke);
                    function.setContinuation(cont);
                    service.ensureEventDispatcher().getQueue().add(function);
                    oResult = null;
                    break;
                }
                case 3: {
                    oResult = this.getLocalGateway().isMBeanRegistered(sName);
                    break;
                }
                case 4: {
                    oResult = this.getLocalGateway().queryNames(taskInvoke.getQueryPattern(), taskInvoke.getQueryFilter());
                    break;
                }
                case 6: {
                    oResult = this.getLocalGateway().getMBeanInfo(sName);
                    break;
                }
                case 7: {
                    LocalModel modelLocal = (LocalModel)this.getLocalRegistry().get(sName);
                    RemoteModel modelRemote = modelLocal == null ? this.getRemoteModels().get(sName) : null;
                    oResult = modelLocal == null ? (modelRemote == null ? null : Integer.valueOf(modelRemote.getModelOwner().getId())) : Integer.valueOf(this.getLocalMemberId());
                    break;
                }
                default: {
                    oResult = new IllegalArgumentException("Invalid action: " + taskInvoke.getAction());
                    break;
                }
            }
        }
        catch (Throwable e) {
            fAsync = false;
            oResult = e;
        }
        tlCont.set(null);
        if (!fAsync) {
            cont.proceed(oResult);
        }
    }

    public void onSubscribe(Subscribe taskSubscribe) {
        String sName = taskSubscribe.getName();
        LocalModel model = (LocalModel)this.getLocalRegistry().get(sName);
        if (model == null) {
            if (!Gateway.isResponsibilityMBean(sName)) {
                Connector._trace("Error updating subscription; unable to locate local model: " + sName, 2);
            }
        } else if (taskSubscribe.getAction() == 0) {
            model._addRemoteNotificationListener(taskSubscribe.getHolder(), this);
        } else {
            int nMemberId = taskSubscribe.getMemberId();
            long[] alId = taskSubscribe.getHolderId();
            int c = alId.length;
            for (int i = 0; i < c; ++i) {
                model._removeRemoteNotificationListener(nMemberId, alId[i]);
            }
        }
    }

    public void onUnregister(Unregister taskUnregister) {
        Local localGateway = this.getLocalGateway();
        if (localGateway != null) {
            try {
                String sName = taskUnregister.getName();
                Map mapModels = this.getRemoteModels();
                if (sName.endsWith(",*")) {
                    localGateway.unregisterModelMBean(sName, null);
                    String sPattern = sName.substring(0, sName.length() - 2);
                    Gateway.removeByPattern(mapModels, sPattern);
                } else {
                    RemoteModel model = (RemoteModel)mapModels.get(sName);
                    if (model != null && Base.equals(model.getModelOwner(), this.getMember(taskUnregister.getMemberFrom()))) {
                        localGateway.unregisterModelMBean(sName, model);
                        mapModels.remove(sName);
                    }
                }
            }
            catch (RuntimeException e) {
                Connector._trace("Ignoring UnregisterRequest exception\n" + Connector.getStackTrace(e), 5);
            }
        }
    }

    public void refreshActiveModels(RemoteModel model) {
        long cRefresh = 0L;
        for (RemoteModel modelNext : this.getRemoteModels().values()) {
            if (!modelNext.isRefreshRequired() || !modelNext.isAccessed() || !modelNext.invokeRemoteAsync()) continue;
            ++cRefresh;
        }
        this.setStatsRefreshPredictionCount(this.getStatsRefreshPredictionCount() + cRefresh);
    }

    public void refreshRemoteModels(Set setModels) {
        if (setModels != null) {
            Map mapModels = this.getRemoteModels();
            long cRefresh = 0L;
            for (Object oMBean : setModels) {
                ObjectName oname = oMBean instanceof ObjectInstance ? ((ObjectInstance)oMBean).getObjectName() : (ObjectName)oMBean;
                RemoteModel model = (RemoteModel)mapModels.get(oname.getKeyPropertyListString());
                if (model == null) continue;
                if (!model.isAccessed()) {
                    this.setStatsRefreshExcessCount(this.getStatsRefreshExcessCount() + 1L);
                }
                if (!model.invokeRemoteAsync()) continue;
                ++cRefresh;
            }
            this.setStatsRefreshPredictionCount(this.getStatsRefreshPredictionCount() + cRefresh);
            this.setStatsRefreshCount(this.getStatsRefreshCount() + cRefresh);
        }
    }

    protected void registerAll(Set setMembers) {
        LocalModel[] aModel = this.getLocalRegistry().values().toArray(new LocalModel[0]);
        if (aModel != null && aModel.length > 0) {
            this.sendRegister(setMembers, aModel);
        }
    }

    public void registerMemberListener(MemberListener listener) {
        this.getService().addMemberListener(listener);
    }

    public void registerModel(LocalModel model) {
        Set setServers;
        String sName = model.get_ModelName();
        Connector._assert(!model.is_Snapshot());
        Connector._assert(sName != null);
        LocalModel modelOld = this.getLocalRegistry().put(sName, model);
        if (modelOld != null && sName.indexOf("nodeId=") >= 0) {
            boolean fSkipSend;
            if (model instanceof WrapperJmxModel && modelOld instanceof WrapperJmxModel) {
                fSkipSend = ((WrapperJmxModel)model).getMBeanInfo().getClassName() == ((WrapperJmxModel)modelOld).getMBeanInfo().getClassName();
            } else if (model instanceof WrapperModel && modelOld instanceof WrapperModel) {
                fSkipSend = ((WrapperModel)model).getMBean().getClass() == ((WrapperModel)modelOld).getMBean().getClass();
            } else {
                boolean bl = fSkipSend = model.getClass() == modelOld.getClass();
            }
            if (fSkipSend) {
                return;
            }
        }
        if (this.getService() != null && this.isAnnounced() && Gateway.isGlobal(sName) && !(setServers = this.getRemoteServers()).isEmpty()) {
            this.sendRegister(setServers, new LocalModel[]{model});
        }
    }

    protected void removeLocalSubscriptions() {
        Iterator iter = this.getLocalRegistry().values().iterator();
        while (iter.hasNext()) {
            ((LocalModel)iter.next())._removeNotificationListeners();
        }
    }

    protected void removeRemoteSubscriptions(com.tangosol.net.Member member) {
        for (LocalModel model : this.getLocalRegistry().values()) {
            RemoteHandler handler = model.get_RemoteNotificationHandler();
            if (handler == null) continue;
            handler.unsubscribeMember(member.getId());
        }
    }

    public String reportSubscriptions() {
        StringBuilder sb = new StringBuilder("LocalModels=\n");
        for (LocalModel local : this.getLocalRegistry().values()) {
            sb.append("Name=").append(local.get_ModelName()).append(",LocalHandler=").append(local.get_LocalNotificationHandler()).append(",RemoteHandler=").append(local.get_RemoteNotificationHandler()).append('\n');
        }
        sb.append("RemoteModels=\n");
        for (RemoteModel remote : this.getRemoteModels().values()) {
            sb.append("Name=").append(remote.get_ModelName()).append(",LocalHandler=").append(remote.get_LocalNotificationHandler()).append('\n');
        }
        return sb.toString();
    }

    public void resetStatistics() {
        this.setStatsRefreshCount(0L);
        this.setStatsRefreshPredictionCount(0L);
        this.setStatsRefreshExcessCount(0L);
        this.setStatsRefreshTimeoutCount(0L);
        this.setStatsNotificationCount(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object resolve(NameService.RequestContext ctx) {
        Collection colInet;
        JMXServiceURL url;
        Connector connector = this;
        synchronized (connector) {
            url = this.getJmxServiceUrl();
            colInet = this.getJmxListenAddresses();
        }
        if (url == null) {
            return null;
        }
        String sHost = url.getHost();
        if (InetAddressHelper.isAnyLocalAddress(sHost)) {
            boolean fLocalDest = true;
            Iterator iter = colInet.iterator();
            while (fLocalDest && iter.hasNext()) {
                fLocalDest = InetAddressHelper.isLocalAddress((InetAddress)iter.next());
            }
            Collection<InetAddress> colAddresses = InetAddressHelper.getRoutableAddresses(ctx.getAcceptAddress(), InetAddressHelper.isLocalAddress(ctx.getSourceAddress()), colInet, fLocalDest);
            if (colAddresses == null || colAddresses.isEmpty()) {
                return null;
            }
            InetAddress addr = colAddresses.iterator().next();
            try {
                url = new JMXServiceURL(url.getProtocol(), addr.getHostAddress(), url.getPort(), url.getURLPath());
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return url.toString();
    }

    public void sendNotification(Set setMembers, String sName, Notification notification) {
        InvocationService service = this.getService();
        Notify task = (Notify)this._newChild("Notify");
        task.setName(sName);
        task.setNotification(notification);
        Iterator iter = setMembers.iterator();
        while (iter.hasNext()) {
            service.execute(task, Collections.singleton(iter.next()), null);
        }
    }

    public Object sendProxyRequest(InvokeRemote task) {
        com.tangosol.net.Member member;
        Map mapResult;
        Object oResult;
        do {
            member = this.chooseRemoteServer(task.getAction());
            mapResult = this.getService().query(task, Collections.singleton(member));
            oResult = mapResult.get(member);
            if (!(oResult instanceof Throwable)) continue;
            throw Base.ensureRuntimeException((Throwable)oResult);
        } while (oResult == null && !mapResult.containsKey(member));
        return oResult;
    }

    protected void sendRegister(Set setMembers, LocalModel[] aModel) {
        InvocationService service = this.getService();
        Register task = (Register)this._newChild("Register");
        task.setMemberFrom(this.getLocalMemberId());
        task.setSnapshot(aModel);
        try {
            Iterator iter = setMembers.iterator();
            while (iter.hasNext()) {
                service.execute(task, Collections.singleton(iter.next()), null);
            }
        }
        catch (Exception e) {
            Connector._trace("Failed to register " + aModel.length + " MBeans " + Connector.getStackTrace(e), 1);
        }
    }

    protected void setAnnounced(boolean f) {
        this.__m_Announced = f;
    }

    protected void setConnectorServer(JMXConnectorServer server) {
        this.__m_ConnectorServer = server;
    }

    public void setDependencies(ConnectorDependencies deps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Dependencies already set");
        }
        this.__m_Dependencies = this.cloneDependencies(deps).validate();
        this.onDependencies(this.getDependencies());
    }

    public void setHttpManagingDynamic(boolean fDynamic) {
        this.__m_HttpManagingDynamic = fDynamic;
    }

    public void setHttpManagingNode(boolean fNode) {
        this.__m_HttpManagingNode = fNode;
    }

    public void setJmxListenAddresses(Collection sUrl) {
        this.__m_JmxListenAddresses = sUrl;
    }

    public void setJmxServiceUrl(JMXServiceURL lUrl) {
        this.__m_JmxServiceUrl = lUrl;
    }

    public void setLocalGateway(Local gateway) {
        this.__m_LocalGateway = gateway;
    }

    protected void setLocalRegistry(Map map) {
        this.__m_LocalRegistry = map;
    }

    public void setManagingDynamic(boolean fDynamic) {
        this.__m_ManagingDynamic = fDynamic;
    }

    public void setManagingNode(boolean fManaging) {
        this.__m_ManagingNode = fManaging;
    }

    private static void setMsgFailure(String sMsg) {
        __s_MsgFailure = sMsg;
    }

    protected void setRefreshAttributeTimeoutMillis(long cMillis) {
        this.__m_RefreshAttributeTimeoutMillis = cMillis;
    }

    public void setRefreshPolicy(String sRefreshPolicy) {
        this.getDependencies().setRefreshPolicy(sRefreshPolicy);
    }

    public void setRefreshTimeoutMillis(long lRefreshTimeoutMillis) {
        this.getDependencies().setRefreshTimeoutMillis(lRefreshTimeoutMillis);
    }

    protected void setRemoteModels(Map mapModels) {
        this.__m_RemoteModels = mapModels;
    }

    protected void setRemoteServers(Set setMember) {
        this.__m_RemoteServers = setMember;
    }

    public void setRequestTimeout(long lTimeout) {
        this.__m_RequestTimeout = lTimeout;
    }

    protected void setService(InvocationService service) {
        this.__m_Service = service;
    }

    protected void setStatsNotificationCount(long cNotifications) {
        this.__m_StatsNotificationCount = cNotifications;
    }

    protected void setStatsRefreshCount(long cSync) {
        this.__m_StatsRefreshCount = cSync;
    }

    protected void setStatsRefreshExcessCount(long cMiss) {
        this.__m_StatsRefreshExcessCount = cMiss;
    }

    protected void setStatsRefreshPredictionCount(long cRefresh) {
        this.__m_StatsRefreshPredictionCount = cRefresh;
    }

    public void setStatsRefreshTimeoutCount(long cCount) {
        this.__m_StatsRefreshTimeoutCount = cCount;
    }

    protected void setThreadLocalContinuation(ThreadLocal cont) {
        this.__m_ThreadLocalContinuation = cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService(SafeCluster cluster) {
        Connector connector = this;
        synchronized (connector) {
            if (this.isStarted() || Connector.getMsgFailure() != null) {
                return;
            }
            if (cluster == null && (cluster = this.getCluster()) == null) {
                return;
            }
        }
        cluster.ensureLocked();
        try {
            connector = this;
            synchronized (connector) {
                block28: {
                    block27: {
                        if (!this.isStarted() && Connector.getMsgFailure() == null) break block27;
                        return;
                    }
                    try {
                        SafeService serviceSafe;
                        InvocationService service = (InvocationService)cluster.ensureService("Management", "Invocation");
                        this.setService(service);
                        service.setContextClassLoader(this.getClass().getClassLoader());
                        service.setUserContext(this);
                        URL url = Resources.findFileOrResourceOrDefault("management-config.xml", null);
                        if (url != null) {
                            try {
                                XmlDocument xml = XmlHelper.loadXml(url.openStream());
                                if (xml != null) {
                                    Connector._trace("Loaded management configuration from \"" + String.valueOf(url) + "\"", 3);
                                    service.configure(xml);
                                }
                            }
                            catch (Exception e) {
                                throw Base.ensureRuntimeException(e);
                            }
                        }
                        if ((serviceSafe = (SafeService)((Object)service)).isRestarting()) {
                            Connector._trace("Resetting the JMX Connector; State=" + serviceSafe.getSafeServiceState(), 3);
                            break block28;
                        }
                        service.start();
                        service.addMemberListener(this);
                        Grid _service = (Grid)serviceSafe.getService();
                        _service.getThisMemberConfigMap().put("dynamic-management", this.isManagingDynamic());
                        this.setRequestTimeout(_service.getRequestTimeout());
                        if (!this.isManagingNode() && this.getDynamicSenior() == service.getCluster().getLocalMember()) {
                            this.assumeManagement();
                            if (this.isHttpManagingDynamic()) {
                                HttpHelper.startService(cluster);
                            }
                        }
                        if (this.isHttpManagingNode()) {
                            HttpHelper.startService(cluster);
                        }
                        try {
                            this.getNameService().bind("management/JMXServiceURL", this);
                        }
                        catch (NameAlreadyBoundException nameAlreadyBoundException) {
                        }
                        catch (NamingException e) {
                            throw Base.ensureRuntimeException(e);
                        }
                        this.announce(service);
                    }
                    catch (Exception e) {
                        int of;
                        String sMsg = e.toString();
                        if (e instanceof SecurityException && (of = sMsg.indexOf(10)) > 0) {
                            sMsg = sMsg.substring(0, of);
                        }
                        Connector.setMsgFailure(sMsg);
                        Connector._trace("Failure to initialize JMX remote management caused by: " + sMsg + ". It will not be possible to manage this node remotely.", 1);
                    }
                }
            }
        }
        finally {
            cluster.unlock();
        }
    }

    public void subscribe(String sName, com.tangosol.net.Member member, RemoteHolder holder) {
        holder.setMemberId(this.getLocalMemberId());
        Subscribe task = new Subscribe();
        task.setAction(0);
        task.setName(sName);
        task.setHolder(holder);
        this.getService().execute(task, Collections.singleton(member), null);
    }

    public void unregisterModel(String sGivenName) {
        Set setServers;
        Map mapRegistry = this.getLocalRegistry();
        if (sGivenName.endsWith(",*")) {
            String sName = MBeanHelper.stripDomain(sGivenName);
            String sPattern = sName.substring(0, sName.length() - 2);
            Gateway.removeByPattern(mapRegistry, sPattern);
        } else {
            mapRegistry.remove(sGivenName);
        }
        InvocationService service = this.getService();
        if (service != null && service.isRunning() && this.isAnnounced() && Gateway.isGlobal(sGivenName) && !(setServers = this.getRemoteServers()).isEmpty()) {
            Unregister task = (Unregister)this._newChild("Unregister");
            task.setMemberFrom(this.getLocalMemberId());
            task.setName(sGivenName);
            service.execute(task, setServers, null);
        }
    }

    public void unsubscribe(String sName, com.tangosol.net.Member member, Set setHolders) {
        long[] alId = new long[setHolders.size()];
        int ix = 0;
        for (LocalHolder holder : setHolders) {
            RemoteHolder hRemote = holder.getRemoteHolder();
            if (hRemote == null) continue;
            alId[ix++] = hRemote.getHolderId();
        }
        Subscribe task = new Subscribe();
        task.setAction(1);
        task.setName(sName);
        task.setMemberId(this.getLocalMemberId());
        task.setHolderId(alId);
        this.getService().execute(task, Collections.singleton(member), null);
    }

    static {
        Connector.__initStatic();
    }

    public static class Announce
    extends Net
    implements ExternalizableLite,
    Invocable,
    InvocationObserver {
        private boolean __m_ManagingNode;
        private int __m_MemberFrom;
        private transient Object __m_Result;
        private transient InvocationService __m_Service;

        public Announce() {
            this(null, null, true);
        }

        public Announce(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Announce();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/management/Connector$Announce".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int getMemberFrom() {
            return this.__m_MemberFrom;
        }

        @Override
        public Object getResult() {
            return this.__m_Result;
        }

        public InvocationService getService() {
            return this.__m_Service;
        }

        @Override
        public void init(InvocationService service) {
            this.setService(service);
        }

        @Override
        public void invocationCompleted() {
            ((Connector)this.get_Module()).onAnnouncementCompleted();
        }

        public boolean isManagingNode() {
            return this.__m_ManagingNode;
        }

        @Override
        public void memberCompleted(com.tangosol.net.Member member, Object oResult) {
            Boolean FServer = (Boolean)oResult;
            if (FServer != null && FServer.booleanValue()) {
                ((Connector)this.get_Module()).getRemoteServers().add(member);
            }
        }

        @Override
        public void memberFailed(com.tangosol.net.Member member, Throwable e) {
            Announce._trace("Failed announcement request at " + String.valueOf(member) + "\n" + Announce.getStackTrace(e), 1);
        }

        @Override
        public void memberLeft(com.tangosol.net.Member member) {
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.setMemberFrom(ExternalizableHelper.readInt(in));
            this.setManagingNode(in.readBoolean());
        }

        @Override
        public void run() {
            Connector conn = (Connector)this.getService().getUserContext();
            conn.onAnnouncement(this);
        }

        public void setManagingNode(boolean f) {
            this.__m_ManagingNode = f;
        }

        public void setMemberFrom(int nMember) {
            this.__m_MemberFrom = nMember;
        }

        public void setResult(Object oResult) {
            this.__m_Result = oResult;
        }

        protected void setService(InvocationService service) {
            this.__m_Service = service;
        }

        @Override
        public String toString() {
            return this.get_Name() + " from Member " + this.getMemberFrom();
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeInt(out, this.getMemberFrom());
            out.writeBoolean(this.isManagingNode());
        }
    }

    public static class ExecuteFunction
    extends Util
    implements Continuation,
    Runnable {
        private Continuation __m_Continuation;
        private InvokeRemote __m_Invocable;

        public ExecuteFunction() {
            this(null, null, true);
        }

        public ExecuteFunction(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new ExecuteFunction();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/management/Connector$ExecuteFunction".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public Continuation getContinuation() {
            return this.__m_Continuation;
        }

        public InvokeRemote getInvocable() {
            return this.__m_Invocable;
        }

        public void proceed(Object oResult) {
            InvokeRemote invocable = this.getInvocable();
            Continuation cont = this.getContinuation();
            if (oResult instanceof Throwable && cont == null) {
                ExecuteFunction._trace("Unable to execute MBeanServerProxy.execute or throw exception to client due to: \n" + Base.getStackTrace((Throwable)oResult) + "\n" + String.valueOf(invocable), 5);
            }
            if (cont != null) {
                cont.proceed(oResult);
            }
        }

        @Override
        public void run() {
            ((Connector)this.get_Module()).getLocalGateway().executeInternal(this.getInvocable().getFunction(), this);
        }

        public void setContinuation(Continuation function) {
            this.__m_Continuation = function;
        }

        public void setInvocable(InvokeRemote remoteInvocable) {
            this.__m_Invocable = remoteInvocable;
        }
    }

    public static class InvokeRemote
    extends Net
    implements ExternalizableLite,
    NonBlockingInvocable {
        private int __m_Action;
        public static final int ACTION_CHECK = 3;
        public static final int ACTION_EXECUTE = 5;
        public static final int ACTION_FIND_OWNER = 7;
        public static final int ACTION_GET = 0;
        public static final int ACTION_INVOKE = 1;
        public static final int ACTION_MBEAN_INFO = 6;
        public static final int ACTION_QUERY = 4;
        public static final int ACTION_SET = 2;
        private String __m_AttributeName;
        private Object __m_AttributeValue;
        private transient Remote.Function __m_Function;
        private String __m_MethodName;
        private String __m_Name;
        private Object[] __m_Parameters;
        private Filter __m_QueryFilter;
        private String __m_QueryPattern;
        private Exception __m_ReadException;
        private Object __m_Result;
        private transient InvocationService __m_Service;
        private String[] __m_Signatures;

        public InvokeRemote() {
            this(null, null, true);
        }

        public InvokeRemote(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new InvokeRemote();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/management/Connector$InvokeRemote".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int getAction() {
            return this.__m_Action;
        }

        public String getAttributeName() {
            return this.__m_AttributeName;
        }

        public Object getAttributeValue() {
            return this.__m_AttributeValue;
        }

        public Remote.Function getFunction() {
            return this.__m_Function;
        }

        public String getMethodName() {
            return this.__m_MethodName;
        }

        public String getName() {
            return this.__m_Name;
        }

        public Object[] getParameters() {
            return this.__m_Parameters;
        }

        public Filter getQueryFilter() {
            return this.__m_QueryFilter;
        }

        public String getQueryPattern() {
            return this.__m_QueryPattern;
        }

        public Exception getReadException() {
            return this.__m_ReadException;
        }

        @Override
        public Object getResult() {
            return this.__m_Result;
        }

        public InvocationService getService() {
            return this.__m_Service;
        }

        public String[] getSignatures() {
            return this.__m_Signatures;
        }

        @Override
        public void init(InvocationService service) {
            this.setService(service);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            int nAction = ExternalizableHelper.readInt(in);
            this.setAction(nAction);
            this.setName(ExternalizableHelper.readSafeUTF(in));
            switch (nAction) {
                case 0: {
                    this.setAttributeName(ExternalizableHelper.readSafeUTF(in));
                    try {
                        if (!ExternalizableHelper.isVersionCompatible(in, 12, 2, 1, 4, 0)) break;
                        this.setQueryFilter((Filter)ExternalizableHelper.readObject(in));
                    }
                    catch (Throwable t) {
                        this.setReadException(Base.ensureRuntimeException(t));
                    }
                    break;
                }
                case 2: {
                    this.setAttributeName(ExternalizableHelper.readSafeUTF(in));
                    this.setAttributeValue(ExternalizableHelper.readObject(in));
                    break;
                }
                case 4: {
                    this.setQueryPattern(ExternalizableHelper.readSafeUTF(in));
                    try {
                        this.setQueryFilter((Filter)ExternalizableHelper.readObject(in));
                    }
                    catch (Throwable t) {
                        this.setReadException(Base.ensureRuntimeException(t));
                    }
                    break;
                }
                case 1: {
                    this.setMethodName(ExternalizableHelper.readSafeUTF(in));
                    int c = ExternalizableHelper.readInt(in);
                    if (c > 0) {
                        Object[] aoParam = new Object[c];
                        try {
                            for (int i = 0; i < c; ++i) {
                                aoParam[i] = ExternalizableHelper.readObject(in);
                            }
                        }
                        catch (Throwable t) {
                            this.setReadException(Base.ensureRuntimeException(t));
                        }
                        this.setParameters(aoParam);
                    }
                    if (!in.readBoolean()) break;
                    this.setSignatures(ExternalizableHelper.readStringArray(in));
                    break;
                }
                case 5: {
                    try {
                        this.setFunction((Remote.Function)ExternalizableHelper.readObject(in));
                        break;
                    }
                    catch (Throwable t) {
                        this.setReadException(Base.ensureRuntimeException(t));
                    }
                }
            }
        }

        @Override
        public void run() {
            throw new IllegalStateException();
        }

        @Override
        public void run(Continuation cont) {
            Connector conn = (Connector)this.getService().getUserContext();
            conn.onRemoteInvoke(this, cont);
        }

        public void setAction(int nAction) {
            this.__m_Action = nAction;
        }

        public void setAttributeName(String sName) {
            this.__m_AttributeName = sName;
        }

        public void setAttributeValue(Object oValue) {
            this.__m_AttributeValue = oValue;
        }

        public void setFunction(Remote.Function oResult) {
            this.__m_Function = oResult;
        }

        public void setMethodName(String sName) {
            this.__m_MethodName = sName;
        }

        public void setName(String f) {
            this.__m_Name = f;
        }

        public void setParameters(Object[] aoParameters) {
            this.__m_Parameters = aoParameters;
        }

        public void setQueryFilter(Filter filterQuery) {
            this.__m_QueryFilter = filterQuery;
        }

        public void setQueryPattern(String sPattern) {
            this.__m_QueryPattern = sPattern;
        }

        public void setReadException(Exception e) {
            this.__m_ReadException = e;
        }

        public void setResult(Object oResult) {
            this.__m_Result = oResult;
        }

        protected void setService(InvocationService service) {
            this.__m_Service = service;
        }

        public void setSignatures(String[] asSignatures) {
            this.__m_Signatures = asSignatures;
        }

        @Override
        public String toString() {
            String s = "InvokeRemote(action=";
            switch (this.getAction()) {
                case 0: {
                    return s + "GET, name=" + this.getName() + ", attributeName=" + this.getAttributeName() + ")";
                }
                case 1: {
                    return s + "INVOKE, name=" + this.getName() + ", methodName=" + this.getMethodName() + ", paramNames=" + Arrays.deepToString(this.getParameters()) + ", sigantures=" + Arrays.deepToString(this.getSignatures()) + ")";
                }
                case 2: {
                    return s + "SET, name=" + this.getName() + ", attributeName=" + this.getAttributeName() + ", attributeValue=" + String.valueOf(this.getAttributeValue()) + ")";
                }
                case 3: {
                    return s + "CHECK, name=" + this.getName() + ")";
                }
                case 4: {
                    return s + "QUERY, queryPattern=" + this.getQueryPattern() + ", queryFilter=" + String.valueOf(this.getQueryFilter()) + ")";
                }
                case 5: {
                    return s + "EXECUTE, function=" + String.valueOf(this.getFunction()) + ")";
                }
            }
            return "UNKNOWN)";
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            int nAction = this.getAction();
            ExternalizableHelper.writeInt(out, nAction);
            ExternalizableHelper.writeSafeUTF(out, this.getName());
            switch (nAction) {
                case 0: {
                    ExternalizableHelper.writeSafeUTF(out, this.getAttributeName());
                    Filter filter = this.getQueryFilter();
                    if (filter != null && !ExternalizableHelper.isVersionCompatible(out, 12, 2, 1, 4, 0)) {
                        throw new UnsupportedOperationException("MBeanServerProxy.getAttributes(String, Filter) not supported by management node");
                    }
                    try {
                        ExternalizableHelper.writeObject(out, this.getQueryFilter());
                        break;
                    }
                    catch (IOException e) {
                        InvokeRemote._trace("Query Filter is not serializable: " + String.valueOf(this.getQueryFilter()), 1);
                        throw e;
                    }
                }
                case 2: {
                    ExternalizableHelper.writeSafeUTF(out, this.getAttributeName());
                    ExternalizableHelper.writeObject(out, this.getAttributeValue());
                    break;
                }
                case 4: {
                    ExternalizableHelper.writeSafeUTF(out, this.getQueryPattern());
                    try {
                        ExternalizableHelper.writeObject(out, this.getQueryFilter());
                        break;
                    }
                    catch (IOException e) {
                        InvokeRemote._trace("Query Filter is not serializable: " + String.valueOf(this.getQueryFilter()), 1);
                        throw e;
                    }
                }
                case 1: {
                    ExternalizableHelper.writeSafeUTF(out, this.getMethodName());
                    Object[] aoParam = this.getParameters();
                    if (aoParam == null) {
                        ExternalizableHelper.writeInt(out, 0);
                    } else {
                        int c = aoParam.length;
                        ExternalizableHelper.writeInt(out, c);
                        for (int i = 0; i < c; ++i) {
                            try {
                                ExternalizableHelper.writeObject(out, aoParam[i]);
                                continue;
                            }
                            catch (IOException e) {
                                InvokeRemote._trace("The invoke parameter [" + i + "] for \"" + this.getMethodName() + "\" is not serializable; ", 1);
                                throw e;
                            }
                        }
                    }
                    String[] asSig = this.getSignatures();
                    if (asSig == null) {
                        out.writeBoolean(false);
                        break;
                    }
                    out.writeBoolean(true);
                    ExternalizableHelper.writeStringArray(out, asSig);
                    break;
                }
                case 5: {
                    if (!ExternalizableHelper.isVersionCompatible(out, 12, 2, 1, 4, 0)) {
                        throw new UnsupportedOperationException("MBeanServerProxy.execute(Remote.Function) not supported by management node");
                    }
                    ExternalizableHelper.writeObject(out, this.getFunction());
                    break;
                }
                case 6: {
                    if (ExternalizableHelper.isVersionCompatible(out, 12, 2, 1, 4, 0)) break;
                    throw new UnsupportedOperationException("MBeanServerProxy.getMBeanInfo(String name) not supported by management node");
                }
            }
        }
    }

    public static class LookupCallback
    extends Net
    implements NameService.LookupCallback {
        public LookupCallback() {
            this(null, null, true);
        }

        public LookupCallback(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new LookupCallback();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/management/Connector$LookupCallback".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        @Override
        public Object lookup(String sName, com.tangosol.net.Cluster cluster, NameService.RequestContext ctx) throws NamingException {
            if (sName.startsWith("management/HTTPManagementURL")) {
                try {
                    Set setAddresses = (Set)((Cluster)cluster).getNameService().lookup(HttpHelper.getServiceName() + "/addresses", ctx);
                    if (setAddresses == null || setAddresses.isEmpty()) {
                        return null;
                    }
                    ArrayList<URL> colUrls = new ArrayList<URL>();
                    Iterator iter = setAddresses.iterator();
                    while (iter.hasNext()) {
                        String[] asSockAddr = ((String)iter.next()).split(":");
                        if (asSockAddr.length > 2) {
                            colUrls.add(HttpHelper.composeURL(asSockAddr[0], Integer.parseInt(asSockAddr[1]), asSockAddr[2]));
                            continue;
                        }
                        colUrls.add(HttpHelper.composeURL(asSockAddr[0], Integer.parseInt(asSockAddr[1])));
                    }
                    return colUrls;
                }
                catch (Exception e) {
                    LookupCallback._trace("Failed to obtain HTTP Management service listen address:\n" + Base.printStackTrace(e), 1);
                }
            } else if (sName.startsWith("metrics/HTTPMetricsURL")) {
                try {
                    Set setAddresses = (Set)((Cluster)cluster).getNameService().lookup(MetricsHttpHelper.getServiceName() + "/addresses", ctx);
                    if (setAddresses == null || setAddresses.isEmpty()) {
                        return null;
                    }
                    ArrayList<URL> colUrls = new ArrayList<URL>();
                    Iterator iter = setAddresses.iterator();
                    while (iter.hasNext()) {
                        String[] asSockAddr = ((String)iter.next()).split(":");
                        if (asSockAddr.length > 2) {
                            colUrls.add(MetricsHttpHelper.composeURL(asSockAddr[0], Integer.parseInt(asSockAddr[1]), asSockAddr[2]));
                            continue;
                        }
                        colUrls.add(MetricsHttpHelper.composeURL(asSockAddr[0], Integer.parseInt(asSockAddr[1])));
                    }
                    return colUrls;
                }
                catch (Exception e) {
                    LookupCallback._trace("Failed to obtain " + MetricsHttpHelper.getServiceName() + " service listen address:\n" + Base.printStackTrace(e), 1);
                }
            } else if (sName.startsWith("health/HTTPHealthURL")) {
                try {
                    Set setAddresses = (Set)((Cluster)cluster).getNameService().lookup(HealthHttpHandler.getServiceName() + "/addresses", ctx);
                    if (setAddresses == null || setAddresses.isEmpty()) {
                        return null;
                    }
                    ArrayList<URL> colUrls = new ArrayList<URL>();
                    Iterator iter = setAddresses.iterator();
                    while (iter.hasNext()) {
                        String[] asSockAddr = ((String)iter.next()).split(":");
                        if (asSockAddr.length > 2) {
                            colUrls.add(new URL(asSockAddr[2], asSockAddr[0], Integer.parseInt(asSockAddr[1]), "/"));
                            continue;
                        }
                        colUrls.add(new URL("http", asSockAddr[0], Integer.parseInt(asSockAddr[1]), "/"));
                    }
                    return colUrls;
                }
                catch (Exception e) {
                    LookupCallback._trace("Failed to obtain " + HealthHttpHandler.getServiceName() + " service listen address:\n" + Base.printStackTrace(e), 1);
                }
            }
            return null;
        }
    }

    public static class Notify
    extends Net
    implements ExternalizableLite,
    Invocable {
        private String __m_Name;
        private Notification __m_Notification;
        private InvocationService __m_Service;

        public Notify() {
            this(null, null, true);
        }

        public Notify(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Notify();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/management/Connector$Notify".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public String getName() {
            return this.__m_Name;
        }

        public Notification getNotification() {
            return this.__m_Notification;
        }

        @Override
        public Object getResult() {
            return null;
        }

        public InvocationService getService() {
            return this.__m_Service;
        }

        @Override
        public void init(InvocationService service) {
            this.setService(service);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            block2: {
                this.setName(ExternalizableHelper.readUTF(in));
                try {
                    this.setNotification((Notification)ExternalizableHelper.readObject(in));
                }
                catch (Throwable e) {
                    if (e instanceof EOFException) break block2;
                    Notify._trace("The Notification is not deserializable; " + String.valueOf(e), 3);
                }
            }
        }

        @Override
        public void run() {
            Connector conn = (Connector)this.getService().getUserContext();
            conn.onNotify(this);
        }

        public void setName(String sName) {
            this.__m_Name = sName;
        }

        public void setNotification(Notification notification) {
            this.__m_Notification = notification;
        }

        protected void setService(InvocationService service) {
            this.__m_Service = service;
        }

        @Override
        public String toString() {
            return "Notification for " + this.getName();
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeUTF(out, this.getName());
            try {
                ExternalizableHelper.writeObject(out, this.getNotification());
            }
            catch (Throwable e) {
                Notify._trace("The Notification \"" + this.getNotification().getClass().getName() + "\" is not serializable; " + String.valueOf(e), 3);
            }
        }
    }

    public static class Publish
    extends Net
    implements ExternalizableLite,
    Invocable {
        private JMXServiceURL __m_JMXServiceURL;
        private Collection __m_ListenAddresses;
        private transient InvocationService __m_Service;

        public Publish() {
            this(null, null, true);
        }

        public Publish(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Publish();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/management/Connector$Publish".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public JMXServiceURL getJMXServiceURL() {
            return this.__m_JMXServiceURL;
        }

        public Collection getListenAddresses() {
            return this.__m_ListenAddresses;
        }

        @Override
        public Object getResult() {
            return null;
        }

        public InvocationService getService() {
            return this.__m_Service;
        }

        @Override
        public void init(InvocationService service) {
            this.setService(service);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.setJMXServiceURL((JMXServiceURL)ExternalizableHelper.readObject(in));
            HashSet setInet = new HashSet();
            ExternalizableHelper.readCollection(in, setInet, null);
            this.setListenAddresses(setInet);
        }

        @Override
        public void run() {
            Connector conn = (Connector)this.getService().getUserContext();
            conn.onPublish(this);
        }

        public void setJMXServiceURL(JMXServiceURL url) {
            this.__m_JMXServiceURL = url;
        }

        public void setListenAddresses(Collection colAddresses) {
            this.__m_ListenAddresses = colAddresses;
        }

        protected void setService(InvocationService service) {
            this.__m_Service = service;
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.getJMXServiceURL());
            ExternalizableHelper.writeCollection(out, this.getListenAddresses());
        }
    }

    public static class Register
    extends Net
    implements ExternalizableLite,
    Invocable {
        private transient int __m_MemberFrom;
        private transient Object __m_Result;
        private transient InvocationService __m_Service;
        private LocalModel[] __m_Snapshot;

        public Register() {
            this(null, null, true);
        }

        public Register(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Register();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/management/Connector$Register".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int getMemberFrom() {
            return this.__m_MemberFrom;
        }

        @Override
        public Object getResult() {
            return this.__m_Result;
        }

        public InvocationService getService() {
            return this.__m_Service;
        }

        public LocalModel[] getSnapshot() {
            return this.__m_Snapshot;
        }

        @Override
        public void init(InvocationService service) {
            this.setService(service);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.setMemberFrom(ExternalizableHelper.readInt(in));
            this.setSnapshot(this.readLocalModelArray(in));
        }

        private LocalModel[] readLargeLocalModelArray(DataInput in, int cLength) throws IOException {
            int cBatchMax = 0x3FFFFF;
            int cBatch = cLength / cBatchMax + 1;
            LocalModel[] aMerged = null;
            int cRead = 0;
            int cAllocate = cBatchMax;
            for (int i = 0; i < cBatch && cRead < cLength; ++i) {
                LocalModel[] ao = this.readLocalModelArray(in, cAllocate);
                aMerged = ExternalizableHelper.mergeArray(aMerged, ao);
                cAllocate = Math.min(cLength - (cRead += ao.length), cBatchMax);
            }
            return aMerged;
        }

        private LocalModel[] readLocalModelArray(DataInput in) throws IOException {
            int c = ExternalizableHelper.readInt(in);
            ExternalizableHelper.validateLoadArray(Object[].class, c, in);
            return c <= 0 ? new LocalModel[]{} : (c < 0x7FFFFF ? this.readLocalModelArray(in, c) : this.readLargeLocalModelArray(in, c));
        }

        private LocalModel[] readLocalModelArray(DataInput in, int cLength) throws IOException {
            LocalModel[] aModel = new LocalModel[cLength];
            ClassLoader loader = this.getClass().getClassLoader();
            for (int i = 0; i < cLength; ++i) {
                aModel[i] = (LocalModel)ExternalizableHelper.readObject(in, loader);
                LocalModel model = aModel[i];
                if (!(model instanceof WrapperModel)) continue;
                MBeanInfo mbeanInfo = (MBeanInfo)ExternalizableHelper.readObject(in, loader);
                ((WrapperModel)model).setMBeanInfo(mbeanInfo);
            }
            return aModel;
        }

        @Override
        public void run() {
            Connector conn = (Connector)this.getService().getUserContext();
            conn.onRegister(this);
        }

        public void setMemberFrom(int nId) {
            this.__m_MemberFrom = nId;
        }

        public void setResult(Object oResult) {
            this.__m_Result = oResult;
        }

        protected void setService(InvocationService service) {
            this.__m_Service = service;
        }

        public void setSnapshot(LocalModel[] aModel) {
            this.__m_Snapshot = aModel;
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeInt(out, this.getMemberFrom());
            LocalModel[] aModel = this.getSnapshot();
            int c = aModel.length;
            ExternalizableHelper.writeInt(out, c);
            for (int i = 0; i < c; ++i) {
                LocalModel model = aModel[i];
                ExternalizableHelper.writeObject(out, model);
                if (!(model instanceof WrapperModel)) continue;
                ExternalizableHelper.writeObject(out, ((WrapperModel)model).getMBeanInfo());
            }
        }
    }

    public static class Subscribe
    extends Net
    implements ExternalizableLite,
    Invocable {
        private transient int __m_Action;
        public static final int ACTION_SUBSCRIBE = 0;
        public static final int ACTION_UNSUBSCRIBE = 1;
        private transient RemoteHolder __m_Holder;
        private long[] __m_HolderId;
        private int __m_MemberId;
        private String __m_Name;
        private InvocationService __m_Service;

        public Subscribe() {
            this(null, null, true);
        }

        public Subscribe(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Subscribe();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/management/Connector$Subscribe".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int getAction() {
            return this.__m_Action;
        }

        public RemoteHolder getHolder() {
            return this.__m_Holder;
        }

        public long[] getHolderId() {
            return this.__m_HolderId;
        }

        public int getMemberId() {
            return this.__m_MemberId;
        }

        public String getName() {
            return this.__m_Name;
        }

        @Override
        public Object getResult() {
            return null;
        }

        public InvocationService getService() {
            return this.__m_Service;
        }

        @Override
        public void init(InvocationService service) {
            this.setService(service);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            int nAction = ExternalizableHelper.readInt(in);
            this.setAction(nAction);
            this.setName(ExternalizableHelper.readUTF(in));
            if (nAction == 0) {
                RemoteHolder holder = new RemoteHolder();
                holder.readExternal(in);
                this.setHolder(holder);
            } else {
                this.setMemberId(ExternalizableHelper.readInt(in));
                this.setHolderId(Subscribe.readLongArray(in));
            }
        }

        private static long[] readLargeLongArray(DataInput in, int cLength) throws IOException {
            int cBatchMax = 0x7FFFFF;
            int cBatch = cLength / cBatchMax + 1;
            long[] aMerged = null;
            int cRead = 0;
            int cAllocate = cBatchMax;
            for (int i = 0; i < cBatch && cRead < cLength; ++i) {
                long[] al = Subscribe.readLongArray(in, cAllocate);
                aMerged = ExternalizableHelper.mergeLongArray(aMerged, al);
                cAllocate = Math.min(cLength - (cRead += al.length), cBatchMax);
            }
            return aMerged;
        }

        private static long[] readLongArray(DataInput in) throws IOException {
            int c = ExternalizableHelper.readInt(in);
            ExternalizableHelper.validateLoadArray(long[].class, c, in);
            return c <= 0 ? new long[]{} : (c < 0xFFFFFF ? Subscribe.readLongArray(in, c) : Subscribe.readLargeLongArray(in, c));
        }

        private static long[] readLongArray(DataInput in, int cLength) throws IOException {
            long[] al = new long[cLength];
            for (int i = 0; i < cLength; ++i) {
                al[i] = ExternalizableHelper.readLong(in);
            }
            return al;
        }

        @Override
        public void run() {
            Connector conn = (Connector)this.getService().getUserContext();
            conn.onSubscribe(this);
        }

        public void setAction(int nAction) {
            this.__m_Action = nAction;
        }

        public void setHolder(RemoteHolder holder) {
            this.__m_Holder = holder;
        }

        public void setHolderId(long[] aId) {
            this.__m_HolderId = aId;
        }

        public void setMemberId(int nId) {
            this.__m_MemberId = nId;
        }

        public void setName(String sName) {
            this.__m_Name = sName;
        }

        protected void setService(InvocationService service) {
            this.__m_Service = service;
        }

        @Override
        public String toString() {
            int nAction = this.getAction();
            return (nAction == 0 ? "Subscribe" : "Unsubcribe") + " to " + this.getName();
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            int nAction = this.getAction();
            ExternalizableHelper.writeInt(out, nAction);
            ExternalizableHelper.writeUTF(out, this.getName());
            if (nAction == 0) {
                this.getHolder().writeExternal(out);
            } else {
                ExternalizableHelper.writeInt(out, this.getMemberId());
                long[] alId = this.getHolderId();
                int c = alId == null ? 0 : alId.length;
                ExternalizableHelper.writeInt(out, c);
                for (int i = 0; i < c; ++i) {
                    ExternalizableHelper.writeLong(out, alId[i]);
                }
            }
        }
    }

    public static class Unregister
    extends Net
    implements ExternalizableLite,
    Invocable {
        private transient int __m_MemberFrom;
        private String __m_Name;
        private transient Object __m_Result;
        private transient InvocationService __m_Service;

        public Unregister() {
            this(null, null, true);
        }

        public Unregister(String sName, Component compParent, boolean fInit) {
            super(sName, compParent, false);
            if (fInit) {
                this.__init();
            }
        }

        @Override
        public void __init() {
            this.__initPrivate();
            this.set_Constructed(true);
        }

        @Override
        protected void __initPrivate() {
            super.__initPrivate();
        }

        public static Component get_Instance() {
            return new Unregister();
        }

        public static Class get_CLASS() {
            Class<?> clz;
            try {
                clz = Class.forName("com.tangosol.coherence/component/net/management/Connector$Unregister".replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            return clz;
        }

        private Component get_Module() {
            return this.get_Parent();
        }

        public int getMemberFrom() {
            return this.__m_MemberFrom;
        }

        public String getName() {
            return this.__m_Name;
        }

        @Override
        public Object getResult() {
            return this.__m_Result;
        }

        public InvocationService getService() {
            return this.__m_Service;
        }

        @Override
        public void init(InvocationService service) {
            this.setService(service);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.setMemberFrom(ExternalizableHelper.readInt(in));
            this.setName(ExternalizableHelper.readSafeUTF(in));
        }

        @Override
        public void run() {
            Connector conn = (Connector)this.getService().getUserContext();
            conn.onUnregister(this);
        }

        public void setMemberFrom(int nId) {
            this.__m_MemberFrom = nId;
        }

        public void setName(String sName) {
            this.__m_Name = sName;
        }

        public void setResult(Object oResult) {
            this.__m_Result = oResult;
        }

        protected void setService(InvocationService service) {
            this.__m_Service = service;
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeInt(out, this.getMemberFrom());
            ExternalizableHelper.writeSafeUTF(out, this.getName());
        }
    }
}

